<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Settings_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }
	
	public function get_expired_products_count($where) 
	{
		$this->db->select("COUNT(1) as total")
		->join('products', 'purchase_items.product_id=products.id');
		$this->db->where($where);
		$this->db->order_by('purchase_items.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('purchase_items')->result();		
    }
	
	public function get_expired_products($where,$offset) 
	{
		$this->db->select("*")
		->join('products', 'purchase_items.product_id=products.id');
		$this->db->where($where);
		$this->db->limit(20, $offset);
		$this->db->order_by('purchase_items.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('purchase_items')->result();		
    }
	
	public function get_bank_accounts_export($where) 
	{
		$this->db->select("id,account_title,account_number,bank_name,branch_address,opening_balance", FALSE);
		$this->db->where($where);
		$this->db->order_by('id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('bank_accounts')->result();		
    }
	
	public function get_bank_accounts($where, $offset = 0) 
	{
		$this->db->select("{$this->db->dbprefix('products')}.id as id, {$this->db->dbprefix('products')}.code as code, {$this->db->dbprefix('products')}.name as name, purchase_items.expiry", FALSE)
		->join('products', 'purchase_items.product_id=products.id');
		$this->db->where($where);
		$this->db->limit(20, $offset);
		$this->db->order_by('purchase_items.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('purchase_items')->result();		
    }

    public function updateLogo($photo)
    {
        $logo = array('logo' => $photo);
        if ($this->db->update('settings', $logo)) {
            return true;
        }
        return false;
    }

    public function updateLoyalitySettings($info)
    {
        if ($this->db->update('loyality_points', $info)) {
            return true;
        }
        return false;
    }

    public function updateLoginLogo($photo)
    {
        $logo = array('logo2' => $photo);
        if ($this->db->update('settings', $logo)) {
            return true;
        }
        return false;
    }

    public function getSettings()
    {
        $q = $this->db->get('settings');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getLoyalityPoints()
    {
        $q = $this->db->get('loyality_points');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getBankAccounts()
    {
        $q = $this->db->get('bank_accounts');
        return $q->result();
    }

    public function getDateFormats()
    {
        $q = $this->db->get('date_format');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function updateSetting($data)
    {
        $this->db->where('setting_id', '1');
        if ($this->db->update('settings', $data)) {
            return true;
        }
        return false;
    }

    public function addTaxRate($data)
    {
        if ($this->db->insert('tax_rates', $data)) {
            return true;
        }
        return false;
    }

    public function updateTaxRate($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('tax_rates', $data)) {
            return true;
        }
        return false;
    }

    public function getAllTaxRates()
    {
        $q = $this->db->get('tax_rates');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getTaxRateByID($id)
    {
        $q = $this->db->get_where('tax_rates', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addWarehouse($data)
    {
        if ($this->db->insert('warehouses', $data)) {
            return true;
        }
        return false;
    }

     public function addStore($data)
    {
        if ($this->db->insert('stores', $data)) {
            return true;
        }
        return false;
    }

    public function updateWarehouse($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('warehouses', $data)) {
            return true;
        }
        return false;
    }

     public function updateStore($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('stores', $data)) {
            return true;
        }
        return false;
    }

    public function getAllWarehouses()
    {
        $q = $this->db->get('warehouses');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getWarehouseByID($id)
    {
        $q = $this->db->get_where('warehouses', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

     public function getStoreByID($id)
    {
        $q = $this->db->get_where('stores', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteTaxRate($id)
    {
        if ($this->db->delete('tax_rates', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function delete_transactions($id)
    {
		if($id > 0)
		{
			if ($this->db->delete('transactions', array('id' => $id))) {
				return true;
			}
		}
		else
		{
			$this->db->where('id != 0');
			if ($this->db->delete('transactions')) {
				return true;
			}
		}
        return FALSE;
    }

    public function deleteInvoiceType($id)
    {
        if ($this->db->delete('invoice_types', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function deleteWarehouse($id)
    {
        if ($this->db->delete('warehouses', array('id' => $id)) && $this->db->delete('warehouses_products', array('warehouse_id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function deleteStore($id)
    {
        if ($this->db->delete('stores', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function addCustomerGroup($data)
    {
        if ($this->db->insert('customer_groups', $data)) {
            return true;
        }
        return false;
    }

    public function updateCustomerGroup($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('customer_groups', $data)) {
            return true;
        }
        return false;
    }

    public function getAllCustomerGroups()
    {
        $q = $this->db->get('customer_groups');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getCustomerGroupByID($id)
    {
        $q = $this->db->get_where('customer_groups', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteCustomerGroup($id)
    {
        if ($this->db->delete('customer_groups', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getGroups()
    {
        $this->db->where('id >', 4);
        $q = $this->db->get('groups');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getGroupByID($id)
    {
        $q = $this->db->get_where('groups', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getGroupPermissions($id)
    {
        $q = $this->db->get_where('permissions', array('group_id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function GroupPermissions($id)
    {
        $q = $this->db->get_where('permissions', array('group_id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->result_array();
        }
        return FALSE;
    }

    public function updatePermissions($id, $data = array())
    {
        if ($this->db->update('permissions', $data, array('group_id' => $id)) && $this->db->update('users', array('show_price' => $data['products-price'], 'show_cost' => $data['products-cost']), array('group_id' => $id))) {
            return true;
        }
        return false;
    }

    public function addGroup($data)
    {
        if ($this->db->insert("groups", $data)) {
            $gid = $this->db->insert_id();
            $this->db->insert('permissions', array('group_id' => $gid));
            return $gid;
        }
        return false;
    }

    public function updateGroup($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update("groups", $data)) {
            return true;
        }
        return false;
    }


    public function getAllCurrencies()
    {
        $q = $this->db->get('currencies');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getCurrencyByID($id)
    {
        $q = $this->db->get_where('currencies', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addCurrency($data)
    {
        if ($this->db->insert("currencies", $data)) {
            return true;
        }
        return false;
    }

    public function updateCurrency($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update("currencies", $data)) {
            return true;
        }
        return false;
    }

    public function deleteCurrency($id)
    {
        if ($this->db->delete("currencies", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getParentCategories()
    {
        $this->db->where('parent_id', NULL)->or_where('parent_id', 0);
        $q = $this->db->get("categories");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getCategoryByID($id)
    {
        $q = $this->db->get_where("categories", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getBankAccountByID($id)
    {
        $q = $this->db->get_where("bank_accounts", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getCategoryByCode($code)
    {
        $q = $this->db->get_where('categories', array('code' => $code), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addCategory($data)
    {
        if ($this->db->insert("categories", $data)) {
            return true;
        }
        return false;
    }

    public function addBankAccount($data)
    {
        if ($this->db->insert("bank_accounts", $data)) {
            return true;
        }
        return false;
    }

    public function addCategories($data)
    {
        if ($this->db->insert_batch('categories', $data)) {
            return true;
        }
        return false;
    }

    public function updateCategory($id, $data = array())
    {
        if ($this->db->update("categories", $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function updateBankAccount($id, $data = array())
    {
        if ($this->db->update("bank_accounts", $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function deleteCategory($id)
    {
        if ($this->db->delete("categories", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function deleteBankAccount($id)
    {
        if ($this->db->delete("bank_accounts", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }


    public function getAllBankAccounts()
    {
        $q = $this->db->get('bank_accounts');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getPaypalSettings()
    {
        $q = $this->db->get('paypal');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function updatePaypal($data)
    {
        $this->db->where('id', '1');
        if ($this->db->update('paypal', $data)) {
            return true;
        }
        return FALSE;
    }

    public function getSkrillSettings()
    {
        $q = $this->db->get('skrill');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function updateSkrill($data)
    {
        $this->db->where('id', '1');
        if ($this->db->update('skrill', $data)) {
            return true;
        }
        return FALSE;
    }

    public function checkGroupUsers($id)
    {
        $q = $this->db->get_where("users", array('group_id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteGroup($id)
    {
        if ($this->db->delete('groups', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function addVariant($data)
    {
        if ($this->db->insert('variants', $data)) {
            return true;
        }
        return false;
    }

    public function updateVariant($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('variants', $data)) {
            return true;
        }
        return false;
    }

    public function getAllVariants()
    {
        $q = $this->db->get('variants');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getVariantByID($id)
    {
        $q = $this->db->get_where('variants', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteVariant($id)
    {
        if ($this->db->delete('variants', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getExpenseCategoryByID($id)
    {
        $q = $this->db->get_where("expense_categories", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getExpenseCategoryByCode($code)
    {
        $q = $this->db->get_where("expense_categories", array('code' => $code), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addExpenseCategory($data)
    {
        if ($this->db->insert("expense_categories", $data)) {
            return true;
        }
        return false;
    }

    public function addExpenseCategories($data)
    {
        if ($this->db->insert_batch("expense_categories", $data)) {
            return true;
        }
        return false;
    }

    public function updateExpenseCategory($id, $data = array())
    {
        if ($this->db->update("expense_categories", $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function hasExpenseCategoryRecord($id)
    {
        $this->db->where('category_id', $id);
        return $this->db->count_all_results('expenses');
    }

    public function deleteExpenseCategory($id)
    {
        if ($this->db->delete("expense_categories", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function addUnit($data)
    {
        if ($this->db->insert("units", $data)) {
            return true;
        }
        return false;
    }

    public function updateUnit($id, $data = array())
    {
        if ($this->db->update("units", $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function getUnitChildren($base_unit)
    {
        $this->db->where('base_unit', $base_unit);
        $q = $this->db->get("units");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function deleteUnit($id)
    {
        if ($this->db->delete("units", array('id' => $id))) {
            $this->db->delete("units", array('base_unit' => $id));
            return true;
        }
        return FALSE;
    }

    public function addPriceGroup($data)
    {
        if ($this->db->insert('price_groups', $data)) {
            return true;
        }
        return false;
    }

    public function updatePriceGroup($id, $data = array())
    {
        $this->db->where('id', $id);
        if ($this->db->update('price_groups', $data)) {
            return true;
        }
        return false;
    }

    public function getAllPriceGroups()
    {
        $q = $this->db->get('price_groups');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getPriceGroupByID($id)
    {
        $q = $this->db->get_where('price_groups', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deletePriceGroup($id)
    {
        if ($this->db->delete('price_groups', array('id' => $id)) && $this->db->delete('product_prices', array('price_group_id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function setProductPriceForPriceGroup($product_id, $group_id, $price)
    {
        if ($this->getGroupPrice($group_id, $product_id)) {
            if ($this->db->update('product_prices', array('price' => $price), array('price_group_id' => $group_id, 'product_id' => $product_id))) {
                return true;
            }
        } else {
            if ($this->db->insert('product_prices', array('price' => $price, 'price_group_id' => $group_id, 'product_id' => $product_id))) {
                return true;
            }
        }
        return FALSE;
    }

    public function getGroupPrice($group_id, $product_id)
    {
        $q = $this->db->get_where('product_prices', array('price_group_id' => $group_id, 'product_id' => $product_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getProductGroupPriceByPID($product_id, $group_id)
    {
        $pg = "(SELECT {$this->db->dbprefix('product_prices')}.price as price, {$this->db->dbprefix('product_prices')}.product_id as product_id FROM {$this->db->dbprefix('product_prices')} WHERE {$this->db->dbprefix('product_prices')}.product_id = {$product_id} AND {$this->db->dbprefix('product_prices')}.price_group_id = {$group_id}) GP";

        $this->db->select("{$this->db->dbprefix('products')}.id as id, {$this->db->dbprefix('products')}.code as code, {$this->db->dbprefix('products')}.name as name, GP.price", FALSE)
        // ->join('products', 'products.id=product_prices.product_id', 'left')
        ->join($pg, 'GP.product_id=products.id', 'left');
        $q = $this->db->get_where('products', array('products.id' => $product_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function updateGroupPrices($data = array())
    {
        foreach ($data as $row) {
            if ($this->getGroupPrice($row['price_group_id'], $row['product_id'])) {
                $this->db->update('product_prices', array('price' => $row['price']), array('product_id' => $row['product_id'], 'price_group_id' => $row['price_group_id']));
            } else {
                $this->db->insert('product_prices', $row);
            }
        }
        return true;
    }

    public function deleteProductGroupPrice($product_id, $group_id)
    {
        if ($this->db->delete('product_prices', array('price_group_id' => $group_id, 'product_id' => $product_id))) {
            return TRUE;
        }
        return FALSE;
    }

    public function getBrandByName($name)
    {
        $q = $this->db->get_where('brands', array('name' => $name), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addBrand($data)
    {
        if ($this->db->insert("brands", $data)) {
            return true;
        }
        return false;
    }

    public function addBrands($data)
    {
        if ($this->db->insert_batch('brands', $data)) {
            return true;
        }
        return false;
    }

    public function updateBrand($id, $data = array())
    {
        if ($this->db->update("brands", $data, array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function brandHasProducts($brand_id)
    {
        $q = $this->db->get_where('products', array('brand' => $brand_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteBrand($id)
    {
        if ($this->db->delete("brands", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }
	
	public function getTransactions($where,$offset = 0)
    {
        $this->db->select("transactions.id,users.username, warehouses.name as warehouse,stores.name,CONCAT(bank_name,' - ',account_number) as bank_name, transactions.amount,transactions.added_on, type,note,trasaction_type,type_id,datetime,transactions.added_by, transactions.pay_id");
		$this->db->join('stores', 'transactions.store_id=stores.id', 'left');
		$this->db->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left');
		$this->db->join('users', 'transactions.user_id=users.id', 'left');
		$this->db->join('warehouses', 'transactions.type_id=warehouses.id AND transactions.type IN ("wtb","wts","stw","btw","purchase","expense","salary","loan", "s")', 'left');
		$this->db->where($where);
		$this->db->limit(20, $offset);
		$this->db->order_by('transactions.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('transactions')->result();
    }

    public function getTransactionsExport($where)
    {
        $this->db->select("transactions.id,users.username, warehouses.name as warehouse,stores.name,CONCAT(bank_name,' - ',account_number) as bank_name, transactions.amount,transactions.added_on, type,note,trasaction_type,type_id,datetime,transactions.added_by");
		$this->db->join('stores', 'transactions.store_id=stores.id', 'left');
		$this->db->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left');
		$this->db->join('users', 'transactions.user_id=users.id', 'left');
		$this->db->join('warehouses', 'transactions.type_id=warehouses.id AND transactions.type IN ("wtb","wts","stw","btw","purchase","expense","salary","loan")', 'left');
		$this->db->where($where);
		//$this->db->limit(20, $offset);
		$this->db->order_by('transactions.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('transactions')->result();
    }
	
	public function getTransactionsBank($where,$offset = 0)
    {
        $this->db->select("transactions.id, transactions.amount,type,note,trasaction_type,type_id");
		$this->db->where($where);
		$this->db->order_by('transactions.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('transactions')->result();
    }
	
	public function getTransactionsCount($where)
    {
        $this->db->select("COUNT(1) as total");
		$this->db->join('stores', 'transactions.store_id=stores.id', 'left');
		$this->db->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left');
		$this->db->join('warehouses', 'transactions.type_id=warehouses.id AND transactions.type IN ("wtb","wts","stw","btw","purchase")', 'left');
		$this->db->join('users', 'transactions.user_id=users.id', 'left');
		$this->db->where($where);
		return $this->db->get('transactions')->row();
    }
	
	public function getWarehouseTransactions($where,$offset = 0)
    {
        $this->db->select("transactions.id,users.username, warehouses.name as warehouse,stores.name,CONCAT(bank_name,' - ',account_number) as bank_name, transactions.amount, transactions.added_on, type,note,trasaction_type,type_id,datetime,transactions.added_by");
		$this->db->join('warehouses', 'transactions.type_id=warehouses.id', 'left');
		$this->db->join('stores', 'transactions.store_id=stores.id', 'left');
		$this->db->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left');
		$this->db->join('users', 'transactions.user_id=users.id', 'left');
		$this->db->where($where);
		$this->db->limit(20, $offset);
		$this->db->order_by('transactions.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('transactions')->result();
    }
	
	public function getWarehouseTransactionsCount($where,$offset = 0)
    {
        $this->db->select("COUNT(1) as total");
		$this->db->join('warehouses', 'transactions.type_id=warehouses.id', 'left');
		$this->db->join('stores', 'transactions.store_id=stores.id', 'left');
		$this->db->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left');
		$this->db->join('users', 'transactions.user_id=users.id', 'left');
		$this->db->where($where);
		$this->db->limit(20, $offset);
		$this->db->order_by('transactions.id', 'DESC'); 
		//echo $where;exit;
		return $this->db->get('transactions')->result();
    }


    public function cleanDatabase()
    { 
        $stringoftables     = "loyality_points_cust,expenses,adjustments_stores,adjustments,adjustment_items_stores,adjustment_items,employee,employee_loan,employee_salary,expense_categories,gift_card_topups,gift_cards,warehouses_stores_products,warehouses_products_variants,warehouses_products,transfers,transfer_items,transactions,suspended_items,stock_counts,suspended_bills,stock_count_items,sales,sale_items,returns,return_items,quotes,quote_items,purchases,purchase_items,products,product_variants,product_prices,product_photos,pos_register,payments,deposits,suspended_sale_items,suspended_sales,brands,categories,combo_items,costing,deleted_sales";
        $array_tablenames   = explode(",", $stringoftables);
        if (!empty($array_tablenames)) 
        {
            foreach ($array_tablenames as $tablename) 
            {
                $this->db->truncate($tablename);     
            }
            $this->db->query("UPDATE `sma_warehouses` SET `opening_cash` = '0' WHERE 1");
            $this->db->query("UPDATE `sma_stores` SET `store_opening_cash` = '0' WHERE 1");
            $this->db->query("UPDATE `sma_bank_accounts` SET `opening_balance` = '0' WHERE 1");
            $this->db->query("UPDATE `sma_companies` SET `deposit_amount` = '0', award_points = '0' WHERE 1");
            $this->db->query("UPDATE `sma_users` SET award_points = '0' WHERE 1");
        }
    }

}
