<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Promotions extends MY_Controller
{

   

   function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        $this->lang->admin_load('notifications', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('promotions_model');
        // $this->load->admin_model('cmt_model');

    }

    function newsletters()
    {

      //  $this->load->admin_model('promotions_model');
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('promotions')));
        $meta = array('page_title' => lang('newsletters'), 'bc' => $bc);
        $this->page_construct('promotions/newsletters/index', $meta, $this->data);
    }
	
	function getNewsletters()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id, title, message, date")
            ->from("newsletters")
            //->where('notification', 1)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('promotions/editNewsletter/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_newsletter") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line("delete_notification") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('promotions/deleteNewsletter/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }
	
    function addNewsletter()
    {

        $this->form_validation->set_rules('message', lang("message"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {
            $data = array(
                'title' => $this->input->post('title'),
                'message' => $this->input->post('message')
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/newsletters");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->addNewsletters($data)) {
            $this->session->set_flashdata('message', lang("newsletter_added"));
            admin_redirect("promotions/newsletters");
        } else {

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('comment'),
            );

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'promotions/newsletters/add', $this->data);

        }
    }

    function editNewsletter($id = NULL)
    {

        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('message', lang("message"), 'required|min_length[3]');
        $this->form_validation->set_rules('title', lang("title"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {
            $data = array(
                'message' => $this->input->post('message'),
                'title' => $this->input->post('title')
               
            );
            //print_r($data);die;
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/newsletters");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->updateNewsletter($id, $data)) {

            $this->session->set_flashdata('message', lang("newsletter_updated"));
            admin_redirect("promotions/newsletters");

        } else {

            $table = 'newsletters';

            $newsletters = $this->promotions_model->getCommentByID($id,$table);

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('message', $newsletters->message),
            );

            $this->data['title'] = array('name' => 'title',
                'id' => 'title',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('title', $newsletters->title),
            );


            $this->data['notification'] = $comment;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['error'] = validation_errors();
            $this->load->view($this->theme . 'promotions/newsletters/edit', $this->data);

        }
    }

    function deleteNewsletter($id = NULL)
    {
        $table = 'newsletters';
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->promotions_model->deleteCommon($id,$table)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("newsletter_deleted")));
        }
    }

    // start SMS
    function sms()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('promotions')));
        $meta = array('page_title' => lang('sms'), 'bc' => $bc);
        $this->page_construct('promotions/sms/index', $meta, $this->data);
    }
    
    function getSmss()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id, title, message, date")
            ->from("sms")
            //->where('notification', 1)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('promotions/editSms/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_newsletter") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line("delete_sms") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('promotions/deleteSms/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }
    
    function addSms()
    {

        $this->form_validation->set_rules('message', lang("message"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {
             $data = array(
                'title' => $this->input->post('title'),
                'message' => $this->input->post('message')
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/sms");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->addSms($data)) {
            $this->session->set_flashdata('message', lang("sms_added"));
            admin_redirect("promotions/sms");
        } else {

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('comment'),
            );

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'promotions/sms/add', $this->data);

        }
    }

    function editSms($id = NULL)
    {

        // if (!$this->Owner) {
        //     $this->session->set_flashdata('warning', lang('access_denied'));
        //     redirect($_SERVER["HTTP_REFERER"]);
        // }

        if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('message', lang("message"), 'required|min_length[3]');
        $this->form_validation->set_rules('title', lang("title"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {
            $data = array(
                'message' => $this->input->post('message'),
                'title' => $this->input->post('title')
               
            );
            //print_r($data);die;
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/sms");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->updateSms($id, $data)) {

            $this->session->set_flashdata('message', lang("newsletter_updated"));
            admin_redirect("promotions/sms");

        } else {

            $table = 'sms';

            $newsletters = $this->promotions_model->getCommentByID($id,$table);

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('message', $newsletters->message),
            );

            $this->data['title'] = array('name' => 'title',
                'id' => 'title',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('title', $newsletters->title),
            );


            $this->data['notification'] = $comment;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['error'] = validation_errors();
            $this->load->view($this->theme . 'promotions/sms/edit', $this->data);

        }
    }

    function deleteSms($id = NULL)
    {
        $table = 'sms';
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->promotions_model->deleteCommon($id,$table)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("sms_deleted")));
        }
    }

    //end sms

     function discount()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('promotions')));
        $meta = array('page_title' => lang('sms'), 'bc' => $bc);
        $this->page_construct('promotions/discount/index', $meta, $this->data);
    }
    
    function getDiscount()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id, start_amount, end_amount, discount_type, type, customer_price_group, discount, account, date")
            ->from("discount")
            //->where('notification', 1)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('promotions/editDiscount/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_discount") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line("delete_sms") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('promotions/deleteDiscount/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

     function addDiscount()
    {

        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('discount_type', lang("discount_type"), 'required|min_length[2]');
        $this->form_validation->set_rules('customer_price_group', lang("customer_price_group"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('account', lang("account"), 'required|min_length[2]');


        if ($this->form_validation->run() == true) {

            $category = '';
            $category = $this->input->post('category');

            $categories = null;

            if($category){
                $categories = implode(",",$category);
            }

            
            $data = array(
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'discount_type' => $this->input->post('discount_type'),
                'categories' => $categories,
                'customer_price_group' => $this->input->post('customer_price_group'),
                'discount' => $this->input->post('discount'),
                'type' => $this->input->post('type'),
                'account' => $this->input->post('account')
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/discount");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->addDiscount($data)) {
            $this->session->set_flashdata('message', lang("discount_added"));
            admin_redirect("promotions/discount");
        } else {

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('comment'),
            );

            $this->data['categories'] = $this->db->select('*')->from('categories')->get()->result();

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'promotions/discount/add', $this->data);

        }
    }

     function editDiscount($id = NULL)
    {

        // if (!$this->Owner) {
        //     $this->session->set_flashdata('warning', lang('access_denied'));
        //     redirect($_SERVER["HTTP_REFERER"]);
        // }

        if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('discount_type', lang("discount_type"), 'required|min_length[2]');
        $this->form_validation->set_rules('customer_price_group', lang("customer_price_group"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('account', lang("account"), 'required|min_length[2]');

        if ($this->form_validation->run() == true) {

            $category = '';
            $category = $this->input->post('category');

            $categories = null;

            if($category){
                $categories = implode(",",$category);
            }

            $data = array(
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'discount_type' => $this->input->post('discount_type'),
                'categories' => $categories,
                'customer_price_group' => $this->input->post('customer_price_group'),
                'type' => $this->input->post('type'),
                'discount' => $this->input->post('discount'),
                'account' => $this->input->post('account'),
               
            );
            //print_r($data);die;
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/discount");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->updateDiscount($id, $data)) {

            $this->session->set_flashdata('message', lang("discount_updated"));
            admin_redirect("promotions/discount");

        } else {

            $table = 'discount';

            $newsletters = $this->promotions_model->getCommentByID($id,$table);

            

            $this->data['start_amount'] = array('name' => 'start_amount',
                'id' => 'start_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('start_amount', $newsletters->start_amount),
            );

            $this->data['end_amount'] = array('name' => 'end_amount',
                'id' => 'end_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('end_amount', $newsletters->end_amount),
            );

            $this->data['discount_type'] = $newsletters->discount_type;
            $this->data['customer_price_group'] = $newsletters->customer_price_group;
            $this->data['type'] = $newsletters->type;

            $this->data['discount'] = array('name' => 'discount',
                'id' => 'discount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('discount', $newsletters->discount),
            );

            $this->data['selectCategories'] = $newsletters->categories;

            $this->data['account'] = $newsletters->account;
            $this->data['categories'] = $this->db->select('*')->from('categories')->get()->result();



            $this->data['notification'] = $comment;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['error'] = validation_errors();
            $this->load->view($this->theme . 'promotions/discount/edit', $this->data);

        }
    }

     function deleteDiscount($id = NULL)
    {
        $table = 'discount';
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->promotions_model->deleteCommon($id,$table)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("discount_deleted")));
        }
    }


     function cashback()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('promotions')));
        $meta = array('page_title' => lang('cashback'), 'bc' => $bc);
        $this->page_construct('promotions/cashback/index', $meta, $this->data);
    }
    
    function getCashback()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id, start_amount, end_amount, type, cashback, date")
            ->from("cashback")
            //->where('notification', 1)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('promotions/editCashback/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_cashback") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line("delete_cashback") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('promotions/deleteCashback/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

     function addCashback()
    {

        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback', lang("cashback"), 'required|min_length[2]');


        if ($this->form_validation->run() == true) {
            
            $data = array(
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'type' => $this->input->post('type'),
                'cashback' => $this->input->post('cashback')
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/cashback");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->addCashback($data)) {
            $this->session->set_flashdata('message', lang("cashback_added"));
            admin_redirect("promotions/cashback");
        } else {

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('comment'),
            );

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'promotions/cashback/add', $this->data);

        }
    }

     function editCashback($id = NULL)
    {

        // if (!$this->Owner) {
        //     $this->session->set_flashdata('warning', lang('access_denied'));
        //     redirect($_SERVER["HTTP_REFERER"]);
        // }

        if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback', lang("cashback"), 'required|min_length[2]');

        if ($this->form_validation->run() == true) {
            $data = array(
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'type' => $this->input->post('type'),
                'cashback' => $this->input->post('cashback'),
               
            );
            //print_r($data);die;
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/cashback");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->updateCashback($id, $data)) {

            $this->session->set_flashdata('message', lang("cashback_updated"));
            admin_redirect("promotions/cashback");

        } else {

            $table = 'cashback';

            $newsletters = $this->promotions_model->getCommentByID($id,$table);

            

            $this->data['start_amount'] = array('name' => 'start_amount',
                'id' => 'start_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('start_amount', $newsletters->start_amount),
            );

            $this->data['end_amount'] = array('name' => 'end_amount',
                'id' => 'end_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('end_amount', $newsletters->end_amount),
            );

            $this->data['type'] = $newsletters->type;

            $this->data['cashback'] = array('name' => 'cashback',
                'id' => 'cashback',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('cashback', $newsletters->cashback),
            );

             

            $this->data['notification'] = $comment;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['error'] = validation_errors();
            $this->load->view($this->theme . 'promotions/cashback/edit', $this->data);

        }
    }

     function deleteCashback($id = NULL)
    {
        $table = 'cashback';
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->promotions_model->deleteCommon($id,$table)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("cashback_deleted")));
        }
    }



     function coupon()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('promotions')));
        $meta = array('page_title' => lang('cashback'), 'bc' => $bc);
        $this->page_construct('promotions/coupon/index', $meta, $this->data);
    }
    
    function getCoupon()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id, coupon_code, start_amount, end_amount, type, cashback_type, cashback, date")
            ->from("coupon")
            //->where('notification', 1)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('promotions/editCoupon/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_coupon") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line("delete_coupon") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('promotions/deleteCoupon/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

     function addCoupon()
    {
        $this->form_validation->set_rules('coupon_code', lang("coupon_code"), 'required|min_length[2]');
        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback_type', lang("cashback_type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback', lang("cashback"), 'required|min_length[2]');


        if ($this->form_validation->run() == true) {
            
            $data = array(
                'coupon_code' => $this->input->post('coupon_code'),
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'type' => $this->input->post('type'),
                'cashback_type' => $this->input->post('cashback_type'),
                'cashback' => $this->input->post('cashback')
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/coupon");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->addCoupon($data)) {
            $this->session->set_flashdata('message', lang("cashback_added"));
            admin_redirect("promotions/coupon");
        } else {

            $this->data['message'] = array('name' => 'message',
                'id' => 'message',
                'type' => 'textarea',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('comment'),
            );

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'promotions/coupon/add', $this->data);

        }
    }

     function editCoupon($id = NULL)
    {

        // if (!$this->Owner) {
        //     $this->session->set_flashdata('warning', lang('access_denied'));
        //     redirect($_SERVER["HTTP_REFERER"]);
        // }

        if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('coupon_code', lang("coupon_code"), 'required|min_length[2]');
        $this->form_validation->set_rules('start_amount', lang("start_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('end_amount', lang("end_amount"), 'required|min_length[2]');
        $this->form_validation->set_rules('type', lang("type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback_type', lang("cashback_type"), 'required|min_length[2]');
        $this->form_validation->set_rules('cashback', lang("cashback"), 'required|min_length[2]');

        if ($this->form_validation->run() == true) {
            $data = array(
                'coupon_code' => $this->input->post('coupon_code'),
                'start_amount' => $this->input->post('start_amount'),
                'end_amount' => $this->input->post('end_amount'),
                'type' => $this->input->post('type'),
                'cashback_type' => $this->input->post('cashback_type'),
                'cashback' => $this->input->post('cashback'),
               
            );
            //print_r($data);die;
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("promotions/coupon");
        }

        if ($this->form_validation->run() == true && $this->promotions_model->updateCoupon($id, $data)) {

            $this->session->set_flashdata('message', lang("coupon_updated"));
            admin_redirect("promotions/coupon");

        } else {

            $table = 'coupon';

            $newsletters = $this->promotions_model->getCommentByID($id,$table);

             $this->data['coupon_code'] = array('name' => 'coupon_code',
                'id' => 'coupon_code',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('coupon_code', $newsletters->coupon_code),
            );

            $this->data['start_amount'] = array('name' => 'start_amount',
                'id' => 'start_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('start_amount', $newsletters->start_amount),
            );

            $this->data['end_amount'] = array('name' => 'end_amount',
                'id' => 'end_amount',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('end_amount', $newsletters->end_amount),
            );

            $this->data['type'] = $newsletters->type;
            $this->data['cashback_type'] = $newsletters->cashback_type;

            $this->data['cashback'] = array('name' => 'cashback',
                'id' => 'cashback',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('cashback', $newsletters->cashback),
            );

             

            $this->data['notification'] = $comment;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['error'] = validation_errors();
            $this->load->view($this->theme . 'promotions/coupon/edit', $this->data);

        }
    }

     function deleteCoupon($id = NULL)
    {
        $table = 'coupon';
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->promotions_model->deleteCommon($id,$table)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("coupon_deleted")));
        }
    }



}
