<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Payments extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->lang->admin_load('purchases', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('purchases_model');
        $this->load->admin_model('sales_model');
        $this->digital_upload_path = 'files/';
        $this->upload_path = 'assets/uploads/';
        $this->thumbs_path = 'assets/uploads/thumbs/';
        $this->image_types = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif|txt';
        $this->allowed_file_size = '1024';
        $this->data['logo'] = true;
        $this->load->admin_model('pos_model');
    }

    function index()
    {
        show_404();
    }

    public function add_payments(){
        $warehouse_id = $this->session->userdata('werehouse');
        $this->sma->checkPermissions();

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        if ($this->Owner || $this->Admin || !$this->session->userdata('warehouse_id')) {
            $this->data['warehouses'] = $this->site->getAllWarehouses();
            $this->data['warehouse_id'] = $warehouse_id;
            $this->data['warehouse'] = $warehouse_id ? $this->site->getWarehouseByID($warehouse_id) : null;
        } else {
            $this->data['warehouses'] = null;
            $this->data['warehouse_id'] = $this->session->userdata('warehouse_id');
            $this->data['warehouse'] = $this->session->userdata('warehouse_id') ? $this->site->getWarehouseByID($this->session->userdata('warehouse_id')) : null;
        }
        // $this->data['accounts'] = $this->purchases_model->getPurchaseAccount();
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['inv'] = $purchase;
            $this->data['payment_ref'] = ''; //$this->site->getReference('ppay');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['accounts'] = $this->purchases_model->getPurchaseAccount();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();//purchases_model->getWarehouseByID($purchase->warehouse_id);
            $this->data['stores'] = $this->pos_model->getAllsStore();

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => 'Payments'));
        $meta = array('page_title' => lang('payments'), 'bc' => $bc);
        $this->page_construct('payments/index', $meta, $this->data);

    }

    public function user_detail($user_detail)
    {
        if ($user_detail == 'users') {
            $user_detail = $this->db->select('*')->from('users')->get()->result();
        } else {
            $user_detail = $this->db->select('*')->from('companies')->where('group_name', $user_detail)->get()->result();
        }
        if ($rows = $user_detail) {
            $data = json_encode($rows);
        } else {
            $data = false;
        }
        echo $data;
    }

    public function update_payments(){
        $type        = $this->input->post('type');
        $user        = $this->input->post('users');
        if($type == 'users'){
            $post_amount = $this->input->post('amount-paid');
            $data['date']  = date('Y-m-d H:m');
            $data['purchase_id']  = null;
            $data['amount']       = $post_amount ;
            $data['paid_by']      =  $this->input->post('paid_by');
            $data['created_by']   =  $this->session->userdata('user_id');
            $data['type']         = 'sent';
            $data['user']         = $user;
            $data['awards']       = $this->input->post('awards');
            $data['reference_no'] = $this->input->post('reference_no') ? $this->input->post('reference_no') : $this->site->getReference('pay');
            $valuesReturn = $this->purchases_model->addRewardPayment($data);
            if ($valuesReturn == 1) {
                $this->session->set_flashdata('message', lang("payment_added"));
                redirect($_SERVER["HTTP_REFERER"]);
            } else {
                $this->session->set_flashdata('error', "Balance Is Not Sufficient For Payment");
                redirect($_SERVER["HTTP_REFERER"]);
            }

        }else if ($type == 'supplier') {
            // $purchaseId = $this->db->select('*')
            // ->from('purchases')
            // ->where('supplier_id',$user)
            // ->where('payment_status','pending')
            // ->or_where('payment_status','partial')
            // ->order_by('id','asc')
            // ->get()
            // ->result();
            $purchaseId =  $this->db->query("SELECT
                      sma_purchases.*
                    FROM
                      sma_purchases
                    WHERE 
                    sma_purchases.supplier_id = $user
                      AND (sma_purchases.payment_status = 'pending'
                      OR sma_purchases.payment_status = 'partial')
                    ORDER BY sma_purchases.id ASC
                    ")->result();

            $amount  =  0;
            $count = count($purchaseId);
            $post_amount = $this->input->post('amount-paid');
            $j = 0;
            for ($i = 0; $i < count($purchaseId); $i++) {
                $tem_current_minus = 0;
                if ($post_amount > 0) {
                    $temp_post = $post_amount;
                    $temp_amount = $purchaseId[$i]->grand_total;
                    if ($temp_post - $temp_amount >= 0 && $temp_post >= 0) {
                        $tem_current_minus = $purchaseId[$i]->grand_total;
                        $purchaseId[$i]->grand_total = 0;
                        $post_amount = $temp_post - $temp_amount;
                    } else if ($temp_amount - $temp_post >= 0 && $temp_post >= 0) {
                        $tem_current_minus = $temp_post;
                        $purchaseId[$i]->grand_total = $temp_amount - $temp_post;
                        $post_amount = $temp_post - $temp_amount;
                    }
                }
                $data['date']  = date('Y-m-d H:m');
                $data['purchase_id']  = $purchaseId[$i]->id;
                $data['amount']       = $tem_current_minus;
                // $data['paid_by']      = 'cash';
                $data['paid_by']      =  $this->input->post('paid_by');
                $data['created_by']   =  $this->session->userdata('user_id');
                $data['type']         = 'sent';
                $data['reference_no'] = $this->input->post('reference_no') ? $this->input->post('reference_no') : $this->site->getReference('ppay');

                $valuesReturn = $this->purchases_model->addPayment($data);
                $j++;
            }
            if ($valuesReturn == 1 && $count == $j) {
                $this->session->set_flashdata('message', lang("payment_added"));
                redirect($_SERVER["HTTP_REFERER"]);
            }else{
                $this->session->set_flashdata('error', "Balance Is Not Sufficient For Payment");
                redirect($_SERVER["HTTP_REFERER"]);
            }
        }else{

              // $sales = $this->db->select('*')
              //                      ->from('sales')
              //                      ->where('customer_id',$user)
              //                      ->where('payment_status','pending')
              //                      ->or_where('payment_status','due')
              //                      ->order_by('id','asc')
              //                      ->get()
              //                      ->result();


                $sales =  $this->db->query("SELECT
                      sma_sales.*
                    FROM
                      sma_sales
                    WHERE 
                    sma_sales.customer_id = $user
                      AND (sma_sales.payment_status = 'pending'
                      OR sma_sales.payment_status = 'due')
                    ORDER BY sma_sales.id ASC
                    ")->result();

                            $amount  =  0;
                            $count = count($sales);
                               $post_amount = $this->input->post('amount-paid');
                               $j= 0;
                                    for($i=0;$i<count($sales);$i++){  
                                $sale = $this->sales_model->getInvoiceByID($sales[$i]->id);

                                        $tem_current_minus = 0;
                                          if($post_amount > 0){
                                              $temp_post = $post_amount; 
                                              $temp_amount = $sales[$i]->grand_total;
                                              if($temp_post - $temp_amount >=0 && $temp_post >= 0){
                                                 $tem_current_minus = $sales[$i]->grand_total; 
                                                 $sales[$i]->grand_total = 0;   
                                                 $post_amount = $temp_post - $temp_amount;
                                              }
                                              else if($temp_amount - $temp_post >=0 && $temp_post >= 0){
                                                 $tem_current_minus = $temp_post;         
                                                 $sales[$i]->grand_total = $temp_amount - $temp_post;
                                                 $post_amount = $temp_post - $temp_amount;
                                              }
                                            }
                                            $data['date']  = date('Y-m-d H:m');
                                            $data['sale_id']     = $sales[$i]->id;
                                            $data['amount']       = $tem_current_minus;
                                            $data['paid_by']      =  $this->input->post('paid_by');
                                            $data['created_by']   =  $this->session->userdata('user_id');
                                            $data['type']         = 'received';
                                            $data['type_id']         = $sale->warehouse_id;
                                            $data['reference_no'] = $this->input->post('reference_no') ? $this->input->post('reference_no') : $this->site->getReference('ppay');

                                            $valuesReturn =   $this->sales_model->addPayment($data, $user);
                                     
                                    $j++;
                                    }
                           if($valuesReturn == 1 && $count == $j){
                                $this->session->set_flashdata('message', lang("payment_added"));
                                redirect($_SERVER["HTTP_REFERER"]);
                            }else{
                                 $this->session->set_flashdata('error', "Payment Not Added");
                                 redirect($_SERVER["HTTP_REFERER"]);
                            }
        }
    }

    public function user_account_details($user,$user_type){
        $array_amount = [];
        $balance      = [];
        $paid         = [];

        if($user_type == 'supplier'){

          // $details = $this->db->select('purchases.*,companies.company company_customer_name')
          //                     ->from('purchases')
          //                     ->join('companies','companies.id=purchases.supplier_id')
          //                     ->where('purchases.supplier_id',$user)
          //                     ->where('purchases.payment_status','pending')
          //                     ->or_where('purchases.payment_status','partial')
          //                     ->order_by('purchases.id','asc')
          //                     ->get()
          //                     ->result();

          $query = "SELECT
                      sma_purchases.*,
                      sma_companies.company AS company_customer_name
                    FROM
                      sma_purchases,
                      sma_companies
                    WHERE sma_companies.id = sma_purchases.supplier_id

                      AND sma_purchases.supplier_id  = $user
                      
                      AND (sma_purchases.payment_status = 'pending'
                      OR sma_purchases.payment_status = 'partial')
                      
                    ORDER BY sma_purchases.id ASC
              ";
          $details =  $this->db->query($query)->result();
        } else if ($user_type == 'users') {
            $query = "SELECT sma_users.* FROM sma_users WHERE sma_users.id = $user ORDER BY sma_users.id ASC";
            $details =  $this->db->query($query)->result();
        } else {
            $details =  $this->db->query("SELECT sma_sales.*, sma_companies.company AS company_customer_name FROM sma_sales, sma_companies WHERE sma_companies.id = sma_sales.customer_id AND sma_sales.customer_id = $user AND (sma_sales.payment_status = 'pending' OR sma_sales.payment_status = 'due') ORDER BY sma_sales.id ASC")->result();
        }

        $invoice_count = 0;
        foreach ($details as $key => $value) {
            if(isset($value->grand_total)){
                 $invoice_count ++;
                $array_amount[] = $value->grand_total;
            }
            $data['details'] = $value;
            $paid[] = $value->paid;
        }

        if($user_type == 'users'){
           $data['sa_point_redeem'] = $this->Settings->sa_point_redeem;
        }

        $amount = array_sum($array_amount);
        $data['amount'] = $invoice_count;
        //$data['amount'] = $amount;
        $data['balance'] = $amount - array_sum($paid);
        echo json_encode($data);
    }

    function paypalipn()
    {

        $this->load->admin_model('sales_model');
        $paypal = $this->sales_model->getPaypalSettings();
        $this->sma->log_payment('Paypal IPN called');

        $req = 'cmd=_notify-validate';
        foreach ($_POST as $key => $value) {
            $value = urlencode(stripslashes($value));
            $req .= "&$key=$value";
        }

        $header = "POST /cgi-bin/webscr HTTP/1.1\r\n";
        $header .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $header .= "Host: www.paypal.com\r\n";  // www.sandbox.paypal.com for a test site
        $header .= "Content-Length: " . strlen($req) . "\r\n";
        $header .= "Connection: close\r\n\r\n";

        //$fp = fsockopen ('ssl://www.sandbox.paypal.com', 443, $errno, $errstr, 30);
        $fp = fsockopen('ssl://www.paypal.com', 443, $errno, $errstr, 30);

        if (!$fp) {

            $this->sma->log_payment('Paypal Payment Failed (IPN HTTP ERROR)', $errstr);
            $this->session->set_flashdata('error', lang('payment_failed'));

        } else {
            fputs($fp, $header . $req);
            while (!feof($fp)) {
                $res = fgets($fp, 1024);
                //log_message('error', 'Paypal IPN - fp handler -'.$res);
                if (stripos($res, "VERIFIED") !== false) {
                    $this->sma->log_payment('Paypal IPN - VERIFIED');

                    $custom = explode('__', $_POST['custom']);
                    $payer_email = $_POST['payer_email'];

                    if (($_POST['payment_status'] == 'Completed' || $_POST['payment_status'] == 'Processed' || $_POST['payment_status'] == 'Pending') &&
                        ($_POST['receiver_email'] == $paypal->account_email) &&
                        ($_POST['mc_gross'] == ($custom[1] + $custom[2]))
                    ) {

                        $invoice_no = $_POST['item_number'];
                        $reference = $_POST['item_name'];
                        if ($_POST['mc_currency'] == $this->Settings->default_currency) {
                            $amount = $_POST['mc_gross'];
                        } else {
                            $currency = $this->site->getCurrencyByCode($_POST['mc_currency']);
                            $amount = $_POST['mc_gross'] * (1 / $currency->rate);
                        }
                        if ($inv = $this->sales_model->getInvoiceByID($invoice_no)) {
                            $payment = array(
                                'date' => date('Y-m-d H:i:s'),
                                'sale_id' => $invoice_no,
                                'reference_no' => $this->site->getReference('pay'),
                                'amount' => $amount,
                                'paid_by' => 'paypal',
                                'transaction_id' => $_POST['txn_id'],
                                'type' => 'received',
                                'note' => $_POST['mc_currency'] . ' ' . $_POST['mc_gross'] . ' had been paid for the Sale Reference No ' . $reference
                            );
                            if ($this->sales_model->addPayment($payment)) {
                                $customer = $this->site->getCompanyByID($inv->customer_id);
                                $this->site->updateReference('pay');

                                $this->load->library('parser');
                                $parse_data = array(
                                    'reference_number' => $reference,
                                    'contact_person' => $customer->name,
                                    'company' => $customer->company,
                                    'site_link' => base_url(),
                                    'site_name' => $this->Settings->site_name,
                                    'logo' => '<img src="' . base_url() . 'assets/uploads/logos/' . $this->Settings->logo . '" alt="' . $this->Settings->site_name . '"/>'
                                );
                                $temp_path = is_dir('./themes/' . $this->Settings->theme . '/admin/views/email_templates/');
                                $theme = $temp_path ? $this->theme : 'default';
                                $msg = file_get_contents('./themes/' . $theme . '/admin/views/email_templates/payment.html');
                                $message = $this->parser->parse_string($msg, $parse_data);
                                $this->sma->log_payment('Payment has been made for Sale Reference #' . $_POST['item_name'] . ' via Paypal (' . $_POST['txn_id'] . ').', print_r($_POST, ture));
                                try {
                                    $this->sma->send_email($paypal->account_email, 'Payment has been made via Paypal', $message);
                                } catch (Exception $e) {
                                    $this->sma->log_payment('Email Notification Failed: ' . $e->getMessage());
                                }
                                $this->session->set_flashdata('message', lang('payment_added'));
                            }
                        }
                    } else {

                        $this->sma->log_payment('Payment failed for Sale Reference #' . $reference . ' via Paypal (' . $_POST['txn_id'] . ').', print_r($_POST, ture));
                        $this->session->set_flashdata('error', lang('payment_failed'));

                    }
                } else if (stripos($res, "INVALID") !== false) {
                    $this->sma->log_payment('INVALID response from Paypal. Payment failed via Paypal.', print_r($_POST, ture));
                    $this->session->set_flashdata('error', lang('payment_failed'));
                }
            }
            fclose($fp);
        }
        redirect('/');
        exit();

    }

    function skrillipn()
    {
        $this->load->admin_model('sales_model');
        $skrill = $this->sales_model->getSkrillSettings();
        $this->sma->log_payment('Skrill IPN called');

        $concatFields = $_POST['merchant_id'] . $_POST['transaction_id'] . strtoupper(md5($skrill->secret_word)) . $_POST['mb_amount'] . $_POST['mb_currency'] . $_POST['status'];

        if (strtoupper(md5($concatFields)) == $_POST['md5sig'] && $_POST['status'] == 2 && $_POST['pay_to_email'] == $skrill->account_email) {
            $invoice_no = $_POST['item_number'];
            $reference = $_POST['item_name'];
            if ($_POST['mb_currency'] == $this->Settings->default_currency) {
                $amount = $_POST['mb_amount'];
            } else {
                $currency = $this->site->getCurrencyByCode($_POST['mb_currency']);
                $amount = $_POST['mb_amount'] * (1 / $currency->rate);
            }
            if ($inv = $this->sales_model->getInvoiceByID($invoice_no)) {
                $payment = array(
                    'date' => date('Y-m-d H:i:s'),
                    'sale_id' => $invoice_no,
                    'reference_no' => $this->site->getReference('pay'),
                    'amount' => $amount,
                    'paid_by' => 'skrill',
                    'transaction_id' => $_POST['mb_transaction_id'],
                    'type' => 'received',
                    'note' => $_POST['mb_currency'] . ' ' . $_POST['mb_amount'] . ' had been paid for the Sale Reference No ' . $reference
                );
                if ($this->sales_model->addPayment($payment)) {
                    $customer = $this->site->getCompanyByID($inv->customer_id);
                    $this->site->updateReference('pay');

                    $this->load->library('parser');
                    $parse_data = array(
                        'reference_number' => $reference,
                        'contact_person' => $customer->name,
                        'company' => $customer->company,
                        'site_link' => base_url(),
                        'site_name' => $this->Settings->site_name,
                        'logo' => '<img src="' . base_url() . 'assets/uploads/logos/' . $this->Settings->logo . '" alt="' . $this->Settings->site_name . '"/>'
                    );
                    $temp_path = is_dir('./themes/' . $this->Settings->theme . '/admin/views/email_templates/');
                    $theme = $temp_path ? $this->theme : 'default';
                    $msg = file_get_contents('./themes/' . $theme . '/admin/views/email_templates/payment.html');
                    $message = $this->parser->parse_string($msg, $parse_data);
                    $this->sma->log_payment('Payment has been made for Sale Reference #' . $_POST['item_name'] . ' via Skrill (' . $_POST['mb_transaction_id'] . ').', print_r($_POST, ture));
                    try {
                        $this->sma->send_email($skrill->account_email, 'Payment has been made via Skrill', $message);
                    } catch (Exception $e) {
                        $this->sma->log_payment('Email Notification Failed: ' . $e->getMessage());
                    }
                    $this->session->set_flashdata('message', lang('payment_added'));
                }
            }
        } else {
            $this->sma->log_payment('Payment failed for via Skrill.', print_r($_POST, ture));
            $this->session->set_flashdata('error', lang('payment_failed'));
        }
        redirect('/');
        exit();

    }

}
