<?php 

defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        $this->lang->admin_load('notifications', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('cmt_model');
        $this->load->admin_model('pos_model');

    }

    function index()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('employee')));
        $meta = array('page_title' => ucwords(lang('employees')), 'bc' => $bc);
        $this->page_construct('employees/index', $meta, $this->data);
    }

    function getNotifications()
    {
		$delete_link = "<a href='#' class='tip po' title='<b>" . $this->lang->line("Delete Employee") . "</b>' data-content=\"<p>"
            . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete1' id='a__$1' href='" . admin_url('employee/delete/$1') . "'>"
            . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i> "
            . lang('Delete Employee') . "</a>";
			
		$action = '<div class="text-center">
					<div class="btn-group text-left">'
            			.'<button type="button" class="btn btn-default btn-xs btn-primary dropdown-toggle testtoggle" data-toggle="dropdown">'.lang('actions').'<span class="caret"></span></button>
						<ul class="dropdown-menu pull-right" role="menu">
							<li><a href="' . admin_url('employee/view_emp_info/$1') . '" data-toggle="modal" data-target="#myModal" class="tip"><i class="fa fa-file-text-o"></i> ' . lang('Employee Details') . '</a></li>
							<li><a href="' . admin_url('employee/edit/$1') . '" data-toggle="modal" data-target="#myModal" class="tip"><i class="fa fa-edit"></i> ' . lang('Edit Employee') . '</a></li>
							<li>'.$delete_link.'</li>
							<li><a href="' . admin_url('employee/salary/$1') . '" class="tip"><i class="fa fa-file-text-o"></i>' . lang('Salary') . '</a></li>
							<li><a href="' . admin_url('employee/loan/$1') . '" class="tip"><i class="fa fa-file-text-o"></i>' . lang('Loan') . '</a></li>
						</ul>
					</div>
				</div>';
        $this->load->library('datatables');
        $this->datatables
           ->select("id, e_name, mobile,id_card,id_card_expire,Vehicle_insurance,Health_Insurance,email,salary")
            ->from("employee")
            //->where('notification', 1)
            ->add_column("Actions", $action, "id");
        //$this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }
	
	function loan($empid = NULL)
    {
		
        $this->data['employee'] = $this->cmt_model->getEmployeeByID($empid);;
           
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('employee')));
        $meta = array('page_title' => lang('employees'), 'bc' => $bc);
        $this->page_construct('employees/loan', $meta, $this->data);
    }
	
	function getEmpLoan($empid = NULL)
    {
        $this->load->library('datatables');
        $this->datatables
           ->select("id, loan_amt, note, created_date, return_amt, return_date,remaining_amt")
            ->from("employee_loan")
            ->where('empid', $empid)
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('employee/edit_loan/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("Edit Loan") . "'>Return</a> <a href='#' class='tip po' title='<b>" . $this->lang->line("Delete Loan") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('employee/delete_loan/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }
	
	function salary($empid = NULL)
    {		
        $this->data['employee'] = $this->cmt_model->getEmployeeByID($empid);           
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => ucwords(lang('employee'))));
        $meta = array('page_title' => ucwords(lang('employees')), 'bc' => $bc);
        $this->page_construct('employees/salary', $meta, $this->data);
    }
	
	function getEmpSalary($empid = NULL)
    {
        $this->load->library('datatables');
        $this->datatables
           ->select("id, salary_amt,total_unpaid_leaves,salary_period,note,created_date")
            ->from("employee_salary")
            ->where('empid', $empid)
            ->add_column("Actions", "<div class=\"text-center\"> <a href='#' class='tip po' title='<b>" . $this->lang->line("Delete Salary") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('employee/delete_salary/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }
	
	function report()
    {
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => ucwords(lang('employee'))));
        $meta = array('page_title' => ucwords(lang('employees')), 'bc' => $bc);
        $this->page_construct('employees/report', $meta, $this->data);
    }
	
	function getEmpReport($pdf = NULL, $xls = NULL)
    {		
		$this->load->library('datatables');
		
		$start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
		
        if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }
		
		if ($pdf || $xls) 
		{
            $this->db
			   ->select("employee.*,sum(loan.loan_amt) as total_amt,sum(loan.remaining_amt) as total_rem_amt")
				->from("employee")
				->join("( SELECT * from {$this->db->dbprefix('employee_loan')} ) loan", 'employee.id=loan.empid', 'left')
				->group_by('empid');
			 if ($start_date) {
				$this->db->where($this->db->dbprefix('employee').'.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
				}	

            $q = $this->db->get();
			
            if ($q->num_rows() > 0) {
                foreach (($q->result()) as $row) {
                    $data[] = $row;
                }
            } else {
                $data = NULL;
            }

            if (!empty($data)) {

                $this->load->library('excel');
                $this->excel->setActiveSheetIndex(0);
                $this->excel->getActiveSheet()->setTitle(lang('Employee_report'));
                $this->excel->getActiveSheet()->SetCellValue('A1', lang('Created Date'));
                $this->excel->getActiveSheet()->SetCellValue('B1', lang('Name'));
                $this->excel->getActiveSheet()->SetCellValue('C1', lang('Mobile'));
                $this->excel->getActiveSheet()->SetCellValue('D1', lang('IQAMA ID'));
                $this->excel->getActiveSheet()->SetCellValue('E1', lang('IQAMA Expire Date'));
                $this->excel->getActiveSheet()->SetCellValue('F1', lang('Vehicle_insurance'));
                $this->excel->getActiveSheet()->SetCellValue('G1', lang('Vehicle_insurance_expire'));
                $this->excel->getActiveSheet()->SetCellValue('H1', lang('Health_Insurance'));
                $this->excel->getActiveSheet()->SetCellValue('I1', lang('email'));
				$this->excel->getActiveSheet()->SetCellValue('J1', lang('address'));
				$this->excel->getActiveSheet()->SetCellValue('K1', lang('Calculation_Finance'));
				$this->excel->getActiveSheet()->SetCellValue('L1', lang('salary'));
				$this->excel->getActiveSheet()->SetCellValue('M1', lang('id_card_renewal_fee'));
				$this->excel->getActiveSheet()->SetCellValue('N1', lang('ministry_of_labor_fee'));
				$this->excel->getActiveSheet()->SetCellValue('O1', lang('insurance_renewal_fee'));
				$this->excel->getActiveSheet()->SetCellValue('P1', lang('vehicle_insurance_fee'));
				$this->excel->getActiveSheet()->SetCellValue('Q1', lang('health_insurance_fee'));
				$this->excel->getActiveSheet()->SetCellValue('R1', lang('account_holder'));
				$this->excel->getActiveSheet()->SetCellValue('S1', lang('bank_name'));
				$this->excel->getActiveSheet()->SetCellValue('T1', lang('account_number'));
				$this->excel->getActiveSheet()->SetCellValue('U1', lang('iban_number'));
				$this->excel->getActiveSheet()->SetCellValue('V1', lang('Loan Amount'));
				$this->excel->getActiveSheet()->SetCellValue('W1', lang('Remaining Amount'));

                $row = 2;
                $total = 0;
                $paid = 0;
                $balance = 0;
                foreach ($data as $data_row) {
                    $this->excel->getActiveSheet()->SetCellValue('A' . $row, $data_row->created_date);
                    $this->excel->getActiveSheet()->SetCellValue('B' . $row, $data_row->e_name);
                    $this->excel->getActiveSheet()->SetCellValue('C' . $row, $data_row->mobile);
                    $this->excel->getActiveSheet()->SetCellValue('D' . $row, $data_row->id_card);
                    $this->excel->getActiveSheet()->SetCellValue('E' . $row, $data_row->id_card_expire);
                    $this->excel->getActiveSheet()->SetCellValue('F' . $row, $data_row->Vehicle_insurance);
                    $this->excel->getActiveSheet()->SetCellValue('G' . $row, $data_row->Vehicle_insurance_expire);
                    $this->excel->getActiveSheet()->SetCellValue('H' . $row, ($data_row->Health_Insurance - $data_row->paid));
                    $this->excel->getActiveSheet()->SetCellValue('I' . $row, $data_row->email);
					
					$this->excel->getActiveSheet()->SetCellValue('J' . $row, $data_row->address);
					$this->excel->getActiveSheet()->SetCellValue('K' . $row, $data_row->Calculation_Finance);
					$this->excel->getActiveSheet()->SetCellValue('L' . $row, $data_row->salary);
					$this->excel->getActiveSheet()->SetCellValue('M' . $row, $data_row->id_card_renewal_fee);
					$this->excel->getActiveSheet()->SetCellValue('N' . $row, $data_row->ministry_of_labor_fee);
					$this->excel->getActiveSheet()->SetCellValue('O' . $row, $data_row->insurance_renewal_fee);
					$this->excel->getActiveSheet()->SetCellValue('P' . $row, $data_row->vehicle_insurance_fee);
					$this->excel->getActiveSheet()->SetCellValue('Q' . $row, $data_row->health_insurance_fee);
					$this->excel->getActiveSheet()->SetCellValue('R' . $row, $data_row->account_holder);
					$this->excel->getActiveSheet()->SetCellValue('S' . $row, $data_row->bank_name);
					$this->excel->getActiveSheet()->SetCellValue('T' . $row, $data_row->account_number);
					$this->excel->getActiveSheet()->SetCellValue('U' . $row, $data_row->iban_number);
					$this->excel->getActiveSheet()->SetCellValue('V' . $row, $data_row->total_amt);
					$this->excel->getActiveSheet()->SetCellValue('W' . $row, $data_row->total_rem_amt);
                    
                    $row++;
                }
                
                $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
                $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
                $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
                $this->excel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
                $this->excel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
                $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                $this->excel->getActiveSheet()->getStyle('E2:E' . $row)->getAlignment()->setWrapText(true);
                $filename = 'employee_report';
                $this->load->helper('excel');
                create_excel($this->excel, $filename);

            }
			
            $this->session->set_flashdata('error', lang('nothing_found'));
            redirect($_SERVER["HTTP_REFERER"]);

        } 
		else 
		{
			$this->datatables
			   ->select("employee.id,employee.e_name,employee.mobile,employee.id_card,employee.id_card_expire,employee.salary,sum(loan.loan_amt) as tloan_amt,sum(loan.remaining_amt) as trem_amt,employee.created_date")
				->from("employee")
				->join("{$this->db->dbprefix('employee_loan')} loan", 'employee.id = loan.empid', 'left')
				->group_by('empid');
				
			 if ($start_date) 
			 {
				$this->datatables->where($this->db->dbprefix('employee').'.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
			}
			
			//$this->datatables->unset_column('id');
		}
        echo $this->datatables->generate();
    }
	
	function salaryreport()
    {
		$this->data['employees'] = $this->cmt_model->getEmpoyees();
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('employee')));
        $meta = array('page_title' => lang('employees'), 'bc' => $bc);
        $this->page_construct('employees/salaryreport', $meta, $this->data);
    }
	
	function getSalaryReport($pdf = NULL, $xls = NULL)
    {
		$this->load->library('datatables');
		
        $empid = $this->input->get('empid') ? $this->input->get('empid') : NULL;
		$start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
		
        if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }
		
		if ($pdf || $xls) 
		{
            $this->db
			   ->select("employee.id,employee.e_name,employee.id_card,emp_salary.salary_amt,total_unpaid_leaves, salary_period, emp_salary.note,emp_salary.created_date")
				->from("employee")
				->join("( SELECT * from {$this->db->dbprefix('employee_salary')} ) emp_salary", 'employee.id=emp_salary.empid', 'left');
			 if ($start_date) {
				$this->db->where('emp_salary.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
				}	
			if ($empid!='') {
				$this->db->where('emp_salary.empid',$empid);
				}			

            $q = $this->db->get();
			
            if ($q->num_rows() > 0) {
                foreach (($q->result()) as $row) {
                    $data[] = $row;
                }
            } else {
                $data = NULL;
            }

            if (!empty($data)) {

                $this->load->library('excel');
                $this->excel->setActiveSheetIndex(0);
                $this->excel->getActiveSheet()->setTitle(lang('Employee_Salary_report'));
                $this->excel->getActiveSheet()->SetCellValue('A1', lang('Date'));
                $this->excel->getActiveSheet()->SetCellValue('B1', lang('Name'));
                $this->excel->getActiveSheet()->SetCellValue('C1', lang('IQAMA ID'));
                $this->excel->getActiveSheet()->SetCellValue('D1', lang('Salary'));
                $this->excel->getActiveSheet()->SetCellValue('E1', lang('Unpaid Leaves'));
                $this->excel->getActiveSheet()->SetCellValue('F1', lang('Salary Month'));
                $this->excel->getActiveSheet()->SetCellValue('G1', lang('Note'));
                

                $row = 2;
                $total = 0;
                $paid = 0;
                $balance = 0;
                foreach ($data as $data_row) 
				{
                    $this->excel->getActiveSheet()->SetCellValue('A' . $row, $data_row->created_date);
                    $this->excel->getActiveSheet()->SetCellValue('B' . $row, $data_row->e_name);
                    $this->excel->getActiveSheet()->SetCellValue('C' . $row, $data_row->id_card);
                    $this->excel->getActiveSheet()->SetCellValue('D' . $row, $data_row->salary_amt);
                    $this->excel->getActiveSheet()->SetCellValue('E' . $row, $data_row->total_unpaid_leaves);
                    $this->excel->getActiveSheet()->SetCellValue('F' . $row, $data_row->salary_period);
                    $this->excel->getActiveSheet()->SetCellValue('G' . $row, $data_row->note);
                    $row++;
                }
                
                $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
                $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
                $this->excel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
                
                $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                $this->excel->getActiveSheet()->getStyle('E2:E' . $row)->getAlignment()->setWrapText(true);
                $filename = 'employee_salary_report';
                $this->load->helper('excel');
                create_excel($this->excel, $filename);

            }
			
            $this->session->set_flashdata('error', lang('nothing_found'));
            redirect($_SERVER["HTTP_REFERER"]);

        } 
		else 
		{
			$this->datatables
			   ->select("employee.id,employee.e_name,employee.id_card,emp_salary.salary_amt, total_unpaid_leaves, salary_period,emp_salary.note, emp_salary.created_date")
				->from("employee")
				->join("( SELECT * from {$this->db->dbprefix('employee_salary')} ) emp_salary", 'employee.id=emp_salary.empid', 'left');
			 	
				if ($start_date) 
				{
					$this->datatables->where('emp_salary.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
				}
					
			if ($empid!='') 
			{
				$this->datatables->where('emp_salary.empid',$empid);
			}		
			//$this->datatables->unset_column('id');
		}
		
        echo $this->datatables->generate();
    }
	
	function loanreport()
    {
		$this->data['employees'] = $this->cmt_model->getEmpoyees();
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('employee')));
        $meta = array('page_title' => lang('employees'), 'bc' => $bc);
        $this->page_construct('employees/loanreport', $meta, $this->data);
    }
	
	function getLoanReport($pdf = NULL, $xls = NULL)
    {
		
		$this->load->library('datatables');
		
        $empid = $this->input->get('empid') ? $this->input->get('empid') : NULL;
		$start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
		
        if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }
		
		if ($pdf || $xls) {
            $this->db
			   ->select("employee.id,employee.e_name,employee.id_card,sum(emp_loan.loan_amt) as tloan_amt,sum(emp_loan.return_amt) as tret_amt,sum(emp_loan.remaining_amt) as trem_amt,emp_loan.created_date")
				->from("employee")
				->join("( SELECT * from {$this->db->dbprefix('employee_loan')} ) emp_loan", 'employee.id=emp_loan.empid', 'right')
				->group_by('empid');
			 if ($start_date) {
				$this->db->where('emp_loan.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
				}	
			if ($empid!='') {
				$this->db->where('emp_loan.empid',$empid);
				}			

            $q = $this->db->get();
			
            if ($q->num_rows() > 0) {
                foreach (($q->result()) as $row) {
                    $data[] = $row;
                }
            } else {
                $data = NULL;
            }

            if (!empty($data)) {

                $this->load->library('excel');
                $this->excel->setActiveSheetIndex(0);
                $this->excel->getActiveSheet()->setTitle(lang('Employee_Salary_report'));
                $this->excel->getActiveSheet()->SetCellValue('A1', lang('Created Date'));
                $this->excel->getActiveSheet()->SetCellValue('B1', lang('Name'));
                $this->excel->getActiveSheet()->SetCellValue('C1', lang('IQAMA ID'));
                $this->excel->getActiveSheet()->SetCellValue('D1', lang('Loan Amount'));
                $this->excel->getActiveSheet()->SetCellValue('E1', lang('Return Amount'));
				$this->excel->getActiveSheet()->SetCellValue('F1', lang('Remaining Amount'));
             
                $row = 2;
                $total = 0;
                $paid = 0;
                $balance = 0;
                foreach ($data as $data_row) {
                    $this->excel->getActiveSheet()->SetCellValue('A' . $row, $data_row->created_date);
                    $this->excel->getActiveSheet()->SetCellValue('B' . $row, $data_row->e_name);
                    $this->excel->getActiveSheet()->SetCellValue('C' . $row, $data_row->id_card);
                    $this->excel->getActiveSheet()->SetCellValue('D' . $row, $data_row->tloan_amt);
                    $this->excel->getActiveSheet()->SetCellValue('E' . $row, $data_row->tret_amt);
					$this->excel->getActiveSheet()->SetCellValue('F' . $row, $data_row->trem_amt);
                    $row++;
                }
                
                $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
				$this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
                
                $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                $this->excel->getActiveSheet()->getStyle('E2:E' . $row)->getAlignment()->setWrapText(true);
                $filename = 'employee_loan_report';
                $this->load->helper('excel');
                create_excel($this->excel, $filename);

            }
            $this->session->set_flashdata('error', lang('nothing_found'));
            redirect($_SERVER["HTTP_REFERER"]);

        } else {
			$this->datatables
			   ->select("employee.id,employee.e_name,employee.id_card,sum(emp_loan.loan_amt),sum(emp_loan.return_amt),sum(emp_loan.remaining_amt),emp_loan.created_date")
				->from("employee")
				->join("( SELECT * from {$this->db->dbprefix('employee_loan')} ) emp_loan", 'employee.id=emp_loan.empid', 'right')
				//->where('emp_loan.empid',$empid)
				->group_by('empid');
			 if ($start_date) {
				$this->datatables->where('emp_loan.created_date BETWEEN "' . date("Y-m-d",strtotime($start_date)) . '" and "' . date("Y-m-d",strtotime($end_date)) . '"');
				}	
			if ($empid!='') {
				$this->datatables->where('emp_loan.empid',$empid);
				}		
			//$this->datatables->unset_column('id');
		}
        echo $this->datatables->generate();
    }

    function add()
    {
		// $this->form_validation->set_rules('comment', lang("comment"), 'required|min_length[3]');
		$this->form_validation->set_rules('e_name', 'e_name', 'required');
		$this->form_validation->set_rules('mobile', 'mobile', 'required');
		$this->form_validation->set_rules('id_card_expire', 'id_card_expire', 'required');
		$this->form_validation->set_rules('Health_Insurance', 'Health Insurance', 'required');
		$this->form_validation->set_rules('email', 'email', 'required');
		$this->form_validation->set_rules('address', 'address', 'required');
        if ($this->form_validation->run() == true) {
            $data = array(
				'e_name' => $this->input->post('e_name'),
				'mobile' => $this->input->post('mobile'),
				'id_card' => $this->input->post('id_card'),
				'id_card_expire' => $this->input->post('id_card_expire'),
				'Vehicle_insurance' => $this->input->post('Vehicle_insurance'),
				'Vehicle_insurance_expire' => $this->input->post('Vehicle_insurance_expire'),
				'Health_Insurance' => $this->input->post('Health_Insurance'),
				'email' => $this->input->post('email'),
				'address' => $this->input->post('address'),
				'Calculation_Finance' => $this->input->post('Calculation_Finance'),
				'salary' => $this->input->post('salary'),
				'id_card_renewal_fee' => $this->input->post('id_card_renewal_fee'),
				'ministry_of_labor_fee' => $this->input->post('ministry_of_labor_fee'),
				'insurance_renewal_fee' => $this->input->post('insurance_renewal_fee'),
				'vehicle_insurance_fee' => $this->input->post('vehicle_insurance_fee'),
				'health_insurance_fee' => $this->input->post('health_insurance_fee'),
				'account_holder' => $this->input->post('account_holder'),
				'bank_name' => $this->input->post('bank_name'),
				'account_number' => $this->input->post('account_number'),
				'iban_number' => $this->input->post('iban_number'),
				
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("Employee");
        }

        if ($this->form_validation->run() == true && $this->cmt_model->addEmployee($data)) {
            $this->session->set_flashdata('message', lang("Employee Added"));
            admin_redirect("Employee");
        } else {

            $this->data['e_name'] = array('name' => 'e_name',
                'id' => 'e_name',
                'type' => 'text',
                'class' => 'form-control',
                'required' => 'required',
                'value' => $this->form_validation->set_value('e_name'),
            );

            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employees/add', $this->data);

        }
    
	
	}
	
	
	function add_loan($empid=NULL)
    {
		
		// $this->form_validation->set_rules('comment', lang("comment"), 'required|min_length[3]');
		$this->form_validation->set_rules('loan_amt', 'loan_amt', 'required');
        $this->form_validation->set_rules('note', 'note', 'required');
        $this->form_validation->set_rules('account', 'Bank Account', 'required');
        $this->load->admin_model('pos_model');
        
        if ($this->form_validation->run() == true) {
            $loan = $this->input->post('loan_amt');
			$data = array(
                'loan_amt' => round($loan,2),
                'note' => $this->input->post('note'),
				'empid' => $this->input->post('empid'),
				'remaining_amt' => $this->input->post('loan_amt'),
				
            );

            if($this->input->post('account') > 0){
                $bank_id = $this->input->post('account');
                $bank_balance = $this->pos_model->getBankBalance($bank_id);
                if($bank_balance < round($loan,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/loan/".$this->input->post('empid'));
                }
            }

            if($this->input->post('account_store') > 0)
			{
				$store_id = $this->input->post('account_store');
                $store_id = (trim($store_id) != '') ? $store_id : 0;
                $store_balance = $this->pos_model->getStoreBalance($store_id); 
                if($store_balance < round($loan,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/loan/".$this->input->post('empid'));
                }
            }
            
            if($this->input->post('account_warehouse') > 0)
			{
				$warehouse_id = $this->input->post('account_warehouse');
                $warehouse_id = (trim($warehouse_id) != '') ? $warehouse_id : 0;
                $warehouse_balance = $this->pos_model->getWarehouseBalance($warehouse_id); 
                if($warehouse_balance < round($loan,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/loan/".$this->input->post('empid'));
                }
            }

            $last_id = $this->cmt_model->addLoan($data);
            
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("Employee/loan/".$this->input->post('empid'));
        }

        if ($this->form_validation->run() == true &&  $last_id > 0) {

            unset($data);
			$data = array(
				'user_id' => $this->session->userdata('user_id'),
				'amount' => (round($loan,2) * -1),
				'note' => $this->input->post('note'),
				'bank_id' => $this->input->post('account') ? $this->input->post('account') : 0,
				'store_id' => $this->input->post('account_store') ? $this->input->post('account_store') : 0,
				'bank_deposit_reference_no' => '',//$this->input->post('bank_deposit_reference_no'),
				'added_on' => date('Y-m-d H:i:s'),//,strtotime(str_replace('/','-',$this->input->post('trans_date')))),
				'added_by' => $this->session->userdata('user_id'),
				'trasaction_type' => 'minus',
				'type' => 'loan',
				'type_id' => $this->input->post('account_warehouse') ? $this->input->post('account_warehouse') : 0,
			);
			
            $this->pos_model->addTransaction($data);

            $transaction_id = $this->db->insert_id();

            if($transaction_id > 0 ){
                $this->db->update('employee_loan', array('transaction_id' => $transaction_id), array('id' => $last_id));
            }
            
            $this->session->set_flashdata('message', lang("Loan Added"));
            admin_redirect("Employee/loan/".$this->input->post('empid'));
        } else {

            $employee = $this->cmt_model->getEmployeeByID($empid);

            $this->data['employee'] = $employee;

            $this->data['accounts'] = $this->cmt_model->getExpenseAccount();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
            
            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employees/add_loan', $this->data);

        }
    
	
	}
	
	function edit_loan($id = NULL)
    {
		if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
		
		if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }
		
		$loan = $this->cmt_model->getLoanByID($id);
       
        $transaction = $this->cmt_model->gettransactionByID($loan->transaction_id);
		$empid = $loan->empid;
		
		$return_amt = trim($loan->return_amt) + trim($this->input->post('return_amt'));
		
		$remaining_amt = trim($loan->loan_amt) - trim($return_amt);
		

        $this->form_validation->set_rules('return_amt', 'return_amt', 'required');
        $this->form_validation->set_rules('account', 'Bank Account', 'required');
       
        if ($this->form_validation->run() == true) {
			$loan_summery = $loan->loan_summery;
			$dataStr = "";
			if($loan_summery!='')
			{
				$loan_summery = $loan->loan_summery;
				$dataStr = date("Y-m-d H:i:s")."*".$this->input->post('return_amt')."|".$loan_summery;
			}
			else
			{
				$dataStr = date("Y-m-d H:i:s")."*".$this->input->post('return_amt');
			}
			
			$loan_summery = $dataStr;
            $data = array(
                'return_amt' => $return_amt,
				'return_date' => date("Y-m-d H:i:s"),
				'remaining_amt' => $remaining_amt,  
				'loan_summery' => $loan_summery,              
            );

            if($this->input->post('account') > 0){
                $bank_id = $this->input->post('account');
            }

            if($this->input->post('account_store') > 0)
			{
				$store_id = $this->input->post('account_store');
                $store_id = (trim($store_id) != '') ? $store_id : 0;
            }
            
            if($this->input->post('account_warehouse') > 0)
			{
				$warehouse_id = $this->input->post('account_warehouse');
                $warehouse_id = (trim($warehouse_id) != '') ? $warehouse_id : 0;
            }

        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("Employee/loan/".$empid);
        }

        if ($this->form_validation->run() == true && $this->cmt_model->updateLoan($id,$data)) {

            unset($data);
			$data = array(
				'user_id' => $this->session->userdata('user_id'),
				'amount' => (round(trim($this->input->post('return_amt')),2)),
				'note' => '',
				'bank_id' => $this->input->post('account') ? $this->input->post('account') : 0,
				'store_id' => $this->input->post('account_store') ? $this->input->post('account_store') : 0,
				'bank_deposit_reference_no' => '',//$this->input->post('bank_deposit_reference_no'),
				'added_on' => date('Y-m-d H:i:s'),//,strtotime(str_replace('/','-',$this->input->post('trans_date')))),
				'added_by' => $this->session->userdata('user_id'),
				'trasaction_type' => 'plus',
				'type' => 'loan',
				'type_id' => $this->input->post('account_warehouse') ? $this->input->post('account_warehouse') : 0,
			);
			
            $this->pos_model->addTransaction($data);


            $this->session->set_flashdata('message', lang("Employee Added"));
            admin_redirect("Employee/loan/".$empid);
        } else {

            $employee = $this->cmt_model->getEmployeeByID($empid);

            $this->data['loan'] = $loan;
            $this->data['transaction'] = $transaction;
            $this->data['employee'] = $employee;
            $this->data['id'] = $id;
            $this->data['accounts'] = $this->cmt_model->getExpenseAccount();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
			$this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employees/edit_loan', $this->data);

        }
    }
	
	function add_salary($empid=NULL)
    {		
		//$this->form_validation->set_rules('salary_amt', 'salary_amt', 'required');
		$this->form_validation->set_rules('month', 'Salary for Month', 'required');
		$this->form_validation->set_rules('unpaid_leaves', 'Unpaid Leaves', 'required');
		$this->form_validation->set_rules('note', 'Note', 'required');
		$this->form_validation->set_rules('account', 'Bank Account', 'required');
		$this->load->admin_model('pos_model');
		
        if ($this->form_validation->run() == true) 
		{
            //$from_date = date_create($this->input->post('from_date'));
			//$to_date = date_create($this->input->post('to_date'));
			//$days = date_diff($from_date,$to_date) - trim($this->input->post('unpaid_leaves'));
			$days = cal_days_in_month(CAL_GREGORIAN, trim($this->input->post('month')), trim($this->input->post('year')));			
			$salary = $this->input->post('salary');
			$salary = $salary / $days;
			$salary = $salary * ($days - trim($this->input->post('unpaid_leaves')));
            $data = array(
                'salary_amt' => round($salary,2),
                'note' => $this->input->post('note'),
                'total_unpaid_leaves' => $this->input->post('unpaid_leaves'),
                'salary_period' => $this->input->post('month').'/'.trim($this->input->post('year')),
                'empid' => $this->input->post('empid'), 
                'created_by' => $this->session->userdata('user_id'), 
            );

            if($this->input->post('account') > 0){
                $bank_id = $this->input->post('account');
                $bank_balance = $this->pos_model->getBankBalance($bank_id);
                if($bank_balance < round($salary,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/salary/".$this->input->post('empid'));
                }
            }

            if($this->input->post('account_store') > 0)
			{
				$store_id = $this->input->post('account_store');
                $store_id = (trim($store_id) != '') ? $store_id : 0;
                $store_balance = $this->pos_model->getStoreBalance($store_id); 
                if($store_balance < round($salary,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/salary/".$this->input->post('empid'));
                }
            }
            
            if($this->input->post('account_warehouse') > 0)
			{
				$warehouse_id = $this->input->post('account_warehouse');
                $warehouse_id = (trim($warehouse_id) != '') ? $warehouse_id : 0;
                $warehouse_balance = $this->pos_model->getWarehouseBalance($warehouse_id); 
                if($warehouse_balance < round($salary,2)){
                    $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                    admin_redirect("Employee/salary/".$this->input->post('empid'));
                }
			}
				
			$last_id = $this->cmt_model->addSalary($data);					
        } 
		elseif ($this->input->post('submit')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("Employee/salary/".$this->input->post('empid'));
        }


        if ($this->form_validation->run() == true && $last_id > 0) 
		{
			unset($data);
			$data = array(
				'store_id' => 0,
				'user_id' => $this->session->userdata('user_id'),
				'amount' => (round($salary,2) * -1),
				'note' => $this->input->post('note'),
				'bank_id' => $this->input->post('account') ? $this->input->post('account') : 0,
				'store_id' => $this->input->post('account_store') ? $this->input->post('account_store') : 0,
				'bank_deposit_reference_no' => '',//$this->input->post('bank_deposit_reference_no'),
				'added_on' => date('Y-m-d H:i:s'),//,strtotime(str_replace('/','-',$this->input->post('trans_date')))),
				'added_by' => $this->session->userdata('user_id'),
				'trasaction_type' => 'minus',
				'pay_id'    => $last_id,
				'type' => 'salary',
				'type_id' => $this->input->post('account_warehouse') ? $this->input->post('account_warehouse') : 0,
			);
			
			$this->pos_model->addTransaction($data);
			
            $this->session->set_flashdata('message', lang("Salary Added"));
            admin_redirect("Employee/salary/".$this->input->post('empid'));
        } 
		else 
		{
            $employee = $this->cmt_model->getEmployeeByID($empid);
			//echo '<pre>';print_r($employee);exit;
            $this->data['employee'] = $employee;
			$this->data['accounts'] = $this->cmt_model->getExpenseAccount();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
			//echo '<pre>';print_r($this->data['accounts']);exit;
            $this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employees/add_salary', $this->data);
        }	
	}
	
	
	
    function edit($id = NULL)
    {
		if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
		
		if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

        $this->form_validation->set_rules('e_name', 'e_name', 'required');
		$this->form_validation->set_rules('mobile', 'mobile', 'required');
		$this->form_validation->set_rules('id_card_expire', 'id_card_expire', 'required');
		$this->form_validation->set_rules('Health_Insurance', 'Health Insurance', 'required');
		$this->form_validation->set_rules('email', 'email', 'required');
		$this->form_validation->set_rules('address', 'address', 'required');
        if ($this->form_validation->run() == true) {
            $data = array(
                'e_name' => $this->input->post('e_name'),
				'mobile' => $this->input->post('mobile'),
				'id_card' => $this->input->post('id_card'),
				'id_card_expire' => $this->input->post('id_card_expire'),
				'Vehicle_insurance' => $this->input->post('Vehicle_insurance'),
				'Vehicle_insurance_expire' => $this->input->post('Vehicle_insurance_expire'),
				'Health_Insurance' => $this->input->post('Health_Insurance'),
				'email' => $this->input->post('email'),
				'address' => $this->input->post('address'),
				'Calculation_Finance' => $this->input->post('Calculation_Finance'),
				'salary' => $this->input->post('salary'),
				'id_card_renewal_fee' => $this->input->post('id_card_renewal_fee'),
				'ministry_of_labor_fee' => $this->input->post('ministry_of_labor_fee'),
				'insurance_renewal_fee' => $this->input->post('insurance_renewal_fee'),
				'vehicle_insurance_fee' => $this->input->post('vehicle_insurance_fee'),
				'health_insurance_fee' => $this->input->post('health_insurance_fee'),
				'account_holder' => $this->input->post('account_holder'),
				'bank_name' => $this->input->post('bank_name'),
				'account_number' => $this->input->post('account_number'),
				'iban_number' => $this->input->post('iban_number'),
                
            );
        } elseif ($this->input->post('submit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("employee");
        }

        if ($this->form_validation->run() == true && $this->cmt_model->updateEmployee($id,$data)) {
            $this->session->set_flashdata('message', lang("Employee Added"));
            admin_redirect("employee");
        } else {

            $employee = $this->cmt_model->getEmployeeByID($id);

            $this->data['employee'] = $employee;
            $this->data['id'] = $id;
			$this->data['error'] = validation_errors();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'employees/edit', $this->data);

        }
    }
	
	function view_emp_info($id = NULL)
    {
		if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
		
		if ($this->input->post('id')) {
            $id = $this->input->post('id');
        }

		$employee = $this->cmt_model->getEmployeeByID($id);
		
		$empid = $employee->id;
		$loan = $this->cmt_model->getLoanByEmpID($empid);
		
		$salary = $this->cmt_model->getSalaryByEmpID($empid);

		$this->data['employee'] = $employee;
		$this->data['loan'] = $loan;
		$this->data['salary'] = $salary;
		$this->data['id'] = $id;
		$this->data['error'] = validation_errors();
		$this->data['modal_js'] = $this->site->modal_js();
		$this->load->view($this->theme . 'employees/view', $this->data);
    }

    function delete($id = NULL)
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->cmt_model->deleteEmployee($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("Employee Deleted")));
        }
    }
	
	function delete_loan($id = NULL)
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->cmt_model->deleteLoan($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("Loan Deleted")));
        }
    }
	function delete_salary($id = NULL)
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->cmt_model->deleteSalary($id))
		{
			
            $this->sma->send_json(array('error' => 0, 'msg' => lang("Salary Deleted")));
        }
    }

}
