<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-folder-open"></i><?= lang('Warehouse_Transactions'); ?></h2> 
		
		<div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                        <i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang("actions") ?>"></i>
                    </a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
						<li>
                            <a href="<?php echo admin_url('system_settings/warehouse_to_store'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> Warehouse to Store Transfer <?php //echo lang('add_warehouse') ?>
                            </a>
                        </li>
						<li>
                            <a href="<?php echo admin_url('system_settings/warehouse_to_bank'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> Warehouse to Bank Transfer <?php //echo lang('add_warehouse') ?>
                            </a>
                        </li>   
						 <li>
                            <a href="#" id="excel" data-action="export_excel">
                                <i class="fa fa-file-excel-o"></i> <?= lang('export_to_excel') ?>
                            </a>
                        </li>
						<li>
                            <a href="#" id="pdf" data-action="combine">
                                <i class="fa fa-file-pdf-o"></i> Export to PDF
							</a>
                        </li>                     
                    </ul>
                </li>
            </ul>
        </div>       
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><? //lang('list_results'); ?></p>
                <div class="table-responsive">
					<div class="row" style="margin-bottom:18px;">
						<form action="<?php echo base_url().'admin/system_settings/warehouse_transactions';?>" method="get" name="search_form" id="search_form">
							<div class="col-md-3 text-left">
								<div class="">
									<select name="warehouse_id" class="form-control" id="warehouse_id" required>
										<option value=""><?= ucwords(lang('warehouse')); ?></option>
										<?php foreach($stores as $store){?>
										<option value="<?php echo $store->id?>"><?php echo $store->name;?></option>
										<?php }?>
									</select>
								</div>
							</div>
							<div class="col-md-3 text-left">
								<div class="dataTables_filter">
									<input type="text" name="date_from" value="<?php echo $from_date;?>" class="input-xs datetime" placeholder="From Date">
								</div>
							</div>
							<div class="col-md-3 text-left"> 	
								<div class="dataTables_filter">
									<input type="text" name="date_to" value="<?php echo $to_date;?>" class="input-xs datetime" placeholder="To Date">
								</div>
							</div>
							<div class="col-md-3 text-left"> 	
								<div class="dataTables_filter">
										<input type="submit" name="submit" class="btn btn-info btn-sm" value="Search">
										<a href="<?php echo base_url().'admin/system_settings/warehouse_transactions';?>" class="btn btn-success btn-sm">Reset</a>
								</div>
							</div>
						</form>
					</div>
					<p class="introtext"><? //lang('list_results'); ?></p>
                    <table class="table table-hover table-striped reports-table">
                        <thead>
                            <tr>
                                <th><?= lang("User"); ?></th>
                                <th style="text-align:center;"><?= lang("Warehouse"); ?></th>
                                <th style="text-align:center;"><?= lang("bank_name"); ?> / <?= lang("Store"); ?></th>
                                <th style="text-align:center;"><?= lang("Amount"); ?></th>
                                <th style="text-align:center;"><?= ucwords(lang("Added_On")); ?></th>
                                <th style="text-align:center;"><?= lang("Type"); ?></th>
                                <th style="text-align:center;"><?= lang("Note"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
						<?php if(!empty($transactions)){
								$type = array('sminus'=>'Store to Sale Register', 'splus'=>'Sale Register to Store','stb'=>'Store to Bank', 'bts'=>'Bank to Store', 'b' => 'Bank Deposit', 'bw' => 'Bank Withdraw', 'wts' => 'Warehouse to Store', 'stw' => 'Store to Warehouse', 'wtb' => 'Warehouse to Bank', 'btw' => 'Bank to Warehouse', 'purchase' => 'Purchase Payment', 'expense' => 'Expense', 'vat'=>'VAT Deducted from Bank', 'salary'=>'Salary Deducted');
								foreach($transactions as $transaction){?>
                            <tr>
                                <td><?php echo $transaction->username;?></td>
                                <td class="text-center"><?php echo $transaction->warehouse;?></td>
                                <td class="text-center"><?php echo ($transaction->bank_name != '') ? $transaction->bank_name : '';?><?php echo ($transaction->name != '') ? $transaction->name : '';?></td>
                                <td class="text-center"><?php echo $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;?></td>
                                <td class="text-center"><?php echo date('F d, Y',strtotime($transaction->added_on));?></td>
                                <td class="text-center"><?php echo ($transaction->type == 's') ? $type[$transaction->type.$transaction->trasaction_type] : $type[$transaction->type];?></td>
                                <td class="text-center"><?php echo $transaction->note;?></td>
                            </tr>
						<?php }}else{?>	
							<tr>
								<td colspan="7">No record found!!!</td>
							</tr>
						<?php }?>
                        </tbody>
						<?php if(isset($links)){?>
						<tfoot>
							<tr>
								<td colspan="7" align="center"><div id="page-nation"><?php echo $links;?></div></td>    
							</tr>
						</tfoot>
						<?php }?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?= admin_form_open('system_settings/transactions_actions', 'id="action-form"') ?>
<div style="display: none;">
    <input type="hidden" name="form_action" value="" id="form_action"/>
	<input type="hidden" name="hidden_date_from" id="hidden_date_from">
	<input type="hidden" name="hidden_date_to" id="hidden_date_to">
	<input type="hidden" name="hidden_warehouse_id" id="hidden_warehouse_id">
	<input type="hidden" name="hidden_store_id" id="hidden_store_id" value="0">
    <?= form_submit('submit', 'submit', 'id="action-form-submit"') ?>
</div>
<?= form_close() ?>
<style type="text/css">
#page-nation a{
	padding: 7px 10px;
	color: #fff;
    background-color: #428bca;
    border: #fff 1px solid;
}
#page-nation strong{
    color: #777;
	padding: 6px 9px;
    cursor: not-allowed;
    background-color: #fff;
    border: #428bca 1px solid;
}
</style>
<script language="javascript">
    $(document).ready(function () {
	
        $('#excel').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#hidden_date_from').val($('#date_from').val());
            $('#hidden_date_to').val($('#date_to').val());
			$('#hidden_warehouse_id').val($('#warehouse_id').val());
            $('#action-form-submit').trigger('click');
        });

        $('#pdf').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#hidden_date_from').val($('#date_from').val());
            $('#hidden_date_to').val($('#date_to').val());
            $('#hidden_warehouse_id').val($('#warehouse_id').val());
            $('#action-form-submit').trigger('click');
        });

    });
</script>

