<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
$type = array('sminus'=>'Store to Sale Register', 'splus'=>'Sale Register to Store','stb'=>'Store to Bank', 'bts'=>'Bank to Store', 'b' => 'Bank Deposit', 'bw' => 'Bank Withdraw', 'wts' => 'Warehouse to Store', 'stw' => 'Store to Warehouse', 'wtb' => 'Warehouse to Bank', 'btw' => 'Bank to Warehouse', 'purchase' => 'Purchase Payment', 'expense' => 'Expense', 'vat'=>'VAT Deducted from Bank', 'salary'=>'Salary Deducted', 'loan'=>'Employee Loan');?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-folder-open"></i><?= lang('Transactions'); ?></h2>
		<div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                        <i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang("actions") ?>"></i>
                    </a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
                        <li>
                            <a href="#" id="excel" data-action="export_excel">
                                <i class="fa fa-file-excel-o"></i> <?= lang('export_to_excel') ?>
                            </a>
                        </li>
						<li>
                            <a href="#" id="pdf" data-action="combine">
                                <i class="fa fa-file-pdf-o"></i> Export to PDF
							</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><? //lang('list_results'); ?></p>
                <div class="table-responsive">
					<div class="row" style="margin-bottom:18px;">
						<form action="<?php echo base_url().'admin/system_settings/transactions';?>" method="get" name="search_form" id="search_form">
							<div class="row">
								<div class="col-md-3 text-left">
									<div class="">
										<select name="type" class="form-control" id="type">
											<option value=""><?= ucwords(lang('transaction type')); ?></option>
											<?php foreach($type as $key => $val){?>
											<option value="<?php echo $key?>"><?php echo $val;?></option>
											<?php }?>
										</select>
									</div>
								</div>
								<div class="col-md-3 text-left warehouse">
									<div class="">
										<select name="warehouse" class="form-control" id="warehouse">
											<option value=""><?= ucwords(lang('warehouse')); ?></option>
											<?php foreach($warehouses as $warehouse){?>
											<option value="<?php echo $warehouse->id?>"><?php echo $warehouse->name;?></option>
											<?php }?>
										</select>
									</div>
								</div>
								<div class="col-md-3 text-left store_id">
									<div class="">
										<select name="store_id" class="form-control" id="store_id">
											<option value="0"><?= ucwords(lang('store')); ?></option>
											<?php foreach($stores as $store){?>
											<option value="<?php echo $store->id?>"><?php echo $store->name;?></option>
											<?php }?>
										</select>
									</div>
								</div>
								<div class="col-md-3 text-left bank">
									<div class="">
										<select name="bank" class="form-control" id="bank">
											<option value=""><?= ucwords(lang('bank')); ?></option>
											<?php foreach($banks as $bank){?>
											<option value="<?php echo $bank->id?>"><?php echo $bank->bank_name.' '.$bank->account_number;?></option>
											<?php }?>
										</select>
									</div>
								</div>
							</div>
							<div class="row" style="margin-top:15px;">
								<div class="col-md-3 text-left">
									<div class="dataTables_filter">
										<input type="text" name="date_from" value="<?php echo $from_date;?>" class="input-xs date" placeholder="From Date">
									</div>
								</div>
								<div class="col-md-3 text-left"> 	
									<div class="dataTables_filter">
										<input type="text" name="date_to" value="<?php echo $to_date != '' ? date('d/m/Y',strtotime($to_date)) : '';?>" class="input-xs date" placeholder="To Date">
									</div>
								</div>
								<div class="col-md-3 text-left"> 	
									<div class="">
										<input type="text" name="txn" value="<?php echo $txn;?>" class="form-control input-xs" placeholder="Reference No.">
									</div>
								</div>
								<div class="col-md-3 text-left"> 	
									<div class="dataTables_filter">
											<input type="submit" name="submit" class="btn btn-info btn-sm" value="Search">
											<a href="<?php echo base_url().'admin/system_settings/transactions';?>" class="btn btn-success btn-sm">Reset</a>
									</div>
								</div>
							</div>
						</form>
					</div>
					<p class="introtext"><? //lang('list_results'); ?></p>
                    <table class="table table-hover table-striped reports-table">
                        <thead>
                            <tr>
                                <th><?= lang("User"); ?></th>
                                <th style="text-align:center;"><?= lang("warehouse"); ?> / <?= lang("Store"); ?></th>
                                <th style="text-align:center;"><?= lang("bank_name"); ?></th>
                                <th style="text-align:center;"><?= lang("Amount"); ?></th>
                                <th style="text-align:center;"><?= ucwords(lang("Added_On")); ?></th>
                                <th style="text-align:center;"><?= lang("Type"); ?></th>
                                <th style="text-align:center;"><?= lang("Note"); ?></th>
								<?php if ($Owner || $Admin) {?>
                                <th style="text-align:center;"><?= lang("Action"); ?>&nbsp;<a class="btn btn-xs btn-danger" title="Delete" data-toggle="tooltip" href="javascript:;" data-original-title="Delete" onClick="deleteTableEntry(-1);">Delete All <i class="fa fa-times"></i></a></th>
								<?php }?>
                            </tr>
                        </thead>
                        <tbody>
						<?php if(!empty($transactions)){
								foreach($transactions as $transaction){
									$url = base_url().'admin/system_settings/transaction_view/';?>
                            <tr style="cursor:pointer;">
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>"><?php echo $transaction->username;?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo ($transaction->name != '') ? $transaction->name : ($transaction->warehouse != '' ? $transaction->warehouse : '--');?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo ($transaction->bank_name != '') ? $transaction->bank_name : '--';?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo date('F d, Y',strtotime($transaction->added_on));?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo ($transaction->type == 's') ? ($transaction->note == 'Sales' ? 'Sales Amount to Store' : ($transaction->note == 'Sales Return' ? 'Amount Deducted from Store' : $type[$transaction->type.$transaction->trasaction_type])) : $type[$transaction->type];?></td>
                                <td data-toggle="modal" data-target="#myModal" href="<?php echo $url.$transaction->id;?>" class="text-center"><?php echo $transaction->note;?></td>
								<?php if ($Owner || $Admin) {?>
								<td class="text-center"><a class="btn btn-xs btn-danger" title="Delete" data-toggle="tooltip" href="javascript:;" data-original-title="Delete" onClick="deleteTableEntry('<?php echo trim($transaction->id);?>');">Delete <i class="fa fa-times"></i></a> </td>
								<?php }?>
                            </tr>
						<?php }}else{?>	
							<tr>
								<td colspan="7">No record found!!!</td>
							</tr>
						<?php }?>
                        </tbody>
						<?php if(isset($links)){?>
						<tfoot>
							<tr>
								<td colspan="8" align="center"><div id="page-nation"><?php echo $links;?></div></td>    
							</tr>
						</tfoot>
						<?php }?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?= admin_form_open('system_settings/transactions_actions', 'id="action-form"') ?>
<div style="display: none;">
    <input type="hidden" name="form_action" value="" id="form_action"/>
	<input type="hidden" name="hidden_date_from" id="hidden_date_from">
	<input type="hidden" name="hidden_date_to" id="hidden_date_to">
	<input type="hidden" name="hidden_type" id="hidden_type">
	<input type="hidden" name="hidden_warehouse" id="hidden_warehouse">
	<input type="hidden" name="hidden_store_id" id="hidden_store_id">
	<input type="hidden" name="hidden_bank" id="hidden_bank">
    <?= form_submit('submit', 'submit', 'id="action-form-submit"') ?>
</div>
<?= form_close() ?>
<style type="text/css">
#page-nation a{
	padding: 7px 10px;
	color: #fff;
    background-color: #428bca;
    border: #fff 1px solid;
}
#page-nation strong{
    color: #777;
	padding: 6px 9px;
    cursor: not-allowed;
    background-color: #fff;
    border: #428bca 1px solid;
}
</style>
<script language="javascript">

	function deleteTableEntry(id)
	{
		var confirmDelete = confirm('Are you sure to delete ?');
		if (confirmDelete == true)
		{ 
			$('.close').click();
			$.ajax({
				type : "GET",
				url : '<?php echo base_url().'admin/system_settings/delete_transactions/';?>'+id,
				dataType : "html",
				success: function(data) {
					
					location.reload();
					//$('#tr_'+de_utoa(id)+'').remove();
				},
				error : function() {
					alert("Sorry, The requested property could not be found.");
				}		
			});
		}
	}
	
    $(document).ready(function () {
		$('#type').val('<?php echo $ttype;?>');
		$('#bank').val(<?php echo $tbank;?>);
		$('#warehouse').val(<?php echo $twarehouse?>);
		$('#store_id').val(<?php echo $store_id?>);
		
		$('#type').change(function(e) {
			if($(this).val() == 'sminus' || $(this).val() == 'splus')
			{
				$('.bank,.warehouse').fadeOut(100);
				$('.store_id').fadeIn(150);
				$('#bank,#warehouse').val('');
			}
			else if($(this).val() == 'stb' || $(this).val() == 'bts' || $(this).val() == 'salary' || $(this).val() == 'loan')
			{
				$('.bank,.store_id,.warehouse').fadeIn(150);
			}
			else if($(this).val() == 'b' || $(this).val() == 'bw' || $(this).val() == 'vat')
			{
				$('.warehouse,.store_id').fadeOut(100);
				$('.bank').fadeIn(150);
				$('#warehouse').val('');
				$('#store_id').val('0');
			}
			else if($(this).val() == 'wts' || $(this).val() == 'stw')
			{
				$('.bank').fadeOut(100);
				$('.warehouse,.store_id').fadeIn(150);
				$('#bank').val('');
			}
			else if($(this).val() == 'wtb' || $(this).val() == 'btw')
			{
				$('.store_id').fadeOut(100);
				$('.warehouse,.bank').fadeIn(150);
				$('#store_id').val('0');
			}
		});
		
		$('#bank').change(function(e) {
			if($(this).val() != '' && ($('#type').val() == 'expense' || $('#type').val() == 'purchase'))
			{
				$('#warehouse,#store_id').val('');
			}
		});
		
		$('#warehouse,#store_id').change(function(e) {
			if($(this).val() != '' && ($('#type').val() == 'expense' || $('#type').val() == 'purchase'))
			{
				$('#bank').val('');
			}
		});
		
		var str = '<?php echo $store_id;?>';
        $('#excel').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#hidden_date_from').val($('#date_from').val());
            $('#hidden_date_to').val($('#date_to').val());
			
            $('#hidden_type').val($('#type').val());
            $('#hidden_warehouse').val($('#warehouse').val());
            $('#hidden_bank').val($('#bank').val());
			
			if($('#store_id').val() == '0')
			{
				$('#hidden_store_id').val(str);
			}
			else
			{
            	$('#hidden_store_id').val($('#store_id').val());
			}
            $('#action-form-submit').trigger('click');
        });

        $('#pdf').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#hidden_date_from').val($('#date_from').val());
            $('#hidden_date_to').val($('#date_to').val());
			
            $('#hidden_type').val($('#type').val());
            $('#hidden_warehouse').val($('#warehouse').val());
            $('#hidden_bank').val($('#bank').val());
			
            if($('#store_id').val() == '0')
			{
				$('#hidden_store_id').val(str);
			}
			else
			{
            	$('#hidden_store_id').val($('#store_id').val());
			}
            $('#action-form-submit').trigger('click');
        });

    });
	
	$(document).ready(function () {	
		$('#warehouse').change(function () {
			var v = $(this).val();
			getStoresNew(v);
		});
	});
	
	function getStoresNew(v)	
	{
		if (v) 
		{
			$.ajax({
				type: "get",
				async: false,
				url: "<?= admin_url('products/getStores') ?>/" + v,
				dataType: "json",
				success: function (scdata) {
					if (scdata != null) 
					{					
						$("#store_id").select2("destroy").empty().attr("placeholder", "Select Store");
						var html = '<option value="">Select Store</option>';
						for(var i = 0; i < scdata.length; i++)
						{
							html += '<option value="'+scdata[i].id+'">'+scdata[i].text+'</option>';
						}
						$("#store_id").html(html);
						$("#store_id").select2({placeholder: "Select Store"});	
					} 
					else 
					{
						var html = '<option value="">Select Store</option>';
						$("#store_id").html(html);
						$("#store_id").select2({placeholder: "Select Store"});	
					}
				},
				error: function () {
					bootbox.alert('<?= lang('ajax_error') ?>');
				}
			});
		}
	}
</script>