<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
	<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i> </button>
			<h4 class="modal-title" id="myModalLabel"><?php echo ucwords(lang('deposit_to_bank')); ?></h4>
		</div>
		<?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open_multipart("system_settings/deposit_to_bank", $attrib); ?>
		<div class="modal-body">
			<p>
				<?= lang('enter_info'); ?>
			</p>
			<div class="form-group">
				<?= lang('amount', 'amount'); ?>
				<?= form_input('amount', set_value('amount'), 'class="form-control" id="amount" required="required"'); ?>
			</div>
			<div class="form-group">
				<label for="store"><?= ucwords(lang('store')); ?></label>
				<select name="store" class="form-control" id="store" required title="<?= ucwords(lang('store')); ?>">
					<option value=""><?= ucwords(lang('store')); ?></option>
					<?php foreach($stores as $store){?>
					<option value="<?php echo $store->id?>"><?php echo $store->name;?></option>
					<?php }?>
				</select>
			</div>	
			<div class="form-group">
				<label for="bank"><?= ucwords(lang('bank')); ?></label>
				<select name="bank" class="form-control" id="bank" required title="<?= ucwords(lang('bank')); ?>">
					<option value=""><?= ucwords(lang('bank')); ?></option>
					<?php foreach($banks as $bank){?>
					<option value="<?php echo $bank->id?>"><?php echo $bank->account_title.' - '.$bank->account_number?></option>
					<?php }?>
				</select>
			</div>			
			<div class="form-group">
				<label for="bank_deposit_reference_no"><?= ucwords(lang('bank_deposit_reference_no')); ?></label>
				<?= form_input('bank_deposit_reference_no', '', 'class="form-control" id="bank_deposit_reference_no" required'); ?>
			</div>		
			<div class="form-group">
				<?= lang('date', 'trans_date'); ?>
				<?= form_input('trans_date', set_value('trans_date'), 'class="form-control date" id="trans_date" required="required"'); ?>
			</div>		
			<div class="form-group">
				<?= lang('note', 'note'); ?>
				<?= form_input('note', set_value('note'), 'class="form-control" id="note" required="required"'); ?>
			</div>	
		</div>
		<div class="modal-footer"> <?php echo form_submit('deposit_to_bank', ucwords(lang('deposit_to_bank')), 'class="btn btn-primary"'); ?> </div>
	</div>
	<?php echo form_close(); ?> </div>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
<?= $modal_js ?>
<script>
    $(document).ready(function() {
        $('.gen_slug').change(function(e) {
            getSlug($(this).val(), 'category');
        });
    });
</script>