<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php /*?><script>
    $(document).ready(function () {
        oTable = $('#BankAccountsTable').dataTable({
            "aaSorting": [[3, "asc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?= lang('all') ?>"]],
            "iDisplayLength": <?= $Settings->rows_per_page ?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= admin_url('system_settings/getBankAccounts') ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            "aoColumns": [{"bSortable": false, "mRender": checkbox}, {"bSortable": false}, null, null, null, null, {"bSortable": false}]
        });
    });
</script><?php */?>
<?= admin_form_open('system_settings/bank_account_actions', 'id="action-form"') ?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa-fw fa fa-folder-open"></i><?= lang('bank_accounts'); ?></h2>

        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                        <i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang("actions") ?>"></i>
                    </a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
                        <li>
                            <a href="<?php echo admin_url('system_settings/add_bank_account'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= lang('add_bank_account') ?>
                            </a>
                        </li>
						<li class="divider"></li>
                        <li>
                            <a href="<?php echo admin_url('system_settings/bank_deposit'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= ucwords(lang('direct_deposit_to_bank')) ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo admin_url('system_settings/bank_withdraw'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= ucwords(lang('bank_withdraw')) ?>
                            </a>
                        </li>
						<li>
                            <a href="<?php echo admin_url('system_settings/deposit_to_store'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= ucwords(lang('bank_to_store')) ?>
                            </a>
                        </li>
						<li>
                            <a href="<?php echo admin_url('system_settings/bank_to_warehouse'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus"></i> <?= ucwords(lang('bank_to_warehouse')) ?>
                            </a>
                        </li>
						<li class="divider"></li>
                        <li>
                            <a href="#" id="excel" data-action="export_excel">
                                <i class="fa fa-file-excel-o"></i> <?= lang('export_to_excel') ?>
                            </a>
                        </li>
						<li>
                            <a href="#" id="combine" data-action="combine">
                                <i class="fa fa-file-pdf-o"></i> Export to PDF
							</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><? //lang('list_results'); ?></p>
                <div class="table-responsive">
                    <table id="BankAccountsTable" class="table table-bordered table-hover table-striped reports-table">
                        <thead>
                            <tr>
                                <th style="min-width:30px; width: 30px; text-align: center;"></th>
                                <th style="text-align: left;"><?= lang("account_title"); ?></th>
                                <th><?= lang("account_number"); ?></th>
                                <th><?= lang("bank_name"); ?></th>
                                <th><?= lang("branch_address"); ?></th>
                                <th><?= lang("opening_balance"); ?></th>
                                <th><?= lang("Current_Balance"); ?></th>
                                <th style="width:100px;"><?= lang("actions"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
						<?php  if(!empty($banks)){
								foreach($banks as $bank){?>
                            <tr class="odd">
								<td class="">&nbsp;</td>
								<td class=""><?php echo $bank->account_title?></td>
								<td class=""><?php echo $bank->account_number?></td>
								<td class=" sorting_1"><?php echo $bank->bank_name?></td>
								<td class=""><?php echo $bank->branch_address?></td>
								<td class=""><?php echo $bank->opening_balance?></td>
								<td class=""><?php echo $bank->current_balance?></td>
								<td class="">
									<div class="text-center">
										<a href="<?php echo base_url()?>admin/system_settings/update_bank_account/<?php echo $bank->id?>" data-toggle="modal" data-target="#myModal" class="tip" data-html="true" data-original-title="Update Bank Account"><i class="fa fa-edit"></i></a> 
										<a href="#" class="tip po" data-html="true" data-placement="left" data-content="<p>Are you sure?</p><a class='btn btn-danger po-delete' data-id='del-store' href='<?php echo base_url()?>admin/system_settings/delete_bank_account/<?php echo $bank->id?>'>Yes I'm sure</a> <button class='btn po-close'>No</button>" rel="popover" data-original-title="<b>Delete Bank Account</b>"><i class="fa fa-trash-o"></i></a>
									</div>
								</td>
							</tr>
						<?php }}?>	
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div style="display: none;">
    <input type="hidden" name="form_action" value="" id="form_action"/>
    <?= form_submit('submit', 'submit', 'id="action-form-submit"') ?>
</div>
<?= form_close() ?>
<script language="javascript">
	
    $(document).ready(function () {
		
		$('.tip.po').tooltip();

        $('#delete').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#action-form-submit').trigger('click');
        });

        $('#excel').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#action-form-submit').trigger('click');
        });

        $('#pdf').click(function (e) {
            e.preventDefault();
            $('#form_action').val($(this).attr('data-action'));
            $('#action-form-submit').trigger('click');
        });

    });
</script>

