<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
foreach ($monthly_sales as $month_sale) {
    $months[] = $month_sale->month;
    $sales[] = $month_sale->sales;
}

?>
<script type="text/javascript">

    (function ($) { // encapsulate jQuery
        $(function () {
            var chart;
            $(document).ready(function () {
                /**
                 * Gray theme for Highcharts JS
                 * @author Torstein Hønsi
                 */

                Highcharts.theme = {
                    colors: ["#DDDF0D", "#7798BF", "#55BF3B", "#DF5353", "#aaeeee", "#ff0066", "#eeaaee",
                        "#55BF3B", "#DF5353", "#7798BF", "#aaeeee"],
                    chart: {
                        backgroundColor: {
                            linearGradient: [0, 0, 0, 400],
                            stops: [
                                [0, 'rgb(96, 96, 96)'],
                                [1, 'rgb(16, 16, 16)']
                            ]
                        },
                        borderWidth: 0,
                        borderRadius: 15,
                        plotBackgroundColor: null,
                        plotShadow: false,
                        plotBorderWidth: 0
                    },
                    title: {
                        style: {
                            color: '#FFF',
                            font: '16px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'
                        }
                    },
                    subtitle: {
                        style: {
                            color: '#DDD',
                            font: '12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'
                        }
                    },
                    xAxis: {
                        gridLineWidth: 0,
                        lineColor: '#999',
                        tickColor: '#999',
                        labels: {
                            style: {
                                color: '#999',
                                fontWeight: 'bold'
                            }
                        },
                        title: {
                            style: {
                                color: '#AAA',
                                font: 'bold 12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        alternateGridColor: null,
                        minorTickInterval: null,
                        gridLineColor: 'rgba(255, 255, 255, .1)',
                        lineWidth: 0,
                        tickWidth: 0,
                        labels: {
                            style: {
                                color: '#999',
                                fontWeight: 'bold'
                            }
                        },
                        title: {
                            style: {
                                color: '#AAA',
                                font: 'bold 14px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'
                            }
                        }
                    },
                    legend: {
                        itemStyle: {
                            color: '#333'
                        },
                        itemHoverStyle: {
                            color: '#000'
                        },
                        itemHiddenStyle: {
                            color: '#333'
                        }
                    },
                    labels: {
                        style: {
                            color: '#CCC'
                        }
                    },
                    tooltip: {
                        backgroundColor: {
                            linearGradient: [0, 0, 0, 50],
                            stops: [
                                [0, 'rgba(96, 96, 96, .8)'],
                                [1, 'rgba(16, 16, 16, .8)']
                            ]
                        },
                        borderWidth: 0,
                        style: {
                            color: '#FFF'
                        }
                    },


                    plotOptions: {
                        line: {
                            dataLabels: {
                                color: '#CCC'
                            },
                            marker: {
                                lineColor: '#333'
                            }
                        },
                        spline: {
                            marker: {
                                lineColor: '#333'
                            }
                        },
                        scatter: {
                            marker: {
                                lineColor: '#333'
                            }
                        },
                        candlestick: {
                            lineColor: 'white'
                        }
                    },

                    toolbar: {
                        itemStyle: {
                            color: '#CCC'
                        }
                    },

                    navigation: {
                        buttonOptions: {
                            backgroundColor: {
                                linearGradient: [0, 0, 0, 20],
                                stops: [
                                    [0.4, '#606060'],
                                    [0.6, '#333333']
                                ]
                            },
                            borderColor: '#000000',
                            symbolStroke: '#C0C0C0',
                            hoverSymbolStroke: '#FFFFFF'
                        }
                    },

                    exporting: {
                        buttons: {
                            exportButton: {
                                symbolFill: '#55BE3B'
                            },
                            printButton: {
                                symbolFill: '#7797BE'
                            }
                        }
                    },

                    // scroll charts
                    rangeSelector: {
                        buttonTheme: {
                            fill: {
                                linearGradient: [0, 0, 0, 20],
                                stops: [
                                    [0.4, '#888'],
                                    [0.6, '#555']
                                ]
                            },
                            stroke: '#000000',
                            style: {
                                color: '#CCC',
                                fontWeight: 'bold'
                            },
                            states: {
                                hover: {
                                    fill: {
                                        linearGradient: [0, 0, 0, 20],
                                        stops: [
                                            [0.4, '#BBB'],

                                            [0.6, '#888']
                                        ]
                                    },
                                    stroke: '#000000',
                                    style: {
                                        color: 'white'
                                    }
                                },
                                select: {
                                    fill: {
                                        linearGradient: [0, 0, 0, 20],
                                        stops: [
                                            [0.1, '#000'],
                                            [0.3, '#333']
                                        ]
                                    },
                                    stroke: '#000000',
                                    style: {
                                        color: 'yellow'
                                    }
                                }
                            }
                        },
                        inputStyle: {
                            backgroundColor: '#333',
                            color: 'silver'
                        },
                        labelStyle: {
                            color: 'silver'
                        }
                    },

                    navigator: {
                        handles: {
                            backgroundColor: '#666',
                            borderColor: '#AAA'
                        },
                        outlineColor: '#CCC',
                        maskFill: 'rgba(16, 16, 16, 0.5)',
                        series: {
                            color: '#7798BF',
                            lineColor: '#A6C7ED'
                        }
                    },

                    scrollbar: {
                        barBackgroundColor: {
                            linearGradient: [0, 0, 0, 20],
                            stops: [
                                [0.4, '#888'],
                                [0.6, '#555']
                            ]
                        },
                        barBorderColor: '#CCC',
                        buttonArrowColor: '#CCC',
                        buttonBackgroundColor: {
                            linearGradient: [0, 0, 0, 20],
                            stops: [
                                [0.4, '#888'],
                                [0.6, '#555']
                            ]
                        },
                        buttonBorderColor: '#CCC',
                        rifleColor: '#FFF',
                        trackBackgroundColor: {
                            linearGradient: [0, 0, 0, 10],
                            stops: [
                                [0, '#000'],
                                [1, '#333']
                            ]
                        },
                        trackBorderColor: '#666'
                    },

                    // special colors for some of the demo examples
                    legendBackgroundColor: 'rgba(48, 48, 48, 0.8)',
                    legendBackgroundColorSolid: 'rgb(70, 70, 70)',
                    dataLabelsColor: '#444',
                    textColor: '#E0E0E0',
                    maskColor: 'rgba(255,255,255,0.3)'
                };

// Apply the theme
                var highchartsOptions = Highcharts.setOptions(Highcharts.theme);

                chart = new Highcharts.Chart({
                    chart: {
                        renderTo: 'container',
                        type: 'column'
                    },
                    title: {
                        text: 'Monthly Sales'
                    },
                    subtitle: {
                        text: 'Overview'
                    },
                    xAxis: {
                        categories: [
                            <?php foreach($months as $month) {
                                 echo "'".$month."', ";
                             }
                            ?>
                        ]
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: 'Sales'
                        }
                    },
                    legend: {
                        layout: 'vertical',
                        backgroundColor: '#FFFFFF',
                        align: 'left',
                        verticalAlign: 'top',
                        x: 100,
                        y: 70,
                        floating: true,
                        shadow: true
                    },
                    tooltip: {
                        formatter: function () {
                            return '' +
                                this.x + ': ' + this.y + ' ';
                        }
                    },
                    credits: {
                        enabled: false
                    },
                    plotOptions: {
                        column: {
                            pointPadding: 0.2,
                            borderWidth: 0
                        }
                    },
                    series: [{

                        name: 'Sales',
                        data: [
                            <?php /*$sales = 10;
                            for($i=1;$i<=12;$i++) { echo $sales+$i.", "; }
                            */
                            echo implode(', ', $sales);
                            ?>
                        ]

                    }]
                });
            });

        });

    })(jQuery);

</script>

<div id="body_section">
    <!-- Errors -->
    <?php if ($message) {
        echo "<div class=\"yellow_bar\">" . $message . "</div>";
    } ?>
    <div id="body_section_inner">
        <div class="contentPageWrapper">

            <div class='mainInfo'>

                <h1><?php echo $page_title; ?></h1>

                <p class="introtext"><?php echo $this->lang->line("chart_heading"); ?></p>


                <div id="container" style="min-width: 400px; height: 400px; margin: 0 auto"></div>

            </div>
            <div class="clr"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>
<script src="smlib/js/sl/highcharts.js"></script>
<script src="smlib/js/sl/modules/exporting.js"></script>