<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
$modal = ($modal == -1) ? NULL : $modal;
?>
<?php if ($modal) { ?>
<div class="modal-dialog no-modal-header" role="document"><div class="modal-content"><div class="modal-body">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i></button>
<?php } else {?>
<!doctype html>
<html>
	<head>
        <meta charset="utf-8">
        <title><?=$page_title . " " . lang("no") . " " . $inv->id;?></title>
        <base href="<?=base_url()?>"/>
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?=$assets?>images/icon.png"/>
        <link rel="stylesheet" href="<?=$assets?>styles/theme.css" type="text/css"/>
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width: 100%; margin: 0 auto; padding: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }
            .bootbox .modal-footer { border-top: 0; text-align: center; }
            h3 { margin: 5px 0; }
            .order_barcodes img { float: none !important; margin-top: 5px; }
			 .no-print { max-width: 480px; margin:0 auto}
            @media print {
                .no-print { display: none; }
                #wrapper { max-width: 100%; width: 100%; min-width: 250px; margin: 0 auto; padding:20px; }
                .no-border { border: none !important; }
                .border-bottom { border-bottom: 1px solid #ddd !important; }
                table tfoot { display: table-row-group; }
            }
        </style>
    </head>

    <body>
	<?php } ?>
    <div id="wrapper">
        <div id="receiptData">
            <div class="no-print">
				<?php if ($message) { ?>
                 <!-- <div class="alert alert-success">
                    <button data-dismiss="alert" class="close" type="button">×</button>
					<?php /*     <?= /* is_array($message) ? print_r($message, true) : $message; */ ?> */?>
                </div>-->
                 <?php } ?>
                <div class="col-xs-12">
                	<a class="btn btn-block btn-warning" href="<?= admin_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
				</div>
            </div>
            <div id="receipt-data" style="float: left; width: 100%;">
                <div class="text-center">
                    <?= !empty($biller->logo) ? '<img src="'.base_url('assets/uploads/logos/'.$biller->logo).'" alt="">' : ''; ?>
                </div>				
				<div class="well well-sm">
					<div class="row bold">
						<div class="col-xs-5">
						<p class="bold" style="font-weight:bold;">
							<?= lang("date"); ?>: <?= $this->sma->hrld($inv->date); ?><br>
							<?= lang("ref"); ?>: <?= $inv->reference_no; ?><br>
							<?php if (!empty($inv->return_sale_ref)) {
								echo lang("return_ref").': '.$inv->return_sale_ref;
								if ($inv->return_id) {
									echo ' <a data-target="#myModal2" data-toggle="modal" href="'.admin_url('sales/modal_view/'.$inv->return_id).'"><i class="fa fa-external-link no-print"></i></a><br>';
								} else {
									echo '<br>';
								}
							} ?>
							<?= lang("sale_status"); ?>: <?= lang($inv->sale_status); ?><br>
							<?= lang("payment_status"); ?>: <?= lang($inv->payment_status); ?><br>
							<?= lang("warehouse"); ?>: <?= lang($warehouse->name); ?>
							<?php if($store){ echo "<br>".lang("stores"). ":" . lang($store->name);}?>
						</p>
						</div>
						<div class="col-xs-7 text-right order_barcodes">
							<img src="<?= admin_url('misc/barcode/'.$this->sma->base64url_encode($inv->reference_no).'/code128/74/0/1'); ?>" alt="<?= $inv->reference_no; ?>" class="bcimg" />
							<?= $this->sma->qrcode('link', urlencode(admin_url('sales/view/' . $inv->id)), 2); ?>
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
				</div>
				
                <div class="row" style="margin-bottom:15px;">

                <?php if ($Settings->invoice_view == 1) { ?>
                    <div class="col-xs-12 text-center">
                        <h1><?= lang('tax_invoice'); ?></h1>
                    </div>
                <?php } ?>

                <div class="col-xs-6">
                    <?php echo $this->lang->line("to"); ?>:<br/>
                    <h2 style="margin-top:10px; font-size:16px; font-weight:bold;"><?= $customer->company ? $customer->company : $customer->name; ?></h2>
                    <?= $customer->company ? "" : "Attn: " . $customer->name ?>

                    <?php
                    echo $customer->address . "<br>" . $customer->city . " " . $customer->postal_code . " " . $customer->state . "<br>" . $customer->country;

                    echo "<p>";

                    if ($customer->vat_no != "-" && $customer->vat_no != "") {
                        echo "<br>" . lang("vat_no") . ": " . $customer->vat_no;
                    }
                    if ($customer->cf1 != "-" && $customer->cf1 != "") {
                        echo "<br>" . lang("ccf1") . ": " . $customer->cf1;
                    }
                    if ($customer->cf2 != "-" && $customer->cf2 != "") {
                        echo "<br>" . lang("ccf2") . ": " . $customer->cf2;
                    }
                    if ($customer->cf3 != "-" && $customer->cf3 != "") {
                        echo "<br>" . lang("ccf3") . ": " . $customer->cf3;
                    }
                    if ($customer->cf4 != "-" && $customer->cf4 != "") {
                        echo "<br>" . lang("ccf4") . ": " . $customer->cf4;
                    }
                    if ($customer->cf5 != "-" && $customer->cf5 != "") {
                        echo "<br>" . lang("ccf5") . ": " . $customer->cf5;
                    }
                    if ($customer->cf6 != "-" && $customer->cf6 != "") {
                        echo "<br>" . lang("ccf6") . ": " . $customer->cf6;
                    }

                    echo "</p>";
                    echo lang("tel") . ": " . $customer->phone . "<br>" . lang("email") . ": " . $customer->email;
                    ?>
                </div>

				<div class="col-xs-6">
					<?php echo $this->lang->line("from"); ?>:
					<h2 style="margin-top:10px; font-size:16px; font-weight:bold;"><?= $biller->company != '-' ? $biller->company : $biller->name; ?></h2>
					<?= $biller->company ? "" : "Attn: " . $biller->name ?>
				
					<?php
					echo $biller->address . "<br>" . $biller->city . " " . $biller->postal_code . " " . $biller->state . "<br>" . $biller->country;
				
					echo "<p>";
				
					if ($biller->vat_no != "-" && $biller->vat_no != "") {
						echo "<br>" . lang("vat_no") . ": " . $biller->vat_no;
					}
					if ($biller->cf1 != "-" && $biller->cf1 != "") {
						echo "<br>" . lang("bcf1") . ": " . $biller->cf1;
					}
					if ($biller->cf2 != "-" && $biller->cf2 != "") {
						echo "<br>" . lang("bcf2") . ": " . $biller->cf2;
					}
					if ($biller->cf3 != "-" && $biller->cf3 != "") {
						echo "<br>" . lang("bcf3") . ": " . $biller->cf3;
					}
					if ($biller->cf4 != "-" && $biller->cf4 != "") {
						echo "<br>" . lang("bcf4") . ": " . $biller->cf4;
					}
					if ($biller->cf5 != "-" && $biller->cf5 != "") {
						echo "<br>" . lang("bcf5") . ": " . $biller->cf5;
					}
					if ($biller->cf6 != "-" && $biller->cf6 != "") {
						echo "<br>" . lang("bcf6") . ": " . $biller->cf6;
					}
				
					echo "</p>";
					echo lang("tel") . ": " . $biller->phone . "<br>" . lang("email") . ": " . $biller->email;
					?>
				</div>

                <div style="clear:both;"></div>
                <div class="table-responsive">
					<table class="table table-bordered table-hover table-striped print-table order-table">
	
						<thead>
	
						<tr>
							<th><?= lang("no"); ?></th>
							<th><?= lang("description"); ?></th>
							<?php if ($Settings->indian_gst) { ?>
								<th><?= lang("hsn_code"); ?></th>
							<?php } ?>
							<th><?= lang("quantity"); ?></th>
							<th><?= lang("unit_price"); ?></th>
							<?php
							if ($Settings->tax1 && $inv->product_tax > 0) {
								echo '<th>' . lang("tax") . '</th>';
							}
							if ($Settings->product_discount && $inv->product_discount != 0) {
								echo '<th>' . lang("discount") . '</th>';
							}
							?>
							<th><?= lang("subtotal"); ?></th>
						</tr>
	
						</thead>
	
						<tbody>
	
						<?php $r = 1;
						foreach ($rows as $row):
						?>
							<tr>
								<td style="text-align:center; width:40px; vertical-align:middle;"><?= $r; ?></td>
								<td style="vertical-align:middle;">
									<?= $row->product_code.' - '.$row->product_name . ($row->variant ? ' (' . $row->variant . ')' : ''); ?>
									<?= $row->second_name ? '<br>' . $row->second_name : ''; ?>
									<?= $row->details ? '<br>' . $row->details : ''; ?>
									<?= $row->serial_no ? '<br>' . $row->serial_no : ''; ?>
								</td>
								<?php if ($Settings->indian_gst) { ?>
								<td style="width: 80px; text-align:center; vertical-align:middle;"><?= $row->hsn_code; ?></td>
								<?php } ?>
								<td style="width: 80px; text-align:center; vertical-align:middle;"><?= $this->sma->formatQuantity($row->unit_quantity).' '.$row->product_unit_code; ?></td>
								<td style="text-align:right; width:100px; vertical-align:middle;"><?= $this->sma->formatMoney($row->unit_price); ?></td>
								<?php
								if ($Settings->tax1 && $inv->product_tax > 0) {
									echo '<td style="width: 100px; text-align:right; vertical-align:middle;">' . ($row->item_tax != 0 ? '<small>('.($Settings->indian_gst ? $row->tax : $row->tax_code).')</small>' : '') . ' ' . $this->sma->formatMoney($row->item_tax) . '</td>';
								}
								if ($Settings->product_discount && $inv->product_discount != 0) {
									echo '<td style="width: 100px; text-align:right; vertical-align:middle;">' . ($row->discount != 0 ? '<small>(' . $row->discount . ')</small> ' : '') . $this->sma->formatMoney($row->item_discount) . '</td>';
								}
								?>
								<td style="text-align:right; width:120px; vertical-align:middle;"><?= $this->sma->formatMoney($row->subtotal); ?></td>
							</tr>
							<?php
							$r++;
						endforeach;
						if ($return_rows) {
							echo '<tr class="warning"><td colspan="100%" class="no-border"><strong>'.lang('returned_items').'</strong></td></tr>';
							foreach ($return_rows as $row):
							?>
								<tr class="warning">
									<td style="text-align:center; width:40px; vertical-align:middle;"><?= $r; ?></td>
									<td style="vertical-align:middle;">
										<?= $row->product_code.' - '.$row->product_name . ($row->variant ? ' (' . $row->variant . ')' : ''); ?>
										<?= $row->second_name ? '<br>' . $row->second_name : ''; ?>
										<?= $row->details ? '<br>' . $row->details : ''; ?>
										<?= $row->serial_no ? '<br>' . $row->serial_no : ''; ?>
									</td>
									<?php if ($Settings->indian_gst) { ?>
									<td style="width: 80px; text-align:center; vertical-align:middle;"><?= $row->hsn_code; ?></td>
									<?php } ?>
									<td style="width: 80px; text-align:center; vertical-align:middle;"><?= $this->sma->formatQuantity($row->quantity).' '.$row->product_unit_code; ?></td>
									<td style="text-align:right; width:100px;"><?= $this->sma->formatMoney($row->unit_price); ?></td>
									<?php
									if ($Settings->tax1 && $inv->product_tax > 0) {
										echo '<td style="width: 100px; text-align:right; vertical-align:middle;">' . ($row->item_tax != 0 ? '<small>('.($Settings->indian_gst ? $row->tax : $row->tax_code).')</small>' : '') . ' ' . $this->sma->formatMoney($row->item_tax) . '</td>';
									}
									if ($Settings->product_discount && $inv->product_discount != 0) {
										echo '<td style="width: 100px; text-align:right; vertical-align:middle;">' . ($row->discount != 0 ? '<small>(' . $row->discount . ')</small> ' : '') . $this->sma->formatMoney($row->item_discount) . '</td>';
									}
									?>
									<td style="text-align:right; width:120px;"><?= $this->sma->formatMoney($row->subtotal); ?></td>
								</tr>
								<?php
								$r++;
							endforeach;
						}
						?>
						</tbody>
						<tfoot>
						<?php
						$col = $Settings->indian_gst ? 5 : 4;
						if ($Settings->product_discount && $inv->product_discount != 0) {
							$col++;
						}
						if ($Settings->tax1 && $inv->product_tax > 0) {
							$col++;
						}
						if ($Settings->product_discount && $inv->product_discount != 0 && $Settings->tax1 && $inv->product_tax > 0) {
							$tcol = $col - 2;
						} elseif ($Settings->product_discount && $inv->product_discount != 0) {
							$tcol = $col - 1;
						} elseif ($Settings->tax1 && $inv->product_tax > 0) {
							$tcol = $col - 1;
						} else {
							$tcol = $col;
						}
						?>
						<?php if ($inv->grand_total != $inv->total) { ?>
							<tr>
								<td colspan="<?= $tcol; ?>"
									style="text-align:right; padding-right:10px;"><?= lang("total"); ?>
									(<?= $default_currency->code; ?>)
								</td>
								<?php
								if ($Settings->tax1 && $inv->product_tax > 0) {
									echo '<td style="text-align:right;">' . $this->sma->formatMoney($return_sale ? ($inv->product_tax+$return_sale->product_tax) : $inv->product_tax) . '</td>';
								}
								if ($Settings->product_discount && $inv->product_discount != 0) {
									echo '<td style="text-align:right;">' . $this->sma->formatMoney($return_sale ? ($inv->product_discount+$return_sale->product_discount) : $inv->product_discount) . '</td>';
								}
								?>
								<td style="text-align:right; padding-right:10px;"><?= $this->sma->formatMoney($return_sale ? (($inv->total + $inv->product_tax)+($return_sale->total + $return_sale->product_tax)) : ($inv->total + $inv->product_tax)); ?></td>
							</tr>
						<?php } ?>
						<?php
						if ($return_sale) {
							echo '<tr><td colspan="' . $col . '" style="text-align:right; padding-right:10px;;">' . lang("return_total") . ' (' . $default_currency->code . ')</td><td style="text-align:right; padding-right:10px;">' . $this->sma->formatMoney($return_sale->grand_total) . '</td></tr>';
						}
						if ($inv->surcharge != 0) {
							echo '<tr><td colspan="' . $col . '" style="text-align:right; padding-right:10px;;">' . lang("return_surcharge") . ' (' . $default_currency->code . ')</td><td style="text-align:right; padding-right:10px;">' . $this->sma->formatMoney($inv->surcharge) . '</td></tr>';
						}
						?>
	
						<?php if ($Settings->indian_gst) {
							if ($inv->cgst > 0) {
								$cgst = $return_sale ? $inv->cgst + $return_sale->cgst : $inv->cgst;
								echo '<tr><td colspan="' . $col . '" class="text-right">' . lang('cgst') . ' (' . $default_currency->code . ')</td><td class="text-right">' . ( $Settings->format_gst ? $this->sma->formatMoney($cgst) : $cgst) . '</td></tr>';
							}
							if ($inv->sgst > 0) {
								$sgst = $return_sale ? $inv->sgst + $return_sale->sgst : $inv->sgst;
								echo '<tr><td colspan="' . $col . '" class="text-right">' . lang('sgst') . ' (' . $default_currency->code . ')</td><td class="text-right">' . ( $Settings->format_gst ? $this->sma->formatMoney($sgst) : $sgst) . '</td></tr>';
							}
							if ($inv->igst > 0) {
								$igst = $return_sale ? $inv->igst + $return_sale->igst : $inv->igst;
								echo '<tr><td colspan="' . $col . '" class="text-right">' . lang('igst') . ' (' . $default_currency->code . ')</td><td class="text-right">' . ( $Settings->format_gst ? $this->sma->formatMoney($igst) : $igst) . '</td></tr>';
							}
						} ?>
	
						<?php if ($inv->order_discount != 0) {
							echo '<tr><td colspan="' . $col . '" style="text-align:right; padding-right:10px;;">' . lang("order_discount") . ' (' . $default_currency->code . ')</td><td style="text-align:right; padding-right:10px;">'.($inv->order_discount_id ? '<small>('.$inv->order_discount_id.')</small> ' : '') . $this->sma->formatMoney($return_sale ? ($inv->order_discount+$return_sale->order_discount) : $inv->order_discount) . '</td></tr>';
						}
						?>
						<?php if ($Settings->tax2 && $inv->order_tax != 0) {
							echo '<tr><td colspan="' . $col . '" style="text-align:right; padding-right:10px;">' . lang("order_tax") . ' (' . $default_currency->code . ')</td><td style="text-align:right; padding-right:10px;">' . $this->sma->formatMoney($return_sale ? ($inv->order_tax+$return_sale->order_tax) : $inv->order_tax) . '</td></tr>';
						}
						?>
						<?php if ($inv->shipping != 0) {
							echo '<tr><td colspan="' . $col . '" style="text-align:right; padding-right:10px;;">' . lang("shipping") . ' (' . $default_currency->code . ')</td><td style="text-align:right; padding-right:10px;">' . $this->sma->formatMoney($inv->shipping) . '</td></tr>';
						}
						?>
						<tr>
							<td colspan="<?= $col; ?>"
								style="text-align:right; font-weight:bold;"><?= lang("total_amount"); ?>
								(<?= $default_currency->code; ?>)
							</td>
							<td style="text-align:right; padding-right:10px; font-weight:bold;"><?= $this->sma->formatMoney($return_sale ? ($inv->grand_total+$return_sale->grand_total) : $inv->grand_total); ?></td>
						</tr>
						<tr>
							<td colspan="<?= $col; ?>"
								style="text-align:right; font-weight:bold;"><?= lang("paid"); ?>
								(<?= $default_currency->code; ?>)
							</td>
							<td style="text-align:right; font-weight:bold;"><?= $this->sma->formatMoney($return_sale ? ($inv->paid+$return_sale->paid) : $inv->paid); ?></td>
						</tr>
						<tr>
							<td colspan="<?= $col; ?>"
								style="text-align:right; font-weight:bold;"><?= lang("balance"); ?>
								(<?= $default_currency->code; ?>)
							</td>
							<td style="text-align:right; font-weight:bold;"><?= $this->sma->formatMoney(($return_sale ? ($inv->grand_total+$return_sale->grand_total) : $inv->grand_total) - ($return_sale ? ($inv->paid+$return_sale->paid) : $inv->paid)); ?></td>
						</tr>
	
						</tfoot>
					</table>
				</div>
                 <?= $Settings->invoice_view > 0 ? $this->gst->summary($rows, $return_rows, ($return_sale ? $inv->product_tax+$return_sale->product_tax : $inv->product_tax)) : ''; ?>

				<div class="row">
					<div class="col-xs-12">
						<?php
							if ($inv->note || $inv->note != "") { ?>
								<div class="well well-sm">
									<p class="bold"><?= lang("note"); ?>:</p>
									<div><?= $this->sma->decode_html($inv->note); ?></div>
								</div>
							<?php
							}
							if ($inv->staff_note || $inv->staff_note != "") { ?>
								<div class="well well-sm staff_note">
									<p class="bold"><?= lang("staff_note"); ?>:</p>
									<div><?= $this->sma->decode_html($inv->staff_note); ?></div>
								</div>
							<?php } ?>
					</div>
	
					<?php if ($customer->award_points != 0 && $Settings->each_spent > 0) { ?>
					<div class="col-xs-5 pull-left">
						<div class="well well-sm">
							<?=
							'<p>'.lang('this_sale').': '.floor(($inv->grand_total/$Settings->each_spent)*$Settings->ca_point)
							.'<br>'.
							lang('total').' '.lang('award_points').': '. $customer->award_points . '</p>';?>
						</div>
					</div>
					<?php } ?>
	
					<div class="col-xs-5 pull-right">
						<div class="well well-sm">
							<p>
								<?= lang("created_by"); ?>: <?= $created_by->first_name . ' ' . $created_by->last_name; ?> <br>
								<?= lang("date"); ?>: <?= $this->sma->hrld($inv->date); ?>
							</p>
							<?php if ($inv->updated_by) { ?>
							<p>
								<?= lang("updated_by"); ?>: <?= $updated_by->first_name . ' ' . $updated_by->last_name;; ?><br>
								<?= lang("update_at"); ?>: <?= $this->sma->hrld($inv->updated_at); ?>
							</p>
							<?php } ?>
						</div>
					</div>
				</div>
            </div>
            <div style="clear:both;"></div>
        </div>

        <div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
            <hr>
            <?php
            if ($message) {
                ?>
                <div class="alert alert-success">
                    <button data-dismiss="alert" class="close" type="button">×</button>
                    <?=is_array($message) ? print_r($message, true) : $message;?>
                </div>
                <?php
            } ?>
            <?php
            if ($modal) {
                ?>
                <div class="btn-group btn-group-justified" role="group" aria-label="...">
                    <div class="btn-group" role="group">
                        <?php
                        if ($pos->remote_printing == 1) {
                            echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';
                        } else {
                            echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                        }

                        ?>
                    </div>
                    <div class="btn-group" role="group">
                        <a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a>
                    </div>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
                    </div>
                </div>
                <?php
            } else {
                ?>
                <span class="pull-right col-xs-12">
                    <?php
                    if ($pos->remote_printing == 1) {
                        echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';
                    } else {
                        echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                        echo '<button onclick="return openCashDrawer()" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</button>';
                    }
                    ?>
                </span>
                <?php /*?><span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a></span><?php */?>
                <span class="col-xs-12">
                    <a class="btn btn-block btn-warning" href="<?= admin_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
                </span>
                <?php } if ($pos->remote_printing == 1) {?>
                <div style="clear:both;"></div>
                <div class="col-xs-12" style="background:#F5F5F5; padding:10px;">
                    <p style="font-weight:bold;">
                        Please don't forget to disble the header and footer in browser print settings.
                    </p>
                    <p style="text-transform: capitalize;">
                        <strong>FF:</strong> File &gt; Print Setup &gt; Margin &amp; Header/Footer Make all --blank--
                    </p>
                    <p style="text-transform: capitalize;">
                        <strong>chrome:</strong> Menu &gt; Print &gt; Disable Header/Footer in Option &amp; Set Margins to None
                    </p>
                </div>
                <?php
            } ?>
            <div style="clear:both;"></div>
        </div>
    </div>

    <?php  if( ! $modal) {  ?>
        <script type="text/javascript" src="<?= $assets ?>js/jquery-2.0.3.min.js"></script>
        <script type="text/javascript" src="<?= $assets ?>js/bootstrap.min.js"></script>
        <script type="text/javascript" src="<?= $assets ?>js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
	<?php  }  ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#email').click(function () {
                bootbox.prompt({
                    title: "<?= lang("email_address"); ?>",
                    inputType: 'email',
                    value: "<?= $customer->email; ?>",
                    callback: function (email) {
                        if (email != null) {
                            $.ajax({
                                type: "post",
                                url: "<?= admin_url('pos/email_receipt') ?>",
                                data: {<?= $this->security->get_csrf_token_name(); ?>: "<?= $this->security->get_csrf_hash(); ?>", email: email, id: <?= $inv->id; ?>},
                                dataType: "json",
                                success: function (data) {
                                    bootbox.alert({message: data.msg, size: 'small'});
                                },
                                error: function () {
                                    bootbox.alert({message: '<?= lang('ajax_request_failed'); ?>', size: 'small'});
                                    return false;
                                }
                            });
                        }
                    }
                });
                return false;
            });
        });

        <?php
        if ($pos_settings->remote_printing == 1) {
            ?>
            $(window).load(function () {
                window.print();
                return false;
            });
            <?php
        }
        ?>

    </script>
    <?php /* include FCPATH.'themes'.DIRECTORY_SEPARATOR.$Settings->theme.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'pos'.DIRECTORY_SEPARATOR.'remote_printing.php'; */ ?>
    <?php include 'remote_printing.php'; ?>
    <?php
    if($modal) {
        ?>
    </div>
</div>
</div>
<?php
} else {
    ?>
</body>
</html>
<?php
}
?>
