<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo "Employee Loan";//echo lang('add_notification'); ?></h4>
        </div>
        <?php $attrib = array('data-toggle' => 'validator', 'role' => 'form');
        echo admin_form_open("Employee/add_loan", $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <?php echo 'Loan Amount';//echo lang('e_name', 'from_date'); ?>
                        <div class="controls">
                            <?php echo form_input('loan_amt', '', 'class="form-control" id="loan_amt" required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
					<div class="form-group"> <?php echo 'Deducted from Bank / Store / Warehouse';//echo lang('e_name', 'from_date'); ?>
						<div class="controls">
							<select name="opt" id="opt" class="form-control">
								<option value="0" selected="selected">Bank Account</option>
								<option value="1">Store</option>
								<option value="2">Warehouse</option>
							</select>
						</div>
					</div>
				</div>
				<div class="col-sm-6">
					<div class="form-group" id="bank-div"> <?php echo 'Deducted from Bank Account';//echo lang('e_name', 'from_date'); ?>
						<div class="controls">
							<select name="account" class="form-control">
								<option value="0">Select Bank Account</option>
								<?php if(!empty($accounts)){
										foreach($accounts as $account){?>
								<option value="<?php echo $account->id;?>"><?php echo $account->account_title.' - '.$account->account_number;?></option>
								<?php }}else{?>								
								<?php }?>
							</select>
						</div>
					</div>
					<div class="form-group" id="store-div" style="display:none;"> <?php echo 'Deducted from Store';//echo lang('e_name', 'from_date'); ?>
						<div class="controls">
							<select name="account_store" class="form-control">
								<option value="0">Select Store</option>
								<?php if(!empty($stores)){
										foreach($stores as $store){?>
								<option value="<?php echo $store->id;?>"><?php echo $store->name;?></option>
								<?php }}else{?>								
								<?php }?>
							</select>
						</div>
					</div>
					<div class="form-group" id="warehouse-div" style="display:none;"> <?php echo 'Deducted from Warehouse';//echo lang('e_name', 'from_date'); ?>
						<div class="controls">
							<select name="account_warehouse" class="form-control">
								<option value="0">Select Warehouse</option>
								<?php if(!empty($warehouses)){
										foreach($warehouses as $warehouse){?>
								<option value="<?php echo $warehouse->id;?>"><?php echo $warehouse->name;?></option>
								<?php }}else{?>								
								<?php }?>
							</select>
						</div>
					</div>
				</div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <?php  echo 'Note '; //echo lang('till', 'to_date'); ?>
                        <div class="controls">
                            <?php echo form_input('note', '', 'class="form-control" id="note" required="required"'); ?>
                        </div>
                    </div>
                </div>
            </div>
			<?php echo form_hidden('empid', $employee->id); ?>
			
        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_notification', lang('Add Loan'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<?= $modal_js ?>
<script type="text/javascript" src="<?= $assets ?>js/custom.js"></script>
<script type="text/javascript" charset="UTF-8">
    $.fn.datetimepicker.dates['sma'] = <?=$dp_lang?>;
    $(document).ready(function(e) {
		$('#opt').change(function(e) {
			if($(this).val() == 0)
			{
				$('#store-div').fadeOut(170);
				$('#warehouse-div').fadeOut(170);
				$('#bank-div').fadeIn(150);
			}
			else if($(this).val() == 1)
			{
				$('#bank-div').fadeOut(170);
				$('#warehouse-div').fadeOut(170);
				$('#store-div').fadeIn(150);
			}
			else
			{
				$('#bank-div').fadeOut(170);
				$('#store-div').fadeOut(170);
				$('#warehouse-div').fadeIn(150);
			}
		});
	});
</script>

