<?php defined('BASEPATH') OR exit('No direct script access allowed');


class Cmt_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();

    }

    public function getExpenseAccount()
    {
		$qry = "SELECT * FROM {$this->db->dbprefix('bank_accounts')} WHERE id IN (SELECT expense_account FROM {$this->db->dbprefix('settings')})";
        $q = $this->db->query($qry)->result();
		return $q;
    }

    public function getAllComments()
    {

        $q = $this->db->get("notifications");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }

            return $data;
        }
    }

    public function getNotifications()
    {
        $date = date('Y-m-d H:i:s', time());
        $this->db->where("from_date <=", $date);
        $this->db->where("till_date >=", $date);
        if (!$this->Owner) {
            if ($this->Supplier) {
                $this->db->where('scope', 4);
            } elseif ($this->Customer) {
                $this->db->where('scope', 1)->or_where('scope', 3);
            } elseif (!$this->Customer && !$this->Supplier) {
                $this->db->where('scope', 2)->or_where('scope', 3);
            }
        }
        $q = $this->db->get("notifications");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }

            return $data;
        }
    }

    public function getCommentByID($id)
    {

        $q = $this->db->get_where("notifications", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }

        return FALSE;

    }
	
	public function getEmployeeByID($id)
    {
        $q = $this->db->get_where("employee", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
	
	public function getLoanByID($id)
    {
        $q = $this->db->get_where("employee_loan", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getTransactionByID($id)
    {
        $q = $this->db->get_where("transactions", array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
	
	public function getEmpoyees()
    {
        $q = $this->db->get_where("employee");
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }

            return $data;
        }
        return FALSE;
    }
	
	public function getLoanByEmpID($empid)
    {
        $q = $this->db->get_where("employee_loan", array('empid' => $empid));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }

            return $data;
        }
        return FALSE;
    }
	
	public function getSalaryByEmpID($empid)
    {
        $q = $this->db->get_where("employee_salary", array('empid' => $empid));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }

            return $data;
        }
        return FALSE;
    }


    public function addNotification($data)
    {

        if ($this->db->insert("notifications", $data)) {
            return true;
        } else {
            return false;
        }
    }

	public function addEmployee($data)
    {

        if ($this->db->insert("employee", $data)) {
            return true;
        } else {
            return false;
        }
    }
	
	public function addLoan($data)
    {

        if ($this->db->insert("employee_loan", $data)) {
            return  $this->db->insert_id();;
        } else {
            return false;
        }
    }
	
	public function addSalary($data)
    {

        if ($this->db->insert("employee_salary", $data)) {
            return $this->db->insert_id();;
        } else {
            return 0;
        }
    }
	
    public function updateNotification($id, $data)
    {

        $this->db->where('id', $id);
        if ($this->db->update("notifications", $data)) {
            return true;
        } else {
            return false;
        }
    }
	
	public function updateEmployee($id, $data)
    {
        $this->db->where('id', $id);
        if ($this->db->update("employee", $data)) {
            return true;
        } else {
            return false;
        }
    }
	
	public function updateLoan($id, $data)
    {
        $this->db->where('id', $id);
        if ($this->db->update("employee_loan", $data)) {
            return true;
        } else {
            return false;
        }
    }

    public function deleteComment($id)
    {
        if ($this->db->delete("notifications", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }
	
	public function deleteEmployee($id)
    {
        if ($this->db->delete("employee", array('id' => $id))) {
			$this->db->delete("employee_loan", array('empid' => $id));
			$this->db->delete("employee_salary", array('empid' => $id));
            return true;
        }
        return FALSE;
    }
	
	public function deleteLoan($id)
    {
        if ($this->db->delete("employee_loan", array('id' => $id))) {
            return true;
        }
        return FALSE;
    }
	
	public function deleteSalary($id)
    {
        if ($this->db->delete("employee_salary", array('id' => $id))) 
		{
			$this->db->delete("transactions", array('type_id' => $id, 'type' => 'salary'));
            return true;
        }
        return FALSE;
    }



}

/* End of file pts_model.php */
/* Location: ./application/models/pts_types_model.php */
