<?php defined('BASEPATH') OR exit('No direct script access allowed');

class system_settings extends MY_Controller
{

    function __construct()
    {

        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
		// yrcode :- add admin permission for allow settings tab
        /*if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect('admin');
        }*/
        $this->lang->admin_load('settings', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('settings_model');
		 $this->load->admin_model('pos_model');
        $this->upload_path = 'assets/uploads/';
        $this->thumbs_path = 'assets/uploads/thumbs/';
        $this->image_types = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif';
        $this->allowed_file_size = '1024';
    }

    function index()
    {
        $this->load->library('gst');
        $this->form_validation->set_rules('site_name', lang('site_name'), 'trim|required');
        $this->form_validation->set_rules('dateformat', lang('dateformat'), 'trim|required');
        $this->form_validation->set_rules('timezone', lang('timezone'), 'trim|required');
        $this->form_validation->set_rules('mmode', lang('maintenance_mode'), 'trim|required');
        //$this->form_validation->set_rules('logo', lang('logo'), 'trim');
        $this->form_validation->set_rules('iwidth', lang('image_width'), 'trim|numeric|required');
        $this->form_validation->set_rules('iheight', lang('image_height'), 'trim|numeric|required');
        $this->form_validation->set_rules('twidth', lang('thumbnail_width'), 'trim|numeric|required');
        $this->form_validation->set_rules('theight', lang('thumbnail_height'), 'trim|numeric|required');
        $this->form_validation->set_rules('display_all_products', lang('display_all_products'), 'trim|numeric|required');
        $this->form_validation->set_rules('watermark', lang('watermark'), 'trim|required');
        $this->form_validation->set_rules('currency', lang('default_currency'), 'trim|required');
        $this->form_validation->set_rules('email', lang('default_email'), 'trim|required');
        $this->form_validation->set_rules('language', lang('language'), 'trim|required');
        $this->form_validation->set_rules('warehouse', lang('default_warehouse'), 'trim|required');
        $this->form_validation->set_rules('biller', lang('default_biller'), 'trim|required');
        $this->form_validation->set_rules('tax_rate', lang('product_tax'), 'trim|required');
        $this->form_validation->set_rules('tax_rate2', lang('invoice_tax'), 'trim|required');
        $this->form_validation->set_rules('sales_prefix', lang('sales_prefix'), 'trim');
        $this->form_validation->set_rules('quote_prefix', lang('quote_prefix'), 'trim');
        $this->form_validation->set_rules('purchase_prefix', lang('purchase_prefix'), 'trim');
        $this->form_validation->set_rules('transfer_prefix', lang('transfer_prefix'), 'trim');
        $this->form_validation->set_rules('delivery_prefix', lang('delivery_prefix'), 'trim');
        $this->form_validation->set_rules('payment_prefix', lang('payment_prefix'), 'trim');
        $this->form_validation->set_rules('return_prefix', lang('return_prefix'), 'trim');
        $this->form_validation->set_rules('expense_prefix', lang('expense_prefix'), 'trim');
        $this->form_validation->set_rules('detect_barcode', lang('detect_barcode'), 'trim|required');
        $this->form_validation->set_rules('theme', lang('theme'), 'trim|required');
        $this->form_validation->set_rules('rows_per_page', lang('rows_per_page'), 'trim|required|greater_than[9]|less_than[501]');
        $this->form_validation->set_rules('accounting_method', lang('accounting_method'), 'trim|required');
        $this->form_validation->set_rules('product_serial', lang('product_serial'), 'trim|required');
        $this->form_validation->set_rules('product_discount', lang('product_discount'), 'trim|required');
        $this->form_validation->set_rules('bc_fix', lang('bc_fix'), 'trim|numeric|required');
        $this->form_validation->set_rules('protocol', lang('email_protocol'), 'trim|required');
        if ($this->input->post('protocol') == 'smtp') {
            $this->form_validation->set_rules('smtp_host', lang('smtp_host'), 'required');
            $this->form_validation->set_rules('smtp_user', lang('smtp_user'), 'required');
            $this->form_validation->set_rules('smtp_pass', lang('smtp_pass'), 'required');
            $this->form_validation->set_rules('smtp_port', lang('smtp_port'), 'required');
        }
        if ($this->input->post('protocol') == 'sendmail') {
            $this->form_validation->set_rules('mailpath', lang('mailpath'), 'required');
        }
        $this->form_validation->set_rules('decimals', lang('decimals'), 'trim|required');
        $this->form_validation->set_rules('decimals_sep', lang('decimals_sep'), 'trim|required');
        $this->form_validation->set_rules('thousands_sep', lang('thousands_sep'), 'trim|required');
        if ($this->Settings->indian_gst) {
            $this->form_validation->set_rules('state', lang('state'), 'trim|required');
        }

        if ($this->form_validation->run() == true) 
		{
            $language = $this->input->post('language');

            if ((file_exists(APPPATH.'language'.DIRECTORY_SEPARATOR.$language.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.'sma_lang.php') && is_dir(APPPATH.DIRECTORY_SEPARATOR.'language'.DIRECTORY_SEPARATOR.$language)) || $language == 'english') {
                $lang = $language;
            } else {
                $this->session->set_flashdata('error', lang('language_x_found'));
                admin_redirect("system_settings");
                $lang = 'english';
            }

            $tax1 = ($this->input->post('tax_rate') != 0) ? 1 : 0;
            $tax2 = ($this->input->post('tax_rate2') != 0) ? 1 : 0;

            $data = array('site_name' => DEMO ? 'Stock Manager Advance' : $this->input->post('site_name'),
                'rows_per_page' => $this->input->post('rows_per_page'),
                'dateformat' => $this->input->post('dateformat'),
                'timezone' => DEMO ? 'Asia/Kuala_Lumpur' : $this->input->post('timezone'),
                'mmode' => trim($this->input->post('mmode')),
                'iwidth' => $this->input->post('iwidth'),
                'iheight' => $this->input->post('iheight'),
                'twidth' => $this->input->post('twidth'),
                'theight' => $this->input->post('theight'),
                'watermark' => $this->input->post('watermark'),
                // 'reg_ver' => $this->input->post('reg_ver'),
                // 'allow_reg' => $this->input->post('allow_reg'),
                // 'reg_notification' => $this->input->post('reg_notification'),
                'accounting_method' => $this->input->post('accounting_method'),
                'default_email' => DEMO ? 'noreply@info.pointofsalesaudi.com' : $this->input->post('email'),
                'language' => $lang,
                'default_warehouse' => $this->input->post('warehouse'),
                'default_tax_rate' => $this->input->post('tax_rate'),
                'default_tax_rate2' => $this->input->post('tax_rate2'),
                'sales_prefix' => $this->input->post('sales_prefix'),
                'quote_prefix' => $this->input->post('quote_prefix'),
                'purchase_prefix' => $this->input->post('purchase_prefix'),
                'transfer_prefix' => $this->input->post('transfer_prefix'),
                'delivery_prefix' => $this->input->post('delivery_prefix'),
                'payment_prefix' => $this->input->post('payment_prefix'),
                'ppayment_prefix' => $this->input->post('ppayment_prefix'),
                'qa_prefix' => $this->input->post('qa_prefix'),
                'return_prefix' => $this->input->post('return_prefix'),
                'returnp_prefix' => $this->input->post('returnp_prefix'),
                'expense_prefix' => $this->input->post('expense_prefix'),
                'auto_detect_barcode' => trim($this->input->post('detect_barcode')),
                'theme' => trim($this->input->post('theme')),
                'product_serial' => $this->input->post('product_serial'),
                'customer_group' => $this->input->post('customer_group'),
                'product_expiry' => $this->input->post('product_expiry'),
                'product_discount' => $this->input->post('product_discount'),
                'default_currency' => $this->input->post('currency'),
                'bc_fix' => $this->input->post('bc_fix'),
                'tax1' => $tax1,
                'tax2' => $tax2,
                'overselling' => $this->input->post('restrict_sale'),
                'reference_format' => $this->input->post('reference_format'),
                'racks' => $this->input->post('racks'),
                'attributes' => $this->input->post('attributes'),
                'restrict_calendar' => $this->input->post('restrict_calendar'),
                'captcha' => $this->input->post('captcha'),
                'item_addition' => $this->input->post('item_addition'),
                'protocol' => DEMO ? 'mail' : $this->input->post('protocol'),
                'mailpath' => $this->input->post('mailpath'),
                'smtp_host' => $this->input->post('smtp_host'),
                'smtp_user' => $this->input->post('smtp_user'),
                'smtp_port' => $this->input->post('smtp_port'),
                'smtp_crypto' => $this->input->post('smtp_crypto') ? $this->input->post('smtp_crypto') : NULL,
                'decimals' => $this->input->post('decimals'),
                'decimals_sep' => $this->input->post('decimals_sep'),
                'thousands_sep' => $this->input->post('thousands_sep'),
                'default_biller' => $this->input->post('biller'),
                'invoice_view' => $this->input->post('invoice_view'),
                'rtl' => $this->input->post('rtl'),
                'each_spent' => $this->input->post('each_spent') ? $this->input->post('each_spent') : NULL,
                'ca_point' => $this->input->post('ca_point') ? $this->input->post('ca_point') : NULL,
                'each_sale' => $this->input->post('each_sale') ? $this->input->post('each_sale') : NULL,
                'sa_point' => $this->input->post('sa_point') ? $this->input->post('sa_point') : NULL,
                'sac' => $this->input->post('sac'),
                'qty_decimals' => $this->input->post('qty_decimals'),
                'display_all_products' => $this->input->post('display_all_products'),
                'display_symbol' => $this->input->post('display_symbol'),
                'symbol' => $this->input->post('symbol'),
                'remove_expired' => $this->input->post('remove_expired'),
                'barcode_separator' => $this->input->post('barcode_separator'),
                'set_focus' => $this->input->post('set_focus'),
                'disable_editing' => $this->input->post('disable_editing'),
                'price_group' => $this->input->post('price_group'),
                'barcode_img' => $this->input->post('barcode_renderer'),
                'update_cost' => $this->input->post('update_cost'),
                'apis' => $this->input->post('apis'),
                'pdf_lib' => $this->input->post('pdf_lib'),
                'state' => $this->input->post('state'),
                'purchase_account' => $this->input->post('purchase_account'),
                'sales_account' => $this->input->post('sales_account'),
                'expense_account' => $this->input->post('expense_account'),
                'discount_type' => $this->input->post('discount_type'),
            );
			
            if ($this->input->post('smtp_pass')) 
			{
                $data['smtp_pass'] = $this->input->post('smtp_pass');
            }
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateSetting($data)) 
		{
            if ( ! DEMO && TIMEZONE != $data['timezone']) {
                if ( ! $this->write_index($data['timezone'])) {
                    $this->session->set_flashdata('error', lang('setting_updated_timezone_failed'));
                    admin_redirect('system_settings');
                }
            }

            $this->session->set_flashdata('message', lang('setting_updated'));
            admin_redirect("system_settings");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['billers'] = $this->site->getAllCompanies('biller');
            $this->data['settings'] = $this->settings_model->getSettings();
            $this->data['currencies'] = $this->settings_model->getAllCurrencies();
            $this->data['date_formats'] = $this->settings_model->getDateFormats();
            $this->data['tax_rates'] = $this->settings_model->getAllTaxRates();
            $this->data['customer_groups'] = $this->settings_model->getAllCustomerGroups();
            $this->data['price_groups'] = $this->settings_model->getAllPriceGroups();
            $this->data['warehouses'] = $this->settings_model->getAllWarehouses();
            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('system_settings')));
            $meta = array('page_title' => lang('system_settings'), 'bc' => $bc);
			$this->data['bank_accounts'] = $this->settings_model->getAllBankAccounts();
			//echo '<pre>';print_r($this->data);exit;
            $this->page_construct('settings/index', $meta, $this->data);
        }
    }
	
	function set_werehouse($val)
    {
		$the_session = array("werehouse" => $val);
		$this->session->set_userdata($the_session);
		$data = array('default_warehouse' => $val);
		$this->settings_model->updateSetting($data);
		//if($val=='' || $val==0)
		//{
			$the_session = array("store" => 0);
			$this->session->set_userdata($the_session);
		//}
    }
	
	function set_store($val)
    {
		$the_session = array("store" => $val);
		$this->session->set_userdata($the_session);
    }

    function paypal()
    {

        $this->form_validation->set_rules('active', $this->lang->line('activate'), 'trim');
        $this->form_validation->set_rules('account_email', $this->lang->line('paypal_account_email'), 'trim|valid_email');
        if ($this->input->post('active')) {
            $this->form_validation->set_rules('account_email', $this->lang->line('paypal_account_email'), 'required');
        }
        $this->form_validation->set_rules('fixed_charges', $this->lang->line('fixed_charges'), 'trim');
        $this->form_validation->set_rules('extra_charges_my', $this->lang->line('extra_charges_my'), 'trim');
        $this->form_validation->set_rules('extra_charges_other', $this->lang->line('extra_charges_others'), 'trim');

        if ($this->form_validation->run() == true) {

            $data = array('active' => $this->input->post('active'),
                'account_email' => $this->input->post('account_email'),
                'fixed_charges' => $this->input->post('fixed_charges'),
                'extra_charges_my' => $this->input->post('extra_charges_my'),
                'extra_charges_other' => $this->input->post('extra_charges_other')
            );
        }

        if ($this->form_validation->run() == true && $this->settings_model->updatePaypal($data)) {
            $this->session->set_flashdata('message', $this->lang->line('paypal_setting_updated'));
            admin_redirect("system_settings/paypal");
        } else {

            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

            $this->data['paypal'] = $this->settings_model->getPaypalSettings();

            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('paypal_settings')));
            $meta = array('page_title' => lang('paypal_settings'), 'bc' => $bc);
            $this->page_construct('settings/paypal', $meta, $this->data);
        }
    }

    function skrill()
    {

        $this->form_validation->set_rules('active', $this->lang->line('activate'), 'trim');
        $this->form_validation->set_rules('account_email', $this->lang->line('paypal_account_email'), 'trim|valid_email');
        if ($this->input->post('active')) {
            $this->form_validation->set_rules('account_email', $this->lang->line('paypal_account_email'), 'required');
        }
        $this->form_validation->set_rules('fixed_charges', $this->lang->line('fixed_charges'), 'trim');
        $this->form_validation->set_rules('extra_charges_my', $this->lang->line('extra_charges_my'), 'trim');
        $this->form_validation->set_rules('extra_charges_other', $this->lang->line('extra_charges_others'), 'trim');

        if ($this->form_validation->run() == true) {

            $data = array('active' => $this->input->post('active'),
                'account_email' => $this->input->post('account_email'),
                'fixed_charges' => $this->input->post('fixed_charges'),
                'extra_charges_my' => $this->input->post('extra_charges_my'),
                'extra_charges_other' => $this->input->post('extra_charges_other')
            );
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateSkrill($data)) {
            $this->session->set_flashdata('message', $this->lang->line('skrill_setting_updated'));
            admin_redirect("system_settings/skrill");
        } else {

            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

            $this->data['skrill'] = $this->settings_model->getSkrillSettings();

            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('skrill_settings')));
            $meta = array('page_title' => lang('skrill_settings'), 'bc' => $bc);
            $this->page_construct('settings/skrill', $meta, $this->data);
        }
    }

    function change_logo()
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            $this->sma->md();
        }
        $this->load->helper('security');
        $this->form_validation->set_rules('site_logo', lang("site_logo"), 'xss_clean');
        $this->form_validation->set_rules('login_logo', lang("login_logo"), 'xss_clean');
        $this->form_validation->set_rules('biller_logo', lang("biller_logo"), 'xss_clean');
        if ($this->form_validation->run() == true) {

            if ($_FILES['site_logo']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path . 'logos/';
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = 300;
                $config['max_height'] = 80;
                $config['overwrite'] = FALSE;
                $config['max_filename'] = 25;
                //$config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('site_logo')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $site_logo = $this->upload->file_name;
                $this->db->update('settings', array('logo' => $site_logo), array('setting_id' => 1));
            }

            if ($_FILES['login_logo']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path . 'logos/';
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = 300;
                $config['max_height'] = 80;
                $config['overwrite'] = FALSE;
                $config['max_filename'] = 25;
                //$config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('login_logo')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $login_logo = $this->upload->file_name;
                $this->db->update('settings', array('logo2' => $login_logo), array('setting_id' => 1));
            }

            if ($_FILES['biller_logo']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path . 'logos/';
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = 300;
                $config['max_height'] = 80;
                $config['overwrite'] = FALSE;
                $config['max_filename'] = 25;
                //$config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('biller_logo')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
            }

            $this->session->set_flashdata('message', lang('logo_uploaded'));
            redirect($_SERVER["HTTP_REFERER"]);

        } elseif ($this->input->post('upload_logo')) {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        } else {
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/change_logo', $this->data);
        }
    }

    public function write_index($timezone)
    {

        $template_path = './assets/config_dumps/index.php';
        $output_path = SELF;
        $index_file = file_get_contents($template_path);
        $new = str_replace("%TIMEZONE%", $timezone, $index_file);
        $handle = fopen($output_path, 'w+');
        @chmod($output_path, 0777);

        if (is_writable($output_path)) {
            if (fwrite($handle, $new)) {
                @chmod($output_path, 0644);
                return true;
            } else {
                @chmod($output_path, 0644);
                return false;
            }
        } else {
            @chmod($output_path, 0644);
            return false;
        }
    }

    function updates()
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->form_validation->set_rules('purchase_code', lang("purchase_code"), 'required');
        $this->form_validation->set_rules('envato_username', lang("envato_username"), 'required');
        if ($this->form_validation->run() == true) {
            $this->db->update('settings', array('purchase_code' => $this->input->post('purchase_code', TRUE), 'envato_username' => $this->input->post('envato_username', TRUE)), array('setting_id' => 1));
            admin_redirect('system_settings/updates');
        } else {
            $fields = array('version' => $this->Settings->version, 'code' => $this->Settings->purchase_code, 'username' => $this->Settings->envato_username, 'site' => base_url());
            $this->load->helper('update');
            $protocol = is_https() ? 'https://' : 'http://';
            $updates = get_remote_contents($protocol.'api.tecdiary.com/v1/update/', $fields);
            $this->data['updates'] = json_decode($updates);
            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('updates')));
            $meta = array('page_title' => lang('updates'), 'bc' => $bc);
            $this->page_construct('settings/updates', $meta, $this->data);
        }
    }

    function install_update($file, $m_version, $version)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->load->helper('update');
        save_remote_file($file . '.zip');
        $this->sma->unzip('./files/updates/' . $file . '.zip');
        if ($m_version) {
            $this->load->library('migration');
            if (!$this->migration->latest()) {
                $this->session->set_flashdata('error', $this->migration->error_string());
                admin_redirect("system_settings/updates");
            }
        }
        $this->db->update('settings', array('version' => $version, 'update' => 0), array('setting_id' => 1));
        unlink('./files/updates/' . $file . '.zip');
        $this->session->set_flashdata('success', lang('update_done'));
        admin_redirect("system_settings/updates");
    }

    function clean_database()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => 'Clean Database'));
        $meta = array('page_title' => 'Clean Database', 'bc' => $bc);
        $this->page_construct('settings/clean_database', $meta, $this->data);
    }

    function clean_db()
    {
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->settings_model->cleanDatabase();
        $this->session->set_flashdata('message', 'Database has been cleaned');
        admin_redirect("system_settings/clean_database");
    }

    function backups()
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->data['files'] = glob('./files/backups/*.zip', GLOB_BRACE);
        $this->data['dbs'] = glob('./files/backups/*.txt', GLOB_BRACE);
        krsort($this->data['files']); krsort($this->data['dbs']);
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('backups')));
        $meta = array('page_title' => lang('backups'), 'bc' => $bc);
        $this->page_construct('settings/backups', $meta, $this->data);
    }

    function backup_database()
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->load->dbutil();
        $prefs = array(
            'format' => 'txt',
            'filename' => 'sma_db_backup.sql'
        );
        $back = $this->dbutil->backup($prefs);
        $backup =& $back;
        $db_name = 'db-backup-on-' . date("Y-m-d-H-i-s") . '.txt';
        $save = './files/backups/' . $db_name;
        $this->load->helper('file');
        write_file($save, $backup);
        $this->session->set_flashdata('messgae', lang('db_saved'));
        admin_redirect("system_settings/backups");
    }

    function backup_files()
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $name = 'file-backup-' . date("Y-m-d-H-i-s");
        $this->sma->zip("./", './files/backups/', $name);
        $this->session->set_flashdata('messgae', lang('backup_saved'));
        admin_redirect("system_settings/backups");
        exit();
    }

    function restore_database($dbfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $file = file_get_contents('./files/backups/' . $dbfile . '.txt');
        // $this->db->conn_id->multi_query($file);
        mysqli_multi_query($this->db->conn_id, $file);
        $this->db->conn_id->close();
        admin_redirect('logout/db');
    }

    function download_database($dbfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->load->library('zip');
        $this->zip->read_file('./files/backups/' . $dbfile . '.txt');
        $name = $dbfile . '.zip';
        $this->zip->download($name);
        exit();
    }

    function download_backup($zipfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $this->load->helper('download');
        force_download('./files/backups/' . $zipfile . '.zip', NULL);
        exit();
    }

    function restore_backup($zipfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        $file = './files/backups/' . $zipfile . '.zip';
        $this->sma->unzip($file, './');
        $this->session->set_flashdata('success', lang('files_restored'));
        admin_redirect("system_settings/backups");
        exit();
    }

    function delete_database($dbfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        unlink('./files/backups/' . $dbfile . '.txt');
        $this->session->set_flashdata('messgae', lang('db_deleted'));
        admin_redirect("system_settings/backups");
    }

    function delete_backup($zipfile)
    {
        if (DEMO) {
            $this->session->set_flashdata('warning', lang('disabled_in_demo'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            admin_redirect("welcome");
        }
        unlink('./files/backups/' . $zipfile . '.zip');
        $this->session->set_flashdata('messgae', lang('backup_deleted'));
        admin_redirect("system_settings/backups");
    }

    function email_templates($template = "credentials")
    {

        $this->form_validation->set_rules('mail_body', lang('mail_message'), 'trim|required');
        $this->load->helper('file');
        $temp_path = is_dir('./themes/' . $this->theme . 'email_templates/');
        $theme = $temp_path ? $this->theme : 'default';
        if ($this->form_validation->run() == true) {
            $data = $_POST["mail_body"];
            if (write_file('./themes/' . $this->theme . 'email_templates/' . $template . '.html', $data)) {
                $this->session->set_flashdata('message', lang('message_successfully_saved'));
                admin_redirect('system_settings/email_templates#' . $template);
            } else {
                $this->session->set_flashdata('error', lang('failed_to_save_message'));
                admin_redirect('system_settings/email_templates#' . $template);
            }
        } else {

            $this->data['credentials'] = file_get_contents('./themes/' . $this->theme . 'email_templates/credentials.html');
            $this->data['sale'] = file_get_contents('./themes/' . $this->theme . 'email_templates/sale.html');
            $this->data['quote'] = file_get_contents('./themes/' . $this->theme . 'email_templates/quote.html');
            $this->data['purchase'] = file_get_contents('./themes/' . $this->theme . 'email_templates/purchase.html');
            $this->data['transfer'] = file_get_contents('./themes/' . $this->theme . 'email_templates/transfer.html');
            $this->data['payment'] = file_get_contents('./themes/' . $this->theme . 'email_templates/payment.html');
            $this->data['forgot_password'] = file_get_contents('./themes/' . $this->theme . 'email_templates/forgot_password.html');
            $this->data['activate_email'] = file_get_contents('./themes/' . $this->theme . 'email_templates/activate_email.html');
            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('email_templates')));
            $meta = array('page_title' => lang('email_templates'), 'bc' => $bc);
            $this->page_construct('settings/email_templates', $meta, $this->data);
        }
    }

    function create_group()
    {

        $this->form_validation->set_rules('group_name', lang('group_name'), 'required|alpha_dash|is_unique[groups.name]');

        if ($this->form_validation->run() == TRUE) {
            $data = array('name' => strtolower($this->input->post('group_name')), 'description' => $this->input->post('description'));
        } elseif ($this->input->post('create_group')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/user_groups");
        }

        if ($this->form_validation->run() == TRUE && ($new_group_id = $this->settings_model->addGroup($data))) {
            $this->session->set_flashdata('message', lang('group_added'));
            admin_redirect("system_settings/permissions/" . $new_group_id);

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['group_name'] = array(
                'name' => 'group_name',
                'id' => 'group_name',
                'type' => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('group_name'),
            );
            $this->data['description'] = array(
                'name' => 'description',
                'id' => 'description',
                'type' => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('description'),
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/create_group', $this->data);
        }
    }

    function edit_group($id)
    {

        if (!$id || empty($id)) {
            admin_redirect('system_settings/user_groups');
        }

        $group = $this->settings_model->getGroupByID($id);

        $this->form_validation->set_rules('group_name', lang('group_name'), 'required|alpha_dash');

        if ($this->form_validation->run() === TRUE) {
            $data = array('name' => strtolower($this->input->post('group_name')), 'description' => $this->input->post('description'));
            $group_update = $this->settings_model->updateGroup($id, $data);

            if ($group_update) {
                $this->session->set_flashdata('message', lang('group_udpated'));
            } else {
                $this->session->set_flashdata('error', lang('attempt_failed'));
            }
            admin_redirect("system_settings/user_groups");
        } else {


            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['group'] = $group;

            $this->data['group_name'] = array(
                'name' => 'group_name',
                'id' => 'group_name',
                'type' => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('group_name', $group->name),
            );
            $this->data['group_description'] = array(
                'name' => 'group_description',
                'id' => 'group_description',
                'type' => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('group_description', $group->description),
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_group', $this->data);
        }
    }

    function permissions($id = NULL)
    {

        $this->form_validation->set_rules('group', lang("group"), 'is_natural_no_zero');
        if ($this->form_validation->run() == true) {

            $data = array(
                'products-index' => $this->input->post('products-index'),
                'products-edit' => $this->input->post('products-edit'),
                'products-add' => $this->input->post('products-add'),
                'products-delete' => $this->input->post('products-delete'),
                'products-cost' => $this->input->post('products-cost'),
                'products-price' => $this->input->post('products-price'),
                'customers-index' => $this->input->post('customers-index'),
                'customers-edit' => $this->input->post('customers-edit'),
                'customers-add' => $this->input->post('customers-add'),
                'customers-delete' => $this->input->post('customers-delete'),
                'suppliers-index' => $this->input->post('suppliers-index'),
                'suppliers-edit' => $this->input->post('suppliers-edit'),
                'suppliers-add' => $this->input->post('suppliers-add'),
                'suppliers-delete' => $this->input->post('suppliers-delete'),
                'sales-index' => $this->input->post('sales-index'),
                'sales-edit' => $this->input->post('sales-edit'),
                'sales-add' => $this->input->post('sales-add'),
                'sales-delete' => $this->input->post('sales-delete'),
                'sales-email' => $this->input->post('sales-email'),
                'sales-pdf' => $this->input->post('sales-pdf'),
                'sales-deliveries' => $this->input->post('sales-deliveries'),
                'sales-edit_delivery' => $this->input->post('sales-edit_delivery'),
                'sales-add_delivery' => $this->input->post('sales-add_delivery'),
                'sales-delete_delivery' => $this->input->post('sales-delete_delivery'),
                'sales-email_delivery' => $this->input->post('sales-email_delivery'),
                'sales-pdf_delivery' => $this->input->post('sales-pdf_delivery'),
                'sales-gift_cards' => $this->input->post('sales-gift_cards'),
                'sales-edit_gift_card' => $this->input->post('sales-edit_gift_card'),
                'sales-add_gift_card' => $this->input->post('sales-add_gift_card'),
                'sales-delete_gift_card' => $this->input->post('sales-delete_gift_card'),
                'quotes-index' => $this->input->post('quotes-index'),
                'quotes-edit' => $this->input->post('quotes-edit'),
                'quotes-add' => $this->input->post('quotes-add'),
                'quotes-delete' => $this->input->post('quotes-delete'),
                'quotes-email' => $this->input->post('quotes-email'),
                'quotes-pdf' => $this->input->post('quotes-pdf'),
                'purchases-index' => $this->input->post('purchases-index'),
                'purchases-edit' => $this->input->post('purchases-edit'),
                'purchases-add' => $this->input->post('purchases-add'),
                'purchases-delete' => $this->input->post('purchases-delete'),
                'purchases-email' => $this->input->post('purchases-email'),
                'purchases-pdf' => $this->input->post('purchases-pdf'),
                'transfers-index' => $this->input->post('transfers-index'),
                'transfers-edit' => $this->input->post('transfers-edit'),
                'transfers-add' => $this->input->post('transfers-add'),
                'transfers-delete' => $this->input->post('transfers-delete'),
                'transfers-email' => $this->input->post('transfers-email'),
                'transfers-pdf' => $this->input->post('transfers-pdf'),
                'sales-return_sales' => $this->input->post('sales-return_sales'),
                'reports-quantity_alerts' => $this->input->post('reports-quantity_alerts'),
                'reports-expiry_alerts' => $this->input->post('reports-expiry_alerts'),
                'reports-products' => $this->input->post('reports-products'),
                'reports-daily_sales' => $this->input->post('reports-daily_sales'),
                'reports-monthly_sales' => $this->input->post('reports-monthly_sales'),
                'reports-payments' => $this->input->post('reports-payments'),
                'reports-sales' => $this->input->post('reports-sales'),
                'reports-purchases' => $this->input->post('reports-purchases'),
                'reports-customers' => $this->input->post('reports-customers'),
                'reports-suppliers' => $this->input->post('reports-suppliers'),
                'sales-payments' => $this->input->post('sales-payments'),
                'purchases-payments' => $this->input->post('purchases-payments'),
                'purchases-expenses' => $this->input->post('purchases-expenses'),
                'products-adjustments' => $this->input->post('products-adjustments'),
                'bulk_actions' => $this->input->post('bulk_actions'),
                'customers-deposits' => $this->input->post('customers-deposits'),
                'customers-delete_deposit' => $this->input->post('customers-delete_deposit'),
                'products-barcode' => $this->input->post('products-barcode'),
                'purchases-return_purchases' => $this->input->post('purchases-return_purchases'),
                'reports-expenses' => $this->input->post('reports-expenses'),
                'reports-daily_purchases' => $this->input->post('reports-daily_purchases'),
                'reports-monthly_purchases' => $this->input->post('reports-monthly_purchases'),
                'products-stock_count' => $this->input->post('products-stock_count'),
                'edit_price' => $this->input->post('edit_price'),
                'returns-index' => $this->input->post('returns-index'),
                'returns-edit' => $this->input->post('returns-edit'),
                'returns-add' => $this->input->post('returns-add'),
                'returns-delete' => $this->input->post('returns-delete'),
                'returns-email' => $this->input->post('returns-email'),
                'returns-pdf' => $this->input->post('returns-pdf'),
                'reports-tax' => $this->input->post('reports-tax'),
				'reports-warehouses_stock' => $this->input->post('reports-warehouses_stock'),
				'reports-store_stock' => $this->input->post('reports-store_stock'),
				'reports-govt_vat' => $this->input->post('reports-govt_vat'),
				'products-adjustments_stores' => $this->input->post('products-adjustments_stores'),
            );

            if (POS) {
                $data['pos-index'] = $this->input->post('pos-index');
            }

            //$this->sma->print_arrays($data);
        }


        if ($this->form_validation->run() == true && $this->settings_model->updatePermissions($id, $data)) {
            $this->session->set_flashdata('message', lang("group_permissions_updated"));
            redirect($_SERVER["HTTP_REFERER"]);
        } else {

            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

            $this->data['id'] = $id;
            $this->data['p'] = $this->settings_model->getGroupPermissions($id);
            $this->data['group'] = $this->settings_model->getGroupByID($id);

            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('group_permissions')));
            $meta = array('page_title' => lang('group_permissions'), 'bc' => $bc);
            $this->page_construct('settings/permissions', $meta, $this->data);
        }
    }

    function user_groups()
    {

        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('error', lang("access_denied"));
            admin_redirect('auth');
        }

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

        $this->data['groups'] = $this->settings_model->getGroups();
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('groups')));
        $meta = array('page_title' => lang('groups'), 'bc' => $bc);
        $this->page_construct('settings/user_groups', $meta, $this->data);
    }

    function delete_group($id = NULL)
    {

        if ($this->settings_model->checkGroupUsers($id)) {
            $this->session->set_flashdata('error', lang("group_x_b_deleted"));
            admin_redirect("system_settings/user_groups");
        }

        if ($this->settings_model->deleteGroup($id)) {
            $this->session->set_flashdata('message', lang("group_deleted"));
            admin_redirect("system_settings/user_groups");
        }
    }

    function currencies()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('currencies')));
        $meta = array('page_title' => lang('currencies'), 'bc' => $bc);
        $this->page_construct('settings/currencies', $meta, $this->data);
    }

    function getCurrencies()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, code, name, rate, symbol")
            ->from("currencies")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_currency/$1') . "' class='tip' title='" . lang("edit_currency") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_currency") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_currency/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        //->unset_column('id');

        echo $this->datatables->generate();
    }

    function add_currency()
    {

        $this->form_validation->set_rules('code', lang("currency_code"), 'trim|is_unique[currencies.code]|required');
        $this->form_validation->set_rules('name', lang("name"), 'required');
        $this->form_validation->set_rules('rate', lang("exchange_rate"), 'required|numeric');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'rate' => $this->input->post('rate'),
                'symbol' => $this->input->post('symbol'),
                'auto_update' => $this->input->post('auto_update') ? $this->input->post('auto_update') : 0,
            );
        } elseif ($this->input->post('add_currency')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/currencies");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addCurrency($data)) { //check to see if we are creating the customer
            $this->session->set_flashdata('message', lang("currency_added"));
            admin_redirect("system_settings/currencies");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['page_title'] = lang("new_currency");
            $this->load->view($this->theme . 'settings/add_currency', $this->data);
        }
    }

    function edit_currency($id = NULL)
    {

        $this->form_validation->set_rules('code', lang("currency_code"), 'trim|required');
        $cur_details = $this->settings_model->getCurrencyByID($id);
        if ($this->input->post('code') != $cur_details->code) {
            $this->form_validation->set_rules('code', lang("currency_code"), 'required|is_unique[currencies.code]');
        }
        $this->form_validation->set_rules('name', lang("currency_name"), 'required');
        $this->form_validation->set_rules('rate', lang("exchange_rate"), 'required|numeric');

        if ($this->form_validation->run() == true) {

            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'rate' => $this->input->post('rate'),
                'symbol' => $this->input->post('symbol'),
                'auto_update' => $this->input->post('auto_update') ? $this->input->post('auto_update') : 0,
            );
        } elseif ($this->input->post('edit_currency')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/currencies");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateCurrency($id, $data)) { //check to see if we are updateing the customer
            $this->session->set_flashdata('message', lang("currency_updated"));
            admin_redirect("system_settings/currencies");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['currency'] = $this->settings_model->getCurrencyByID($id);
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_currency', $this->data);
        }
    }

    function delete_currency($id = NULL)
    {

        if ($this->settings_model->deleteCurrency($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("currency_deleted")));
        }
    }

    function currency_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteCurrency($id);
                    }
                    $this->session->set_flashdata('message', lang("currencies_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('currencies'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('rate'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $sc = $this->settings_model->getCurrencyByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $sc->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $sc->name);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $sc->rate);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'currencies_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function categories()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('categories')));
        $meta = array('page_title' => lang('categories'), 'bc' => $bc);
        $this->page_construct('settings/categories', $meta, $this->data);
    }

    function getCategories()
    {

        $print_barcode = anchor('admin/products/print_barcodes/?category=$1', '<i class="fa fa-print"></i>', 'title="'.lang('print_barcodes').'" class="tip"');

        $this->load->library('datatables');
        $this->datatables
            ->select("{$this->db->dbprefix('categories')}.id as id, {$this->db->dbprefix('categories')}.image, {$this->db->dbprefix('categories')}.code, {$this->db->dbprefix('categories')}.name, {$this->db->dbprefix('categories')}.slug, c.name as parent", FALSE)
            ->from("categories")
            ->join("categories c", 'c.id=categories.parent_id', 'left')
            ->group_by('categories.id')
            ->add_column("Actions", "<div class=\"text-center\">".$print_barcode." <a href='" . admin_url('system_settings/edit_category/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_category") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_category") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_category/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_category()
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("category_code"), 'trim|is_unique[categories.code]|required');
        $this->form_validation->set_rules('name', lang("name"), 'required|min_length[3]');
        $this->form_validation->set_rules('slug', lang("slug"), 'required|is_unique[categories.slug]|alpha_dash');
        $this->form_validation->set_rules('userfile', lang("category_image"), 'xss_clean');

        if ($this->form_validation->run() == true) {
            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'slug' => $this->input->post('slug'),
                'parent_id' => $this->input->post('parent'),
                );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path;
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = $this->Settings->iwidth;
                $config['max_height'] = $this->Settings->iheight;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['image'] = $photo;
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = $this->upload_path . $photo;
                $config['new_image'] = $this->thumbs_path . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = $this->Settings->twidth;
                $config['height'] = $this->Settings->theight;
                $this->image_lib->clear();
                $this->image_lib->initialize($config);
                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
                if ($this->Settings->watermark) {
                    $this->image_lib->clear();
                    $wm['source_image'] = $this->upload_path . $photo;
                    $wm['wm_text'] = 'Copyright ' . date('Y') . ' - ' . $this->Settings->site_name;
                    $wm['wm_type'] = 'text';
                    $wm['wm_font_path'] = 'system/fonts/texb.ttf';
                    $wm['quality'] = '100';
                    $wm['wm_font_size'] = '16';
                    $wm['wm_font_color'] = '999999';
                    $wm['wm_shadow_color'] = 'CCCCCC';
                    $wm['wm_vrt_alignment'] = 'top';
                    $wm['wm_hor_alignment'] = 'left';
                    $wm['wm_padding'] = '10';
                    $this->image_lib->initialize($wm);
                    $this->image_lib->watermark();
                }
                $this->image_lib->clear();
                $config = NULL;
            }

        } elseif ($this->input->post('add_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/categories");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addCategory($data)) {
            $this->session->set_flashdata('message', lang("category_added"));
            admin_redirect("system_settings/categories");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['categories'] = $this->settings_model->getParentCategories();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_category', $this->data);

        }
    }

    function edit_category($id = NULL)
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("category_code"), 'trim|required');
        $pr_details = $this->settings_model->getCategoryByID($id);
        if ($this->input->post('code') != $pr_details->code) {
            $this->form_validation->set_rules('code', lang("category_code"), 'required|is_unique[categories.code]');
        }
        $this->form_validation->set_rules('slug', lang("slug"), 'required|alpha_dash');
        if ($this->input->post('slug') != $pr_details->slug) {
            $this->form_validation->set_rules('slug', lang("slug"), 'required|alpha_dash|is_unique[categories.slug]');
        }
        $this->form_validation->set_rules('name', lang("category_name"), 'required|min_length[3]');
        $this->form_validation->set_rules('userfile', lang("category_image"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'slug' => $this->input->post('slug'),
                'parent_id' => $this->input->post('parent'),
                );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path;
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = $this->Settings->iwidth;
                $config['max_height'] = $this->Settings->iheight;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['image'] = $photo;
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = $this->upload_path . $photo;
                $config['new_image'] = $this->thumbs_path . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = $this->Settings->twidth;
                $config['height'] = $this->Settings->theight;
                $this->image_lib->clear();
                $this->image_lib->initialize($config);
                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
                if ($this->Settings->watermark) {
                    $this->image_lib->clear();
                    $wm['source_image'] = $this->upload_path . $photo;
                    $wm['wm_text'] = 'Copyright ' . date('Y') . ' - ' . $this->Settings->site_name;
                    $wm['wm_type'] = 'text';
                    $wm['wm_font_path'] = 'system/fonts/texb.ttf';
                    $wm['quality'] = '100';
                    $wm['wm_font_size'] = '16';
                    $wm['wm_font_color'] = '999999';
                    $wm['wm_shadow_color'] = 'CCCCCC';
                    $wm['wm_vrt_alignment'] = 'top';
                    $wm['wm_hor_alignment'] = 'left';
                    $wm['wm_padding'] = '10';
                    $this->image_lib->initialize($wm);
                    $this->image_lib->watermark();
                }
                $this->image_lib->clear();
                $config = NULL;
            }

        } elseif ($this->input->post('edit_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/categories");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateCategory($id, $data)) {
            $this->session->set_flashdata('message', lang("category_updated"));
            admin_redirect("system_settings/categories");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['category'] = $this->settings_model->getCategoryByID($id);
            $this->data['categories'] = $this->settings_model->getParentCategories();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_category', $this->data);

        }
    }

    function delete_category($id = NULL)
    {

        if ($this->site->getSubCategories($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("category_has_subcategory")));
        }

        if ($this->settings_model->deleteCategory($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("category_deleted")));
        }
    }

    function category_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteCategory($id);
                    }
                    $this->session->set_flashdata('message', lang("categories_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('categories'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('image'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('parent_actegory'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $sc = $this->settings_model->getCategoryByID($id);
                        $parent_actegory = '';
                        if ($sc->parent_id) {
                            $pc = $this->settings_model->getCategoryByID($sc->parent_id);
                            $parent_actegory = $pc->code;
                        }
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $sc->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $sc->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $sc->image);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $parent_actegory);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'categories_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }
	
	public function combine_pdf($bank_accounts)
    {
        $this->sma->checkPermissions('pdf');
		foreach ($bank_accounts as $bank_account) 
		{			
			$amount = $bank_account->opening_balance;
			$where = 'bank_id = '.$bank_account->id.'';
			$transactions = $this->settings_model->getTransactionsBank($where, 0);
			foreach($transactions as $transaction)
			{
				$transaction_amount = $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;
				if(in_array($transaction->type, array('stb','b','ob','wtb'))){
					$amount = $amount + ($transaction_amount);
				}else{
					$amount = $amount - ($transaction_amount);
				}
			}
			$bank_account->current_balance = $amount;
		}
        $this->data['bank_accounts'] = $bank_accounts;
		$html_data = $this->load->view($this->theme . 'settings/bank_account_pdf', $this->data, true);			
		if (! $this->Settings->barcode_img) {
			$html_data = preg_replace("'\<\?xml(.*)\?\>'", '', $html_data);
		}

		$html[] = array(
			'content' => $html_data
		);

        $name = lang("bank_accounts") . ".pdf";
        $this->sma->generate_pdf($html, $name);
    }

    function bank_account_actions($wh = NULL)
    {
        if ((!$this->Owner && !$this->Admin) && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) 
		{
			$where = 'id != 0';
			$bank_accounts = $this->settings_model->get_bank_accounts_export($where);
            if (!empty($bank_accounts)) 
			{
				if ($this->input->post('form_action') == 'combine') 
				{
                    $html = $this->combine_pdf($bank_accounts);

                }
				else if ($this->input->post('form_action') == 'export_excel') 
				{
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle('Bank Accounts');
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('Account Title'));
					$this->excel->getActiveSheet()->SetCellValue('B1', lang('Account Number'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('Bank Name'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('Bank Address'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('Openning Balance'));
                    $this->excel->getActiveSheet()->SetCellValue('F1', lang('Current Balance'));

                    $row = 2;
                    foreach ($bank_accounts as $bank_account) 
					{						
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $bank_account->account_title);
						$this->excel->getActiveSheet()->SetCellValue('B' . $row, $bank_account->account_number);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $bank_account->bank_name);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $bank_account->branch_address);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $bank_account->opening_balance);
						
						$amount = $bank_account->opening_balance;
						$where = 'bank_id = '.$bank_account->id.'';
						$transactions = $this->settings_model->getTransactionsBank($where, 0);
						foreach($transactions as $transaction){
							$transaction_amount = $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;
							if(in_array($transaction->type, array('stb','b','ob','wtb'))){
								$amount = $amount + ($transaction_amount);
							}else{
								$amount = $amount - ($transaction_amount);
							}
						}
						//$bank->transactions = $transactions;
						$bank_account->current_balance = $amount;
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $bank_account->current_balance);
						
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
                    $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'bank_accounts_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } 
			else 
			{
                $this->session->set_flashdata('error', $this->lang->line("no_product_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } 
		else 
		{
            $this->session->set_flashdata('error', validation_errors());
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'admin/system_settings/bank_accounts');
        }
    }

    function bank_accounts()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('bank_accounts')));
        $meta = array('page_title' => lang('bank_accounts'), 'bc' => $bc);
		$banks = $this->settings_model->getBankAccounts();
		if(!empty($banks))
		{
			foreach($banks as $bank)
			{
				$amount = $bank->opening_balance;
				$where = 'bank_id = '.$bank->id.'';
				$transactions = $this->settings_model->getTransactionsBank($where, 0);
				foreach($transactions as $transaction){
					$transaction_amount = $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;
					if(in_array($transaction->type, array('stb','b','ob','wtb'))){
						$amount = $amount + ($transaction_amount);
					}else{
						$amount = $amount - ($transaction_amount);
					}
				}
				//$bank->transactions = $transactions;
				$bank->current_balance = $amount;
			}
		}
		
		$this->data['banks'] = $banks;
		//echo '<pre>';print_r($this->data['banks']);exit;
        $this->page_construct('settings/bank_accounts', $meta, $this->data);
    }

    function getBankAccounts()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("id,account_title,account_number,bank_name,branch_address,opening_balance", FALSE)
            ->from("bank_accounts")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/update_bank_account/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("update_bank_account") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_bank_account") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_bank_account/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
		//echo $this->db->last_query();exit;
        echo $this->datatables->generate();
    }

    function add_bank_account()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('account_title', lang("account_title"), 'trim|required');
        $this->form_validation->set_rules('account_number', lang("account_number"), 'trim|required|min_length[4]');
        $this->form_validation->set_rules('bank_name', lang("bank_name"), 'trim|required');
        $this->form_validation->set_rules('branch_address', lang("branch_address"), 'trim|required');
        $this->form_validation->set_rules('opening_balance', lang("opening_balance"), 'trim|required');

        if ($this->form_validation->run() == true) 
		{
            $data = array(
                'account_title' => $this->input->post('account_title'),
                'account_number' => $this->input->post('account_number'),
                'bank_name' => $this->input->post('bank_name'),
                'branch_address' => $this->input->post('branch_address'),
                'opening_balance' => $this->input->post('opening_balance'),
                'added_by' => $this->session->userdata('username'),
            );
        } 
		elseif ($this->input->post('add_bank_account')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/bank_accounts");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addBankAccount($data)) 
		{
            $this->session->set_flashdata('message', lang("bank_acc_added"));
            admin_redirect("system_settings/bank_accounts");
        } 
		else
		{

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['categories'] = $this->settings_model->getParentCategories();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_bank_account', $this->data);

        }
    }

    function update_bank_account($id = NULL)
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('account_title', lang("account_title"), 'trim|required');
        $this->form_validation->set_rules('account_number', lang("account_number"), 'trim|required|min_length[4]');
        $this->form_validation->set_rules('bank_name', lang("bank_name"), 'trim|required');
        $this->form_validation->set_rules('branch_address', lang("branch_address"), 'trim|required');
        $this->form_validation->set_rules('opening_balance', lang("opening_balance"), 'trim|required');

        if ($this->form_validation->run() == true) {

            $data = array(
                'account_title' => $this->input->post('account_title'),
                'account_number' => $this->input->post('account_number'),
                'bank_name' => $this->input->post('bank_name'),
                'branch_address' => $this->input->post('branch_address'),
                'opening_balance' => $this->input->post('opening_balance'),
            );

        } elseif ($this->input->post('update_bank_account')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/bank_accounts");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateBankAccount($id, $data)) 
		{
            $this->session->set_flashdata('message', lang("bank_acc_updated"));
            admin_redirect("system_settings/bank_accounts");
        } 
		else 
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['bank_account'] = $this->settings_model->getBankAccountByID($id);
            $this->data['modal_js'] = $this->site->modal_js();
  
            $this->load->view($this->theme . 'settings/update_bank_account', $this->data);

        }
    }

    function delete_bank_account($id = NULL)
    {
        if ($this->settings_model->deleteBankAccount($id)) 
		{
            $this->sma->send_json(array('error' => 0, 'msg' => lang("bank_acc_deleted")));
        }
    }

    function stores_balance()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang(''))));
        $meta = array('page_title' => ucwords(lang('')), 'bc' => $bc);
		
		$stores = $this->pos_model->getAllsStore();
		foreach($stores as $store)
		{
			$store_balance = $this->pos_model->getStoreBalance($store->id);
			$store->balance = $store_balance;
		}
		$this->data['stores'] = $stores;
		//echo '<pre>';print_r($this->data);exit;
        $this->page_construct('settings/stores_balance', $meta, $this->data);
    }

    function warehouse_balance()
    {
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang(''))));
        $meta = array('page_title' => ucwords(lang('')), 'bc' => $bc);
		
		$warehouses = $this->pos_model->getAllWarehouses();
		foreach($warehouses as $warehouse)
		{
			$warehouse_balance = $this->pos_model->getWarehouseBalance($warehouse->id);
            $warehouse->balance = $warehouse_balance;
        }
		$this->data['warehouses'] = $warehouses;
		//echo '<pre>';print_r($this->data);exit;
        $this->page_construct('settings/warehouse_balance', $meta, $this->data);
    }
	
    function warehouse_to_bank()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('warehouse', lang("warehouse"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			$Balance =  $this->pos_model->getWarehouseBalance($this->input->post('warehouse'));
			if($Balance >=  $this->input->post('amount'))
			{
				$data = array(
					'store_id' => 0,
					'type_id' => $this->input->post('warehouse'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount') * -1),
					'note' => $this->input->post('note'),
					'bank_id' => $this->input->post('bank'),
					'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'minus',
					'type' => 'wtb',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Warehouse balance is less than required deposit amount.');
            	admin_redirect("system_settings/warehouse_balance");
			}
        } 
		elseif ($this->input->post('warehouse_to_bank'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/warehouses");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_bank_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/warehouse_to_bank', $this->data);
        }
    }
	
    function bank_to_warehouse()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('warehouse', lang("warehouse"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			$Balance = $this->pos_model->getBankBalance( $this->input->post('bank'));
			if($Balance >=   $this->input->post('amount'))
			{
				$data = array(
					'store_id' => 0,
					'type_id' => $this->input->post('warehouse'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount') * 1),
					'note' => $this->input->post('note'),
					'bank_id' => $this->input->post('bank'),
					'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'plus',
					'type' => 'btw',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Bank balance is less than required deposit amount.');
            	admin_redirect("system_settings/bank_accounts");
			}
        } 
		elseif ($this->input->post('bank_to_warehouse'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/warehouses");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_bank_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/bank_to_warehouse', $this->data);
        }
    }
	
    function warehouse_to_store()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('store', lang("store"), 'trim|required');
        $this->form_validation->set_rules('warehouse', lang("warehouse"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			$Balance = $this->pos_model->getWarehouseBalance($this->input->post('warehouse'));
			if($Balance >=  $this->input->post('amount'))
			{
				$data = array(
					'store_id' => $this->input->post('store'),
					'type_id' => $this->input->post('warehouse'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount') * -1),
					'note' => $this->input->post('note'),
					'bank_id' => 0,
					'bank_deposit_reference_no' => '',
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'minus',
					'type' => 'wts',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Warehouse balance is less than required deposit amount.');
            	admin_redirect("system_settings/warehouses");
			}
        } 
		elseif ($this->input->post('warehouse_to_store'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/warehouses");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_store_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/warehouse_to_store', $this->data);
        }
    }
	
    function store_to_warehouse()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('store', lang("store"), 'trim|required');
        $this->form_validation->set_rules('warehouse', lang("warehouse"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			$Balance = $this->pos_model->getStoreBalance( $this->input->post('store'));
			if($Balance >=  $this->input->post('amount'))
			{
				$data = array(
					'store_id' => $this->input->post('store'),
					'type_id' => $this->input->post('warehouse'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount') * -1),
					'note' => $this->input->post('note'),
					'bank_id' => 0,
					'bank_deposit_reference_no' => '',
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'minus',
					'type' => 'stw',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Store balance is less than required deposit amount.');
            	admin_redirect("system_settings/stores_balance");
			}
        } 
		elseif ($this->input->post('store_to_warehouse'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/stores");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_store_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['warehouses'] = $this->pos_model->getAllWarehouses();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/store_to_warehouse', $this->data);
        }
    }
	
    function deduct_vat()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{

            $Balance = $this->pos_model->getBankBalance( $this->input->post('bank'));
            if($Balance >=  $this->input->post('amount'))
			{
                $data = array(
                    'store_id' => 0,
                    'user_id' => $this->session->userdata('user_id'),
                    'amount' => ($this->input->post('amount') * -1),
                    'note' => $this->input->post('note'),
                    'bank_id' => $this->input->post('bank'),
                    'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
                    'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
                    'added_by' => $this->session->userdata('user_id'),
                    'trasaction_type' => 'minus',
                    'type' => 'vat',
                );
			
                if($this->pos_model->addTransaction($data))
                {
                    $done = true;
                }
            }
            else
            {
                $this->session->set_flashdata('error', 'Bank balance is less than the posted amount.');
            	admin_redirect("system_settings/vat_reports");
            }
        } 
		elseif ($this->input->post('deduct_vat'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/deduct_vat");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("VAT_deducted_successfully"));
            admin_redirect("system_settings/vat_reports");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/deduct_vat', $this->data);
        }
    }
	
    function deposit_to_bank()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('store', lang("store"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			$Balance = $this->pos_model->getStoreBalance( $this->input->post('store'));
			if($Balance >=  $this->input->post('amount'))
			{
				$data = array(
					'store_id' => $this->input->post('store'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount') * -1),
					'note' => $this->input->post('note'),
					'bank_id' => $this->input->post('bank'),
					'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'minus',
					'type' => 'stb',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Store balance is less than required deposit amount.');
            	admin_redirect("system_settings/stores_balance");
			}
        } 
		elseif ($this->input->post('deposit_to_bank'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/stores");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_bank_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/deposit_to_bank', $this->data);
        }
    }
	
    function bank_deposit()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
			
			$data = array(
				'store_id' => 0,
				'user_id' => $this->session->userdata('user_id'),
				'amount' => ($this->input->post('amount') * 1),
				'note' => $this->input->post('note'),
				'bank_id' => $this->input->post('bank'),
				'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
				'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
				'added_by' => $this->session->userdata('user_id'),
				'trasaction_type' => 'plus',
				'type' => 'b',
			);
			
			if($this->pos_model->addTransaction($data))
			{
				$done = true;
			}
        } 
		elseif ($this->input->post('bank_deposit'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/bank_accounts");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_bank_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/bank_deposit', $this->data);
        }
    }
	
    function bank_withdraw()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
            $bank_balance = $this->pos_model->getBankBalance($this->input->post('bank'));
            if($bank_balance >= $this->input->post('amount'))
            {
                $data = array(
                    'store_id' => 0,
                    'user_id' => $this->session->userdata('user_id'),
                    'amount' => ($this->input->post('amount') * -1),
                    'note' => $this->input->post('note'),
                    'bank_id' => $this->input->post('bank'),
                    'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
                    'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
                    'added_by' => $this->session->userdata('user_id'),
                    'trasaction_type' => 'minus',
                    'type' => 'bw',
                );
                
                if($this->pos_model->addTransaction($data))
                {
                    $done = true;
                }
            }
            else
            {
                $this->session->set_flashdata('error', 'Balance is Not Sufficient for Payment');
                admin_redirect("system_settings/bank_accounts");
            }
			
        } 
		elseif ($this->input->post('bank_withdraw'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/bank_accounts");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_bank_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/bank_withdraw', $this->data);
        }
    }
   
    function deposit_to_store()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('amount', lang("amount"), 'trim|required');
        $this->form_validation->set_rules('bank', lang("bank"), 'trim|required');
        $this->form_validation->set_rules('store', lang("store"), 'trim|required');
        $this->form_validation->set_rules('trans_date', lang("date"), 'trim|required');
		
		
		$done = false;
        if ($this->form_validation->run() == true) 
		{
            $Balance = $this->pos_model->getBankBalance( $this->input->post('bank'));
			if($Balance >=  $this->input->post('amount'))
			{
				$data = array(
					'store_id' => $this->input->post('store'),
					'user_id' => $this->session->userdata('user_id'),
					'amount' => ($this->input->post('amount')),
					'note' => $this->input->post('note'),
					'bank_id' => $this->input->post('bank'),
					'bank_deposit_reference_no' => $this->input->post('bank_deposit_reference_no'),
					'added_on' => date('Y-m-d H:i:s',strtotime(str_replace('/','-',$this->input->post('trans_date')))),
					'added_by' => $this->session->userdata('user_id'),
					'trasaction_type' => 'plus',
					'type' => 'bts',
				);
				
				if($this->pos_model->addTransaction($data))
				{
					$done = true;
				}
			}
			else
			{
				$this->session->set_flashdata('error', 'Bank balance is less than required deposit amount.');
            	admin_redirect("system_settings/bank_accounts");
			}
        } 
		elseif ($this->input->post('deposit_to_store'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/stores_balance");
        }

        if ($this->form_validation->run() == true && $done == true)
		{
            $this->session->set_flashdata('message', lang("deposit_to_store_successfully"));
            admin_redirect("system_settings/transactions");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['banks'] = $this->settings_model->getBankAccounts();
            $this->data['stores'] = $this->pos_model->getAllsStore();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/deposit_to_store', $this->data);
        }
    }
	
	public function combine_pdf_transactions($transactions)
    {
        $this->sma->checkPermissions('pdf');

        $this->data['transactions'] = $transactions;
		$html_data = $this->load->view($this->theme . 'settings/transactions_pdf', $this->data, true);			
		if (! $this->Settings->barcode_img) {
			$html_data = preg_replace("'\<\?xml(.*)\?\>'", '', $html_data);
		}

		$html[] = array(
			'content' => $html_data
		);

        $name = lang("transactions") . ".pdf";
        $this->sma->generate_pdf($html, $name);
    }
	
	function transactions_actions($wh = NULL)
    {
        if ((!$this->Owner && !$this->Admin) && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) 
		{
			$where = 'transactions.id != 0';
			$from_date = '1970-01-01';
			$to_date = date('Y-m-d H:i:s');
			$store_id = 0;
			$warehouse_id = 0;
			$bank = '0';
		
			if(isset($_POST['hidden_date_from']) && trim($_POST['hidden_date_from']) != '')
			{
				$from_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_POST['hidden_date_from']))));
			}
			
			if(isset($_POST['hidden_date_to']) && trim($_POST['hidden_date_to']) != '')
			{
				$to_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_POST['hidden_date_to']))));
			}
			
			if($to_date < $from_date)
			{
				$to_date = date('Y-m-d H:i:s');;
			}
			
			if(isset($_POST['hidden_store_id']) && trim($_POST['hidden_store_id']) != '')
			{
				$store_id = trim($_POST['hidden_store_id']);
			}
			
			if(isset($_POST['hidden_warehouse_id']))
			{
				if(trim($_POST['hidden_warehouse_id']) != '')
				{
					$warehouse_id = trim($_POST['hidden_warehouse_id']);
				}
				$where .= ' AND transactions.type IN ("wtb","wts","stw","btw","purchase","expense") AND transactions.type_id != 0';
			}
			
			if($store_id == '-1')
			{
				$where .= ' AND store_id != 0';
			}
			else if($store_id != '0')
			{
				$where .= ' AND store_id = '.$store_id;
			}
			
			if($warehouse_id != '0')
			{
				if($store_id != '0' && in_array(trim($_POST['hidden_type']),array('purchase','expense')))
				{
					
				}
				else
				{					
					$where .= ' AND type_id = '.$warehouse_id;
				}
			}
			
			if(isset($_POST['hidden_bank_id']))
			{
				$where .= ' AND transactions.bank_id != 0';
				if(trim($_POST['hidden_bank_id']) != '')
				{
					$bank = trim($_POST['hidden_bank_id']);
					$where .= ' AND transactions.bank_id = '.$bank;
				}
			}
			
			if(isset($_POST['hidden_type']) && trim($_POST['hidden_type']) != '')
			{
				if(trim($_POST['hidden_type']) == 'sminus')
				{
					$where .= ' AND type = "s" AND trasaction_type ="minus"';
				}
				else if(trim($_POST['hidden_type']) == 'splus')
				{
					$where .= ' AND type = "s" AND trasaction_type ="plus"';
				}
				else
				{
					$where .= ' AND type = "'.trim($_POST['hidden_type']).'"';
				}
			}
			
			if(isset($_POST['hidden_warehouse']) && trim($_POST['hidden_warehouse']) != '')
			{
				//$where .= ' AND store_id = "'.trim($_POST['hidden_warehouse']).'"';
			}
			
			if(isset($_POST['hidden_bank']) && trim($_POST['hidden_bank']) != '' && trim($_POST['hidden_type']) != 'salary')
			{
				$where .= ' AND bank_id = "'.trim($_POST['hidden_bank']).'"';
			}
			
			if(trim($_POST['hidden_type']) == 'salary')
			{
				if(isset($_POST['hidden_bank']) && trim($_POST['hidden_bank']) != '' && isset($_POST['hidden_store_id']) && trim($_POST['hidden_store_id']) != '0')
				{
					$where .= ' AND (bank_id = "'.trim($_POST['hidden_bank']).'" OR store_id = "'.trim($_POST['hidden_store_id']).'")';
				}
				else if(isset($_POST['hidden_bank']) && trim($_POST['hidden_bank']) != '')
				{
					$where .= ' AND (bank_id = "'.trim($_POST['hidden_bank']).'")';
				}
				else if(isset($_POST['hidden_store_id']) && trim($_POST['hidden_store_id']) != '0')
				{
					$where .= ' AND (store_id = "'.trim($_POST['hidden_store_id']).'")';
				}				
			}
		
			$where .= ' AND transactions.added_on BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
			$where = str_replace('%20',' ',$where);
			//echo $where;exit;
			$transactions = $this->settings_model->getTransactionsExport($where);
            
			if(isset($_POST['hidden_bank_id']))
			{
				$databanks = $this->settings_model->getBankAccounts();
				foreach($databanks as $bank_acc)
				{
					if($bank == '0')
					{
						$transaction['id'] = -1;
						$transaction['username'] = $bank_acc->added_by;
						$transaction['name'] = '';
						$transaction['bank_name'] = $bank_acc->bank_name.' - '.$bank_acc->account_number;
						$transaction['amount'] = $bank_acc->opening_balance;
						$transaction['added_on'] = $bank_acc->added_on;
						$transaction['type'] = 'ob';
						$transaction['note'] = 'Opening Balance';
						$transaction['trasaction_type'] = 'plus';
						$transactions[count($transactions)] = (object)$transaction;
					}
					else if($bank == $bank_acc->id)
					{
						$transaction['id'] = -1;
						$transaction['username'] = $bank_acc->added_by;
						$transaction['name'] = '';
						$transaction['bank_name'] = $bank_acc->bank_name.' - '.$bank_acc->account_number;
						$transaction['amount'] = $bank_acc->opening_balance;
						$transaction['added_on'] = $bank_acc->added_on;
						$transaction['type'] = 'ob';
						$transaction['note'] = 'Opening Balance';
						$transaction['trasaction_type'] = 'plus';
						$transactions[count($transactions)] = (object)$transaction;
					}
				}
			}
			
            if (!empty($transactions)) 
			{
				if ($this->input->post('form_action') == 'combine') 
				{
                    $html = $this->combine_pdf_transactions($transactions);

                }
				else if ($this->input->post('form_action') == 'export_excel') 
				{
                    $type = array('sminus'=>'Store to Sale Register', 'splus'=>'Sale Register to Store','stb'=>'Store to Bank', 'bts'=>'Bank to Store', 'b' => 'Bank Deposit', 'bw' => 'Bank Withdraw', 'wts' => 'Warehouse to Store', 'stw' => 'Store to Warehouse', 'wtb' => 'Warehouse to Bank', 'btw' => 'Bank to Warehouse', 'purchase' => 'Purchase Payment', 'expense' => 'Expense', 'vat'=>'VAT Deducted from Bank');

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle('Bank Accounts');
					$this->excel->getActiveSheet()->SetCellValue('A1', lang('User'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang("warehouse").' / '.lang("Store"));
					$this->excel->getActiveSheet()->SetCellValue('C1', lang('bank_name'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('Amount'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('Added_On'));
                    $this->excel->getActiveSheet()->SetCellValue('F1', lang('Type'));
                    $this->excel->getActiveSheet()->SetCellValue('G1', lang('Note'));

                    $row = 2;$amount = 0; 
                    foreach ($transactions as $transaction) 
					{
						$transaction_amount = $transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount;
						if(in_array($transaction->type, array('stb','b','ob','wtb'))){
							$amount = $amount + ($transaction_amount);
						}else{
							$amount = $amount - ($transaction_amount);
						}
						$this->excel->getActiveSheet()->SetCellValue('A' . $row, $transaction->username);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, ($transaction->name != '') ? $transaction->name : ($transaction->warehouse != '' ? $transaction->warehouse : '--'));
						$this->excel->getActiveSheet()->SetCellValue('C' . $row, (($transaction->bank_name != '') ? $transaction->bank_name : '--'));
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, ($transaction->amount < 0 ? (-1*$transaction->amount) : $transaction->amount));
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, date('F d, Y',strtotime($transaction->added_on)));
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, (($transaction->type == 's') ? ($transaction->note == 'Sales' ? 'Sales Amount to Store' : ($transaction->note == 'Sales Return' ? 'Amount Deducted from Store' : $type[$transaction->type.$transaction->trasaction_type])) : $type[$transaction->type]));
						$this->excel->getActiveSheet()->SetCellValue('G' . $row, $transaction->note);
                        $row++;
                    }
					
					if(isset($_POST['hidden_bank_id']))
					{
						$this->excel->getActiveSheet()->SetCellValue('C' . ($row + 1), 'Ledger Balance');
						$this->excel->getActiveSheet()->SetCellValue('D' . ($row + 1), $amount);
					}
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
                    $this->excel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'transactions_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } 
			else 
			{
                $this->session->set_flashdata('error', $this->lang->line("No_Record_Found"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } 
		else 
		{
            $this->session->set_flashdata('error', validation_errors());
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'admin/system_settings/transactions');
        }
    }

    function transactions($store_id = 0, $from_date = '', $to_date = '', $offset = 0)
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang('transactions'))));
        $meta = array('page_title' => ucwords(lang('transactions')), 'bc' => $bc);
		
		$where = 'transactions.id != 0';
		$from_date = ($from_date == '') ? '1970-01-01' : $from_date;
        $to_date = ($to_date == '') ? date('Y-m-d H:i:s') : $to_date;
        $type =  isset($_GET['type']) ? trim($_GET['type']) : '';
        $warehouse =  isset($_GET['warehouse']) ? trim($_GET['warehouse']) : '';
        $bank =  isset($_GET['bank']) ? trim($_GET['bank']) : '';
        $txn = isset($_GET['txn']) ? trim($_GET['txn']) : '';
		
		$this->data['from_date'] = $this->data['to_date'] = '';
		if(isset($_GET['date_from']) && trim($_GET['date_from']) != '')
		{
			$this->data['from_date'] =trim($_GET['date_from']);
			$from_date = date('Y-m-d',strtotime(str_replace('/','-',trim($_GET['date_from']))));
		}
		
		if(isset($_GET['date_to']) && trim($_GET['date_to']) != '')
		{
			$this->data['to_date'] = trim($_GET['date_to']);
			$to_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_to']))));
		}
		
		if(isset($_GET['store_id']) && trim($_GET['store_id']) != '')
		{
			$store_id = trim($_GET['store_id']);
		}
		
		if($store_id == '-1')
		{
			$where .= ' AND store_id != 0';
		}
		else if($store_id != '0' && in_array(trim($_GET['type']),array('sminus','splus','stb','bts','wts','stw','purchase','expense')))
		{
			$where .= ' AND store_id = '.$store_id;
		}
		
		$this->data['ttype'] = $this->data['twarehouse'] = $this->data['tbank'] = '';
		
		if(isset($_GET['type']) && trim($_GET['type']) != '')
		{
			$this->data['ttype'] = trim($_GET['type']);
			if(trim($_GET['type']) == 'sminus')
			{
				$where .= ' AND type = "s" AND trasaction_type ="minus"';
			}
			else if(trim($_GET['type']) == 'splus')
			{
				$where .= ' AND type = "s" AND trasaction_type ="plus"';
			}
			else
			{
				$where .= ' AND type = "'.trim($_GET['type']).'"';
			}
		}
		
		if(isset($_GET['warehouse']) && trim($_GET['warehouse']) != '')
		{
			$this->data['twarehouse'] = trim($_GET['warehouse']);
			if($store_id != '0' && in_array(trim($_GET['type']),array('purchase','expense')))
			{
				
			}
			else
			{
				$where .= ' AND type_id = "'.trim($_GET['warehouse']).'"';
			}
		}
		
		if(isset($_GET['bank']) && trim($_GET['bank']) != '' && trim($_GET['type']) != 'salary')
		{
			$this->data['tbank'] = trim($_GET['bank']);
			$where .= ' AND bank_id = "'.trim($_GET['bank']).'"';
        }
		
		if(trim(isset($_GET['type']) && $_GET['type']) == 'salary')
		{
			if(isset($_GET['bank']) && trim($_GET['bank']) != '' && isset($_GET['store_id']) && trim($_GET['store_id']) != '0' && isset($_GET['warehouse']) && trim($_GET['warehouse']) != '0')
			{
				$this->data['tbank'] = trim($_GET['bank']);
				$where .= ' AND (bank_id = "'.trim($_GET['bank']).'" OR store_id = "'.trim($_GET['store_id']).'" OR type_id = "'.trim($_GET['warehouse']).'")';
			}
			else if(isset($_GET['bank']) && trim($_GET['bank']) != '')
			{
				$this->data['tbank'] = trim($_GET['bank']);
				$where .= ' AND (bank_id = "'.trim($_GET['bank']).'")';
			}
			else if(isset($_GET['store_id']) && trim($_GET['store_id']) != '0')
			{
				$where .= ' AND (store_id = "'.trim($_GET['store_id']).'")';
            }
            else if(isset($_GET['warehouse']) && trim($_GET['warehouse']) != '0')
			{
				$where .= ' AND (type_id = "'.trim($_GET['warehouse']).'")';
			}
			
        }
        
        if(trim(isset($_GET['type']) && $_GET['type']) == 'loan')
		{
			if(isset($_GET['bank']) && trim($_GET['bank']) != '' && isset($_GET['store_id']) && trim($_GET['store_id']) != '0' && isset($_GET['warehouse']) && trim($_GET['warehouse']) != '0')
			{
				$this->data['tbank'] = trim($_GET['bank']);
				$where .= ' AND (bank_id = "'.trim($_GET['bank']).'" OR store_id = "'.trim($_GET['store_id']).'" OR type_id = "'.trim($_GET['warehouse']).'")';
			}
			else if(isset($_GET['bank']) && trim($_GET['bank']) != '')
			{
				$this->data['tbank'] = trim($_GET['bank']);
				$where .= ' AND (bank_id = "'.trim($_GET['bank']).'")';
			}
			else if(isset($_GET['store_id']) && trim($_GET['store_id']) != '0')
			{
				$where .= ' AND (store_id = "'.trim($_GET['store_id']).'")';
            }
            else if(isset($_GET['warehouse']) && trim($_GET['warehouse']) != '0')
			{
				$where .= ' AND (type_id = "'.trim($_GET['warehouse']).'")';
			}
			
		}
		
		$this->data['txn'] = '';
		if(isset($_GET['txn']) && trim($_GET['txn']) != '')
		{
			$this->data['txn'] = $_GET['txn'];
			$txn = trim(str_replace('txn','',strtolower($_GET['txn'])));
			$where .= ' AND transactions.id = '.$txn;
		}
		//echo $where;exit;
		if($to_date < $from_date)
		{
			$to_date = date('Y-m-d H:i:s');;
		}
		$this->data['store_id'] = trim($store_id);
		$this->data['to_date'] = ($to_date != date('Y-m-d H:i:s')) ? trim($to_date) : '';
		$this->data['from_date'] = ($from_date != '1970-01-01') ? trim($from_date) : '';
		
		$where .= ' AND transactions.added_on BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
		$where = str_replace('%20',' ',$where);
		$total_transactions = $this->settings_model->getTransactionsCount($where);

		$this->load->library('pagination');
		$config['base_url']		= base_url().'admin/system_settings/transactions/'.$store_id.'/'.$from_date.'/'.$to_date;
		$config['total_rows']	= $total_transactions->total;
		$config['uri_segment'] 	= 7;
		$config['per_page']		= 20;
		$this->pagination->initialize($config);
		$this->data['links'] =  $this->pagination->create_links();
		
		$transactions = $this->settings_model->getTransactions($where, $offset);
		$this->data['transactions'] = $transactions;
		$this->data['stores'] = $this->pos_model->getAllsStore();
		$this->data['banks'] = $this->settings_model->getBankAccounts();
		$this->data['warehouses'] = $this->pos_model->getAllWarehouses();
		//echo '<pre>';print_r($this->data);exit;
		$this->page_construct('settings/transactions', $meta, $this->data);
    }

    function transaction_view($id = 0)
    {		
		$where = 'transactions.id = '.$id;
		$transactions = $this->settings_model->getTransactions($where, 0);
		$this->data['transactions'] = $transactions;
		//echo '<pre>';print_r($this->data);exit;
		$this->load->view($this->theme . 'settings/modal_view', $this->data);
    }

    function delete_transactions($id = 0)
    {		
		$transactions = $this->settings_model->delete_transactions($id);
		echo 1;
    }

    function vat_reports($from_date = '', $to_date = '', $offset = 0)
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang('VAT_Submit_Reports'))));
        $meta = array('page_title' => ucwords(lang('VAT_Submit_Reports')), 'bc' => $bc);
		
		$where = 'transactions.id != 0 AND type = "vat"';
		$from_date = ($from_date == '') ? '1970-01-01' : $from_date;
		$to_date = ($to_date == '') ? date('Y-m-d H:i:s') : $to_date;
		
		$this->data['from_date'] = $this->data['to_date'] = '';
		if(isset($_GET['date_from']) && trim($_GET['date_from']) != '')
		{
			$this->data['from_date'] =trim($_GET['date_from']);
			$from_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_from']))));
		}
		
		if(isset($_GET['date_to']) && trim($_GET['date_to']) != '')
		{
			$this->data['to_date'] = trim($_GET['date_to']);
			$to_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_to']))));
		}
		
		
		$this->data['to_date'] = ($to_date != date('Y-m-d H:i:s')) ? trim($to_date) : '';
		$this->data['from_date'] = ($from_date != '1970-01-01') ? trim($from_date) : '';
		
		$where .= ' AND transactions.added_on BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        $where = str_replace('%20',' ',$where);
        //echo $where; exit;
		$total_transactions = $this->settings_model->getTransactionsCount($where);
        $to_date = date('Y-m-d', strtotime($to_date));
        $from_date = date('Y-m-d', strtotime($from_date));
		$this->load->library('pagination');
		$config['base_url']		= base_url().'admin/system_settings/vat_reports/'.$from_date.'/'.$to_date;
		$config['total_rows']	= $total_transactions->total;
		$config['uri_segment'] 	= 6;
		$config['per_page']		= 20;
		$this->pagination->initialize($config);
		$this->data['links'] =  $this->pagination->create_links();
		
		$transactions = $this->settings_model->getTransactions($where, $offset);
		$this->data['transactions'] = $transactions;
		//echo '<pre>';print_r($this->data);exit;
		$this->page_construct('settings/vat_reports', $meta, $this->data);
    }

    function vat_report_view($id = 0)
    {		
		$where = 'transactions.id = '.$id;
		$transactions = $this->settings_model->getTransactions($where, 0);
		$this->data['transactions'] = $transactions;
		//echo '<pre>';print_r($this->data);exit;
		$this->load->view($this->theme . 'settings/modal_view', $this->data);
    }

    function loyality_points()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang('loyalty_points'))));
        $meta = array('page_title' => ucwords(lang('loyalty_points')), 'bc' => $bc);
		
		$this->load->helper('security');
        $this->form_validation->set_rules('amount_spent', lang("amount_spent"), 'trim|required');
        $this->form_validation->set_rules('loyality_points', lang("Earn_Loyality_Points"), 'trim|required');
        $this->form_validation->set_rules('per_points', lang("loyality_points"), 'trim|required');
        $this->form_validation->set_rules('credit', lang("get_credit"), 'trim|required');
		
		
        if ($this->form_validation->run() == true) 
		{
			$data = array(
				'amount_spent' => $this->input->post('amount_spent'),
				'updated_by' => $this->session->userdata('user_id'),
				'loyality_points' => ($this->input->post('loyality_points')),
				'per_points' => $this->input->post('per_points'),
				'credit' => $this->input->post('credit'),
				'updated_on' => date('Y-m-d H:i:s'),
			);
		}
		elseif ($this->input->post('update_loyality_points'))
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/loyality_points");
        }
      
		if ($this->form_validation->run() == true && $this->settings_model->updateLoyalitySettings($data))
		{
            $this->session->set_flashdata('message', ucwords(lang("loyality_points_updated_successfully")));
            admin_redirect("system_settings/loyality_points");
        } 
		else
		{
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
			$this->data['rec'] = $this->settings_model->getLoyalityPoints();
			//echo '<pre>';print_r($this->data);exit;
			$this->page_construct('settings/loyalty_points', $meta, $this->data);
        }
    }

    function ledger($bank = '0', $from_date = '', $to_date = '', $offset = 0)
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang('general_ledger'))));
        $meta = array('page_title' => ucwords(lang('general_ledger')), 'bc' => $bc);
		
		$where = 'transactions.bank_id != 0';
		$from_date = ($from_date == '') ? '1970-01-01' : $from_date;
		$to_date = ($to_date == '') ? date('Y-m-d H:i:s') : $to_date;
		
		if(isset($_GET['date_from']) && trim($_GET['date_from']) != '')
		{
			$from_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_from']))));
		}
		
		if(isset($_GET['date_to']) && trim($_GET['date_to']) != '')
		{
			$to_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_to']))));
		}
		
		if(isset($_GET['bank']) && trim($_GET['bank']) != '')
		{
			$bank = trim($_GET['bank']);
		}
		
		if($bank != '0')
		{
			$where .= ' AND bank_id = '.$bank;
		}
		
		$this->data['bank'] = trim($bank);
		$this->data['to_date'] = ($to_date != date('Y-m-d H:i:s')) ? trim($to_date) : '';
		$this->data['from_date'] = ($from_date != '1970-01-01') ? trim($from_date) : '';
		
		$where .= ' AND transactions.added_on BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
		$where = str_replace('%20',' ',$where);
		$total_transactions = $this->settings_model->getTransactionsCount($where);

		$this->load->library('pagination');
		$config['base_url']		= base_url().'admin/system_settings/ledger/'.$bank.'/'.$from_date.'/'.$to_date;
		$config['total_rows']	= $total_transactions->total;
		$config['uri_segment'] 	= 7;
		$config['per_page']		= 20;
		$this->pagination->initialize($config);
		$this->data['links'] =  $this->pagination->create_links();
		
		$transactions = $this->settings_model->getTransactions($where, $offset);
		
		$this->data['banks'] = $this->settings_model->getBankAccounts();
		foreach($this->data['banks'] as $bank_acc)
		{
			if($bank == '0')
			{
				$transaction['id'] = -1;
				$transaction['username'] = $bank_acc->added_by;
				$transaction['name'] = '';
				$transaction['bank_name'] = $bank_acc->bank_name.' - '.$bank_acc->account_number;
				$transaction['amount'] = $bank_acc->opening_balance;
				$transaction['added_on'] = $bank_acc->added_on;
				$transaction['type'] = 'ob';
				$transaction['note'] = 'Opening Balance';
				$transaction['trasaction_type'] = 'plus';
				$transactions[count($transactions)] = (object)$transaction;
			}
			else if($bank == $bank_acc->id)
			{
				$transaction['id'] = -1;
				$transaction['username'] = $bank_acc->added_by;
				$transaction['name'] = '';
				$transaction['bank_name'] = $bank_acc->bank_name.' - '.$bank_acc->account_number;
				$transaction['amount'] = $bank_acc->opening_balance;
				$transaction['added_on'] = $bank_acc->added_on;
				$transaction['type'] = 'ob';
				$transaction['note'] = 'Opening Balance';
				$transaction['trasaction_type'] = 'plus';
				$transactions[count($transactions)] = (object)$transaction;
			}
		}
		
		$this->data['transactions'] = $transactions;
		//echo '<pre>';print_r($this->data);exit;
		$this->page_construct('settings/ledger', $meta, $this->data);
    }

    function warehouse_transactions($warehouse_id = 0, $from_date = '', $to_date = '', $offset = 0)
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => ucwords(lang('transactions'))));
        $meta = array('page_title' => ucwords(lang('transactions')), 'bc' => $bc);
		
		$where = 'transactions.type IN ("wtb","wts","stw","btw","purchase") AND transactions.type_id != 0';
		$from_date = ($from_date == '') ? '1970-01-01' : $from_date;
		$to_date = ($to_date == '') ? date('Y-m-d H:i:s') : $to_date;
		
		$this->data['from_date'] = $this->data['to_date'] = '';
		if(isset($_GET['date_from']) && trim($_GET['date_from']) != '')
		{
			$this->data['from_date'] =trim($_GET['date_from']);
			$from_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_from']))));
		}
		
		if(isset($_GET['date_to']) && trim($_GET['date_to']) != '')
		{
			$this->data['to_date'] = trim($_GET['date_to']);
			$to_date = date('Y-m-d H:i:s',strtotime(str_replace('/','-',trim($_GET['date_to']))));
		}
		
		if(isset($_GET['warehouse_id']) && trim($_GET['warehouse_id']) != '')
		{
			$warehouse_id = trim($_GET['warehouse_id']);
		}
		
		if($warehouse_id != '0')
		{
			$where .= ' AND type_id = '.$warehouse_id;
		}
		//echo $where;exit;
		$this->data['warehouse_id'] = trim($warehouse_id);
		$this->data['to_date'] = ($to_date != date('Y-m-d H:i:s')) ? trim($to_date) : '';
		$this->data['from_date'] = ($from_date != '1970-01-01') ? trim($from_date) : '';
		
		$where .= ' AND transactions.added_on BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
		$where = str_replace('%20',' ',$where);
		$total_transactions = $this->settings_model->getWarehouseTransactionsCount($where);

		$this->load->library('pagination');
		$config['base_url']		= base_url().'admin/system_settings/warehouse_transactions/'.$warehouse_id.'/'.$from_date.'/'.$to_date;
		$config['total_rows']	= $total_transactions->total;
		$config['uri_segment'] 	= 7;
		$config['per_page']		= 20;
		$this->pagination->initialize($config);
		$this->data['links'] =  $this->pagination->create_links();
		
		$transactions = $this->settings_model->getWarehouseTransactions($where, $offset);
		$this->data['transactions'] = $transactions;
		$this->data['stores'] = $this->pos_model->getAllWarehouses();
		//echo '<pre>';print_r($this->data);exit;
		$this->page_construct('settings/warehouse_transactions', $meta, $this->data);
    }

    function getTransactions()
    {
        $this->load->library('datatables');
        $this->datatables
            ->select("transactions.id as id,users.username, stores.name,CONCAT(bank_name,' - ',account_number) as bank_name, transactions.amount, transactions.added_on, transactions.type", FALSE)
            ->from("transactions")
			->join('stores', 'transactions.store_id=stores.id', 'left')
			->join('bank_accounts', 'transactions.bank_id=bank_accounts.id', 'left')
			->join('users', 'transactions.user_id=users.id', 'left');
		//echo $this->db->last_query();exit;

        echo $this->datatables->generate();
    }
	
	
    function tax_rates()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('tax_rates')));
        $meta = array('page_title' => lang('tax_rates'), 'bc' => $bc);
        $this->page_construct('settings/tax_rates', $meta, $this->data);
    }

    function getTaxRates()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name, code, rate, type")
            ->from("tax_rates")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_tax_rate/$1') . "' class='tip' title='" . lang("edit_tax_rate") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_tax_rate") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_tax_rate/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        //->unset_column('id');

        echo $this->datatables->generate();
    }

    function add_tax_rate()
    {

        $this->form_validation->set_rules('name', lang("name"), 'trim|is_unique[tax_rates.name]|required');
        $this->form_validation->set_rules('type', lang("type"), 'required');
        $this->form_validation->set_rules('rate', lang("tax_rate"), 'required|numeric');

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'type' => $this->input->post('type'),
                'rate' => $this->input->post('rate'),
            );
        } elseif ($this->input->post('add_tax_rate')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/tax_rates");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addTaxRate($data)) {
            $this->session->set_flashdata('message', lang("tax_rate_added"));
            admin_redirect("system_settings/tax_rates");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_tax_rate', $this->data);
        }
    }

    function edit_tax_rate($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("name"), 'trim|required');
        $tax_details = $this->settings_model->getTaxRateByID($id);
        if ($this->input->post('name') != $tax_details->name) {
            $this->form_validation->set_rules('name', lang("name"), 'required|is_unique[tax_rates.name]');
        }
        $this->form_validation->set_rules('type', lang("type"), 'required');
        $this->form_validation->set_rules('rate', lang("tax_rate"), 'required|numeric');

        if ($this->form_validation->run() == true) {

            $data = array('name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'type' => $this->input->post('type'),
                'rate' => $this->input->post('rate'),
            );
        } elseif ($this->input->post('edit_tax_rate')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/tax_rates");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateTaxRate($id, $data)) { //check to see if we are updateing the customer
            $this->session->set_flashdata('message', lang("tax_rate_updated"));
            admin_redirect("system_settings/tax_rates");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['tax_rate'] = $this->settings_model->getTaxRateByID($id);

            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_tax_rate', $this->data);
        }
    }

    function delete_tax_rate($id = NULL)
    {
        if ($this->settings_model->deleteTaxRate($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("tax_rate_deleted")));
        }
    }

    function tax_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteTaxRate($id);
                    }
                    $this->session->set_flashdata('message', lang("tax_rates_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('tax_rates'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('tax_rate'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('type'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $tax = $this->settings_model->getTaxRateByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $tax->name);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $tax->code);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $tax->rate);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, ($tax->type == 1) ? lang('percentage') : lang('fixed'));
                        $row++;
                    }
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'tax_rates_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function customer_groups()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('customer_groups')));
        $meta = array('page_title' => lang('customer_groups'), 'bc' => $bc);
        $this->page_construct('settings/customer_groups', $meta, $this->data);
    }

    function getCustomerGroups()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name, percent")
            ->from("customer_groups")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_customer_group/$1') . "' class='tip' title='" . lang("edit_customer_group") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_customer_group") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_customer_group/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        //->unset_column('id');

        echo $this->datatables->generate();
    }

    function add_customer_group()
    {

        $this->form_validation->set_rules('name', lang("group_name"), 'trim|is_unique[customer_groups.name]|required');
        $this->form_validation->set_rules('percent', lang("group_percentage"), 'required|numeric');

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'),
                'percent' => $this->input->post('percent'),
            );
        } elseif ($this->input->post('add_customer_group')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/customer_groups");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addCustomerGroup($data)) {
            $this->session->set_flashdata('message', lang("customer_group_added"));
            admin_redirect("system_settings/customer_groups");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_customer_group', $this->data);
        }
    }

    function edit_customer_group($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("group_name"), 'trim|required');
        $pg_details = $this->settings_model->getCustomerGroupByID($id);
        if ($this->input->post('name') != $pg_details->name) {
            $this->form_validation->set_rules('name', lang("group_name"), 'required|is_unique[tax_rates.name]');
        }
        $this->form_validation->set_rules('percent', lang("group_percentage"), 'required|numeric');

        if ($this->form_validation->run() == true) {

            $data = array('name' => $this->input->post('name'),
                'percent' => $this->input->post('percent'),
            );
        } elseif ($this->input->post('edit_customer_group')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/customer_groups");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateCustomerGroup($id, $data)) {
            $this->session->set_flashdata('message', lang("customer_group_updated"));
            admin_redirect("system_settings/customer_groups");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['customer_group'] = $this->settings_model->getCustomerGroupByID($id);

            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_customer_group', $this->data);
        }
    }

    function delete_customer_group($id = NULL)
    {
        if ($this->settings_model->deleteCustomerGroup($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("customer_group_deleted")));
        }
    }

    function customer_group_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteCustomerGroup($id);
                    }
                    $this->session->set_flashdata('message', lang("customer_groups_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('tax_rates'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('group_name'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('group_percentage'));
                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $pg = $this->settings_model->getCustomerGroupByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $pg->name);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $pg->percent);
                        $row++;
                    }
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'customer_groups_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_customer_group_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function warehouses()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('warehouses')));
        $meta = array('page_title' => lang('warehouses'), 'bc' => $bc);
        $this->page_construct('settings/warehouses', $meta, $this->data);
    }

    function getWarehouses()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("{$this->db->dbprefix('warehouses')}.id as id, map, code, {$this->db->dbprefix('warehouses')}.name as name, {$this->db->dbprefix('price_groups')}.name as price_group, phone, email, address,opening_cash")
            ->from("warehouses")
            ->join('price_groups', 'price_groups.id=warehouses.price_group_id', 'left')
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_warehouse/$1') . "' class='tip' title='" . lang("edit_warehouse") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_warehouse") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_warehouse/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_warehouse()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("code"), 'trim|is_unique[warehouses.code]|required');
        $this->form_validation->set_rules('name', lang("name"), 'required');
        $this->form_validation->set_rules('address', lang("address"), 'required');
        $this->form_validation->set_rules('userfile', lang("map_image"), 'xss_clean');
        $this->form_validation->set_rules('opening_balance', lang("Opening_Balance"), 'trim|required');

        if ($this->form_validation->run() == true) {
            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = '2000';
                $config['max_height'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('message', $error);
                    admin_redirect("system_settings/warehouses");
                }

                $map = $this->upload->file_name;

                $this->load->helper('file');
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'assets/uploads/' . $map;
                $config['new_image'] = 'assets/uploads/thumbs/' . $map;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 76;
                $config['height'] = 76;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
            } else {
                $map = NULL;
            }
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'phone' => $this->input->post('phone'),
                'email' => $this->input->post('email'),
                'address' => $this->input->post('address'),
                'price_group_id' => $this->input->post('price_group'),
                'opening_cash' => $this->input->post('opening_balance'),
                'map' => $map,
            );
        } elseif ($this->input->post('add_warehouse')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/warehouses");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addWarehouse($data)) {
            $this->session->set_flashdata('message', lang("warehouse_added"));
            admin_redirect("system_settings/warehouses");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['price_groups'] = $this->settings_model->getAllPriceGroups();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_warehouse', $this->data);
        }
    }

    function edit_warehouse($id = NULL)
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("code"), 'trim|required');
        $wh_details = $this->settings_model->getWarehouseByID($id);
        if ($this->input->post('code') != $wh_details->code) {
            $this->form_validation->set_rules('code', lang("code"), 'required|is_unique[warehouses.code]');
        }
        $this->form_validation->set_rules('address', lang("address"), 'required');
        $this->form_validation->set_rules('map', lang("map_image"), 'xss_clean');
        $this->form_validation->set_rules('opening_balance', lang("Opening_Balance"), 'trim|required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'phone' => $this->input->post('phone'),
                'email' => $this->input->post('email'),
                'address' => $this->input->post('address'),
                'price_group_id' => $this->input->post('price_group'),
                'opening_cash' => $this->input->post('opening_balance'),
            );

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = '2000';
                $config['max_height'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('message', $error);
                    admin_redirect("system_settings/warehouses");
                }

                $data['map'] = $this->upload->file_name;

                $this->load->helper('file');
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'assets/uploads/' . $data['map'];
                $config['new_image'] = 'assets/uploads/thumbs/' . $data['map'];
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 76;
                $config['height'] = 76;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
            }
        } elseif ($this->input->post('edit_warehouse')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/warehouses");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateWarehouse($id, $data)) { //check to see if we are updateing the customer
            $this->session->set_flashdata('message', lang("warehouse_updated"));
            admin_redirect("system_settings/warehouses");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['warehouse'] = $this->settings_model->getWarehouseByID($id);
            $this->data['price_groups'] = $this->settings_model->getAllPriceGroups();
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_warehouse', $this->data);
        }
    }

    function delete_warehouse($id = NULL)
    {
        if ($this->settings_model->deleteWarehouse($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("warehouse_deleted")));
        }
    }

    function warehouse_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteWarehouse($id);
                    }
                    $this->session->set_flashdata('message', lang("warehouses_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('warehouses'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('address'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('city'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $wh = $this->settings_model->getWarehouseByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $wh->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $wh->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $wh->address);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $wh->city);
                        $row++;
                    }
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'warehouses_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_warehouse_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }


     function stores()
    {
        //echo {$this->db->dbprefix('stores')};die;

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('stores')));
        //print_r($this->data);die;
        $meta = array('page_title' => lang('stores'), 'bc' => $bc);
        $this->page_construct('settings/stores', $meta, $this->data);
    }

    function getStores()
    {
        $this->load->library('datatables');
		$this->datatables->join('warehouses', 'stores.warehouse_id = warehouses.id', 'left');
$this->datatables->select('stores.id as id,stores.map,stores.code,stores.name,warehouses.name as wh_name, stores.phone, stores.store_opening_cash, stores.address')
			->from('stores')
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_store/$1') . "' class='tip' title='" . ucwords(lang("edit_store")) . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . ucwords(lang("delete_store")) . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_store/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
		//print_r($data);
        echo $this->datatables->generate();
    }

    function getStores1()
    {
       $this->load->library('datatables');
        $this->datatables
            ->select("{$this->db->dbprefix('stores')}.id as id, map, code, {$this->db->dbprefix('stores')}.name as name, price_groups.name as price_groups, phone, email, address")
            ->from("stores")
            ->join('price_groups', 'price_groups.id=stores.price_group_id', 'left')
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_store/$1') . "' class='tip' title='" . lang("edit_store") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_store") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' data-id='del-store' href='" . admin_url('system_settings/delete_store/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
			echo $this->datatables->generate();
    }
	
	function getStoresByWarehouse()
    {
       $this->load->library('datatables');
		$this->datatables->join('warehouses', 'stores.warehouse_id = warehouses.id', 'left');
		$this->datatables->select('stores.id as id,stores.map, stores.code, stores.name,warehouses.name as wh_name, stores.phone, stores.store_opening_cash,stores.address')
			->from('stores')
			->where('warehouse_id', $this->session->userdata('werehouse'))
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_store/$1') . "' class='tip' title='" . lang("edit_store") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_store") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' data-id='del-store' href='" . admin_url('system_settings/delete_store/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
			echo $this->datatables->generate();
    }

    function add_store()
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("code"), 'trim|is_unique[stores.code]|required');
        $this->form_validation->set_rules('name', lang("name"), 'required');
		$this->form_validation->set_rules('store_opening_cash', lang("store_opening_cash"), 'trim|required');
        $this->form_validation->set_rules('address', lang("address"), 'required');
        $this->form_validation->set_rules('userfile', lang("map_image"), 'xss_clean');

        if ($this->form_validation->run() == true) {
            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = '2000';
                $config['max_height'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('message', $error);
                    admin_redirect("system_settings/stores");
                }

                $map = $this->upload->file_name;

                $this->load->helper('file');
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'assets/uploads/' . $map;
                $config['new_image'] = 'assets/uploads/thumbs/' . $map;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 76;
                $config['height'] = 76;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
            } else {
                $map = NULL;
            }
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'phone' => $this->input->post('phone'),
                'email' => $this->input->post('email'),
                'address' => $this->input->post('address'),
                'warehouse_id' => $this->input->post('warehouse'),
                'store_opening_cash' => $this->input->post('store_opening_cash'),
                'map' => $map,
            );
        } elseif ($this->input->post('add_store')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/stores");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addStore($data)) {
            $this->session->set_flashdata('message', lang("store_added"));
            admin_redirect("system_settings/stores");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['warehouses'] = $this->settings_model->getAllWarehouses();
            $this->data['modal_js'] = $this->site->modal_js();

            $this->load->view($this->theme . 'settings/add_store', $this->data);

        }
    }

    function edit_store($id = NULL)
    {
        $this->load->helper('security');
        $this->form_validation->set_rules('code', lang("code"), 'trim|required');
        $wh_details = $this->settings_model->getWarehouseByID($id);
        if ($this->input->post('code') != $wh_details->code) {
            $this->form_validation->set_rules('code', lang("code"), 'required');
        }
        $this->form_validation->set_rules('address', lang("address"), 'required');
        $this->form_validation->set_rules('map', lang("map_image"), 'xss_clean');
		$this->form_validation->set_rules('store_opening_cash', lang("store_opening_cash"), 'trim|required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'phone' => $this->input->post('phone'),
                'email' => $this->input->post('email'),
                'address' => $this->input->post('address'),
                'warehouse_id' => $this->input->post('warehouse'),
                'store_opening_cash' => $this->input->post('store_opening_cash'),
            );

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = '2000';
                $config['max_height'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('message', $error);
                    admin_redirect("system_settings/stores");
                }

                $data['map'] = $this->upload->file_name;

                $this->load->helper('file');
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'assets/uploads/' . $data['map'];
                $config['new_image'] = 'assets/uploads/thumbs/' . $data['map'];
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 76;
                $config['height'] = 76;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
            }
        } elseif ($this->input->post('edit_store')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/stores");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateStore($id, $data)) { //check to see if we are updateing the customer
            $this->session->set_flashdata('message', lang("store_updated"));
            admin_redirect("system_settings/stores");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['store'] = $this->settings_model->getStoreByID($id);
            $this->data['warehouses'] = $this->settings_model->getAllWarehouses();
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_store', $this->data);
        }
    }

    function delete_store($id = NULL)
    {
        if ($this->settings_model->deleteStore($id)) {
			$this->session->set_flashdata('error', lang("store_deleted"));
            //admin_redirect("system_settings/stores");
            $this->sma->send_json(array('error' => 0, 'msg' => lang("store_deleted")));
        }
    }

    function store_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteStore($id);
                    }
                    $this->session->set_flashdata('message', lang("stores_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('stores'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('address'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('city'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $wh = $this->settings_model->getStoreByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $wh->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $wh->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $wh->address);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $wh->city);
                        $row++;
                    }
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'stores_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_store_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function variants()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('variants')));
        $meta = array('page_title' => lang('variants'), 'bc' => $bc);
        $this->page_construct('settings/variants', $meta, $this->data);
    }

    function getVariants()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name")
            ->from("variants")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_variant/$1') . "' class='tip' title='" . lang("edit_variant") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_variant") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_variant/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        //->unset_column('id');

        echo $this->datatables->generate();
    }

    function add_variant()
    {

        $this->form_validation->set_rules('name', lang("name"), 'trim|is_unique[variants.name]|required');

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'));
        } elseif ($this->input->post('add_variant')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/variants");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addVariant($data)) {
            $this->session->set_flashdata('message', lang("variant_added"));
            admin_redirect("system_settings/variants");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_variant', $this->data);
        }
    }

    function edit_variant($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("name"), 'trim|required');
        $tax_details = $this->settings_model->getVariantByID($id);
        if ($this->input->post('name') != $tax_details->name) {
            $this->form_validation->set_rules('name', lang("name"), 'required|is_unique[variants.name]');
        }

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'));
        } elseif ($this->input->post('edit_variant')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/variants");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateVariant($id, $data)) {
            $this->session->set_flashdata('message', lang("variant_updated"));
            admin_redirect("system_settings/variants");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['variant'] = $tax_details;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_variant', $this->data);
        }
    }

    function delete_variant($id = NULL)
    {
        if ($this->settings_model->deleteVariant($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("variant_deleted")));
        }
    }

    function expense_categories()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('expense_categories')));
        $meta = array('page_title' => lang('categories'), 'bc' => $bc);
        $this->page_construct('settings/expense_categories', $meta, $this->data);
    }

    function getExpenseCategories()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, code, name")
            ->from("expense_categories")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_expense_category/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_expense_category") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_expense_category") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_expense_category/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_expense_category()
    {

        $this->form_validation->set_rules('code', lang("category_code"), 'trim|is_unique[categories.code]|required');
        $this->form_validation->set_rules('name', lang("name"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
            );

        } elseif ($this->input->post('add_expense_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/expense_categories");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addExpenseCategory($data)) {
            $this->session->set_flashdata('message', lang("expense_category_added"));
            admin_redirect("system_settings/expense_categories");
        } else {
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_expense_category', $this->data);
        }
    }

    function edit_expense_category($id = NULL)
    {
        $this->form_validation->set_rules('code', lang("category_code"), 'trim|required');
        $category = $this->settings_model->getExpenseCategoryByID($id);
        if ($this->input->post('code') != $category->code) {
            $this->form_validation->set_rules('code', lang("category_code"), 'required|is_unique[expense_categories.code]');
        }
        $this->form_validation->set_rules('name', lang("category_name"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {

            $data = array(
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name')
            );

        } elseif ($this->input->post('edit_expense_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/expense_categories");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateExpenseCategory($id, $data)) {
            $this->session->set_flashdata('message', lang("expense_category_updated"));
            admin_redirect("system_settings/expense_categories");
        } else {
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['category'] = $category;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_expense_category', $this->data);
        }
    }

    function delete_expense_category($id = NULL)
    {

        if ($this->settings_model->hasExpenseCategoryRecord($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("category_has_expenses")));
        }

        if ($this->settings_model->deleteExpenseCategory($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("expense_category_deleted")));
        }
    }

    function expense_category_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteCategory($id);
                    }
                    $this->session->set_flashdata('message', lang("categories_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('categories'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $sc = $this->settings_model->getCategoryByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $sc->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $sc->name);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'expense_categories_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function import_categories()
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');
                $config['upload_path'] = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = $this->allowed_file_size;
                $config['overwrite'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("system_settings/categories");
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen('files/' . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);
                $keys = array('code', 'name', 'image', 'pcode');
                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                foreach ($final as $csv_ct) {
                    if (!$this->settings_model->getCategoryByCode(trim($csv_ct['code']))) {
                        $pcode = trim($csv_ct['pcode']);
                        if (!empty($pcode)) {
                            if ($pcategory = $this->settings_model->getCategoryByCode($pcode)) {
                                $data[] = array(
                                    'code' => trim($csv_ct['code']),
                                    'name' => trim($csv_ct['name']),
                                    'image' => trim($csv_ct['image']),
                                    'parent_id' => $pcategory->id,
                                    );
                            }
                        } else {
                            $data[] = array(
                                'code' => trim($csv_ct['code']),
                                'name' => trim($csv_ct['name']),
                                'image' => trim($csv_ct['image']),
                                );
                        }
                    }
                }
            }

            // $this->sma->print_arrays($data);
        }

        if ($this->form_validation->run() == true && $this->settings_model->addCategories($data)) {
            $this->session->set_flashdata('message', lang("categories_added"));
            admin_redirect('system_settings/categories');
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['userfile'] = array('name' => 'userfile',
                'id' => 'userfile',
                'type' => 'text',
                'value' => $this->form_validation->set_value('userfile')
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'settings/import_categories', $this->data);

        }
    }

    function import_subcategories()
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');
                $config['upload_path'] = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = $this->allowed_file_size;
                $config['overwrite'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("system_settings/categories");
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen('files/' . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);
                $keys = array('code', 'name', 'category_code', 'image');
                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                $rw = 2;
                foreach ($final as $csv_ct) {
                    if ( ! $this->settings_model->getSubcategoryByCode(trim($csv_ct['code']))) {
                        if ($parent_actegory = $this->settings_model->getCategoryByCode(trim($csv_ct['category_code']))) {
                            $data[] = array(
                                'code' => trim($csv_ct['code']),
                                'name' => trim($csv_ct['name']),
                                'image' => trim($csv_ct['image']),
                                'category_id' => $parent_actegory->id,
                                );
                        } else {
                            $this->session->set_flashdata('error', lang("check_category_code") . " (" . $csv_ct['category_code'] . "). " . lang("category_code_x_exist") . " " . lang("line_no") . " " . $rw);
                            admin_redirect("system_settings/categories");
                        }
                    }
                    $rw++;
                }
            }

            // $this->sma->print_arrays($data);
        }

        if ($this->form_validation->run() == true && $this->settings_model->addSubCategories($data)) {
            $this->session->set_flashdata('message', lang("subcategories_added"));
            admin_redirect('system_settings/categories');
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['userfile'] = array('name' => 'userfile',
                'id' => 'userfile',
                'type' => 'text',
                'value' => $this->form_validation->set_value('userfile')
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'settings/import_subcategories', $this->data);

        }
    }

    function import_expense_categories()
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');
                $config['upload_path'] = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = $this->allowed_file_size;
                $config['overwrite'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("system_settings/expense_categories");
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen('files/' . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);
                $keys = array('code', 'name');
                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                foreach ($final as $csv_ct) {
                    if ( ! $this->settings_model->getExpenseCategoryByCode(trim($csv_ct['code']))) {
                        $data[] = array(
                            'code' => trim($csv_ct['code']),
                            'name' => trim($csv_ct['name']),
                            );
                    }
                }
            }

            // $this->sma->print_arrays($data);
        }

        if ($this->form_validation->run() == true && $this->settings_model->addExpenseCategories($data)) {
            $this->session->set_flashdata('message', lang("categories_added"));
            admin_redirect('system_settings/expense_categories');
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['userfile'] = array('name' => 'userfile',
                'id' => 'userfile',
                'type' => 'text',
                'value' => $this->form_validation->set_value('userfile')
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'settings/import_expense_categories', $this->data);

        }
    }

    function units()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('units')));
        $meta = array('page_title' => lang('units'), 'bc' => $bc);
        $this->page_construct('settings/units', $meta, $this->data);
    }

    function getUnits()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("{$this->db->dbprefix('units')}.id as id, {$this->db->dbprefix('units')}.code, {$this->db->dbprefix('units')}.name, b.name as base_unit, {$this->db->dbprefix('units')}.operator, {$this->db->dbprefix('units')}.operation_value", FALSE)
            ->from("units")
            ->join("units b", 'b.id=units.base_unit', 'left')
            ->group_by('units.id')
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_unit/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_unit") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_unit") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_unit/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_unit()
    {

        $this->form_validation->set_rules('code', lang("unit_code"), 'trim|is_unique[units.code]|required');
        $this->form_validation->set_rules('name', lang("unit_name"), 'trim|required');
        if ($this->input->post('base_unit')) {
            $this->form_validation->set_rules('operator', lang("operator"), 'required');
            $this->form_validation->set_rules('operation_value', lang("operation_value"), 'trim|required');
        }

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'base_unit' => $this->input->post('base_unit') ? $this->input->post('base_unit') : NULL,
                'operator' => $this->input->post('base_unit') ? $this->input->post('operator') : NULL,
                'operation_value' => $this->input->post('operation_value') ? $this->input->post('operation_value') : NULL,
                );

        } elseif ($this->input->post('add_unit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/units");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addUnit($data)) {
            $this->session->set_flashdata('message', lang("unit_added"));
            admin_redirect("system_settings/units");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['base_units'] = $this->site->getAllBaseUnits();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_unit', $this->data);

        }
    }

    function edit_unit($id = NULL)
    {

        $this->form_validation->set_rules('code', lang("code"), 'trim|required');
        $unit_details = $this->site->getUnitByID($id);
        if ($this->input->post('code') != $unit_details->code) {
            $this->form_validation->set_rules('code', lang("code"), 'required|is_unique[units.code]');
        }
        $this->form_validation->set_rules('name', lang("name"), 'trim|required');
        if ($this->input->post('base_unit')) {
            $this->form_validation->set_rules('operator', lang("operator"), 'required');
            $this->form_validation->set_rules('operation_value', lang("operation_value"), 'trim|required');
        }

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'base_unit' => $this->input->post('base_unit') ? $this->input->post('base_unit') : NULL,
                'operator' => $this->input->post('base_unit') ? $this->input->post('operator') : NULL,
                'operation_value' => $this->input->post('operation_value') ? $this->input->post('operation_value') : NULL,
                );

        } elseif ($this->input->post('edit_unit')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/units");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateUnit($id, $data)) {
            $this->session->set_flashdata('message', lang("unit_updated"));
            admin_redirect("system_settings/units");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['unit'] = $unit_details;
            $this->data['base_units'] = $this->site->getAllBaseUnits();
            $this->load->view($this->theme . 'settings/edit_unit', $this->data);

        }
    }

    function delete_unit($id = NULL)
    {

        if ($this->settings_model->getUnitChildren($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("unit_has_subunit")));
        }

        if ($this->settings_model->deleteUnit($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("unit_deleted")));
        }
    }

    function unit_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteUnit($id);
                    }
                    $this->session->set_flashdata('message', lang("units_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('categories'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('base_unit'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('operator'));
                    $this->excel->getActiveSheet()->SetCellValue('E1', lang('operation_value'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $unit = $this->site->getUnitByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $unit->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $unit->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $unit->base_unit);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $unit->operator);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $unit->operation_value);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'units_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function price_groups()
    {

        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');

        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('price_groups')));
        $meta = array('page_title' => lang('price_groups'), 'bc' => $bc);
        $this->page_construct('settings/price_groups', $meta, $this->data);
    }

    function getPriceGroups()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name")
            ->from("price_groups")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/group_product_prices/$1') . "' class='tip' title='" . lang("group_product_prices") . "'><i class=\"fa fa-eye\"></i></a>  <a href='" . admin_url('system_settings/edit_price_group/$1') . "' class='tip' title='" . lang("edit_price_group") . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_price_group") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_price_group/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");
        //->unset_column('id');

        echo $this->datatables->generate();
    }

    function add_price_group()
    {

        $this->form_validation->set_rules('name', lang("group_name"), 'trim|is_unique[price_groups.name]|required|alpha_numeric_spaces');

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'));
        } elseif ($this->input->post('add_price_group')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/price_groups");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addPriceGroup($data)) {
            $this->session->set_flashdata('message', lang("price_group_added"));
            admin_redirect("system_settings/price_groups");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_price_group', $this->data);
        }
    }

    function edit_price_group($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("group_name"), 'trim|required|alpha_numeric_spaces');
        $pg_details = $this->settings_model->getPriceGroupByID($id);
        if ($this->input->post('name') != $pg_details->name) {
            $this->form_validation->set_rules('name', lang("group_name"), 'required|is_unique[price_groups.name]');
        }

        if ($this->form_validation->run() == true) {
            $data = array('name' => $this->input->post('name'));
        } elseif ($this->input->post('edit_price_group')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/price_groups");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updatePriceGroup($id, $data)) {
            $this->session->set_flashdata('message', lang("price_group_updated"));
            admin_redirect("system_settings/price_groups");
        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

            $this->data['price_group'] = $pg_details;
            $this->data['id'] = $id;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/edit_price_group', $this->data);
        }
    }

    function delete_price_group($id = NULL)
    {
        if ($this->settings_model->deletePriceGroup($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("price_group_deleted")));
        }
    }

    function product_group_price_actions($group_id)
    {
        if (!$group_id) {
            $this->session->set_flashdata('error', lang('no_price_group_selected'));
            admin_redirect('system_settings/price_groups');
        }

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'update_price') {

                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->setProductPriceForPriceGroup($id, $group_id, $this->input->post('price'.$id));
                    }
                    $this->session->set_flashdata('message', lang("products_group_price_updated"));
                    redirect($_SERVER["HTTP_REFERER"]);

                } elseif ($this->input->post('form_action') == 'delete') {

                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteProductGroupPrice($id, $group_id);
                    }
                    $this->session->set_flashdata('message', lang("products_group_price_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);

                } elseif ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('tax_rates'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('product_code'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('product_name'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('price'));
                    $this->excel->getActiveSheet()->SetCellValue('D1', lang('group_name'));
                    $row = 2;
                    $group = $this->settings_model->getPriceGroupByID($group_id);
                    foreach ($_POST['val'] as $id) {
                        $pgp = $this->settings_model->getProductGroupPriceByPID($id, $group_id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $pgp->code);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $pgp->name);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $pgp->price);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $group->name);
                        $row++;
                    }
                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
                    $this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
                    $this->excel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'price_groups_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_price_group_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function group_product_prices($group_id = NULL)
    {

        if (!$group_id) {
            $this->session->set_flashdata('error', lang('no_price_group_selected'));
            admin_redirect('system_settings/price_groups');
        }

        $this->data['price_group'] = $this->settings_model->getPriceGroupByID($group_id);
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')),  array('link' => admin_url('system_settings/price_groups'), 'page' => lang('price_groups')), array('link' => '#', 'page' => lang('group_product_prices')));
        $meta = array('page_title' => lang('group_product_prices'), 'bc' => $bc);
        $this->page_construct('settings/group_product_prices', $meta, $this->data);
    }

    function getProductPrices($group_id = NULL)
    {
        if (!$group_id) {
            $this->session->set_flashdata('error', lang('no_price_group_selected'));
            admin_redirect('system_settings/price_groups');
        }

        $pp = "( SELECT {$this->db->dbprefix('product_prices')}.product_id as product_id, {$this->db->dbprefix('product_prices')}.price as price FROM {$this->db->dbprefix('product_prices')} WHERE price_group_id = {$group_id} ) PP";

        $this->load->library('datatables');
        $this->datatables
            ->select("{$this->db->dbprefix('products')}.id as id, {$this->db->dbprefix('products')}.code as product_code, {$this->db->dbprefix('products')}.name as product_name, PP.price as price ")
            ->from("products")
            ->join($pp, 'PP.product_id=products.id', 'left')
            ->edit_column("price", "$1__$2", 'id, price')
            ->add_column("Actions", "<div class=\"text-center\"><button class=\"btn btn-primary btn-xs form-submit\" type=\"button\"><i class=\"fa fa-check\"></i></button></div>", "id");

        echo $this->datatables->generate();
    }

    function update_product_group_price($group_id = NULL)
    {
        if (!$group_id) {
            $this->sma->send_json(array('status' => 0));
        }

        $product_id = $this->input->post('product_id', TRUE);
        $price = $this->input->post('price', TRUE);
        if (!empty($product_id) && !empty($price)) {
            if ($this->settings_model->setProductPriceForPriceGroup($product_id, $group_id, $price)) {
                $this->sma->send_json(array('status' => 1));
            }
        }

        $this->sma->send_json(array('status' => 0));
    }

    function update_prices_csv($group_id = NULL)
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (DEMO) {
                $this->session->set_flashdata('message', lang("disabled_in_demo"));
                admin_redirect('welcome');
            }

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');
                $config['upload_path'] = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = $this->allowed_file_size;
                $config['overwrite'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("system_settings/group_product_prices/".$group_id);
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen('files/' . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);

                $keys = array('code', 'price');

                $final = array();

                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }
                $rw = 2;
                foreach ($final as $csv_pr) {
                    if ($product = $this->site->getProductByCode(trim($csv_pr['code']))) {
                    $data[] = array(
                        'product_id' => $product->id,
                        'price' => $csv_pr['price'],
                        'price_group_id' => $group_id
                        );
                    } else {
                        $this->session->set_flashdata('message', lang("check_product_code") . " (" . $csv_pr['code'] . "). " . lang("code_x_exist") . " " . lang("line_no") . " " . $rw);
                        admin_redirect("system_settings/group_product_prices/".$group_id);
                    }
                    $rw++;
                }
            }

        } elseif ($this->input->post('update_price')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/group_product_prices/".$group_id);
        }

        if ($this->form_validation->run() == true && !empty($data)) {
            $this->settings_model->updateGroupPrices($data);
            $this->session->set_flashdata('message', lang("price_updated"));
            admin_redirect("system_settings/group_product_prices/".$group_id);
        } else {

            $this->data['userfile'] = array('name' => 'userfile',
                'id' => 'userfile',
                'type' => 'text',
                'value' => $this->form_validation->set_value('userfile')
            );
            $this->data['group'] = $this->site->getPriceGroupByID($group_id);
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'settings/update_price', $this->data);

        }
    }

    function brands()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('system_settings'), 'page' => lang('system_settings')), array('link' => '#', 'page' => lang('brands')));
        $meta = array('page_title' => lang('brands'), 'bc' => $bc);
        $this->page_construct('settings/brands', $meta, $this->data);
    }

    function getBrands()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, image, code, name, slug")
            ->from("brands")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('system_settings/edit_brand/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_brand") . "'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . lang("delete_brand") . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('system_settings/delete_brand/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_brand()
    {

        $this->form_validation->set_rules('name', lang("brand_name"), 'trim|required|is_unique[brands.name]|alpha_numeric_spaces');
        $this->form_validation->set_rules('slug', lang("slug"), 'trim|required|is_unique[brands.slug]|alpha_dash');

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'slug' => $this->input->post('slug'),
                );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path;
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = $this->Settings->iwidth;
                $config['max_height'] = $this->Settings->iheight;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['image'] = $photo;
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = $this->upload_path . $photo;
                $config['new_image'] = $this->thumbs_path . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = $this->Settings->twidth;
                $config['height'] = $this->Settings->theight;
                $this->image_lib->clear();
                $this->image_lib->initialize($config);
                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
                $this->image_lib->clear();
            }

        } elseif ($this->input->post('add_brand')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/brands");
        }

        if ($this->form_validation->run() == true && $this->settings_model->addBrand($data)) {
            $this->session->set_flashdata('message', lang("brand_added"));
            admin_redirect("system_settings/brands");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'settings/add_brand', $this->data);

        }
    }

    function edit_brand($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("brand_name"), 'trim|required|alpha_numeric_spaces');
        $brand_details = $this->site->getBrandByID($id);
        if ($this->input->post('name') != $brand_details->name) {
            $this->form_validation->set_rules('name', lang("brand_name"), 'required|is_unique[brands.name]');
        }
        $this->form_validation->set_rules('slug', lang("slug"), 'required|alpha_dash');
        if ($this->input->post('slug') != $brand_details->slug) {
            $this->form_validation->set_rules('slug', lang("slug"), 'required|alpha_dash|is_unique[brands.slug]');
        }

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                'code' => $this->input->post('code'),
                'slug' => $this->input->post('slug'),
                );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = $this->upload_path;
                $config['allowed_types'] = $this->image_types;
                $config['max_size'] = $this->allowed_file_size;
                $config['max_width'] = $this->Settings->iwidth;
                $config['max_height'] = $this->Settings->iheight;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $config['max_filename'] = 25;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['image'] = $photo;
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = $this->upload_path . $photo;
                $config['new_image'] = $this->thumbs_path . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = $this->Settings->twidth;
                $config['height'] = $this->Settings->theight;
                $this->image_lib->clear();
                $this->image_lib->initialize($config);
                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors();
                }
                $this->image_lib->clear();
            }

        } elseif ($this->input->post('edit_brand')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("system_settings/brands");
        }

        if ($this->form_validation->run() == true && $this->settings_model->updateBrand($id, $data)) {
            $this->session->set_flashdata('message', lang("brand_updated"));
            admin_redirect("system_settings/brands");
        } else {

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['brand'] = $brand_details;
            $this->load->view($this->theme . 'settings/edit_brand', $this->data);

        }
    }

    function delete_brand($id = NULL)
    {

        if ($this->settings_model->brandHasProducts($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("brand_has_products")));
        }

        if ($this->settings_model->deleteBrand($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("brand_deleted")));
        }
    }

    function import_brands()
    {

        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');
                $config['upload_path'] = 'files/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = $this->allowed_file_size;
                $config['overwrite'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect("system_settings/brands");
                }

                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen('files/' . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 5000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                $titles = array_shift($arrResult);
                $keys = array('name', 'code', 'image');
                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                foreach ($final as $csv_ct) {
                    if ( ! $this->settings_model->getBrandByName(trim($csv_ct['name']))) {
                        $data[] = array(
                            'code' => trim($csv_ct['code']),
                            'name' => trim($csv_ct['name']),
                            'image' => trim($csv_ct['image']),
                            );
                    }
                }
            }

            // $this->sma->print_arrays($data);
        }

        if ($this->form_validation->run() == true && !empty($data) && $this->settings_model->addBrands($data)) {
            $this->session->set_flashdata('message', lang("brands_added"));
            admin_redirect('system_settings/brands');
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['userfile'] = array('name' => 'userfile',
                'id' => 'userfile',
                'type' => 'text',
                'value' => $this->form_validation->set_value('userfile')
            );
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'settings/import_brands', $this->data);

        }
    }

    function brand_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->settings_model->deleteBrand($id);
                    }
                    $this->session->set_flashdata('message', lang("brands_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('brands'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('name'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('code'));
                    $this->excel->getActiveSheet()->SetCellValue('C1', lang('image'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $brand = $this->site->getBrandByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $brand->name);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $brand->code);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $brand->image);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'brands_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

}
