
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Levis',NULL,1,NULL,'2018-01-03 15:49:47','2018-01-03 15:49:47'),(2,1,'Espirit',NULL,1,NULL,'2018-01-03 15:49:58','2018-01-03 15:49:58'),(3,1,'U.S. Polo Assn.',NULL,1,NULL,'2018-01-03 15:50:26','2018-01-03 15:50:26'),(4,1,'Nike',NULL,1,NULL,'2018-01-03 15:50:34','2018-01-03 15:50:34'),(5,1,'Puma',NULL,1,NULL,'2018-01-03 15:50:40','2018-01-03 15:50:40'),(6,1,'Adidas',NULL,1,NULL,'2018-01-03 15:50:46','2018-01-03 15:50:46'),(7,1,'Samsung',NULL,1,NULL,'2018-01-06 00:10:14','2018-01-06 00:10:14'),(8,1,'Apple',NULL,1,NULL,'2018-01-06 00:10:23','2018-01-06 00:10:23'),(9,1,'Acer',NULL,1,NULL,'2018-01-06 00:33:37','2018-01-06 00:33:37'),(10,1,'Bowflex',NULL,1,NULL,'2018-01-06 00:45:31','2018-01-06 00:45:31'),(11,1,'Oreo',NULL,1,NULL,'2018-01-06 01:05:00','2018-01-06 01:05:00'),(12,1,'Sharewood',NULL,1,NULL,'2018-01-06 01:10:52','2018-01-06 01:10:52'),(13,1,'Barilla',NULL,1,NULL,'2018-01-06 01:14:59','2018-01-06 01:14:59'),(14,1,'Lipton',NULL,1,NULL,'2018-01-06 01:18:12','2018-01-06 01:18:12'),(15,2,'Acino',NULL,4,NULL,'2018-04-10 02:44:44','2018-04-10 02:44:44'),(16,2,'Cipla',NULL,4,NULL,'2018-04-10 02:45:04','2018-04-10 02:45:04'),(17,2,'BAYER',NULL,4,NULL,'2018-04-10 02:45:32','2018-04-10 02:45:32'),(18,3,'Samsung',NULL,5,NULL,'2018-04-10 05:27:28','2018-04-10 05:27:28'),(19,3,'LG',NULL,5,NULL,'2018-04-10 05:27:35','2018-04-10 05:27:35'),(20,3,'Apple',NULL,5,NULL,'2018-04-10 05:27:42','2018-04-10 05:27:42'),(21,3,'Sony',NULL,5,NULL,'2018-04-10 05:27:49','2018-04-10 05:27:49'),(22,3,'Panasonic',NULL,5,NULL,'2018-04-10 05:27:57','2018-04-10 05:27:57'),(23,3,'HP',NULL,5,NULL,'2018-04-10 05:37:21','2018-04-10 05:37:21');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Awesome Shop',2,'2018-01-01','3412569900','GSTIN',NULL,NULL,NULL,25.00,1,'America/Phoenix',1,'fifo',10.00,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,1,'before','null','m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,1,'2018-01-03 20:45:19','2018-08-12 17:51:29'),(2,'Awesome Pharmacy',2,'2018-04-10','3412569900','VAT',NULL,NULL,NULL,25.00,4,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AP',1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,1,1,1,1,1,0,4,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,1,'2018-04-10 02:42:40','2018-04-10 04:51:38'),(3,'Ultimate Electronics',2,'2018-04-10','12548555003','GST',NULL,NULL,NULL,25.00,5,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AE',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,1,1,1,1,1,0,5,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,1,'2018-04-10 05:16:15','2018-04-10 06:23:35'),(4,'Awesome Services',124,NULL,'3412569900','GST',NULL,NULL,NULL,25.00,6,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,0,1,0,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,1,'2018-04-10 06:50:42','2018-04-10 06:53:40'),(5,'Awesome Restaurant',2,'2018-07-12','4578220005','IGST','4593220009','SGST',NULL,25.00,7,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AR',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before','[\"tables\",\"modifiers\",\"service_staff\",\"kitchen\"]','m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,1,'2018-07-13 11:12:11','2018-08-02 19:11:56'),(6,'cxcxd',53,'2018-08-01',NULL,NULL,NULL,NULL,NULL,25.00,10,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\"}',NULL,NULL,1,'2018-08-06 14:45:34','2018-08-06 14:45:34');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,NULL,'Awesome Shop','Linking Street','USA','Arizona','Phoenix','85001',1,1,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 20:45:20','2018-01-03 20:45:20'),(2,2,NULL,'Awesome Pharmacy','Linking Street','USA','Arizona','Phoenix','492001',2,2,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(3,3,NULL,'Ultimate Electronics','Linking Street','USA','Arizona','Phoenix','492001',3,3,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(4,4,NULL,'Awesome Services','Linking Street','USA','Arizona','Phoenix','282001',4,4,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,5,NULL,'Awesome Restaurant','Linking Street','USA','Arizona','Phoenix','85001',5,5,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(6,6,'0001','cxcxd','wqw','India','odisha','kbj','77039',6,6,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,0.00,'cash','credit','initial',NULL,'2018-07-13 02:09:34','2018-07-13 02:09:34'),(2,1,42.50,'cash','credit','sell',41,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(3,1,0.00,'cash','credit','sell',41,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(4,1,77.50,'cash','credit','sell',42,'2018-07-13 02:15:29','2018-07-13 02:15:29'),(5,1,0.00,'cash','credit','sell',42,'2018-07-13 02:15:29','2018-07-13 02:15:29'),(6,1,33.75,'cash','credit','sell',43,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(7,1,0.00,'cash','credit','sell',43,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(8,1,71.25,'cash','credit','sell',44,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(9,1,0.00,'cash','credit','sell',44,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(10,2,0.00,'cash','credit','initial',NULL,'2018-08-05 16:22:12','2018-08-05 16:22:12'),(11,2,112.50,'cash','credit','sell',46,'2018-08-07 23:03:35','2018-08-07 23:03:35'),(12,2,0.00,'cash','credit','sell',46,'2018-08-07 23:03:35','2018-08-07 23:03:35');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,5,7,'open',NULL,0.00,0,0,NULL,'2018-07-13 02:09:34','2018-07-13 02:09:34'),(2,1,1,'open',NULL,0.00,0,0,NULL,'2018-08-05 16:22:12','2018-08-05 16:22:12');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Men\'s',1,NULL,0,1,NULL,'2018-01-03 15:36:34','2018-01-03 15:36:34'),(2,'Women\'s',1,NULL,0,1,NULL,'2018-01-03 15:36:46','2018-01-03 15:36:46'),(3,'Accessories',1,NULL,0,1,NULL,'2018-01-03 15:37:03','2018-01-03 15:37:03'),(4,'Jeans',1,NULL,1,1,NULL,'2018-01-03 15:37:34','2018-01-03 15:37:34'),(5,'Shirts',1,NULL,1,1,NULL,'2018-01-03 15:38:18','2018-01-03 15:38:18'),(6,'Belts',1,NULL,3,1,NULL,'2018-01-03 15:38:41','2018-01-03 15:38:41'),(8,'Shoes',1,NULL,3,1,NULL,'2018-01-03 15:39:04','2018-01-03 15:39:04'),(10,'Sandal',1,NULL,3,1,NULL,'2018-01-03 15:39:23','2018-01-03 15:39:23'),(11,'Wallets',1,NULL,3,1,NULL,'2018-01-03 17:35:50','2018-01-03 17:35:50'),(12,'Electronics',1,NULL,0,1,NULL,'2018-01-05 23:54:34','2018-01-05 23:54:34'),(13,'Cell Phones',1,NULL,12,1,NULL,'2018-01-05 23:54:57','2018-01-05 23:54:57'),(14,'Computers',1,NULL,12,1,NULL,'2018-01-05 23:55:55','2018-01-05 23:55:55'),(15,'Sports',1,NULL,0,1,NULL,'2018-01-05 23:57:33','2018-01-05 23:57:33'),(16,'Athletic Clothing',1,NULL,15,1,NULL,'2018-01-05 23:58:40','2018-01-05 23:58:40'),(17,'Exercise & Fitness',1,NULL,15,1,NULL,'2018-01-05 23:59:19','2018-01-05 23:59:19'),(18,'Books',1,NULL,0,1,NULL,'2018-01-05 23:59:59','2018-01-05 23:59:59'),(19,'Autobiography',1,NULL,18,1,NULL,'2018-01-06 00:00:16','2018-01-06 00:00:16'),(20,'Children\'s books',1,NULL,18,1,NULL,'2018-01-06 00:00:58','2018-01-06 00:00:58'),(21,'Food & Grocery',1,NULL,0,1,NULL,'2018-01-06 00:01:35','2018-01-06 00:01:35'),(22,'Capsule',2,NULL,0,4,NULL,'2018-04-10 02:49:58','2018-04-10 02:50:54'),(23,'Bandages',2,NULL,0,4,NULL,'2018-04-10 02:50:48','2018-04-10 02:50:48'),(24,'Cream',2,NULL,0,4,NULL,'2018-04-10 02:51:23','2018-04-10 02:51:23'),(25,'Drops',2,NULL,0,4,NULL,'2018-04-10 02:51:31','2018-04-10 02:51:31'),(26,'Gel',2,NULL,0,4,NULL,'2018-04-10 02:51:57','2018-04-10 02:51:57'),(27,'Bottle',2,NULL,0,4,NULL,'2018-04-10 02:52:30','2018-04-10 02:52:30'),(28,'Mobile Phones',3,NULL,0,5,NULL,'2018-04-10 05:29:49','2018-04-10 05:29:49'),(29,'Tablets',3,NULL,0,5,NULL,'2018-04-10 05:30:02','2018-04-10 05:30:02'),(30,'Laptops',3,NULL,0,5,NULL,'2018-04-10 05:30:09','2018-04-10 05:30:09'),(31,'TVs',3,NULL,0,5,NULL,'2018-04-10 05:30:15','2018-04-10 05:30:15'),(32,'Cameras',3,NULL,0,5,NULL,'2018-04-10 05:30:29','2018-04-10 05:30:29'),(33,'Accessories',3,NULL,0,5,NULL,'2018-04-10 05:30:57','2018-04-10 05:30:57'),(34,'Car Services',4,NULL,0,6,NULL,'2018-04-10 06:55:33','2018-04-10 07:00:10'),(35,'Hair Styling',4,NULL,0,6,NULL,'2018-04-10 06:58:32','2018-04-10 06:59:18'),(36,'Plumbing',4,NULL,0,6,NULL,'2018-04-10 07:00:41','2018-04-10 07:00:41'),(37,'Bodycare',4,NULL,0,6,NULL,'2018-04-10 07:00:52','2018-04-10 07:00:52'),(38,'Spa',4,NULL,0,6,NULL,'2018-04-10 07:01:01','2018-04-10 07:01:01'),(39,'Starter',5,NULL,0,7,NULL,'2018-07-12 19:19:08','2018-07-12 19:19:08'),(40,'Main Menu',5,NULL,0,7,NULL,'2018-07-12 19:19:24','2018-07-12 19:19:24'),(41,'Salad',5,NULL,0,7,NULL,'2018-07-12 19:20:15','2018-07-12 19:20:15'),(42,'Pizza',5,NULL,0,7,NULL,'2018-07-12 19:20:29','2018-07-12 19:20:29'),(43,'Desserts',5,NULL,0,7,NULL,'2018-07-12 19:20:40','2018-07-12 19:20:40'),(44,'Drinks',5,NULL,0,7,NULL,'2018-07-12 19:20:54','2018-07-12 19:20:54'),(45,'Bakery and Snacks',5,NULL,0,7,NULL,'2018-07-12 20:28:40','2018-07-12 20:28:40');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(20,2) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,'CO0005',NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:15:20','2018-06-11 16:52:05'),(2,1,'supplier','Alpha Clothings','Michael',NULL,'CO0001','4590091535','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:29:38','2018-06-11 16:51:03'),(3,1,'supplier','Manhattan Clothing Ltd.','Philip',NULL,'CO0003','54869310093','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:30:55','2018-06-11 16:51:36'),(4,1,'customer',NULL,'Harry',NULL,'CO0006',NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:31:40','2018-06-11 16:52:16'),(5,1,'supplier','Digital Ocean','Mike McCubbin',NULL,'CN0004','52965489001','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,30,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:23:22','2018-06-11 16:51:47'),(6,1,'supplier','Univer Suppliers','Jackson Hill',NULL,'CO0002','5459000655','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,45,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:25:09','2018-06-11 16:51:18'),(7,2,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(8,2,'supplier','Jones Pharma','Micheal Larson',NULL,'522500003',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:32:52','2018-04-10 04:32:52'),(9,2,'supplier','Axolotl Biologix','Phillip Jenner',NULL,'4585220005',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:34:20','2018-04-10 04:34:20'),(10,3,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(11,3,'supplier','Digital Ocean','Micheal Krick',NULL,'12500079',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,5,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:06:21','2018-04-10 06:06:21'),(12,3,'supplier','Neon Electronics','Samuel Williams',NULL,'525800083',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',NULL,5,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:08:33','2018-04-10 06:08:33'),(13,4,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(14,5,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(15,5,'supplier','Perfect Bakers','Thomas Willson','thomas@example.com','CO0002','45781005',NULL,NULL,NULL,NULL,'87850009358',NULL,NULL,10,'months',NULL,7,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-07-13 02:03:50','2018-07-13 02:03:50'),(16,1,'supplier','test','test',NULL,'test','test',NULL,NULL,NULL,NULL,'173002834',NULL,NULL,10,'months',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-06 02:05:47','2018-08-06 02:05:47'),(17,6,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,10,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
INSERT INTO `group_sub_taxes` VALUES (4,2),(4,3);
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,1,'classic',NULL,NULL,NULL,'2018-04-03 18:05:32','2018-04-03 18:05:32'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,2,'classic',NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,3,'classic',NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,4,'classic',NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,5,'classic',NULL,NULL,NULL,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(6,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,6,'classic',NULL,NULL,NULL,'2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','AS',1,7,4,1,'2018-01-03 20:45:20','2018-08-07 23:55:04'),(2,2,'Default','blank','AP',1,3,4,1,'2018-04-10 02:42:40','2018-04-10 04:56:12'),(3,3,'Default','blank','AE',1,5,4,1,'2018-04-10 05:16:16','2018-04-10 06:24:16'),(4,4,'Default','blank','',1,8,4,1,'2018-04-10 06:50:43','2018-04-10 07:38:49'),(5,5,'Default','blank','',1,4,4,1,'2018-07-13 05:42:11','2018-07-12 20:46:36'),(6,6,'Default','blank','',1,0,4,1,'2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2017_07_05_071953_create_currencies_table',1),(4,'2017_07_05_073658_create_business_table',1),(5,'2017_07_22_075923_add_business_id_users_table',1),(6,'2017_07_23_113209_create_brands_table',1),(7,'2017_07_26_083429_create_permission_tables',1),(8,'2017_07_26_110000_create_tax_rates_table',1),(9,'2017_07_26_122313_create_units_table',1),(10,'2017_07_27_075706_create_contacts_table',1),(11,'2017_08_04_071038_create_categories_table',1),(12,'2017_08_08_115903_create_products_table',1),(13,'2017_08_09_061616_create_variation_templates_table',1),(14,'2017_08_09_061638_create_variation_value_templates_table',1),(15,'2017_08_10_061146_create_product_variations_table',1),(16,'2017_08_10_061216_create_variations_table',1),(17,'2017_08_19_054827_create_transactions_table',1),(18,'2017_08_31_073533_create_purchase_lines_table',1),(19,'2017_10_15_064638_create_transaction_payments_table',1),(20,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(21,'2017_11_20_051930_create_table_group_sub_taxes',1),(22,'2017_11_20_063603_create_transaction_sell_lines',1),(23,'2017_11_21_064540_create_barcodes_table',1),(24,'2017_11_23_181237_create_invoice_schemes_table',1),(25,'2017_12_25_122822_create_business_locations_table',1),(26,'2017_12_25_160253_add_location_id_to_transactions_table',1),(27,'2017_12_25_163227_create_variation_location_details_table',1),(28,'2018_01_04_115627_create_sessions_table',1),(29,'2018_01_05_112817_create_invoice_layouts_table',1),(30,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(31,'2018_01_08_104124_create_expense_categories_table',1),(32,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(33,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(34,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(35,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(36,'2018_01_27_184322_create_printers_table',1),(37,'2018_01_30_181442_create_cash_registers_table',1),(38,'2018_01_31_125836_create_cash_register_transactions_table',1),(39,'2018_02_07_173326_modify_business_table',1),(40,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(41,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(42,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(43,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(44,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(45,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(46,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(47,'2018_02_13_183323_alter_decimal_fields_size',1),(48,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(49,'2018_02_15_161032_add_document_column_to_transactions_table',1),(50,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(51,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(52,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(53,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(54,'2018_02_21_105329_create_system_table',1),(55,'2018_02_23_100549_version_1_2',1),(56,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(57,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(58,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(59,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(60,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(61,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(62,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(63,'2018_03_06_210206_modify_product_barcode_types',1),(64,'2018_03_13_181541_add_expiry_type_to_business_table',1),(65,'2018_03_16_113446_product_expiry_setting_for_business',1),(66,'2018_03_19_113601_add_business_settings_options',1),(67,'2018_03_26_125334_add_pos_settings_to_business_table',1),(68,'2018_03_26_165350_create_customer_groups_table',1),(69,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(70,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(71,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(72,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(73,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(74,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(75,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(76,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(77,'2018_04_17_123122_add_lot_number_to_business',1),(78,'2018_04_17_160845_add_product_racks_table',1),(79,'2018_04_20_182015_create_res_tables_table',1),(80,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(81,'2018_04_24_114149_add_enabled_modules_business_table',1),(82,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(83,'2018_04_27_132653_quotation_related_change',1),(84,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(85,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(86,'2018_05_14_114027_add_rows_positions_for_products',1),(87,'2018_05_14_125223_add_weight_to_products_table',1),(88,'2018_05_14_164754_add_opening_stock_permission',1),(89,'2018_05_15_134729_add_design_to_invoice_layouts',1),(90,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(91,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(92,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(93,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(94,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(95,'2018_05_22_123527_create_reference_counts_table',1),(96,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(97,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(98,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(99,'2018_05_25_180603_create_modifiers_related_table',1),(100,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(101,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(102,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(103,'2018_06_05_111905_modify_products_table_for_modifiers',1),(104,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(105,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(106,'2018_06_07_182258_add_image_field_to_products_table',1),(107,'2018_06_13_133705_create_bookings_table',1),(108,'2018_06_15_173636_add_email_column_to_contacts_table',1),(109,'2018_06_27_182835_add_superadmin_related_fields_business',1),(110,'2018_06_27_185405_create_packages_table',1),(111,'2018_06_28_182803_create_subscriptions_table',1),(112,'2018_07_10_101913_add_custom_fields_to_products_table',1),(113,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(114,'2018_07_17_120612_change_all_quantity_field_type_to_decimal',1),(115,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(116,'2018_07_17_182021_add_rows_to_system_table',1),(117,'2018_07_19_131721_add_options_to_packages_table',1),(118,'2018_07_24_152720_create_payment_accounts_table',1),(119,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(120,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(121,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(122,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(123,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(124,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(125,'2018_07_18_104802_add_column_to_product_table',2),(126,'2018_08_04_115904_add_delivery_status_to_transactions_table',2),(127,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',2),(128,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(2,2,'App\\User'),(1,3,'App\\User'),(3,4,'App\\User'),(5,5,'App\\User'),(7,6,'App\\User'),(9,7,'App\\User'),(11,8,'App\\User'),(1,9,'App\\User'),(12,10,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(20,4) NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Starter - Free','Give it a test drive...',1,2,30,0,0,0,0,30,'months',1,10,0.0000,1,0,1,NULL,'2018-08-01 14:36:32','2018-08-01 14:40:49'),(2,'Regular','For Small Shops',2,4,1000,0,0,0,0,800,'months',1,10,199.9900,1,1,1,NULL,'2018-08-01 14:37:50','2018-08-01 14:42:30'),(3,'Unlimited','For Large Business',0,0,0,0,0,0,0,0,'months',1,10,599.9900,1,1,1,NULL,'2018-08-01 14:43:37','2018-08-01 14:43:50'),(4,'Business','For Small & Growing Shops...',10,10,15000,0,0,0,0,1000,'months',1,10,259.9900,1,5,0,NULL,'2018-08-01 14:46:14','2018-08-01 14:46:14');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_accounts` WRITE;
/*!40000 ALTER TABLE `payment_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2018-08-02 17:17:25',NULL),(2,'direct_sell.access','web','2018-08-02 17:17:25',NULL),(3,'product.opening_stock','web','2018-08-02 17:18:17','2018-08-02 17:18:17'),(4,'crud_all_bookings','web','2018-08-02 17:18:40','2018-08-02 17:18:40'),(5,'crud_own_bookings','web','2018-08-02 17:18:40','2018-08-02 17:18:40'),(6,'user.view','web','2018-08-02 17:19:19',NULL),(7,'user.create','web','2018-08-02 17:19:19',NULL),(8,'user.update','web','2018-08-02 17:19:19',NULL),(9,'user.delete','web','2018-08-02 17:19:19',NULL),(10,'supplier.view','web','2018-08-02 17:19:19',NULL),(11,'supplier.create','web','2018-08-02 17:19:19',NULL),(12,'supplier.update','web','2018-08-02 17:19:19',NULL),(13,'supplier.delete','web','2018-08-02 17:19:19',NULL),(14,'customer.view','web','2018-08-02 17:19:19',NULL),(15,'customer.create','web','2018-08-02 17:19:19',NULL),(16,'customer.update','web','2018-08-02 17:19:19',NULL),(17,'customer.delete','web','2018-08-02 17:19:19',NULL),(18,'product.view','web','2018-08-02 17:19:19',NULL),(19,'product.create','web','2018-08-02 17:19:19',NULL),(20,'product.update','web','2018-08-02 17:19:19',NULL),(21,'product.delete','web','2018-08-02 17:19:19',NULL),(22,'purchase.view','web','2018-08-02 17:19:19',NULL),(23,'purchase.create','web','2018-08-02 17:19:19',NULL),(24,'purchase.update','web','2018-08-02 17:19:19',NULL),(25,'purchase.delete','web','2018-08-02 17:19:19',NULL),(26,'sell.view','web','2018-08-02 17:19:19',NULL),(27,'sell.create','web','2018-08-02 17:19:19',NULL),(28,'sell.update','web','2018-08-02 17:19:19',NULL),(29,'sell.delete','web','2018-08-02 17:19:19',NULL),(30,'purchase_n_sell_report.view','web','2018-08-02 17:19:19',NULL),(31,'contacts_report.view','web','2018-08-02 17:19:19',NULL),(32,'stock_report.view','web','2018-08-02 17:19:19',NULL),(33,'tax_report.view','web','2018-08-02 17:19:19',NULL),(34,'trending_product_report.view','web','2018-08-02 17:19:19',NULL),(35,'register_report.view','web','2018-08-02 17:19:19',NULL),(36,'sales_representative.view','web','2018-08-02 17:19:19',NULL),(37,'expense_report.view','web','2018-08-02 17:19:19',NULL),(38,'business_settings.access','web','2018-08-02 17:19:19',NULL),(39,'barcode_settings.access','web','2018-08-02 17:19:19',NULL),(40,'invoice_settings.access','web','2018-08-02 17:19:19',NULL),(41,'brand.view','web','2018-08-02 17:19:19',NULL),(42,'brand.create','web','2018-08-02 17:19:19',NULL),(43,'brand.update','web','2018-08-02 17:19:19',NULL),(44,'brand.delete','web','2018-08-02 17:19:19',NULL),(45,'tax_rate.view','web','2018-08-02 17:19:19',NULL),(46,'tax_rate.create','web','2018-08-02 17:19:19',NULL),(47,'tax_rate.update','web','2018-08-02 17:19:19',NULL),(48,'tax_rate.delete','web','2018-08-02 17:19:19',NULL),(49,'unit.view','web','2018-08-02 17:19:19',NULL),(50,'unit.create','web','2018-08-02 17:19:19',NULL),(51,'unit.update','web','2018-08-02 17:19:19',NULL),(52,'unit.delete','web','2018-08-02 17:19:19',NULL),(53,'category.view','web','2018-08-02 17:19:19',NULL),(54,'category.create','web','2018-08-02 17:19:19',NULL),(55,'category.update','web','2018-08-02 17:19:19',NULL),(56,'category.delete','web','2018-08-02 17:19:19',NULL),(57,'expense.access','web','2018-08-02 17:19:19',NULL),(58,'access_all_locations','web','2018-08-02 17:19:19',NULL),(59,'dashboard.data','web','2018-08-02 17:19:19',NULL),(60,'location.1','web','2018-08-02 17:19:27',NULL),(61,'location.2','web','2018-08-02 17:19:28',NULL),(62,'location.3','web','2018-08-02 17:19:28',NULL),(63,'location.4','web','2018-08-02 17:19:29',NULL),(64,'location.5','web','2018-08-02 17:19:30',NULL),(65,'location.6','web','2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,'DUMMY',1,1,'2018-01-03 15:59:08','2018-01-03 15:59:08'),(2,'Waist Size',2,0,'2018-01-03 16:00:35','2018-01-05 23:44:12'),(3,'Size',3,0,'2018-01-03 17:21:52','2018-01-05 23:43:48'),(4,'Size',4,0,'2018-01-03 17:24:34','2018-01-05 23:49:36'),(8,'Size',8,0,'2018-01-03 17:40:10','2018-01-05 23:48:46'),(9,'Size',9,0,'2018-01-03 17:41:57','2018-01-05 23:50:01'),(10,'Size',10,0,'2018-01-03 17:43:02','2018-01-05 23:49:20'),(11,'DUMMY',11,1,'2018-01-03 17:44:35','2018-01-03 17:44:35'),(12,'DUMMY',12,1,'2018-01-03 17:45:50','2018-01-03 17:45:50'),(13,'Size',13,0,'2018-01-03 17:47:59','2018-01-05 23:44:48'),(14,'Color',14,0,'2018-01-06 00:12:19','2018-01-06 00:12:19'),(15,'Internal Memory',14,0,'2018-01-06 00:14:14','2018-01-06 00:14:14'),(16,'Color',15,0,'2018-01-06 00:19:51','2018-01-06 00:19:51'),(17,'Internal Memory',15,0,'2018-01-06 00:19:51','2018-01-06 00:19:51'),(18,'Color',16,0,'2018-01-06 00:24:48','2018-01-06 00:24:48'),(19,'Color',17,0,'2018-01-06 00:35:01','2018-01-06 00:35:01'),(20,'Storage',18,0,'2018-01-06 00:37:30','2018-01-06 00:37:30'),(21,'DUMMY',19,1,'2018-01-06 00:40:28','2018-01-06 00:40:28'),(22,'Color',20,0,'2018-01-06 00:43:00','2018-01-06 00:43:00'),(23,'DUMMY',21,1,'2018-01-06 00:46:35','2018-01-06 00:46:35'),(24,'DUMMY',22,1,'2018-01-06 00:55:09','2018-01-06 00:55:09'),(25,'DUMMY',23,1,'2018-01-06 00:56:27','2018-01-06 00:56:27'),(26,'DUMMY',24,1,'2018-01-06 01:01:22','2018-01-06 01:01:22'),(27,'DUMMY',25,1,'2018-01-06 01:02:23','2018-01-06 01:02:23'),(28,'DUMMY',26,1,'2018-01-06 01:05:51','2018-01-06 01:05:51'),(29,'DUMMY',27,1,'2018-01-06 01:13:16','2018-01-06 01:13:16'),(30,'DUMMY',28,1,'2018-01-06 01:15:47','2018-01-06 01:15:47'),(31,'DUMMY',29,1,'2018-01-06 01:16:53','2018-01-06 01:16:53'),(32,'DUMMY',30,1,'2018-01-06 01:18:59','2018-01-06 01:18:59'),(33,'DUMMY',31,1,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(34,'DUMMY',32,1,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(35,'DUMMY',33,1,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(36,'DUMMY',34,1,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(37,'DUMMY',35,1,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(38,'DUMMY',36,1,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(39,'DUMMY',37,1,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(40,'DUMMY',38,1,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(41,'DUMMY',39,1,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(42,'DUMMY',40,1,'2018-04-10 05:04:32','2018-04-10 05:04:32'),(43,'DUMMY',41,1,'2018-04-10 05:38:27','2018-04-10 05:38:27'),(44,'DUMMY',42,1,'2018-04-10 05:45:52','2018-04-10 05:45:52'),(45,'DUMMY',43,1,'2018-04-10 05:48:01','2018-04-10 05:48:01'),(46,'DUMMY',44,1,'2018-04-10 05:49:10','2018-04-10 05:49:10'),(47,'DUMMY',45,1,'2018-04-10 05:50:22','2018-04-10 05:50:22'),(48,'DUMMY',46,1,'2018-04-10 05:52:04','2018-04-10 05:52:04'),(49,'DUMMY',47,1,'2018-04-10 05:53:45','2018-04-10 05:53:45'),(50,'DUMMY',48,1,'2018-04-10 05:54:42','2018-04-10 05:54:42'),(51,'DUMMY',49,1,'2018-04-10 05:55:55','2018-04-10 05:55:55'),(52,'DUMMY',50,1,'2018-04-10 06:04:32','2018-04-10 06:04:32'),(53,'DUMMY',51,1,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(54,'DUMMY',52,1,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(55,'DUMMY',53,1,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(56,'DUMMY',54,1,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(57,'DUMMY',55,1,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(58,'DUMMY',56,1,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(59,'DUMMY',57,1,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(60,'DUMMY',58,1,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(61,'DUMMY',59,1,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(62,'DUMMY',60,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(63,'DUMMY',61,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(64,'DUMMY',62,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(65,'DUMMY',63,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(66,'DUMMY',64,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(67,'DUMMY',65,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(68,'DUMMY',66,1,'2018-07-12 19:30:31','2018-07-12 19:30:31'),(69,'DUMMY',67,1,'2018-07-12 19:34:47','2018-07-12 19:34:47'),(70,'DUMMY',68,1,'2018-07-12 19:38:55','2018-07-12 19:38:55'),(71,'DUMMY',69,1,'2018-07-12 19:45:51','2018-07-12 19:45:51'),(72,'DUMMY',70,1,'2018-07-12 19:57:37','2018-07-12 19:57:37'),(73,'DUMMY',71,1,'2018-07-12 20:00:41','2018-07-12 20:00:41'),(74,'DUMMY',72,1,'2018-07-12 20:05:03','2018-07-12 20:05:03'),(75,'DUMMY',73,1,'2018-07-12 20:07:29','2018-07-12 20:07:29'),(76,'DUMMY',74,1,'2018-07-12 20:10:44','2018-07-12 20:10:44'),(77,'DUMMY',75,1,'2018-07-12 20:13:09','2018-07-12 20:13:09'),(78,'DUMMY',76,1,'2018-07-12 20:18:33','2018-07-12 20:18:33'),(79,'DUMMY',77,1,'2018-07-12 20:24:22','2018-07-12 20:24:22'),(80,'DUMMY',78,0,'2018-07-16 02:28:04','2018-07-16 02:28:04'),(81,'DUMMY',79,0,'2018-07-16 02:35:37','2018-07-16 02:35:37'),(82,'DUMMY',80,1,'2018-08-07 22:59:03','2018-08-07 22:59:03'),(83,'DUMMY',81,1,'2018-08-12 17:40:39','2018-08-12 17:40:39'),(84,'DUMMY',82,1,'2018-08-12 17:41:16','2018-08-12 17:41:16'),(85,'DUMMY',83,1,'2018-08-12 17:41:48','2018-08-12 17:41:48');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Men\'s Reverse Fleece Crew',1,'single',1,1,1,5,1,'exclusive',1,5,'AS0001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728059_fleece_crew.jpg',1,'2018-01-03 15:59:08','2018-06-11 02:10:59'),(2,'Levis Men\'s Slimmy Fit Jeans',1,'variable',1,1,1,4,1,'exclusive',1,10,'AS0002','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727964_levis_jeans.jpg',1,'2018-01-03 16:00:35','2018-06-11 02:09:24'),(3,'Men\'s Cozy Hoodie Sweater',1,'variable',1,2,1,5,1,'exclusive',1,10,'AS0003','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728035_cozy_sweater.jpg',1,'2018-01-03 17:21:52','2018-06-11 02:10:35'),(4,'Puma Brown Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,5,'AS0004','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728147_puma_brown_sneaker.jpg',1,'2018-01-03 17:24:33','2018-06-11 02:12:27'),(8,'Nike Fashion Sneaker',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0008','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728076_nike_sneaker.jpg',1,'2018-01-03 17:40:10','2018-06-11 02:11:16'),(9,'PUMA Men\'s Black Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,10,'AS0009','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728163_puma_brown_sneaker.jpg',1,'2018-01-03 17:41:57','2018-06-11 02:12:43'),(10,'NIKE Men\'s Running Shoe',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728095_nike_running_shoe.jpg',1,'2018-01-03 17:43:02','2018-06-11 02:11:35'),(11,'U.S. Polo Men\'s Leather Belt',1,'single',1,3,3,6,1,'exclusive',1,15,'AS0011','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727768_belt.jpg',1,'2018-01-03 17:44:35','2018-06-11 02:06:08'),(12,'Unisex Brown Leather Wallet',1,'single',1,1,3,11,1,'exclusive',1,10,'AS0012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727750_unisex_brown_wallet.jpg',1,'2018-01-03 17:45:50','2018-06-11 02:05:50'),(13,'Men Full sleeve T Shirt',1,'variable',1,2,1,5,1,'exclusive',1,15,'AS0013','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728019_mens_tshirt.jpg',1,'2018-01-03 17:47:59','2018-06-11 02:10:19'),(14,'Samsung Galaxy S8',1,'variable',1,7,12,13,1,'exclusive',1,100,'AS0014','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728193_s8.jpg',1,'2018-01-06 00:12:19','2018-06-11 02:13:13'),(15,'Apple iPhone 8',1,'variable',1,8,12,13,1,'exclusive',1,100,'AS0015','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727817_iphone8.jpg',1,'2018-01-06 00:19:51','2018-06-11 02:06:57'),(16,'Samsung Galaxy J7 Pro',1,'variable',1,7,12,13,NULL,'exclusive',1,100,'AS0016','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728178_j7_pro.jpg',1,'2018-01-06 00:24:48','2018-06-11 02:12:58'),(17,'Acer Aspire E 15',1,'variable',1,9,12,14,NULL,'exclusive',1,70,'AS0017','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727793_acerE15.jpg',1,'2018-01-06 00:35:01','2018-06-11 02:06:33'),(18,'Apple MacBook Air',1,'variable',1,8,12,14,NULL,'exclusive',1,30,'AS0018','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727849_macbookair.jpg',1,'2018-01-06 00:37:30','2018-06-11 02:07:29'),(19,'Cushion Crew Socks',1,'single',1,4,15,16,NULL,'exclusive',1,100,'AS0019','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727903_socks.jpg',1,'2018-01-06 00:40:28','2018-06-11 02:08:23'),(20,'Sports Tights Pants',1,'variable',1,6,15,16,1,'exclusive',1,60,'AS0020','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728250_sports_pant.jpg',1,'2018-01-06 00:43:00','2018-06-11 02:14:10'),(21,'Pair Of Dumbbells',1,'single',1,10,15,17,NULL,'exclusive',1,45,'AS0021','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728133_pair_of_dumbell.jpg',1,'2018-01-06 00:46:35','2018-06-11 02:12:13'),(22,'Diary of a Wimpy Kid',1,'single',1,NULL,18,20,1,'exclusive',1,20,'AS0022','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727917_diary_of_whimp_kid.jpeg',1,'2018-01-06 00:55:09','2018-06-11 02:08:37'),(23,'Sneezy the Snowman',1,'single',1,NULL,18,20,NULL,'exclusive',1,20,'AS0023','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728231_sneezy.jpg',1,'2018-01-06 00:56:27','2018-06-11 02:13:51'),(24,'Etched in Sand Autobiography',1,'single',1,NULL,18,19,1,'exclusive',1,30,'AS0024','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727933_etched_in_stone.jpg',1,'2018-01-06 01:01:22','2018-06-11 02:08:53'),(25,'Five Presidents',1,'single',1,NULL,18,19,NULL,'exclusive',1,30,'AS0025','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727949_five_pesident.jpg',1,'2018-01-06 01:02:22','2018-06-11 02:09:09'),(26,'Oreo Cookies',1,'single',2,11,21,NULL,NULL,'exclusive',1,500,'AS0026','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728111_oreo.jpg',1,'2018-01-06 01:05:51','2018-06-11 02:11:51'),(27,'Butter Cookies',1,'single',2,12,21,NULL,1,'exclusive',1,100,'AS0027','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727881_butter_cookies.jpg',1,'2018-01-06 01:13:16','2018-06-11 02:08:01'),(28,'Barilla Pasta',1,'single',2,13,21,NULL,1,'exclusive',1,50,'AS0028','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727865_barilla_pasta.jpeg',1,'2018-01-06 01:15:47','2018-06-11 02:07:45'),(29,'Thin Spaghetti',1,'single',2,13,21,NULL,NULL,'exclusive',1,100,'AS0029','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528728274_thin_spegatti.jpg',1,'2018-01-06 01:16:53','2018-06-11 02:14:34'),(30,'Lipton Black Tea Bags',1,'single',2,14,21,NULL,1,'exclusive',1,50,'AS0030','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528727999_lipton_tea.jpg',1,'2018-01-06 01:18:59','2018-06-11 02:09:59'),(31,'Dolocare 1g paracetol',2,'single',4,16,27,NULL,NULL,'exclusive',1,50,'AP0031','C128',24.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(32,'Lexin 500mg capsule',2,'single',4,16,22,NULL,NULL,'exclusive',1,30,'AP0032','C128',24.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(33,'Oflen-75',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0033','C128',36.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(34,'Cistiben Forte',2,'single',4,16,22,NULL,NULL,'exclusive',1,25,'AP0034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(35,'Disflatyl drop 30ml',2,'single',4,17,25,NULL,NULL,'exclusive',1,20,'AP0035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(36,'Mycoheal 40',2,'single',4,17,26,NULL,NULL,'exclusive',1,30,'AP0036','C128',6.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(37,'Laboxyl',2,'single',4,16,24,NULL,NULL,'exclusive',1,20,'AP0037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(38,'Fertilex plus men',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(39,'vitamin E AIWA',2,'single',4,15,22,NULL,NULL,'exclusive',1,20,'AP0039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(40,'Glycerol 4g',2,'single',4,16,22,NULL,NULL,'exclusive',1,20,'AP0040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,'2018-04-10 05:04:32','2018-04-10 05:04:49'),(41,'HP 15-AY020TU',3,'single',5,23,30,NULL,NULL,'inclusive',1,10,'AE0041','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:38:27','2018-04-10 05:38:27'),(42,'HP Pavilion 15-AU624TX',3,'single',5,23,NULL,NULL,NULL,'exclusive',1,10,'AE0042','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:45:52','2018-04-10 06:21:21'),(43,'iPhone 6s plus',3,'single',5,20,28,NULL,NULL,'exclusive',1,20,'AE0043','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:48:01','2018-04-10 05:48:01'),(44,'Samsung J7 Pro',3,'single',5,18,28,NULL,NULL,'exclusive',1,20,'AE0044','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:49:10','2018-04-10 05:49:10'),(45,'Samsung Galaxy S7 Edge',3,'single',5,18,28,NULL,NULL,'exclusive',1,20,'AE0045','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:50:21','2018-04-10 05:50:21'),(46,'LG G6 64 GB',3,'single',5,19,28,NULL,NULL,'exclusive',1,10,'AE0046','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:52:04','2018-04-10 05:52:04'),(47,'Panasonic TH-58D300DX',3,'single',5,22,31,NULL,NULL,'exclusive',1,20,'AE0047','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:53:45','2018-04-10 05:53:45'),(48,'Samsung 50MU6100',3,'single',5,18,NULL,NULL,NULL,'exclusive',1,7,'AE0048','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:54:42','2018-04-10 06:22:07'),(49,'LG 55E7T',3,'single',5,19,31,NULL,NULL,'exclusive',1,5,'AE0049','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 05:55:55','2018-04-10 05:55:55'),(50,'SONY ILCE-6000L/B',3,'single',5,21,NULL,NULL,NULL,'exclusive',1,10,'AE0050','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,'2018-04-10 06:04:32','2018-04-10 06:04:32'),(51,'Oil and filter change',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(52,'Removal of wheels and brakes checked',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0052','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(53,'Full body wash',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0053','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(54,'Hair Cut',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0054','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(55,'Wash And Blow Dry',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0055','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(56,'Thai massage',4,'single',6,NULL,38,NULL,NULL,'exclusive',0,0,'AS0056','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(57,'Toilet Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0057','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(58,'Sewer Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0058','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(59,'Refrigerator Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0059','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(60,'AC Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0060','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(61,'Red Wine',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,10,'AS0061','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528779460_wine.jpg',1,'2018-06-11 16:27:41','2018-06-11 16:27:41'),(62,'Pinot Noir Red Wine',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,10,'AS0062','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528779737_wine2.jpg',1,'2018-06-11 16:32:17','2018-06-11 16:32:17'),(63,'Banana',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,100,'AS0063','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780092_banana.jpg',1,'2018-06-11 16:38:12','2018-06-11 16:38:12'),(64,'Apple - Fuji',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,50,'AS0064','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780234_apples.jpg',1,'2018-06-11 16:40:34','2018-06-11 16:40:34'),(65,'Organic Egg',1,'single',1,NULL,21,NULL,NULL,'exclusive',1,10,'AS0065','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1528780470_eggs.jpg',1,'2018-06-11 16:44:00','2018-06-11 16:44:30'),(66,'Honey Roast Chicken',5,'single',7,NULL,39,NULL,NULL,'exclusive',0,0,'AR0066','C128',NULL,NULL,0,'300 gm',NULL,NULL,NULL,NULL,NULL,'1531481431_honey-roast-chicken.jpg',7,'2018-07-13 01:00:31','2018-07-13 01:00:31'),(67,'Mushroom and Herb Filled Tomatoes',5,'single',7,NULL,39,NULL,NULL,'exclusive',0,0,'AR0067','C128',NULL,NULL,0,'150 gm',NULL,NULL,NULL,NULL,NULL,'1531481687_tomtoes-with-mushroom_med.jpg',7,'2018-07-13 01:04:47','2018-07-13 01:04:47'),(68,'Pasta Carbonara',5,'single',7,NULL,40,NULL,NULL,'exclusive',0,0,'AR0068','C128',NULL,NULL,0,'180 gm',NULL,NULL,NULL,NULL,NULL,'1531481935_pasta.jpg',7,'2018-07-13 01:08:55','2018-07-13 01:08:55'),(69,'Chicken Doner Pita with Hummus',5,'single',7,NULL,40,NULL,NULL,'exclusive',0,0,'AR0069','C128',NULL,NULL,0,'180 gm',NULL,NULL,NULL,NULL,NULL,'1531482350_pita.jpg',7,'2018-07-13 01:15:50','2018-07-13 01:15:51'),(70,'Falafal Doner Salad',5,'single',7,NULL,41,NULL,NULL,'exclusive',0,0,'AR0070','C128',NULL,NULL,0,'200 gm',NULL,NULL,NULL,NULL,NULL,'1531483057_salad-doner.jpg',7,'2018-07-13 01:27:37','2018-07-13 01:27:37'),(71,'Lamb Doner Salad',5,'single',7,NULL,41,NULL,NULL,'exclusive',0,0,'AR0071','C128',NULL,NULL,0,'220 gm',NULL,NULL,NULL,NULL,NULL,'1531483241_lamb-salad.jpg',7,'2018-07-13 01:30:41','2018-07-13 01:30:41'),(72,'Chicago-Style Pan Pizza',5,'single',7,NULL,42,NULL,NULL,'exclusive',0,0,'AR0072','C128',NULL,NULL,0,'190 gm',NULL,NULL,NULL,NULL,NULL,'1531483502_pizza1.jpg',7,'2018-07-13 01:35:02','2018-07-13 01:35:03'),(73,'Pizza Margherita',5,'single',7,NULL,42,NULL,NULL,'exclusive',0,0,'AR0073','C128',NULL,NULL,0,'200 gm',NULL,NULL,NULL,NULL,NULL,'1531483649_margherita-pizza.jpg',7,'2018-07-13 01:37:29','2018-07-13 01:37:29'),(74,'Blueberry-Ginger Mojito',5,'single',7,NULL,44,NULL,NULL,'exclusive',0,0,'AR0074','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531483843_mojito.jpg',7,'2018-07-13 01:40:43','2018-07-13 01:40:44'),(75,'Chocolate Brownie',5,'single',7,NULL,43,NULL,NULL,'exclusive',0,0,'AR0075','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531483989_Chocolate-Brownies.jpg',7,'2018-07-13 01:43:09','2018-07-13 01:43:09'),(76,'Pepsi Soft Drink',5,'single',7,NULL,44,NULL,NULL,'exclusive',1,50,'AR0076','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531484313_pepsi.jpg',7,'2018-07-13 01:48:33','2018-07-13 01:48:33'),(77,'Brown Bread',5,'single',8,NULL,45,NULL,NULL,'exclusive',1,50,'AR0077','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'1531484661_brown-bread.jpg',7,'2018-07-13 01:54:21','2018-07-13 01:58:56'),(78,'Toppings',5,'modifier',NULL,NULL,NULL,NULL,NULL,'inclusive',0,0,'AR0078','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'2018-07-16 02:28:04','2018-07-16 02:28:04'),(79,'Extra',5,'modifier',NULL,NULL,NULL,NULL,NULL,'inclusive',0,0,'AR0079','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,'2018-07-16 02:35:37','2018-07-16 02:35:37'),(80,'with supplier',1,'single',1,1,1,4,NULL,'exclusive',1,1,'with supplier','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,2,NULL,1,'2018-08-07 22:59:02','2018-08-07 22:59:02'),(81,'P1 package',1,'single',2,1,2,NULL,NULL,'exclusive',1,1,'P1 package','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'2018-08-12 17:40:38','2018-08-12 17:40:38'),(82,'P2 package',1,'single',1,1,1,4,NULL,'exclusive',1,1,'P2 package','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'2018-08-12 17:41:16','2018-08-12 17:41:16'),(83,'P3 package',1,'single',1,1,1,4,NULL,'exclusive',1,1,'P3 package','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'2018-08-12 17:41:48','2018-08-12 17:41:48');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `pp_without_discount` decimal(20,2) NOT NULL DEFAULT '0.00' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(20,2) DEFAULT NULL,
  `purchase_price_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(20,4) DEFAULT '0.0000',
  `quantity_adjusted` decimal(20,4) DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,100.0000,70.00,0.00,70.00,77.00,7.00,1,50.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-06-13 06:09:08'),(2,1,2,3,150.0000,70.00,0.00,70.00,77.00,7.00,1,60.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-06-13 06:09:08'),(3,1,2,4,150.0000,70.00,0.00,70.00,77.00,7.00,1,2.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-08-07 23:55:05'),(4,1,2,5,150.0000,72.00,0.00,72.00,79.20,7.20,1,0.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-06-13 06:09:07'),(5,1,2,6,100.0000,72.00,0.00,72.00,79.20,7.20,1,0.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-06-13 06:09:07'),(6,2,14,47,100.0000,700.00,0.00,700.00,770.00,70.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:28:10','2018-08-12 18:02:01'),(7,3,28,71,500.0000,10.00,0.00,10.00,11.00,1.00,1,30.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:32:22','2018-06-13 06:09:08'),(8,4,21,64,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,60.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:33:12','2018-06-13 06:09:08'),(9,5,27,70,500.0000,20.00,0.00,20.00,22.00,2.00,1,30.0000,0.0000,NULL,NULL,NULL,'2018-01-06 01:35:26','2018-06-13 06:09:07'),(10,11,34,77,50.0000,6.00,0.00,6.00,6.00,0.00,NULL,10.0000,0.0000,'2018-04-10','2019-08-02',NULL,'2018-04-10 04:48:16','2018-06-13 06:09:08'),(11,12,32,75,100.0000,12.00,0.00,12.00,12.00,0.00,NULL,7.0000,0.0000,'2018-04-12','2019-02-02',NULL,'2018-04-10 04:49:40','2018-06-13 06:09:08'),(12,13,36,79,150.0000,9.00,0.00,9.00,9.00,0.00,NULL,0.0000,0.0000,'2018-03-30','2019-08-02',NULL,'2018-04-10 04:50:41','2018-06-13 06:09:07'),(13,14,33,76,180.0000,12.00,0.00,12.00,12.00,0.00,NULL,27.0000,0.0000,'2018-04-10','2018-07-31',NULL,'2018-04-10 04:51:38','2018-06-13 06:09:08'),(14,18,46,89,30.0000,321.00,0.00,321.00,321.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:09:54','2018-06-13 06:09:07'),(15,19,41,84,40.0000,500.00,0.00,500.00,500.00,0.00,NULL,26.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:10:51','2018-06-13 06:09:09'),(16,20,45,88,45.0000,300.00,0.00,300.00,300.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:11:45','2018-06-13 06:09:07'),(17,21,44,87,100.0000,195.00,0.00,195.00,195.00,0.00,NULL,20.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:12:34','2018-06-13 06:09:09'),(18,22,43,86,30.0000,400.00,0.00,400.00,400.00,0.00,NULL,5.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:13:12','2018-06-13 06:09:09'),(19,27,42,85,50.0000,520.00,0.00,520.00,520.00,0.00,NULL,20.0000,0.0000,NULL,NULL,NULL,'2018-04-10 06:23:36','2018-06-13 06:09:09'),(20,37,61,104,20.0000,34.00,0.00,34.00,34.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-11 11:17:07','2018-06-13 06:09:07'),(21,37,64,107,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-11 11:17:07','2018-06-13 06:09:07'),(22,37,63,106,200.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-11 11:17:07','2018-06-13 06:09:07'),(23,37,65,108,50.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-11 11:17:07','2018-06-13 06:09:07'),(24,38,17,57,30.0000,350.00,0.00,350.00,350.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(25,38,17,58,50.0000,350.00,0.00,350.00,350.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(26,38,64,107,100.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(27,38,15,49,30.0000,950.00,0.00,950.00,1045.00,95.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(28,38,15,50,20.0000,950.00,0.00,950.00,1045.00,95.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(29,38,15,51,30.0000,950.00,0.00,950.00,1045.00,95.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(30,38,15,52,20.0000,950.00,0.00,950.00,1045.00,95.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(31,38,15,53,40.0000,1010.00,0.00,1010.00,1111.00,101.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(32,38,18,59,20.0000,1350.00,0.00,1350.00,1350.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(33,38,18,60,20.0000,1450.00,0.00,1450.00,1450.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(34,38,63,106,100.0000,10.00,0.00,10.00,10.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(35,38,19,61,30.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(36,38,22,65,10.0000,8.00,0.00,8.00,8.80,0.80,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(37,38,24,67,10.0000,8.00,0.00,8.00,8.80,0.80,1,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(38,38,25,68,20.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(39,39,77,120,100.0000,3.00,0.00,3.00,3.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(40,39,76,119,200.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(41,40,76,119,100.0000,8.00,0.00,8.00,8.00,0.00,NULL,0.0000,0.0000,NULL,NULL,NULL,'2018-07-13 02:08:24','2018-07-13 02:08:24'),(42,45,80,128,1.0000,100.00,0.00,100.00,100.00,0.00,NULL,1.0000,0.0000,NULL,NULL,NULL,'2018-08-07 23:03:01','2018-08-07 23:03:35'),(43,48,2,2,1.0000,70.00,0.00,70.00,77.00,7.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-08-12 17:48:41','2018-08-12 18:00:43'),(44,49,2,2,1.0000,70.00,0.00,70.00,77.00,7.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-08-12 17:50:06','2018-08-12 17:50:06'),(45,50,2,2,1.0000,70.00,0.00,70.00,77.00,7.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-08-12 17:50:47','2018-08-12 17:50:47'),(46,51,28,71,1.0000,10.00,0.00,10.00,11.00,1.00,1,0.0000,0.0000,NULL,NULL,NULL,'2018-08-12 17:51:29','2018-08-12 17:51:29');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'purchase',6,1,'2018-06-11 16:47:07','2018-08-12 17:51:29'),(2,'contacts',7,1,'2018-06-11 16:47:07','2018-08-06 02:05:47'),(3,'contacts',2,5,'2018-07-13 11:12:11','2018-07-13 02:03:50'),(4,'business_location',1,5,'2018-07-13 11:12:11','2018-07-13 11:12:11'),(5,'purchase',2,5,'2018-07-13 02:04:45','2018-07-13 02:08:24'),(6,'sell_payment',4,5,'2018-07-13 02:14:40','2018-07-13 02:16:36'),(7,'contacts',1,6,'2018-08-06 14:45:35','2018-08-06 14:45:35'),(8,'business_location',1,6,'2018-08-06 14:45:35','2018-08-06 14:45:35'),(9,'sell_payment',5,1,'2018-08-07 23:03:35','2018-08-09 01:57:15'),(10,'purchase_payment',3,1,'2018-08-12 17:48:41','2018-08-12 17:51:29'),(11,'expense',2,1,'2018-08-12 18:18:48','2018-08-12 18:19:04');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
INSERT INTO `res_product_modifier_sets` VALUES (78,72),(78,73),(79,73),(79,69),(79,72),(79,75),(79,68);
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
INSERT INTO `res_tables` VALUES (1,5,5,'Table 1',NULL,7,NULL,'2018-07-13 02:10:57','2018-07-13 02:10:57'),(2,5,5,'Table 2',NULL,7,NULL,'2018-07-13 02:11:04','2018-07-13 02:11:04'),(3,5,5,'Table 3',NULL,7,NULL,'2018-07-13 02:11:10','2018-07-13 02:11:10'),(4,5,5,'Table 4',NULL,7,NULL,'2018-07-13 02:11:17','2018-07-13 02:11:17');
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (26,2),(27,2),(28,2),(29,2),(58,2),(26,4),(27,4),(28,4),(29,4),(58,4),(26,6),(27,6),(28,6),(29,6),(58,6),(26,8),(27,8),(28,8),(29,8),(58,8),(26,10),(27,10),(28,10),(29,10),(58,10),(58,11),(59,11),(26,13),(27,13),(28,13),(29,13),(58,13);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2018-08-02 17:19:26','2018-08-02 17:19:26'),(2,'Cashier#1','web',1,0,0,'2018-08-02 17:19:26','2018-08-02 17:19:26'),(3,'Admin#2','web',2,1,0,'2018-08-02 17:19:27','2018-08-02 17:19:27'),(4,'Cashier#2','web',2,0,0,'2018-08-02 17:19:27','2018-08-02 17:19:27'),(5,'Admin#3','web',3,0,0,'2018-08-02 17:19:28','2018-08-02 17:19:28'),(6,'Cashier#3','web',3,0,0,'2018-08-02 17:19:28','2018-08-02 17:19:28'),(7,'Admin#4','web',4,1,0,'2018-08-02 17:19:28','2018-08-02 17:19:28'),(8,'Cashier#4','web',4,0,0,'2018-08-02 17:19:29','2018-08-02 17:19:29'),(9,'Admin#5','web',5,1,0,'2018-08-02 17:19:29','2018-08-02 17:19:29'),(10,'Cashier#5','web',5,0,0,'2018-08-02 17:19:29','2018-08-02 17:19:29'),(11,'Waiter#5','web',5,0,1,'2018-08-02 17:19:30','2018-08-02 17:19:30'),(12,'Admin#6','web',6,1,0,'2018-08-06 14:45:34','2018-08-06 14:45:34'),(13,'Cashier#6','web',6,0,0,'2018-08-06 14:45:34','2018-08-06 14:45:34');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `unit_price` decimal(20,2) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(20,2) NOT NULL,
  `package_details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('approved','waiting','declined') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,1,3,'2018-08-02','2018-08-12','2018-09-02',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',1,'stripe','ch_1CuLdQAhokBpT93LVZNg2At6','approved',NULL,'2018-08-02 02:19:09','2018-08-01 02:19:09'),(2,2,3,'2018-08-02','2018-08-12','2018-09-02',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',4,'stripe','ch_1CuLggAhokBpT93LbaE29pMW','approved',NULL,'2018-08-01 04:22:31','2018-08-01 04:22:31'),(3,4,3,'2018-08-02','2018-08-12','2018-09-02',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',6,'stripe','ch_1CuLkoAhokBpT93LW0UAFC7N','approved',NULL,'2018-08-01 04:26:48','2018-08-01 04:26:48'),(4,3,3,'2018-08-02','2018-08-12','2018-09-02',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',5,'stripe','ch_1CuLljAhokBpT93LGozt93Wn','approved',NULL,'2018-08-01 04:27:44','2018-08-01 04:27:44'),(5,5,3,'2018-08-02','2018-08-12','2018-09-02',599.99,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Unlimited\"}',7,'stripe','ch_1CuLmXAhokBpT93LOUCvEIKD','approved',NULL,'2018-08-01 04:28:34','2018-08-01 04:28:34');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES ('db_version','2.6'),('default_business_active_status','1'),('superadmin_version','0.5'),('app_currency_id','2'),('invoice_business_name','Ultimate POS'),('invoice_business_landmark','Linking Street'),('invoice_business_zip','85001'),('invoice_business_state','Arizona'),('invoice_business_city','Phoenix'),('invoice_business_country','USA'),('email','thewebfosters@gmail.com');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(8,2) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'VAT@10%',10.00,0,1,NULL,'2018-01-03 21:10:07','2018-01-03 21:10:07'),(2,1,'CGST@10%',10.00,0,1,NULL,'2018-01-03 21:10:55','2018-01-03 21:10:55'),(3,1,'SGST@8%',8.00,0,1,NULL,'2018-01-03 21:11:13','2018-01-03 21:11:13'),(4,1,'GST@18%',18.00,1,1,NULL,'2018-01-03 21:12:19','2018-01-03 21:12:19');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` enum('visa','master') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,6,0,770.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:06:11','2018-01-05 20:06:11'),(2,7,0,825.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:06:31','2018-01-05 20:06:31'),(3,8,0,7700.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:07:23','2018-01-05 20:07:23'),(4,9,0,750.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:07:45','2018-01-05 20:07:45'),(5,10,0,412.50,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:08:03','2018-01-05 20:08:03'),(6,4,0,2000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:32:56',1,NULL,NULL,'Cash Payment',NULL,'2018-01-11 01:02:56','2018-01-11 01:02:56'),(7,3,0,3000.00,'bank_transfer',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,'502110000631','2018-01-11 17:34:10',1,NULL,NULL,'3000 Paid Via Bank Transfer',NULL,'2018-01-11 01:04:10','2018-01-11 01:04:10'),(8,2,0,84700.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:34:36',1,NULL,NULL,NULL,NULL,'2018-01-11 01:04:36','2018-01-11 01:04:36'),(9,1,0,50000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:04',1,NULL,NULL,NULL,NULL,'2018-01-11 01:05:04','2018-01-11 01:05:04'),(10,1,0,5660.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:17',1,NULL,NULL,NULL,NULL,'2018-01-11 01:05:17','2018-01-11 01:05:17'),(11,11,0,300.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:48:47',4,8,NULL,NULL,NULL,'2018-04-10 04:48:47','2018-04-10 04:48:47'),(12,12,0,1200.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:49:49',4,9,NULL,NULL,NULL,'2018-04-10 04:49:49','2018-04-10 04:49:49'),(13,13,0,1350.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:50:55',4,9,NULL,NULL,NULL,'2018-04-10 04:50:55','2018-04-10 04:50:55'),(14,14,0,1500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:52:10',4,9,NULL,NULL,NULL,'2018-04-10 04:52:10','2018-04-10 04:52:10'),(15,15,0,75.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:35',4,7,NULL,NULL,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,16,0,105.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:58',4,7,NULL,NULL,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,17,0,405.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:54:21',4,7,NULL,NULL,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(18,18,0,9630.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:10:02',5,11,NULL,NULL,NULL,'2018-04-10 06:10:02','2018-04-10 06:10:02'),(19,19,0,20000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:10:58',5,12,NULL,NULL,NULL,'2018-04-10 06:10:58','2018-04-10 06:10:58'),(20,20,0,13500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:19',5,12,NULL,NULL,NULL,'2018-04-10 06:13:19','2018-04-10 06:13:19'),(21,21,0,19500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:24',5,12,NULL,NULL,NULL,'2018-04-10 06:13:24','2018-04-10 06:13:24'),(22,22,0,5000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:35',5,11,NULL,NULL,NULL,'2018-04-10 06:13:35','2018-04-10 06:13:35'),(23,23,0,2500.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:14:47',5,10,NULL,NULL,NULL,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(24,24,0,4875.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:15:06',5,10,NULL,NULL,NULL,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(25,25,0,625.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:16:02',5,10,NULL,NULL,NULL,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(26,26,0,15625.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:18:48',5,10,NULL,NULL,NULL,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(27,28,0,13000.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:24:16',5,10,NULL,NULL,NULL,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(28,29,0,656.25,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:40',6,13,NULL,NULL,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(29,30,0,250.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:54',6,13,NULL,NULL,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(30,31,0,75.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:35:19',6,13,NULL,NULL,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(31,32,0,37.50,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:37:50',6,13,NULL,NULL,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(32,33,0,375.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:01',6,13,NULL,NULL,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(33,34,0,250.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:15',6,13,NULL,NULL,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(34,35,0,100.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:27',6,13,NULL,NULL,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(35,36,0,125.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:49',6,13,NULL,NULL,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(36,46,0,112.50,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-08 04:33:35',1,1,NULL,NULL,'SP2018/0001','2018-08-07 23:03:35','2018-08-07 23:03:35'),(37,NULL,0,100.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-09 07:26:47',1,1,NULL,NULL,'SP2018/0002','2018-08-09 01:56:48','2018-08-09 01:56:48'),(38,47,0,100.00,'cash','cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-09 07:26:47',1,1,37,NULL,'SP2018/0003','2018-08-09 01:56:48','2018-08-09 01:56:48'),(39,NULL,0,18.80,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-09 07:27:15',1,1,NULL,NULL,'SP2018/0004','2018-08-09 01:57:15','2018-08-09 01:57:15'),(40,47,0,18.80,'cash','cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-09 07:27:15',1,1,39,NULL,'SP2018/0005','2018-08-09 01:57:15','2018-08-09 01:57:15'),(41,48,0,77.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-12 23:18:41',1,2,NULL,NULL,'PP2018/0001','2018-08-12 17:48:41','2018-08-12 17:48:41'),(42,50,0,77.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-12 23:20:47',1,2,NULL,NULL,'PP2018/0002','2018-08-12 17:50:47','2018-08-12 17:50:47'),(43,51,0,31.00,'cash',NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-08-12 23:21:29',1,2,NULL,NULL,'PP2018/0003','2018-08-12 17:51:29','2018-08-12 17:51:29');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `unit_price_before_discount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price` decimal(20,2) DEFAULT NULL,
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,6,2,3,10.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(2,7,27,70,30.0000,25.00,25.00,NULL,0.00,27.50,2.50,1,NULL,NULL,NULL,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(3,8,2,3,50.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(4,8,2,2,50.0000,70.00,70.00,NULL,0.00,77.00,7.00,1,NULL,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(5,9,21,64,60.0000,12.50,12.50,NULL,0.00,12.50,0.00,NULL,NULL,NULL,NULL,'2018-01-06 01:37:45','2018-01-06 01:37:45'),(6,10,28,71,30.0000,12.50,12.50,NULL,0.00,13.75,1.25,1,NULL,NULL,NULL,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(7,15,34,77,10.0000,7.50,7.50,NULL,0.00,7.50,0.00,NULL,NULL,'',NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(8,16,32,75,7.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(9,17,33,76,27.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(10,23,43,86,5.0000,500.00,500.00,NULL,0.00,500.00,0.00,NULL,NULL,'IHN45822225007',NULL,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(11,24,44,87,20.0000,243.75,243.75,NULL,0.00,243.75,0.00,NULL,NULL,'SMJ7558455524',NULL,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(12,25,41,84,1.0000,625.00,625.00,NULL,0.00,625.00,0.00,NULL,NULL,'EXSD1225778855',NULL,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(13,26,41,84,25.0000,625.00,625.00,NULL,0.00,625.00,0.00,NULL,NULL,'HP020555548444',NULL,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(14,28,42,85,20.0000,650.00,650.00,NULL,0.00,650.00,0.00,NULL,NULL,'HP68400258F',NULL,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(15,29,53,96,5.0000,131.25,131.25,NULL,0.00,131.25,0.00,NULL,NULL,'',NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(16,30,51,94,2.0000,125.00,125.00,NULL,0.00,125.00,0.00,NULL,NULL,'',NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(17,31,57,100,3.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(18,32,60,103,2.0000,18.75,18.75,NULL,0.00,18.75,0.00,NULL,NULL,'',NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(19,33,56,99,2.0000,187.50,187.50,NULL,0.00,187.50,0.00,NULL,NULL,'',NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(20,34,54,97,20.0000,12.50,12.50,NULL,0.00,12.50,0.00,NULL,NULL,'',NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(21,35,55,98,10.0000,10.00,10.00,NULL,0.00,10.00,0.00,NULL,NULL,'',NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(22,36,57,100,5.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(23,41,71,114,2.0000,21.25,21.25,NULL,0.00,21.25,0.00,NULL,NULL,'',NULL,'2018-07-13 02:14:40','2018-07-13 02:14:40'),(24,42,70,113,2.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(25,42,67,110,2.0000,10.00,10.00,NULL,0.00,10.00,0.00,NULL,NULL,'',NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(26,42,68,111,2.0000,13.75,13.75,NULL,0.00,13.75,0.00,NULL,NULL,'',NULL,'2018-07-13 02:15:28','2018-07-13 02:15:28'),(27,43,74,117,1.0000,8.75,8.75,NULL,0.00,8.75,0.00,NULL,NULL,'',NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(28,43,73,116,1.0000,25.00,25.00,NULL,0.00,25.00,0.00,NULL,NULL,'',NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(29,44,74,117,3.0000,8.75,8.75,NULL,0.00,8.75,0.00,NULL,NULL,'',NULL,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(30,44,69,112,3.0000,15.00,15.00,NULL,0.00,15.00,0.00,NULL,NULL,'',NULL,'2018-07-13 02:16:36','2018-07-13 02:16:36'),(31,46,80,128,1.0000,125.00,125.00,'fixed',0.00,125.00,0.00,NULL,NULL,'',NULL,'2018-08-07 23:03:35','2018-08-07 23:03:35'),(32,47,2,4,2.0000,60.00,60.00,'fixed',0.00,66.00,6.00,1,NULL,'',NULL,'2018-08-07 23:55:04','2018-08-07 23:55:04');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(20,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,31,NULL,42,1.0000,'2018-08-07 23:03:35','2018-08-07 23:03:35'),(2,32,NULL,3,2.0000,'2018-08-07 23:55:05','2018-08-07 23:55:05');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('purchase','sell','expense','stock_adjustment','sell_transfer','purchase_transfer','opening_stock','sell_return') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('received','pending','ordered','draft','final') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(20,2) NOT NULL DEFAULT '0.00',
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `final_total` decimal(20,2) NOT NULL DEFAULT '0.00',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(20,2) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `delivery_status` enum('packaging','order_processing','delivered') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'35001BCVX','2018-07-18 22:49:20',50600.00,1,5060.00,NULL,'0',NULL,0.00,NULL,NULL,55660.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:27:11','2018-01-06 01:27:11'),(2,1,1,NULL,NULL,NULL,'purchase','ordered',0,'paid',NULL,5,NULL,NULL,'35001BJGN','2018-07-18 00:00:00',77000.00,1,7700.00,NULL,'0',NULL,0.00,NULL,NULL,84700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:28:10','2018-08-12 18:02:01'),(3,1,1,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,6,NULL,NULL,'35001BCVJ','2018-07-03 22:49:20',5500.00,1,550.00,NULL,'0',NULL,0.00,NULL,NULL,6050.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:32:22','2018-01-06 01:32:22'),(4,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,6,NULL,NULL,'35001BCVK','2018-07-03 22:49:20',2000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:33:12','2018-01-06 01:33:12'),(5,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'35001BCVD','2018-07-26 22:49:20',11000.00,1,1100.00,NULL,'0',NULL,0.00,NULL,NULL,12100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:35:26','2018-01-06 01:35:26'),(6,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0001','','2018-04-10 13:23:21',770.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,770.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(7,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0002','','2018-07-31 22:49:20',825.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,825.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(8,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0003','','2018-07-31 22:49:20',7700.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,7700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:37:22','2018-01-06 01:37:22'),(9,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0004','','2018-08-02 22:49:20',750.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,750.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:37:45','2018-01-06 01:37:45'),(10,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0005','','2018-08-02 22:49:20',412.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,412.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(11,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,8,NULL,NULL,'56247065','2018-07-26 22:49:20',300.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:48:16','2018-04-10 04:48:47'),(12,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'547887025','2018-07-26 22:49:20',1200.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:49:40','2018-04-10 04:49:49'),(13,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'45470025','2018-07-03 22:49:20',1350.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1350.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:50:41','2018-04-10 04:50:55'),(14,2,2,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,9,NULL,NULL,'65589898','2018-07-03 22:49:20',2160.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2160.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:51:38','2018-04-10 04:52:10'),(15,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0001','','2018-07-31 22:49:20',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0002','','2018-07-31 22:49:20',105.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,105.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0003','','2018-08-02 22:49:20',405.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,405.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(18,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,11,NULL,NULL,'548471117','2018-07-03 22:49:20',9630.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,9630.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:09:54','2018-04-10 06:10:02'),(19,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'548222220','2018-07-26 22:49:20',20000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,20000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:10:51','2018-04-10 06:10:58'),(20,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'878445524','2018-07-18 22:49:20',13500.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,13500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:11:45','2018-04-10 06:13:19'),(21,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'582500058','2018-07-18 22:49:20',19500.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,19500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:12:34','2018-04-10 06:13:24'),(22,3,3,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,11,NULL,NULL,'848485552','2018-07-26 22:49:20',12000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,12000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:13:12','2018-04-10 06:13:35'),(23,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0001','','2018-08-02 22:49:20',2500.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,2500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(24,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0002','','2018-07-31 22:49:20',4875.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,4875.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(25,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0003','','2018-07-31 22:49:20',625.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(26,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0004','','2018-08-02 22:49:20',15625.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,15625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(27,3,3,NULL,NULL,NULL,'purchase','received',0,'due',NULL,12,NULL,NULL,'1545477882','2018-07-18 22:49:20',26000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,26000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:23:36','2018-04-10 06:23:36'),(28,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0005','','2018-07-31 22:49:20',13000.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,13000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,NULL,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(29,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0001','','2018-08-02 22:49:20',656.25,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,656.25,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(30,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0002','','2018-07-31 22:49:20',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(31,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0003','','2018-08-02 22:49:20',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(32,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0004','','2018-08-02 22:49:20',37.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,37.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(33,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0005','','2018-07-31 22:49:20',375.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,375.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(34,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0006','','2018-07-31 22:49:20',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(35,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0007','','2018-08-02 22:49:20',100.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(36,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0008','','2018-07-31 22:49:20',125.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(37,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'PO2018/0001','2018-07-31 22:49:20',5180.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,5180.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(38,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,6,NULL,NULL,'PO2018/0002','2018-08-02 22:49:20',235656.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,235656.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(39,5,5,NULL,NULL,NULL,'purchase','received',0,'due',NULL,15,NULL,NULL,'PO2018/0001','2018-07-31 22:49:20',1900.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1900.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(40,5,5,NULL,NULL,NULL,'purchase','received',0,'due',NULL,15,NULL,NULL,'PO2018/0002','2018-07-31 22:49:20',800.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:08:24','2018-07-13 02:08:24'),(41,5,5,1,8,'served','sell','final',0,'paid',NULL,14,NULL,'0001','','2018-08-02 22:49:20',42.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,42.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:14:40','2018-07-13 02:18:07'),(42,5,5,2,8,NULL,'sell','final',0,'paid',NULL,14,NULL,'0002','','2018-08-02 22:49:20',77.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,77.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:15:28','2018-07-13 02:15:29'),(43,5,5,3,8,NULL,'sell','final',0,'paid',NULL,14,NULL,'0003','','2018-08-02 22:49:20',33.75,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,33.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:16:04','2018-07-13 02:16:04'),(44,5,5,NULL,NULL,'cooked','sell','final',0,'paid',NULL,14,NULL,'0004','','2018-08-02 22:49:20',71.25,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,71.25,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,7,NULL,'2018-07-13 02:16:36','2018-07-13 02:16:55'),(45,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'with supplier','2018-08-08 00:00:00',100.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-07 23:03:01','2018-08-07 23:03:01'),(46,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0006','','2018-08-08 04:33:35',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-07 23:03:35','2018-08-07 23:03:35'),(47,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0007','','2018-08-08 00:00:00',132.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,118.80,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,NULL,'2018-08-07 23:55:04','2018-08-09 01:57:15'),(48,1,1,NULL,NULL,NULL,'purchase','pending',0,'paid',NULL,2,NULL,NULL,'ref1','2018-08-12 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 17:48:41','2018-08-12 18:00:43'),(49,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'ref2','2018-08-12 00:00:00',77.00,NULL,0.00,NULL,'0','Transport',20.00,NULL,NULL,97.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 17:50:06','2018-08-12 17:50:06'),(50,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'ref3','2018-08-12 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 17:50:47','2018-08-12 17:50:47'),(51,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'ref4','2018-08-12 00:00:00',11.00,NULL,0.00,NULL,'0','Transport',20.00,NULL,NULL,31.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 17:51:29','2018-08-12 17:51:29'),(52,1,1,NULL,NULL,NULL,'expense','final',0,'paid',NULL,NULL,NULL,NULL,'dsdsd','2018-08-12 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 18:18:48','2018-08-12 18:18:48'),(53,1,1,NULL,NULL,NULL,'expense','final',0,'due',NULL,NULL,NULL,NULL,'dsdsd','2018-08-12 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,NULL,'2018-08-12 18:19:04','2018-08-12 18:19:04');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,1,NULL,'2018-01-03 15:15:20','2018-01-03 15:15:20'),(2,1,'Packets','packets',0,1,NULL,'2018-01-06 01:07:01','2018-01-06 01:08:36'),(3,1,'Grams','g',1,1,NULL,'2018-01-06 01:10:34','2018-01-06 01:10:34'),(4,2,'Pieces','Pc(s)',0,4,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(5,3,'Units','units',0,5,NULL,'2018-04-10 05:16:16','2018-04-10 05:29:19'),(6,4,'Units','units',0,6,NULL,'2018-04-10 06:50:43','2018-04-10 07:02:04'),(7,5,'Pieces','Pc(s)',0,7,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(8,5,'Packets','packets',0,7,NULL,'2018-07-12 20:27:16','2018-07-12 20:27:16'),(9,6,'Pieces','Pc(s)',0,10,NULL,'2018-08-06 14:45:35','2018-08-06 14:45:35');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Mr','Admin',NULL,'admin','admin@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'dmldhzm4QKbKzCi3nYynqOuQJuGwkDpU1tHar8xfNSswUdTD0BsOTwoVG420',1,0,0.00,NULL,'2018-01-03 20:45:19','2018-01-03 20:45:19'),(2,'Mr','Demo','Cashier','cashier','cashier@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-01-03 20:50:58','2018-01-03 20:50:58'),(3,'Mr.','Demo','Admin','demo-admin','demoadmin@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-01-06 01:40:57','2018-01-06 01:40:57'),(4,'Mr','Demo','Admin','admin-pharmacy','admin-pharma@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'MJnleh4kefXZtw3FCI2yHKEwr45Rs5nZxyQyGSFRfjIcQn93sJZyw7BAzSUq',2,0,0.00,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(5,'Mr','Demo','Admin','admin-electronics','admin-electronics@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'YzGFoRAfllUjyB12qIZhowlteUPhvR1cd77YREQuqemSUftHp72aRLZMrzwR',3,0,0.00,NULL,'2018-04-10 05:16:15','2018-04-10 05:16:15'),(6,'Mr','Demo','Admin','admin-services','admin-services@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'CdBNjmTIXVU0nEgcEg85L97w6JEjvuE6CfF7mvhmz7Ad2K7IxJVd9WPLdxcg',4,0,0.00,NULL,'2018-04-10 06:50:42','2018-04-10 06:50:42'),(7,'Mr','Demo','Admin','admin-restaurant','admin-restaurant@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'ZzGDokwQe0vR0YpbBBWwbCWOGAkTgMS4wZlQOzAgWs2yAnovdGFkRwjofy1Y',5,0,0.00,NULL,'2018-07-13 05:42:11','2018-07-13 05:42:11'),(8,'Mr','Kevin','Nicols','kevin-nicols','kevin@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'57dRoj3knI8dJ9UPSqFo2EH0CVTco5WJHnDgrmB2CY4lvJR6ZTtmzHi7NdLa',5,0,0.00,NULL,'2018-07-12 20:43:20','2018-07-12 20:43:20'),(9,'Mr.','Super','Admin','superadmin','superadmin@example.com','$2y$10$GFw/K9Mhu6HIioD1WWu44eh1Dd3JdFXoSsaSzBeO5dw..lY/5Gusa','en',NULL,NULL,'hOsbFrWWSYsT7dAnP2rwUAYx6aMvbUhUs1ZYl8yXWe9JYKkumTb0mYLXQYUl',1,0,0.00,NULL,'2018-08-01 22:35:55','2018-08-01 22:35:55'),(10,'mr.','sds','dsd','dsdsdsds','dsdsdsds@dsdsdsds.com','$2y$10$MQg83RHljeThgl.wxfXi3eO7mLU9cKJa7mROIKS3jtWmHSBnK9XC2','en',NULL,NULL,'cSqo5mWVzRZWeqjI4RBPSLOVbVIqxvRV17QfC7nqsTwtBT8SsNzQyKUg6tgQ',6,0,0.00,NULL,'2018-08-06 14:45:34','2018-08-06 14:45:34');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(20,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,2,2,2,1,52.0000,'2018-01-06 01:27:11','2018-08-12 18:00:43'),(2,2,2,3,1,90.0000,'2018-01-06 01:27:11','2018-01-06 01:37:23'),(3,2,2,4,1,148.0000,'2018-01-06 01:27:11','2018-08-07 23:55:05'),(4,2,2,5,1,150.0000,'2018-01-06 01:27:11','2018-01-06 01:27:11'),(5,2,2,6,1,100.0000,'2018-01-06 01:27:11','2018-01-06 01:27:11'),(6,14,15,47,1,0.0000,'2018-01-06 01:28:10','2018-08-12 18:02:01'),(7,28,30,71,1,471.0000,'2018-01-06 01:32:22','2018-08-12 17:51:29'),(8,21,23,64,1,140.0000,'2018-01-06 01:33:12','2018-01-06 01:37:45'),(9,27,29,70,1,470.0000,'2018-01-06 01:35:26','2018-01-06 01:36:32'),(10,34,36,77,2,40.0000,'2018-04-10 04:48:16','2018-04-10 04:53:35'),(11,32,34,75,2,93.0000,'2018-04-10 04:49:40','2018-04-10 04:53:58'),(12,36,38,79,2,150.0000,'2018-04-10 04:50:41','2018-04-10 04:50:41'),(13,33,35,76,2,153.0000,'2018-04-10 04:51:38','2018-04-10 04:54:21'),(14,46,48,89,3,30.0000,'2018-04-10 06:09:54','2018-04-10 06:09:54'),(15,41,43,84,3,14.0000,'2018-04-10 06:10:51','2018-04-10 06:18:48'),(16,45,47,88,3,45.0000,'2018-04-10 06:11:45','2018-04-10 06:11:45'),(17,44,46,87,3,80.0000,'2018-04-10 06:12:34','2018-04-10 06:15:06'),(18,43,45,86,3,25.0000,'2018-04-10 06:13:12','2018-04-10 06:14:47'),(19,42,44,85,3,30.0000,'2018-04-10 06:23:36','2018-04-10 06:24:16'),(20,61,63,104,1,20.0000,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(21,64,66,107,1,300.0000,'2018-06-11 16:47:07','2018-06-12 17:48:04'),(22,63,65,106,1,300.0000,'2018-06-11 16:47:07','2018-06-12 17:48:04'),(23,65,67,108,1,50.0000,'2018-06-11 16:47:07','2018-06-11 16:47:07'),(24,17,19,57,1,30.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(25,17,19,58,1,50.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(26,15,16,49,1,30.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(27,15,16,50,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(28,15,16,51,1,30.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(29,15,17,52,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(30,15,17,53,1,40.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(31,18,20,59,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(32,18,20,60,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(33,19,21,61,1,30.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(34,22,24,65,1,10.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(35,24,26,67,1,10.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(36,25,27,68,1,20.0000,'2018-06-12 17:48:04','2018-06-12 17:48:04'),(37,77,79,120,5,100.0000,'2018-07-13 02:04:45','2018-07-13 02:04:45'),(38,76,78,119,5,300.0000,'2018-07-13 02:04:45','2018-07-13 02:08:24'),(39,80,82,128,1,0.0000,'2018-08-07 23:03:01','2018-08-07 23:03:35');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
INSERT INTO `variation_templates` VALUES (1,'Size (Tshirts)',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'Size (Shoes)',1,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(3,'Waist Size (Jeans)',1,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(4,'Color',1,'2018-01-06 07:12:52','2018-01-06 07:12:52');
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
INSERT INTO `variation_value_templates` VALUES (1,'S',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'M',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(3,'L',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(4,'XL',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(5,'5',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(6,'6',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(7,'7',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(8,'8',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(9,'9',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(10,'28',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(11,'30',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(12,'32',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(13,'34',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(14,'36',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(16,'Black',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(17,'Blue',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(18,'Brown',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(19,'Grey',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(20,'Gold',4,'2018-01-06 07:13:17','2018-01-06 07:13:17');
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `default_purchase_price` decimal(20,2) DEFAULT NULL,
  `dpp_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `profit_percent` decimal(20,2) NOT NULL DEFAULT '0.00',
  `default_sell_price` decimal(20,2) DEFAULT NULL,
  `sell_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'AS0001',1,130.00,143.00,0.00,130.00,143.00,'2018-01-03 15:59:08','2018-06-11 02:10:59',NULL),(2,'28',2,'AS0002-1',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-06-11 02:09:24',NULL),(3,'30',2,'AS0002-2',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-06-11 02:09:24',NULL),(4,'32',2,'AS0002-3',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-06-11 02:09:24',NULL),(5,'34',2,'AS0002-4',2,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-06-11 02:09:24',NULL),(6,'36',2,'AS0002-5',2,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-06-11 02:09:24',NULL),(7,'S',3,'AS0003-1',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-06-11 02:10:35',NULL),(8,'M',3,'AS0003-2',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-06-11 02:10:35',NULL),(9,'L',3,'AS0003-3',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-06-11 02:10:35',NULL),(10,'XL',3,'AS0003-4',3,191.00,210.10,0.00,191.00,210.10,'2018-01-03 17:21:52','2018-06-11 02:10:35',NULL),(11,'6',4,'AS0004-1',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-06-11 02:12:27',NULL),(12,'7',4,'AS0004-2',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-06-11 02:12:27',NULL),(13,'8',4,'AS0004-3',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-06-11 02:12:27',NULL),(14,'9',4,'AS0004-4',4,166.00,182.60,0.00,166.00,182.60,'2018-01-03 17:24:34','2018-06-11 02:12:27',NULL),(27,'6',8,'AS0008-1',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-06-11 02:11:16',NULL),(28,'7',8,'AS0008-2',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-06-11 02:11:16',NULL),(29,'8',8,'AS0008-3',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-06-11 02:11:16',NULL),(30,'9',8,'AS0008-4',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-06-11 02:11:16',NULL),(31,'6',9,'AS0009-1',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-06-11 02:12:43',NULL),(32,'7',9,'AS0009-2',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-06-11 02:12:43',NULL),(33,'8',9,'AS0009-3',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-06-11 02:12:43',NULL),(34,'9',9,'AS0009-4',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-06-11 02:12:43',NULL),(35,'5',10,'AS0010-1',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-06-11 02:11:35',NULL),(36,'6',10,'AS0010-2',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-06-11 02:11:35',NULL),(37,'7',10,'AS0010-3',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-06-11 02:11:35',NULL),(38,'8',10,'AS0010-4',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-06-11 02:11:35',NULL),(39,'9',10,'AS0010-5',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-06-11 02:11:35',NULL),(40,'DUMMY',11,'AS0011',11,30.00,33.00,0.00,30.00,33.00,'2018-01-03 17:44:35','2018-06-11 02:06:08',NULL),(41,'DUMMY',12,'AS0012',12,25.00,27.50,0.00,25.00,27.50,'2018-01-03 17:45:50','2018-06-11 02:05:50',NULL),(42,'M',13,'AS0013-1',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-06-11 02:10:19',NULL),(43,'L',13,'AS0013-2',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-06-11 02:10:19',NULL),(44,'XL',13,'AS0013-3',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-06-11 02:10:19',NULL),(45,'Gray',14,'AS0014-1',14,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-06-11 02:13:13',NULL),(46,'Black',14,'AS0014-2',14,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-06-11 02:13:13',NULL),(47,'64 GB',14,'AS0014-1',15,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:14:14','2018-06-11 02:13:13',NULL),(48,'128 GB',14,'AS0014-2',15,800.00,880.00,25.00,1000.00,1100.00,'2018-01-06 00:14:14','2018-06-11 02:13:13',NULL),(49,'White',15,'AS0015-1',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-06-11 02:06:57',NULL),(50,'Gray',15,'AS0015-2',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-06-11 02:06:57',NULL),(51,'Black',15,'AS0015-3',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-06-11 02:06:57',NULL),(52,'32 GB',15,'AS0015-1',17,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-06-11 02:06:57',NULL),(53,'64 GB',15,'AS0015-2',17,1010.00,1111.00,25.00,1262.50,1388.75,'2018-01-06 00:19:51','2018-06-11 02:06:57',NULL),(54,'Gold',16,'AS0016-1',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-06-11 02:12:58',NULL),(55,'White',16,'AS0016-2',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-06-11 02:12:58',NULL),(56,'Black',16,'AS0016-3',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-06-11 02:12:58',NULL),(57,'Black',17,'AS0017-1',19,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-08-12 17:45:20',NULL),(58,'White',17,'AS0017-2',19,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-08-12 17:45:20',NULL),(59,'256 GB',18,'AS0018-1',20,1350.00,1350.00,25.00,1687.50,1687.50,'2018-01-06 00:37:30','2018-06-11 02:07:29',NULL),(60,'500 GB',18,'AS0018-2',20,1450.00,1450.00,25.00,1812.50,1812.50,'2018-01-06 00:37:30','2018-06-11 02:07:29',NULL),(61,'DUMMY',19,'AS0019',21,8.00,8.00,25.00,10.00,10.00,'2018-01-06 00:40:28','2018-06-11 02:08:23',NULL),(62,'Gray',20,'AS0020-1',22,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-06-11 02:14:10',NULL),(63,'Black',20,'AS0020-2',22,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-06-11 02:14:10',NULL),(64,'DUMMY',21,'AS0021',23,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:46:35','2018-06-11 02:12:13',NULL),(65,'DUMMY',22,'AS0022',24,8.00,8.80,25.00,10.00,11.00,'2018-01-06 00:55:09','2018-06-11 02:08:37',NULL),(66,'DUMMY',23,'AS0023',25,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:56:27','2018-06-11 02:13:51',NULL),(67,'DUMMY',24,'AS0024',26,8.00,8.80,25.00,10.00,11.00,'2018-01-06 01:01:22','2018-06-11 02:08:53',NULL),(68,'DUMMY',25,'AS0025',27,15.00,15.00,25.00,18.75,18.75,'2018-01-06 01:02:23','2018-06-11 02:09:09',NULL),(69,'DUMMY',26,'AS0026',28,5.00,5.00,25.00,6.25,6.25,'2018-01-06 01:05:51','2018-06-11 02:11:51',NULL),(70,'DUMMY',27,'AS0027',29,20.00,22.00,25.00,25.00,27.50,'2018-01-06 01:13:16','2018-06-11 02:08:01',NULL),(71,'DUMMY',28,'AS0028',30,10.00,11.00,25.00,12.50,13.75,'2018-01-06 01:15:47','2018-06-11 02:07:45',NULL),(72,'DUMMY',29,'AS0029',31,12.00,12.00,25.00,15.00,15.00,'2018-01-06 01:16:53','2018-06-11 02:14:34',NULL),(73,'DUMMY',30,'AS0030',32,40.00,44.00,25.00,50.00,55.00,'2018-01-06 01:18:59','2018-06-11 02:09:59',NULL),(74,'DUMMY',31,'AP0031',33,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:36:29','2018-04-10 04:36:29',NULL),(75,'DUMMY',32,'AP0032',34,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:37:52','2018-04-10 04:37:52',NULL),(76,'DUMMY',33,'AP0033',35,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:39:45','2018-04-10 04:39:45',NULL),(77,'DUMMY',34,'AP0034',36,6.00,6.00,25.00,7.50,7.50,'2018-04-10 04:40:59','2018-04-10 04:40:59',NULL),(78,'DUMMY',35,'AP0035',37,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:42:53','2018-04-10 04:42:53',NULL),(79,'DUMMY',36,'AP0036',38,9.00,9.00,25.00,11.25,11.25,'2018-04-10 04:44:18','2018-04-10 04:44:18',NULL),(80,'DUMMY',37,'AP0037',39,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:01:29','2018-04-10 05:01:29',NULL),(81,'DUMMY',38,'AP0038',40,15.00,15.00,25.00,18.75,18.75,'2018-04-10 05:02:35','2018-04-10 05:02:35',NULL),(82,'DUMMY',39,'AP0039',41,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:03:26','2018-04-10 05:03:26',NULL),(83,'DUMMY',40,'AP0040',42,8.00,8.00,25.00,10.00,10.00,'2018-04-10 05:04:32','2018-04-10 05:04:49',NULL),(84,'DUMMY',41,'AE0041',43,500.00,500.00,25.00,625.00,625.00,'2018-04-10 05:38:27','2018-04-10 05:38:27',NULL),(85,'DUMMY',42,'AE0042',44,520.00,520.00,25.00,650.00,650.00,'2018-04-10 05:45:52','2018-04-10 06:21:21',NULL),(86,'DUMMY',43,'AE0043',45,400.00,400.00,25.00,500.00,500.00,'2018-04-10 05:48:01','2018-04-10 05:48:01',NULL),(87,'DUMMY',44,'AE0044',46,195.00,195.00,25.00,243.75,243.75,'2018-04-10 05:49:10','2018-04-10 05:49:10',NULL),(88,'DUMMY',45,'AE0045',47,300.00,300.00,25.00,375.00,375.00,'2018-04-10 05:50:22','2018-04-10 05:50:22',NULL),(89,'DUMMY',46,'AE0046',48,321.00,321.00,25.00,401.25,401.25,'2018-04-10 05:52:04','2018-04-10 05:52:04',NULL),(90,'DUMMY',47,'AE0047',49,255.00,255.00,25.00,318.75,318.75,'2018-04-10 05:53:45','2018-04-10 05:53:45',NULL),(91,'DUMMY',48,'AE0048',50,850.00,850.00,25.00,1062.50,1062.50,'2018-04-10 05:54:42','2018-04-10 06:22:07',NULL),(92,'DUMMY',49,'AE0049',51,1500.00,1500.00,25.00,1875.00,1875.00,'2018-04-10 05:55:55','2018-04-10 05:55:55',NULL),(93,'DUMMY',50,'AE0050',52,630.00,630.00,25.00,787.50,787.50,'2018-04-10 06:04:32','2018-04-10 06:04:32',NULL),(94,'DUMMY',51,'AS0051',53,100.00,100.00,25.00,125.00,125.00,'2018-04-10 07:04:57','2018-04-10 07:04:57',NULL),(95,'DUMMY',52,'AS0052',54,80.00,80.00,25.00,100.00,100.00,'2018-04-10 07:05:55','2018-04-10 07:05:55',NULL),(96,'DUMMY',53,'AS0053',55,105.00,105.00,25.00,131.25,131.25,'2018-04-10 07:09:15','2018-04-10 07:09:15',NULL),(97,'DUMMY',54,'AS0054',56,10.00,10.00,25.00,12.50,12.50,'2018-04-10 07:24:16','2018-04-10 07:24:16',NULL),(98,'DUMMY',55,'AS0055',57,8.00,8.00,25.00,10.00,10.00,'2018-04-10 07:26:18','2018-04-10 07:26:18',NULL),(99,'DUMMY',56,'AS0056',58,150.00,150.00,25.00,187.50,187.50,'2018-04-10 07:31:59','2018-04-10 07:31:59',NULL),(100,'DUMMY',57,'AS0057',59,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:01','2018-04-10 07:33:01',NULL),(101,'DUMMY',58,'AS0058',60,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:37','2018-04-10 07:33:37',NULL),(102,'DUMMY',59,'AS0059',61,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:36:45','2018-04-10 07:36:45',NULL),(103,'DUMMY',60,'AS0060',62,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:37:08','2018-04-10 07:37:08',NULL),(104,'DUMMY',61,'AS0061',63,34.00,34.00,25.00,42.50,42.50,'2018-06-11 16:27:41','2018-06-11 16:27:41',NULL),(105,'DUMMY',62,'AS0062',64,35.00,35.00,25.00,43.75,43.75,'2018-06-11 16:32:17','2018-06-11 16:32:17',NULL),(106,'DUMMY',63,'AS0063',65,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:38:12','2018-06-11 16:38:12',NULL),(107,'DUMMY',64,'AS0064',66,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:40:34','2018-06-11 16:40:34',NULL),(108,'DUMMY',65,'AS0065',67,10.00,10.00,25.00,12.50,12.50,'2018-06-11 16:44:00','2018-06-11 16:44:30',NULL),(109,'DUMMY',66,'AR0066',68,15.00,15.00,25.00,18.75,18.75,'2018-07-13 01:00:31','2018-07-13 01:00:31',NULL),(110,'DUMMY',67,'AR0067',69,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:04:47','2018-07-13 01:04:47',NULL),(111,'DUMMY',68,'AR0068',70,11.00,11.00,25.00,13.75,13.75,'2018-07-13 01:08:55','2018-07-13 01:08:55',NULL),(112,'DUMMY',69,'AR0069',71,12.00,12.00,25.00,15.00,15.00,'2018-07-13 01:15:51','2018-07-13 01:15:51',NULL),(113,'DUMMY',70,'AR0070',72,12.00,12.00,25.00,15.00,15.00,'2018-07-13 01:27:37','2018-07-13 01:27:37',NULL),(114,'DUMMY',71,'AR0071',73,17.00,17.00,25.00,21.25,21.25,'2018-07-13 01:30:41','2018-07-13 01:30:41',NULL),(115,'DUMMY',72,'AR0072',74,18.00,18.00,25.00,22.50,22.50,'2018-07-13 01:35:03','2018-07-13 01:35:03',NULL),(116,'DUMMY',73,'AR0073',75,20.00,20.00,25.00,25.00,25.00,'2018-07-13 01:37:29','2018-07-13 01:37:29',NULL),(117,'DUMMY',74,'AR0074',76,7.00,7.00,25.00,8.75,8.75,'2018-07-13 01:40:45','2018-07-13 01:40:45',NULL),(118,'DUMMY',75,'AR0075',77,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:43:09','2018-07-13 01:43:09',NULL),(119,'DUMMY',76,'AR0076',78,8.00,8.00,25.00,10.00,10.00,'2018-07-13 01:48:33','2018-07-13 01:48:33',NULL),(120,'DUMMY',77,'AR0077',79,3.00,3.00,25.00,3.75,3.75,'2018-07-13 01:54:22','2018-07-13 01:58:56',NULL),(121,'Bacon',78,'AR0078-1',80,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:28:04','2018-07-16 02:28:51',NULL),(122,'Black olives',78,'AR0078-2',80,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:28:33','2018-07-16 02:28:51',NULL),(123,'Green peppers',78,'AR0078-3',80,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:28:51','2018-07-16 02:28:51',NULL),(124,'Cheese',79,'AR0079-1',81,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(125,'Vegies',79,'AR0079-2',81,1.00,1.00,0.00,1.00,1.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(126,'Bacon',79,'AR0079-3',81,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:35:37','2018-07-16 02:36:52',NULL),(127,'Chocolate',79,'AR0079-4',81,2.00,2.00,0.00,2.00,2.00,'2018-07-16 02:36:52','2018-07-16 02:36:52',NULL),(128,'DUMMY',80,'with supplier',82,100.00,100.00,25.00,125.00,125.00,'2018-08-07 22:59:03','2018-08-07 22:59:03',NULL),(129,'DUMMY',81,'P1 package',83,100.00,100.00,25.00,125.00,125.00,'2018-08-12 17:40:39','2018-08-12 17:40:39',NULL),(130,'DUMMY',82,'P2 package',84,250.00,250.00,25.00,312.50,312.50,'2018-08-12 17:41:16','2018-08-12 17:41:16',NULL),(131,'DUMMY',83,'P3 package',85,300.00,300.00,25.00,375.00,375.00,'2018-08-12 17:41:48','2018-08-12 17:41:48',NULL);
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

