
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Levis',NULL,1,NULL,'2018-01-03 15:49:47','2018-01-03 15:49:47'),(2,1,'Espirit',NULL,1,NULL,'2018-01-03 15:49:58','2018-01-03 15:49:58'),(3,1,'U.S. Polo Assn.',NULL,1,NULL,'2018-01-03 15:50:26','2018-01-03 15:50:26'),(4,1,'Nike',NULL,1,NULL,'2018-01-03 15:50:34','2018-01-03 15:50:34'),(5,1,'Puma',NULL,1,NULL,'2018-01-03 15:50:40','2018-01-03 15:50:40'),(6,1,'Adidas',NULL,1,NULL,'2018-01-03 15:50:46','2018-01-03 15:50:46'),(7,1,'Samsung',NULL,1,NULL,'2018-01-06 00:10:14','2018-01-06 00:10:14'),(8,1,'Apple',NULL,1,NULL,'2018-01-06 00:10:23','2018-01-06 00:10:23'),(9,1,'Acer',NULL,1,NULL,'2018-01-06 00:33:37','2018-01-06 00:33:37'),(10,1,'Bowflex',NULL,1,NULL,'2018-01-06 00:45:31','2018-01-06 00:45:31'),(11,1,'Oreo',NULL,1,NULL,'2018-01-06 01:05:00','2018-01-06 01:05:00'),(12,1,'Sharewood',NULL,1,NULL,'2018-01-06 01:10:52','2018-01-06 01:10:52'),(13,1,'Barilla',NULL,1,NULL,'2018-01-06 01:14:59','2018-01-06 01:14:59'),(14,1,'Lipton',NULL,1,NULL,'2018-01-06 01:18:12','2018-01-06 01:18:12'),(15,2,'Acino',NULL,4,NULL,'2018-04-10 02:44:44','2018-04-10 02:44:44'),(16,2,'Cipla',NULL,4,NULL,'2018-04-10 02:45:04','2018-04-10 02:45:04'),(17,2,'BAYER',NULL,4,NULL,'2018-04-10 02:45:32','2018-04-10 02:45:32'),(18,3,'Samsung',NULL,5,NULL,'2018-04-10 05:27:28','2018-04-10 05:27:28'),(19,3,'LG',NULL,5,NULL,'2018-04-10 05:27:35','2018-04-10 05:27:35'),(20,3,'Apple',NULL,5,NULL,'2018-04-10 05:27:42','2018-04-10 05:27:42'),(21,3,'Sony',NULL,5,NULL,'2018-04-10 05:27:49','2018-04-10 05:27:49'),(22,3,'Panasonic',NULL,5,NULL,'2018-04-10 05:27:57','2018-04-10 05:27:57'),(23,3,'HP',NULL,5,NULL,'2018-04-10 05:37:21','2018-04-10 05:37:21'),(24,1,'test','test',1,NULL,'2018-04-19 16:25:34','2018-04-19 16:25:34'),(30,1,'Variation',NULL,1,NULL,'2018-04-25 07:04:27','2018-04-25 07:04:27'),(31,1,'ARENA Y MAR',NULL,1,NULL,'2018-04-25 08:09:20','2018-04-25 08:09:20'),(33,1,'ANTIDOTO',NULL,1,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(34,1,'timezone','timezone',1,NULL,'2018-05-10 12:37:43','2018-05-10 12:37:43');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'd-m-Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Awesome Shop',38,'2018-01-01','24DYQPS5104C1ZG','TIN:','DYQPS5104C','PAN:',NULL,25.00,1,'Asia/Kolkata',1,'fifo',10.00,'includes',NULL,'AS',1,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',1,1,1,1,1,1,NULL,1,1,1,1,NULL,1,1,'before',NULL,'d-m-Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"SR\",\"expense\":\"EXP\",\"contacts\":\"CON\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}','2018-01-03 20:45:19','2018-06-05 10:49:55'),(2,'Awesome Pharmacy',2,'2018-04-10','3412569900','VAT',NULL,NULL,NULL,25.00,4,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AP',1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,1,1,1,1,1,0,4,0,0,0,1,NULL,1,0,'before',NULL,'d-m-Y','24',NULL,'2018-04-10 02:42:40','2018-04-10 04:51:38'),(3,'Ultimate Electronics',2,'2018-04-10','12548555003','GST',NULL,NULL,NULL,25.00,5,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AE',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,1,1,1,1,1,0,5,0,0,0,1,NULL,1,0,'before',NULL,'d-m-Y','24',NULL,'2018-04-10 05:16:15','2018-04-10 06:23:35'),(4,'Awesome Services',124,NULL,'3412569900','GST',NULL,NULL,NULL,25.00,6,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,0,1,0,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'d-m-Y','24',NULL,'2018-04-10 06:50:42','2018-04-10 06:53:40');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,NULL,'Pcbucket Infotech','3-Kamla,Opp Opera Society,New Vikagruh Road, Paldi','India','Gujarat','Ahmedabad','PIN Cod',1,5,1,'browser',NULL,NULL,NULL,'support@thepcbucket.com','www.pcbucket.com',NULL,NULL,NULL,NULL,NULL,'2018-01-03 20:45:20','2018-05-24 07:25:20'),(2,2,NULL,'Awesome Pharmacy','Linking Street','USA','Arizona','Phoenix','492001',2,2,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(3,3,NULL,'Ultimate Electronics','Linking Street','USA','Arizona','Phoenix','492001',3,3,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(4,4,NULL,'Awesome Services','Linking Street','USA','Arizona','Phoenix','282001',4,4,1,'browser',NULL,'','','',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,1,NULL,'Loc2','loc2','c','state','test','zip',1,1,1,'browser',NULL,'m','a','test@test.com',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-23 11:44:20','2018-04-23 11:44:20'),(6,1,NULL,'Almacen 1','Almacen 1','Almacen 1','Almacen 1','Almacen 1','Almacen',1,5,1,'browser',NULL,'Almacen 1','Almacen 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 08:02:23','2018-04-25 08:02:23'),(7,1,NULL,'Electro','Electro','Electro','Electro','Electro','Electro',1,1,1,'browser',NULL,'Electro','v',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 11:25:34','2018-04-25 11:25:34'),(8,1,'BL0001','loc1010',NULL,'tet','tet','test','test',1,1,1,'browser',NULL,'t',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-31 06:27:30','2018-05-31 06:27:30');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `pay_method` enum('cash','card','cheque','bank_transfer','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,10.00,'cash','credit','initial',NULL,'2018-04-19 16:23:19','2018-04-19 16:23:19'),(2,1,562.50,'cash','credit','sell',38,'2018-04-20 10:53:18','2018-04-20 10:53:18'),(3,1,142.56,'cash','credit','sell',39,'2018-04-23 12:39:06','2018-04-23 12:39:06'),(4,1,69.30,'cash','credit','sell',40,'2018-04-24 05:31:36','2018-04-24 05:31:36'),(5,1,69.30,'cash','credit','sell',45,'2018-04-24 05:33:42','2018-04-24 05:33:42'),(6,1,12.38,'cash','credit','sell',46,'2018-04-24 05:55:44','2018-04-24 05:55:44'),(7,1,851.40,'cash','credit','sell',47,'2018-04-24 07:35:45','2018-04-24 07:35:45'),(8,1,641.52,'cash','credit','sell',47,'2018-04-24 07:37:41','2018-04-24 07:37:41'),(9,1,12.38,'cash','credit','sell',48,'2018-04-24 10:36:45','2018-04-24 10:36:45'),(10,1,71.28,'cash','credit','sell',49,'2018-04-24 10:39:50','2018-04-24 10:39:50'),(11,1,71.28,'cash','credit','sell',50,'2018-04-24 10:43:06','2018-04-24 10:43:06'),(12,1,71.28,'cash','credit','sell',51,'2018-04-24 10:43:12','2018-04-24 10:43:12'),(13,1,71.28,'cash','credit','sell',52,'2018-04-24 10:44:21','2018-04-24 10:44:21'),(14,1,71.28,'cash','credit','sell',53,'2018-04-24 10:44:57','2018-04-24 10:44:57'),(15,1,71.28,'cash','credit','sell',54,'2018-04-24 10:45:30','2018-04-24 10:45:30'),(16,1,71.28,'cash','credit','sell',55,'2018-04-24 10:46:09','2018-04-24 10:46:09'),(17,1,71.28,'cash','credit','sell',56,'2018-04-24 10:46:27','2018-04-24 10:46:27'),(18,1,71.28,'cash','credit','sell',57,'2018-04-24 10:47:15','2018-04-24 10:47:15'),(19,1,71.28,'cash','credit','sell',58,'2018-04-24 10:47:29','2018-04-24 10:47:29'),(20,1,71.28,'cash','credit','sell',59,'2018-04-24 10:47:52','2018-04-24 10:47:52'),(21,1,71.28,'cash','credit','sell',60,'2018-04-24 10:49:21','2018-04-24 10:49:21'),(22,1,71.28,'cash','credit','sell',61,'2018-04-24 10:49:45','2018-04-24 10:49:45'),(23,1,71.28,'cash','credit','sell',62,'2018-04-24 10:49:54','2018-04-24 10:49:54'),(24,1,71.28,'cash','credit','sell',63,'2018-04-24 10:50:30','2018-04-24 10:50:30'),(25,1,69.30,'cash','credit','sell',64,'2018-04-24 10:52:02','2018-04-24 10:52:02'),(26,1,71.28,'cash','credit','sell',65,'2018-04-24 10:53:05','2018-04-24 10:53:05'),(27,1,71.28,'cash','credit','sell',66,'2018-04-24 10:54:03','2018-04-24 10:54:03'),(28,1,71.28,'cash','credit','sell',67,'2018-04-24 10:56:14','2018-04-24 10:56:14'),(29,1,12.38,'cash','credit','sell',68,'2018-04-24 10:56:34','2018-04-24 10:56:34'),(30,1,1386.00,'cash','credit','sell',69,'2018-04-24 13:20:52','2018-04-24 13:20:52'),(31,1,712.80,'cash','credit','sell',194,'2018-04-25 10:42:06','2018-04-25 10:42:06'),(32,1,69.30,'cash','credit','sell',292,'2018-04-25 12:18:43','2018-04-25 12:18:43'),(33,1,69.30,'cash','credit','sell',293,'2018-04-25 12:30:27','2018-04-25 12:30:27'),(34,1,69.30,'cash','credit','sell',294,'2018-04-25 12:31:09','2018-04-25 12:31:09'),(35,1,69.30,'cash','credit','sell',295,'2018-04-25 12:32:16','2018-04-25 12:32:16'),(36,1,69.30,'cash','credit','sell',296,'2018-04-25 12:32:46','2018-04-25 12:32:46'),(37,1,69.30,'cash','credit','sell',297,'2018-04-25 12:33:14','2018-04-25 12:33:14'),(38,1,71.28,'cash','credit','sell',298,'2018-04-25 12:34:16','2018-04-25 12:34:16'),(39,1,69.30,'cash','credit','sell',299,'2018-04-25 12:34:44','2018-04-25 12:34:44'),(40,1,71.28,'cash','credit','sell',300,'2018-04-25 12:35:41','2018-04-25 12:35:41'),(41,1,69.30,'cash','credit','sell',301,'2018-04-25 12:35:59','2018-04-25 12:35:59'),(42,1,71.28,'cash','credit','sell',302,'2018-04-25 12:36:40','2018-04-25 12:36:40'),(43,1,69.30,'cash','credit','sell',303,'2018-04-25 12:39:08','2018-04-25 12:39:08'),(44,1,71.28,'cash','credit','sell',304,'2018-04-25 12:40:09','2018-04-25 12:40:09'),(45,1,112.50,'cash','credit','sell',305,'2018-04-25 12:41:02','2018-04-25 12:41:02'),(46,1,71.28,'cash','credit','sell',306,'2018-04-25 12:42:42','2018-04-25 12:42:42'),(47,1,71.28,'cash','credit','sell',307,'2018-04-25 12:46:42','2018-04-25 12:46:42'),(48,1,69.30,'cash','credit','sell',308,'2018-04-25 12:47:46','2018-04-25 12:47:46'),(49,1,69.30,'cash','credit','sell',309,'2018-04-25 12:49:35','2018-04-25 12:49:35'),(50,1,12.38,'cash','credit','sell',310,'2018-04-25 12:52:19','2018-04-25 12:52:19'),(51,1,69.30,'cash','credit','sell',311,'2018-04-25 12:52:57','2018-04-25 12:52:57'),(52,1,71.28,'cash','credit','sell',312,'2018-04-25 12:56:20','2018-04-25 12:56:20'),(53,1,69.30,'cash','credit','sell',313,'2018-04-25 13:02:08','2018-04-25 13:02:08'),(54,1,71.28,'cash','credit','sell',314,'2018-04-25 13:06:13','2018-04-25 13:06:13'),(55,1,69.30,'cash','credit','sell',315,'2018-04-25 13:06:29','2018-04-25 13:06:29'),(56,1,71.28,'cash','credit','sell',316,'2018-04-25 13:07:25','2018-04-25 13:07:25'),(57,1,69.30,'cash','credit','sell',317,'2018-04-25 13:08:28','2018-04-25 13:08:28'),(58,1,71.28,'cash','credit','sell',318,'2018-04-25 13:09:07','2018-04-25 13:09:07'),(59,1,71.28,'cash','credit','sell',319,'2018-04-25 13:09:49','2018-04-25 13:09:49'),(60,1,69.30,'cash','credit','sell',320,'2018-04-25 13:10:36','2018-04-25 13:10:36'),(61,1,69.30,'cash','credit','sell',321,'2018-04-25 13:11:01','2018-04-25 13:11:01'),(62,1,71.28,'cash','credit','sell',322,'2018-04-25 13:11:20','2018-04-25 13:11:20'),(63,1,69.30,'cash','credit','sell',323,'2018-04-25 13:11:49','2018-04-25 13:11:49'),(64,1,71.28,'cash','credit','sell',324,'2018-04-25 13:12:21','2018-04-25 13:12:21'),(65,1,69.30,'cash','credit','sell',325,'2018-04-25 13:12:35','2018-04-25 13:12:35'),(66,1,71.28,'cash','credit','sell',326,'2018-04-25 13:13:11','2018-04-25 13:13:11'),(67,1,69.30,'cash','credit','sell',327,'2018-04-25 13:14:07','2018-04-25 13:14:07'),(68,1,71.28,'cash','credit','sell',328,'2018-04-25 13:15:04','2018-04-25 13:15:04'),(69,1,69.30,'cash','credit','sell',329,'2018-04-25 13:15:26','2018-04-25 13:15:26'),(70,1,71.28,'cash','credit','sell',330,'2018-04-25 13:15:42','2018-04-25 13:15:42'),(71,1,69.30,'cash','credit','sell',331,'2018-04-25 13:16:03','2018-04-25 13:16:03'),(72,1,71.28,'cash','credit','sell',332,'2018-04-25 13:16:21','2018-04-25 13:16:21'),(73,1,69.30,'cash','credit','sell',333,'2018-04-25 13:16:41','2018-04-25 13:16:41'),(74,1,71.28,'cash','credit','sell',334,'2018-04-25 13:17:14','2018-04-25 13:17:14'),(75,1,112.50,'cash','credit','sell',335,'2018-04-25 13:23:17','2018-04-25 13:23:17'),(76,1,69.30,'cash','credit','sell',336,'2018-04-25 13:25:27','2018-04-25 13:25:27'),(77,1,71.28,'cash','credit','sell',337,'2018-04-25 13:25:38','2018-04-25 13:25:38'),(78,1,69.30,'cash','credit','sell',338,'2018-04-25 13:26:02','2018-04-25 13:26:02'),(79,1,71.28,'cash','credit','sell',339,'2018-04-25 13:26:33','2018-04-25 13:26:33'),(80,1,69.30,'cash','credit','sell',340,'2018-04-25 13:26:49','2018-04-25 13:26:49'),(81,1,71.28,'cash','credit','sell',341,'2018-04-27 06:31:52','2018-04-27 06:31:52'),(82,1,81.77,'cash','credit','sell',342,'2018-04-27 06:32:18','2018-04-27 06:32:18'),(83,1,71.28,'cash','credit','sell',343,'2018-04-27 07:46:51','2018-04-27 07:46:51'),(84,1,69.30,'cash','credit','sell',349,'2018-04-27 10:32:26','2018-04-27 10:32:26'),(85,1,12.38,'cash','credit','sell',351,'2018-04-27 10:47:15','2018-04-27 10:47:15'),(86,1,12.38,'cash','debit','refund',351,'2018-04-27 11:45:45','2018-04-27 11:45:45'),(87,1,12.38,'cash','credit','sell',351,'2018-04-27 11:46:24','2018-04-27 11:46:24'),(88,1,69.30,'cash','credit','sell',348,'2018-04-27 11:50:57','2018-04-27 11:50:57'),(89,1,11250.00,'cash','credit','sell',361,'2018-04-30 13:34:26','2018-04-30 13:34:26'),(90,2,0.00,'cash','credit','initial',NULL,'2018-05-01 05:24:42','2018-05-01 05:24:42'),(91,2,71.28,'cash','credit','sell',362,'2018-05-01 05:25:06','2018-05-01 05:25:06'),(92,2,1.98,'cash','debit','refund',362,'2018-05-01 05:51:02','2018-05-01 05:51:02'),(93,2,78.41,'cash','credit','sell',363,'2018-05-01 05:52:35','2018-05-01 05:52:35'),(94,2,71.28,'cash','credit','sell',366,'2018-05-01 12:06:02','2018-05-01 12:06:02'),(95,2,69.30,'cash','credit','sell',367,'2018-05-01 12:49:49','2018-05-01 12:49:49'),(96,2,71.28,'cash','credit','sell',368,'2018-05-01 12:52:29','2018-05-01 12:52:29'),(97,2,112.50,'cash','credit','sell',369,'2018-05-02 05:36:29','2018-05-02 05:36:29'),(98,2,69.30,'cash','credit','sell',372,'2018-05-02 06:51:08','2018-05-02 06:51:08'),(99,2,112.50,'cash','credit','sell',373,'2018-05-02 06:52:34','2018-05-02 06:52:34'),(103,2,112.50,'cash','credit','sell',377,'2018-05-02 07:01:31','2018-05-02 07:01:31'),(104,2,100.00,'cash','credit','sell',378,'2018-05-02 07:23:36','2018-05-02 07:23:36'),(105,2,69.30,'cash','credit','sell',379,'2018-05-02 07:24:31','2018-05-02 07:24:31'),(106,2,71.28,'cash','credit','sell',380,'2018-05-02 07:25:55','2018-05-02 07:25:55'),(107,2,69.30,'cash','credit','sell',381,'2018-05-02 07:26:10','2018-05-02 07:26:10'),(108,2,112.50,'cash','credit','sell',382,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(109,2,0.00,'cash','credit','sell',382,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(110,2,150.00,'cash','credit','sell',383,'2018-05-02 07:29:27','2018-05-02 07:29:27'),(111,2,37.50,'cash','credit','sell',383,'2018-05-02 07:29:27','2018-05-02 07:29:27'),(112,2,62.50,'cash','credit','sell',383,'2018-05-02 07:42:22','2018-05-02 07:42:22'),(113,2,200.00,'cash','credit','sell',384,'2018-05-02 07:44:08','2018-05-02 07:44:08'),(114,2,87.50,'cash','credit','sell',384,'2018-05-02 07:44:08','2018-05-02 07:44:08'),(115,2,100.00,'cash','credit','sell',384,'2018-05-02 07:47:54','2018-05-02 07:47:54'),(116,3,0.00,'cash','credit','initial',NULL,'2018-05-02 08:13:30','2018-05-02 08:13:30'),(117,3,100.00,'cash','credit','sell',385,'2018-05-02 08:13:48','2018-05-02 08:13:48'),(118,3,28.72,'cash','debit','sell',385,'2018-05-02 08:13:48','2018-05-02 08:13:48'),(119,3,107.44,'cash','credit','sell',385,'2018-05-02 08:22:36','2018-05-02 08:22:36'),(120,3,20.00,'cash','credit','sell',385,'2018-05-02 08:25:02','2018-05-02 08:25:02'),(121,3,40.00,'cash','credit','sell',385,'2018-05-02 08:26:02','2018-05-02 08:26:02'),(122,4,0.00,'cash','credit','initial',NULL,'2018-05-02 08:32:57','2018-05-02 08:32:57'),(123,4,100.00,'cash','credit','sell',386,'2018-05-02 08:33:15','2018-05-02 08:33:15'),(124,4,-30.70,'cash','credit','sell',386,'2018-05-02 08:33:15','2018-05-02 08:33:15'),(125,4,81.40,'cash','credit','sell',386,'2018-05-02 08:33:57','2018-05-02 08:33:57'),(126,4,81.40,'cash','debit','refund',386,'2018-05-02 08:37:05','2018-05-02 08:37:05'),(127,5,0.00,'cash','credit','initial',NULL,'2018-05-02 08:37:29','2018-05-02 08:37:29'),(128,5,100.00,'cash','credit','sell',387,'2018-05-02 08:37:47','2018-05-02 08:37:47'),(129,5,-30.70,'cash','credit','sell',387,'2018-05-02 08:37:47','2018-05-02 08:37:47'),(130,5,112.50,'cash','credit','sell',388,'2018-05-02 08:39:07','2018-05-02 08:39:07'),(131,5,0.00,'cash','credit','sell',388,'2018-05-02 08:39:07','2018-05-02 08:39:07'),(132,5,120.00,'cash','debit','refund',388,'2018-05-02 08:39:41','2018-05-02 08:39:41'),(133,5,120.00,'card','credit','sell',388,'2018-05-02 08:39:41','2018-05-02 08:39:41'),(134,6,0.00,'cash','credit','initial',NULL,'2018-05-02 10:36:55','2018-05-02 10:36:55'),(135,6,100.00,'cash','credit','sell',389,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(136,6,-30.70,'cash','credit','sell',389,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(137,6,71.28,'cash','credit','sell',390,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(138,6,0.00,'cash','credit','sell',390,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(139,6,100.00,'cash','credit','sell',391,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(140,6,-30.70,'cash','credit','sell',391,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(141,6,69.30,'cash','credit','sell',392,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(142,6,0.00,'cash','credit','sell',392,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(143,6,100.00,'cash','credit','sell',393,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(144,6,-30.70,'cash','credit','sell',393,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(145,6,10.00,'cash','credit','sell',394,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(146,6,20.00,'card','credit','sell',394,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(147,6,50.00,'cheque','credit','sell',394,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(148,6,-10.70,'cash','credit','sell',394,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(149,6,100.00,'cash','credit','sell',395,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(150,6,-28.72,'cash','credit','sell',395,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(151,7,0.00,'cash','credit','initial',NULL,'2018-05-03 05:26:27','2018-05-03 05:26:27'),(152,7,135.00,'cash','credit','sell',396,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(153,7,0.00,'cash','credit','sell',396,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(154,7,146.25,'cash','credit','sell',397,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(155,7,0.00,'cash','credit','sell',397,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(156,7,146.25,'cash','credit','sell',398,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(157,7,0.00,'cash','credit','sell',398,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(158,7,71.28,'cash','credit','sell',399,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(159,7,0.00,'cash','credit','sell',399,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(160,7,135.00,'cash','credit','sell',400,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(161,7,0.00,'cash','credit','sell',400,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(162,7,10.00,'cash','credit','sell',401,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(163,7,0.00,'cash','credit','sell',401,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(164,7,71.28,'cash','credit','sell',402,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(165,7,0.00,'cash','credit','sell',402,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(166,7,120.00,'cash','credit','sell',403,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(167,7,-7.50,'cash','credit','sell',403,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(168,7,100.00,'cash','credit','sell',404,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(169,7,-30.70,'cash','credit','sell',404,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(170,7,76.23,'cash','credit','sell',405,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(171,7,0.00,'cash','credit','sell',405,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(172,7,10.00,'cash','credit','sell',406,'2018-05-03 10:29:10','2018-05-03 10:29:10'),(173,7,59.30,'card','credit','sell',406,'2018-05-03 10:29:10','2018-05-03 10:29:10'),(174,7,0.00,'cash','credit','sell',406,'2018-05-03 10:29:10','2018-05-03 10:29:10'),(175,7,71.28,'cash','credit','sell',406,'2018-05-07 07:38:23','2018-05-07 07:38:23'),(176,7,0.00,'cash','credit','sell',406,'2018-05-07 07:38:23','2018-05-07 07:38:23'),(177,7,69.30,'cash','credit','sell',407,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(178,7,0.00,'cash','credit','sell',407,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(179,7,69.30,'cash','credit','sell',408,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(180,7,0.00,'cash','credit','sell',408,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(181,7,71.28,'cash','credit','sell',409,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(182,7,0.00,'cash','credit','sell',409,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(183,7,71.28,'cash','credit','sell',410,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(184,7,0.00,'cash','credit','sell',410,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(185,7,69.30,'cash','credit','sell',411,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(186,7,0.00,'cash','credit','sell',411,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(187,7,69.30,'cash','credit','sell',412,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(188,7,0.00,'cash','credit','sell',412,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(189,7,69.30,'cash','credit','sell',413,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(190,7,0.00,'cash','credit','sell',413,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(191,7,69.30,'cash','credit','sell',414,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(192,7,0.00,'cash','credit','sell',414,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(193,7,142.56,'cash','credit','sell',415,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(194,7,0.00,'cash','credit','sell',415,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(195,7,69.30,'cash','credit','sell',416,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(196,7,0.00,'cash','credit','sell',416,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(197,7,69.30,'cash','credit','sell',417,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(198,7,0.00,'cash','credit','sell',417,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(199,7,71.28,'cash','credit','sell',418,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(200,7,0.00,'cash','credit','sell',418,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(201,7,69.30,'cash','credit','sell',419,'2018-05-07 08:15:33','2018-05-07 08:15:33'),(202,7,0.00,'cash','credit','sell',419,'2018-05-07 08:15:33','2018-05-07 08:15:33'),(203,7,69.30,'cash','credit','sell',420,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(204,7,0.00,'cash','credit','sell',420,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(205,7,71.28,'cash','credit','sell',421,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(206,7,0.00,'cash','credit','sell',421,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(207,7,69.30,'cash','credit','sell',422,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(208,7,0.00,'cash','credit','sell',422,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(209,7,69.30,'cash','credit','sell',423,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(210,7,0.00,'cash','credit','sell',423,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(211,7,71.28,'cash','credit','sell',426,'2018-05-07 13:21:56','2018-05-07 13:21:56'),(212,7,0.00,'cash','credit','sell',426,'2018-05-07 13:21:56','2018-05-07 13:21:56'),(213,7,34.00,'cash','credit','sell',426,'2018-05-10 10:54:26','2018-05-10 10:54:26'),(214,7,0.00,'cash','credit','sell',426,'2018-05-10 10:54:26','2018-05-10 10:54:26'),(215,7,34.00,'cash','credit','sell',427,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(216,7,0.00,'cash','credit','sell',427,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(217,7,34.00,'cash','credit','sell',428,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(218,7,0.00,'cash','credit','sell',428,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(219,7,33.98,'cash','credit','sell',429,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(220,7,0.00,'cash','credit','sell',429,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(221,7,34.00,'cash','credit','sell',430,'2018-05-10 11:24:25','2018-05-10 11:24:25'),(222,7,0.00,'cash','credit','sell',430,'2018-05-10 11:24:25','2018-05-10 11:24:25'),(223,7,69.30,'cash','credit','sell',431,'2018-05-10 12:54:15','2018-05-10 12:54:15'),(224,7,0.00,'cash','credit','sell',431,'2018-05-10 12:54:15','2018-05-10 12:54:15'),(225,7,69.30,'cash','credit','sell',432,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(226,7,0.00,'cash','credit','sell',432,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(227,7,69.30,'cash','credit','sell',433,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(228,7,0.00,'cash','credit','sell',433,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(229,7,69.30,'cash','credit','sell',435,'2018-05-11 12:23:32','2018-05-11 12:23:32'),(230,7,0.00,'cash','credit','sell',435,'2018-05-11 12:23:32','2018-05-11 12:23:32'),(231,7,71.28,'cash','credit','sell',436,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(232,7,0.00,'cash','credit','sell',436,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(233,7,71.28,'cash','credit','sell',437,'2018-05-11 12:34:58','2018-05-11 12:34:58'),(234,7,0.00,'cash','credit','sell',437,'2018-05-11 12:34:58','2018-05-11 12:34:58'),(235,7,69.30,'cash','credit','sell',438,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(236,7,0.00,'cash','credit','sell',438,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(237,7,69.30,'cash','credit','sell',439,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(238,7,0.00,'cash','credit','sell',439,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(239,7,71.28,'cash','credit','sell',440,'2018-05-11 14:43:26','2018-05-11 14:43:26'),(240,7,0.00,'cash','credit','sell',440,'2018-05-11 14:43:27','2018-05-11 14:43:27'),(241,7,71.28,'cash','credit','sell',441,'2018-05-12 06:08:03','2018-05-12 06:08:03'),(242,7,0.00,'cash','credit','sell',441,'2018-05-12 06:08:03','2018-05-12 06:08:03'),(243,7,69.30,'cash','credit','sell',442,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(244,7,0.00,'cash','credit','sell',442,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(245,7,69.30,'cash','credit','sell',443,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(246,7,0.00,'cash','credit','sell',443,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(247,7,71.28,'cash','credit','sell',444,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(248,7,0.00,'cash','credit','sell',444,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(249,7,71.28,'cash','credit','sell',445,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(250,7,0.00,'cash','credit','sell',445,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(251,7,71.28,'cash','credit','sell',446,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(252,7,0.00,'cash','credit','sell',446,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(253,7,69.30,'cash','credit','sell',447,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(254,7,0.00,'cash','credit','sell',447,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(255,7,69.30,'cash','credit','sell',448,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(256,7,0.00,'cash','credit','sell',448,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(257,7,71.28,'cash','credit','sell',449,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(258,7,0.00,'cash','credit','sell',449,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(259,7,71.28,'cash','credit','sell',450,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(260,7,0.00,'cash','credit','sell',450,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(261,7,69.30,'cash','credit','sell',451,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(262,7,0.00,'cash','credit','sell',451,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(263,7,71.28,'cash','credit','sell',452,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(264,7,0.00,'cash','credit','sell',452,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(265,7,69.30,'cash','credit','sell',453,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(266,7,0.00,'cash','credit','sell',453,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(267,7,71.28,'cash','credit','sell',454,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(268,7,0.00,'cash','credit','sell',454,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(269,7,69.30,'cash','credit','sell',455,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(270,7,0.00,'cash','credit','sell',455,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(271,7,71.28,'cash','credit','sell',456,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(272,7,0.00,'cash','credit','sell',456,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(273,7,69.30,'cash','credit','sell',457,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(274,7,0.00,'cash','credit','sell',457,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(275,7,69.30,'cash','credit','sell',458,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(276,7,0.00,'cash','credit','sell',458,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(277,7,69.30,'cash','credit','sell',459,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(278,7,0.00,'cash','credit','sell',459,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(279,7,71.28,'cash','credit','sell',460,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(280,7,0.00,'cash','credit','sell',460,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(281,7,71.28,'cash','credit','sell',461,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(282,7,0.00,'cash','credit','sell',461,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(283,7,69.30,'cash','credit','sell',462,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(284,7,0.00,'cash','credit','sell',462,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(285,7,69.30,'cash','credit','sell',463,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(286,7,0.00,'cash','credit','sell',463,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(287,7,71.28,'cash','credit','sell',464,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(288,7,0.00,'cash','credit','sell',464,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(289,7,71.28,'cash','credit','sell',465,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(290,7,0.00,'cash','credit','sell',465,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(291,7,69.30,'cash','credit','sell',466,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(292,7,0.00,'cash','credit','sell',466,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(293,7,69.30,'cash','credit','sell',467,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(294,7,0.00,'cash','credit','sell',467,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(295,7,71.28,'cash','credit','sell',468,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(296,7,0.00,'cash','credit','sell',468,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(297,7,71.28,'cash','credit','sell',469,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(298,7,0.00,'cash','credit','sell',469,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(299,7,69.30,'cash','credit','sell',470,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(300,7,0.00,'cash','credit','sell',470,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(301,7,69.30,'cash','credit','sell',471,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(302,7,0.00,'cash','credit','sell',471,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(303,7,71.28,'cash','credit','sell',472,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(304,7,0.00,'cash','credit','sell',472,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(305,7,71.28,'cash','credit','sell',473,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(306,7,0.00,'cash','credit','sell',473,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(307,7,69.30,'cash','credit','sell',474,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(308,7,0.00,'cash','credit','sell',474,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(309,7,69.30,'cash','credit','sell',475,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(310,7,0.00,'cash','credit','sell',475,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(311,7,71.28,'cash','credit','sell',476,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(312,7,0.00,'cash','credit','sell',476,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(313,7,71.28,'cash','credit','sell',477,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(314,7,0.00,'cash','credit','sell',477,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(315,7,69.30,'cash','credit','sell',478,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(316,7,0.00,'cash','credit','sell',478,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(317,7,69.30,'cash','credit','sell',479,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(318,7,0.00,'cash','credit','sell',479,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(319,7,71.28,'cash','credit','sell',480,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(320,7,0.00,'cash','credit','sell',480,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(321,7,71.28,'cash','credit','sell',481,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(322,7,0.00,'cash','credit','sell',481,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(323,7,69.30,'cash','credit','sell',482,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(324,7,0.00,'cash','credit','sell',482,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(325,7,69.30,'cash','credit','sell',483,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(326,7,0.00,'cash','credit','sell',483,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(327,7,71.28,'cash','credit','sell',484,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(328,7,0.00,'cash','credit','sell',484,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(329,7,71.28,'cash','credit','sell',485,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(330,7,0.00,'cash','credit','sell',485,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(331,7,69.30,'cash','credit','sell',486,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(332,7,0.00,'cash','credit','sell',486,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(333,7,69.30,'cash','credit','sell',487,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(334,7,0.00,'cash','credit','sell',487,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(335,7,71.28,'cash','credit','sell',488,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(336,7,0.00,'cash','credit','sell',488,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(337,7,71.28,'cash','credit','sell',489,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(338,7,0.00,'cash','credit','sell',489,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(339,7,69.30,'cash','credit','sell',490,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(340,7,0.00,'cash','credit','sell',490,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(341,7,71.28,'cash','credit','sell',491,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(342,7,0.00,'cash','credit','sell',491,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(343,7,71.28,'cash','credit','sell',492,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(344,7,0.00,'cash','credit','sell',492,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(345,7,69.30,'cash','credit','sell',493,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(346,7,0.00,'cash','credit','sell',493,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(347,7,69.30,'cash','credit','sell',494,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(348,7,0.00,'cash','credit','sell',494,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(349,7,69.30,'cash','credit','sell',495,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(350,7,0.00,'cash','credit','sell',495,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(351,7,71.28,'cash','credit','sell',496,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(352,7,0.00,'cash','credit','sell',496,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(353,7,71.28,'cash','credit','sell',497,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(354,7,0.00,'cash','credit','sell',497,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(355,7,69.30,'cash','credit','sell',498,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(356,7,0.00,'cash','credit','sell',498,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(357,7,69.30,'cash','credit','sell',499,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(358,7,0.00,'cash','credit','sell',499,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(359,7,140.58,'cash','credit','sell',500,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(360,7,0.00,'cash','credit','sell',500,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(361,7,83.66,'cash','credit','sell',501,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(362,7,0.00,'cash','credit','sell',501,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(363,7,81.68,'cash','credit','sell',502,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(364,7,0.00,'cash','credit','sell',502,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(365,7,83.66,'cash','credit','sell',503,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(366,7,0.00,'cash','credit','sell',503,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(367,7,78.41,'cash','credit','sell',504,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(368,7,0.00,'cash','credit','sell',504,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(369,7,0.00,'cash','credit','sell',505,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(370,7,0.00,'cash','credit','sell',505,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(371,7,69.30,'cash','credit','sell',506,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(372,7,0.00,'cash','credit','sell',506,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(373,7,71.28,'cash','credit','sell',507,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(374,7,0.00,'cash','credit','sell',507,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(375,7,71.28,'cash','credit','sell',508,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(376,7,0.00,'cash','credit','sell',508,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(377,7,69.30,'cash','credit','sell',509,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(378,7,0.00,'cash','credit','sell',509,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(379,7,81.68,'cash','credit','sell',510,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(380,7,0.00,'cash','credit','sell',510,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(381,7,81.68,'cash','credit','sell',511,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(382,7,0.00,'cash','credit','sell',511,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(383,7,217.53,'cash','credit','sell',512,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(384,7,0.00,'cash','credit','sell',512,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(385,7,217.53,'cash','credit','sell',513,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(386,7,0.00,'cash','credit','sell',513,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(387,7,217.53,'cash','credit','sell',514,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(388,7,0.00,'cash','credit','sell',514,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(389,7,158.63,'cash','credit','sell',515,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(390,7,0.00,'cash','credit','sell',515,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(391,7,227.93,'cash','credit','sell',516,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(392,7,0.00,'cash','credit','sell',516,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(393,7,227.93,'cash','credit','sell',517,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(394,7,0.00,'cash','credit','sell',517,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(395,7,81.68,'cash','credit','sell',518,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(396,7,0.00,'cash','credit','sell',518,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(397,7,217.53,'cash','credit','sell',519,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(398,7,0.00,'cash','credit','sell',519,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(399,7,215.55,'cash','credit','sell',520,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(400,7,0.00,'cash','credit','sell',520,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(401,7,179.66,'cash','credit','sell',521,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(402,7,0.00,'cash','credit','sell',521,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(403,7,138.60,'cash','credit','sell',522,'2018-05-14 05:39:01','2018-05-14 05:39:01'),(404,7,0.00,'cash','credit','sell',522,'2018-05-14 05:39:01','2018-05-14 05:39:01'),(405,7,206.28,'cash','credit','sell',523,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(406,7,0.00,'cash','credit','sell',523,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(407,7,239.28,'cash','credit','sell',524,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(408,7,0.00,'cash','credit','sell',524,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(409,7,69.30,'cash','credit','sell',525,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(410,7,0.00,'cash','credit','sell',525,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(411,7,69.30,'cash','credit','sell',526,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(412,7,0.00,'cash','credit','sell',526,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(413,7,78.41,'cash','credit','sell',527,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(414,7,0.00,'cash','credit','sell',527,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(415,7,206.28,'cash','credit','sell',528,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(416,7,0.00,'cash','credit','sell',528,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(417,7,0.00,'cash','credit','sell',529,'2018-05-14 05:47:22','2018-05-14 05:47:22'),(418,7,0.00,'cash','credit','sell',529,'2018-05-14 05:47:22','2018-05-14 05:47:22'),(419,7,100.00,'cash','credit','sell',530,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(420,7,0.00,'cash','credit','sell',530,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(421,7,20.00,'cash','credit','sell',531,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(422,7,0.00,'cash','credit','sell',531,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(423,7,69.30,'cash','credit','sell',536,'2018-05-15 08:34:21','2018-05-15 08:34:21'),(424,7,0.00,'cash','credit','sell',536,'2018-05-15 08:34:21','2018-05-15 08:34:21'),(425,7,1125.00,'cash','credit','sell',537,'2018-05-15 08:34:51','2018-05-15 08:34:51'),(426,7,0.00,'cash','credit','sell',537,'2018-05-15 08:34:51','2018-05-15 08:34:51'),(427,7,69.30,'cash','credit','sell',538,'2018-05-15 10:50:19','2018-05-15 10:50:19'),(428,7,0.00,'cash','credit','sell',538,'2018-05-15 10:50:19','2018-05-15 10:50:19'),(429,7,0.00,'cash','credit','sell',539,'2018-05-15 10:51:52','2018-05-15 10:51:52'),(430,7,0.00,'cash','credit','sell',539,'2018-05-15 10:51:52','2018-05-15 10:51:52'),(431,7,69.30,'cash','credit','sell',540,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(432,7,0.00,'cash','credit','sell',540,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(433,7,69.30,'cash','credit','sell',541,'2018-05-15 11:38:38','2018-05-15 11:38:38'),(434,7,0.00,'cash','credit','sell',541,'2018-05-15 11:38:38','2018-05-15 11:38:38'),(435,7,71.28,'cash','credit','sell',542,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(436,7,0.00,'cash','credit','sell',542,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(437,7,71.28,'cash','credit','sell',543,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(438,7,0.00,'cash','credit','sell',543,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(439,7,69.30,'cash','credit','sell',544,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(440,7,0.00,'cash','credit','sell',544,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(441,7,71.28,'cash','credit','sell',545,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(442,7,0.00,'cash','credit','sell',545,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(443,7,71.28,'cash','credit','sell',546,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(444,7,0.00,'cash','credit','sell',546,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(445,7,69.30,'cash','credit','sell',547,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(446,7,0.00,'cash','credit','sell',547,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(447,7,69.30,'cash','credit','sell',548,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(448,7,0.00,'cash','credit','sell',548,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(449,7,1869.21,'cash','credit','sell',549,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(450,7,0.00,'cash','credit','sell',549,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(451,7,1602.99,'cash','credit','sell',550,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(452,7,0.00,'cash','credit','sell',550,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(453,7,112.50,'cash','debit','refund',550,'2018-05-15 12:37:41','2018-05-15 12:37:41'),(454,7,81.68,'cash','credit','sell',551,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(455,7,0.00,'cash','credit','sell',551,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(456,7,216.68,'cash','credit','sell',552,'2018-05-16 06:19:26','2018-05-16 06:19:26'),(457,7,0.00,'cash','credit','sell',552,'2018-05-16 06:19:26','2018-05-16 06:19:26'),(458,7,71.28,'cash','credit','sell',553,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(459,7,0.00,'cash','credit','sell',553,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(460,7,69.30,'card','credit','sell',554,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(461,7,0.00,'cash','credit','sell',554,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(462,7,69.30,'card','credit','sell',555,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(463,7,0.00,'cash','credit','sell',555,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(464,7,81.68,'card','credit','sell',556,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(465,7,0.00,'cash','credit','sell',556,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(466,7,81.68,'card','credit','sell',557,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(467,7,0.00,'cash','credit','sell',557,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(468,7,217.53,'card','credit','sell',558,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(469,7,0.00,'cash','credit','sell',558,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(470,7,217.53,'card','credit','sell',559,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(471,7,0.00,'cash','credit','sell',559,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(472,7,81.68,'card','credit','sell',560,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(473,7,0.00,'cash','credit','sell',560,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(474,7,71.28,'cash','credit','sell',561,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(475,7,0.00,'cash','credit','sell',561,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(476,7,69.30,'cash','credit','sell',562,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(477,7,0.00,'cash','credit','sell',562,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(478,7,69.30,'cash','credit','sell',563,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(479,7,0.00,'cash','credit','sell',563,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(480,7,71.28,'card','credit','sell',564,'2018-05-16 07:48:03','2018-05-16 07:48:03'),(481,7,0.00,'cash','credit','sell',564,'2018-05-16 07:48:03','2018-05-16 07:48:03'),(482,7,69.30,'card','credit','sell',565,'2018-05-16 07:58:28','2018-05-16 07:58:28'),(483,7,0.00,'cash','credit','sell',565,'2018-05-16 07:58:28','2018-05-16 07:58:28'),(484,7,69.30,'cash','credit','sell',570,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(485,7,0.00,'cash','credit','sell',570,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(486,7,69.30,'cash','credit','sell',571,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(487,7,0.00,'cash','credit','sell',571,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(488,7,71.28,'cash','credit','sell',572,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(489,7,0.00,'cash','credit','sell',572,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(490,7,71.28,'cash','credit','sell',573,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(491,7,0.00,'cash','credit','sell',573,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(492,7,69.30,'cash','credit','sell',574,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(493,7,0.00,'cash','credit','sell',574,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(494,7,69.30,'cash','credit','sell',575,'2018-05-16 12:55:07','2018-05-16 12:55:07'),(495,7,0.00,'cash','credit','sell',575,'2018-05-16 12:55:07','2018-05-16 12:55:07'),(496,7,69.30,'cash','credit','sell',576,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(497,7,0.00,'cash','credit','sell',576,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(498,7,5314.37,'cash','credit','sell',577,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(499,7,0.00,'cash','credit','sell',577,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(500,7,71.28,'cash','credit','sell',578,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(501,7,0.00,'cash','credit','sell',578,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(502,7,69.30,'cash','credit','sell',579,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(503,7,0.00,'cash','credit','sell',579,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(504,7,69.30,'cash','credit','sell',580,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(505,7,0.00,'cash','credit','sell',580,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(506,7,69.30,'cash','credit','sell',598,'2018-05-19 07:30:47','2018-05-19 07:30:47'),(507,7,0.00,'cash','credit','sell',598,'2018-05-19 07:30:48','2018-05-19 07:30:48'),(508,7,69.30,'cash','credit','sell',599,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(509,7,0.00,'cash','credit','sell',599,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(510,7,69.30,'cash','credit','sell',600,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(511,7,0.00,'cash','credit','sell',600,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(512,7,69.30,'cash','credit','sell',614,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(513,7,0.00,'cash','credit','sell',614,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(514,7,346.50,'cash','credit','sell',615,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(515,7,0.00,'cash','credit','sell',615,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(516,7,5625.00,'cash','credit','sell',619,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(517,7,0.00,'cash','credit','sell',619,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(518,7,415.80,'cash','credit','sell',629,'2018-05-21 13:52:54','2018-05-21 13:52:54'),(519,7,0.00,'cash','credit','sell',629,'2018-05-21 13:52:54','2018-05-21 13:52:54'),(520,8,0.00,'cash','credit','initial',NULL,'2018-05-24 04:58:09','2018-05-24 04:58:09'),(521,7,0.00,'cash','debit','refund',629,'2018-05-24 07:03:03','2018-05-24 07:03:03'),(522,7,69.30,'cash','credit','sell',630,'2018-05-24 07:23:06','2018-05-24 07:23:06'),(523,7,0.00,'cash','credit','sell',630,'2018-05-24 07:23:06','2018-05-24 07:23:06'),(524,7,69.30,'cash','credit','sell',631,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(525,7,0.00,'cash','credit','sell',631,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(526,7,71.28,'cash','credit','sell',632,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(527,7,0.00,'cash','credit','sell',632,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(528,7,71.28,'cash','credit','sell',633,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(529,7,0.00,'cash','credit','sell',633,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(530,7,100.00,'cash','credit','sell',634,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(531,7,-30.70,'cash','credit','sell',634,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(532,7,207.90,'cash','credit','sell',635,'2018-05-25 10:50:55','2018-05-25 10:50:55'),(533,7,0.00,'cash','credit','sell',635,'2018-05-25 10:50:55','2018-05-25 10:50:55'),(534,7,69.30,'cash','credit','sell',636,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(535,7,0.00,'cash','credit','sell',636,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(536,7,87.30,'cash','credit','sell',638,'2018-05-30 12:16:41','2018-05-30 12:16:41'),(537,7,0.00,'cash','credit','sell',638,'2018-05-30 12:16:41','2018-05-30 12:16:41'),(538,7,98.28,'cash','credit','sell',645,'2018-05-30 14:01:16','2018-05-30 14:01:16'),(539,7,0.00,'cash','credit','sell',645,'2018-05-30 14:01:16','2018-05-30 14:01:16'),(540,7,95.58,'cash','credit','sell',646,'2018-05-30 14:02:13','2018-05-30 14:02:13'),(541,7,0.00,'cash','credit','sell',646,'2018-05-30 14:02:13','2018-05-30 14:02:13'),(542,7,93.60,'cash','credit','sell',648,'2018-05-30 14:03:52','2018-05-30 14:03:52'),(543,7,0.00,'cash','credit','sell',648,'2018-05-30 14:03:52','2018-05-30 14:03:52'),(544,7,98.28,'cash','credit','sell',650,'2018-05-31 05:04:10','2018-05-31 05:04:10'),(545,7,0.00,'cash','credit','sell',650,'2018-05-31 05:04:10','2018-05-31 05:04:10');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,'close','2018-05-01 10:54:17',20924.95,0,0,NULL,'2018-04-19 16:23:19','2018-05-01 05:24:17'),(2,1,1,'close','2018-05-02 13:43:18',1826.25,0,0,NULL,'2018-05-01 05:24:42','2018-05-02 08:13:18'),(3,1,1,'close','2018-05-02 14:02:48',296.16,0,0,NULL,'2018-05-02 08:13:29','2018-05-02 08:32:48'),(4,1,1,'close','2018-05-02 14:07:20',69.30,0,0,NULL,'2018-05-02 08:32:56','2018-05-02 08:37:20'),(5,1,1,'close','2018-05-02 16:06:47',61.80,1,0,NULL,'2018-05-02 08:37:29','2018-05-02 10:36:47'),(6,1,1,'close','2018-05-03 10:56:15',419.06,1,1,NULL,'2018-05-02 10:36:55','2018-05-03 05:26:15'),(7,1,1,'open',NULL,0.00,0,0,NULL,'2018-05-03 05:26:27','2018-05-03 05:26:27'),(8,1,11,'open',NULL,0.00,0,0,NULL,'2018-05-24 04:58:09','2018-05-24 04:58:09');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Men\'s',1,NULL,0,1,NULL,'2018-01-03 15:36:34','2018-01-03 15:36:34'),(2,'Women\'s',1,NULL,0,1,NULL,'2018-01-03 15:36:46','2018-01-03 15:36:46'),(3,'Accessories',1,NULL,0,1,NULL,'2018-01-03 15:37:03','2018-01-03 15:37:03'),(4,'Jeans',1,NULL,1,1,NULL,'2018-01-03 15:37:34','2018-01-03 15:37:34'),(5,'Shirts',1,NULL,1,1,NULL,'2018-01-03 15:38:18','2018-01-03 15:38:18'),(6,'Belts',1,NULL,3,1,NULL,'2018-01-03 15:38:41','2018-01-03 15:38:41'),(8,'Shoes',1,NULL,3,1,NULL,'2018-01-03 15:39:04','2018-01-03 15:39:04'),(10,'Sandal',1,NULL,3,1,NULL,'2018-01-03 15:39:23','2018-01-03 15:39:23'),(11,'Wallets',1,NULL,3,1,NULL,'2018-01-03 17:35:50','2018-01-03 17:35:50'),(12,'Electronics',1,NULL,0,1,NULL,'2018-01-05 23:54:34','2018-01-05 23:54:34'),(13,'Cell Phones',1,NULL,12,1,NULL,'2018-01-05 23:54:57','2018-01-05 23:54:57'),(14,'Computers',1,NULL,12,1,NULL,'2018-01-05 23:55:55','2018-01-05 23:55:55'),(15,'Sports',1,NULL,0,1,NULL,'2018-01-05 23:57:33','2018-01-05 23:57:33'),(16,'Athletic Clothing',1,NULL,15,1,NULL,'2018-01-05 23:58:40','2018-01-05 23:58:40'),(17,'Exercise & Fitness',1,NULL,15,1,NULL,'2018-01-05 23:59:19','2018-01-05 23:59:19'),(18,'Books',1,NULL,0,1,NULL,'2018-01-05 23:59:59','2018-01-05 23:59:59'),(19,'Autobiography',1,NULL,18,1,NULL,'2018-01-06 00:00:16','2018-01-06 00:00:16'),(20,'Children\'s books',1,NULL,18,1,NULL,'2018-01-06 00:00:58','2018-01-06 00:00:58'),(21,'Food & Grocery',1,NULL,0,1,NULL,'2018-01-06 00:01:35','2018-01-06 00:01:35'),(22,'Capsule',2,NULL,0,4,NULL,'2018-04-10 02:49:58','2018-04-10 02:50:54'),(23,'Bandages',2,NULL,0,4,NULL,'2018-04-10 02:50:48','2018-04-10 02:50:48'),(24,'Cream',2,NULL,0,4,NULL,'2018-04-10 02:51:23','2018-04-10 02:51:23'),(25,'Drops',2,NULL,0,4,NULL,'2018-04-10 02:51:31','2018-04-10 02:51:31'),(26,'Gel',2,NULL,0,4,NULL,'2018-04-10 02:51:57','2018-04-10 02:51:57'),(27,'Bottle',2,NULL,0,4,NULL,'2018-04-10 02:52:30','2018-04-10 02:52:30'),(28,'Mobile Phones',3,NULL,0,5,NULL,'2018-04-10 05:29:49','2018-04-10 05:29:49'),(29,'Tablets',3,NULL,0,5,NULL,'2018-04-10 05:30:02','2018-04-10 05:30:02'),(30,'Laptops',3,NULL,0,5,NULL,'2018-04-10 05:30:09','2018-04-10 05:30:09'),(31,'TVs',3,NULL,0,5,NULL,'2018-04-10 05:30:15','2018-04-10 05:30:15'),(32,'Cameras',3,NULL,0,5,NULL,'2018-04-10 05:30:29','2018-04-10 05:30:29'),(33,'Accessories',3,NULL,0,5,NULL,'2018-04-10 05:30:57','2018-04-10 05:30:57'),(34,'Car Services',4,NULL,0,6,NULL,'2018-04-10 06:55:33','2018-04-10 07:00:10'),(35,'Hair Styling',4,NULL,0,6,NULL,'2018-04-10 06:58:32','2018-04-10 06:59:18'),(36,'Plumbing',4,NULL,0,6,NULL,'2018-04-10 07:00:41','2018-04-10 07:00:41'),(37,'Bodycare',4,NULL,0,6,NULL,'2018-04-10 07:00:52','2018-04-10 07:00:52'),(38,'Spa',4,NULL,0,6,NULL,'2018-04-10 07:01:01','2018-04-10 07:01:01'),(39,'General',1,NULL,0,1,NULL,'2018-04-25 08:09:20','2018-04-25 08:09:20');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer','123456',NULL,'Phoenix','Arizona Arizona Arizona','USA USA USA','LinkingStreetLinkingStreetLinkingStreetLinkingStreetLinkingStreetLinkingStreet','(378) 400-1234',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:15:20','2018-05-16 12:52:02'),(2,1,'supplier','Alpha Clothings','Michael',NULL,'4590091535','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:29:38','2018-01-03 15:35:10'),(3,1,'supplier','Manhattan Clothing Ltd.','Philip',NULL,'54869310093','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,15,'days',1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-03 15:30:55','2018-01-03 15:44:06'),(4,1,'customer',NULL,'Harry',NULL,NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,'2018-05-03 10:25:13','2018-01-03 15:31:40','2018-05-03 10:25:13'),(5,1,'supplier','Digital Ocean','Mike McCubbin',NULL,'52965489001','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,30,'days',1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:23:22','2018-01-06 01:23:22'),(6,1,'supplier','Univer Suppliers','Jackson Hill','CON001','5459000655','Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,45,'days',1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-06 01:25:09','2018-05-31 06:26:43'),(7,2,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(8,2,'supplier','Jones Pharma','Micheal Larson','522500003',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:32:52','2018-04-10 04:32:52'),(9,2,'supplier','Axolotl Biologix','Phillip Jenner','4585220005',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',4,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 04:34:20','2018-04-10 04:34:20'),(10,3,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(11,3,'supplier','Digital Ocean','Micheal Krick','12500079',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',5,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:06:21','2018-04-10 06:06:21'),(12,3,'supplier','Neon Electronics','Samuel Williams','525800083',NULL,'Phoenix','Arizona','USA',NULL,'(378) 400-1234',NULL,NULL,30,'days',5,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:08:33','2018-04-10 06:08:33'),(13,4,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(14,1,'customer',NULL,'TEST','test','test','et','tet','etst','t','test','etst','etst',NULL,NULL,1,0,1,NULL,NULL,NULL,NULL,NULL,'2018-05-03 10:25:34','2018-05-03 10:25:34'),(15,1,'customer',NULL,'Dhruv Khatri','12345','Dhruv GST','Isanpur,Ahmedabad 382443','Gujarat','India','12 Manorama Park Soc','9016254309',NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:56:42','2018-05-24 07:22:38'),(16,1,'customer',NULL,'With tax number','1234','GSTIN 1234',NULL,NULL,NULL,NULL,'9437638555',NULL,NULL,NULL,NULL,1,0,NULL,'f1','f2','f3',NULL,NULL,'2018-05-21 11:13:43','2018-05-21 11:14:01'),(17,1,'customer',NULL,'qwqw',NULL,NULL,'Kantabanji',NULL,NULL,'test','9437638555',NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-22 05:01:52','2018-05-22 05:01:52');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (1,1,'test',10.00,1,'2018-04-20 10:50:43','2018-04-20 10:50:43');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
INSERT INTO `group_sub_taxes` VALUES (4,2),(4,3);
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `design` enum('classic','elegant') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer','#000000',NULL,NULL,1,1,'classic',NULL,NULL,NULL,'2018-04-03 18:05:32','2018-04-25 12:14:42'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer','#000000','',NULL,1,2,'classic',NULL,NULL,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer','#000000','',NULL,1,3,'classic',NULL,NULL,NULL,'2018-04-10 05:16:16','2018-04-10 05:16:16'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer','#000000','',NULL,1,4,'classic',NULL,NULL,NULL,'2018-04-10 06:50:43','2018-04-10 06:50:43'),(5,'Restarant',NULL,'Reference Number','quotation_no_prefix','Original Copy','Despatched Through :','Docket Number :',NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total','Amount Due','Total Paid',1,'Client id','GSTIN','Invoice Date',0,0,1,1,1,'Product / Service Name','Quantity','Unit Price','Amount','HSN','VN2iBuq3yxhL5XgGD36FkvtZHlQlBguSeJRt3e6g.png',1,0,1,1,1,1,1,1,1,0,1,1,1,0,1,1,'Bill to:','#000000',NULL,'{\"Restaurant\":{\"show_table\":\"1\",\"show_waiter\":\"1\",\"table_label\":\"Table:_edit\",\"waiter_label\":\"Waiter:_edit\"}}',0,1,'elegant','Credit Note','Ref. No.','Credit Amount','2018-04-24 08:20:57','2018-05-24 07:24:06'),(6,'res2',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer','#000000',NULL,'{\"Restaurant\":{\"show_table\":\"1\",\"show_waiter\":\"1\",\"table_label\":\"Table\",\"waiter_label\":\"Waiter\"}}',0,1,'classic',NULL,NULL,NULL,'2018-04-24 08:37:33','2018-04-24 08:37:33'),(7,'with design',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,1,'elegant',NULL,NULL,NULL,'2018-05-15 08:27:24','2018-05-15 08:27:24'),(8,'testing label',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,1,'classic',NULL,NULL,NULL,'2018-05-16 13:09:41','2018-05-16 13:09:41'),(9,'hsn',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,1,'classic',NULL,NULL,NULL,'2018-05-17 14:54:22','2018-05-17 14:54:22'),(10,'Credit note',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,1,'elegant','Credit Note22','Ref. No.22','Credit Amount22','2018-05-21 08:22:36','2018-05-21 08:22:58');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','AS',1,316,4,1,'2018-01-03 20:45:20','2018-05-31 05:04:09'),(2,2,'Default','blank','AP',1,3,4,1,'2018-04-10 02:42:40','2018-04-10 04:56:12'),(3,3,'Default','blank','AE',1,5,4,1,'2018-04-10 05:16:16','2018-04-10 06:24:16'),(4,4,'Default','blank','',1,8,4,1,'2018-04-10 06:50:43','2018-04-10 07:38:49');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2017_07_05_071953_create_currencies_table',1),(4,'2017_07_05_073658_create_business_table',1),(5,'2017_07_22_075923_add_business_id_users_table',1),(6,'2017_07_23_113209_create_brands_table',1),(7,'2017_07_26_083429_create_permission_tables',1),(8,'2017_07_26_110000_create_tax_rates_table',1),(9,'2017_07_26_122313_create_units_table',1),(10,'2017_07_27_075706_create_contacts_table',1),(11,'2017_08_04_071038_create_categories_table',1),(12,'2017_08_08_115903_create_products_table',1),(13,'2017_08_09_061616_create_variation_templates_table',1),(14,'2017_08_09_061638_create_variation_value_templates_table',1),(15,'2017_08_10_061146_create_product_variations_table',1),(16,'2017_08_10_061216_create_variations_table',1),(17,'2017_08_19_054827_create_transactions_table',1),(18,'2017_08_31_073533_create_purchase_lines_table',1),(19,'2017_10_15_064638_create_transaction_payments_table',1),(20,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(21,'2017_11_20_051930_create_table_group_sub_taxes',1),(22,'2017_11_20_063603_create_transaction_sell_lines',1),(23,'2017_11_21_064540_create_barcodes_table',1),(24,'2017_11_23_181237_create_invoice_schemes_table',1),(25,'2017_12_25_122822_create_business_locations_table',1),(26,'2017_12_25_160253_add_location_id_to_transactions_table',1),(27,'2017_12_25_163227_create_variation_location_details_table',1),(28,'2018_01_04_115627_create_sessions_table',1),(29,'2018_01_05_112817_create_invoice_layouts_table',1),(30,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(31,'2018_01_08_104124_create_expense_categories_table',1),(32,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(33,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(34,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(35,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(36,'2018_01_27_184322_create_printers_table',1),(37,'2018_01_30_181442_create_cash_registers_table',1),(38,'2018_01_31_125836_create_cash_register_transactions_table',1),(39,'2018_02_07_173326_modify_business_table',1),(40,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(41,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(42,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(43,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(44,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(45,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(46,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(47,'2018_02_13_183323_alter_decimal_fields_size',1),(48,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(49,'2018_02_15_161032_add_document_column_to_transactions_table',1),(50,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(51,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(52,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(53,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(54,'2018_02_21_105329_create_system_table',1),(55,'2018_02_23_100549_version_1_2',1),(56,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(57,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(58,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(59,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(60,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(61,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(62,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(63,'2018_03_06_210206_modify_product_barcode_types',1),(64,'2018_03_13_181541_add_expiry_type_to_business_table',1),(65,'2018_03_16_113446_product_expiry_setting_for_business',1),(66,'2018_03_19_113601_add_business_settings_options',1),(67,'2018_03_26_125334_add_pos_settings_to_business_table',1),(68,'2018_03_26_165350_create_customer_groups_table',1),(69,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(70,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(71,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(72,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(73,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(74,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(75,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(76,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(77,'2018_04_17_123122_add_lot_number_to_business',1),(78,'2018_04_17_160845_add_product_racks_table',1),(79,'2018_04_20_182015_create_res_tables_table',2),(80,'2018_04_24_105246_restaurant_fields_in_transaction_table',3),(81,'2018_04_24_114149_add_enabled_modules_business_table',4),(82,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',5),(86,'2018_04_27_132653_quotation_related_change',6),(87,'2018_05_02_111939_add_sell_return_to_transaction_payments',7),(88,'2018_05_02_104439_add_date_format_and_time_format_to_business',8),(89,'2018_05_14_114027_add_rows_positions_for_products',9),(90,'2018_05_14_125223_add_weight_to_products_table',10),(91,'2018_05_14_164754_add_opening_stock_permission',11),(92,'2018_05_15_134729_add_design_to_invoice_layouts',12),(94,'2018_05_16_183307_add_tax_fields_invoice_layout',13),(95,'2018_05_18_191956_add_sell_return_to_transaction_table',14),(96,'2018_05_21_131607_invoice_layout_fields_for_sell_return',15),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',16),(98,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',16),(101,'2018_05_25_180603_create_modifiers_related_table',17),(102,'2018_05_22_123527_create_reference_counts_table',18),(103,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',18),(104,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',18),(105,'2018_05_24_161026_add_location_id_column_to_business_location_table',18),(106,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',18),(107,'2018_05_30_190450_add_modifiers_field_to_transaction_sell_lines',18),(108,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',19),(109,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',20);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(2,2,'App\\User'),(1,3,'App\\User'),(3,4,'App\\User'),(5,5,'App\\User'),(7,6,'App\\User'),(9,7,'App\\User'),(1,8,'App\\User'),(2,9,'App\\User'),(2,11,'App\\User'),(9,12,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2018-04-19 13:21:35',NULL),(2,'direct_sell.access','web','2018-04-19 13:21:35',NULL),(3,'user.view','web','2018-04-19 13:22:12',NULL),(4,'user.create','web','2018-04-19 13:22:12',NULL),(5,'user.update','web','2018-04-19 13:22:12',NULL),(6,'user.delete','web','2018-04-19 13:22:12',NULL),(7,'supplier.view','web','2018-04-19 13:22:12',NULL),(8,'supplier.create','web','2018-04-19 13:22:12',NULL),(9,'supplier.update','web','2018-04-19 13:22:12',NULL),(10,'supplier.delete','web','2018-04-19 13:22:12',NULL),(11,'customer.view','web','2018-04-19 13:22:12',NULL),(12,'customer.create','web','2018-04-19 13:22:12',NULL),(13,'customer.update','web','2018-04-19 13:22:12',NULL),(14,'customer.delete','web','2018-04-19 13:22:12',NULL),(15,'product.view','web','2018-04-19 13:22:12',NULL),(16,'product.create','web','2018-04-19 13:22:12',NULL),(17,'product.update','web','2018-04-19 13:22:12',NULL),(18,'product.delete','web','2018-04-19 13:22:12',NULL),(19,'purchase.view','web','2018-04-19 13:22:12',NULL),(20,'purchase.create','web','2018-04-19 13:22:12',NULL),(21,'purchase.update','web','2018-04-19 13:22:12',NULL),(22,'purchase.delete','web','2018-04-19 13:22:12',NULL),(23,'sell.view','web','2018-04-19 13:22:12',NULL),(24,'sell.create','web','2018-04-19 13:22:12',NULL),(25,'sell.update','web','2018-04-19 13:22:12',NULL),(26,'sell.delete','web','2018-04-19 13:22:12',NULL),(27,'purchase_n_sell_report.view','web','2018-04-19 13:22:12',NULL),(28,'contacts_report.view','web','2018-04-19 13:22:12',NULL),(29,'stock_report.view','web','2018-04-19 13:22:12',NULL),(30,'tax_report.view','web','2018-04-19 13:22:12',NULL),(31,'trending_product_report.view','web','2018-04-19 13:22:12',NULL),(32,'register_report.view','web','2018-04-19 13:22:12',NULL),(33,'sales_representative.view','web','2018-04-19 13:22:12',NULL),(34,'expense_report.view','web','2018-04-19 13:22:12',NULL),(35,'business_settings.access','web','2018-04-19 13:22:12',NULL),(36,'barcode_settings.access','web','2018-04-19 13:22:12',NULL),(37,'invoice_settings.access','web','2018-04-19 13:22:12',NULL),(38,'brand.view','web','2018-04-19 13:22:12',NULL),(39,'brand.create','web','2018-04-19 13:22:12',NULL),(40,'brand.update','web','2018-04-19 13:22:12',NULL),(41,'brand.delete','web','2018-04-19 13:22:12',NULL),(42,'tax_rate.view','web','2018-04-19 13:22:12',NULL),(43,'tax_rate.create','web','2018-04-19 13:22:12',NULL),(44,'tax_rate.update','web','2018-04-19 13:22:12',NULL),(45,'tax_rate.delete','web','2018-04-19 13:22:12',NULL),(46,'unit.view','web','2018-04-19 13:22:12',NULL),(47,'unit.create','web','2018-04-19 13:22:12',NULL),(48,'unit.update','web','2018-04-19 13:22:12',NULL),(49,'unit.delete','web','2018-04-19 13:22:12',NULL),(50,'category.view','web','2018-04-19 13:22:12',NULL),(51,'category.create','web','2018-04-19 13:22:12',NULL),(52,'category.update','web','2018-04-19 13:22:12',NULL),(53,'category.delete','web','2018-04-19 13:22:12',NULL),(54,'expense.access','web','2018-04-19 13:22:12',NULL),(55,'access_all_locations','web','2018-04-19 13:22:12',NULL),(56,'dashboard.data','web','2018-04-19 13:22:12',NULL),(57,'location.1','web','2018-04-19 13:22:21',NULL),(58,'location.2','web','2018-04-19 13:22:23',NULL),(59,'location.3','web','2018-04-19 13:22:24',NULL),(60,'location.4','web','2018-04-19 13:22:25',NULL),(61,'location.5','web','2018-04-23 11:44:21','2018-04-23 11:44:21'),(62,'location.6','web','2018-04-25 08:02:24','2018-04-25 08:02:24'),(63,'location.7','web','2018-04-25 11:25:35','2018-04-25 11:25:35'),(64,'product.opening_stock','web','2018-05-14 11:20:56','2018-05-14 11:20:56'),(65,'location.8','web','2018-05-31 06:27:30','2018-05-31 06:27:30');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (1,1,1,193,'pos1',NULL,NULL,'2018-05-11 12:01:54','2018-05-14 11:40:29'),(2,1,5,193,'pos2',NULL,NULL,'2018-05-11 12:01:54','2018-05-14 11:40:29'),(3,1,6,193,'pos3',NULL,NULL,'2018-05-11 12:01:54','2018-05-14 11:40:29'),(4,1,7,193,'pos4',NULL,NULL,'2018-05-11 12:01:54','2018-05-14 11:40:29'),(5,1,1,295,'rack1_e','row1_e','pos1_e','2018-05-14 06:43:03','2018-05-14 07:15:09'),(6,1,5,295,'rack2_e','row2_e','pos2_e','2018-05-14 06:43:03','2018-05-14 07:15:09'),(7,1,6,295,'alrack_e','alrow_e','alpos_e','2018-05-14 06:43:03','2018-05-14 07:15:09'),(8,1,7,295,'el-rack_e','el-row_e','el-pos_e','2018-05-14 06:43:03','2018-05-14 07:15:09'),(9,1,1,95,'1','2','3','2018-05-14 07:09:40','2018-05-14 07:09:40'),(10,1,5,95,'4','5','6','2018-05-14 07:09:40','2018-05-14 07:09:40'),(11,1,6,95,'7','8','9','2018-05-14 07:09:40','2018-05-14 07:09:40'),(12,1,7,95,'10','11','12','2018-05-14 07:09:40','2018-05-14 07:09:40'),(13,1,1,296,'pc1','pc2','pc3','2018-05-14 07:26:46','2018-05-14 07:34:00'),(14,1,5,296,'l1','l2','l3','2018-05-14 07:26:46','2018-05-14 07:34:00'),(15,1,6,296,'a1','a2','a3','2018-05-14 07:26:46','2018-05-14 07:34:00'),(16,1,7,296,'e1','e2','e3','2018-05-14 07:26:46','2018-05-14 07:34:00'),(17,1,1,297,'R1','ROW1','POS1','2018-05-14 10:16:03','2018-05-14 10:16:03'),(18,1,5,297,'R2',NULL,NULL,'2018-05-14 10:16:03','2018-05-14 10:16:03'),(19,1,6,297,NULL,NULL,NULL,'2018-05-14 10:16:03','2018-05-14 10:16:03'),(20,1,7,297,NULL,NULL,NULL,'2018-05-14 10:16:03','2018-05-14 10:16:03'),(21,1,1,299,'Left 1','3','1','2018-05-14 10:18:53','2018-05-14 10:18:53'),(22,1,5,299,NULL,NULL,NULL,'2018-05-14 10:18:53','2018-05-14 10:18:53'),(23,1,6,299,NULL,NULL,NULL,'2018-05-14 10:18:53','2018-05-14 10:18:53'),(24,1,7,299,NULL,NULL,NULL,'2018-05-14 10:18:53','2018-05-14 10:18:53'),(37,1,1,309,'R1',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(38,1,5,309,'R2',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(39,1,6,309,'R3',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(40,1,7,309,'R4',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(41,1,1,310,'P1',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(42,1,5,310,'P2',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(43,1,6,310,'P3',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(44,1,7,310,'p4',NULL,NULL,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(45,1,1,1,NULL,NULL,NULL,'2018-05-14 13:40:03','2018-05-15 06:20:27'),(46,1,5,1,NULL,NULL,NULL,'2018-05-14 13:40:03','2018-05-15 06:20:27'),(47,1,6,1,NULL,NULL,NULL,'2018-05-14 13:40:03','2018-05-15 06:20:27'),(48,1,7,1,NULL,NULL,NULL,'2018-05-14 13:40:03','2018-05-15 06:20:27'),(49,1,1,12,NULL,NULL,NULL,'2018-05-15 06:23:14','2018-05-15 06:23:14'),(50,1,5,12,NULL,NULL,NULL,'2018-05-15 06:23:14','2018-05-15 06:23:14'),(51,1,6,12,NULL,NULL,NULL,'2018-05-15 06:23:14','2018-05-15 06:23:14'),(52,1,7,12,NULL,NULL,NULL,'2018-05-15 06:23:14','2018-05-15 06:23:14'),(53,1,1,311,NULL,NULL,NULL,'2018-05-16 10:39:23','2018-05-16 10:39:23'),(54,1,5,311,NULL,NULL,NULL,'2018-05-16 10:39:23','2018-05-16 10:39:23'),(55,1,6,311,NULL,NULL,NULL,'2018-05-16 10:39:23','2018-05-16 10:39:23'),(56,1,7,311,NULL,NULL,NULL,'2018-05-16 10:39:23','2018-05-16 10:39:23'),(57,1,1,315,NULL,NULL,NULL,'2018-05-21 12:16:40','2018-05-21 12:16:40'),(58,1,5,315,NULL,NULL,NULL,'2018-05-21 12:16:40','2018-05-21 12:16:40'),(59,1,6,315,NULL,NULL,NULL,'2018-05-21 12:16:40','2018-05-21 12:16:40'),(60,1,7,315,NULL,NULL,NULL,'2018-05-21 12:16:40','2018-05-21 12:16:40');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,'DUMMY',1,1,'2018-01-03 15:59:08','2018-01-03 15:59:08'),(2,'Waist Size',2,0,'2018-01-03 16:00:35','2018-01-05 23:44:12'),(3,'Size',3,0,'2018-01-03 17:21:52','2018-01-05 23:43:48'),(4,'Size',4,0,'2018-01-03 17:24:34','2018-01-05 23:49:36'),(8,'Size',8,0,'2018-01-03 17:40:10','2018-01-05 23:48:46'),(9,'Size',9,0,'2018-01-03 17:41:57','2018-01-05 23:50:01'),(10,'Size',10,0,'2018-01-03 17:43:02','2018-01-05 23:49:20'),(11,'DUMMY',11,1,'2018-01-03 17:44:35','2018-01-03 17:44:35'),(12,'DUMMY',12,1,'2018-01-03 17:45:50','2018-01-03 17:45:50'),(13,'Size',13,0,'2018-01-03 17:47:59','2018-01-05 23:44:48'),(14,'Color',14,0,'2018-01-06 00:12:19','2018-01-06 00:12:19'),(15,'Internal Memory',14,0,'2018-01-06 00:14:14','2018-01-06 00:14:14'),(16,'Color',15,0,'2018-01-06 00:19:51','2018-01-06 00:19:51'),(17,'Internal Memory',15,0,'2018-01-06 00:19:51','2018-01-06 00:19:51'),(18,'Color',16,0,'2018-01-06 00:24:48','2018-01-06 00:24:48'),(19,'Color',17,0,'2018-01-06 00:35:01','2018-01-06 00:35:01'),(20,'Storage',18,0,'2018-01-06 00:37:30','2018-01-06 00:37:30'),(21,'DUMMY',19,1,'2018-01-06 00:40:28','2018-01-06 00:40:28'),(22,'Color',20,0,'2018-01-06 00:43:00','2018-01-06 00:43:00'),(23,'DUMMY',21,1,'2018-01-06 00:46:35','2018-01-06 00:46:35'),(24,'DUMMY',22,1,'2018-01-06 00:55:09','2018-01-06 00:55:09'),(25,'DUMMY',23,1,'2018-01-06 00:56:27','2018-01-06 00:56:27'),(26,'DUMMY',24,1,'2018-01-06 01:01:22','2018-01-06 01:01:22'),(27,'DUMMY',25,1,'2018-01-06 01:02:23','2018-01-06 01:02:23'),(28,'DUMMY',26,1,'2018-01-06 01:05:51','2018-01-06 01:05:51'),(29,'DUMMY',27,1,'2018-01-06 01:13:16','2018-01-06 01:13:16'),(30,'DUMMY',28,1,'2018-01-06 01:15:47','2018-01-06 01:15:47'),(31,'DUMMY',29,1,'2018-01-06 01:16:53','2018-01-06 01:16:53'),(32,'DUMMY',30,1,'2018-01-06 01:18:59','2018-01-06 01:18:59'),(33,'DUMMY',31,1,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(34,'DUMMY',32,1,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(35,'DUMMY',33,1,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(36,'DUMMY',34,1,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(37,'DUMMY',35,1,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(38,'DUMMY',36,1,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(39,'DUMMY',37,1,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(40,'DUMMY',38,1,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(41,'DUMMY',39,1,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(42,'DUMMY',40,1,'2018-04-10 05:04:32','2018-04-10 05:04:32'),(43,'DUMMY',41,1,'2018-04-10 05:38:27','2018-04-10 05:38:27'),(44,'DUMMY',42,1,'2018-04-10 05:45:52','2018-04-10 05:45:52'),(45,'DUMMY',43,1,'2018-04-10 05:48:01','2018-04-10 05:48:01'),(46,'DUMMY',44,1,'2018-04-10 05:49:10','2018-04-10 05:49:10'),(47,'DUMMY',45,1,'2018-04-10 05:50:22','2018-04-10 05:50:22'),(48,'DUMMY',46,1,'2018-04-10 05:52:04','2018-04-10 05:52:04'),(49,'DUMMY',47,1,'2018-04-10 05:53:45','2018-04-10 05:53:45'),(50,'DUMMY',48,1,'2018-04-10 05:54:42','2018-04-10 05:54:42'),(51,'DUMMY',49,1,'2018-04-10 05:55:55','2018-04-10 05:55:55'),(52,'DUMMY',50,1,'2018-04-10 06:04:32','2018-04-10 06:04:32'),(53,'DUMMY',51,1,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(54,'DUMMY',52,1,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(55,'DUMMY',53,1,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(56,'DUMMY',54,1,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(57,'DUMMY',55,1,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(58,'DUMMY',56,1,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(59,'DUMMY',57,1,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(60,'DUMMY',58,1,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(61,'DUMMY',59,1,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(62,'DUMMY',60,1,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(63,'DUMMY',61,1,'2018-04-20 10:52:37','2018-04-20 10:52:37'),(64,'size',62,0,'2018-04-25 07:04:27','2018-04-25 07:04:27'),(73,'size',71,0,'2018-04-25 07:12:05','2018-04-25 07:12:05'),(82,'size',80,0,'2018-04-25 07:46:02','2018-04-25 07:46:02'),(83,'size',81,0,'2018-04-25 07:48:31','2018-04-25 07:48:31'),(84,'Talla',82,0,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(85,'Talla',83,0,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(86,'Talla',84,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(87,'Talla',85,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(88,'Talla',86,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(89,'Talla',87,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(90,'Talla',88,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(91,'Talla',89,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(92,'Talla',90,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(93,'Talla',91,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(94,'Talla',92,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(95,'Talla',93,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(96,'Talla',94,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(97,'Talla',95,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(98,'Talla',96,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(99,'Talla',97,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(100,'Talla',98,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(101,'Talla',99,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(102,'Talla',100,0,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(103,'Talla',101,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(104,'Talla',102,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(105,'Talla',103,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(106,'Talla',104,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(107,'Talla',105,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(108,'Talla',106,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(109,'Talla',107,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(110,'Talla',108,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(111,'Talla',109,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(112,'Talla',110,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(113,'Talla',111,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(114,'Talla',112,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(115,'Talla',113,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(116,'Talla',114,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(117,'Talla',115,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(118,'Talla',116,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(119,'Talla',117,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(120,'Talla',118,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(121,'Talla',119,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(122,'Talla',120,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(123,'Talla',121,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(124,'Talla',122,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(125,'Talla',123,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(126,'Talla',124,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(127,'Talla',125,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(128,'Talla',126,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(129,'Talla',127,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(130,'Talla',128,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(131,'Talla',129,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(132,'Talla',130,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(133,'Talla',131,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(134,'Talla',132,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(135,'Talla',133,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(136,'Talla',134,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(137,'Talla',135,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(138,'Talla',136,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(139,'Talla',137,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(140,'Talla',138,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(141,'Talla',139,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(142,'Talla',140,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(143,'Talla',141,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(144,'Talla',142,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(145,'Talla',143,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(146,'Talla',144,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(147,'Talla',145,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(148,'Talla',146,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(149,'Talla',147,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(150,'Talla',148,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(151,'Talla',149,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(152,'Talla',150,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(153,'Talla',151,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(154,'Talla',152,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(155,'Talla',153,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(156,'Talla',154,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(157,'Talla',155,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(158,'Talla',156,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(159,'Talla',157,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(160,'Talla',158,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(161,'Talla',159,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(162,'Talla',160,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(163,'Talla',161,0,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(164,'Talla',162,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(165,'Talla',163,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(166,'Talla',164,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(167,'Talla',165,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(168,'Talla',166,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(169,'Talla',167,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(170,'Talla',168,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(171,'Talla',169,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(172,'Talla',170,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(173,'Talla',171,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(174,'Talla',172,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(175,'Talla',173,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(176,'Talla',174,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(177,'Talla',175,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(178,'Talla',176,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(179,'Talla',177,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(180,'Talla',178,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(181,'Talla',179,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(182,'Talla',180,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(183,'Talla',181,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(184,'Talla',182,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(185,'Talla',183,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(186,'Talla',184,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(187,'Talla',185,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(188,'Talla',186,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(189,'Talla',187,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(190,'Talla',188,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(191,'Talla',189,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(192,'Talla',190,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(193,'Talla',191,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(194,'Talla',192,0,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(196,'Talla',194,0,'2018-04-25 08:22:19','2018-04-25 08:22:19'),(197,'DUMMY',195,1,'2018-04-25 08:42:06','2018-04-25 08:42:06'),(198,'Talla,Color',196,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(199,'Talla,Color',197,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(200,'Talla,Color',198,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(201,'Talla,Color',199,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(202,'Talla,Color',200,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(203,'Talla,Color',201,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(204,'Talla,Color',202,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(205,'Talla,Color',203,0,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(206,'Talla,Color',204,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(207,'Talla,Color',205,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(208,'Talla,Color',206,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(209,'Talla,Color',207,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(210,'Talla,Color',208,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(211,'Talla,Color',209,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(212,'Talla,Color',210,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(213,'Talla,Color',211,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(214,'Talla,Color',212,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(215,'Talla,Color',213,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(216,'Talla,Color',214,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(217,'Talla,Color',215,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(218,'Talla,Color',216,0,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(219,'Talla,Color',217,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(220,'Talla,Color',218,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(221,'Talla,Color',219,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(222,'Talla,Color',220,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(223,'Talla,Color',221,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(224,'Talla,Color',222,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(225,'Talla,Color',223,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(226,'Talla,Color',224,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(227,'Talla,Color',225,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(228,'Talla,Color',226,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(229,'Talla,Color',227,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(230,'Talla,Color',228,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(231,'Talla,Color',229,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(232,'Talla,Color',230,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(233,'Talla,Color',231,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(234,'Talla,Color',232,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(235,'Talla,Color',233,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(236,'Talla,Color',234,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(237,'Talla,Color',235,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(238,'Talla,Color',236,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(239,'Talla,Color',237,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(240,'Talla,Color',238,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(241,'Talla,Color',239,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(242,'Talla,Color',240,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(243,'Talla,Color',241,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(244,'Talla,Color',242,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(245,'Talla,Color',243,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(246,'Talla,Color',244,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(247,'Talla,Color',245,0,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(248,'Talla,Color',246,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(249,'Talla,Color',247,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(250,'Talla,Color',248,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(251,'Talla,Color',249,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(252,'Talla,Color',250,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(253,'Talla,Color',251,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(254,'Talla,Color',252,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(255,'Talla,Color',253,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(256,'Talla,Color',254,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(257,'Talla,Color',255,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(258,'Talla,Color',256,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(259,'Talla,Color',257,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(260,'Talla,Color',258,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(261,'Talla,Color',259,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(262,'Talla,Color',260,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(263,'Talla,Color',261,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(264,'Talla,Color',262,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(265,'Talla,Color',263,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(266,'Talla,Color',264,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(267,'Talla,Color',265,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(268,'Talla,Color',266,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(269,'Talla,Color',267,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(270,'Talla,Color',268,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(271,'Talla,Color',269,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(272,'Talla,Color',270,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(273,'Talla,Color',271,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(274,'Talla,Color',272,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(275,'Talla,Color',273,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(276,'Talla,Color',274,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(277,'Talla,Color',275,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(278,'Talla,Color',276,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(279,'Talla,Color',277,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(280,'Talla,Color',278,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(281,'Talla,Color',279,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(282,'Talla,Color',280,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(283,'Talla,Color',281,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(284,'Talla,Color',282,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(285,'Talla,Color',283,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(286,'Talla,Color',284,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(287,'Talla,Color',285,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(288,'Talla,Color',286,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(289,'Talla,Color',287,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(290,'Talla,Color',288,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(291,'Talla,Color',289,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(292,'Talla,Color',290,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(293,'Talla,Color',291,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(294,'Talla,Color',292,0,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(295,'DUMMY',293,1,'2018-04-30 13:33:44','2018-04-30 13:33:44'),(296,'DUMMY',294,1,'2018-05-10 13:19:08','2018-05-10 13:19:08'),(297,'DUMMY',295,1,'2018-05-14 06:43:03','2018-05-14 06:43:03'),(298,'DUMMY',296,1,'2018-05-14 07:26:46','2018-05-14 07:26:46'),(299,'DUMMY',297,1,'2018-05-14 10:16:03','2018-05-14 10:16:03'),(300,'DUMMY',298,1,'2018-05-14 10:17:00','2018-05-14 10:17:00'),(301,'DUMMY',299,1,'2018-05-14 10:18:53','2018-05-14 10:18:53'),(305,'DUMMY',309,1,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(306,'DUMMY',310,1,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(307,'DUMMY',311,1,'2018-05-16 10:39:23','2018-05-16 10:39:23'),(308,'DUMMY',312,1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(309,'DUMMY',313,1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(310,'DUMMY',314,1,'2018-05-16 10:47:31','2018-05-16 10:47:31'),(311,'sell return',315,0,'2018-05-21 12:16:40','2018-05-21 12:16:40');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit_id` int(10) unsigned NOT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=316 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Men\'s Reverse Fleece Crew',1,'modifier',1,1,1,5,1,'exclusive',1,5,'AS0001','C128',NULL,NULL,0,NULL,1,'2018-01-03 15:59:08','2018-01-06 00:21:33'),(2,'Levis Men\'s Slimmy Fit Jeans',1,'variable',1,1,1,4,1,'exclusive',1,10,'AS0002','C128',NULL,NULL,0,NULL,1,'2018-01-03 16:00:35','2018-01-06 00:21:16'),(3,'Men\'s Cozy Hoodie Sweater',1,'variable',1,2,1,5,1,'exclusive',1,10,'AS0003','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:21:52','2018-01-06 00:20:51'),(4,'Puma Brown Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,5,'AS0004','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:24:33','2018-01-03 17:24:33'),(8,'Nike Fashion Sneaker',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0008','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:40:10','2018-01-03 17:40:10'),(9,'PUMA Men\'s Black Sneaker',1,'variable',1,5,3,8,1,'exclusive',1,10,'AS0009','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:41:57','2018-01-03 17:41:57'),(10,'NIKE Men\'s Running Shoe',1,'variable',1,4,3,8,1,'exclusive',1,10,'AS0010','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:43:02','2018-01-03 17:43:02'),(11,'U.S. Polo Men\'s Leather Belt',1,'single',1,3,3,6,1,'exclusive',1,15,'AS0011','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:44:35','2018-01-03 17:44:35'),(12,'Unisex Brown Leather Wallet',1,'single',1,1,3,11,1,'exclusive',1,10,'AS0012','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:45:50','2018-01-06 00:21:49'),(13,'Men Full sleeve T Shirt',1,'variable',1,2,1,5,1,'exclusive',1,15,'AS0013','C128',NULL,NULL,0,NULL,1,'2018-01-03 17:47:59','2018-01-03 17:47:59'),(14,'Samsung Galaxy S8',1,'variable',1,7,12,13,1,'exclusive',1,100,'AS0014','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:12:19','2018-01-06 00:12:19'),(15,'Apple iPhone 8',1,'variable',1,8,12,13,1,'exclusive',1,100,'AS0015','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:19:51','2018-01-06 00:19:51'),(16,'Samsung Galaxy J7 Pro',1,'variable',1,7,12,13,NULL,'exclusive',1,100,'AS0016','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:24:48','2018-01-06 00:24:48'),(17,'Acer Aspire E 15',1,'variable',1,9,12,14,NULL,'exclusive',1,70,'AS0017','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:35:01','2018-01-06 00:35:01'),(18,'Apple MacBook Air',1,'variable',1,8,12,14,NULL,'exclusive',1,30,'AS0018','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:37:30','2018-01-06 00:37:30'),(19,'Cushion Crew Socks',1,'single',1,4,15,16,NULL,'exclusive',1,100,'AS0019','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:40:28','2018-01-06 00:41:01'),(20,'Sports Tights Pants',1,'variable',1,6,15,16,1,'exclusive',1,60,'AS0020','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:43:00','2018-01-06 00:43:00'),(21,'Pair Of Dumbbells',1,'single',1,10,15,17,NULL,'exclusive',1,45,'AS0021','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:46:35','2018-01-06 00:46:35'),(22,'Diary of a Wimpy Kid',1,'single',1,NULL,18,20,1,'exclusive',1,20,'AS0022','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:55:09','2018-01-06 00:55:09'),(23,'Sneezy the Snowman',1,'single',1,NULL,18,20,NULL,'exclusive',1,20,'AS0023','C128',NULL,NULL,0,NULL,1,'2018-01-06 00:56:27','2018-01-06 00:56:27'),(24,'Etched in Sand Autobiography',1,'single',1,NULL,18,19,1,'exclusive',1,30,'AS0024','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:01:22','2018-01-06 01:01:22'),(25,'Five Presidents',1,'single',1,NULL,18,19,NULL,'exclusive',1,30,'AS0025','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:02:22','2018-01-06 01:02:22'),(26,'Oreo Cookies',1,'single',2,11,21,NULL,NULL,'exclusive',1,500,'AS0026','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:05:51','2018-01-06 01:08:55'),(27,'Butter Cookies',1,'single',2,12,21,NULL,1,'exclusive',1,100,'AS0027','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:13:16','2018-01-06 01:13:16'),(28,'Barilla Pasta',1,'single',2,13,21,NULL,1,'exclusive',1,50,'AS0028','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:15:47','2018-01-06 01:15:47'),(29,'Thin Spaghetti',1,'single',2,13,21,NULL,NULL,'exclusive',1,100,'AS0029','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:16:53','2018-01-06 01:16:53'),(30,'Lipton Black Tea Bags',1,'single',2,14,21,NULL,1,'exclusive',1,50,'AS0030','C128',NULL,NULL,0,NULL,1,'2018-01-06 01:18:59','2018-01-06 01:18:59'),(31,'Dolocare 1g paracetol',2,'single',4,16,27,NULL,NULL,'exclusive',1,50,'AP0031','C128',24.00,'months',0,NULL,4,'2018-04-10 04:36:29','2018-04-10 04:36:29'),(32,'Lexin 500mg capsule',2,'single',4,16,22,NULL,NULL,'exclusive',1,30,'AP0032','C128',24.00,'months',0,NULL,4,'2018-04-10 04:37:52','2018-04-10 04:37:52'),(33,'Oflen-75',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0033','C128',36.00,'months',0,NULL,4,'2018-04-10 04:39:45','2018-04-10 04:39:45'),(34,'Cistiben Forte',2,'single',4,16,22,NULL,NULL,'exclusive',1,25,'AP0034','C128',12.00,'months',0,NULL,4,'2018-04-10 04:40:59','2018-04-10 04:40:59'),(35,'Disflatyl drop 30ml',2,'single',4,17,25,NULL,NULL,'exclusive',1,20,'AP0035','C128',12.00,'months',0,NULL,4,'2018-04-10 04:42:53','2018-04-10 04:42:53'),(36,'Mycoheal 40',2,'single',4,17,26,NULL,NULL,'exclusive',1,30,'AP0036','C128',6.00,'months',0,NULL,4,'2018-04-10 04:44:18','2018-04-10 04:44:18'),(37,'Laboxyl',2,'single',4,16,24,NULL,NULL,'exclusive',1,20,'AP0037','C128',12.00,'months',0,NULL,4,'2018-04-10 05:01:29','2018-04-10 05:01:29'),(38,'Fertilex plus men',2,'single',4,15,22,NULL,NULL,'exclusive',1,30,'AP0038','C128',12.00,'months',0,NULL,4,'2018-04-10 05:02:35','2018-04-10 05:02:35'),(39,'vitamin E AIWA',2,'single',4,15,22,NULL,NULL,'exclusive',1,20,'AP0039','C128',12.00,'months',0,NULL,4,'2018-04-10 05:03:26','2018-04-10 05:03:26'),(40,'Glycerol 4g',2,'single',4,16,22,NULL,NULL,'exclusive',1,20,'AP0040','C128',12.00,'months',0,NULL,4,'2018-04-10 05:04:32','2018-04-10 05:04:49'),(41,'HP 15-AY020TU',3,'single',5,23,30,NULL,NULL,'inclusive',1,10,'AE0041','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:38:27','2018-04-10 05:38:27'),(42,'HP Pavilion 15-AU624TX',3,'single',5,23,NULL,NULL,NULL,'exclusive',1,10,'AE0042','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:45:52','2018-04-10 06:21:21'),(43,'iPhone 6s plus',3,'single',5,20,28,NULL,NULL,'exclusive',1,20,'AE0043','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:48:01','2018-04-10 05:48:01'),(44,'Samsung J7 Pro',3,'single',5,18,28,NULL,NULL,'exclusive',1,20,'AE0044','C128',NULL,NULL,0,NULL,5,'2018-04-10 05:49:10','2018-04-10 05:49:10'),(45,'Samsung Galaxy S7 Edge',3,'single',5,18,28,NULL,NULL,'exclusive',1,20,'AE0045','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:50:21','2018-04-10 05:50:21'),(46,'LG G6 64 GB',3,'single',5,19,28,NULL,NULL,'exclusive',1,10,'AE0046','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:52:04','2018-04-10 05:52:04'),(47,'Panasonic TH-58D300DX',3,'single',5,22,31,NULL,NULL,'exclusive',1,20,'AE0047','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:53:45','2018-04-10 05:53:45'),(48,'Samsung 50MU6100',3,'single',5,18,NULL,NULL,NULL,'exclusive',1,7,'AE0048','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:54:42','2018-04-10 06:22:07'),(49,'LG 55E7T',3,'single',5,19,31,NULL,NULL,'exclusive',1,5,'AE0049','C128',NULL,NULL,1,NULL,5,'2018-04-10 05:55:55','2018-04-10 05:55:55'),(50,'SONY ILCE-6000L/B',3,'single',5,21,NULL,NULL,NULL,'exclusive',1,10,'AE0050','C128',NULL,NULL,1,NULL,5,'2018-04-10 06:04:32','2018-04-10 06:04:32'),(51,'Oil and filter change',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0051','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:04:57','2018-04-10 07:04:57'),(52,'Removal of wheels and brakes checked',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0052','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:05:55','2018-04-10 07:05:55'),(53,'Full body wash',4,'single',6,NULL,34,NULL,NULL,'exclusive',0,0,'AS0053','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:09:15','2018-04-10 07:09:15'),(54,'Hair Cut',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0054','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:24:16','2018-04-10 07:24:16'),(55,'Wash And Blow Dry',4,'single',6,NULL,35,NULL,NULL,'exclusive',0,0,'AS0055','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:26:18','2018-04-10 07:26:18'),(56,'Thai massage',4,'single',6,NULL,38,NULL,NULL,'exclusive',0,0,'AS0056','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:31:59','2018-04-10 07:31:59'),(57,'Toilet Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0057','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:33:01','2018-04-10 07:33:01'),(58,'Sewer Repair',4,'single',6,NULL,36,NULL,NULL,'exclusive',0,0,'AS0058','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:33:37','2018-04-10 07:33:37'),(59,'Refrigerator Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0059','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:36:45','2018-04-10 07:36:45'),(60,'AC Repair',4,'single',6,NULL,NULL,NULL,NULL,'exclusive',0,0,'AS0060','C128',NULL,NULL,0,NULL,6,'2018-04-10 07:37:08','2018-04-10 07:37:08'),(61,'my producs',1,'single',1,1,1,NULL,NULL,'exclusive',1,10,'AS0061','C128',NULL,NULL,0,NULL,1,'2018-04-20 10:52:36','2018-04-20 10:52:36'),(62,'Testing variation',1,'variable',1,30,NULL,NULL,NULL,'inclusive',1,0,'AS0062','C128',NULL,NULL,1,NULL,1,'2018-04-25 07:04:27','2018-04-25 07:04:27'),(71,'Testing variation',1,'variable',1,30,NULL,NULL,NULL,'inclusive',1,0,'AS0071','C128',NULL,NULL,1,NULL,1,'2018-04-25 07:12:05','2018-04-25 07:12:05'),(80,'Testing variation2',1,'variable',1,30,NULL,NULL,NULL,'inclusive',1,0,'AS0080','C128',NULL,NULL,1,NULL,1,'2018-04-25 07:46:02','2018-04-25 07:46:02'),(81,'Testing variation2',1,'variable',1,30,NULL,NULL,NULL,'inclusive',1,0,'AS0080','C128',NULL,NULL,1,NULL,1,'2018-04-25 07:48:31','2018-04-25 07:48:31'),(82,'154',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'000I5430','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(83,'154',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'000I5432','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(84,'154',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15434','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(85,'154',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15436','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(86,'155',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15530','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(87,'155',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15532','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(88,'155',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15534','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(89,'155',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'15536','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(90,'177',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'17732','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(91,'177',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'17734','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(92,'177',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'177336','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(93,'177',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'17738','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(94,'122',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'12232','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(95,'122',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'12234','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(96,'122',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'12236','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(97,'122',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'12238','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(98,'88',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'8832','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(99,'88',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'8834','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(100,'88',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'8836','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(101,'88',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'8838','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(102,'514',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51432','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(103,'514',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51434','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(104,'514',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51436','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(105,'514',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51438','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(106,'510',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51032','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(107,'510',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51034','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(108,'510',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51036','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(109,'510',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'51036','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(110,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'2392','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(111,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'2394','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(112,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'2396','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(113,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'2398','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(114,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'23910','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(115,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'239212','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(116,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'239214','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(117,'239',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'23916','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(118,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24002','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(119,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24004','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(120,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24006','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(121,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24008','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(122,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24010','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(123,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24012','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(124,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24014','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(125,'240',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'24016','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(126,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25502','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(127,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25504','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(128,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25506','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(129,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25508','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(130,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25510','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(131,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25512','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(132,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25514','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(133,'255',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'25516','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(134,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28502','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(135,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28504','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(136,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28506','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(137,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28508','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(138,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28510','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(139,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28512','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(140,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28514','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(141,'285',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'28516','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(142,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27102','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(143,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27104','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(144,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27106','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(145,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27108','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(146,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27110','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(147,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27112','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(148,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27114','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(149,'271',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27116','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(150,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34202','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(151,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34204','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(152,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34206','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(153,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34208','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(154,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34210','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(155,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34212','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(156,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34214','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(157,'342',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34216','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(158,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34502','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(159,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34504','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(160,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34506','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(161,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34508','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(162,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34510','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(163,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34512','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(164,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34514','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(165,'345',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'34516','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(166,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7332','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(167,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7334','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(168,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7336','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(169,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7338','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(170,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7432','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(171,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7434','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(172,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7436','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(173,'73',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'7438','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(174,'74',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'39834','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(175,'74',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'39836','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(176,'74',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'39838','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(177,'388',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'38834','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(178,'388',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'38836','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(179,'388',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'38838','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(180,'394',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'394','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(181,'500',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'50032','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(182,'500',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'50034','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(183,'500',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'50036','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(184,'500',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'50038','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(185,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27902','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(186,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27904','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(187,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27906','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(188,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27908','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(189,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27910','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(190,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27912','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(191,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27914','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(192,'279',1,'variable',7,31,39,NULL,NULL,'exclusive',1,2,'27916','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(194,'154',1,'variable',7,31,39,NULL,5,'exclusive',1,2,'000I5430-nik','C39',NULL,NULL,0,NULL,1,'2018-04-25 08:22:19','2018-04-25 08:22:19'),(195,'Single-nik',1,'single',1,30,NULL,NULL,NULL,'inclusive',1,0,'single-nik','C128',NULL,NULL,1,NULL,1,'2018-04-25 08:42:06','2018-04-25 08:42:06'),(196,'701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0196','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(197,'701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0197','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(198,'701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0198','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(199,'1701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0199','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(200,'1701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0200','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(201,'1701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0201','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(202,'2001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0202','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(203,'2001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0203','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(204,'2001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0204','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(205,'2401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0205','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(206,'3301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0206','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(207,'3301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0207','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(208,'3601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0208','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(209,'3601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0209','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(210,'3601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0210','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(211,'3601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0211','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(212,'4401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0212','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(213,'4401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0213','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(214,'4401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0214','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(215,'4401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0215','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(216,'4501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0216','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(217,'4501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0217','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(218,'4501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0218','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(219,'4501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0219','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(220,'4601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0220','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(221,'4601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0221','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(222,'4601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0222','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(223,'4601',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0223','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(224,'4701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0224','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(225,'4701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0225','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(226,'4701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0226','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(227,'5501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0227','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(228,'5501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0228','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(229,'5501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0229','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(230,'5501',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0230','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(231,'6301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0231','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(232,'6301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0232','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(233,'6301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0233','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(234,'6301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0234','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(235,'6301',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0235','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(236,'6701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0236','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(237,'6801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0237','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(238,'6801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0238','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(239,'6801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0239','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(240,'6801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0240','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(241,'7101',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0241','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(242,'7101',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0242','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(243,'7101',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0243','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(244,'7101',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0244','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(245,'7201',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0245','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(246,'7201',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0246','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(247,'7201',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0247','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(248,'7201',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0248','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(249,'7401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0249','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(250,'7401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0250','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(251,'7401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0251','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(252,'7701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0252','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(253,'7701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0253','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(254,'7701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0254','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(255,'7701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0255','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(256,'7801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0256','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(257,'7801',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0257','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(258,'7901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0258','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(259,'7901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0259','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(260,'7901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0260','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(261,'8118',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0261','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(262,'8118',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0262','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(263,'8118',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0263','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(264,'8118',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0264','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(265,'9001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0265','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(266,'9001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0266','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(267,'9001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0267','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(268,'9001',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0268','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(269,'9201',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0269','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(270,'9401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0270','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(271,'9401',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0271','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(272,'9701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0272','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(273,'9701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0273','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(274,'9701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0274','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(275,'9701',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0275','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(276,'9901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0276','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(277,'9901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0277','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(278,'9901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0278','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(279,'9901',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0279','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(280,'A072',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0280','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(281,'A072',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0281','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(282,'A072',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0282','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(283,'A072',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0283','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(284,'A122',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0284','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(285,'A122',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0285','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(286,'A122',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0286','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(287,'A182',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0287','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(288,'A182',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0288','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(289,'A182',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0289','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(290,'A252',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0290','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(291,'A252',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0291','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(292,'A252',1,'variable',7,33,39,NULL,NULL,'exclusive',1,2,'AS0292','C39',NULL,NULL,0,NULL,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(293,'Unknowown brands',1,'single',1,NULL,1,NULL,NULL,'exclusive',0,0,'AS0293','C128',NULL,NULL,0,NULL,1,'2018-04-30 13:33:42','2018-04-30 13:33:43'),(294,'openingstock',1,'single',1,1,1,4,NULL,'exclusive',1,1,'AS0294','C128',NULL,NULL,0,NULL,1,'2018-05-10 13:19:07','2018-05-10 13:19:07'),(295,'with details',1,'single',1,1,2,NULL,NULL,'exclusive',1,1,'with details','C128',NULL,NULL,0,NULL,1,'2018-05-14 06:43:03','2018-05-14 06:43:03'),(296,'weight',1,'single',1,2,3,8,NULL,'exclusive',0,0,'weight','C128',NULL,NULL,0,'10 KG edited',1,'2018-05-14 07:26:45','2018-05-14 07:29:00'),(297,'CSV import',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0297','C128',NULL,NULL,0,'10KG',1,'2018-05-14 10:16:03','2018-05-14 10:16:03'),(298,'CSV import',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0298','C128',NULL,NULL,0,'10KG',1,'2018-05-14 10:17:00','2018-05-14 10:17:00'),(299,'CSV import',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0299','C128',NULL,NULL,0,'10KG',1,'2018-05-14 10:18:53','2018-05-14 10:18:53'),(309,'import1',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,0,'AS0309','C128',NULL,NULL,1,'11 KG',1,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(310,'import2',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,0,'AS0310','C128',NULL,NULL,0,'110KG',1,'2018-05-14 10:44:51','2018-05-14 10:44:51'),(311,'pp inc tax',1,'single',1,1,1,5,NULL,'exclusive',1,1,'AS0311','C128',12.00,'months',0,NULL,1,'2018-05-16 10:39:22','2018-05-16 10:39:23'),(312,'with opening stock',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0312','C128',NULL,NULL,0,'',1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(313,'with opening stock',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0313','C128',NULL,NULL,0,'',1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(314,'with opening stock1',1,'single',1,NULL,NULL,NULL,NULL,'inclusive',1,1,'AS0314','C128',NULL,NULL,0,'',1,'2018-05-16 10:47:31','2018-05-16 10:47:31'),(315,'sell return',1,'variable',1,1,1,4,NULL,'exclusive',1,1,'sell return','C128',12.00,'months',0,NULL,1,'2018-05-21 12:16:39','2018-05-21 12:16:39');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `pp_without_discount` decimal(20,2) NOT NULL DEFAULT '0.00' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(20,2) DEFAULT NULL,
  `purchase_price_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=408 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,100,70.00,0.00,70.00,77.00,7.00,1,83.00,3.00,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-05-31 06:25:47'),(2,1,2,3,150,70.00,0.00,70.00,77.00,7.00,1,119.00,0.00,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-05-25 10:50:55'),(3,1,2,4,150,70.00,0.00,70.00,77.00,7.00,1,117.00,0.00,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-05-30 12:16:41'),(4,1,2,5,150,72.00,0.00,72.00,79.20,7.20,1,118.00,0.00,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-05-31 05:04:10'),(5,1,2,6,100,72.00,0.00,72.00,79.20,7.20,1,66.00,0.00,NULL,NULL,NULL,'2018-01-06 01:27:11','2018-05-30 14:02:13'),(6,2,14,47,100,700.00,0.00,700.00,770.00,70.00,1,0.00,0.00,NULL,NULL,NULL,'2018-01-06 01:28:10','2018-04-19 13:22:25'),(7,3,28,71,500,10.00,0.00,10.00,11.00,1.00,1,52.00,0.00,NULL,NULL,NULL,'2018-01-06 01:32:22','2018-05-17 11:19:01'),(8,4,21,64,200,10.00,0.00,10.00,10.00,0.00,NULL,60.00,0.00,NULL,NULL,NULL,'2018-01-06 01:33:12','2018-04-19 13:22:26'),(9,5,27,70,500,20.00,0.00,20.00,22.00,2.00,1,30.00,0.00,NULL,NULL,NULL,'2018-01-06 01:35:26','2018-04-19 13:22:25'),(10,11,34,77,50,6.00,0.00,6.00,6.00,0.00,NULL,10.00,0.00,'2018-04-10','2019-04-19',NULL,'2018-04-10 04:48:16','2018-04-19 13:22:27'),(11,12,32,75,100,12.00,0.00,12.00,12.00,0.00,NULL,7.00,0.00,'2018-04-12','2018-10-19',NULL,'2018-04-10 04:49:40','2018-04-19 13:22:27'),(12,13,36,79,150,9.00,0.00,9.00,9.00,0.00,NULL,0.00,0.00,'2018-03-30','2019-04-19',NULL,'2018-04-10 04:50:41','2018-04-19 13:22:25'),(13,14,33,76,180,12.00,0.00,12.00,12.00,0.00,NULL,27.00,0.00,'2018-04-10','2018-04-17',NULL,'2018-04-10 04:51:38','2018-04-19 13:22:27'),(14,18,46,89,30,321.00,0.00,321.00,321.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-10 06:09:54','2018-04-19 13:22:25'),(15,19,41,84,40,500.00,0.00,500.00,500.00,0.00,NULL,26.00,0.00,NULL,NULL,NULL,'2018-04-10 06:10:51','2018-04-19 13:22:28'),(16,20,45,88,45,300.00,0.00,300.00,300.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-10 06:11:45','2018-04-19 13:22:25'),(17,21,44,87,100,195.00,0.00,195.00,195.00,0.00,NULL,20.00,0.00,NULL,NULL,NULL,'2018-04-10 06:12:34','2018-04-19 13:22:28'),(18,22,43,86,30,400.00,0.00,400.00,400.00,0.00,NULL,5.00,0.00,NULL,NULL,NULL,'2018-04-10 06:13:12','2018-04-19 13:22:27'),(19,27,42,85,50,520.00,0.00,520.00,520.00,0.00,NULL,20.00,0.00,NULL,NULL,NULL,'2018-04-10 06:23:36','2018-04-19 13:22:28'),(20,37,61,104,10,100.00,0.00,100.00,100.00,0.00,NULL,5.00,0.00,NULL,NULL,NULL,'2018-04-20 10:52:47','2018-04-20 10:53:18'),(21,70,71,132,2,0.00,0.00,100.00,100.00,0.00,NULL,2.00,0.00,NULL,NULL,NULL,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(22,71,71,133,4,0.00,0.00,120.00,120.00,0.00,NULL,2.00,0.00,NULL,NULL,NULL,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(23,72,71,134,6,0.00,0.00,130.00,130.00,0.00,NULL,2.00,0.00,NULL,NULL,NULL,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(25,78,80,159,2,0.00,0.00,100.00,100.00,0.00,NULL,2.00,0.00,NULL,NULL,NULL,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(26,78,80,160,4,0.00,0.00,120.00,120.00,0.00,NULL,4.00,0.00,NULL,NULL,NULL,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(27,78,80,161,6,0.00,0.00,130.00,130.00,0.00,NULL,3.00,0.00,NULL,NULL,NULL,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(28,79,81,162,10,0.00,0.00,100.00,100.00,0.00,NULL,3.00,0.00,NULL,NULL,NULL,'2018-04-25 07:48:31','2018-05-17 11:19:01'),(29,79,81,163,20,0.00,0.00,120.00,120.00,0.00,NULL,7.00,0.00,NULL,NULL,NULL,'2018-04-25 07:48:31','2018-05-17 11:19:01'),(30,79,81,164,30,0.00,0.00,130.00,130.00,0.00,NULL,16.00,0.00,NULL,NULL,NULL,'2018-04-25 07:48:31','2018-05-17 11:19:01'),(31,80,82,165,100,0.00,0.00,28500.00,33915.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(32,81,83,166,100,0.00,0.00,28500.00,33915.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(33,82,84,167,100,0.00,0.00,28500.00,33915.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(34,83,85,168,100,0.00,0.00,28500.00,33915.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(35,84,86,169,100,0.00,0.00,29500.00,35105.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(36,85,87,170,100,0.00,0.00,29500.00,35105.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(37,86,88,171,100,0.00,0.00,29500.00,35105.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(38,87,89,172,100,0.00,0.00,29500.00,35105.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(39,88,90,173,100,0.00,0.00,36000.00,42840.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(40,89,91,174,100,0.00,0.00,36000.00,42840.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(41,90,92,175,100,0.00,0.00,36000.00,42840.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(42,91,93,176,100,0.00,0.00,36000.00,42840.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(43,92,94,177,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(44,93,95,178,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(45,94,96,179,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(46,95,97,180,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(47,96,98,181,100,0.00,0.00,40000.00,47600.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(48,97,99,182,100,0.00,0.00,40000.00,47600.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(49,98,100,183,100,0.00,0.00,40000.00,47600.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(50,99,101,184,100,0.00,0.00,40000.00,47600.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(51,100,102,185,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(52,101,103,186,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(53,102,104,187,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(54,103,105,188,100,0.00,0.00,37000.00,44030.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(55,104,106,189,100,0.00,0.00,39000.00,46410.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(56,105,107,190,100,0.00,0.00,39000.00,46410.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(57,106,108,191,100,0.00,0.00,39000.00,46410.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(58,107,109,192,100,0.00,0.00,39000.00,46410.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(59,108,110,193,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(60,109,111,194,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(61,110,112,195,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(62,111,113,196,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(63,112,114,197,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(64,113,115,198,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(65,114,116,199,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(66,115,117,200,100,0.00,0.00,21000.00,24990.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(67,116,118,201,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(68,117,119,202,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(69,118,120,203,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(70,119,121,204,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(71,120,122,205,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(72,121,123,206,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(73,122,124,207,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(74,123,125,208,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(75,124,126,209,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(76,125,127,210,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(77,126,128,211,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(78,127,129,212,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(79,128,130,213,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(80,129,131,214,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(81,130,132,215,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(82,131,133,216,100,0.00,0.00,25500.00,30345.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(83,132,134,217,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(84,133,135,218,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(85,134,136,219,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(86,135,137,220,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(87,136,138,221,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(88,137,139,222,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(89,138,140,223,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(90,139,141,224,100,0.00,0.00,24000.00,28560.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(91,140,142,225,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(92,141,143,226,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(93,142,144,227,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(94,143,145,228,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(95,144,146,229,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(96,145,147,230,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(97,146,148,231,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(98,147,149,232,100,0.00,0.00,19000.00,22610.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(99,148,150,233,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(100,149,151,234,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(101,150,152,235,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(102,151,153,236,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(103,152,154,237,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(104,153,155,238,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(105,154,156,239,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(106,155,157,240,100,0.00,0.00,10500.00,12495.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(107,156,158,241,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(108,157,159,242,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(109,158,160,243,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(110,159,161,244,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(111,160,162,245,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(112,161,163,246,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(113,162,164,247,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(114,163,165,248,100,0.00,0.00,9500.00,11305.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(115,164,166,249,100,0.00,0.00,35000.00,41650.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(116,165,167,250,100,0.00,0.00,35000.00,41650.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(117,166,168,251,100,0.00,0.00,35000.00,41650.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(118,167,169,252,100,0.00,0.00,35000.00,41650.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(119,168,170,253,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(120,169,171,254,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(121,170,172,255,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(122,171,173,256,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(123,172,174,257,100,0.00,0.00,11000.00,13090.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(124,173,175,258,100,0.00,0.00,11000.00,13090.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(125,174,176,259,100,0.00,0.00,11000.00,13090.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(126,175,177,260,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(127,176,178,261,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(128,177,179,262,100,0.00,0.00,26000.00,30940.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(129,178,180,263,100,0.00,0.00,8000.00,9520.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(130,179,181,264,100,0.00,0.00,29964.00,35657.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(131,180,182,265,100,0.00,0.00,29964.00,35657.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(132,181,183,266,100,0.00,0.00,29964.00,35657.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(133,182,184,267,100,0.00,0.00,29964.00,35657.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(134,183,185,268,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(135,184,186,269,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(136,185,187,270,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(137,186,188,271,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(138,187,189,272,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(139,188,190,273,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(140,189,191,274,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(141,190,192,275,100,0.00,0.00,20000.00,23800.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(143,192,194,277,100,0.00,0.00,28500.00,33915.00,5415.00,5,0.00,0.00,NULL,NULL,NULL,'2018-04-25 08:22:19','2018-04-25 08:22:19'),(144,193,195,278,10,0.00,0.00,100.00,100.00,0.00,NULL,10.00,0.00,NULL,NULL,NULL,'2018-04-25 08:42:06','2018-05-02 08:39:07'),(145,195,196,279,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(146,195,196,280,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(147,196,197,281,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(148,196,197,282,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(149,197,198,283,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(150,197,198,284,100,0.00,0.00,14928.00,14928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(151,198,199,285,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(152,198,199,286,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(153,199,200,287,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(154,199,200,288,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(155,200,201,289,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(156,200,201,290,100,0.00,0.00,11357.00,11357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(157,201,202,291,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(158,201,202,292,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(159,202,203,293,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(160,202,203,294,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(161,203,204,295,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(162,203,204,296,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(163,204,205,297,100,0.00,0.00,8928.00,8928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(164,204,205,298,100,0.00,0.00,8928.00,8928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(165,205,206,299,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(166,205,206,300,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(167,206,207,301,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(168,206,207,302,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(169,207,208,303,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(170,207,208,304,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(171,208,209,305,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(172,208,209,306,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(173,209,210,307,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(174,209,210,308,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(175,210,211,309,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(176,210,211,310,100,0.00,0.00,14142.00,14142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(177,211,212,311,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(178,211,212,312,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(179,212,213,313,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(180,212,213,314,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(181,213,214,315,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(182,213,214,316,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(183,214,215,317,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(184,214,215,318,100,0.00,0.00,12642.00,12642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(185,215,216,319,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(186,215,216,320,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(187,216,217,321,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(188,216,217,322,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(189,217,218,323,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(190,217,218,324,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(191,218,219,325,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(192,218,219,326,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(193,219,220,327,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(194,219,220,328,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(195,220,221,329,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(196,220,221,330,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(197,221,222,331,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(198,221,222,332,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(199,222,223,333,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(200,222,223,334,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(201,223,224,335,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(202,223,224,336,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(203,224,225,337,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(204,224,225,338,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(205,225,226,339,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(206,225,226,340,100,0.00,0.00,10357.00,10357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(207,226,227,341,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(208,226,227,342,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(209,227,228,343,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(210,227,228,344,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(211,228,229,345,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(212,228,229,346,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(213,229,230,347,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(214,229,230,348,100,0.00,0.00,17550.00,17550.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(215,230,231,349,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(216,230,231,350,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(217,231,232,351,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(218,231,232,352,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(219,232,233,353,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(220,232,233,354,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(221,233,234,355,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(222,233,234,356,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(223,234,235,357,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(224,234,235,358,100,0.00,0.00,5051.00,5051.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(225,235,236,359,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(226,235,236,360,100,0.00,0.00,12785.00,12785.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(227,236,237,361,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(228,236,237,362,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(229,237,238,363,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(230,237,238,364,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(231,238,239,365,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(232,238,239,366,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(233,239,240,367,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(234,239,240,368,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(235,240,241,369,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(236,240,241,370,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(237,241,242,371,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(238,241,242,372,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(239,242,243,373,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(240,242,243,374,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(241,243,244,375,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(242,243,244,376,100,0.00,0.00,12071.00,12071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(243,244,245,377,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(244,244,245,378,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(245,245,246,379,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(246,245,246,380,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(247,246,247,381,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(248,246,247,382,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(249,247,248,383,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(250,247,248,384,100,0.00,0.00,11071.00,11071.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(251,248,249,385,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(252,248,249,386,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(253,249,250,387,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(254,249,250,388,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(255,250,251,389,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(256,250,251,390,100,0.00,0.00,11714.00,11714.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(257,251,252,391,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(258,251,252,392,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(259,252,253,393,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(260,252,253,394,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(261,253,254,395,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(262,253,254,396,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(263,254,255,397,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(264,254,255,398,100,0.00,0.00,15642.00,15642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(265,255,256,399,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(266,255,256,400,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(267,256,257,401,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(268,256,257,402,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(269,257,258,403,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(270,257,258,404,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(271,258,259,405,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(272,258,259,406,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(273,259,260,407,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(274,259,260,408,100,0.00,0.00,14642.00,14642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(275,260,261,409,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(276,260,261,410,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(277,261,262,411,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(278,261,262,412,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(279,262,263,413,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(280,262,263,414,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(281,263,264,415,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(282,263,264,416,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(283,264,265,417,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(284,264,265,418,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(285,265,266,419,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(286,265,266,420,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(287,266,267,421,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(288,266,267,422,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(289,267,268,423,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(290,267,268,424,100,0.00,0.00,4642.00,4642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(291,268,269,425,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(292,268,269,426,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(293,269,270,427,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(294,269,270,428,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(295,270,271,429,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(296,270,271,430,100,0.00,0.00,9928.00,9928.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(297,271,272,431,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(298,271,272,432,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(299,272,273,433,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(300,272,273,434,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(301,273,274,435,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(302,273,274,436,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(303,274,275,437,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(304,274,275,438,100,0.00,0.00,10642.00,10642.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(305,275,276,439,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(306,275,276,440,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(307,276,277,441,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(308,276,277,442,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(309,277,278,443,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(310,277,278,444,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(311,278,279,445,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(312,278,279,446,100,0.00,0.00,20357.00,20357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(313,279,280,447,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(314,279,280,448,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(315,280,281,449,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(316,280,281,450,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(317,281,282,451,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(318,281,282,452,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(319,282,283,453,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(320,282,283,454,100,0.00,0.00,16142.00,16142.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(321,283,284,455,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(322,283,284,456,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(323,284,285,457,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(324,284,285,458,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(325,285,286,459,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(326,285,286,460,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(327,286,287,461,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(328,286,287,462,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(329,287,288,463,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(330,287,288,464,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(331,288,289,465,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(332,288,289,466,100,0.00,0.00,20214.00,20214.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(333,289,290,467,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(334,289,290,468,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(335,290,291,469,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(336,290,291,470,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(337,291,292,471,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(338,291,292,472,100,0.00,0.00,15357.00,15357.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(339,365,2,4,1,0.00,0.00,77.00,77.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(340,434,294,474,10,0.00,0.00,100.00,100.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-10 13:55:23','2018-05-10 13:55:23'),(341,434,294,474,1,0.00,0.00,100.00,100.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-10 13:55:23','2018-05-10 13:55:23'),(344,534,1,1,10,0.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-14 13:45:05','2018-05-14 13:45:05'),(345,534,1,1,10,100.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-15 06:04:21','2018-05-15 06:04:21'),(346,535,12,41,10,100.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,NULL,'L2','2018-05-15 06:22:58','2018-05-15 06:55:45'),(347,535,12,41,10,100.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,'2020-01-11','L2','2018-05-15 06:24:34','2018-05-15 06:55:45'),(348,535,12,41,10,100.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,'2018-11-25',NULL,'2018-05-15 06:25:55','2018-05-15 06:55:45'),(349,535,12,41,10,0.00,0.00,100.00,110.00,10.00,1,0.00,0.00,NULL,'2018-05-17',NULL,'2018-05-15 06:51:12','2018-05-16 10:07:29'),(350,566,311,485,10,100.00,0.00,100.00,100.00,0.00,NULL,0.00,0.00,NULL,'2018-05-17','lot number','2018-05-16 10:39:43','2018-05-16 10:39:43'),(351,568,313,487,10,1200.00,0.00,1200.00,1200.00,0.00,NULL,1.00,0.00,NULL,NULL,NULL,'2018-05-16 10:44:09','2018-05-17 11:19:01'),(352,567,312,486,10,1200.00,0.00,1200.00,1200.00,0.00,NULL,1.00,0.00,NULL,NULL,NULL,'2018-05-16 10:44:09','2018-05-17 11:19:01'),(353,569,314,488,10,1200.00,0.00,1200.00,1200.00,0.00,NULL,1.00,0.00,NULL,NULL,NULL,'2018-05-16 10:47:31','2018-05-17 11:19:01'),(354,569,314,488,10,100.00,0.00,100.00,100.00,0.00,NULL,0.00,0.00,NULL,NULL,'lot','2018-05-16 10:53:09','2018-05-16 10:53:09'),(355,582,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:28:04','2018-05-18 12:28:04'),(356,583,1,1,1,130.00,0.00,130.00,143.00,13.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:29:24','2018-05-18 12:29:24'),(357,584,2,2,4,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:29:54','2018-05-18 12:29:54'),(358,585,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:35:12','2018-05-18 12:35:12'),(359,586,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:41:13','2018-05-18 12:41:13'),(360,587,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:49:14','2018-05-18 12:49:14'),(361,588,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:49:25','2018-05-18 12:49:25'),(362,589,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:50:47','2018-05-18 12:50:47'),(363,590,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:53:09','2018-05-18 12:53:09'),(364,591,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:53:42','2018-05-18 12:53:42'),(365,592,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 12:54:54','2018-05-18 12:54:54'),(366,593,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 13:19:32','2018-05-18 13:19:32'),(367,594,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 13:19:49','2018-05-18 13:19:49'),(368,595,81,163,1,150.00,0.00,150.00,150.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-18 13:27:07','2018-05-18 13:27:07'),(369,596,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 13:52:52','2018-05-18 13:52:52'),(370,597,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-18 14:16:19','2018-05-18 14:16:19'),(371,601,81,163,3,150.00,0.00,150.00,150.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 06:02:20','2018-05-21 06:02:20'),(372,602,2,2,2,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 06:10:11','2018-05-21 06:10:11'),(373,603,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:07:04','2018-05-21 07:07:04'),(374,604,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:08:02','2018-05-21 07:08:02'),(375,605,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:09:04','2018-05-21 07:09:04'),(376,606,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:12:00','2018-05-21 07:12:00'),(377,607,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:12:20','2018-05-21 07:12:20'),(378,608,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:17:21','2018-05-21 07:17:21'),(379,609,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:20:21','2018-05-21 07:20:21'),(380,610,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:42:59','2018-05-21 07:42:59'),(381,610,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:42:59','2018-05-21 07:42:59'),(382,611,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:43:33','2018-05-21 07:43:33'),(383,611,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 07:43:33','2018-05-21 07:43:33'),(384,612,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 08:27:42','2018-05-21 08:27:42'),(385,612,28,71,1,12.50,0.00,12.50,13.75,1.25,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 08:27:42','2018-05-21 08:27:42'),(386,613,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 08:29:16','2018-05-21 08:29:16'),(387,616,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-21 11:27:48','2018-05-21 11:27:48'),(388,617,315,489,100,100.00,0.00,100.00,100.00,0.00,NULL,90.00,10.00,NULL,'2018-05-22',NULL,'2018-05-21 12:17:05','2018-05-21 12:20:58'),(389,618,315,489,50,100.00,0.00,100.00,100.00,0.00,NULL,0.00,40.00,'1970-01-01','1970-01-01',NULL,'2018-05-21 12:17:55','2018-05-22 06:30:43'),(390,620,315,489,40,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 12:19:14','2018-05-21 12:19:14'),(391,622,315,489,40,0.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 12:19:53','2018-05-21 12:19:53'),(392,624,315,489,1,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 13:07:05','2018-05-21 13:07:05'),(393,625,315,489,1,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 13:08:10','2018-05-21 13:08:10'),(394,626,315,489,1,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 13:09:52','2018-05-21 13:09:52'),(395,627,315,489,1,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 13:14:11','2018-05-21 13:14:11'),(396,628,315,489,5,125.00,0.00,125.00,125.00,0.00,NULL,0.00,0.00,NULL,NULL,NULL,'2018-05-21 13:29:31','2018-05-21 13:29:31'),(397,637,1,1,-1,130.00,0.00,130.00,143.00,13.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-29 15:12:36','2018-05-29 15:12:36'),(398,651,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(399,651,2,3,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(400,651,2,4,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(401,651,2,5,1,72.00,0.00,72.00,79.20,7.20,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(402,651,2,6,1,72.00,0.00,72.00,79.20,7.20,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(403,652,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 06:03:19','2018-05-31 06:03:19'),(404,653,2,3,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 06:04:17','2018-05-31 06:04:17'),(405,654,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 06:05:12','2018-05-31 06:05:12'),(406,655,2,2,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 06:06:03','2018-05-31 06:06:03'),(407,656,2,3,1,70.00,0.00,70.00,77.00,7.00,1,0.00,0.00,NULL,NULL,NULL,'2018-05-31 06:20:16','2018-05-31 06:20:16');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (2,'sell_payment',4,1,'2018-05-30 14:01:15','2018-05-31 05:04:09'),(3,'purchase',6,1,'2018-05-31 05:44:29','2018-05-31 06:20:16'),(4,'stock_adjustment',3,1,'2018-05-31 06:24:36','2018-05-31 06:25:47'),(5,'business_location',1,1,'2018-05-31 06:27:30','2018-05-31 06:27:30');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_modifier_sets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_modifier_sets_business_id_foreign` (`business_id`),
  CONSTRAINT `res_modifier_sets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_modifier_sets` DISABLE KEYS */;
INSERT INTO `res_modifier_sets` VALUES (1,1,'Cheese',NULL,'1','2018-05-29 06:52:29','2018-05-29 06:52:29'),(2,1,'Garlic',NULL,'1','2018-05-29 06:52:44','2018-05-29 06:52:44'),(3,1,'test',NULL,'1','2018-05-29 07:11:52','2018-05-29 07:11:52'),(4,1,'Breads',NULL,'1','2018-06-05 05:34:30','2018-06-05 05:34:30');
/*!40000 ALTER TABLE `res_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_modifiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_modifiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `modifier_set_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(24,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_modifiers_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_modifiers_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `res_modifier_sets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_modifiers` WRITE;
/*!40000 ALTER TABLE `res_modifiers` DISABLE KEYS */;
INSERT INTO `res_modifiers` VALUES (1,1,'Single',10.0000,'2018-05-29 06:52:29','2018-05-29 06:52:29'),(2,1,'Double',17.0000,'2018-05-29 06:52:29','2018-05-29 06:52:29'),(3,2,'Yes',10.0000,'2018-05-29 06:52:44','2018-05-29 06:52:44'),(4,2,'No',0.0000,'2018-05-29 06:52:44','2018-05-29 06:52:44'),(5,3,'te',10.0000,'2018-05-29 07:11:52','2018-05-29 07:11:52'),(6,4,'Plan',20.0000,'2018-06-05 05:34:30','2018-06-05 05:34:30'),(7,4,'Brown Bread',20.0000,'2018-06-05 05:34:30','2018-06-05 05:34:30');
/*!40000 ALTER TABLE `res_modifiers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  `modifier_set_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `res_modifier_sets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
INSERT INTO `res_product_modifier_sets` VALUES (2,62,1,'2018-05-29 11:05:14','2018-05-29 11:05:14'),(3,62,1,'2018-05-29 11:06:01','2018-05-29 11:06:01'),(4,28,1,'2018-05-29 11:06:02','2018-05-29 11:06:02'),(5,30,1,'2018-05-29 11:06:02','2018-05-29 11:06:02'),(6,2,2,'2018-05-29 11:29:45','2018-05-29 11:29:45'),(7,28,2,'2018-05-29 11:29:45','2018-05-29 11:29:45'),(8,30,2,'2018-05-29 11:29:45','2018-05-29 11:29:45'),(9,28,2,'2018-05-29 11:31:01','2018-05-29 11:31:01'),(11,30,3,'2018-05-29 11:40:26','2018-05-29 11:40:26'),(12,2,3,'2018-05-29 11:40:50','2018-05-29 11:40:50'),(13,2,1,'2018-05-30 05:27:20','2018-05-30 05:27:20');
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `name` varchar(256) NOT NULL,
  `description` text,
  `created_by` int(11) NOT NULL,
  `deleted_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
INSERT INTO `res_tables` VALUES (1,1,1,'Table1','test',1,'0000-00-00 00:00:00','2018-05-30 10:49:01','2018-05-30 10:49:01'),(2,1,1,'table 2',NULL,1,'0000-00-00 00:00:00','2018-05-30 10:49:10','2018-05-30 10:49:10'),(3,1,1,'table 3','test',1,'0000-00-00 00:00:00','2018-05-30 10:49:21','2018-05-30 10:49:21');
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (23,2),(24,2),(25,2),(26,2),(55,2),(56,2),(23,4),(24,4),(25,4),(26,4),(55,4),(56,4),(23,6),(24,6),(25,6),(26,6),(55,6),(56,6),(23,8),(24,8),(25,8),(26,8),(55,8),(56,8),(15,11),(16,11),(17,11),(18,11),(56,11),(57,11),(61,11),(62,11),(63,11),(64,11),(3,12),(4,12),(5,12),(6,12),(55,12),(56,12);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,'2018-04-19 13:22:18','2018-04-19 13:22:18'),(2,'Cashier121212#1','web',1,0,'2018-04-19 13:22:18','2018-05-31 04:58:31'),(3,'Admin#2','web',2,1,'2018-04-19 13:22:21','2018-04-19 13:22:21'),(4,'Cashier#2','web',2,1,'2018-04-19 13:22:21','2018-04-19 13:22:21'),(5,'Admin#3','web',3,1,'2018-04-19 13:22:23','2018-04-19 13:22:23'),(6,'Cashier#3','web',3,1,'2018-04-19 13:22:23','2018-04-19 13:22:23'),(7,'Admin#4','web',4,1,'2018-04-19 13:22:24','2018-04-19 13:22:24'),(8,'Cashier#4','web',4,1,'2018-04-19 13:22:24','2018-04-19 13:22:24'),(9,'Waiter#1','web',1,1,'2018-04-24 12:35:11','2018-04-24 12:35:11'),(11,'os1234#1','web',1,0,'2018-05-14 11:22:06','2018-05-14 11:22:06'),(12,'Cashier (Awsome Shop)#1','web',1,0,'2018-05-24 05:16:14','2018-05-24 05:16:14');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(8,2) NOT NULL,
  `unit_price` decimal(20,2) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (1,623,315,489,50.00,125.00,NULL,'2018-05-21 12:20:58','2018-05-21 12:20:58'),(2,657,2,2,1.00,77.00,NULL,'2018-05-31 06:24:36','2018-05-31 06:24:36'),(3,658,2,2,1.00,77.00,NULL,'2018-05-31 06:25:08','2018-05-31 06:25:08'),(4,659,2,2,1.00,77.00,NULL,'2018-05-31 06:25:47','2018-05-31 06:25:47');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES ('db_version','2.2.1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(8,2) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'VAT@10%',10.00,0,1,NULL,'2018-01-03 21:10:07','2018-01-03 21:10:07'),(2,1,'CGST@10%',10.00,0,1,NULL,'2018-01-03 21:10:55','2018-01-03 21:10:55'),(3,1,'SGST@8%',8.00,0,1,NULL,'2018-01-03 21:11:13','2018-01-03 21:11:13'),(4,1,'GST@18%',18.00,1,1,'2018-05-11 11:12:01','2018-01-03 21:12:19','2018-05-11 11:12:01'),(5,1,'Tax@19',19.00,0,1,NULL,'2018-04-25 08:21:30','2018-04-25 08:21:30'),(6,1,'tax@6',6.00,0,1,NULL,'2018-05-10 10:47:13','2018-05-10 10:47:13');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `method` enum('cash','card','cheque','bank_transfer','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` enum('visa','master') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,6,0,770.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:06:11','2018-01-05 20:06:11'),(2,7,0,825.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:06:31','2018-01-05 20:06:31'),(3,8,0,7700.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:07:23','2018-01-05 20:07:23'),(4,9,0,750.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:07:45','2018-01-05 20:07:45'),(5,10,0,412.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-09 17:30:35',1,NULL,NULL,NULL,NULL,'2018-01-05 20:08:03','2018-01-05 20:08:03'),(6,4,0,2000.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:32:56',1,NULL,NULL,'Cash Payment',NULL,'2018-01-11 01:02:56','2018-01-11 01:02:56'),(7,3,0,3000.00,'bank_transfer',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,'502110000631','2018-01-11 17:34:10',1,NULL,NULL,'3000 Paid Via Bank Transfer',NULL,'2018-01-11 01:04:10','2018-01-11 01:04:10'),(8,2,0,84700.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:34:36',1,NULL,NULL,NULL,NULL,'2018-01-11 01:04:36','2018-01-11 01:04:36'),(9,1,0,50000.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:04',1,NULL,NULL,NULL,NULL,'2018-01-11 01:05:04','2018-01-11 01:05:04'),(10,1,0,5660.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-11 17:35:17',1,NULL,NULL,NULL,NULL,'2018-01-11 01:05:17','2018-01-11 01:05:17'),(11,11,0,300.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:48:47',4,8,NULL,NULL,NULL,'2018-04-10 04:48:47','2018-04-10 04:48:47'),(12,12,0,1200.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:49:49',4,9,NULL,NULL,NULL,'2018-04-10 04:49:49','2018-04-10 04:49:49'),(13,13,0,1350.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:50:55',4,9,NULL,NULL,NULL,'2018-04-10 04:50:55','2018-04-10 04:50:55'),(14,14,0,1500.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:52:10',4,9,NULL,NULL,NULL,'2018-04-10 04:52:10','2018-04-10 04:52:10'),(15,15,0,75.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:35',4,7,NULL,NULL,NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,16,0,105.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:53:58',4,7,NULL,NULL,NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,17,0,405.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 15:54:21',4,7,NULL,NULL,NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(18,18,0,9630.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:10:02',5,11,NULL,NULL,NULL,'2018-04-10 06:10:02','2018-04-10 06:10:02'),(19,19,0,20000.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:10:58',5,12,NULL,NULL,NULL,'2018-04-10 06:10:58','2018-04-10 06:10:58'),(20,20,0,13500.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:19',5,12,NULL,NULL,NULL,'2018-04-10 06:13:19','2018-04-10 06:13:19'),(21,21,0,19500.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:24',5,12,NULL,NULL,NULL,'2018-04-10 06:13:24','2018-04-10 06:13:24'),(22,22,0,5000.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:13:35',5,11,NULL,NULL,NULL,'2018-04-10 06:13:35','2018-04-10 06:13:35'),(23,23,0,2500.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:14:47',5,10,NULL,NULL,NULL,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(24,24,0,4875.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:15:06',5,10,NULL,NULL,NULL,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(25,25,0,625.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:16:02',5,10,NULL,NULL,NULL,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(26,26,0,15625.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:18:48',5,10,NULL,NULL,NULL,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(27,28,0,13000.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 17:24:16',5,10,NULL,NULL,NULL,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(28,29,0,656.25,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:40',6,13,NULL,NULL,NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(29,30,0,250.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:34:54',6,13,NULL,NULL,NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(30,31,0,75.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:35:19',6,13,NULL,NULL,NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(31,32,0,37.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:37:50',6,13,NULL,NULL,NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(32,33,0,375.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:01',6,13,NULL,NULL,NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(33,34,0,250.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:15',6,13,NULL,NULL,NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(34,35,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:27',6,13,NULL,NULL,NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(35,36,0,125.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-10 18:38:49',6,13,NULL,NULL,NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(36,38,0,562.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-20 16:23:18',1,1,NULL,NULL,NULL,'2018-04-20 10:53:18','2018-04-20 10:53:18'),(37,39,0,142.56,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-23 18:09:06',1,1,NULL,NULL,NULL,'2018-04-23 12:39:06','2018-04-23 12:39:06'),(38,40,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 11:01:36',1,1,NULL,NULL,NULL,'2018-04-24 05:31:36','2018-04-24 05:31:36'),(43,45,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 11:03:42',1,1,NULL,NULL,NULL,'2018-04-24 05:33:42','2018-04-24 05:33:42'),(44,46,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 11:25:44',1,1,NULL,NULL,NULL,'2018-04-24 05:55:44','2018-04-24 05:56:08'),(45,47,0,1492.92,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 13:05:44',1,1,NULL,NULL,NULL,'2018-04-24 07:35:44','2018-04-24 07:37:41'),(46,48,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:06:45',1,1,NULL,NULL,NULL,'2018-04-24 10:36:45','2018-04-24 10:36:45'),(47,49,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:09:50',1,1,NULL,NULL,NULL,'2018-04-24 10:39:50','2018-04-24 10:39:50'),(48,50,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:13:06',1,1,NULL,NULL,NULL,'2018-04-24 10:43:06','2018-04-24 10:43:06'),(49,51,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:13:12',1,1,NULL,NULL,NULL,'2018-04-24 10:43:12','2018-04-24 10:43:12'),(50,52,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:14:20',1,1,NULL,NULL,NULL,'2018-04-24 10:44:20','2018-04-24 10:44:20'),(51,53,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:14:57',1,1,NULL,NULL,NULL,'2018-04-24 10:44:57','2018-04-24 10:44:57'),(52,54,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:15:30',1,1,NULL,NULL,NULL,'2018-04-24 10:45:30','2018-04-24 10:45:30'),(53,55,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:16:09',1,1,NULL,NULL,NULL,'2018-04-24 10:46:09','2018-04-24 10:46:09'),(54,56,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:16:27',1,1,NULL,NULL,NULL,'2018-04-24 10:46:27','2018-04-24 10:46:27'),(55,57,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:17:15',1,1,NULL,NULL,NULL,'2018-04-24 10:47:15','2018-04-24 10:47:15'),(56,58,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:17:29',1,1,NULL,NULL,NULL,'2018-04-24 10:47:29','2018-04-24 10:47:29'),(57,59,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:17:52',1,1,NULL,NULL,NULL,'2018-04-24 10:47:52','2018-04-24 10:47:52'),(58,60,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:19:21',1,1,NULL,NULL,NULL,'2018-04-24 10:49:21','2018-04-24 10:49:21'),(59,61,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:19:45',1,1,NULL,NULL,NULL,'2018-04-24 10:49:45','2018-04-24 10:49:45'),(60,62,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:19:54',1,1,NULL,NULL,NULL,'2018-04-24 10:49:54','2018-04-24 10:49:54'),(61,63,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:20:30',1,1,NULL,NULL,NULL,'2018-04-24 10:50:30','2018-04-24 10:50:30'),(62,64,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:22:02',1,1,NULL,NULL,NULL,'2018-04-24 10:52:02','2018-04-24 10:52:02'),(63,65,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:23:05',1,1,NULL,NULL,NULL,'2018-04-24 10:53:05','2018-04-24 10:53:05'),(64,66,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:24:03',1,1,NULL,NULL,NULL,'2018-04-24 10:54:03','2018-04-24 10:54:03'),(65,67,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:26:14',1,1,NULL,NULL,NULL,'2018-04-24 10:56:14','2018-04-24 10:56:14'),(66,68,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 16:26:34',1,1,NULL,NULL,NULL,'2018-04-24 10:56:34','2018-04-24 13:10:31'),(67,69,0,1386.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-24 18:50:52',1,1,NULL,NULL,NULL,'2018-04-24 13:20:52','2018-04-24 13:20:52'),(68,194,0,712.80,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 16:12:06',1,1,NULL,NULL,NULL,'2018-04-25 10:42:06','2018-04-25 10:42:06'),(69,292,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 17:48:43',1,1,NULL,NULL,NULL,'2018-04-25 12:18:43','2018-04-25 12:18:43'),(70,293,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:00:27',1,1,NULL,NULL,NULL,'2018-04-25 12:30:27','2018-04-25 12:30:27'),(71,294,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:01:09',1,1,NULL,NULL,NULL,'2018-04-25 12:31:09','2018-04-25 12:31:09'),(72,295,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:02:16',1,1,NULL,NULL,NULL,'2018-04-25 12:32:16','2018-04-25 12:32:16'),(73,296,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:02:46',1,1,NULL,NULL,NULL,'2018-04-25 12:32:46','2018-04-25 12:32:46'),(74,297,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:03:14',1,1,NULL,NULL,NULL,'2018-04-25 12:33:14','2018-04-25 12:33:14'),(75,298,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:04:16',1,1,NULL,NULL,NULL,'2018-04-25 12:34:16','2018-04-25 12:34:16'),(76,299,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:04:44',1,1,NULL,NULL,NULL,'2018-04-25 12:34:44','2018-04-25 12:34:44'),(77,300,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:05:41',1,1,NULL,NULL,NULL,'2018-04-25 12:35:41','2018-04-25 12:35:41'),(78,301,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:05:59',1,1,NULL,NULL,NULL,'2018-04-25 12:35:59','2018-04-25 12:35:59'),(79,302,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:06:40',1,1,NULL,NULL,NULL,'2018-04-25 12:36:40','2018-04-25 12:36:40'),(80,303,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:09:08',1,1,NULL,NULL,NULL,'2018-04-25 12:39:08','2018-04-25 12:39:08'),(81,304,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:10:09',1,1,NULL,NULL,NULL,'2018-04-25 12:40:09','2018-04-25 12:40:09'),(82,305,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:11:02',1,1,NULL,NULL,NULL,'2018-04-25 12:41:02','2018-04-25 12:41:02'),(83,306,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:12:42',1,1,NULL,NULL,NULL,'2018-04-25 12:42:42','2018-04-25 12:42:42'),(84,307,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:16:42',1,1,NULL,NULL,NULL,'2018-04-25 12:46:42','2018-04-25 12:46:42'),(85,308,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:17:46',1,1,NULL,NULL,NULL,'2018-04-25 12:47:46','2018-04-25 12:47:46'),(86,309,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:19:35',1,1,NULL,NULL,NULL,'2018-04-25 12:49:35','2018-04-25 12:49:35'),(87,310,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:22:19',1,1,NULL,NULL,NULL,'2018-04-25 12:52:19','2018-04-25 12:52:19'),(88,311,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:22:57',1,1,NULL,NULL,NULL,'2018-04-25 12:52:57','2018-04-25 12:52:57'),(89,312,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:26:20',1,1,NULL,NULL,NULL,'2018-04-25 12:56:20','2018-04-25 12:56:20'),(90,313,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:32:08',1,1,NULL,NULL,NULL,'2018-04-25 13:02:08','2018-04-25 13:02:08'),(91,314,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:36:13',1,1,NULL,NULL,NULL,'2018-04-25 13:06:13','2018-04-25 13:06:13'),(92,315,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:36:29',1,1,NULL,NULL,NULL,'2018-04-25 13:06:29','2018-04-25 13:06:29'),(93,316,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:37:25',1,1,NULL,NULL,NULL,'2018-04-25 13:07:25','2018-04-25 13:07:25'),(94,317,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:38:28',1,1,NULL,NULL,NULL,'2018-04-25 13:08:28','2018-04-25 13:08:28'),(95,318,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:39:07',1,1,NULL,NULL,NULL,'2018-04-25 13:09:07','2018-04-25 13:09:07'),(96,319,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:39:49',1,1,NULL,NULL,NULL,'2018-04-25 13:09:49','2018-04-25 13:09:49'),(97,320,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:40:36',1,1,NULL,NULL,NULL,'2018-04-25 13:10:36','2018-04-25 13:10:36'),(98,321,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:41:01',1,1,NULL,NULL,NULL,'2018-04-25 13:11:01','2018-04-25 13:11:01'),(99,322,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:41:20',1,1,NULL,NULL,NULL,'2018-04-25 13:11:20','2018-04-25 13:11:20'),(100,323,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:41:49',1,1,NULL,NULL,NULL,'2018-04-25 13:11:49','2018-04-25 13:11:49'),(101,324,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:42:20',1,1,NULL,NULL,NULL,'2018-04-25 13:12:20','2018-04-25 13:12:20'),(102,325,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:42:35',1,1,NULL,NULL,NULL,'2018-04-25 13:12:35','2018-04-25 13:12:35'),(103,326,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:43:11',1,1,NULL,NULL,NULL,'2018-04-25 13:13:11','2018-04-25 13:13:11'),(104,327,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:44:07',1,1,NULL,NULL,NULL,'2018-04-25 13:14:07','2018-04-25 13:14:07'),(105,328,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:45:04',1,1,NULL,NULL,NULL,'2018-04-25 13:15:04','2018-04-25 13:15:04'),(106,329,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:45:26',1,1,NULL,NULL,NULL,'2018-04-25 13:15:26','2018-04-25 13:15:26'),(107,330,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:45:42',1,1,NULL,NULL,NULL,'2018-04-25 13:15:42','2018-04-25 13:15:42'),(108,331,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:46:03',1,1,NULL,NULL,NULL,'2018-04-25 13:16:03','2018-04-25 13:16:03'),(109,332,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:46:21',1,1,NULL,NULL,NULL,'2018-04-25 13:16:21','2018-04-25 13:16:21'),(110,333,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:46:41',1,1,NULL,NULL,NULL,'2018-04-25 13:16:41','2018-04-25 13:16:41'),(111,334,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:47:14',1,1,NULL,NULL,NULL,'2018-04-25 13:17:14','2018-04-25 13:17:14'),(112,335,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:53:17',1,1,NULL,NULL,NULL,'2018-04-25 13:23:17','2018-04-25 13:23:17'),(113,336,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:55:27',1,1,NULL,NULL,NULL,'2018-04-25 13:25:27','2018-04-25 13:25:27'),(114,337,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:55:38',1,1,NULL,NULL,NULL,'2018-04-25 13:25:38','2018-04-25 13:25:38'),(115,338,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:56:02',1,1,NULL,NULL,NULL,'2018-04-25 13:26:02','2018-04-25 13:26:02'),(116,339,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:56:33',1,1,NULL,NULL,NULL,'2018-04-25 13:26:33','2018-04-25 13:26:33'),(117,340,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-25 18:56:49',1,1,NULL,NULL,NULL,'2018-04-25 13:26:49','2018-04-25 13:26:49'),(118,341,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 12:01:52',1,1,NULL,NULL,NULL,'2018-04-27 06:31:52','2018-04-27 06:31:52'),(119,342,0,81.77,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 12:02:18',1,1,NULL,NULL,NULL,'2018-04-27 06:32:18','2018-04-27 06:32:18'),(120,343,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 13:16:51',1,1,NULL,NULL,NULL,'2018-04-27 07:46:51','2018-04-27 07:46:51'),(121,344,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 14:00:32',1,1,NULL,NULL,NULL,'2018-04-27 08:30:32','2018-04-27 08:30:32'),(122,345,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 14:01:47',1,1,NULL,NULL,NULL,'2018-04-27 08:31:47','2018-04-27 08:31:47'),(123,346,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 14:06:04',1,1,NULL,NULL,NULL,'2018-04-27 08:36:04','2018-04-27 08:36:04'),(124,347,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 14:06:47',1,1,NULL,NULL,NULL,'2018-04-27 08:36:47','2018-04-27 08:36:47'),(125,348,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 14:08:07',1,1,NULL,NULL,NULL,'2018-04-27 08:38:07','2018-04-27 11:50:57'),(126,349,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:02:26',1,1,NULL,NULL,NULL,'2018-04-27 10:32:26','2018-04-27 10:32:26'),(127,350,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:16:53',1,1,NULL,NULL,NULL,'2018-04-27 10:46:53','2018-04-27 11:43:37'),(128,351,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:17:15',1,1,NULL,NULL,NULL,'2018-04-27 10:47:15','2018-04-27 11:46:24'),(129,352,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:19:20',1,1,NULL,NULL,NULL,'2018-04-27 10:49:20','2018-04-27 11:44:06'),(130,353,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:43:35',1,1,NULL,NULL,NULL,'2018-04-27 11:13:35','2018-04-27 11:13:35'),(131,354,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:44:44',1,1,NULL,NULL,NULL,'2018-04-27 11:14:44','2018-04-27 11:14:44'),(132,355,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:47:17',1,1,NULL,NULL,NULL,'2018-04-27 11:17:17','2018-04-27 11:17:17'),(133,356,0,12.38,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-27 16:47:36',1,1,NULL,NULL,NULL,'2018-04-27 11:17:36','2018-04-27 11:23:08'),(134,361,0,11250.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-04-30 19:04:26',1,1,NULL,NULL,NULL,'2018-04-30 13:34:26','2018-04-30 13:34:26'),(135,362,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-01 10:55:06',1,1,NULL,NULL,NULL,'2018-05-01 05:25:06','2018-05-01 05:51:02'),(136,363,0,78.41,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-01 11:22:35',1,1,NULL,NULL,NULL,'2018-05-01 05:52:35','2018-05-01 05:52:35'),(137,37,0,1000.00,'card','test','test','visa','test','test','test','test',NULL,NULL,'2018-05-01 12:07:42',1,2,NULL,'test',NULL,'2018-05-01 06:37:42','2018-05-01 06:37:42'),(138,366,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-01 17:36:02',1,1,NULL,NULL,NULL,'2018-05-01 12:06:02','2018-05-01 12:06:02'),(139,367,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-01 18:19:49',1,1,NULL,NULL,NULL,'2018-05-01 12:49:49','2018-05-01 12:49:49'),(140,368,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-01 18:22:29',1,1,NULL,NULL,NULL,'2018-05-01 12:52:29','2018-05-01 12:52:29'),(141,369,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 11:06:29',1,1,NULL,NULL,NULL,'2018-05-02 05:36:29','2018-05-02 05:36:29'),(142,NULL,0,15150.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 11:08:45',1,6,NULL,'15,150.00',NULL,'2018-05-02 05:38:45','2018-05-02 05:38:45'),(143,3,0,3050.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 11:08:45',1,6,142,NULL,NULL,'2018-05-02 05:38:45','2018-05-02 05:38:45'),(144,5,0,12100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 11:08:45',1,6,142,NULL,NULL,'2018-05-02 05:38:45','2018-05-02 05:38:45'),(145,372,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:21:08',1,1,NULL,NULL,NULL,'2018-05-02 06:51:08','2018-05-02 06:51:08'),(146,373,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:22:34',1,1,NULL,NULL,NULL,'2018-05-02 06:52:34','2018-05-02 06:52:34'),(150,377,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:31:31',1,1,NULL,NULL,NULL,'2018-05-02 07:01:31','2018-05-02 07:01:31'),(152,378,1,28.72,'cash','','','','','',NULL,'','','','2018-05-02 12:53:36',1,1,NULL,'',NULL,'2018-05-02 07:23:36','2018-05-02 07:23:36'),(154,380,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:55:55',1,1,NULL,NULL,NULL,'2018-05-02 07:25:55','2018-05-02 07:25:55'),(156,382,0,112.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:58:44',1,1,NULL,NULL,NULL,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(157,383,0,250.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 12:59:27',1,1,NULL,NULL,NULL,'2018-05-02 07:29:27','2018-05-02 07:42:22'),(159,384,0,250.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 13:14:08',1,1,NULL,NULL,NULL,'2018-05-02 07:44:08','2018-05-02 07:47:54'),(161,384,1,137.50,'cash','','','','','',NULL,'','','','2018-05-02 13:17:54',1,1,NULL,'',NULL,'2018-05-02 07:47:54','2018-05-02 07:47:54'),(162,385,0,155.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 13:43:48',1,1,NULL,NULL,NULL,'2018-05-02 08:13:48','2018-05-02 08:26:02'),(166,385,1,83.72,'cash','','','','','',NULL,'','','','2018-05-02 13:56:02',1,1,NULL,'',NULL,'2018-05-02 08:26:02','2018-05-02 08:26:02'),(167,386,0,120.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 14:03:15',1,1,NULL,NULL,NULL,'2018-05-02 08:33:15','2018-05-02 08:37:05'),(170,386,1,50.70,'cash','','','','','',NULL,'','','','2018-05-02 14:07:05',1,1,NULL,'',NULL,'2018-05-02 08:37:05','2018-05-02 08:37:05'),(171,387,0,110.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 14:07:47',1,1,NULL,NULL,NULL,'2018-05-02 08:37:47','2018-05-02 08:38:25'),(173,387,1,40.70,'cash','','','','','',NULL,'','','','2018-05-02 14:08:25',1,1,NULL,'',NULL,'2018-05-02 08:38:25','2018-05-02 08:38:25'),(174,388,0,120.00,'card',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 14:09:07',1,1,NULL,NULL,NULL,'2018-05-02 08:39:07','2018-05-02 08:39:41'),(175,388,1,7.50,'cash','','','','','',NULL,'','','','2018-05-02 14:09:41',1,1,NULL,'',NULL,'2018-05-02 08:39:41','2018-05-02 08:39:41'),(176,389,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:07:33',1,1,NULL,NULL,NULL,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(177,389,1,30.70,'cash','','','','','',NULL,'','','','2018-05-02 16:07:33',1,1,NULL,'',NULL,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(178,390,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:18:33',1,1,NULL,NULL,NULL,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(179,391,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:18:49',1,1,NULL,NULL,NULL,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(180,391,1,30.70,'cash','','','','','',NULL,'','','','2018-05-02 16:18:49',1,1,NULL,'',NULL,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(181,392,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:19:22',1,1,NULL,NULL,NULL,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(182,393,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:19:36',1,1,NULL,NULL,NULL,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(183,393,1,30.70,'cash','','','','','',NULL,'','','','2018-05-02 16:19:36',1,1,NULL,'',NULL,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(184,394,0,10.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:20:31',1,1,NULL,NULL,NULL,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(185,394,0,20.00,'card',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:20:31',1,1,NULL,NULL,NULL,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(186,394,0,50.00,'cheque',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:20:31',1,1,NULL,NULL,NULL,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(187,394,1,10.70,'cash','','','','','',NULL,'','','','2018-05-02 16:20:31',1,1,NULL,'',NULL,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(188,395,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-02 16:58:01',1,1,NULL,NULL,NULL,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(189,395,1,28.72,'cash','','','','','',NULL,'','','','2018-05-02 16:58:01',1,1,NULL,'',NULL,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(190,396,0,135.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 10:57:14',1,1,NULL,NULL,NULL,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(191,397,0,146.25,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 10:57:27',1,1,NULL,NULL,NULL,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(192,398,0,146.25,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 10:59:00',1,1,NULL,NULL,NULL,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(193,399,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 11:20:08',1,1,NULL,NULL,NULL,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(194,400,0,135.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 12:26:32',1,1,NULL,NULL,NULL,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(195,401,0,10.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 12:34:45',1,1,NULL,NULL,NULL,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(196,402,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 12:35:19',1,1,NULL,NULL,NULL,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(197,403,0,120.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 12:35:53',1,1,NULL,NULL,NULL,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(198,403,1,7.50,'cash','','','','','',NULL,'','','','2018-05-03 12:35:53',1,1,NULL,'',NULL,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(199,404,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 12:38:45',1,1,NULL,NULL,NULL,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(200,404,1,30.70,'cash','','','','','',NULL,'','','','2018-05-03 12:38:45',1,1,NULL,'',NULL,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(201,405,0,76.23,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-03 15:55:59',1,14,NULL,NULL,NULL,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(202,406,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:08:23',1,1,NULL,NULL,NULL,'2018-05-07 07:38:23','2018-05-07 07:38:23'),(203,407,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:08:47',1,1,NULL,NULL,NULL,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(204,408,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:08:58',1,1,NULL,NULL,NULL,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(205,409,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:11:43',1,1,NULL,NULL,NULL,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(206,410,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:13:33',1,1,NULL,NULL,NULL,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(207,411,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:23:47',1,1,NULL,NULL,NULL,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(208,412,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:36:12',1,1,NULL,NULL,NULL,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(209,413,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:40:22',1,1,NULL,NULL,NULL,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(210,414,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:43:39',1,1,NULL,NULL,NULL,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(211,415,0,142.56,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:44:16',1,1,NULL,NULL,NULL,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(212,416,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:44:39',1,1,NULL,NULL,NULL,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(213,417,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:44:52',1,1,NULL,NULL,NULL,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(214,418,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:45:19',1,1,NULL,NULL,NULL,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(215,419,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:45:32',1,1,NULL,NULL,NULL,'2018-05-07 08:15:32','2018-05-07 08:15:32'),(216,420,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:46:02',1,1,NULL,NULL,NULL,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(217,421,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:46:35',1,1,NULL,NULL,NULL,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(218,422,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:47:18',1,1,NULL,NULL,NULL,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(219,423,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-07 13:47:35',1,1,NULL,NULL,NULL,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(220,426,0,34.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 16:24:25',1,1,NULL,NULL,NULL,'2018-05-10 10:54:26','2018-05-10 10:54:26'),(221,427,0,34.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 16:27:40',1,1,NULL,NULL,NULL,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(222,428,0,34.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 16:31:03',1,1,NULL,NULL,NULL,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(223,429,0,33.98,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 16:37:33',1,1,NULL,NULL,NULL,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(224,430,0,34.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 16:54:24',1,1,NULL,NULL,NULL,'2018-05-10 11:24:25','2018-05-10 11:26:36'),(225,431,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 18:24:15',1,1,NULL,NULL,NULL,'2018-05-10 12:54:15','2018-05-10 12:54:15'),(226,432,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 05:58:27',1,1,NULL,NULL,NULL,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(227,433,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-10 18:29:20',1,1,NULL,NULL,NULL,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(228,435,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 17:53:32',1,1,NULL,NULL,NULL,'2018-05-11 12:23:32','2018-05-11 12:23:32'),(229,436,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 18:00:30',1,1,NULL,NULL,NULL,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(230,437,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 18:04:58',1,1,NULL,NULL,NULL,'2018-05-11 12:34:58','2018-05-11 12:34:58'),(231,438,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 18:53:50',1,1,NULL,NULL,NULL,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(232,439,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 19:27:12',1,1,NULL,NULL,NULL,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(233,440,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-11 20:13:26',1,1,NULL,NULL,NULL,'2018-05-11 14:43:26','2018-05-11 14:43:26'),(234,441,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:38:02',1,1,NULL,NULL,NULL,'2018-05-12 06:08:02','2018-05-12 06:08:02'),(235,442,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:40:54',1,1,NULL,NULL,NULL,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(236,443,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:43:07',1,1,NULL,NULL,NULL,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(237,444,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:48:40',1,1,NULL,NULL,NULL,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(238,445,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 11:54:20',1,1,NULL,NULL,NULL,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(239,446,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:00:06',1,1,NULL,NULL,NULL,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(240,447,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:00:55',1,1,NULL,NULL,NULL,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(241,448,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:02:22',1,1,NULL,NULL,NULL,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(242,449,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:04:02',1,1,NULL,NULL,NULL,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(243,450,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:04:45',1,1,NULL,NULL,NULL,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(244,451,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:09:15',1,1,NULL,NULL,NULL,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(245,452,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:20:07',1,1,NULL,NULL,NULL,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(246,453,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:29:22',1,1,NULL,NULL,NULL,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(247,454,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:32:23',1,1,NULL,NULL,NULL,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(248,455,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:45:50',1,1,NULL,NULL,NULL,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(249,456,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:51:11',1,1,NULL,NULL,NULL,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(250,457,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:52:26',1,1,NULL,NULL,NULL,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(251,458,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 12:59:44',1,1,NULL,NULL,NULL,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(252,459,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:02:44',1,1,NULL,NULL,NULL,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(253,460,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:04:55',1,1,NULL,NULL,NULL,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(254,461,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:06:20',1,1,NULL,NULL,NULL,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(255,462,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:08:46',1,1,NULL,NULL,NULL,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(256,463,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:10:09',1,1,NULL,NULL,NULL,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(257,464,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:12:44',1,1,NULL,NULL,NULL,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(258,465,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:14:15',1,1,NULL,NULL,NULL,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(259,466,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:14:35',1,1,NULL,NULL,NULL,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(260,467,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:14:54',1,1,NULL,NULL,NULL,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(261,468,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:15:14',1,1,NULL,NULL,NULL,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(262,469,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:15:46',1,1,NULL,NULL,NULL,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(263,470,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:16:35',1,1,NULL,NULL,NULL,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(264,471,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:17:06',1,1,NULL,NULL,NULL,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(265,472,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:26:14',1,1,NULL,NULL,NULL,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(266,473,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:30:45',1,1,NULL,NULL,NULL,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(267,474,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:35:22',1,1,NULL,NULL,NULL,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(268,475,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:37:25',1,1,NULL,NULL,NULL,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(269,476,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:38:11',1,1,NULL,NULL,NULL,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(270,477,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:42:57',1,1,NULL,NULL,NULL,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(271,478,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:46:28',1,1,NULL,NULL,NULL,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(272,479,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:53:20',1,1,NULL,NULL,NULL,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(273,480,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:54:14',1,1,NULL,NULL,NULL,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(274,481,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:55:24',1,1,NULL,NULL,NULL,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(275,482,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:59:15',1,1,NULL,NULL,NULL,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(276,483,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 13:59:47',1,1,NULL,NULL,NULL,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(277,484,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 14:01:23',1,1,NULL,NULL,NULL,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(278,485,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 14:02:23',1,1,NULL,NULL,NULL,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(279,486,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 14:02:54',1,1,NULL,NULL,NULL,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(280,487,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:45:20',1,1,NULL,NULL,NULL,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(281,488,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:47:00',1,1,NULL,NULL,NULL,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(282,489,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:49:46',1,1,NULL,NULL,NULL,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(283,490,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:54:52',1,1,NULL,NULL,NULL,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(284,491,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:56:44',1,1,NULL,NULL,NULL,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(285,492,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:57:49',1,1,NULL,NULL,NULL,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(286,493,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 16:59:29',1,1,NULL,NULL,NULL,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(287,494,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:03:28',1,1,NULL,NULL,NULL,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(288,495,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:04:56',1,1,NULL,NULL,NULL,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(289,496,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:05:46',1,1,NULL,NULL,NULL,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(290,497,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:08:52',1,1,NULL,NULL,NULL,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(291,498,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:10:28',1,1,NULL,NULL,NULL,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(292,499,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:11:53',1,1,NULL,NULL,NULL,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(293,500,0,140.58,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:17:41',1,1,NULL,NULL,NULL,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(294,501,0,83.66,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:19:09',1,1,NULL,NULL,NULL,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(295,502,0,81.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:22:01',1,1,NULL,NULL,NULL,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(296,503,0,83.66,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:22:44',1,1,NULL,NULL,NULL,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(297,504,0,78.41,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:23:46',1,1,NULL,NULL,NULL,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(298,506,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:26:58',1,15,NULL,NULL,NULL,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(299,507,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:30:12',1,15,NULL,NULL,NULL,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(300,508,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:31:35',1,1,NULL,NULL,NULL,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(301,509,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:40:24',1,15,NULL,NULL,NULL,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(302,510,0,81.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:43:27',1,1,NULL,NULL,NULL,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(303,511,0,81.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:44:03',1,1,NULL,NULL,NULL,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(304,512,0,217.53,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:44:48',1,15,NULL,NULL,NULL,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(305,513,0,217.53,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:45:59',1,15,NULL,NULL,NULL,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(306,514,0,217.53,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 17:47:16',1,1,NULL,NULL,NULL,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(307,515,0,158.63,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 18:43:37',1,1,NULL,NULL,NULL,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(308,516,0,227.93,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 18:44:37',1,1,NULL,NULL,NULL,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(309,517,0,227.93,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 18:49:04',1,15,NULL,NULL,NULL,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(310,518,0,81.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 18:49:49',1,1,NULL,NULL,NULL,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(311,519,0,217.53,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 19:28:28',1,1,NULL,NULL,NULL,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(312,520,0,215.55,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 19:33:19',1,1,NULL,NULL,NULL,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(313,521,0,179.66,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-12 19:39:49',1,1,NULL,NULL,NULL,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(314,522,0,138.60,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:09:01',1,1,NULL,NULL,NULL,'2018-05-14 05:39:01','2018-05-14 05:39:01'),(315,523,0,206.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:10:03',1,1,NULL,NULL,NULL,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(316,524,0,239.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:10:50',1,1,NULL,NULL,NULL,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(317,525,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:11:25',1,1,NULL,NULL,NULL,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(318,526,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:12:37',1,1,NULL,NULL,NULL,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(319,527,0,78.41,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:12:49',1,1,NULL,NULL,NULL,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(320,528,0,206.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:15:38',1,1,NULL,NULL,NULL,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(321,530,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:17:51',1,1,NULL,NULL,NULL,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(322,531,0,20.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-14 11:19:04',1,1,NULL,NULL,NULL,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(323,536,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 14:04:21',1,1,NULL,NULL,NULL,'2018-05-15 08:34:21','2018-05-15 08:34:21'),(324,537,0,1125.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 14:04:51',1,1,NULL,NULL,NULL,'2018-05-15 08:34:51','2018-05-15 08:34:51'),(325,538,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 16:20:18',1,1,NULL,NULL,NULL,'2018-05-15 10:50:18','2018-05-15 10:50:18'),(326,540,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 16:36:02',1,1,NULL,NULL,NULL,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(327,541,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:08:37',1,1,NULL,NULL,NULL,'2018-05-15 11:38:38','2018-05-15 11:38:38'),(328,542,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:09:22',1,1,NULL,NULL,NULL,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(329,543,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:10:20',1,1,NULL,NULL,NULL,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(330,544,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:10:41',1,1,NULL,NULL,NULL,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(331,545,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:15:20',1,1,NULL,NULL,NULL,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(332,546,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:15:39',1,1,NULL,NULL,NULL,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(333,547,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:16:49',1,1,NULL,NULL,NULL,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(334,548,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 17:17:34',1,1,NULL,NULL,NULL,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(335,549,0,1869.21,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 18:00:03',1,1,NULL,NULL,NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(336,550,0,1602.99,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-15 18:01:15',1,1,NULL,NULL,NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(339,550,1,112.50,'cash','','','','','',NULL,'','','','2018-05-15 18:09:45',1,1,NULL,'',NULL,'2018-05-15 12:39:45','2018-05-15 12:39:45'),(340,551,0,81.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 11:38:59',1,1,NULL,NULL,NULL,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(341,552,0,0.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 11:49:26',1,1,NULL,NULL,NULL,'2018-05-16 06:19:26','2018-05-16 06:39:44'),(342,553,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 11:52:01',1,1,NULL,NULL,NULL,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(343,552,0,216.68,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 12:09:44',1,1,NULL,NULL,NULL,'2018-05-16 06:39:44','2018-05-16 06:39:44'),(344,554,0,69.30,'card','123456','number','visa','name','month',NULL,'1234',NULL,NULL,'2018-05-16 13:06:53',1,1,NULL,NULL,NULL,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(345,555,0,69.30,'card','123456','number','visa','name','month',NULL,'1234',NULL,NULL,'2018-05-16 13:06:53',1,1,NULL,NULL,NULL,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(346,556,0,81.68,'card','tran','number','visa','name','month',NULL,'1234',NULL,NULL,'2018-05-16 13:08:48',1,1,NULL,NULL,NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(347,557,0,81.68,'card','tran','number','visa','name','month',NULL,'1234',NULL,NULL,'2018-05-16 13:08:48',1,1,NULL,NULL,NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(348,558,0,217.53,'card',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:09:14',1,1,NULL,NULL,NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(349,559,0,217.53,'card',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:09:14',1,1,NULL,NULL,NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(350,560,0,81.68,'card','tra','num','visa','name','2017',NULL,'test',NULL,NULL,'2018-05-16 13:10:18',1,1,NULL,NULL,NULL,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(351,561,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:15:09',1,1,NULL,NULL,NULL,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(352,562,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:15:29',1,1,NULL,NULL,NULL,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(353,563,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:16:37',1,1,NULL,NULL,NULL,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(354,564,0,71.28,'card',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:18:03',1,1,NULL,NULL,NULL,'2018-05-16 07:48:03','2018-05-16 07:48:03'),(355,565,0,69.30,'card',NULL,NULL,'master',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 13:28:28',1,1,NULL,NULL,NULL,'2018-05-16 07:58:28','2018-05-16 08:13:31'),(356,570,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:13:40',1,1,NULL,NULL,NULL,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(357,571,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:14:44',1,1,NULL,NULL,NULL,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(358,572,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:17:33',1,1,NULL,NULL,NULL,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(359,573,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:21:16',1,1,NULL,NULL,NULL,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(360,574,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:22:13',1,1,NULL,NULL,NULL,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(361,575,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:25:07',1,1,NULL,NULL,NULL,'2018-05-16 12:55:07','2018-05-16 12:55:07'),(362,576,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-16 18:42:48',1,1,NULL,NULL,NULL,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(363,577,0,5314.37,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-17 16:49:00',1,1,NULL,NULL,NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(364,578,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-18 10:52:26',1,1,NULL,NULL,NULL,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(365,579,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-18 11:24:25',1,1,NULL,NULL,NULL,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(366,580,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-18 11:24:59',1,1,NULL,NULL,NULL,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(367,598,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-19 13:00:47',1,1,NULL,NULL,NULL,'2018-05-19 07:30:47','2018-05-19 07:30:47'),(368,599,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-19 13:02:46',1,1,NULL,NULL,NULL,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(369,600,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-19 13:05:57',1,1,NULL,NULL,NULL,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(370,614,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-21 16:44:28',1,16,NULL,NULL,NULL,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(371,615,0,346.50,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-21 16:56:22',1,1,NULL,NULL,NULL,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(372,619,0,5625.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-21 17:48:25',1,1,NULL,NULL,NULL,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(373,629,0,600.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-21 19:22:54',1,1,NULL,NULL,NULL,'2018-05-21 13:52:54','2018-05-24 07:09:00'),(375,629,1,184.20,'cash','','','','','',NULL,'','','','2018-05-24 12:39:00',1,1,NULL,'',NULL,'2018-05-24 07:09:00','2018-05-24 07:09:00'),(376,630,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-24 12:53:06',1,15,NULL,NULL,NULL,'2018-05-24 07:23:06','2018-05-24 07:23:06'),(377,631,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-24 12:54:19',1,15,NULL,NULL,NULL,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(378,632,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-24 12:55:34',1,15,NULL,NULL,NULL,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(379,633,0,71.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-24 13:17:44',1,15,NULL,NULL,NULL,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(380,634,0,100.00,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-24 13:19:16',1,15,NULL,NULL,NULL,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(381,634,1,30.70,'cash','','','','','',NULL,'','','','2018-05-24 13:19:16',1,15,NULL,'',NULL,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(382,635,0,207.90,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-25 16:20:55',1,1,NULL,NULL,NULL,'2018-05-25 10:50:55','2018-05-25 10:50:55'),(383,636,0,69.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-25 16:21:25',1,1,NULL,NULL,NULL,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(384,638,0,87.30,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-30 17:46:40',1,1,NULL,NULL,NULL,'2018-05-30 12:16:40','2018-05-30 12:16:40'),(391,645,0,98.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-30 19:31:15',1,1,NULL,NULL,'2018/0001','2018-05-30 14:01:16','2018-05-30 14:01:16'),(392,646,0,95.58,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-30 19:32:13',1,1,NULL,NULL,'2018/0002','2018-05-30 14:02:13','2018-05-30 14:02:13'),(393,648,0,93.60,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-30 19:33:52',1,1,NULL,NULL,'2018/0003','2018-05-30 14:03:52','2018-05-30 14:03:52'),(394,650,0,98.28,'cash',NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2018-05-31 10:34:09',1,1,NULL,NULL,'2018/0004','2018-05-31 05:04:09','2018-05-31 05:04:09');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` decimal(22,4) DEFAULT NULL,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL,
  `item_tax` decimal(22,4) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `modifiers` text COLLATE utf8mb4_unicode_ci COMMENT 'Used in restaurant module',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,6,2,3,10,70.0000,77.0000,7.0000,1,NULL,NULL,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(2,7,27,70,30,25.0000,27.5000,2.5000,1,NULL,NULL,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(3,8,2,3,50,70.0000,77.0000,7.0000,1,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(4,8,2,2,50,70.0000,77.0000,7.0000,1,NULL,NULL,'2018-01-06 01:37:23','2018-01-06 01:37:23'),(5,9,21,64,60,12.5000,12.5000,0.0000,NULL,NULL,NULL,'2018-01-06 01:37:45','2018-01-06 01:37:45'),(6,10,28,71,30,12.5000,13.7500,1.2500,1,NULL,NULL,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(7,15,34,77,10,7.5000,7.5000,0.0000,NULL,'',NULL,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(8,16,32,75,7,15.0000,15.0000,0.0000,NULL,'',NULL,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(9,17,33,76,27,15.0000,15.0000,0.0000,NULL,'',NULL,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(10,23,43,86,5,500.0000,500.0000,0.0000,NULL,'IHN45822225007',NULL,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(11,24,44,87,20,243.7500,243.7500,0.0000,NULL,'SMJ7558455524',NULL,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(12,25,41,84,1,625.0000,625.0000,0.0000,NULL,'EXSD1225778855',NULL,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(13,26,41,84,25,625.0000,625.0000,0.0000,NULL,'HP020555548444',NULL,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(14,28,42,85,20,650.0000,650.0000,0.0000,NULL,'HP68400258F',NULL,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(15,29,53,96,5,131.2500,131.2500,0.0000,NULL,'',NULL,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(16,30,51,94,2,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(17,31,57,100,3,25.0000,25.0000,0.0000,NULL,'',NULL,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(18,32,60,103,2,18.7500,18.7500,0.0000,NULL,'',NULL,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(19,33,56,99,2,187.5000,187.5000,0.0000,NULL,'',NULL,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(20,34,54,97,20,12.5000,12.5000,0.0000,NULL,'',NULL,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(21,35,55,98,10,10.0000,10.0000,0.0000,NULL,'',NULL,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(22,36,57,100,5,25.0000,25.0000,0.0000,NULL,'',NULL,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(23,38,61,104,5,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-04-20 10:53:18','2018-04-20 10:53:18'),(24,39,2,5,2,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-23 12:39:06','2018-04-23 12:39:06'),(25,40,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-24 05:31:36','2018-04-24 05:31:36'),(30,45,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-24 05:33:42','2018-04-24 05:33:42'),(31,46,28,71,1,12.5000,13.7500,0.0000,1,'',NULL,'2018-04-24 05:55:44','2018-04-24 05:56:08'),(32,47,2,4,2,70.0000,77.0000,0.0000,1,'',NULL,'2018-04-24 07:35:44','2018-04-24 07:37:41'),(33,47,2,6,19,72.0000,79.2000,0.0000,1,'',NULL,'2018-04-24 07:35:44','2018-04-24 07:37:41'),(34,48,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-04-24 10:36:45','2018-04-24 10:36:45'),(35,49,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:39:50','2018-04-24 10:39:50'),(36,50,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:43:06','2018-04-24 10:43:06'),(37,51,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:43:12','2018-04-24 10:43:12'),(38,52,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:44:20','2018-04-24 10:44:20'),(39,53,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:44:57','2018-04-24 10:44:57'),(40,54,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:45:30','2018-04-24 10:45:30'),(41,55,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:46:09','2018-04-24 10:46:09'),(42,56,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:46:27','2018-04-24 10:46:27'),(43,57,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:47:15','2018-04-24 10:47:15'),(44,58,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:47:29','2018-04-24 10:47:29'),(45,59,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:47:52','2018-04-24 10:47:52'),(46,60,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:49:21','2018-04-24 10:49:21'),(47,61,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:49:45','2018-04-24 10:49:45'),(48,62,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:49:54','2018-04-24 10:49:54'),(49,63,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:50:30','2018-04-24 10:50:30'),(50,64,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-24 10:52:02','2018-04-24 10:52:02'),(51,65,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:53:05','2018-04-24 10:53:05'),(52,66,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:54:03','2018-04-24 10:54:03'),(53,67,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-24 10:56:14','2018-04-24 10:56:14'),(54,68,28,71,1,12.5000,13.7500,0.0000,1,'',NULL,'2018-04-24 10:56:34','2018-04-24 13:10:31'),(55,69,2,4,20,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-24 13:20:52','2018-04-24 13:20:52'),(56,194,2,5,10,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 10:42:06','2018-04-25 10:42:06'),(57,292,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:18:43','2018-04-25 12:18:43'),(58,293,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:30:27','2018-04-25 12:30:27'),(59,294,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:31:09','2018-04-25 12:31:09'),(60,295,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:32:16','2018-04-25 12:32:16'),(61,296,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:32:46','2018-04-25 12:32:46'),(62,297,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:33:14','2018-04-25 12:33:14'),(63,298,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:34:16','2018-04-25 12:34:16'),(64,299,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:34:44','2018-04-25 12:34:44'),(65,300,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:35:41','2018-04-25 12:35:41'),(66,301,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:35:59','2018-04-25 12:35:59'),(67,302,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:36:40','2018-04-25 12:36:40'),(68,303,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:39:08','2018-04-25 12:39:08'),(69,304,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:40:09','2018-04-25 12:40:09'),(70,305,195,278,1,125.0000,125.0000,0.0000,NULL,'dsd',NULL,'2018-04-25 12:41:02','2018-04-25 12:41:02'),(71,306,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:42:42','2018-04-25 12:42:42'),(72,307,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:46:42','2018-04-25 12:46:42'),(73,308,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:47:46','2018-04-25 12:47:46'),(74,309,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:49:35','2018-04-25 12:49:35'),(75,310,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-04-25 12:52:19','2018-04-25 12:52:19'),(76,311,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 12:52:57','2018-04-25 12:52:57'),(77,312,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 12:56:20','2018-04-25 12:56:20'),(78,313,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:02:08','2018-04-25 13:02:08'),(79,314,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:06:13','2018-04-25 13:06:13'),(80,315,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:06:29','2018-04-25 13:06:29'),(81,316,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:07:25','2018-04-25 13:07:25'),(82,317,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:08:28','2018-04-25 13:08:28'),(83,318,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:09:07','2018-04-25 13:09:07'),(84,319,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:09:49','2018-04-25 13:09:49'),(85,320,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:10:36','2018-04-25 13:10:36'),(86,321,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:11:01','2018-04-25 13:11:01'),(87,322,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:11:20','2018-04-25 13:11:20'),(88,323,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:11:49','2018-04-25 13:11:49'),(89,324,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:12:20','2018-04-25 13:12:20'),(90,325,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:12:35','2018-04-25 13:12:35'),(91,326,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:13:11','2018-04-25 13:13:11'),(92,327,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:14:07','2018-04-25 13:14:07'),(93,328,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:15:04','2018-04-25 13:15:04'),(94,329,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:15:26','2018-04-25 13:15:26'),(95,330,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:15:42','2018-04-25 13:15:42'),(96,331,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:16:03','2018-04-25 13:16:03'),(97,332,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:16:21','2018-04-25 13:16:21'),(98,333,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:16:41','2018-04-25 13:16:41'),(99,334,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:17:14','2018-04-25 13:17:14'),(100,335,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-04-25 13:23:17','2018-04-25 13:23:17'),(101,336,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:25:27','2018-04-25 13:25:27'),(102,337,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:25:38','2018-04-25 13:25:38'),(103,338,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:26:02','2018-04-25 13:26:02'),(104,339,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-25 13:26:33','2018-04-25 13:26:33'),(105,340,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-25 13:26:49','2018-04-25 13:26:49'),(106,341,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 06:31:52','2018-04-27 06:31:52'),(107,342,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 06:32:18','2018-04-27 06:32:18'),(108,343,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 07:46:51','2018-04-27 07:46:51'),(109,344,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 08:30:32','2018-04-27 08:30:32'),(110,345,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 08:31:47','2018-04-27 08:31:47'),(111,346,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 08:36:04','2018-04-27 08:36:04'),(112,347,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 08:36:47','2018-04-27 08:36:47'),(113,348,2,4,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-04-27 08:38:07','2018-04-27 11:50:57'),(114,349,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 10:32:26','2018-04-27 10:32:26'),(115,350,2,5,1,72.0000,79.2000,0.0000,1,'',NULL,'2018-04-27 10:46:53','2018-04-27 11:43:37'),(116,351,28,71,1,12.5000,13.7500,0.0000,1,'',NULL,'2018-04-27 10:47:15','2018-04-27 11:46:24'),(117,352,2,5,1,72.0000,79.2000,0.0000,1,'',NULL,'2018-04-27 10:49:20','2018-04-27 11:44:06'),(118,353,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 11:13:35','2018-04-27 11:13:35'),(119,354,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 11:14:44','2018-04-27 11:14:44'),(120,355,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 11:17:17','2018-04-27 11:17:17'),(121,356,28,71,1,12.5000,13.7500,0.0000,1,'',NULL,'2018-04-27 11:17:36','2018-04-27 11:23:08'),(122,357,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-04-27 12:45:09','2018-04-27 12:45:09'),(123,357,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-04-27 12:45:09','2018-04-27 12:45:09'),(124,358,2,5,1,72.0000,79.2000,0.0000,1,'',NULL,'2018-04-27 12:45:56','2018-04-27 13:06:28'),(125,359,2,4,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-04-27 12:49:57','2018-04-27 13:05:43'),(126,360,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-04-27 12:53:28','2018-04-27 12:53:28'),(127,361,293,473,1,12500.0000,12500.0000,0.0000,NULL,'',NULL,'2018-04-30 13:34:25','2018-04-30 13:34:25'),(128,362,2,5,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-01 05:25:06','2018-05-01 05:51:02'),(129,363,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-01 05:52:35','2018-05-01 05:52:35'),(130,364,2,4,1,77.0000,77.0000,0.0000,NULL,'',NULL,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(131,366,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-01 12:06:02','2018-05-01 12:06:02'),(132,367,2,4,1,77.0000,77.0000,0.0000,NULL,'',NULL,'2018-05-01 12:49:49','2018-05-01 12:49:49'),(133,368,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-01 12:52:29','2018-05-01 12:52:29'),(134,369,195,278,1,125.0000,125.0000,0.0000,NULL,'test',NULL,'2018-05-02 05:36:29','2018-05-02 05:36:29'),(137,372,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 06:51:08','2018-05-02 06:51:08'),(138,373,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 06:52:34','2018-05-02 06:52:34'),(142,377,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 07:01:31','2018-05-02 07:01:31'),(143,378,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-02 07:23:36','2018-05-02 07:23:36'),(144,379,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 07:24:31','2018-05-02 07:24:31'),(145,380,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-02 07:25:55','2018-05-02 07:25:55'),(146,381,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 07:26:10','2018-05-02 07:26:10'),(147,382,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(148,383,195,278,1,125.0000,125.0000,0.0000,NULL,'qwqw',NULL,'2018-05-02 07:29:27','2018-05-02 07:42:22'),(149,383,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 07:42:22','2018-05-02 07:42:22'),(150,384,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 07:44:08','2018-05-02 07:47:54'),(151,385,2,5,1,72.0000,79.2000,0.0000,1,'',NULL,'2018-05-02 08:13:48','2018-05-02 08:26:02'),(152,386,2,3,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-02 08:33:15','2018-05-02 08:37:05'),(153,387,2,4,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-02 08:37:47','2018-05-02 08:38:25'),(154,388,195,278,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-02 08:39:07','2018-05-02 08:39:41'),(155,389,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(156,390,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(157,391,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(158,392,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(159,393,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(160,394,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(161,395,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(162,396,80,160,1,136.3600,150.0000,13.6400,1,'IMEI: 201967',NULL,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(163,397,80,161,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(164,398,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(165,399,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(166,400,80,160,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(167,401,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(168,401,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(169,402,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(170,403,71,132,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(171,404,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(172,405,2,4,1,77.0000,84.7000,7.7000,1,'',NULL,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(173,406,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 07:38:23','2018-05-07 07:38:23'),(174,407,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(175,408,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(176,409,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(177,410,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(178,411,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(179,412,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(180,413,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(181,414,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(182,415,2,5,2,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(183,416,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(184,417,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(185,418,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(186,419,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:15:32','2018-05-07 08:15:32'),(187,420,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(188,421,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(189,422,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(190,423,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(191,424,2,6,10,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 12:19:10','2018-05-07 12:19:10'),(192,425,2,5,10,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-07 12:22:07','2018-05-07 12:22:07'),(193,426,2,6,6,5.9400,6.3000,0.3600,6,'',NULL,'2018-05-10 10:54:25','2018-05-10 10:54:25'),(194,427,2,3,6,5.9400,6.3000,0.3600,6,'',NULL,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(195,428,2,4,6,5.9400,6.3000,0.3600,6,'',NULL,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(196,429,2,6,6,5.9400,6.2900,0.3500,6,'',NULL,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(197,430,2,3,6,5.9400,6.2960,0.3560,6,'',NULL,'2018-05-10 11:24:24','2018-05-10 11:26:36'),(198,431,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-10 12:54:15','2018-05-10 12:54:15'),(199,432,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(200,433,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(201,435,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-11 12:23:31','2018-05-11 12:23:31'),(202,436,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(203,437,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-11 12:34:58','2018-05-11 12:34:58'),(204,438,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(205,439,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(206,440,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-11 14:43:26','2018-05-11 14:43:26'),(207,441,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:08:02','2018-05-12 06:08:02'),(208,442,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(209,443,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(210,444,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(211,445,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(212,446,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(213,447,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(214,448,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(215,449,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(216,450,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(217,451,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(218,452,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(219,453,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(220,454,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(221,455,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(222,456,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(223,457,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(224,458,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(225,459,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(226,460,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(227,461,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(228,462,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(229,463,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(230,464,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(231,465,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(232,466,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(233,467,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(234,468,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(235,469,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(236,470,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(237,471,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(238,472,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(239,473,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(240,474,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(241,475,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(242,476,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(243,477,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(244,478,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(245,479,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(246,480,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(247,481,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(248,482,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(249,483,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(250,484,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(251,485,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(252,486,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(253,487,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(254,488,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(255,489,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(256,490,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(257,491,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(258,492,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(259,493,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(260,494,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(261,495,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(262,496,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(263,497,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(264,498,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(265,499,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(266,500,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(267,500,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(268,501,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(269,501,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(270,502,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(271,502,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(272,503,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(273,503,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(274,504,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(275,505,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(276,505,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(277,506,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(278,507,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(279,508,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(280,509,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(281,510,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(282,510,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(283,511,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(284,511,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(285,512,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(286,512,81,164,1,162.5000,162.5000,0.0000,NULL,'Serial No: 12345',NULL,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(287,513,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(288,513,81,164,1,162.5000,162.5000,0.0000,NULL,'IMEI: 123456',NULL,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(289,514,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(290,514,81,164,1,162.5000,162.5000,0.0000,NULL,'IMEI: 123456',NULL,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(291,515,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(292,515,81,164,1,162.5000,162.5000,0.0000,NULL,'IMEI: 123456',NULL,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(293,516,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(294,516,28,71,1,12.7300,13.7500,1.0200,3,'',NULL,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(295,516,81,164,1,162.5000,162.5000,0.0000,NULL,'IMEI 123456',NULL,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(296,517,81,164,1,162.5000,162.5000,0.0000,NULL,'IMEI: 123456',NULL,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(297,517,2,3,1,70.0000,77.0000,7.0000,2,'',NULL,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(298,517,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(299,518,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(300,518,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(301,519,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(302,519,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(303,520,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(304,520,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(305,521,2,3,1,70.0000,77.0000,7.0000,2,'',NULL,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(306,521,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(307,521,81,164,1,70.0000,77.0000,7.0000,2,'',NULL,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(308,522,2,4,2,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-14 05:39:01','2018-05-14 05:39:01'),(309,523,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(310,523,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(311,524,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(312,524,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(313,525,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(314,526,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(315,527,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(316,528,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(317,528,81,163,1,150.0000,150.0000,0.0000,NULL,'IMEI: 1234567890',NULL,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(318,529,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:47:22','2018-05-14 05:47:22'),(319,530,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(320,530,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(321,531,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(322,536,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 08:34:21','2018-05-15 08:34:21'),(323,537,296,476,1,1250.0000,1250.0000,0.0000,NULL,'',NULL,'2018-05-15 08:34:51','2018-05-15 08:34:51'),(324,538,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 10:50:18','2018-05-15 10:50:18'),(325,539,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 10:51:52','2018-05-15 10:51:52'),(326,540,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(327,541,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 11:38:37','2018-05-15 11:38:37'),(328,542,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(329,543,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(330,544,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(331,545,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(332,546,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(333,547,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(334,548,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(335,549,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(336,549,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(337,549,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(338,549,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(339,549,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(340,549,296,476,1,1250.0000,1250.0000,0.0000,NULL,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(341,549,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(342,549,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(343,549,81,162,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-15 12:30:03','2018-05-15 12:30:03'),(344,550,2,5,2,72.0000,79.2000,0.0000,1,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(345,550,2,2,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(346,550,2,3,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(347,550,2,4,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(348,550,2,6,1,72.0000,79.2000,0.0000,1,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(349,550,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(350,550,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(351,550,81,162,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(352,550,80,161,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(353,550,80,160,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(354,550,80,159,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(355,550,71,134,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(356,550,71,133,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(357,551,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 06:08:58','2018-05-16 06:08:58'),(358,551,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(359,552,2,3,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-16 06:19:26','2018-05-16 06:39:44'),(360,552,28,71,1,12.5000,13.7500,0.0000,1,'',NULL,'2018-05-16 06:19:26','2018-05-16 06:39:44'),(361,552,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-16 06:19:26','2018-05-16 06:39:44'),(362,553,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(363,554,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(364,555,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(365,556,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(366,556,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(367,557,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(368,557,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(369,558,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(370,558,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(371,559,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(372,559,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(373,560,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(374,560,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(375,561,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(376,562,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(377,563,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(378,564,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 07:48:03','2018-05-16 07:48:03'),(379,565,2,2,1,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-16 07:58:28','2018-05-16 08:13:31'),(380,570,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(381,571,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(382,572,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(383,573,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(384,574,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(385,575,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 12:55:07','2018-05-16 12:55:07'),(386,576,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(387,577,2,5,2,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(388,577,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(389,577,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(390,577,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(391,577,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(392,577,28,71,1,12.5000,13.7500,1.2500,1,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(393,577,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(394,577,71,132,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(395,577,71,133,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(396,577,71,134,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(397,577,80,159,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(398,577,80,160,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(399,577,80,161,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(400,577,81,162,1,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(401,577,81,163,1,150.0000,150.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(402,577,81,164,1,162.5000,162.5000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(403,577,312,486,1,1320.0000,1320.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(404,577,313,487,1,1320.0000,1320.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(405,577,314,488,1,1320.0000,1320.0000,0.0000,NULL,'',NULL,'2018-05-17 11:19:00','2018-05-17 11:19:00'),(406,578,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(407,579,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(408,580,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(409,598,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-19 07:30:47','2018-05-19 07:30:47'),(410,599,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(411,600,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(412,614,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(413,615,2,2,5,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(414,619,315,489,50,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(415,621,315,489,40,125.0000,125.0000,0.0000,NULL,'',NULL,'2018-05-21 12:19:53','2018-05-21 12:19:53'),(416,629,2,2,6,70.0000,77.0000,0.0000,1,'',NULL,'2018-05-21 13:52:53','2018-05-24 07:09:00'),(417,630,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-24 07:23:05','2018-05-24 07:23:05'),(418,631,2,3,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(419,632,2,5,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(420,633,2,6,1,72.0000,79.2000,7.2000,1,'',NULL,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(421,634,2,2,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(422,635,2,3,3,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-25 10:50:55','2018-05-25 10:50:55'),(423,636,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(424,638,2,4,1,70.0000,77.0000,7.0000,1,'',NULL,'2018-05-30 12:16:40','2018-05-30 12:16:40'),(438,645,2,5,1,72.0000,79.2000,7.2000,1,'','[]','2018-05-30 14:01:15','2018-05-30 14:01:15'),(439,646,2,6,1,72.0000,79.2000,7.2000,1,'','[]','2018-05-30 14:02:13','2018-05-30 14:02:13'),(440,648,2,2,1,70.0000,77.0000,7.0000,1,'','[{\"id\":\"2\",\"price\":17},{\"id\":\"3\",\"price\":10}]','2018-05-30 14:03:52','2018-05-30 14:03:52'),(441,650,2,5,1,72.0000,79.2000,7.2000,1,'','[{\"id\":\"1\",\"price\":10},{\"id\":\"3\",\"price\":10},{\"id\":\"5\",\"price\":10}]','2018-05-31 05:04:09','2018-05-31 05:04:09');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=402 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,1,NULL,2,10.00,'2018-04-19 13:22:25','2018-04-19 13:22:25'),(2,2,NULL,9,30.00,'2018-04-19 13:22:25','2018-04-19 13:22:25'),(3,3,NULL,2,50.00,'2018-04-19 13:22:26','2018-04-19 13:22:26'),(4,4,NULL,1,50.00,'2018-04-19 13:22:26','2018-04-19 13:22:26'),(5,5,NULL,8,60.00,'2018-04-19 13:22:26','2018-04-19 13:22:26'),(6,6,NULL,7,30.00,'2018-04-19 13:22:27','2018-04-19 13:22:27'),(7,7,NULL,10,10.00,'2018-04-19 13:22:27','2018-04-19 13:22:27'),(8,8,NULL,11,7.00,'2018-04-19 13:22:27','2018-04-19 13:22:27'),(9,9,NULL,13,27.00,'2018-04-19 13:22:27','2018-04-19 13:22:27'),(10,10,NULL,18,5.00,'2018-04-19 13:22:27','2018-04-19 13:22:27'),(11,11,NULL,17,20.00,'2018-04-19 13:22:28','2018-04-19 13:22:28'),(12,12,NULL,15,1.00,'2018-04-19 13:22:28','2018-04-19 13:22:28'),(13,13,NULL,15,25.00,'2018-04-19 13:22:28','2018-04-19 13:22:28'),(14,14,NULL,19,20.00,'2018-04-19 13:22:28','2018-04-19 13:22:28'),(15,23,NULL,20,5.00,'2018-04-20 10:53:18','2018-04-20 10:53:18'),(16,24,NULL,4,2.00,'2018-04-23 12:39:06','2018-04-23 12:39:06'),(17,25,NULL,3,1.00,'2018-04-24 05:31:36','2018-04-24 05:31:36'),(18,30,NULL,3,1.00,'2018-04-24 05:33:42','2018-04-24 05:33:42'),(19,31,NULL,7,1.00,'2018-04-24 05:55:44','2018-04-24 05:55:44'),(20,32,NULL,3,2.00,'2018-04-24 07:35:45','2018-04-24 07:35:45'),(21,33,NULL,5,10.00,'2018-04-24 07:35:45','2018-04-24 07:35:45'),(22,33,NULL,5,9.00,'2018-04-24 07:37:42','2018-04-24 07:37:42'),(23,34,NULL,7,1.00,'2018-04-24 10:36:45','2018-04-24 10:36:45'),(24,35,NULL,4,1.00,'2018-04-24 10:39:50','2018-04-24 10:39:50'),(25,36,NULL,4,1.00,'2018-04-24 10:43:06','2018-04-24 10:43:06'),(26,37,NULL,4,1.00,'2018-04-24 10:43:12','2018-04-24 10:43:12'),(27,38,NULL,4,1.00,'2018-04-24 10:44:21','2018-04-24 10:44:21'),(28,39,NULL,4,1.00,'2018-04-24 10:44:57','2018-04-24 10:44:57'),(29,40,NULL,4,1.00,'2018-04-24 10:45:30','2018-04-24 10:45:30'),(30,41,NULL,4,1.00,'2018-04-24 10:46:09','2018-04-24 10:46:09'),(31,42,NULL,4,1.00,'2018-04-24 10:46:27','2018-04-24 10:46:27'),(32,43,NULL,4,1.00,'2018-04-24 10:47:15','2018-04-24 10:47:15'),(33,44,NULL,4,1.00,'2018-04-24 10:47:29','2018-04-24 10:47:29'),(34,45,NULL,4,1.00,'2018-04-24 10:47:52','2018-04-24 10:47:52'),(35,46,NULL,4,1.00,'2018-04-24 10:49:21','2018-04-24 10:49:21'),(36,47,NULL,4,1.00,'2018-04-24 10:49:45','2018-04-24 10:49:45'),(37,48,NULL,4,1.00,'2018-04-24 10:49:54','2018-04-24 10:49:54'),(38,49,NULL,4,1.00,'2018-04-24 10:50:30','2018-04-24 10:50:30'),(39,50,NULL,3,1.00,'2018-04-24 10:52:02','2018-04-24 10:52:02'),(40,51,NULL,4,1.00,'2018-04-24 10:53:05','2018-04-24 10:53:05'),(41,52,NULL,4,1.00,'2018-04-24 10:54:03','2018-04-24 10:54:03'),(42,53,NULL,4,1.00,'2018-04-24 10:56:14','2018-04-24 10:56:14'),(43,54,NULL,7,1.00,'2018-04-24 10:56:34','2018-04-24 10:56:34'),(44,55,NULL,3,20.00,'2018-04-24 13:20:52','2018-04-24 13:20:52'),(45,56,NULL,4,10.00,'2018-04-25 10:42:06','2018-04-25 10:42:06'),(46,57,NULL,3,1.00,'2018-04-25 12:18:43','2018-04-25 12:18:43'),(47,58,NULL,3,1.00,'2018-04-25 12:30:27','2018-04-25 12:30:27'),(48,59,NULL,3,1.00,'2018-04-25 12:31:09','2018-04-25 12:31:09'),(49,60,NULL,3,1.00,'2018-04-25 12:32:16','2018-04-25 12:32:16'),(50,61,NULL,3,1.00,'2018-04-25 12:32:46','2018-04-25 12:32:46'),(51,62,NULL,3,1.00,'2018-04-25 12:33:14','2018-04-25 12:33:14'),(52,63,NULL,4,1.00,'2018-04-25 12:34:16','2018-04-25 12:34:16'),(53,64,NULL,3,1.00,'2018-04-25 12:34:44','2018-04-25 12:34:44'),(54,65,NULL,4,1.00,'2018-04-25 12:35:41','2018-04-25 12:35:41'),(55,66,NULL,3,1.00,'2018-04-25 12:35:59','2018-04-25 12:35:59'),(56,67,NULL,4,1.00,'2018-04-25 12:36:40','2018-04-25 12:36:40'),(57,68,NULL,3,1.00,'2018-04-25 12:39:08','2018-04-25 12:39:08'),(58,69,NULL,4,1.00,'2018-04-25 12:40:09','2018-04-25 12:40:09'),(59,70,NULL,144,1.00,'2018-04-25 12:41:02','2018-04-25 12:41:02'),(60,71,NULL,4,1.00,'2018-04-25 12:42:42','2018-04-25 12:42:42'),(61,72,NULL,4,1.00,'2018-04-25 12:46:42','2018-04-25 12:46:42'),(62,73,NULL,3,1.00,'2018-04-25 12:47:46','2018-04-25 12:47:46'),(63,74,NULL,3,1.00,'2018-04-25 12:49:35','2018-04-25 12:49:35'),(64,75,NULL,7,1.00,'2018-04-25 12:52:19','2018-04-25 12:52:19'),(65,76,NULL,3,1.00,'2018-04-25 12:52:57','2018-04-25 12:52:57'),(66,77,NULL,4,1.00,'2018-04-25 12:56:20','2018-04-25 12:56:20'),(67,78,NULL,3,1.00,'2018-04-25 13:02:08','2018-04-25 13:02:08'),(68,79,NULL,4,1.00,'2018-04-25 13:06:13','2018-04-25 13:06:13'),(69,80,NULL,3,1.00,'2018-04-25 13:06:29','2018-04-25 13:06:29'),(70,81,NULL,4,1.00,'2018-04-25 13:07:25','2018-04-25 13:07:25'),(71,82,NULL,3,1.00,'2018-04-25 13:08:28','2018-04-25 13:08:28'),(72,83,NULL,4,1.00,'2018-04-25 13:09:07','2018-04-25 13:09:07'),(73,84,NULL,4,1.00,'2018-04-25 13:09:49','2018-04-25 13:09:49'),(74,85,NULL,3,1.00,'2018-04-25 13:10:36','2018-04-25 13:10:36'),(75,86,NULL,3,1.00,'2018-04-25 13:11:01','2018-04-25 13:11:01'),(76,87,NULL,4,1.00,'2018-04-25 13:11:21','2018-04-25 13:11:21'),(77,88,NULL,3,1.00,'2018-04-25 13:11:49','2018-04-25 13:11:49'),(78,89,NULL,4,1.00,'2018-04-25 13:12:21','2018-04-25 13:12:21'),(79,90,NULL,3,1.00,'2018-04-25 13:12:35','2018-04-25 13:12:35'),(80,91,NULL,4,1.00,'2018-04-25 13:13:11','2018-04-25 13:13:11'),(81,92,NULL,3,1.00,'2018-04-25 13:14:07','2018-04-25 13:14:07'),(82,93,NULL,4,1.00,'2018-04-25 13:15:04','2018-04-25 13:15:04'),(83,94,NULL,3,1.00,'2018-04-25 13:15:26','2018-04-25 13:15:26'),(84,95,NULL,4,1.00,'2018-04-25 13:15:42','2018-04-25 13:15:42'),(85,96,NULL,3,1.00,'2018-04-25 13:16:03','2018-04-25 13:16:03'),(86,97,NULL,4,1.00,'2018-04-25 13:16:21','2018-04-25 13:16:21'),(87,98,NULL,3,1.00,'2018-04-25 13:16:41','2018-04-25 13:16:41'),(88,99,NULL,4,1.00,'2018-04-25 13:17:14','2018-04-25 13:17:14'),(89,100,NULL,144,1.00,'2018-04-25 13:23:17','2018-04-25 13:23:17'),(90,101,NULL,3,1.00,'2018-04-25 13:25:27','2018-04-25 13:25:27'),(91,102,NULL,4,1.00,'2018-04-25 13:25:38','2018-04-25 13:25:38'),(92,103,NULL,3,1.00,'2018-04-25 13:26:02','2018-04-25 13:26:02'),(93,104,NULL,4,1.00,'2018-04-25 13:26:33','2018-04-25 13:26:33'),(94,105,NULL,3,1.00,'2018-04-25 13:26:49','2018-04-25 13:26:49'),(95,106,NULL,4,1.00,'2018-04-27 06:31:52','2018-04-27 06:31:52'),(96,107,NULL,3,1.00,'2018-04-27 06:32:18','2018-04-27 06:32:18'),(97,108,NULL,4,1.00,'2018-04-27 07:46:51','2018-04-27 07:46:51'),(98,114,NULL,3,1.00,'2018-04-27 10:32:26','2018-04-27 10:32:26'),(100,116,NULL,7,1.00,'2018-04-27 11:46:24','2018-04-27 11:46:24'),(101,113,NULL,3,1.00,'2018-04-27 11:50:57','2018-04-27 11:50:57'),(102,125,NULL,3,1.00,'2018-04-27 13:05:43','2018-04-27 13:05:43'),(103,124,NULL,4,1.00,'2018-04-27 13:06:28','2018-04-27 13:06:28'),(104,128,NULL,4,1.00,'2018-05-01 05:25:06','2018-05-01 05:25:06'),(105,129,NULL,4,1.00,'2018-05-01 05:52:35','2018-05-01 05:52:35'),(106,130,NULL,3,1.00,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(107,131,NULL,4,1.00,'2018-05-01 12:06:02','2018-05-01 12:06:02'),(108,132,NULL,3,1.00,'2018-05-01 12:49:50','2018-05-01 12:49:50'),(109,133,NULL,4,1.00,'2018-05-01 12:52:29','2018-05-01 12:52:29'),(110,134,NULL,144,1.00,'2018-05-02 05:36:29','2018-05-02 05:36:29'),(111,137,NULL,3,1.00,'2018-05-02 06:51:08','2018-05-02 06:51:08'),(112,138,NULL,144,1.00,'2018-05-02 06:52:34','2018-05-02 06:52:34'),(113,142,NULL,144,1.00,'2018-05-02 07:01:31','2018-05-02 07:01:31'),(114,143,NULL,4,1.00,'2018-05-02 07:23:36','2018-05-02 07:23:36'),(115,144,NULL,3,1.00,'2018-05-02 07:24:31','2018-05-02 07:24:31'),(116,145,NULL,4,1.00,'2018-05-02 07:25:55','2018-05-02 07:25:55'),(117,146,NULL,3,1.00,'2018-05-02 07:26:10','2018-05-02 07:26:10'),(118,147,NULL,144,1.00,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(119,148,NULL,144,1.00,'2018-05-02 07:29:27','2018-05-02 07:29:27'),(120,149,NULL,144,1.00,'2018-05-02 07:42:22','2018-05-02 07:42:22'),(121,150,NULL,144,1.00,'2018-05-02 07:44:08','2018-05-02 07:44:08'),(122,151,NULL,4,1.00,'2018-05-02 08:13:48','2018-05-02 08:13:48'),(123,152,NULL,2,1.00,'2018-05-02 08:33:15','2018-05-02 08:33:15'),(124,153,NULL,3,1.00,'2018-05-02 08:37:47','2018-05-02 08:37:47'),(125,154,NULL,144,1.00,'2018-05-02 08:39:07','2018-05-02 08:39:07'),(126,155,NULL,2,1.00,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(127,156,NULL,4,1.00,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(128,157,NULL,3,1.00,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(129,158,NULL,2,1.00,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(130,159,NULL,3,1.00,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(131,160,NULL,2,1.00,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(132,161,NULL,4,1.00,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(133,162,NULL,26,1.00,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(134,163,NULL,27,1.00,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(135,164,NULL,30,1.00,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(136,165,NULL,4,1.00,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(137,166,NULL,26,1.00,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(138,167,NULL,3,1.00,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(139,168,NULL,7,1.00,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(140,169,NULL,4,1.00,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(141,170,NULL,21,1.00,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(142,171,NULL,2,1.00,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(143,172,NULL,3,1.00,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(144,173,NULL,4,1.00,'2018-05-07 07:38:23','2018-05-07 07:38:23'),(145,174,NULL,2,1.00,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(146,175,NULL,3,1.00,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(147,176,NULL,4,1.00,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(148,177,NULL,4,1.00,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(149,178,NULL,2,1.00,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(150,179,NULL,3,1.00,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(151,180,NULL,2,1.00,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(152,181,NULL,3,1.00,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(153,182,NULL,4,2.00,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(154,183,NULL,2,1.00,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(155,184,NULL,3,1.00,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(156,185,NULL,5,1.00,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(157,186,NULL,2,1.00,'2018-05-07 08:15:33','2018-05-07 08:15:33'),(158,187,NULL,3,1.00,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(159,188,NULL,4,1.00,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(160,189,NULL,2,1.00,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(161,190,NULL,3,1.00,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(162,192,NULL,4,10.00,'2018-05-07 12:22:07','2018-05-07 12:22:07'),(163,193,NULL,5,6.00,'2018-05-10 10:54:26','2018-05-10 10:54:26'),(164,194,NULL,2,6.00,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(165,195,NULL,3,6.00,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(166,196,NULL,5,6.00,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(167,197,NULL,2,6.00,'2018-05-10 11:24:25','2018-05-10 11:24:25'),(168,198,NULL,3,1.00,'2018-05-10 12:54:16','2018-05-10 12:54:16'),(169,199,NULL,3,1.00,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(170,200,NULL,3,1.00,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(171,201,NULL,3,1.00,'2018-05-11 12:23:32','2018-05-11 12:23:32'),(172,202,NULL,4,1.00,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(173,203,NULL,4,1.00,'2018-05-11 12:34:58','2018-05-11 12:34:58'),(174,204,NULL,3,1.00,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(175,205,NULL,3,1.00,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(176,206,NULL,4,1.00,'2018-05-11 14:43:27','2018-05-11 14:43:27'),(177,207,NULL,5,1.00,'2018-05-12 06:08:03','2018-05-12 06:08:03'),(178,208,NULL,2,1.00,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(179,209,NULL,3,1.00,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(180,210,NULL,4,1.00,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(181,211,NULL,5,1.00,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(182,212,NULL,5,1.00,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(183,213,NULL,2,1.00,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(184,214,NULL,3,1.00,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(185,215,NULL,4,1.00,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(186,216,NULL,5,1.00,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(187,217,NULL,2,1.00,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(188,218,NULL,4,1.00,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(189,219,NULL,3,1.00,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(190,220,NULL,4,1.00,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(191,221,NULL,2,1.00,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(192,222,NULL,5,1.00,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(193,223,NULL,3,1.00,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(194,224,NULL,2,1.00,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(195,225,NULL,3,1.00,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(196,226,NULL,4,1.00,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(197,227,NULL,5,1.00,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(198,228,NULL,2,1.00,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(199,229,NULL,3,1.00,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(200,230,NULL,4,1.00,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(201,231,NULL,5,1.00,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(202,232,NULL,2,1.00,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(203,233,NULL,3,1.00,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(204,234,NULL,4,1.00,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(205,235,NULL,5,1.00,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(206,236,NULL,2,1.00,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(207,237,NULL,3,1.00,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(208,238,NULL,4,1.00,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(209,239,NULL,5,1.00,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(210,240,NULL,2,1.00,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(211,241,NULL,3,1.00,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(212,242,NULL,4,1.00,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(213,243,NULL,5,1.00,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(214,244,NULL,2,1.00,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(215,245,NULL,3,1.00,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(216,246,NULL,4,1.00,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(217,247,NULL,5,1.00,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(218,248,NULL,2,1.00,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(219,249,NULL,3,1.00,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(220,250,NULL,4,1.00,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(221,251,NULL,5,1.00,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(222,252,NULL,2,1.00,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(223,253,NULL,3,1.00,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(224,254,NULL,4,1.00,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(225,255,NULL,5,1.00,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(226,256,NULL,3,1.00,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(227,257,NULL,4,1.00,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(228,258,NULL,5,1.00,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(229,259,NULL,2,1.00,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(230,260,NULL,2,1.00,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(231,261,NULL,3,1.00,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(232,262,NULL,4,1.00,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(233,263,NULL,5,1.00,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(234,264,NULL,2,1.00,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(235,265,NULL,3,1.00,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(236,266,NULL,4,1.00,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(237,267,NULL,2,1.00,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(238,268,NULL,5,1.00,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(239,269,NULL,7,1.00,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(240,270,NULL,3,1.00,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(241,271,NULL,7,1.00,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(242,272,NULL,5,1.00,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(243,273,NULL,7,1.00,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(244,274,NULL,4,1.00,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(245,275,NULL,2,1.00,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(246,276,NULL,7,1.00,'2018-05-12 11:54:26','2018-05-12 11:54:26'),(247,277,NULL,3,1.00,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(248,278,NULL,4,1.00,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(249,279,NULL,5,1.00,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(250,280,NULL,1,1.00,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(251,281,NULL,2,1.00,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(252,282,NULL,7,1.00,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(253,283,NULL,3,1.00,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(254,284,NULL,7,1.00,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(255,285,NULL,4,1.00,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(256,286,NULL,30,1.00,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(257,287,NULL,5,1.00,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(258,288,NULL,30,1.00,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(259,289,NULL,5,1.00,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(260,290,NULL,30,1.00,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(261,291,NULL,7,1.00,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(262,292,NULL,30,1.00,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(263,293,NULL,1,1.00,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(264,294,NULL,7,1.00,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(265,295,NULL,30,1.00,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(266,296,NULL,30,1.00,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(267,297,NULL,2,1.00,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(268,298,NULL,7,1.00,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(269,299,NULL,7,1.00,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(270,300,NULL,3,1.00,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(271,301,NULL,4,1.00,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(272,302,NULL,30,1.00,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(273,303,NULL,1,1.00,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(274,304,NULL,30,1.00,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(275,305,NULL,2,1.00,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(276,306,NULL,7,1.00,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(277,307,NULL,30,1.00,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(278,308,NULL,3,2.00,'2018-05-14 05:39:02','2018-05-14 05:39:02'),(279,309,NULL,4,1.00,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(280,310,NULL,29,1.00,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(281,311,NULL,5,1.00,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(282,312,NULL,30,1.00,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(283,313,NULL,1,1.00,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(284,314,NULL,2,1.00,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(285,315,NULL,4,1.00,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(286,316,NULL,5,1.00,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(287,317,NULL,29,1.00,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(288,318,NULL,4,1.00,'2018-05-14 05:47:22','2018-05-14 05:47:22'),(289,319,NULL,5,1.00,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(290,320,NULL,30,1.00,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(291,321,NULL,1,1.00,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(292,322,NULL,2,1.00,'2018-05-15 08:34:21','2018-05-15 08:34:21'),(293,324,NULL,3,1.00,'2018-05-15 10:50:19','2018-05-15 10:50:19'),(294,325,NULL,1,1.00,'2018-05-15 10:51:53','2018-05-15 10:51:53'),(295,326,NULL,2,1.00,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(296,327,NULL,3,1.00,'2018-05-15 11:38:38','2018-05-15 11:38:38'),(297,328,NULL,4,1.00,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(298,329,NULL,5,1.00,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(299,330,NULL,1,1.00,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(300,331,NULL,5,1.00,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(301,332,NULL,4,1.00,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(302,333,NULL,2,1.00,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(303,334,NULL,3,1.00,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(304,335,NULL,1,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(305,336,NULL,2,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(306,337,NULL,3,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(307,338,NULL,4,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(308,339,NULL,5,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(309,341,NULL,30,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(310,342,NULL,29,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(311,343,NULL,28,1.00,'2018-05-15 12:30:04','2018-05-15 12:30:04'),(312,344,NULL,4,2.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(313,345,NULL,1,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(314,346,NULL,2,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(315,347,NULL,3,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(316,348,NULL,5,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(317,349,NULL,30,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(318,350,NULL,29,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(319,351,NULL,28,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(320,352,NULL,27,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(321,353,NULL,26,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(322,354,NULL,25,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(323,355,NULL,23,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(324,356,NULL,22,1.00,'2018-05-15 12:31:15','2018-05-15 12:31:15'),(325,357,NULL,1,1.00,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(326,358,NULL,7,1.00,'2018-05-16 06:08:59','2018-05-16 06:08:59'),(327,359,NULL,2,1.00,'2018-05-16 06:19:26','2018-05-16 06:19:26'),(328,360,NULL,7,1.00,'2018-05-16 06:19:26','2018-05-16 06:19:26'),(329,361,NULL,29,1.00,'2018-05-16 06:19:26','2018-05-16 06:19:26'),(330,362,NULL,5,1.00,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(331,363,NULL,3,1.00,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(332,364,NULL,3,1.00,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(333,365,NULL,1,1.00,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(334,366,NULL,7,1.00,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(335,367,NULL,1,1.00,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(336,368,NULL,7,1.00,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(337,369,NULL,5,1.00,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(338,370,NULL,30,1.00,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(339,371,NULL,5,1.00,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(340,372,NULL,30,1.00,'2018-05-16 07:39:15','2018-05-16 07:39:15'),(341,373,NULL,2,1.00,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(342,374,NULL,7,1.00,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(343,375,NULL,4,1.00,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(344,376,NULL,2,1.00,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(345,377,NULL,3,1.00,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(346,378,NULL,4,1.00,'2018-05-16 07:48:03','2018-05-16 07:48:03'),(347,379,NULL,1,1.00,'2018-05-16 07:58:28','2018-05-16 07:58:28'),(348,380,NULL,2,1.00,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(349,381,NULL,3,1.00,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(350,382,NULL,4,1.00,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(351,383,NULL,5,1.00,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(352,384,NULL,3,1.00,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(353,385,NULL,1,1.00,'2018-05-16 12:55:08','2018-05-16 12:55:08'),(354,386,NULL,2,1.00,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(355,387,NULL,4,2.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(356,388,NULL,1,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(357,389,NULL,2,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(358,390,NULL,3,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(359,391,NULL,5,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(360,392,NULL,7,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(361,393,NULL,29,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(362,394,NULL,21,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(363,395,NULL,22,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(364,396,NULL,23,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(365,397,NULL,25,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(366,398,NULL,26,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(367,399,NULL,27,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(368,400,NULL,28,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(369,401,NULL,29,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(370,402,NULL,30,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(371,403,NULL,352,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(372,404,NULL,351,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(373,405,NULL,353,1.00,'2018-05-17 11:19:01','2018-05-17 11:19:01'),(374,406,NULL,5,1.00,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(375,407,NULL,1,1.00,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(376,408,NULL,3,1.00,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(377,409,NULL,1,1.00,'2018-05-19 07:30:48','2018-05-19 07:30:48'),(378,410,NULL,1,1.00,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(379,411,NULL,1,1.00,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(380,412,NULL,1,1.00,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(381,413,NULL,1,5.00,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(382,414,NULL,388,50.00,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(383,415,NULL,388,40.00,'2018-05-21 12:19:53','2018-05-21 12:19:53'),(384,NULL,1,388,10.00,'2018-05-21 12:20:58','2018-05-21 12:20:58'),(385,NULL,1,389,40.00,'2018-05-21 12:20:58','2018-05-21 12:20:58'),(386,416,NULL,1,6.00,'2018-05-21 13:52:54','2018-05-21 13:52:54'),(387,417,NULL,1,1.00,'2018-05-24 07:23:06','2018-05-24 07:23:06'),(388,418,NULL,2,1.00,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(389,419,NULL,4,1.00,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(390,420,NULL,5,1.00,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(391,421,NULL,1,1.00,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(392,422,NULL,2,3.00,'2018-05-25 10:50:55','2018-05-25 10:50:55'),(393,423,NULL,3,1.00,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(394,424,NULL,3,1.00,'2018-05-30 12:16:41','2018-05-30 12:16:41'),(395,438,NULL,4,1.00,'2018-05-30 14:01:16','2018-05-30 14:01:16'),(396,439,NULL,5,1.00,'2018-05-30 14:02:13','2018-05-30 14:02:13'),(397,440,NULL,1,1.00,'2018-05-30 14:03:52','2018-05-30 14:03:52'),(398,441,NULL,4,1.00,'2018-05-31 05:04:10','2018-05-31 05:04:10'),(399,NULL,2,1,1.00,'2018-05-31 06:24:36','2018-05-31 06:24:36'),(400,NULL,3,1,1.00,'2018-05-31 06:25:08','2018-05-31 06:25:08'),(401,NULL,4,1,1.00,'2018-05-31 06:25:47','2018-05-31 06:25:47');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL,
  `res_waiter_id` int(10) unsigned DEFAULT NULL,
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('purchase','sell','expense','stock_adjustment','sell_transfer','purchase_transfer','opening_stock','sell_return') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('received','pending','ordered','draft','final') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(20,2) NOT NULL DEFAULT '0.00',
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `final_total` decimal(20,2) NOT NULL DEFAULT '0.00',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(20,2) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=660 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'35001BCVX','2018-04-04 18:52:12',50600.00,1,5060.00,NULL,'0',NULL,0.00,NULL,NULL,55660.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:27:11','2018-01-06 01:27:11'),(2,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,5,NULL,NULL,'35001BJGN','2018-04-04 18:52:12',77000.00,1,7700.00,NULL,'0',NULL,0.00,NULL,NULL,84700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:28:10','2018-01-06 01:28:10'),(3,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,6,NULL,NULL,'35001BCVJ','2018-03-20 18:52:12',5500.00,1,550.00,NULL,'0',NULL,0.00,NULL,NULL,6050.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:32:22','2018-05-02 05:38:45'),(4,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,6,NULL,NULL,'35001BCVK','2018-03-20 18:52:12',2000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:33:12','2018-01-06 01:33:12'),(5,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,6,NULL,NULL,'35001BCVD','2018-04-12 18:52:12',11000.00,1,1100.00,NULL,'0',NULL,0.00,NULL,NULL,12100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:35:26','2018-05-02 05:38:45'),(6,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0001','','2018-04-10 13:23:21',770.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,770.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:36:11','2018-01-06 01:36:11'),(7,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0002','','2018-04-17 18:52:12',825.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,825.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:36:31','2018-01-06 01:36:31'),(8,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,4,NULL,'AS0003','','2018-04-17 18:52:12',7700.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,7700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:37:22','2018-01-06 01:37:22'),(9,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0004','','2018-04-19 18:52:12',750.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,750.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:37:45','2018-01-06 01:37:45'),(10,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0005','','2018-04-19 18:52:12',412.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,412.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-01-06 01:38:03','2018-01-06 01:38:03'),(11,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,8,NULL,NULL,'56247065','2018-04-12 18:52:12',300.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:48:16','2018-04-10 04:48:47'),(12,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'547887025','2018-04-12 18:52:12',1200.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:49:40','2018-04-10 04:49:49'),(13,2,2,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,9,NULL,NULL,'45470025','2018-03-20 18:52:12',1350.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1350.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:50:41','2018-04-10 04:50:55'),(14,2,2,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,9,NULL,NULL,'65589898','2018-03-20 18:52:12',2160.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,2160.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:51:38','2018-04-10 04:52:10'),(15,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0001','','2018-04-17 18:52:12',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:53:35','2018-04-10 04:53:35'),(16,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0002','','2018-04-17 18:52:12',105.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,105.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:53:58','2018-04-10 04:53:58'),(17,2,2,NULL,NULL,NULL,'sell','final',0,'paid',NULL,7,NULL,'0003','','2018-04-19 18:52:12',405.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,405.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,4,'2018-04-10 04:54:21','2018-04-10 04:56:26'),(18,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,11,NULL,NULL,'548471117','2018-03-20 18:52:12',9630.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,9630.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:09:54','2018-04-10 06:10:02'),(19,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'548222220','2018-04-12 18:52:12',20000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,20000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:10:51','2018-04-10 06:10:58'),(20,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'878445524','2018-04-04 18:52:12',13500.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,13500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:11:45','2018-04-10 06:13:19'),(21,3,3,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,12,NULL,NULL,'582500058','2018-04-04 18:52:12',19500.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,19500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:12:34','2018-04-10 06:13:24'),(22,3,3,NULL,NULL,NULL,'purchase','received',0,'partial',NULL,11,NULL,NULL,'848485552','2018-04-12 18:52:12',12000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,12000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:13:12','2018-04-10 06:13:35'),(23,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0001','','2018-04-19 18:52:12',2500.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,2500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:14:47','2018-04-10 06:17:10'),(24,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0002','','2018-04-17 18:52:12',4875.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,4875.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:15:06','2018-04-10 06:16:43'),(25,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0003','','2018-04-17 18:52:12',625.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:16:02','2018-04-10 06:16:02'),(26,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0004','','2018-04-19 18:52:12',15625.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,15625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:18:48','2018-04-10 06:18:48'),(27,3,3,NULL,NULL,NULL,'purchase','received',0,'due',NULL,12,NULL,NULL,'1545477882','2018-04-04 18:52:12',26000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,26000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:23:36','2018-04-10 06:23:36'),(28,3,3,NULL,NULL,NULL,'sell','final',0,'paid',NULL,10,NULL,'AE0005','','2018-04-17 18:52:12',13000.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,13000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,5,'2018-04-10 06:24:16','2018-04-10 06:24:16'),(29,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0001','','2018-04-19 18:52:12',656.25,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,656.25,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:34:40','2018-04-10 07:34:40'),(30,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0002','','2018-04-17 18:52:12',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:34:54','2018-04-10 07:34:54'),(31,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0003','','2018-04-19 18:52:12',75.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,75.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:35:19','2018-04-10 07:35:19'),(32,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0004','','2018-04-19 18:52:12',37.50,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,37.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:37:50','2018-04-10 07:37:50'),(33,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0005','','2018-04-17 18:52:12',375.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,375.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:38:01','2018-04-10 07:38:01'),(34,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0006','','2018-04-17 18:52:12',250.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:38:15','2018-04-10 07:38:15'),(35,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0007','','2018-04-19 18:52:12',100.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:38:27','2018-04-10 07:38:27'),(36,4,4,NULL,NULL,NULL,'sell','final',0,'paid',NULL,13,NULL,'0008','','2018-04-17 18:52:12',125.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,6,'2018-04-10 07:38:49','2018-04-10 07:38:49'),(37,1,1,NULL,NULL,NULL,'purchase','received',0,'paid',NULL,2,NULL,NULL,'test','2018-04-20 00:00:00',1000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-20 10:52:47','2018-05-01 06:37:43'),(38,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0006','','2018-04-20 16:23:17',625.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,562.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-20 10:53:18','2018-04-20 10:53:18'),(39,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0007','','2018-04-23 18:09:04',158.40,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,142.56,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-23 12:39:04','2018-04-23 12:39:06'),(40,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0008','','2018-04-24 11:01:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 05:31:36','2018-04-24 05:31:36'),(45,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0009','','2018-04-24 11:03:41',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 05:33:41','2018-04-24 05:33:42'),(46,1,1,10,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0010','','2018-04-24 11:25:44',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 05:55:44','2018-04-24 05:56:08'),(47,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0011','','2018-04-24 13:05:44',1658.80,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,1492.92,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 07:35:44','2018-04-24 07:37:42'),(48,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0012','','2018-04-24 16:06:45',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:36:45','2018-04-24 10:36:45'),(49,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0013','','2018-04-24 16:09:50',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:39:50','2018-04-24 10:39:50'),(50,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0014','','2018-04-24 16:13:06',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:43:06','2018-04-24 10:43:06'),(51,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0015','','2018-04-24 16:13:12',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:43:12','2018-04-24 10:43:12'),(52,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0016','','2018-04-24 16:14:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:44:20','2018-04-24 10:44:21'),(53,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0017','','2018-04-24 16:14:57',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:44:57','2018-04-24 10:44:57'),(54,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0018','','2018-04-24 16:15:30',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:45:30','2018-04-24 10:45:30'),(55,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0019','','2018-04-24 16:16:09',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:46:09','2018-04-24 10:46:09'),(56,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0020','','2018-04-24 16:16:27',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:46:27','2018-04-24 10:46:27'),(57,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0021','','2018-04-24 16:17:15',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:47:15','2018-04-24 10:47:15'),(58,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0022','','2018-04-24 16:17:28',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:47:28','2018-04-24 10:47:29'),(59,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0023','','2018-04-24 16:17:52',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:47:52','2018-04-24 10:47:52'),(60,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0024','','2018-04-24 16:19:21',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:49:21','2018-04-24 10:49:21'),(61,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0025','','2018-04-24 16:19:45',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:49:45','2018-04-24 10:49:45'),(62,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0026','','2018-04-24 16:19:54',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:49:54','2018-04-24 10:49:54'),(63,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0027','','2018-04-24 16:20:30',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:50:30','2018-04-24 10:50:30'),(64,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0028','','2018-04-24 16:22:02',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:52:02','2018-04-24 10:52:02'),(65,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0029','','2018-04-24 16:23:05',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:53:05','2018-04-24 10:53:05'),(66,1,1,8,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0030','','2018-04-24 16:24:03',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:54:03','2018-04-24 10:54:03'),(67,1,1,9,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0031','','2018-04-24 16:26:14',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:56:14','2018-04-24 10:56:14'),(68,1,1,8,7,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0032','','2018-04-24 16:26:34',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 10:56:34','2018-04-24 13:10:31'),(69,1,1,8,7,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0033','','2018-04-24 18:50:52',1540.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,1386.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-24 13:20:52','2018-04-24 13:20:52'),(70,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 12:42:05',200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,71,1,'2018-04-25 07:12:05','2018-04-25 07:12:05'),(71,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 12:42:05',480.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,480.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,71,1,'2018-04-25 07:12:05','2018-04-25 07:12:05'),(72,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 12:42:05',780.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,780.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,71,1,'2018-04-25 07:12:05','2018-04-25 07:12:05'),(78,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:16:02',1460.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1460.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,80,1,'2018-04-25 07:46:02','2018-04-25 07:46:02'),(79,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:18:31',7300.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,7300.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,81,1,'2018-04-25 07:48:31','2018-04-25 07:48:31'),(80,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:21',3391500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3391500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,82,1,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(81,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3391500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3391500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,83,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(82,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3391500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3391500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,84,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(83,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3391500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3391500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,85,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(84,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3510500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,86,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(85,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3510500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,87,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(86,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3510500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,88,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(87,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',3510500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,89,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(88,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4284000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4284000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,90,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(89,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4284000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4284000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,91,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(90,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4284000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4284000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,92,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(91,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4284000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4284000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,93,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(92,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,94,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(93,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,95,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(94,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,96,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(95,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,97,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(96,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4760000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4760000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,98,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(97,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:22',4760000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4760000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,99,1,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(98,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4760000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4760000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,100,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(99,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4760000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4760000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,101,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(100,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,102,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(101,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,103,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(102,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,104,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(103,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4403000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4403000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,105,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(104,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4641000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4641000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,106,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(105,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4641000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4641000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,107,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(106,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4641000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4641000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,108,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(107,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',4641000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4641000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,109,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(108,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,110,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(109,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,111,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(110,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,112,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(111,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,113,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(112,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,114,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(113,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,115,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(114,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,116,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(115,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2499000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2499000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,117,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(116,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,118,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(117,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,119,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(118,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,120,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(119,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,121,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(120,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,122,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(121,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,123,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(122,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,124,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(123,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,125,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(124,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,126,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(125,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,127,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(126,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,128,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(127,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,129,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(128,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,130,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(129,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,131,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(130,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,132,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(131,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',3034500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3034500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,133,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(132,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,134,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(133,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,135,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(134,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,136,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(135,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,137,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(136,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,138,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(137,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,139,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(138,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,140,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(139,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2856000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2856000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,141,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(140,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,142,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(141,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,143,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(142,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,144,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(143,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,145,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(144,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,146,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(145,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,147,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(146,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,148,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(147,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',2261000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2261000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,149,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(148,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,150,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(149,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,151,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(150,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,152,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(151,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,153,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(152,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,154,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(153,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,155,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(154,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,156,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(155,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1249500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1249500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,157,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(156,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,158,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(157,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,159,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(158,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,160,1,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(159,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:23',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,161,1,'2018-04-25 08:09:23','2018-04-25 08:09:24'),(160,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,162,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(161,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,163,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(162,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,164,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(163,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1130500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,165,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(164,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',4165000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4165000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,166,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(165,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',4165000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4165000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,167,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(166,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',4165000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4165000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,168,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(167,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',4165000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4165000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,169,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(168,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,170,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(169,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,171,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(170,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,172,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(171,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,173,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(172,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1309000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1309000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,174,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(173,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1309000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1309000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,175,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(174,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',1309000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1309000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,176,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(175,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,177,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(176,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,178,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(177,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3094000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3094000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,179,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(178,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',952000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,952000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,180,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(179,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3565700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3565700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,181,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(180,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3565700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3565700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,182,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(181,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3565700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3565700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,183,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(182,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',3565700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3565700.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,184,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(183,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,185,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(184,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,186,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(185,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,187,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(186,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,188,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(187,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,189,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(188,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,190,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(189,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,191,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(190,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',2380000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2380000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,192,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(191,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:39:24',226100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,226100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,193,1,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(192,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 13:52:19',3391500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3391500.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,194,1,'2018-04-25 08:22:19','2018-04-25 08:22:19'),(193,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 14:12:06',1000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,195,1,'2018-04-25 08:42:06','2018-04-25 08:42:06'),(194,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0034','','2018-04-25 16:12:06',792.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,712.80,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 10:42:06','2018-04-25 10:42:06'),(195,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,196,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(196,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,197,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(197,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,198,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(198,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2271400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2271400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,199,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(199,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2271400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2271400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,200,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(200,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2271400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2271400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,201,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(201,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,202,1,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(202,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:23',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,203,1,'2018-04-25 11:29:23','2018-04-25 11:29:24'),(203,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,204,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(204,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',1785600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1785600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,205,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(205,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,206,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(206,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,207,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(207,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,208,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(208,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,209,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(209,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,210,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(210,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2828400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2828400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,211,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(211,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2528400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2528400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,212,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(212,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2528400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2528400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,213,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(213,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2528400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2528400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,214,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(214,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2528400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2528400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,215,1,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(215,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:24',2557000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2557000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,216,1,'2018-04-25 11:29:24','2018-04-25 11:29:25'),(216,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2557000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2557000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,217,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(217,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2557000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2557000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,218,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(218,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2557000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2557000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,219,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(219,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,220,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(220,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,221,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(221,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,222,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(222,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,223,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(223,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,224,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(224,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,225,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(225,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,226,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(226,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3510000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,227,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(227,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3510000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,228,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(228,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3510000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,229,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(229,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3510000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3510000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,230,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(230,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',1010200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1010200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,231,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(231,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',1010200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1010200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,232,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(232,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',1010200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1010200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,233,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(233,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',1010200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1010200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,234,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(234,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',1010200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1010200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,235,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(235,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2557000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2557000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,236,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(236,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,237,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(237,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,238,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(238,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,239,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(239,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,240,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(240,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2414200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2414200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,241,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(241,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2414200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2414200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,242,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(242,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2414200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2414200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,243,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(243,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2414200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2414200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,244,1,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(244,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:25',2214200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2214200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,245,1,'2018-04-25 11:29:25','2018-04-25 11:29:26'),(245,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2214200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2214200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,246,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(246,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2214200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2214200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,247,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(247,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2214200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2214200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,248,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(248,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2342800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2342800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,249,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(249,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2342800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2342800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,250,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(250,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2342800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2342800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,251,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(251,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,252,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(252,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,253,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(253,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,254,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(254,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,255,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(255,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,256,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(256,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,257,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(257,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,258,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(258,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,259,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(259,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,260,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(260,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,261,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(261,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,262,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(262,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,263,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(263,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,264,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(264,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,265,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(265,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,266,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(266,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,267,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(267,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',928400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,928400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,268,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(268,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',1985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,269,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(269,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',1985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,270,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(270,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',1985600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1985600.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,271,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(271,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,272,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(272,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,273,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(273,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,274,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(274,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',2128400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2128400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,275,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(275,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,276,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(276,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,277,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(277,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,278,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(278,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,279,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(279,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3228400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3228400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,280,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(280,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3228400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3228400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,281,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(281,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3228400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3228400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,282,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(282,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3228400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3228400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,283,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(283,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,284,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(284,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,285,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(285,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,286,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(286,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4042800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4042800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,287,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(287,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4042800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4042800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,288,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(288,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',4042800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4042800.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,289,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(289,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,290,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(290,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,291,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(291,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:59:26',3071400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3071400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,292,1,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(292,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0035','','2018-04-25 17:48:43',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:18:43','2018-04-25 12:18:43'),(293,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0036','','2018-04-25 18:00:27',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:30:27','2018-04-25 12:30:27'),(294,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0037','','2018-04-25 18:01:09',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:31:09','2018-04-25 12:31:09'),(295,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0038','','2018-04-25 18:02:16',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:32:16','2018-04-25 12:32:16'),(296,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0039','','2018-04-25 18:02:46',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:32:46','2018-04-25 12:32:46'),(297,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0040','','2018-04-25 18:03:14',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:33:14','2018-04-25 12:33:14'),(298,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0041','','2018-04-25 18:04:16',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:34:16','2018-04-25 12:34:16'),(299,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0042','','2018-04-25 18:04:44',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:34:44','2018-04-25 12:34:44'),(300,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0043','','2018-04-25 18:05:41',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:35:41','2018-04-25 12:35:41'),(301,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0044','','2018-04-25 18:05:59',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:35:59','2018-04-25 12:35:59'),(302,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0045','','2018-04-25 18:06:40',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:36:40','2018-04-25 12:36:40'),(303,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0046','','2018-04-25 18:09:08',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:39:08','2018-04-25 12:39:08'),(304,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0047','','2018-04-25 18:10:09',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:40:09','2018-04-25 12:40:09'),(305,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0048','','2018-04-25 18:11:02',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:41:02','2018-04-25 12:41:02'),(306,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0049','','2018-04-25 18:12:42',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:42:42','2018-04-25 12:42:42'),(307,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0050','','2018-04-25 18:16:42',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:46:42','2018-04-25 12:46:42'),(308,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0051','','2018-04-25 18:17:46',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:47:46','2018-04-25 12:47:46'),(309,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0052','','2018-04-25 18:19:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:49:35','2018-04-25 12:49:35'),(310,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0053','','2018-04-25 18:22:19',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:52:19','2018-04-25 12:52:19'),(311,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0054','','2018-04-25 18:22:57',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:52:57','2018-04-25 12:52:57'),(312,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0055','','2018-04-25 18:26:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 12:56:20','2018-04-25 12:56:20'),(313,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0056','','2018-04-25 18:32:08',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:02:08','2018-04-25 13:02:08'),(314,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0057','','2018-04-25 18:36:13',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:06:13','2018-04-25 13:06:13'),(315,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0058','','2018-04-25 18:36:29',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:06:29','2018-04-25 13:06:29'),(316,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0059','','2018-04-25 18:37:25',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:07:25','2018-04-25 13:07:25'),(317,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0060','','2018-04-25 18:38:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:08:28','2018-04-25 13:08:28'),(318,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0061','','2018-04-25 18:39:07',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:09:07','2018-04-25 13:09:07'),(319,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0062','','2018-04-25 18:39:49',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:09:49','2018-04-25 13:09:49'),(320,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0063','','2018-04-25 18:40:36',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:10:36','2018-04-25 13:10:36'),(321,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0064','','2018-04-25 18:41:00',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:11:01','2018-04-25 13:11:01'),(322,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0065','','2018-04-25 18:41:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:11:20','2018-04-25 13:11:20'),(323,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0066','','2018-04-25 18:41:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:11:49','2018-04-25 13:11:49'),(324,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0067','','2018-04-25 18:42:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:12:20','2018-04-25 13:12:21'),(325,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0068','','2018-04-25 18:42:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:12:35','2018-04-25 13:12:35'),(326,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0069','','2018-04-25 18:43:11',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:13:11','2018-04-25 13:13:11'),(327,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0070','','2018-04-25 18:44:07',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:14:07','2018-04-25 13:14:07'),(328,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0071','','2018-04-25 18:45:04',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:15:04','2018-04-25 13:15:04'),(329,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0072','','2018-04-25 18:45:26',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:15:26','2018-04-25 13:15:26'),(330,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0073','','2018-04-25 18:45:42',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:15:42','2018-04-25 13:15:42'),(331,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0074','','2018-04-25 18:46:03',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:16:03','2018-04-25 13:16:03'),(332,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0075','','2018-04-25 18:46:21',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:16:21','2018-04-25 13:16:21'),(333,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0076','','2018-04-25 18:46:41',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:16:41','2018-04-25 13:16:41'),(334,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0077','','2018-04-25 18:47:14',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:17:14','2018-04-25 13:17:14'),(335,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0078','','2018-04-25 18:53:17',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:23:17','2018-04-25 13:23:17'),(336,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0079','','2018-04-25 18:55:27',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:25:27','2018-04-25 13:25:27'),(337,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0080','','2018-04-25 18:55:38',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:25:38','2018-04-25 13:25:38'),(338,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0081','','2018-04-25 18:56:02',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:26:02','2018-04-25 13:26:02'),(339,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0082','','2018-04-25 18:56:33',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:26:33','2018-04-25 13:26:33'),(340,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0083','','2018-04-25 18:56:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-25 13:26:49','2018-04-25 13:26:49'),(341,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0084','','2018-04-27 12:01:51',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 06:31:51','2018-04-27 06:31:52'),(342,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0085','','2018-04-27 12:02:18',77.00,4,12.47,'percentage','10',NULL,0.00,NULL,NULL,81.77,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 06:32:18','2018-04-27 06:32:18'),(343,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0086','','2018-04-27 13:16:51',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 07:46:51','2018-04-27 07:46:51'),(344,1,1,NULL,NULL,NULL,'sell','draft',0,NULL,NULL,1,NULL,'Draft -ytrVl','','2018-04-27 14:00:32',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 08:30:32','2018-04-27 08:30:32'),(345,1,1,NULL,NULL,NULL,'sell','draft',0,NULL,NULL,1,NULL,'Draft -tQz8q','','2018-04-27 14:01:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 08:31:47','2018-04-27 08:31:47'),(346,1,1,NULL,NULL,NULL,'sell','draft',0,NULL,NULL,1,NULL,'Draft -fwwWP','','2018-04-27 14:06:04',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 08:36:04','2018-04-27 08:36:04'),(347,1,1,NULL,NULL,NULL,'sell','draft',0,NULL,NULL,1,NULL,'Draft -pIMt5','','2018-04-27 14:06:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 08:36:47','2018-04-27 08:36:47'),(348,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0090','','2018-04-27 14:08:07',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 08:38:07','2018-04-27 11:50:57'),(349,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0087','','2018-04-27 16:02:25',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 10:32:26','2018-04-27 10:32:26'),(350,1,1,NULL,NULL,NULL,'sell','draft',1,'paid',NULL,1,NULL,'Draft -LyZgP','','2018-04-27 16:16:53',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 10:46:53','2018-04-27 11:43:37'),(351,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0089','','2018-04-27 16:17:15',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 10:47:15','2018-04-27 11:46:24'),(352,1,1,NULL,NULL,NULL,'sell','draft',1,'paid',NULL,1,NULL,'Draft -PDoyg','','2018-04-27 16:19:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 10:49:20','2018-04-27 11:44:06'),(353,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'uWhqA','','2018-04-27 16:43:35',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 11:13:35','2018-04-27 11:13:35'),(354,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'eSHDO','','2018-04-27 16:44:44',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 11:14:44','2018-04-27 11:14:44'),(355,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'PZeqS','','2018-04-27 16:47:17',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 11:17:17','2018-04-27 11:17:17'),(356,1,1,NULL,NULL,NULL,'sell','draft',1,'paid',NULL,1,NULL,'PPTmq','','2018-04-27 16:47:36',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,12.38,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-27 11:17:36','2018-04-27 11:23:08'),(357,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'sZoSJ','','2018-04-27 00:00:00',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-04-27 12:45:09','2018-04-27 12:45:09'),(358,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0092','','2019-01-02 00:00:00',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-04-27 12:45:56','2018-04-27 13:06:28'),(359,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0091','','2019-02-01 00:00:00',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-04-27 12:49:57','2018-04-27 13:05:43'),(360,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'EPVJI','','2018-04-27 00:00:00',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-04-27 12:53:28','2018-04-27 12:53:28'),(361,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0093','','2018-04-30 19:04:25',12500.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,11250.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-04-30 13:34:25','2018-04-30 13:34:26'),(362,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0094','','2018-05-01 10:55:06',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 05:25:06','2018-05-01 05:51:02'),(363,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0095','','2018-05-01 11:22:35',79.20,1,7.13,'percentage','10',NULL,0.00,NULL,NULL,78.41,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 05:52:35','2018-05-01 05:52:35'),(364,1,1,NULL,NULL,NULL,'sell_transfer','final',0,'paid',NULL,NULL,NULL,NULL,'ref1010','2018-05-01 00:00:00',77.00,NULL,0.00,NULL,NULL,NULL,10.00,'test',NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(365,1,5,NULL,NULL,NULL,'purchase_transfer','received',0,'paid',NULL,NULL,NULL,NULL,'ref1010','2018-05-01 00:00:00',77.00,NULL,0.00,NULL,NULL,NULL,10.00,'test',NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,364,NULL,1,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(366,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0096','','2018-05-01 17:36:02',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 12:06:02','2018-05-01 12:06:02'),(367,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0097','','2018-05-01 18:19:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 12:49:49','2018-05-01 12:49:49'),(368,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0098','','2018-05-01 18:22:29',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-01 12:52:29','2018-05-01 12:52:29'),(369,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0099','','2018-05-02 11:06:28',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 05:36:28','2018-05-02 05:36:29'),(372,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0100','','2018-05-02 12:21:08',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 06:51:08','2018-05-02 06:51:08'),(373,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0101','','2018-05-02 12:22:34',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 06:52:34','2018-05-02 06:52:34'),(377,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0102','','2018-05-02 12:31:31',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:01:31','2018-05-02 07:01:31'),(378,1,1,NULL,NULL,NULL,'sell','final',0,'partial',NULL,1,NULL,'AS0103','','2018-05-02 12:53:36',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:23:36','2018-05-02 07:23:36'),(379,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0104','','2018-05-02 12:54:31',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:24:31','2018-05-02 07:24:31'),(380,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0105','','2018-05-02 12:55:55',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:25:55','2018-05-02 07:25:55'),(381,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0106','','2018-05-02 12:56:10',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:26:10','2018-05-02 07:26:10'),(382,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0107','','2018-05-02 12:58:44',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:28:44','2018-05-02 07:28:44'),(383,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0108','','2018-05-02 12:59:27',250.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,225.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:29:27','2018-05-02 07:42:22'),(384,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0109','','2018-05-02 13:14:08',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 07:44:08','2018-05-02 07:47:54'),(385,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0110','','2018-05-02 13:43:48',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 08:13:48','2018-05-02 08:26:02'),(386,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0111','','2018-05-02 14:03:14',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 08:33:15','2018-05-02 08:37:05'),(387,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0112','','2018-05-02 14:07:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 08:37:47','2018-05-02 08:38:25'),(388,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0113','','2018-05-02 14:09:07',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 08:39:07','2018-05-02 08:39:41'),(389,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0114','','2018-05-02 16:07:33',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:37:33','2018-05-02 10:37:33'),(390,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0115','','2018-05-02 16:18:33',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:48:33','2018-05-02 10:48:33'),(391,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0116','','2018-05-02 16:18:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:48:49','2018-05-02 10:48:49'),(392,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0117','','2018-05-02 16:19:22',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:49:22','2018-05-02 10:49:22'),(393,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0118','','2018-05-02 16:19:36',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:49:36','2018-05-02 10:49:36'),(394,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0119','','2018-05-02 16:20:31',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 10:50:31','2018-05-02 10:50:31'),(395,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0120','','2018-05-02 16:58:01',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-02 11:28:01','2018-05-02 11:28:01'),(396,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0121','','2018-05-03 10:57:14',150.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,135.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 05:27:14','2018-05-03 05:27:14'),(397,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0122','','2018-05-03 10:57:27',162.50,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,146.25,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 05:27:27','2018-05-03 05:27:27'),(398,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0123','','2018-05-03 10:59:00',162.50,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,146.25,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 05:29:00','2018-05-03 05:29:00'),(399,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0124','','2018-05-03 11:20:08',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 05:50:08','2018-05-03 05:50:08'),(400,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0125','','2018-05-03 12:26:32',150.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,135.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 06:56:32','2018-05-03 06:56:32'),(401,1,1,NULL,NULL,NULL,'sell','final',0,'partial',NULL,1,NULL,'AS0126','','2018-05-03 12:34:45',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 07:04:45','2018-05-03 07:04:45'),(402,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0127','','2018-05-03 12:35:19',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 07:05:19','2018-05-03 07:05:19'),(403,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0128','','2018-05-03 12:35:53',125.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,112.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 07:05:53','2018-05-03 07:05:53'),(404,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0129','','2018-05-03 12:38:45',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 07:08:45','2018-05-03 07:08:45'),(405,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,14,1,'AS0130','','2018-05-03 15:55:59',84.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,76.23,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-03 10:25:59','2018-05-03 10:25:59'),(406,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0132','','2018-05-07 13:08:22',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:38:22','2018-05-07 07:38:23'),(407,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0133','','2018-05-07 13:08:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:38:47','2018-05-07 07:38:47'),(408,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0134','','2018-05-07 13:08:57',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:38:58','2018-05-07 07:38:58'),(409,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0135','','2018-05-07 13:11:43',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:41:43','2018-05-07 07:41:43'),(410,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0136','','2018-05-07 13:13:33',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:43:33','2018-05-07 07:43:33'),(411,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0137','','2018-05-07 13:23:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 07:53:47','2018-05-07 07:53:47'),(412,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0138','','2018-05-07 13:36:12',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:06:12','2018-05-07 08:06:12'),(413,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0139','','2018-05-07 13:40:22',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:10:22','2018-05-07 08:10:22'),(414,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0140','','2018-05-07 13:43:39',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:13:39','2018-05-07 08:13:39'),(415,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0141','','2018-05-07 13:44:16',158.40,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,142.56,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:14:16','2018-05-07 08:14:16'),(416,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0142','','2018-05-07 13:44:39',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:14:39','2018-05-07 08:14:39'),(417,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0143','','2018-05-07 13:44:52',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:14:52','2018-05-07 08:14:52'),(418,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0144','','2018-05-07 13:45:19',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:15:19','2018-05-07 08:15:19'),(419,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0145','','2018-05-07 13:45:32',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:15:32','2018-05-07 08:15:33'),(420,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0146','','2018-05-07 13:46:02',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:16:02','2018-05-07 08:16:02'),(421,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0147','','2018-05-07 13:46:35',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:16:35','2018-05-07 08:16:35'),(422,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0148','','2018-05-07 13:47:18',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:17:18','2018-05-07 08:17:18'),(423,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0149','','2018-05-07 13:47:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-07 08:17:35','2018-05-07 08:17:35'),(424,1,1,NULL,NULL,NULL,'sell','draft',1,NULL,NULL,1,NULL,'K6toG','','2018-05-07 00:00:00',792.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,712.80,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-05-07 12:19:09','2018-05-07 12:19:09'),(425,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0150','','2018-05-07 00:00:00',792.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,712.80,NULL,NULL,NULL,NULL,1,1.000,NULL,NULL,NULL,1,'2018-05-07 12:22:07','2018-05-07 12:22:07'),(426,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0152','','2018-05-10 16:24:24',37.80,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,34.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 10:54:25','2018-05-10 10:54:26'),(427,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0153','','2018-05-10 16:27:40',37.80,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,34.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 10:57:40','2018-05-10 10:57:40'),(428,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0154','','2018-05-10 16:31:03',37.80,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,34.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 11:01:03','2018-05-10 11:01:03'),(429,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0155','','2018-05-10 16:37:32',37.76,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,33.98,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 11:07:33','2018-05-10 11:07:33'),(430,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0156','','2018-05-10 16:54:24',37.78,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,34.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 11:24:24','2018-05-10 11:26:36'),(431,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0157','','2018-05-10 18:24:15',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 12:54:15','2018-05-10 12:54:15'),(432,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0158','','2018-05-10 05:58:27',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 00:28:27','2018-05-10 00:28:27'),(433,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0159','','2018-05-10 18:29:20',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-10 12:59:20','2018-05-10 12:59:20'),(434,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 19:25:22',1100.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1100.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,294,1,'2018-05-10 13:55:23','2018-05-10 13:55:23'),(435,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0160','','2018-05-11 17:53:31',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 12:23:31','2018-05-11 12:23:32'),(436,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0161','','2018-05-11 18:00:30',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 12:30:30','2018-05-11 12:30:30'),(437,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0162','','2018-05-11 18:04:57',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 12:34:57','2018-05-11 12:34:58'),(438,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0163','','2018-05-11 18:53:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 13:23:50','2018-05-11 13:23:50'),(439,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0164','','2018-05-11 19:27:12',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 13:57:12','2018-05-11 13:57:12'),(440,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0165','','2018-05-11 20:13:26',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-11 14:43:26','2018-05-11 14:43:27'),(441,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0166','','2018-05-12 11:38:02',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:08:02','2018-05-12 06:08:03'),(442,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0167','','2018-05-12 11:40:53',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:10:54','2018-05-12 06:10:54'),(443,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0168','','2018-05-12 11:43:07',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:13:07','2018-05-12 06:13:07'),(444,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0169','','2018-05-12 11:48:40',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:18:40','2018-05-12 06:18:40'),(445,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0170','','2018-05-12 11:54:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:24:20','2018-05-12 06:24:20'),(446,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0171','','2018-05-12 12:00:06',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:30:06','2018-05-12 06:30:06'),(447,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0172','','2018-05-12 12:00:55',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:30:55','2018-05-12 06:30:55'),(448,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0173','','2018-05-12 12:02:22',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:32:22','2018-05-12 06:32:22'),(449,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0174','','2018-05-12 12:04:02',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:34:02','2018-05-12 06:34:02'),(450,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0175','','2018-05-12 12:04:45',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:34:45','2018-05-12 06:34:45'),(451,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0176','','2018-05-12 12:09:15',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:39:15','2018-05-12 06:39:15'),(452,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0177','','2018-05-12 12:20:07',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:50:07','2018-05-12 06:50:07'),(453,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0178','','2018-05-12 12:29:22',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 06:59:22','2018-05-12 06:59:22'),(454,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0179','','2018-05-12 12:32:23',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:02:23','2018-05-12 07:02:23'),(455,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0180','','2018-05-12 12:45:50',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:15:50','2018-05-12 07:15:50'),(456,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0181','','2018-05-12 12:51:11',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:21:11','2018-05-12 07:21:11'),(457,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0182','','2018-05-12 12:52:26',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:22:26','2018-05-12 07:22:26'),(458,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0183','','2018-05-12 12:59:44',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:29:44','2018-05-12 07:29:44'),(459,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0184','','2018-05-12 13:02:44',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:32:44','2018-05-12 07:32:44'),(460,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0185','','2018-05-12 13:04:55',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:34:55','2018-05-12 07:34:55'),(461,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0186','','2018-05-12 13:06:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:36:20','2018-05-12 07:36:20'),(462,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0187','','2018-05-12 13:08:46',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:38:46','2018-05-12 07:38:46'),(463,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0188','','2018-05-12 13:10:09',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:40:09','2018-05-12 07:40:09'),(464,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0189','','2018-05-12 13:12:44',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:42:44','2018-05-12 07:42:44'),(465,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0190','','2018-05-12 13:14:15',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:44:15','2018-05-12 07:44:15'),(466,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0191','','2018-05-12 13:14:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:44:35','2018-05-12 07:44:35'),(467,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0192','','2018-05-12 13:14:54',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:44:54','2018-05-12 07:44:54'),(468,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0193','','2018-05-12 13:15:14',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:45:14','2018-05-12 07:45:14'),(469,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0194','','2018-05-12 13:15:46',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:45:46','2018-05-12 07:45:46'),(470,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0195','','2018-05-12 13:16:35',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:46:35','2018-05-12 07:46:35'),(471,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0196','','2018-05-12 13:17:06',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:47:06','2018-05-12 07:47:06'),(472,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0197','','2018-05-12 13:26:14',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 07:56:14','2018-05-12 07:56:14'),(473,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0198','','2018-05-12 13:30:45',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:00:45','2018-05-12 08:00:45'),(474,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0199','','2018-05-12 13:35:22',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:05:22','2018-05-12 08:05:22'),(475,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0200','','2018-05-12 13:37:25',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:07:25','2018-05-12 08:07:25'),(476,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0201','','2018-05-12 13:38:11',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:08:11','2018-05-12 08:08:11'),(477,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0202','','2018-05-12 13:42:57',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:12:57','2018-05-12 08:12:57'),(478,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0203','','2018-05-12 13:46:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:16:28','2018-05-12 08:16:28'),(479,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0204','','2018-05-12 13:53:20',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:23:20','2018-05-12 08:23:20'),(480,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0205','','2018-05-12 13:54:14',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:24:14','2018-05-12 08:24:14'),(481,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0206','','2018-05-12 13:55:24',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:25:24','2018-05-12 08:25:24'),(482,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0207','','2018-05-12 13:59:15',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:29:15','2018-05-12 08:29:15'),(483,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0208','','2018-05-12 13:59:47',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:29:47','2018-05-12 08:29:47'),(484,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0209','','2018-05-12 14:01:23',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:31:23','2018-05-12 08:31:23'),(485,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0210','','2018-05-12 14:02:23',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:32:23','2018-05-12 08:32:23'),(486,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0211','','2018-05-12 14:02:54',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 08:32:54','2018-05-12 08:32:54'),(487,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0212','','2018-05-12 16:45:20',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:15:20','2018-05-12 11:15:20'),(488,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0213','','2018-05-12 16:47:00',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:17:00','2018-05-12 11:17:00'),(489,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0214','','2018-05-12 16:49:46',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:19:46','2018-05-12 11:19:46'),(490,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0215','','2018-05-12 16:54:52',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:24:52','2018-05-12 11:24:52'),(491,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0216','','2018-05-12 16:56:44',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:26:44','2018-05-12 11:26:44'),(492,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0217','','2018-05-12 16:57:49',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:27:49','2018-05-12 11:27:49'),(493,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0218','','2018-05-12 16:59:29',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:29:29','2018-05-12 11:29:29'),(494,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0219','','2018-05-12 17:03:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:33:28','2018-05-12 11:33:28'),(495,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0220','','2018-05-12 17:04:56',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:34:56','2018-05-12 11:34:56'),(496,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0221','','2018-05-12 17:05:46',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:35:46','2018-05-12 11:35:46'),(497,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0222','','2018-05-12 17:08:52',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:38:52','2018-05-12 11:38:52'),(498,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0223','','2018-05-12 17:10:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:40:28','2018-05-12 11:40:28'),(499,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0224','','2018-05-12 17:11:53',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:41:53','2018-05-12 11:41:53'),(500,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0225','','2018-05-12 17:17:41',156.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,140.58,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:47:41','2018-05-12 11:47:41'),(501,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0226','','2018-05-12 17:19:09',92.95,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,83.66,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:49:09','2018-05-12 11:49:09'),(502,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0227','','2018-05-12 17:22:01',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:52:01','2018-05-12 11:52:01'),(503,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0228','','2018-05-12 17:22:44',92.95,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,83.66,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:52:44','2018-05-12 11:52:44'),(504,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0229','','2018-05-12 17:23:46',79.20,1,7.13,'percentage','10',NULL,0.00,NULL,NULL,78.41,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:53:46','2018-05-12 11:53:46'),(505,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0230','','2018-05-12 17:24:25',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:54:25','2018-05-12 11:54:26'),(506,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0231','','2018-05-12 17:26:58',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 11:56:58','2018-05-12 11:56:58'),(507,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0232','','2018-05-12 17:30:12',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:00:12','2018-05-12 12:00:12'),(508,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0233','','2018-05-12 17:31:35',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:01:35','2018-05-12 12:01:35'),(509,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0234','','2018-05-12 17:40:24',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:10:24','2018-05-12 12:10:24'),(510,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0235','','2018-05-12 17:43:27',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:13:27','2018-05-12 12:13:27'),(511,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0236','','2018-05-12 17:44:03',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:14:03','2018-05-12 12:14:03'),(512,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0237','','2018-05-12 17:44:48',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:14:48','2018-05-12 12:14:48'),(513,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0238','','2018-05-12 17:45:59',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:15:59','2018-05-12 12:15:59'),(514,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0239','','2018-05-12 17:47:16',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 12:17:16','2018-05-12 12:17:16'),(515,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0240','','2018-05-12 18:43:37',176.25,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,158.63,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 13:13:37','2018-05-12 13:13:37'),(516,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0241','','2018-05-12 18:44:37',253.25,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,227.93,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 13:14:37','2018-05-12 13:14:37'),(517,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0242','','2018-05-12 18:49:04',253.25,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,227.93,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 13:19:04','2018-05-12 13:19:04'),(518,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0243','','2018-05-12 18:49:49',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 13:19:49','2018-05-12 13:19:49'),(519,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0244','','2018-05-12 19:28:28',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 13:58:28','2018-05-12 13:58:28'),(520,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0245','','2018-05-12 19:33:19',239.50,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,215.55,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 14:03:19','2018-05-12 14:03:19'),(521,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0246','','2018-05-12 19:39:49',167.75,5,28.69,'percentage','10',NULL,0.00,NULL,NULL,179.66,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-12 14:09:49','2018-05-12 14:09:49'),(522,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0247','','2018-05-14 11:09:00',154.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,138.60,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:39:00','2018-05-14 05:39:01'),(523,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0248','','2018-05-14 11:10:03',229.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,206.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:40:03','2018-05-14 05:40:03'),(524,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0249','','2018-05-14 11:10:50',241.70,2,21.75,'percentage','10',NULL,0.00,NULL,NULL,239.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:40:50','2018-05-14 05:40:50'),(525,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0250','','2018-05-14 11:11:25',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:41:25','2018-05-14 05:41:25'),(526,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0251','','2018-05-14 11:12:37',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:42:37','2018-05-14 05:42:37'),(527,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0252','','2018-05-14 11:12:49',79.20,2,7.13,'percentage','10',NULL,0.00,NULL,NULL,78.41,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:42:49','2018-05-14 05:42:49'),(528,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0253','','2018-05-14 11:15:38',229.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,206.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:45:38','2018-05-14 05:45:38'),(529,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0254','','2018-05-14 11:17:22',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:47:22','2018-05-14 05:47:22'),(530,1,1,NULL,NULL,NULL,'sell','final',0,'partial',NULL,1,NULL,'AS0255','','2018-05-14 11:17:51',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:47:51','2018-05-14 05:47:51'),(531,1,1,NULL,NULL,NULL,'sell','final',0,'partial',NULL,1,NULL,'AS0256','','2018-05-14 11:19:04',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-14 05:49:04','2018-05-14 05:49:04'),(534,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 19:15:05',2200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2200.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,1,1,'2018-05-14 13:45:05','2018-05-15 06:04:21'),(535,1,7,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 11:52:58',4400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4400.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,12,1,'2018-05-15 06:22:58','2018-05-15 06:55:45'),(536,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0257','','2018-05-15 14:04:20',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 08:34:20','2018-05-15 08:34:21'),(537,1,7,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0258','','2018-05-15 14:04:51',1250.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,1125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 08:34:51','2018-05-15 08:34:51'),(538,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0259','','2018-05-15 16:20:16',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 10:50:17','2018-05-15 10:50:19'),(539,1,1,NULL,NULL,NULL,'sell','final',0,'due',NULL,1,NULL,'AS0260','','2018-05-15 16:21:51',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 10:51:51','2018-05-15 10:51:52'),(540,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0261','','2018-05-15 16:36:02',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:06:02','2018-05-15 11:06:02'),(541,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0262','','2018-05-15 17:08:37',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:38:37','2018-05-15 11:38:38'),(542,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0263','','2018-05-15 17:09:22',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:39:22','2018-05-15 11:39:22'),(543,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0264','','2018-05-15 17:10:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:40:20','2018-05-15 11:40:20'),(544,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0265','','2018-05-15 17:10:41',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:40:41','2018-05-15 11:40:41'),(545,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0266','','2018-05-15 17:15:20',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:45:20','2018-05-15 11:45:20'),(546,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0267','','2018-05-15 17:15:39',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:45:39','2018-05-15 11:45:39'),(547,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0268','','2018-05-15 17:16:49',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:46:49','2018-05-15 11:46:49'),(548,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0269','','2018-05-15 17:17:34',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 11:47:34','2018-05-15 11:47:34'),(549,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0270','','2018-05-15 18:00:03',2076.90,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,1869.21,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 12:30:03','2018-05-15 12:30:04'),(550,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0271','','2018-05-15 18:01:14',1656.10,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,1490.49,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-15 12:31:15','2018-05-15 12:39:45'),(551,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0272','','2018-05-16 11:38:57',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 06:08:57','2018-05-16 06:08:59'),(552,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0273','','2018-05-16 11:49:26',240.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,216.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 06:19:26','2018-05-16 06:39:44'),(553,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0274','','2018-05-16 11:52:01',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 06:22:01','2018-05-16 06:22:01'),(554,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0275','','2018-05-16 13:06:53',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(555,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0275','','2018-05-16 13:06:53',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:36:53','2018-05-16 07:36:53'),(556,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0276','','2018-05-16 13:08:48',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(557,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0276','','2018-05-16 13:08:48',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:38:48','2018-05-16 07:38:48'),(558,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0277','','2018-05-16 13:09:14',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(559,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0277','','2018-05-16 13:09:14',241.70,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,217.53,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:39:14','2018-05-16 07:39:14'),(560,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0278','','2018-05-16 13:10:18',90.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:40:18','2018-05-16 07:40:18'),(561,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0279','','2018-05-16 13:15:09',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:45:09','2018-05-16 07:45:09'),(562,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0280','','2018-05-16 13:15:29',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:45:29','2018-05-16 07:45:29'),(563,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0281','','2018-05-16 13:16:37',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:46:37','2018-05-16 07:46:37'),(564,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0282','','2018-05-16 13:18:02',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:48:02','2018-05-16 07:48:03'),(565,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0283','','2018-05-16 13:28:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 07:58:28','2018-05-16 08:13:31'),(566,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:09:43',1000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,311,1,'2018-05-16 10:39:43','2018-05-16 10:39:43'),(567,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:14:09',12000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,12000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,312,1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(568,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:14:09',12000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,12000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,313,1,'2018-05-16 10:44:09','2018-05-16 10:44:09'),(569,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 16:17:31',13000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,13000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,314,1,'2018-05-16 10:47:31','2018-05-16 10:53:09'),(570,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0284','','2018-05-16 18:13:39',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:43:40','2018-05-16 12:43:40'),(571,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0285','','2018-05-16 18:14:44',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:44:44','2018-05-16 12:44:44'),(572,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0286','','2018-05-16 18:17:33',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:47:33','2018-05-16 12:47:33'),(573,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0287','','2018-05-16 18:21:16',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:51:16','2018-05-16 12:51:16'),(574,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0288','','2018-05-16 18:22:13',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:52:13','2018-05-16 12:52:13'),(575,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0289','','2018-05-16 18:25:07',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 12:55:07','2018-05-16 12:55:07'),(576,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0290','','2018-05-16 18:42:48',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-16 13:12:48','2018-05-16 13:12:48'),(577,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0291','','2018-05-17 16:48:59',5904.85,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,5314.37,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-17 11:19:00','2018-05-17 11:19:01'),(578,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0292','','2018-05-18 10:52:26',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 05:22:26','2018-05-18 05:22:26'),(579,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0293','','2018-05-18 11:24:25',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 05:54:25','2018-05-18 05:54:25'),(580,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0294','','2018-05-18 11:24:59',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 05:54:59','2018-05-18 05:54:59'),(582,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,'AS0295','','2018-05-17 00:00:00',13.75,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,81.68,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:28:03','2018-05-18 12:28:03'),(583,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,'AS0296','','2018-05-18 00:00:00',143.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,143.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:29:24','2018-05-18 12:29:24'),(584,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,'AS0297','','2018-05-18 00:00:00',308.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,308.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:29:54','2018-05-18 12:29:54'),(585,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,NULL,'2018-05-18 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:35:12','2018-05-18 12:35:12'),(586,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'ref101','2018-05-20 00:00:00',77.00,NULL,0.00,'fixed','10',NULL,0.00,'note',NULL,67.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:41:13','2018-05-18 12:41:13'),(587,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'reftest','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:49:14','2018-05-18 12:49:14'),(588,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'reftest','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:49:25','2018-05-18 12:49:25'),(589,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'reftest','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:50:47','2018-05-18 12:50:47'),(590,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'reftest','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:53:09','2018-05-18 12:53:09'),(591,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'testsellingprice','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:53:42','2018-05-18 12:53:42'),(592,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'rer','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 12:54:54','2018-05-18 12:54:54'),(593,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'ref1010','2018-05-18 00:00:00',13.75,NULL,0.00,'fixed','10',NULL,0.00,NULL,NULL,80.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 13:19:32','2018-05-18 13:19:32'),(594,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'ref1010','2018-05-18 00:00:00',13.75,NULL,0.00,'fixed','10',NULL,0.00,NULL,NULL,80.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 13:19:49','2018-05-18 13:19:49'),(595,1,1,NULL,NULL,NULL,'','final',0,NULL,NULL,1,NULL,NULL,'ewewe','2018-05-18 00:00:00',150.00,NULL,0.00,NULL,'0',NULL,0.00,'rtrtr',NULL,227.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 13:27:07','2018-05-18 13:27:07'),(596,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,NULL,'wewe','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 13:52:52','2018-05-18 13:52:52'),(597,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,15,NULL,NULL,'test','2018-05-18 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-18 14:16:19','2018-05-18 14:16:19'),(598,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0298','','2018-05-19 13:00:46',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-19 07:30:46','2018-05-19 07:30:48'),(599,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0299','','2018-05-19 13:02:46',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-19 07:32:46','2018-05-19 07:32:46'),(600,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0300','','2018-05-19 13:05:57',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-19 07:35:57','2018-05-19 07:35:57'),(601,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,NULL,'ref1010','2018-05-21 00:00:00',450.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,631.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 06:02:20','2018-05-21 06:02:20'),(602,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,NULL,'REF102','2018-05-21 00:00:00',154.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,154.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 06:10:11','2018-05-21 06:10:11'),(603,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'ref101',NULL,'2018-05-21 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:07:04','2018-05-21 07:07:04'),(604,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'ref101',NULL,'2018-05-21 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:08:02','2018-05-21 07:08:02'),(605,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'ref1000',NULL,'2018-05-21 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:09:04','2018-05-21 07:09:04'),(606,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'1212',NULL,'2018-05-21 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:12:00','2018-05-21 07:12:00'),(607,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'1212',NULL,'2018-05-21 00:00:00',13.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:12:20','2018-05-21 07:12:20'),(608,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'ref',NULL,'2018-05-21 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:17:21','2018-05-21 07:17:21'),(609,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'ref',NULL,'2018-05-21 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:20:21','2018-05-21 07:20:21'),(610,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'test1234',NULL,'2018-05-21 00:00:00',90.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:42:58','2018-05-21 07:42:58'),(611,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'test1234 test1234',NULL,'2018-05-21 00:00:00',90.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 07:43:33','2018-05-21 07:43:33'),(612,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'Print testing',NULL,'2018-05-21 00:00:00',90.75,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,90.75,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 08:27:42','2018-05-21 08:27:42'),(613,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'print test',NULL,'2018-05-21 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 08:29:16','2018-05-21 08:29:16'),(614,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,16,NULL,'AS0301','','2018-05-21 16:44:28',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 11:14:28','2018-05-21 11:14:28'),(615,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0302','','2018-05-21 16:56:22',385.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,346.50,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 11:26:22','2018-05-21 11:26:22'),(616,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'AS0002-1',NULL,'2018-05-21 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 11:27:48','2018-05-21 11:27:48'),(617,1,1,NULL,NULL,NULL,'opening_stock','received',0,'paid',NULL,NULL,NULL,NULL,NULL,'2018-01-01 17:47:04',10000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,10000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,315,1,'2018-05-21 12:17:04','2018-05-21 12:17:04'),(618,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'sell return','2018-05-21 00:00:00',5000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,5000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 12:17:55','2018-05-22 06:30:43'),(619,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0303','','2018-05-21 17:48:25',6250.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,5625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 12:18:25','2018-05-21 12:18:25'),(620,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'sell return',NULL,'2018-05-21 00:00:00',5000.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,5000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 12:19:14','2018-05-21 12:19:14'),(621,1,1,NULL,NULL,NULL,'sell_transfer','final',0,'paid',NULL,NULL,NULL,NULL,'sell return','2018-05-21 00:00:00',5000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,5000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 12:19:53','2018-05-21 12:19:53'),(622,1,5,NULL,NULL,NULL,'purchase_transfer','received',0,'paid',NULL,NULL,NULL,NULL,'sell return','2018-05-21 00:00:00',5000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,5000.00,NULL,NULL,NULL,NULL,0,1.000,NULL,621,NULL,1,'2018-05-21 12:19:53','2018-05-21 12:19:53'),(623,1,1,NULL,NULL,NULL,'stock_adjustment','received',0,NULL,'normal',NULL,NULL,NULL,NULL,'2018-05-21 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,6250.00,NULL,NULL,NULL,NULL,0,1.000,0.00,NULL,NULL,1,'2018-05-21 12:20:58','2018-05-21 12:20:58'),(624,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'wewew',NULL,'2018-05-21 00:00:00',125.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:07:04','2018-05-21 13:07:04'),(625,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'today',NULL,'2018-05-21 00:00:00',125.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:08:10','2018-05-21 13:08:10'),(626,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'today',NULL,'2018-05-21 00:00:00',125.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:09:52','2018-05-21 13:09:52'),(627,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'return today',NULL,'2018-05-21 00:00:00',125.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,125.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:14:11','2018-05-21 13:14:11'),(628,1,1,NULL,NULL,NULL,'sell_return','final',0,NULL,NULL,1,NULL,'return testing',NULL,'2018-05-21 00:00:00',625.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,625.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:29:31','2018-05-21 13:29:31'),(629,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0304','','2018-05-21 19:22:53',462.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,415.80,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-21 13:52:53','2018-05-24 07:09:00'),(630,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0305','','2018-05-24 12:53:05',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-24 07:23:05','2018-05-24 07:23:06'),(631,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0306','','2018-05-24 12:54:19',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-24 07:24:19','2018-05-24 07:24:19'),(632,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0307','','2018-05-24 12:55:34',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-24 07:25:34','2018-05-24 07:25:34'),(633,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0308','','2018-05-24 13:17:44',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,71.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-24 07:47:44','2018-05-24 07:47:44'),(634,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,15,NULL,'AS0309','','2018-05-24 13:19:16',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-24 07:49:16','2018-05-24 07:49:16'),(635,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0310','','2018-05-25 16:20:53',231.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,207.90,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-25 10:50:54','2018-05-25 10:50:55'),(636,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0311','','2018-05-25 16:21:25',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,69.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-25 10:51:25','2018-05-25 10:51:25'),(637,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'12121ewewew','2018-05-29 00:00:00',-143.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,-143.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-29 15:12:36','2018-05-29 15:12:36'),(638,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0312','','2018-05-30 17:46:39',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,87.30,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-30 12:16:39','2018-05-30 12:16:41'),(645,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0313','','2018-05-30 19:31:15',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,98.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-30 14:01:15','2018-05-30 14:01:16'),(646,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0314','','2018-05-30 19:32:13',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,95.58,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-30 14:02:13','2018-05-30 14:02:13'),(648,1,1,NULL,NULL,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0315','','2018-05-30 19:33:52',77.00,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,93.60,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-30 14:03:52','2018-05-30 14:03:52'),(650,1,1,1,12,NULL,'sell','final',0,'paid',NULL,1,NULL,'AS0316','','2018-05-31 10:34:09',79.20,NULL,0.00,'percentage','10',NULL,0.00,NULL,NULL,98.28,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 05:04:09','2018-05-31 05:04:10'),(651,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0001','2018-06-01 00:00:00',389.40,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,389.40,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 05:44:29','2018-05-31 06:06:27'),(652,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0001','2018-06-01 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 06:03:19','2018-05-31 06:03:19'),(653,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0001','2018-05-31 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 06:04:17','2018-05-31 06:04:17'),(654,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0001','2018-05-31 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 06:05:12','2018-05-31 06:05:12'),(655,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0001','2018-05-31 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 06:06:03','2018-05-31 06:06:03'),(656,1,1,NULL,NULL,NULL,'purchase','received',0,'due',NULL,2,NULL,NULL,'PO2018/0002','2018-05-11 00:00:00',77.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,NULL,NULL,NULL,1,'2018-05-31 06:20:16','2018-05-31 06:20:16'),(657,1,1,NULL,NULL,NULL,'stock_adjustment','received',0,NULL,'normal',NULL,NULL,NULL,'SA2018/0001','2018-05-31 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,0.00,NULL,NULL,1,'2018-05-31 06:24:36','2018-05-31 06:24:36'),(658,1,1,NULL,NULL,NULL,'stock_adjustment','received',0,NULL,'normal',NULL,NULL,NULL,'SA2018/0002','2018-05-31 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,0.00,NULL,NULL,1,'2018-05-31 06:25:08','2018-05-31 06:25:08'),(659,1,1,NULL,NULL,NULL,'stock_adjustment','received',0,NULL,'normal',NULL,NULL,NULL,'SA2018/0003','2018-05-17 00:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,77.00,NULL,NULL,NULL,NULL,0,1.000,0.00,NULL,NULL,1,'2018-05-31 06:25:47','2018-05-31 06:25:47');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,1,NULL,'2018-01-03 15:15:20','2018-01-03 15:15:20'),(2,1,'Packets','packets',0,1,NULL,'2018-01-06 01:07:01','2018-01-06 01:08:36'),(3,1,'Grams','g',1,1,NULL,'2018-01-06 01:10:34','2018-01-06 01:10:34'),(4,2,'Pieces','Pc(s)',0,4,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(5,3,'Units','units',0,5,NULL,'2018-04-10 05:16:16','2018-04-10 05:29:19'),(6,4,'Units','units',0,6,NULL,'2018-04-10 06:50:43','2018-04-10 07:02:04'),(7,1,'n/a','n/a',1,1,NULL,'2018-04-25 08:02:53','2018-04-25 08:02:53');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Mr','Admin',NULL,'admin','admin@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,'Pn21h51jYSmCTycKzOQo1n4q89JIhxqIODAOCObPuz6wzRHzsGayZqFlxqP4',1,0,0.00,NULL,'2018-01-03 20:45:19','2018-05-27 05:58:53'),(2,'Mr','Demo','Cashier','cashier','cashier@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-01-03 20:50:58','2018-01-03 20:50:58'),(3,'Mr.','Demo','Admin','demo-admin','demoadmin@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-01-06 01:40:57','2018-01-06 01:40:57'),(4,'Mr','Demo','Admin','admin-pharmacy','admin-pharma@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,'MJnleh4kefXZtw3FCI2yHKEwr45Rs5nZxyQyGSFRfjIcQn93sJZyw7BAzSUq',2,0,0.00,NULL,'2018-04-10 02:42:40','2018-04-10 02:42:40'),(5,'Mr','Demo','Admin','admin-electronics','admin-electronics@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,'YzGFoRAfllUjyB12qIZhowlteUPhvR1cd77YREQuqemSUftHp72aRLZMrzwR',3,0,0.00,NULL,'2018-04-10 05:16:15','2018-04-10 05:16:15'),(6,'Mr','Demo','Admin','admin-services','admin-services@example.com','$2y$10$IOHqpJwtPjTR963yjoMEDeFp2MrwtPG/Q7dm5wsXh9sEV./y9SL.a','en',NULL,NULL,'CdBNjmTIXVU0nEgcEg85L97w6JEjvuE6CfF7mvhmz7Ad2K7IxJVd9WPLdxcg',4,0,0.00,NULL,'2018-04-10 06:50:42','2018-04-10 06:50:42'),(7,'Waiter','Waiter','Waiter','waiter','Waiter@Waiter.co','$2y$10$kT./3IjL.isXZ7Pyan0dA.nibPdymrt5f2qzkrR5ZCJwoKt/u7VO2','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-04-24 12:36:59','2018-04-24 12:36:59'),(8,NULL,'test','test','test1234','nikhil@test.com','$2y$10$Azuoz6yfaK3eNtNR3xvG3OmrXpcKevC6r/VE9BUespK8MS5ieNXpm','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-05-02 05:36:04','2018-05-02 05:36:04'),(9,'test','test','test','testcashier','test@test.com','$2y$10$bRZbchfAAlLRMEJh9U.5Tu3ut6GSgbLo64RQ2Mo/MceGQEUkj29wa','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-05-24 04:56:36','2018-05-24 04:56:36'),(11,'test','test','test','test123cashier','testcshier@test.com','$2y$10$mKpS7z2DsFb97vZy3hJCIebFU/ADqLTFetMjIDLRLdD/Snrg2PTW6','en',NULL,NULL,'Nsz5gkGHZ1hbUkU0zPnW4Yn81Rha3A5ivtEfnBOzuPnuKyeLIcTHbdYkg5LC',1,0,0.00,NULL,'2018-05-24 04:57:25','2018-05-24 04:58:47'),(12,'test','Raju','waiter','rajuwaiter','test@test.com','$2y$10$79lXsZWmHKAtQBA11bSHYOUuGa/eLyDA8Yy/4TkbTwhWts7cW2zJe','en',NULL,NULL,NULL,1,0,0.00,NULL,'2018-05-31 05:03:43','2018-05-31 05:03:43');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=348 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,2,2,2,1,33.00,'2018-01-06 01:27:11','2018-05-31 06:25:47'),(2,2,2,3,1,34.00,'2018-01-06 01:27:11','2018-05-31 06:20:16'),(3,2,2,4,1,33.00,'2018-01-06 01:27:11','2018-05-31 05:44:29'),(4,2,2,5,1,33.00,'2018-01-06 01:27:11','2018-05-31 05:44:29'),(5,2,2,6,1,34.00,'2018-01-06 01:27:11','2018-05-31 05:44:29'),(6,14,15,47,1,100.00,'2018-01-06 01:28:10','2018-01-06 01:28:10'),(7,28,30,71,1,465.00,'2018-01-06 01:32:22','2018-05-21 08:27:42'),(8,21,23,64,1,140.00,'2018-01-06 01:33:12','2018-01-06 01:37:45'),(9,27,29,70,1,470.00,'2018-01-06 01:35:26','2018-01-06 01:36:32'),(10,34,36,77,2,40.00,'2018-04-10 04:48:16','2018-04-10 04:53:35'),(11,32,34,75,2,93.00,'2018-04-10 04:49:40','2018-04-10 04:53:58'),(12,36,38,79,2,150.00,'2018-04-10 04:50:41','2018-04-10 04:50:41'),(13,33,35,76,2,153.00,'2018-04-10 04:51:38','2018-04-10 04:54:21'),(14,46,48,89,3,30.00,'2018-04-10 06:09:54','2018-04-10 06:09:54'),(15,41,43,84,3,14.00,'2018-04-10 06:10:51','2018-04-10 06:18:48'),(16,45,47,88,3,45.00,'2018-04-10 06:11:45','2018-04-10 06:11:45'),(17,44,46,87,3,80.00,'2018-04-10 06:12:34','2018-04-10 06:15:06'),(18,43,45,86,3,25.00,'2018-04-10 06:13:12','2018-04-10 06:14:47'),(19,42,44,85,3,30.00,'2018-04-10 06:23:36','2018-04-10 06:24:16'),(20,61,63,104,1,5.00,'2018-04-20 10:52:47','2018-04-20 10:53:18'),(21,71,73,132,1,0.00,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(22,71,73,133,1,2.00,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(23,71,73,134,1,4.00,'2018-04-25 07:12:05','2018-05-17 11:19:01'),(24,80,82,159,1,0.00,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(25,80,82,160,1,0.00,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(26,80,82,161,1,3.00,'2018-04-25 07:46:02','2018-05-17 11:19:01'),(27,81,83,162,1,7.00,'2018-04-25 07:48:31','2018-05-17 11:19:01'),(28,81,83,163,1,17.00,'2018-04-25 07:48:31','2018-05-21 06:02:20'),(29,81,83,164,1,13.00,'2018-04-25 07:48:31','2018-05-17 11:19:01'),(30,82,84,165,1,100.00,'2018-04-25 08:09:21','2018-04-25 08:09:21'),(31,83,85,166,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(32,84,86,167,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(33,85,87,168,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(34,86,88,169,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(35,87,89,170,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(36,88,90,171,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(37,89,91,172,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(38,90,92,173,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(39,91,93,174,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(40,92,94,175,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(41,93,95,176,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(42,94,96,177,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(43,95,97,178,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(44,96,98,179,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(45,97,99,180,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(46,98,100,181,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(47,99,101,182,1,100.00,'2018-04-25 08:09:22','2018-04-25 08:09:22'),(48,100,102,183,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(49,101,103,184,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(50,102,104,185,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(51,103,105,186,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(52,104,106,187,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(53,105,107,188,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(54,106,108,189,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(55,107,109,190,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(56,108,110,191,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(57,109,111,192,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(58,110,112,193,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(59,111,113,194,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(60,112,114,195,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(61,113,115,196,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(62,114,116,197,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(63,115,117,198,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(64,116,118,199,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(65,117,119,200,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(66,118,120,201,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(67,119,121,202,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(68,120,122,203,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(69,121,123,204,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(70,122,124,205,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(71,123,125,206,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(72,124,126,207,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(73,125,127,208,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(74,126,128,209,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(75,127,129,210,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(76,128,130,211,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(77,129,131,212,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(78,130,132,213,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(79,131,133,214,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(80,132,134,215,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(81,133,135,216,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(82,134,136,217,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(83,135,137,218,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(84,136,138,219,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(85,137,139,220,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(86,138,140,221,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(87,139,141,222,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(88,140,142,223,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(89,141,143,224,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(90,142,144,225,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(91,143,145,226,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(92,144,146,227,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(93,145,147,228,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(94,146,148,229,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(95,147,149,230,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(96,148,150,231,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(97,149,151,232,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(98,150,152,233,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(99,151,153,234,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(100,152,154,235,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(101,153,155,236,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(102,154,156,237,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(103,155,157,238,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(104,156,158,239,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(105,157,159,240,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(106,158,160,241,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(107,159,161,242,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(108,160,162,243,1,100.00,'2018-04-25 08:09:23','2018-04-25 08:09:23'),(109,161,163,244,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(110,162,164,245,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(111,163,165,246,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(112,164,166,247,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(113,165,167,248,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(114,166,168,249,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(115,167,169,250,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(116,168,170,251,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(117,169,171,252,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(118,170,172,253,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(119,171,173,254,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(120,172,174,255,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(121,173,175,256,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(122,174,176,257,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(123,175,177,258,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(124,176,178,259,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(125,177,179,260,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(126,178,180,261,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(127,179,181,262,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(128,180,182,263,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(129,181,183,264,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(130,182,184,265,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(131,183,185,266,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(132,184,186,267,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(133,185,187,268,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(134,186,188,269,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(135,187,189,270,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(136,188,190,271,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(137,189,191,272,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(138,190,192,273,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(139,191,193,274,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(140,192,194,275,1,100.00,'2018-04-25 08:09:24','2018-04-25 08:09:24'),(142,194,196,277,1,100.00,'2018-04-25 08:22:19','2018-04-25 08:22:19'),(143,195,197,278,1,0.00,'2018-04-25 08:42:06','2018-05-02 08:39:07'),(144,196,198,279,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(145,196,198,280,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(146,197,199,281,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(147,197,199,282,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(148,198,200,283,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(149,198,200,284,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(150,199,201,285,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(151,199,201,286,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(152,200,202,287,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(153,200,202,288,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(154,201,203,289,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(155,201,203,290,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(156,202,204,291,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(157,202,204,292,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(158,203,205,293,7,100.00,'2018-04-25 11:29:23','2018-04-25 11:29:23'),(159,203,205,294,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(160,204,206,295,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(161,204,206,296,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(162,205,207,297,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(163,205,207,298,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(164,206,208,299,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(165,206,208,300,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(166,207,209,301,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(167,207,209,302,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(168,208,210,303,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(169,208,210,304,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(170,209,211,305,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(171,209,211,306,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(172,210,212,307,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(173,210,212,308,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(174,211,213,309,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(175,211,213,310,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(176,212,214,311,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(177,212,214,312,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(178,213,215,313,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(179,213,215,314,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(180,214,216,315,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(181,214,216,316,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(182,215,217,317,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(183,215,217,318,7,100.00,'2018-04-25 11:29:24','2018-04-25 11:29:24'),(184,216,218,319,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(185,216,218,320,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(186,217,219,321,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(187,217,219,322,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(188,218,220,323,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(189,218,220,324,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(190,219,221,325,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(191,219,221,326,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(192,220,222,327,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(193,220,222,328,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(194,221,223,329,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(195,221,223,330,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(196,222,224,331,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(197,222,224,332,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(198,223,225,333,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(199,223,225,334,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(200,224,226,335,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(201,224,226,336,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(202,225,227,337,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(203,225,227,338,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(204,226,228,339,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(205,226,228,340,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(206,227,229,341,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(207,227,229,342,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(208,228,230,343,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(209,228,230,344,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(210,229,231,345,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(211,229,231,346,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(212,230,232,347,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(213,230,232,348,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(214,231,233,349,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(215,231,233,350,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(216,232,234,351,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(217,232,234,352,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(218,233,235,353,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(219,233,235,354,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(220,234,236,355,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(221,234,236,356,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(222,235,237,357,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(223,235,237,358,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(224,236,238,359,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(225,236,238,360,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(226,237,239,361,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(227,237,239,362,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(228,238,240,363,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(229,238,240,364,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(230,239,241,365,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(231,239,241,366,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(232,240,242,367,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(233,240,242,368,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(234,241,243,369,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(235,241,243,370,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(236,242,244,371,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(237,242,244,372,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(238,243,245,373,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(239,243,245,374,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(240,244,246,375,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(241,244,246,376,7,100.00,'2018-04-25 11:29:25','2018-04-25 11:29:25'),(242,245,247,377,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(243,245,247,378,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(244,246,248,379,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(245,246,248,380,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(246,247,249,381,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(247,247,249,382,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(248,248,250,383,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(249,248,250,384,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(250,249,251,385,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(251,249,251,386,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(252,250,252,387,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(253,250,252,388,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(254,251,253,389,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(255,251,253,390,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(256,252,254,391,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(257,252,254,392,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(258,253,255,393,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(259,253,255,394,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(260,254,256,395,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(261,254,256,396,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(262,255,257,397,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(263,255,257,398,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(264,256,258,399,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(265,256,258,400,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(266,257,259,401,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(267,257,259,402,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(268,258,260,403,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(269,258,260,404,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(270,259,261,405,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(271,259,261,406,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(272,260,262,407,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(273,260,262,408,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(274,261,263,409,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(275,261,263,410,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(276,262,264,411,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(277,262,264,412,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(278,263,265,413,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(279,263,265,414,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(280,264,266,415,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(281,264,266,416,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(282,265,267,417,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(283,265,267,418,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(284,266,268,419,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(285,266,268,420,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(286,267,269,421,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(287,267,269,422,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(288,268,270,423,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(289,268,270,424,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(290,269,271,425,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(291,269,271,426,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(292,270,272,427,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(293,270,272,428,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(294,271,273,429,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(295,271,273,430,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(296,272,274,431,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(297,272,274,432,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(298,273,275,433,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(299,273,275,434,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(300,274,276,435,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(301,274,276,436,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(302,275,277,437,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(303,275,277,438,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(304,276,278,439,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(305,276,278,440,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(306,277,279,441,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(307,277,279,442,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(308,278,280,443,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(309,278,280,444,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(310,279,281,445,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(311,279,281,446,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(312,280,282,447,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(313,280,282,448,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(314,281,283,449,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(315,281,283,450,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(316,282,284,451,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(317,282,284,452,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(318,283,285,453,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(319,283,285,454,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(320,284,286,455,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(321,284,286,456,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(322,285,287,457,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(323,285,287,458,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(324,286,288,459,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(325,286,288,460,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(326,287,289,461,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(327,287,289,462,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(328,288,290,463,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(329,288,290,464,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(330,289,291,465,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(331,289,291,466,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(332,290,292,467,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(333,290,292,468,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(334,291,293,469,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(335,291,293,470,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(336,292,294,471,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(337,292,294,472,7,100.00,'2018-04-25 11:29:26','2018-04-25 11:29:26'),(338,2,2,4,5,1.00,'2018-05-01 05:56:50','2018-05-01 05:56:50'),(339,294,296,474,1,11.00,'2018-05-10 13:55:23','2018-05-10 13:55:23'),(340,1,1,1,1,20.00,'2018-05-14 13:45:05','2018-05-29 15:12:36'),(341,12,12,41,7,40.00,'2018-05-15 06:22:58','2018-05-15 06:51:11'),(342,311,307,485,1,10.00,'2018-05-16 10:39:43','2018-05-16 10:39:43'),(343,313,309,487,1,9.00,'2018-05-16 10:44:09','2018-05-17 11:19:01'),(344,312,308,486,1,9.00,'2018-05-16 10:44:09','2018-05-17 11:19:01'),(345,314,310,488,1,19.00,'2018-05-16 10:47:31','2018-05-17 11:19:01'),(346,315,311,489,1,59.00,'2018-05-21 12:17:04','2018-05-21 13:29:31'),(347,315,311,489,5,40.00,'2018-05-21 12:19:53','2018-05-21 12:19:53');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
INSERT INTO `variation_templates` VALUES (1,'Size (Tshirts)',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'Size (Shoes)',1,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(3,'Waist Size (Jeans)',1,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(4,'Color',1,'2018-01-06 07:12:52','2018-01-06 07:12:52');
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
INSERT INTO `variation_value_templates` VALUES (1,'S',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(2,'M',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(3,'L',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(4,'XL',1,'2018-01-03 21:22:13','2018-01-03 21:22:13'),(5,'5',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(6,'6',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(7,'7',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(8,'8',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(9,'9',2,'2018-01-03 21:23:21','2018-01-03 21:23:21'),(10,'28',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(11,'30',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(12,'32',3,'2018-01-03 21:24:34','2018-01-03 21:24:34'),(13,'34',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(14,'36',3,'2018-01-03 21:24:35','2018-01-03 21:24:35'),(16,'Black',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(17,'Blue',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(18,'Brown',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(19,'Grey',4,'2018-01-06 07:13:17','2018-01-06 07:13:17'),(20,'Gold',4,'2018-01-06 07:13:17','2018-01-06 07:13:17');
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `default_purchase_price` decimal(20,2) DEFAULT NULL,
  `dpp_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `profit_percent` decimal(20,2) NOT NULL DEFAULT '0.00',
  `default_sell_price` decimal(20,2) DEFAULT NULL,
  `sell_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=490 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'AS0001',1,130.00,143.00,0.00,130.00,143.00,'2018-01-03 15:59:08','2018-05-15 06:20:27',NULL),(2,'28',2,'AS0002-1',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-01-06 00:21:16',NULL),(3,'30',2,'AS0002-2',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-01-06 00:21:16',NULL),(4,'32',2,'AS0002-3',2,70.00,77.00,0.00,70.00,77.00,'2018-01-03 16:00:35','2018-01-06 00:21:16',NULL),(5,'34',2,'AS0002-4',2,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-01-06 00:21:16',NULL),(6,'36',2,'AS0002-5',2,72.00,79.20,0.00,72.00,79.20,'2018-01-03 16:00:35','2018-01-06 00:21:16',NULL),(7,'S',3,'AS0003-1',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-01-06 00:20:51',NULL),(8,'M',3,'AS0003-2',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-01-06 00:20:51',NULL),(9,'L',3,'AS0003-3',3,190.00,209.00,0.00,190.00,209.00,'2018-01-03 17:21:52','2018-01-06 00:20:51',NULL),(10,'XL',3,'AS0003-4',3,191.00,210.10,0.00,191.00,210.10,'2018-01-03 17:21:52','2018-01-06 00:20:51',NULL),(11,'6',4,'AS0004-1',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-01-05 23:49:36',NULL),(12,'7',4,'AS0004-2',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-01-05 23:49:36',NULL),(13,'8',4,'AS0004-3',4,165.00,181.50,0.00,165.00,181.50,'2018-01-03 17:24:34','2018-01-05 23:49:36',NULL),(14,'9',4,'AS0004-4',4,166.00,182.60,0.00,166.00,182.60,'2018-01-03 17:24:34','2018-01-05 23:49:36',NULL),(27,'6',8,'AS0008-1',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-01-05 23:48:46',NULL),(28,'7',8,'AS0008-2',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-01-05 23:48:46',NULL),(29,'8',8,'AS0008-3',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-01-05 23:48:46',NULL),(30,'9',8,'AS0008-4',8,110.00,121.00,0.00,110.00,121.00,'2018-01-03 17:40:10','2018-01-05 23:48:46',NULL),(31,'6',9,'AS0009-1',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-01-05 23:50:01',NULL),(32,'7',9,'AS0009-2',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-01-05 23:50:01',NULL),(33,'8',9,'AS0009-3',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-01-05 23:50:01',NULL),(34,'9',9,'AS0009-4',9,135.00,148.50,0.00,135.00,148.50,'2018-01-03 17:41:57','2018-01-05 23:50:01',NULL),(35,'5',10,'AS0010-1',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-01-05 23:49:20',NULL),(36,'6',10,'AS0010-2',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-01-05 23:49:20',NULL),(37,'7',10,'AS0010-3',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-01-05 23:49:20',NULL),(38,'8',10,'AS0010-4',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-01-05 23:49:20',NULL),(39,'9',10,'AS0010-5',10,150.00,165.00,0.00,150.00,165.00,'2018-01-03 17:43:02','2018-01-05 23:49:20',NULL),(40,'DUMMY',11,'AS0011',11,30.00,33.00,0.00,30.00,33.00,'2018-01-03 17:44:35','2018-01-03 17:44:35',NULL),(41,'DUMMY',12,'AS0012',12,25.00,27.50,0.00,25.00,27.50,'2018-01-03 17:45:50','2018-05-15 06:23:14',NULL),(42,'M',13,'AS0013-1',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-01-05 23:44:48',NULL),(43,'L',13,'AS0013-2',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-01-05 23:44:48',NULL),(44,'XL',13,'AS0013-3',13,60.00,66.00,0.00,60.00,66.00,'2018-01-03 17:47:59','2018-01-05 23:44:48',NULL),(45,'Gray',14,'AS0014-1',14,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-01-06 00:14:14',NULL),(46,'Black',14,'AS0014-2',14,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:12:19','2018-01-06 00:14:14',NULL),(47,'64 GB',14,'AS0014-1',15,700.00,770.00,25.00,875.00,962.50,'2018-01-06 00:14:14','2018-01-06 00:14:14',NULL),(48,'128 GB',14,'AS0014-2',15,800.00,880.00,25.00,1000.00,1100.00,'2018-01-06 00:14:14','2018-01-06 00:14:14',NULL),(49,'White',15,'AS0015-1',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-01-06 00:19:51',NULL),(50,'Gray',15,'AS0015-2',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-01-06 00:19:51',NULL),(51,'Black',15,'AS0015-3',16,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-01-06 00:19:51',NULL),(52,'32 GB',15,'AS0015-1',17,950.00,1045.00,25.00,1187.50,1306.25,'2018-01-06 00:19:51','2018-01-06 00:19:51',NULL),(53,'64 GB',15,'AS0015-2',17,1010.00,1111.00,25.00,1262.50,1388.75,'2018-01-06 00:19:51','2018-01-06 00:19:51',NULL),(54,'Gold',16,'AS0016-1',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-01-06 00:24:48',NULL),(55,'White',16,'AS0016-2',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-01-06 00:24:48',NULL),(56,'Black',16,'AS0016-3',18,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:24:48','2018-01-06 00:24:48',NULL),(57,'Black',17,'AS0017-1',19,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-01-06 00:35:01',NULL),(58,'White',17,'AS0017-2',19,350.00,350.00,25.00,437.50,437.50,'2018-01-06 00:35:01','2018-01-06 00:35:01',NULL),(59,'256 GB',18,'AS0018-1',20,1350.00,1350.00,25.00,1687.50,1687.50,'2018-01-06 00:37:30','2018-01-06 00:37:30',NULL),(60,'500 GB',18,'AS0018-2',20,1450.00,1450.00,25.00,1812.50,1812.50,'2018-01-06 00:37:30','2018-01-06 00:37:30',NULL),(61,'DUMMY',19,'AS0019',21,8.00,8.00,25.00,10.00,10.00,'2018-01-06 00:40:28','2018-01-06 00:40:28',NULL),(62,'Gray',20,'AS0020-1',22,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-01-06 00:43:00',NULL),(63,'Black',20,'AS0020-2',22,25.00,27.50,25.00,31.25,34.38,'2018-01-06 00:43:00','2018-01-06 00:43:00',NULL),(64,'DUMMY',21,'AS0021',23,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:46:35','2018-01-06 00:46:35',NULL),(65,'DUMMY',22,'AS0022',24,8.00,8.80,25.00,10.00,11.00,'2018-01-06 00:55:09','2018-01-06 00:55:09',NULL),(66,'DUMMY',23,'AS0023',25,10.00,10.00,25.00,12.50,12.50,'2018-01-06 00:56:27','2018-01-06 00:56:27',NULL),(67,'DUMMY',24,'AS0024',26,8.00,8.80,25.00,10.00,11.00,'2018-01-06 01:01:22','2018-01-06 01:01:22',NULL),(68,'DUMMY',25,'AS0025',27,15.00,15.00,25.00,18.75,18.75,'2018-01-06 01:02:23','2018-01-06 01:02:23',NULL),(69,'DUMMY',26,'AS0026',28,5.00,5.00,25.00,6.25,6.25,'2018-01-06 01:05:51','2018-01-06 01:05:51',NULL),(70,'DUMMY',27,'AS0027',29,20.00,22.00,25.00,25.00,27.50,'2018-01-06 01:13:16','2018-01-06 01:13:16',NULL),(71,'DUMMY',28,'AS0028',30,10.00,11.00,25.00,12.50,13.75,'2018-01-06 01:15:47','2018-01-06 01:15:47',NULL),(72,'DUMMY',29,'AS0029',31,12.00,12.00,25.00,15.00,15.00,'2018-01-06 01:16:53','2018-01-06 01:16:53',NULL),(73,'DUMMY',30,'AS0030',32,40.00,44.00,25.00,50.00,55.00,'2018-01-06 01:18:59','2018-01-06 01:18:59',NULL),(74,'DUMMY',31,'AP0031',33,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:36:29','2018-04-10 04:36:29',NULL),(75,'DUMMY',32,'AP0032',34,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:37:52','2018-04-10 04:37:52',NULL),(76,'DUMMY',33,'AP0033',35,12.00,12.00,25.00,15.00,15.00,'2018-04-10 04:39:45','2018-04-10 04:39:45',NULL),(77,'DUMMY',34,'AP0034',36,6.00,6.00,25.00,7.50,7.50,'2018-04-10 04:40:59','2018-04-10 04:40:59',NULL),(78,'DUMMY',35,'AP0035',37,7.00,7.00,25.00,8.75,8.75,'2018-04-10 04:42:53','2018-04-10 04:42:53',NULL),(79,'DUMMY',36,'AP0036',38,9.00,9.00,25.00,11.25,11.25,'2018-04-10 04:44:18','2018-04-10 04:44:18',NULL),(80,'DUMMY',37,'AP0037',39,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:01:29','2018-04-10 05:01:29',NULL),(81,'DUMMY',38,'AP0038',40,15.00,15.00,25.00,18.75,18.75,'2018-04-10 05:02:35','2018-04-10 05:02:35',NULL),(82,'DUMMY',39,'AP0039',41,12.00,12.00,25.00,15.00,15.00,'2018-04-10 05:03:26','2018-04-10 05:03:26',NULL),(83,'DUMMY',40,'AP0040',42,8.00,8.00,25.00,10.00,10.00,'2018-04-10 05:04:32','2018-04-10 05:04:49',NULL),(84,'DUMMY',41,'AE0041',43,500.00,500.00,25.00,625.00,625.00,'2018-04-10 05:38:27','2018-04-10 05:38:27',NULL),(85,'DUMMY',42,'AE0042',44,520.00,520.00,25.00,650.00,650.00,'2018-04-10 05:45:52','2018-04-10 06:21:21',NULL),(86,'DUMMY',43,'AE0043',45,400.00,400.00,25.00,500.00,500.00,'2018-04-10 05:48:01','2018-04-10 05:48:01',NULL),(87,'DUMMY',44,'AE0044',46,195.00,195.00,25.00,243.75,243.75,'2018-04-10 05:49:10','2018-04-10 05:49:10',NULL),(88,'DUMMY',45,'AE0045',47,300.00,300.00,25.00,375.00,375.00,'2018-04-10 05:50:22','2018-04-10 05:50:22',NULL),(89,'DUMMY',46,'AE0046',48,321.00,321.00,25.00,401.25,401.25,'2018-04-10 05:52:04','2018-04-10 05:52:04',NULL),(90,'DUMMY',47,'AE0047',49,255.00,255.00,25.00,318.75,318.75,'2018-04-10 05:53:45','2018-04-10 05:53:45',NULL),(91,'DUMMY',48,'AE0048',50,850.00,850.00,25.00,1062.50,1062.50,'2018-04-10 05:54:42','2018-04-10 06:22:07',NULL),(92,'DUMMY',49,'AE0049',51,1500.00,1500.00,25.00,1875.00,1875.00,'2018-04-10 05:55:55','2018-04-10 05:55:55',NULL),(93,'DUMMY',50,'AE0050',52,630.00,630.00,25.00,787.50,787.50,'2018-04-10 06:04:32','2018-04-10 06:04:32',NULL),(94,'DUMMY',51,'AS0051',53,100.00,100.00,25.00,125.00,125.00,'2018-04-10 07:04:57','2018-04-10 07:04:57',NULL),(95,'DUMMY',52,'AS0052',54,80.00,80.00,25.00,100.00,100.00,'2018-04-10 07:05:55','2018-04-10 07:05:55',NULL),(96,'DUMMY',53,'AS0053',55,105.00,105.00,25.00,131.25,131.25,'2018-04-10 07:09:15','2018-04-10 07:09:15',NULL),(97,'DUMMY',54,'AS0054',56,10.00,10.00,25.00,12.50,12.50,'2018-04-10 07:24:16','2018-04-10 07:24:16',NULL),(98,'DUMMY',55,'AS0055',57,8.00,8.00,25.00,10.00,10.00,'2018-04-10 07:26:18','2018-04-10 07:26:18',NULL),(99,'DUMMY',56,'AS0056',58,150.00,150.00,25.00,187.50,187.50,'2018-04-10 07:31:59','2018-04-10 07:31:59',NULL),(100,'DUMMY',57,'AS0057',59,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:01','2018-04-10 07:33:01',NULL),(101,'DUMMY',58,'AS0058',60,20.00,20.00,25.00,25.00,25.00,'2018-04-10 07:33:37','2018-04-10 07:33:37',NULL),(102,'DUMMY',59,'AS0059',61,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:36:45','2018-04-10 07:36:45',NULL),(103,'DUMMY',60,'AS0060',62,15.00,15.00,25.00,18.75,18.75,'2018-04-10 07:37:08','2018-04-10 07:37:08',NULL),(104,'DUMMY',61,'AS0061',63,100.00,100.00,25.00,125.00,125.00,'2018-04-20 10:52:37','2018-04-20 10:52:37',NULL),(105,'28',62,'AS0062-1',64,100.00,100.00,25.00,125.00,125.00,'2018-04-25 07:04:27','2018-04-25 08:15:46',NULL),(106,'30',62,'AS0062-2',64,120.00,120.00,25.00,150.00,150.00,'2018-04-25 07:04:27','2018-04-25 08:15:46',NULL),(107,'32',62,'AS0062-3',64,130.00,130.00,25.00,162.50,162.50,'2018-04-25 07:04:27','2018-04-25 08:15:46',NULL),(132,'28',71,'AS0071-1',73,100.00,100.00,25.00,125.00,125.00,'2018-04-25 07:12:05','2018-04-25 07:12:45',NULL),(133,'30',71,'AS0071-2',73,120.00,120.00,25.00,150.00,150.00,'2018-04-25 07:12:05','2018-04-25 07:12:45',NULL),(134,'32',71,'AS0071-3',73,130.00,130.00,25.00,162.50,162.50,'2018-04-25 07:12:05','2018-04-25 07:12:45',NULL),(159,'28',80,'AS0080-1',82,100.00,100.00,25.00,125.00,125.00,'2018-04-25 07:46:02','2018-04-25 07:46:25',NULL),(160,'30',80,'AS0080-2',82,120.00,120.00,25.00,150.00,150.00,'2018-04-25 07:46:02','2018-04-25 07:46:25',NULL),(161,'32',80,'AS0080-3',82,130.00,130.00,25.00,162.50,162.50,'2018-04-25 07:46:02','2018-04-25 07:46:25',NULL),(162,'28',81,'AS0080-1',83,100.00,100.00,25.00,125.00,125.00,'2018-04-25 07:48:31','2018-04-25 07:48:31',NULL),(163,'30',81,'AS0080-2',83,120.00,120.00,25.00,150.00,150.00,'2018-04-25 07:48:31','2018-04-25 07:48:31',NULL),(164,'32',81,'AS0080-3',83,130.00,130.00,25.00,162.50,162.50,'2018-04-25 07:48:31','2018-04-25 07:48:31',NULL),(165,'30',82,'000I5430-1',84,28500.00,33915.00,16.00,42773.00,42773.00,'2018-04-25 08:09:21','2018-04-25 08:09:21',NULL),(166,'32',83,'000I5432-1',85,28500.00,33915.00,16.00,42773.00,42773.00,'2018-04-25 08:09:22','2018-04-25 08:13:26',NULL),(167,'34',84,'15434-1',86,28500.00,33915.00,16.00,42773.00,42773.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(168,'36',85,'15436-1',87,28500.00,33915.00,16.00,42773.00,42773.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(169,'30',86,'15530-1',88,29500.00,35105.00,16.00,46639.00,46639.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(170,'32',87,'15532-1',89,29500.00,35105.00,16.00,46639.00,46639.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(171,'34',88,'15534-1',90,29500.00,35105.00,16.00,46639.00,46639.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(172,'36',89,'15536-1',91,29500.00,35105.00,16.00,46639.00,46639.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(173,'32',90,'17732-1',92,36000.00,42840.00,16.00,45294.00,45294.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(174,'34',91,'17734-1',93,36000.00,42840.00,16.00,45294.00,45294.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(175,'36',92,'177336-1',94,36000.00,42840.00,16.00,45294.00,45294.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(176,'38',93,'17738-1',95,36000.00,42840.00,16.00,45294.00,45294.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(177,'32',94,'12232-1',96,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(178,'34',95,'12234-1',97,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:22','2018-05-14 07:09:40',NULL),(179,'36',96,'12236-1',98,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(180,'38',97,'12238-1',99,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(181,'32',98,'8832-1',100,40000.00,47600.00,16.00,52857.00,52857.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(182,'34',99,'8834-1',101,40000.00,47600.00,16.00,52857.00,52857.00,'2018-04-25 08:09:22','2018-04-25 08:09:22',NULL),(183,'36',100,'8836-1',102,40000.00,47600.00,16.00,52857.00,52857.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(184,'38',101,'8838-1',103,40000.00,47600.00,16.00,52857.00,52857.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(185,'32',102,'51432-1',104,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(186,'34',103,'51434-1',105,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(187,'36',104,'51436-1',106,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(188,'38',105,'51438-1',107,37000.00,44030.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(189,'32',106,'51032-1',108,39000.00,46410.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(190,'34',107,'51034-1',109,39000.00,46410.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(191,'36',108,'51036-1',110,39000.00,46410.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(192,'38',109,'51036-1',111,39000.00,46410.00,16.00,50336.00,50336.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(193,'2',110,'2392-1',112,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(194,'4',111,'2394-1',113,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(195,'6',112,'2396-1',114,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(196,'8',113,'2398-1',115,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(197,'10',114,'23910-1',116,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(198,'12',115,'239212-1',117,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(199,'14',116,'239214-1',118,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(200,'16',117,'23916-1',119,21000.00,24990.00,16.00,26807.00,26807.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(201,'2',118,'24002-1',120,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(202,'4',119,'24004-1',121,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(203,'6',120,'24006-1',122,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(204,'8',121,'24008-1',123,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(205,'10',122,'24010-1',124,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(206,'12',123,'24012-1',125,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(207,'14',124,'24014-1',126,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(208,'16',125,'24016-1',127,19000.00,22610.00,16.00,23025.00,23025.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(209,'2',126,'25502-1',128,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(210,'4',127,'25504-1',129,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(211,'6',128,'25506-1',130,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(212,'8',129,'25508-1',131,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(213,'10',130,'25510-1',132,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(214,'12',131,'25512-1',133,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(215,'14',132,'25514-1',134,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(216,'16',133,'25516-1',135,25500.00,30345.00,16.00,29412.00,29412.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(217,'2',134,'28502-1',136,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(218,'4',135,'28504-1',137,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(219,'6',136,'28506-1',138,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(220,'8',137,'28508-1',139,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(221,'10',138,'28510-1',140,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(222,'12',139,'28512-1',141,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(223,'14',140,'28514-1',142,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(224,'16',141,'28516-1',143,24000.00,28560.00,16.00,27647.00,27647.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(225,'2',142,'27102-1',144,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(226,'4',143,'27104-1',145,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(227,'6',144,'27106-1',146,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(228,'8',145,'27108-1',147,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(229,'10',146,'27110-1',148,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(230,'12',147,'27112-1',149,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(231,'14',148,'27114-1',150,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(232,'16',149,'27116-1',151,19000.00,22610.00,16.00,22353.00,22353.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(233,'2',150,'34202-1',152,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(234,'4',151,'34204-1',153,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(235,'6',152,'34206-1',154,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(236,'8',153,'34208-1',155,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(237,'10',154,'34210-1',156,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(238,'12',155,'34212-1',157,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(239,'14',156,'34214-1',158,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(240,'16',157,'34216-1',159,10500.00,12495.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(241,'2',158,'34502-1',160,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(242,'4',159,'34504-1',161,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(243,'6',160,'34506-1',162,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(244,'8',161,'34508-1',163,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:23','2018-04-25 08:09:23',NULL),(245,'10',162,'34510-1',164,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(246,'12',163,'34512-1',165,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(247,'14',164,'34514-1',166,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(248,'16',165,'34516-1',167,9500.00,11305.00,16.00,12521.00,12521.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(249,'32',166,'7332-1',168,35000.00,41650.00,16.00,36723.00,36723.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(250,'34',167,'7334-1',169,35000.00,41650.00,16.00,36723.00,36723.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(251,'36',168,'7336-1',170,35000.00,41650.00,16.00,36723.00,36723.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(252,'38',169,'7338-1',171,35000.00,41650.00,16.00,36723.00,36723.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(253,'32',170,'7432-1',172,26000.00,30940.00,16.00,28571.00,28571.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(254,'34',171,'7434-1',173,26000.00,30940.00,16.00,28571.00,28571.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(255,'36',172,'7436-1',174,26000.00,30940.00,16.00,28571.00,28571.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(256,'38',173,'7438-1',175,26000.00,30940.00,16.00,28571.00,28571.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(257,'34',174,'39834-1',176,11000.00,13090.00,16.00,13866.00,13866.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(258,'36',175,'39836-1',177,11000.00,13090.00,16.00,13866.00,13866.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(259,'38',176,'39838-1',178,11000.00,13090.00,16.00,13866.00,13866.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(260,'34',177,'38834-1',179,26000.00,30940.00,16.00,30672.00,30672.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(261,'36',178,'38836-1',180,26000.00,30940.00,16.00,30672.00,30672.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(262,'38',179,'38838-1',181,26000.00,30940.00,16.00,30672.00,30672.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(263,'U',180,'394-1',182,8000.00,9520.00,16.00,10840.00,10840.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(264,'32',181,'50032-1',183,29964.00,35657.00,16.00,33193.00,33193.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(265,'34',182,'50034-1',184,29964.00,35657.00,16.00,33193.00,33193.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(266,'36',183,'50036-1',185,29964.00,35657.00,16.00,33193.00,33193.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(267,'38',184,'50038-1',186,29964.00,35657.00,16.00,33193.00,33193.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(268,'2',185,'27902-1',187,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(269,'4',186,'27904-1',188,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(270,'6',187,'27906-1',189,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(271,'8',188,'27908-1',190,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(272,'10',189,'27910-1',191,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(273,'12',190,'27912-1',192,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(274,'14',191,'27914-1',193,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(275,'16',192,'27916-1',194,20000.00,23800.00,16.00,24202.00,24202.00,'2018-04-25 08:09:24','2018-04-25 08:09:24',NULL),(277,'30',194,'000I5430-nik-1',196,28500.00,33915.00,16.00,42773.00,50899.87,'2018-04-25 08:22:19','2018-04-25 08:22:19',NULL),(278,'DUMMY',195,'single-nik',197,100.00,100.00,25.00,125.00,125.00,'2018-04-25 08:42:06','2018-04-25 08:42:26',NULL),(279,'S',196,'AS0196-1',198,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(280,'SURTIDO',196,'AS0196-2',198,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(281,'M',197,'AS0197-1',199,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(282,'SURTIDO',197,'AS0197-2',199,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(283,'XL',198,'AS0198-1',200,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(284,'SURTIDO',198,'AS0198-2',200,14928.00,14928.00,16.00,17563.00,17563.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(285,'S',199,'AS0199-1',201,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(286,'SURTIDO',199,'AS0199-2',201,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(287,'M',200,'AS0200-1',202,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(288,'SURTIDO',200,'AS0200-2',202,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(289,'L',201,'AS0201-1',203,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:31:55',NULL),(290,'SURTIDO',201,'AS0201-2',203,11357.00,11357.00,16.00,13361.00,13361.00,'2018-04-25 11:29:23','2018-04-25 11:31:55',NULL),(291,'S',202,'AS0202-1',204,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(292,'SURTIDO',202,'AS0202-2',204,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(293,'M',203,'AS0203-1',205,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(294,'SURTIDO',203,'AS0203-2',205,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:23','2018-04-25 11:29:23',NULL),(295,'L',204,'AS0204-1',206,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(296,'SURTIDO',204,'AS0204-2',206,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(297,'L',205,'AS0205-1',207,8928.00,8928.00,16.00,10504.00,10504.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(298,'SURTIDO',205,'AS0205-2',207,8928.00,8928.00,16.00,10504.00,10504.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(299,'XL',206,'AS0206-1',208,14142.00,14142.00,16.00,15882.00,15882.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(300,'SURTIDO',206,'AS0206-2',208,14142.00,14142.00,17.00,15882.00,15882.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(301,'M',207,'AS0207-1',209,14142.00,14142.00,16.00,15882.00,15882.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(302,'SURTIDO',207,'AS0207-2',209,14142.00,14142.00,17.00,15882.00,15882.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(303,'S',208,'AS0208-1',210,14142.00,14142.00,16.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(304,'SURTIDO',208,'AS0208-2',210,14142.00,14142.00,17.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(305,'M',209,'AS0209-1',211,14142.00,14142.00,16.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(306,'SURTIDO',209,'AS0209-2',211,14142.00,14142.00,17.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(307,'L',210,'AS0210-1',212,14142.00,14142.00,16.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(308,'SURTIDO',210,'AS0210-2',212,14142.00,14142.00,17.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(309,'XL',211,'AS0211-1',213,14142.00,14142.00,16.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(310,'SURTIDO',211,'AS0211-2',213,14142.00,14142.00,17.00,16639.00,16639.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(311,'S',212,'AS0212-1',214,12642.00,12642.00,16.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(312,'SURTIDO',212,'AS0212-2',214,12642.00,12642.00,17.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(313,'M',213,'AS0213-1',215,12642.00,12642.00,16.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(314,'SURTIDO',213,'AS0213-2',215,12642.00,12642.00,17.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(315,'L',214,'AS0214-1',216,12642.00,12642.00,16.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(316,'SURTIDO',214,'AS0214-2',216,12642.00,12642.00,17.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(317,'XL',215,'AS0215-1',217,12642.00,12642.00,16.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(318,'SURTIDO',215,'AS0215-2',217,12642.00,12642.00,17.00,14874.00,14874.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(319,'S',216,'AS0216-1',218,12785.00,12785.00,16.00,15042.00,15042.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(320,'SURTIDO',216,'AS0216-2',218,12785.00,12785.00,18.00,15042.00,15042.00,'2018-04-25 11:29:24','2018-04-25 11:29:24',NULL),(321,'M',217,'AS0217-1',219,12785.00,12785.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(322,'SURTIDO',217,'AS0217-2',219,12785.00,12785.00,18.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(323,'L',218,'AS0218-1',220,12785.00,12785.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(324,'SURTIDO',218,'AS0218-2',220,12785.00,12785.00,18.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(325,'XL',219,'AS0219-1',221,12785.00,12785.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(326,'SURTIDO',219,'AS0219-2',221,12785.00,12785.00,18.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(327,'S',220,'AS0220-1',222,10357.00,10357.00,16.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(328,'SURTIDO',220,'AS0220-2',222,10357.00,10357.00,18.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(329,'M',221,'AS0221-1',223,10357.00,10357.00,16.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(330,'SURTIDO',221,'AS0221-2',223,10357.00,10357.00,18.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(331,'L',222,'AS0222-1',224,10357.00,10357.00,16.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(332,'SURTIDO',222,'AS0222-2',224,10357.00,10357.00,18.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(333,'XL',223,'AS0223-1',225,10357.00,10357.00,16.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(334,'SURTIDO',223,'AS0223-2',225,10357.00,10357.00,18.00,12185.00,12185.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(335,'S',224,'AS0224-1',226,10357.00,10357.00,16.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(336,'SURTIDO',224,'AS0224-2',226,10357.00,10357.00,18.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(337,'M',225,'AS0225-1',227,10357.00,10357.00,16.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(338,'SURTIDO',225,'AS0225-2',227,10357.00,10357.00,18.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(339,'L',226,'AS0226-1',228,10357.00,10357.00,16.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(340,'SURTIDO',226,'AS0226-2',228,10357.00,10357.00,19.00,11765.00,11765.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(341,'S',227,'AS0227-1',229,17550.00,17550.00,16.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(342,'SURTIDO',227,'AS0227-2',229,17550.00,17550.00,19.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(343,'M',228,'AS0228-1',230,17550.00,17550.00,16.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(344,'SURTIDO',228,'AS0228-2',230,17550.00,17550.00,19.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(345,'L',229,'AS0229-1',231,17550.00,17550.00,16.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(346,'SURTIDO',229,'AS0229-2',231,17550.00,17550.00,19.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(347,'XL',230,'AS0230-1',232,17550.00,17550.00,16.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(348,'SURTIDO',230,'AS0230-2',232,17550.00,17550.00,19.00,20672.00,20672.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(349,'8',231,'AS0231-1',233,5051.00,5051.00,16.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(350,'SURTIDO',231,'AS0231-2',233,5051.00,5051.00,19.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(351,'10',232,'AS0232-1',234,5051.00,5051.00,16.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(352,'SURTIDO',232,'AS0232-2',234,5051.00,5051.00,19.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(353,'12',233,'AS0233-1',235,5051.00,5051.00,16.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(354,'SURTIDO',233,'AS0233-2',235,5051.00,5051.00,19.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(355,'14',234,'AS0234-1',236,5051.00,5051.00,16.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(356,'SURTIDO',234,'AS0234-2',236,5051.00,5051.00,19.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(357,'16',235,'AS0235-1',237,5051.00,5051.00,16.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(358,'SURTIDO',235,'AS0235-2',237,5051.00,5051.00,19.00,8319.00,8319.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(359,'M',236,'AS0236-1',238,12785.00,12785.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(360,'SURTIDO',236,'AS0236-2',238,12785.00,12785.00,20.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(361,'S',237,'AS0237-1',239,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(362,'SURTIDO',237,'AS0237-2',239,15642.00,15642.00,20.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(363,'M',238,'AS0238-1',240,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(364,'SURTIDO',238,'AS0238-2',240,15642.00,15642.00,20.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(365,'L',239,'AS0239-1',241,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(366,'SURTIDO',239,'AS0239-2',241,15642.00,15642.00,20.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(367,'XL',240,'AS0240-1',242,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(368,'SURTIDO',240,'AS0240-2',242,15642.00,15642.00,20.00,18403.00,18403.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(369,'S',241,'AS0241-1',243,12071.00,12071.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(370,'SURTIDO',241,'AS0241-2',243,12071.00,12071.00,20.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(371,'M',242,'AS0242-1',244,12071.00,12071.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(372,'SURTIDO',242,'AS0242-2',244,12071.00,12071.00,20.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(373,'L',243,'AS0243-1',245,12071.00,12071.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(374,'SURTIDO',243,'AS0243-2',245,12071.00,12071.00,20.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(375,'XL',244,'AS0244-1',246,12071.00,12071.00,16.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(376,'SURTIDO',244,'AS0244-2',246,12071.00,12071.00,20.00,15042.00,15042.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(377,'S',245,'AS0245-1',247,11071.00,11071.00,16.00,14538.00,14538.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(378,'SURTIDO',245,'AS0245-2',247,11071.00,11071.00,20.00,14538.00,14538.00,'2018-04-25 11:29:25','2018-04-25 11:29:25',NULL),(379,'M',246,'AS0246-1',248,11071.00,11071.00,16.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(380,'SURTIDO',246,'AS0246-2',248,11071.00,11071.00,21.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(381,'L',247,'AS0247-1',249,11071.00,11071.00,16.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(382,'SURTIDO',247,'AS0247-2',249,11071.00,11071.00,21.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(383,'XL',248,'AS0248-1',250,11071.00,11071.00,16.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(384,'SURTIDO',248,'AS0248-2',250,11071.00,11071.00,21.00,14538.00,14538.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(385,'S',249,'AS0249-1',251,11714.00,11714.00,16.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(386,'SURTIDO',249,'AS0249-2',251,11714.00,11714.00,21.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(387,'M',250,'AS0250-1',252,11714.00,11714.00,16.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(388,'SURTIDO',250,'AS0250-2',252,11714.00,11714.00,21.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(389,'L',251,'AS0251-1',253,11714.00,11714.00,16.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(390,'SURTIDO',251,'AS0251-2',253,11714.00,11714.00,21.00,13782.00,13782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(391,'S',252,'AS0252-1',254,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(392,'SURTIDO',252,'AS0252-2',254,15642.00,15642.00,21.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(393,'M',253,'AS0253-1',255,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(394,'SURTIDO',253,'AS0253-2',255,15642.00,15642.00,21.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(395,'L',254,'AS0254-1',256,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(396,'SURTIDO',254,'AS0254-2',256,15642.00,15642.00,21.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(397,'XL',255,'AS0255-1',257,15642.00,15642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(398,'SURTIDO',255,'AS0255-2',257,15642.00,15642.00,21.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(399,'M',256,'AS0256-1',258,14642.00,14642.00,16.00,17227.00,17227.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(400,'SURTIDO',256,'AS0256-2',258,14642.00,14642.00,22.00,17227.00,17227.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(401,'L',257,'AS0257-1',259,14642.00,14642.00,16.00,17227.00,17227.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(402,'SURTIDO',257,'AS0257-2',259,14642.00,14642.00,22.00,17227.00,17227.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(403,'S',258,'AS0258-1',260,14642.00,14642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(404,'SURTIDO',258,'AS0258-2',260,14642.00,14642.00,22.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(405,'M',259,'AS0259-1',261,14642.00,14642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(406,'SURTIDO',259,'AS0259-2',261,14642.00,14642.00,22.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(407,'XL',260,'AS0260-1',262,14642.00,14642.00,16.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(408,'SURTIDO',260,'AS0260-2',262,14642.00,14642.00,22.00,18403.00,18403.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(409,'S',261,'AS0261-1',263,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(410,'SURTIDO',261,'AS0261-2',263,15357.00,15357.00,22.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(411,'M',262,'AS0262-1',264,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(412,'SURTIDO',262,'AS0262-2',264,15357.00,15357.00,22.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(413,'L',263,'AS0263-1',265,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(414,'SURTIDO',263,'AS0263-2',265,15357.00,15357.00,22.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(415,'XL',264,'AS0264-1',266,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(416,'SURTIDO',264,'AS0264-2',266,15357.00,15357.00,22.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(417,'S',265,'AS0265-1',267,4642.00,4642.00,16.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(418,'SURTIDO',265,'AS0265-2',267,4642.00,4642.00,22.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(419,'M',266,'AS0266-1',268,4642.00,4642.00,16.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(420,'SURTIDO',266,'AS0266-2',268,4642.00,4642.00,23.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(421,'L',267,'AS0267-1',269,4642.00,4642.00,16.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(422,'SURTIDO',267,'AS0267-2',269,4642.00,4642.00,23.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(423,'XL',268,'AS0268-1',270,4642.00,4642.00,16.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(424,'SURTIDO',268,'AS0268-2',270,4642.00,4642.00,23.00,6639.00,6639.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(425,'L',269,'AS0269-1',271,9928.00,9928.00,16.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(426,'SURTIDO',269,'AS0269-2',271,9928.00,9928.00,23.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(427,'S',270,'AS0270-1',272,9928.00,9928.00,16.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(428,'SURTIDO',270,'AS0270-2',272,9928.00,9928.00,23.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(429,'L',271,'AS0271-1',273,9928.00,9928.00,16.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(430,'SURTIDO',271,'AS0271-2',273,9928.00,9928.00,23.00,11681.00,11681.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(431,'S',272,'AS0272-1',274,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(432,'SURTIDO',272,'AS0272-2',274,10642.00,10642.00,23.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(433,'M',273,'AS0273-1',275,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(434,'SURTIDO',273,'AS0273-2',275,10642.00,10642.00,23.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(435,'L',274,'AS0274-1',276,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(436,'SURTIDO',274,'AS0274-2',276,10642.00,10642.00,23.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(437,'XL',275,'AS0275-1',277,10642.00,10642.00,16.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(438,'SURTIDO',275,'AS0275-2',277,10642.00,10642.00,23.00,12521.00,12521.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(439,'S',276,'AS0276-1',278,20357.00,20357.00,16.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(440,'SURTIDO',276,'AS0276-2',278,20357.00,20357.00,24.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(441,'M',277,'AS0277-1',279,20357.00,20357.00,16.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(442,'SURTIDO',277,'AS0277-2',279,20357.00,20357.00,24.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(443,'L',278,'AS0278-1',280,20357.00,20357.00,16.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(444,'SURTIDO',278,'AS0278-2',280,20357.00,20357.00,24.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(445,'XL',279,'AS0279-1',281,20357.00,20357.00,16.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(446,'SURTIDO',279,'AS0279-2',281,20357.00,20357.00,24.00,23950.00,23950.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(447,'S',280,'AS0280-1',282,16142.00,16142.00,16.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(448,'SURTIDO',280,'AS0280-2',282,16142.00,16142.00,24.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(449,'M',281,'AS0281-1',283,16142.00,16142.00,16.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(450,'SURTIDO',281,'AS0281-2',283,16142.00,16142.00,24.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(451,'L',282,'AS0282-1',284,16142.00,16142.00,16.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(452,'SURTIDO',282,'AS0282-2',284,16142.00,16142.00,24.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(453,'XL',283,'AS0283-1',285,16142.00,16142.00,16.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(454,'SURTIDO',283,'AS0283-2',285,16142.00,16142.00,24.00,18992.00,18992.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(455,'S',284,'AS0284-1',286,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(456,'SURTIDO',284,'AS0284-2',286,15357.00,15357.00,24.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(457,'M',285,'AS0285-1',287,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(458,'SURTIDO',285,'AS0285-2',287,15357.00,15357.00,24.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(459,'L',286,'AS0286-1',288,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(460,'SURTIDO',286,'AS0286-2',288,15357.00,15357.00,25.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(461,'S',287,'AS0287-1',289,20214.00,20214.00,16.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(462,'SURTIDO',287,'AS0287-2',289,20214.00,20214.00,25.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(463,'M',288,'AS0288-1',290,20214.00,20214.00,16.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(464,'SURTIDO',288,'AS0288-2',290,20214.00,20214.00,25.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(465,'L',289,'AS0289-1',291,20214.00,20214.00,16.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(466,'SURTIDO',289,'AS0289-2',291,20214.00,20214.00,25.00,23782.00,23782.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(467,'S',290,'AS0290-1',292,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(468,'SURTIDO',290,'AS0290-2',292,15357.00,15357.00,25.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(469,'M',291,'AS0291-1',293,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(470,'SURTIDO',291,'AS0291-2',293,15357.00,15357.00,25.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(471,'L',292,'AS0292-1',294,15357.00,15357.00,16.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(472,'SURTIDO',292,'AS0292-2',294,15357.00,15357.00,25.00,18067.00,18067.00,'2018-04-25 11:29:26','2018-04-25 11:29:26',NULL),(473,'DUMMY',293,'AS0293',295,10000.00,10000.00,25.00,12500.00,12500.00,'2018-04-30 13:33:44','2018-04-30 13:33:44',NULL),(474,'DUMMY',294,'AS0294',296,100.00,100.00,25.00,125.00,125.00,'2018-05-10 13:19:08','2018-05-10 13:19:08',NULL),(475,'DUMMY',295,'with details',297,100.00,100.00,25.00,125.00,125.00,'2018-05-14 06:43:03','2018-05-14 07:15:09',NULL),(476,'DUMMY',296,'weight',298,1000.00,1000.00,25.00,1250.00,1250.00,'2018-05-14 07:26:46','2018-05-14 07:34:00',NULL),(477,'DUMMY',297,'AS0297',299,100.00,100.00,10.00,110.00,110.00,'2018-05-14 10:16:04','2018-05-14 10:16:04',NULL),(478,'DUMMY',298,'AS0298',300,100.00,100.00,10.00,110.00,110.00,'2018-05-14 10:17:00','2018-05-14 10:17:00',NULL),(479,'DUMMY',299,'AS0299',301,100.00,100.00,10.00,110.00,110.00,'2018-05-14 10:18:53','2018-05-14 10:18:53',NULL),(483,'DUMMY',309,'AS0309',305,100.00,100.00,10.00,110.00,110.00,'2018-05-14 10:44:51','2018-05-14 10:44:51',NULL),(484,'DUMMY',310,'AS0310',306,110.00,110.00,10.00,121.00,121.00,'2018-05-14 10:44:52','2018-05-14 10:44:52',NULL),(485,'DUMMY',311,'AS0311',307,100.00,100.00,10.00,110.00,110.00,'2018-05-16 10:39:23','2018-05-16 10:39:23',NULL),(486,'DUMMY',312,'AS0312',308,1200.00,1200.00,10.00,1320.00,1320.00,'2018-05-16 10:44:09','2018-05-16 10:44:09',NULL),(487,'DUMMY',313,'AS0313',309,1200.00,1200.00,10.00,1320.00,1320.00,'2018-05-16 10:44:09','2018-05-16 10:44:09',NULL),(488,'DUMMY',314,'AS0314',310,1200.00,1200.00,10.00,1320.00,1320.00,'2018-05-16 10:47:31','2018-05-16 10:47:31',NULL),(489,'s2',315,'sell return-1',311,100.00,100.00,25.00,125.00,125.00,'2018-05-21 12:16:40','2018-05-21 12:16:40',NULL);
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

