<?php $__env->startSection('title', __('account::lang.account_book')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('account::lang.account_book')); ?>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-sm-4 col-xs-6">
            <div class="box box-solid">
                <div class="box-body">
                    <table class="table">
                        <tr>
                            <th><?php echo e(app('translator')->getFromJson('account::lang.account_name')); ?>: </th>
                            <td><?php echo e($account->name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(app('translator')->getFromJson('account::lang.account_number')); ?>:</th>
                            <td><?php echo e($account->account_number); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(app('translator')->getFromJson('lang_v1.balance')); ?>:</th>
                            <td><span class="display_currency" data-currency_symbol="true"><?php echo e($account->balance); ?></span></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-8 col-xs-12">
            <div class="box box-solid">
                <div class="box-header">
                    <h3 class="box-title"> <i class="fa fa-filter" aria-hidden="true"></i> <?php echo e(app('translator')->getFromJson('report.filters')); ?>:</h3>
                </div>
                <div class="box-body">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?php echo Form::label('transaction_date_range', __('report.date_range') . ':'); ?>

                            <div class="input-group">
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                <?php echo Form::text('transaction_date_range', null, ['class' => 'form-control', 'readonly', 'placeholder' => __('report.date_range')]); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?php echo Form::label('transaction_type', __('account::lang.transaction_type') . ':'); ?>

                            <div class="input-group">
                                <span class="input-group-addon"><i class="fa fa-exchange"></i></span>
                                <?php echo Form::select('transaction_type', ['' => __('messages.all'),'debit' => __('account::lang.debit'), 'credit' => __('account::lang.credit')], '', ['class' => 'form-control']); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
        	<div class="box">
                <div class="box-body">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_account.view')): ?>
                        <div class="table-responsive">
                    	<table class="table table-bordered table-striped" id="account_book">
                    		<thead>
                    			<tr>
                                    <th><?php echo e(app('translator')->getFromJson( 'messages.date' )); ?></th>
                                    <th><?php echo e(app('translator')->getFromJson( 'lang_v1.description' )); ?></th>
                    				<th><?php echo e(app('translator')->getFromJson('account::lang.credit')); ?></th>
                                    <th><?php echo e(app('translator')->getFromJson('account::lang.debit')); ?></th>
                    				<th><?php echo e(app('translator')->getFromJson( 'lang_v1.balance' )); ?></th>
                    			</tr>
                    		</thead>
                    	</table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    

    <div class="modal fade account_model" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function(){
        
        // Account Book
        var account_book = $('#account_book').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: '<?php echo e(action("\Modules\Account\Http\Controllers\AccountController@show",[$account->id])); ?>',
                        "ordering": false,
                        "searching": false,
                        columns: [
                            {data: 'operation_date', name: 'operation_date'},
                            {data: 'sub_type', name: 'sub_type'},
                            {data: 'credit', name: 'amount'},
                            {data: 'debit', name: 'amount'},
                            {data: 'balance', name: 'balance'}
                        ],
                        "fnDrawCallback": function (oSettings) {
                            __currency_convert_recursively($('#account_book'));
                        }
                    });
        dateRangeSettings.autoUpdateInput = false
        $('#transaction_date_range').daterangepicker(
            dateRangeSettings,
            function (start, end) {
                $('#transaction_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
                var start = '';
                var end = '';
                if($('#transaction_date_range').val()){
                    start = $('input#transaction_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    end = $('input#transaction_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                }
                var transaction_type = $('select#transaction_type').val();
                account_book.ajax.url( '<?php echo e(action("\Modules\Account\Http\Controllers\AccountController@show",[$account->id])); ?>?start_date=' + start + '&end_date=' + end + '&type=' + transaction_type ).load();
            }
        );
        $('#transaction_type').change( function(){
            var start = '';
            var end = '';
            if($('#transaction_date_range').val()){
                start = $('input#transaction_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end = $('input#transaction_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            var transaction_type = $('select#transaction_type').val();
            account_book.ajax.url( '<?php echo e(action("\Modules\Account\Http\Controllers\AccountController@show",[$account->id])); ?>?start_date=' + start + '&end_date=' + end + '&type=' + transaction_type ).load();
        });
        $('#transaction_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $('#transaction_date_range').val('');
            account_book.ajax.url( '<?php echo e(action("\Modules\Account\Http\Controllers\AccountController@show",[$account->id])); ?>?start_date=' + start + '&end_date=' + end + '&type=' + transaction_type ).load();
        });

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>