<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap.min.css') }}" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/font-awesome.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap-datepicker3.min.css') }}" />
    <link rel='stylesheet' href="{{ asset('user/assets/css/bootstrap-table.min.css') }}">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>

    @if ($errors->any())
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                title: 'Validation Errors',
                html: `
                    <ul style="text-align: left; list-style-type: none; padding: 0;">
                        @foreach ($errors->all() as $error)
                            <li>⚠️ {{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        });
    </script>
@endif

    <style>
        .was-validated .invalid-unit,
        .invalid-unit {
            border: 2px solid red !important;
            /* Change the border color to red for invalid units */
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(.375em + .1875rem) center !important;
            background-size: calc(.75em + .375rem) calc(.75em + .375rem) !important;

        }
    </style>

</head>

<body class="bg_gray- bg-new-theme ff_omfs">
    <div class="header-home">
        <div class="row mx-0">
            <div class="col-lg-6 pl-lg-5 --ml-2 py-3">
                <div class="d-flex justify-content-around align-items-center logo-div">
                    <img src="{{ asset('user/assets/img/logo.svg') }}" alt="OMFS Calculator Logo" class="img-fluid"
                        height="38" />
                    <span class="separator mx-2 mx-md-0">|</span>
                    <h1 class="redhat-regular fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
                </div>
            </div>
            <div
                class="col-lg-6 d-flex justify-content-center justify-content-md-start justify-content-lg-end align-items-center text-white mb-3 mb-lg-0 pl-md-4 pl-lg-3">
                <div class="user-profile-icon">
                    <i class="fa fa-user" aria-hidden="true"></i>
                </div>
                <div class="fs_16 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> {{ \Auth::user()->email }}</div>
                <a href="{{ url('user/logout') }}" class="fw_5 btn btn-custom-2 text-white fs_16 ml-3">Logout</a>
            </div>
        </div>
    </div>

    <div class="row mx-0 calc_container">
        <div class="col-lg-3 px-0 bg-white mh-100 min-lg-vh-100 ">
            <div class="tab_head mt-3 mt-md-5 pt-3">
                <nav>
                    <div class="nav flex-lg-column nav-tabs nav-fill new-theme-tab" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link text-left active" id="physician-services-tab" data-toggle="tab"
                            href="{{route('physician.service')}}" role="tab" aria-controls="physician-services"
                            aria-selected="true"><span class="nav-tab-icon"></span>Physician Services</a>
                        <a class="nav-item nav-link text-left" id="e-service-tab" data-toggle="tab" href="{{route('pharmacy.service')}}"
                            role="tab" aria-controls="e-service" aria-selected="false"><span
                                class="pharmacy-tab-icon"></span>Pharmacy</a>
                        <a class="nav-item nav-link text-left" id="rfa-serving-tab" data-toggle="tab"
                            href="#rfa-serving" role="tab" aria-controls="rfa-serving" aria-selected="false"><span
                                class="nav-tab-icon"></span>RFA Serving</a>
                        <a class="nav-item nav-link text-left" id="pr2-service-tab" data-toggle="tab"
                            href="#pr2-service" role="tab" aria-controls="pr2-service" aria-selected="false"><span
                                class="nav-tab-icon"></span>PR2 Service</a>
                        <a class="nav-item nav-link text-left" id="claim-admin-dir-tab" data-toggle="tab"
                            href="#claim-admin-dir" role="tab" aria-controls="claim-admin-dir"
                            aria-selected="false"><span class="nav-tab-icon"></span>Claim Admin Directory</a>
                    </div>
                </nav>
            </div>
        </div>
        <div class="col-lg-9 px-md-5">

            <div class="tab_body tab-content new-theme-tab-content py-2 px-3 px-sm-0" id="nav-tabContent">
                <div class="tab-pane show active" id="physician-services" role="tabpanel"
                    aria-labelledby="physician-services-tab">
                    <div class="container-fluid">
                        <div class="row my-3 rounded">
                            <div class="col-md-6 px-0">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="is_cascading_bulk">
                                    <label class="custom-control-label" for="is_cascading_bulk">Multiple DOS Cascading</label>
                                </div>
                            </div>

                            <div class="col-md-6 px-0 text-right">
                                <div class="d-flex justify-content-end align-items-center #bulkCollapse">
                                    <div id="email_div">
                                        <div class="input-parent input-parent-email float-right hide-input-parent">
                                            <input type="text"
                                                class="form-control text-uppercase form-input rc_emails float-right"
                                                placeholder="Receiver email address" required
                                                style="width: 0; padding: 0;">
                                        </div>
                                        <div id="servicezipValidate" class="invalid-feedback">Please Enter valid Email
                                            Address</div>
                                    </div>
                                    <div class="custom-control custom-switch ml-3">
                                        <input type="checkbox" value="1"
                                            class="custom-control-input" id="is_pdf_bulk">
                                        <label class="custom-control-label" for="is_pdf_bulk">Pdf Result</label>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <div class="row bg-white position-relative">
                            <div class="position-absolute bulk-cascading-banner-left"
                                style=" min-width: 300px; height: 100%; width: 100%; max-width: 330px;"></div>
                            {{-- <div class="col-lg-4 col-xl-3 pl-0 "></div> --}}
                            <div class="col-lg-12 offset-xl-3 col-xl-6 text-center py-4" style="z-index: 1">
                                <h2 class="fw_7 fs_25 redhat-bold text-dark mb-3 mb-sm-0">Are you interested to get
                                    OMFS into Multiple DOS?</h2>

                                <span class="fw_7 fs_13 text-dark redhat-regular d-block mb-1 mt-2 ml-2">Download xlsx
                                    Template:</span>
                                <div class="mb-3 mt-2 inline_btn_compact justify-content-center cascading-btn"
                                    style="justify-content: center !important;">

                                    <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-md-2 rounded-100 samplefile btn-custom-1 w-auto text-white"
                                        href="{{ asset('user/bulk-template/SampleMultipleDOSOMFS.xlsx') }}" download><i
                                            class="fa fa-download mr-2" aria-hidden="true"></i><span
                                            class="sampletxt">Sample
                                            xlsx</span></a>
                                    <a class="btn text-white fs_14 py-2 collapsed mt-2 ml-2 rounded-100 btn-custom-2"
                                        data-toggle="collapse" href="#bulkCollapse" role="button"
                                        aria-expanded="false" aria-controls="bulkCollapse">Upload Multiple DOS</a>
                                </div>
                            </div>
                            {{-- <div class="col-lg-4 col-xl-3 pr-0 "></div> --}}
                            <div class="bulk-cascading-banner-right position-absolute"
                                style="right: 0; min-width: 300px; height: 100%; width: 100%; max-width: 330px;"></div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-sm-12">

                                <div class="collapse" id="bulkCollapse">
                                    <div class="card card-body border-0"
                                        style="background-color: #fff; border-radius: 10px;">
                                        <form method="POST" action="{{ url('user/bulk-report') }}" id="upload-file"
                                            enctype="multipart/form-data" class="was-validated">
                                            @csrf
                                            <input type="hidden" name="is_cascading_bulk" value="0"
                                                class="custom-control-input" id="is_cascading_bulk_h">

                                                 <input type="hidden" name="is_pdf_bulk" value="0"
                                                class="custom-control-input" id="is_pdf_bulk_h">

                                                 <input type="hidden" name="rc_email" value=""
                                                class="custom-control-input" id="rc_email_h">

                                            <div class="row">
                                                <div class="col-sm-12 text-left text-sm-right mb-3">
                                                    <div class="row">
                                                        <div class="col-md-12 text-left">
                                                            <div class="fw_7 fs_13 text-dark mb-1">Upload Your file
                                                                <span class="fs_12 fw_4">(xlsx format only):</span>
                                                            </div>

                                                        </div>

                                                        <div class="col-md-12 d-flex flex-row align-items-center">
                                                            <div class="fileBrowse">
                                                                <input type="file" class="fs_12" name="file"
                                                                    id="file" required />
                                                                <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                    width="50px" height="50px" />
                                                                <label for="file"></label>
                                                                <div class="invalid-feedback">xlsx file is required.
                                                                </div>
                                                            </div>
                                                            <div class="ml-2"style="min-width: 180px;">
                                                                <button type="submit"
                                                                    class="btn border-0 rounded-100 btn-custom-1 w-auto- text-white fs_15 px-0 bulk-submit"
                                                                    id="bulk-submit">
                                                                    Calculate Multiple DOS
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    {{-- Physician Content Start --}}
                    <h3 class="redhat-medium fw_5 fs_20 text-dark mb-3 mt-4">Physician Services</h3>
                    <form id="calc_form" method="POST" action="{{ url('user/single-report') }}" novalidate="">
                        @csrf
                        <div class="service_name">
                            <input type="hidden" class="" id="service_name" name="service_name"
                                placeholder="Select Service" value="Physician Services" />
                        </div>
                        <div class="row mt-lg-2 ">
                            <div class="col-sm-12">
                                <div class="form-group bg-white py-4 px-4">
                                    <div class="row">
                                        <div class="form_label col-sm-6 col-xl-3 mb-4">
                                            <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy)</span><span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="datepicker date input-group datepicker-new-theme">
                                                <div class="input-group-append ml-0"> <span
                                                        class="input-group-text pl-3"><i
                                                            class="fa fa-calendar"></i></span> </div>
                                                <input type="text" placeholder="MM/DD/YYYY"
                                                    class="form-control dos_input" id="dos" name="dos"
                                                    pattern="\d{2}/\d{2}/\d{4}" value="{{ old('dos') }}"
                                                    min="01/01/2000"  required="" />
                                                <div class="invalid-feedback datpicker-feedback pr-5">Select date of
                                                    service</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-sm-6 col-xl-3 mb-4">
                                            <label>Place of Service Type</label>
                                            <div class="custom-input-form d-flex align-items-center">
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="facility"
                                                        name="servicetype" value="Facility" required checked>
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="facility"><span>Facility</span></label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-facility" name="servicetype" value="Non-Facility"
                                                        required>
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="non-facility"><span>Non-Facility</span></label>
                                                </div>
                                                <div class="invalid-feedback">Select service type</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-12 col-xl-6  mb-4">
                                            <label>Provider Type</label>
                                            <div class="custom-input-form d-flex align-items-center">
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="physician"
                                                        name="providertype" value="Physician" required checked>
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="physician"><span>Physician</span></label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-physician" name="providertype" value="Non-Physician"
                                                        required>
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="non-physician"><span>Non-Physician</span></label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="clinical-soial-worker" name="providertype"
                                                        value="Clinical Soial Worker" required>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="clinical-soial-worker"><span>Clinical Soial
                                                            Worker</span></label>
                                                </div>
                                                <div class="invalid-feedback">Select provider type</div>
                                            </div>
                                        </div>


                                        <div id="convFactorDiv"
                                            class="form_label col-sm-6 col-xl-3 mt-2 mb-3 convFactorDiv">
                                            <label>Select Conversion Factor <span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="mb-3 select2-simple_select_div">
                                                <select id="conversionfactor"
                                                    class="simple_select select2-simple_select mb-3 mt-2"
                                                    name="conversionfactor" aria-label="Conversion Factor"
                                                    aria-describedby="conversionfactoralidate" required>
                                                    <option value="Radiology">Radiology
                                                    </option>
                                                    <option value="Anesthesia">Anesthesia</option>
                                                    <option value="Surgery">Surgery</option>
                                                    <option value="Other Services">Other Services</option>
                                                </select>
                                                <div id="conversionfactoralidate" class="invalid-feedback">Select
                                                    conversion factor</div>
                                            </div>
                                        </div>


                                        <div id="localityDiv"
                                            class="form_label col-sm-6 col-xl-3 mt-2 mb-3 localityDiv">
                                            <label>Find Place of Service Locality By</label>
                                            <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input"
                                                        type="radio" name="locality_type" id="county"
                                                        value="County" checked>
                                                    <label class="form-check-label fw_4 custom-control-label"
                                                        for="county"><span>County</span></label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input"
                                                        type="radio" name="locality_type" id="zipcode"
                                                        value="Zip-Code">
                                                    <label class="form-check-label fw_4 custom-control-label"
                                                        for="zipcode"><span>Zip-Code</span></label>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="form_label col-sm-6 col-xl-2 mt-2 mb-3">
                                            <label class="" for="state">State</label>
                                            <div class="select2-simple_select_div select2-state">
                                                <select id="locality_state" name="locality_state" aria-label="State"
                                                    class="js-example-responsive mb-3 form-control js-example-basic-single js-states locality_state select2-simple_select- select2-simple_select-with-search"
                                                    required>
                                                    @forelse($states as $state)
                                                        <option value="{{ $state->state }}">{{ $state->state }}
                                                        </option>
                                                    @empty
                                                    @endforelse

                                                </select>
                                                <div id="servicestateValidate" class="invalid-feedback">Select State
                                                </div>
                                            </div>

                                        </div>

                                        <div id="countyListDiv"
                                            class="form_label col-sm-6 col-xl-4 mt-2 mb-3 countyListDiv">
                                            <label for="calculation_locality_number">Place of Service County</label>
                                            <div class="mb-3 select2-simple_select_div select2-place-of-service">
                                                <select id="calculation_locality_number" name="locality_number"
                                                    aria-label="Place of Service County"
                                                    class="js-example-responsive mb-3 form-control js-example-basic-single js-states county select2-simple_select-with-search"
                                                    required>
                                                </select>

                                                <input type="hidden" class="localityname" name="locality_name"
                                                    id="localityname">
                                                <div id="servicecountyValidate" class="invalid-feedback">Select Place
                                                    of service </div>
                                            </div>
                                        </div>

                                        <div id="zipListDiv"
                                            class="form_label col-sm-6 col-xl-4 mt-2 mb-3 zipListDiv">
                                            <label for="servicezipValidate">Place of Service Zip Code</label>
                                            <div class="mb-3">
                                                <div class="input-parent input-parent-county">
                                                    <input type="text"
                                                        class="form-control text-uppercase localityzip form-input"
                                                        name="localityzip" placeholder="Service Zip Code" required />
                                                </div>
                                                <div id="servicezipValidate" class="invalid-feedback">Please Enter Zip
                                                    Code </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>


                            </div>

                        </div>

                        <div class="row mt-2 margin_up_minus">
                            <div class="col-sm-12">
                                {{-- <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">Bills</div> --}}
                                <h3 class="redhat-medium fw_5 fs_20 text-dark mb-3 mt-5">Bills</h3>
                            </div>
                        </div>



                        <div class="bill-section bg-white py-4 px-4">
                            <div class="row mobile-hidden d-xl-flex d-none">
                                <div class="col-6 col-sm-3 col-md-3">
                                    <div class="form_label">
                                        <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                    </div>
                                </div>
                                <div class="col-6 col-sm-3 col-md-3">
                                    <div class="form_label">
                                        <label>Modifiers <span class="text-red fs_12"></span></label>
                                    </div>
                                </div>
                                <div class="col-6 col-sm-3 col-md-3">
                                    <div class="form_label">
                                        <label>Units <span class="text-red fs_12">*</span></label>
                                    </div>
                                </div>
                                <div class="col-6 col-sm-3 col-md-3">
                                    <div class="form_label">
                                        <label>Payment Total <span class="text-red fs_12"></span></label>
                                    </div>
                                </div>
                            </div>
                            <div class="field_wrapper_main">
                                <div class="row select-container_main">
                                    <div class="col-6- col-md-6 col-xl-3">
                                        <div class="form_label mb-3">
                                            <label class="d-block d-xl-none">Procedure Code<span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="input-parent input-parent-cpt">
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase form-input"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                            </div>
                                            <div class="invalid-feedback code-feedback">Select procedure code</div>

                                        </div>
                                    </div>
                                    <div class="col-6- col-md-6 col-xl-3">
                                        <div class="form_label mb-3">
                                            <label class="d-block d-xl-none">Modifiers <span
                                                    class="text-red fs_12"></span></label>
                                            <div class="mb-3 select2-simple_select_div select2-modifiers">
                                                {{-- Add class "multiple="multiple" for multiple selections --}}
                                                <select name="singleReport[0][modifiers][]" multiple
                                                    class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select select2-simple_select-with-search">
                                                    {{-- Data imported from ajax --}}
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6- col-md-6 col-xl-3 ">
                                        <div class="form_label mb-3">
                                            <label class="d-block d-xl-none">Units <span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="input-parent input-parent-unit">
                                                <input type="text" class="form-control units form-input"
                                                    name="singleReport[0][units]" placeholder="1" value="1"
                                                    maxLength="3" required />
                                            </div>
                                            <div class="invalid-feedback unit-feedback">Select unit</div>
                                        </div>
                                    </div>
                                    <div class="col-6- col-md-6 col-xl-3">
                                        <div class="form_label mb-3 ">
                                            <label class="d-block d-xl-none">Payment Total <span
                                                    class="text-red fs_12"></span></label>
                                            <div class="last_field">
                                                <div class="input-parent input-parent-charges">
                                                    <input type="text" class="form-control charges form-input"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                </div>
                                                <div class="removeField">
                                                    <a href='javascript:void(0);' class='remove_button'><i
                                                            class='fa fa-remove' aria-hidden='true'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-5">
                                    <div class="text-right d-flex">
                                        <button type="submit"
                                            class="btn border-0 btn-custom-1 w-auto fs_15 text-white rounded-100"
                                            id="submitButton">Calculate</button>
                                    </div>
                                </div>
                            </div>
                            {{-- ------------------------------------------------------------------------- --}}

                            {{-- <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code<span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections -- }}
                                                    <select name="singleReport[0][modifiers][]" multiple
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">
                                                        {{-- Data imported from ajax -- }}
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="1" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}
                            {{-- ------------------------------------------------------------------------- --}}
                        </div>


                        {{-- <div class='row select-container_main'>
    <div class='col-6 col-sm-3 col-md-3'> <div class='form_label mb-3 input-parent input-parent-cpt'> <label class='d-block d-sm-none'>Procedure Code <span class='text-red fs_12'>*</span></label> <input type='text' class='form-control inc_main cptcode text-uppercase append_field  form-input' name='singleReport["+index_main+"][cptcode]' placeholder='CPT code' value='' pattern='[a-zA-Z0-9]{1,5}'' maxLength='5'/> <div class='invalid-feedback'>Select procedure code</div> </div> </div>
    <div class='col-6 col-sm-3 col-md-3'> <div class='form_label mb-3 input-parent input-parent-cpt'> <label class='d-block d-sm-none'>Modifiers <span class='text-red fs_12'></span></label> <div class='mb-3 mod_selector_main select2-simple_select_div select2-modifiers'></div> </div> </div>
    <div class='col-6 col-sm-3 col-md-3'> <div class='form_label mb-3 input-parent input-parent-cpt'> <label class='d-block d-sm-none'>Units <span class='text-red fs_12'>*</span></label> <input type='text' class='form-control units  form-input' name='singleReport["+index_main+"][units]' placeholder='0' value='1' maxLength='3' required/> <div class='invalid-feedback'>Select unit</div> </div> </div>
    <div class='col-6 col-sm-3 col-md-3'> <div class='form_label mb-3 input-parent input-parent-cpt'> <label class='d-block d-sm-none'>Charges <span class='text-red fs_12'></span></label> <div class='last_field'> <input type='text' class='form-control charges  form-input' name='singleReport["+index_main+"][payment_total]' placeholder='0.00'  value='0' maxLength='5' /> <div class='removeField'><a href='javascript:void(0);' class='remove_button'><i class='fa fa-remove' aria-hidden='true'></i></a></div> </div> </div> </div>
</div> --}}



                    </form>

                    {{-- Physician Content End --}}
                </div>

            </div>
        </div>
    </div>

    <script>
        window.baseUrl = "{{ url('/') }}";
    </script>

    {{-- <script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script> --}}
    <script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('user/assets/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-export.js') }}"></script>
    <script src="{{ asset('user/assets/js/tableExport.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-filter-control.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="{{ asset('user/assets/js/dynamic_cpt_row_main.js') }}"></script>
    <script src="{{ asset('user/assets/js/custom.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    @if (\Session::has('message'))
        <script>
            // Display SweetAlert error message using the message from the session
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "{!! \Session::get('message') !!}"
            });
        </script>
    @endif


    <script>
        $(document).ready(function() {

            $('.select2-simple_select').select2({
                minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });

            $('.select2-simple_select-with-search').select2({
                // minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });
            $('.select2-state .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "state",
            });
            $('.select2-place-of-service .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Service Zip Code",
            });
            $('.select2-modifiers .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Modifiers",
                allowClear: true,
            });

            $('.locality_state').val("CA").trigger('change');
            $('.localitytype').trigger('change');

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {

                var tabId = $(e.target).html(); // Get activated tab's ID
                $("#service_name").val(tabId);
                $('form')[0].reset();
                $('.locality_state').val("CA").trigger('change');
                $('.localitytype').trigger('change');

                var href = $(e.target).attr('href');
            if (href && href.startsWith('http')) {
                window.location.href = href; // Redirect to the URL
            }
            });


        });

        // function getDate() {
        //     const selectedDos = document.querySelector('.tab-pane.show.active .dos_input').value;
        //     if (selectedDos.length > 0) {
        //         if (!moment(selectedDos).isBetween('12/31/1999', '03/01/2017')) {
        //             document.getElementById("conversionfactor").options[1].style.display = 'block';
        //             document.getElementById("conversionfactor").options[3].style.display = 'block';
        //             document.getElementById("conversionfactor").value = 'Other Services';
        //         }
        //     }
        // }

        $(function() {
            /*Date Comparison*/
            $(".dos_input").on("change", function() {
                var sb_dos_selected = $(this).val();
                if (moment(sb_dos_selected).isAfter(moment('02/28/2017', 'MM/DD/YYYY'))) {
                    $(".convFactorDiv select option[value='Other Services']").attr('selected', 'selected');

                    $("#conversionfactor").val("Other Services").trigger('change');

                }
                var state = $(".locality_state").val();
                fetchServicePlaces(state, sb_dos_selected)
            });

            window.onpageshow = function(event) {
                if (event.persisted) {
                    window.location.reload();
                    document.getElementById("upload-file").reset();
                }
            };
        });


        $(document).ready(function() {
            // Handle form submission
            $('#upload-file').submit(function(event) {
                event.preventDefault();

                var rc_email = $(".rc_emails").val();
                if ($("#is_pdf_bulk").prop('checked')) {
                    if (rc_email && validateEmail(rc_email)) {
                         Swal.fire({
                            icon:"info",
                            text: "You will receive an email with PDF reporting details shortly after the Multiple DOS processing is complete."
                        });
                        setTimeout(function() {
                        $('#upload-file')[0].submit();

                        }, 2000);

                        $("#is_pdf_bulk_h").val(1)
                        $("#rc_email_h").val(rc_email)

                    } else {


                        Swal.fire({
                            icon: 'error',
                            title: 'Valid Receiver Email',
                            text: "Please enter a valid email address."
                        });
                    }
                } else {
                    $('#upload-file')[0].submit();

                }

            });

            function validateEmail(email) {
                var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return re.test(email);
            }

            $('#calc_form').submit(function(event) {
                event.preventDefault(); // Prevent default form submission
                isValid = true;
                $('.units').each(function() {
                    let unitInput = $(this);
                    let unitValue = parseInt(unitInput.val());
                    if (unitValue < 1) {
                        isValid = false;
                        unitInput.val('')
                    } else {
                        unitInput.removeClass('invalid-unit');
                    }
                });

                if (isValid) {
                    $("#submitButton").prop('disabled', true);
                    $("#submitButton").html('Calculating...');
                    var formData = $(this).serialize();
                    $.ajax({
                        url: "{{ route('edit-report') }}", // Form action URL
                        method: 'POST',
                        data: formData,
                        success: function(response) {
                            if (response.error) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Calculation Error',
                                    text: response.error
                                });

                                $("#submitButton").prop('disabled', false);
                                $("#submitButton").html('Calculate');
                            } else {
                                $('#calc_form')[0].submit();
                            }



                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: "Something Went Wrong!"
                            });

                            $("#submitButton").prop('disabled', false);
                            $("#submitButton").html('Calculate');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Invalid Unit!',
                        text: 'Please enter a unit value that is at least 1.'
                    });

                    $("#submitButton").prop('disabled', false);
                    $("#submitButton").html('Calculate');
                }
            });

        });



        //calculation_locality_number

        $('.county').on('change', function() {
            // Get the selected state value
            var selectedOption = $(this).find('option:selected');
            var selectedText = selectedOption.text();
            $(".localityname").val(selectedText);

        });

        $('#is_cascading_bulk').on('change', function() {
            if ($(this).prop('checked')) {
                $("#is_cascading_bulk_h").val(1);
                $(".sampletxt").html('Multiple DOS Sample xlsx');
                $(".samplefile").attr("href", "{{ asset('user/bulk-template/MultipleDOSCascadingTemplate.xlsx') }}")
            } else {
                $("#is_cascading_bulk_h").val(0);
                $(".sampletxt").html('Sample xlsx');
                $(".samplefile").attr("href", "{{ asset('user/bulk-template/SampleMultipleDOSOMFS.xlsx') }}")


            }
        });

        $("#is_pdf_bulk").on('change', function() {
            console.log("test");

            $("#email_div input").css("transition", "0.4s");

            if ($(this).prop('checked')) {

                $("#email_div input").css("width", "100%");
                $("#email_div input").css("padding", "14px 60px")
                setTimeout(() => {
                    $("#email_div .input-parent-email").removeClass("hide-input-parent");
                }, 300);

            } else {
                $("#email_div input").css("width", "0%");
                $("#email_div input").css("padding", "0");

                $("#email_div .input-parent-email").addClass('hide-input-parent');
            }
        });

        $('.locality_state').on('change', function() {
            // Get the selected state value
            var state = $(this).val();
            var dateofservice = $(".dos_input").val();
            // Call the fetchServicePlaces function with the selected state value
            fetchServicePlaces(state, dateofservice);
        });

        $('.localitytype').change(function() {
            var checkedValue = $(this).val(); // Get the value of the changed checkbox

            if ($(this).is(':checked')) {
                console.log(checkedValue); // Output the checked value

                if (checkedValue === "County") {
                    $(".zipListDiv").hide();
                    $('.localityzip').prop('required', false);
                    $("#calculation_locality_number").prop('required', true);
                    $(".countyListDiv").show();

                } else {
                    $(".zipListDiv").show();
                    $('.localityzip').prop('required', true);
                    $("#calculation_locality_number").prop('required', false);

                    $(".countyListDiv").hide();
                }
            }
        });


        function fetchServicePlaces(state, doservice) {
            $.ajax({
                url: '{{ route('placeOfServiceList') }}',
                type: 'GET',
                data: {
                    state: state,
                    dos: doservice
                },
                success: function(response) {
                    // Clear previous options
                    $('.county').empty();

                    // Iterate over each response item and append an option
                    $.each(response, function(index, item) {
                        $('.county').append('<option value="' + item
                            .locality_number + '">' + item.locality_name + "-" + item
                            .locality_number +
                            ' </option>');
                        $('.county').trigger("change");
                    });
                    $('.localitytype').trigger('change');

                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    </script>

</body>

</html>
