<?php

namespace App\Imports;

use App\Models\OMFSALL;
use DateTime;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class OmfsImport implements ToModel, WithHeadingRow, WithValidation
{
    protected $errors = [];

    public function rules(): array
    {
        return [
            'conv_factor_values' => 'required',
            'hcpcs' => 'required',
            'dos' => 'required|numeric',
            'doe' => 'required|numeric',
            'mod' => 'required',
            'description' => 'required',
            'status_code' => 'required',
            'work_rvu' => 'required',
            'non_fac_pe_rvu' => 'required',
            'facility_pe_rvu' => 'required',
            'mp_rvu' => 'required',
            'non_facility_total' => 'required',
            'facility_total' => 'required',
            'pctc_ind' => 'required',
            'glob_days' => 'required',
            'pre_op' => 'required',
            'intra_op' => 'required',
            'post_op' => 'required',
            'mult_proc' => 'required',
            'bilat_surg' => 'required',
            'asst_surg' => 'required',
            'co_surg' => 'required',
            'team_surg' => 'required',
            'physician_supervision_of_diagnostic_procedures' => 'required',
            'calculation_flag' => 'required',
            'diagnostic_imaging_family_indicator' => 'required',
            'non_facility_pe_used_for_opps_payment_amount' => 'required',
            'facility_pe_used_for_opps_payment_amount' => 'required',
            'mp_used_for_opps_payment_amount' => 'required',
            'i_id' => 'required',

        ];
    }


    public function model(array $row)
    {


        try {

            // Convert Excel date strings to DateTime objects
            $dos = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['dos']);
            $doe = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['doe']);
        } catch (\Exception $e) {
            // If conversion fails, add an error message
            $this->errors[] = [
                'message' => "Invalid date format for DOS or DOE",
                'row' => $row,
            ];
             return null; // Skip this row
        }

        $existingOmfs = OMFSALL::where('hcpcs', $row['hcpcs'])
            ->where('dos', $dos)
            ->where('doe', $doe)
            ->first();

        if ($existingOmfs) {
            // Handle duplicate Omfs
            // For example, update the existing Omfs with new data
            $existingOmfs->update([
                'conv_factor' => $row['conv_factor_values'],
                'mod' => $row['mod'],
                'description' => $row['description'],
                'status_code' => $row['status_code'],
                'not_used_for_medicare_payment' => $row['not_used_for_medicare_payment'] ?? null,
                'work_rvu' => $row['work_rvu'],
                'non_fac_pe_rvu' => $row['non_fac_pe_rvu'],
                'non_fac_na_indicator' => $row['non_fac_na_indicator'] ?? null,
                'facility_pe_rvu' => $row['facility_pe_rvu'],
                'facility_na_indicator' => $row['facility_na_indicator'] ?? null,
                'mp_rvu' => $row['mp_rvu'],
                'non_facility_total' => $row['non_facility_total'],
                'facility_total' => $row['facility_total'],
                'pctc_ind' => $row['pctc_ind'],
                'glob_days' => $row['glob_days'],
                'pre_op' => $row['pre_op'],
                'intra_op' => $row['intra_op'],
                'post_op' => $row['post_op'],
                'mult_proc' => $row['mult_proc'],
                'bilat_surg' => $row['bilat_surg'],
                'asst_surg' => $row['asst_surg'],
                'co_surg' => $row['co_surg'],
                'team_surg' => $row['team_surg'],
                'endo_base' => $row['endo_base'] ?? null,
                'physician_supervision_of_diagnostic_procedures' => $row['physician_supervision_of_diagnostic_procedures'],
                'calculation_flag' => $row['calculation_flag'],
                'diagnostic_imaging_family_indicator' => $row['diagnostic_imaging_family_indicator'],
                'non_facility_pe_used_for_opps_payment_amount' => $row['non_facility_pe_used_for_opps_payment_amount'],
                'facility_pe_used_for_opps_payment_amount' => $row['facility_pe_used_for_opps_payment_amount'],
                'mp_used_for_opps_payment_amount' => $row['mp_used_for_opps_payment_amount'],
                'i_id' => $row['i_id']
                // Update other attributes as needed
            ]);
            return null; // Skip this row
        }

        return OMFSALL::create([
            'conv_factor' => $row['conv_factor_values'],
            'hcpcs' => $row['hcpcs'],
            'dos' => $dos,
            'doe' => $doe,
            'mod' => $row['mod'],
            'description' => $row['description'],
            'status_code' => $row['status_code'],
            'not_used_for_medicare_payment' => $row['not_used_for_medicare_payment'] ?? null,
            'work_rvu' => $row['work_rvu'],
            'non_fac_pe_rvu' => $row['non_fac_pe_rvu'],
            'non_fac_na_indicator' => $row['non_fac_na_indicator'] ?? null,
            'facility_pe_rvu' => $row['facility_pe_rvu'],
            'facility_na_indicator' => $row['facility_na_indicator'] ?? null,
            'mp_rvu' => $row['mp_rvu'],
            'non_facility_total' => $row['non_facility_total'],
            'facility_total' => $row['facility_total'],
            'pctc_ind' => $row['pctc_ind'],
            'glob_days' => $row['glob_days'],
            'pre_op' => $row['pre_op'],
            'intra_op' => $row['intra_op'],
            'post_op' => $row['post_op'],
            'mult_proc' => $row['mult_proc'],
            'bilat_surg' => $row['bilat_surg'],
            'asst_surg' => $row['asst_surg'],
            'co_surg' => $row['co_surg'],
            'team_surg' => $row['team_surg'],
            'endo_base' => $row['endo_base'] ?? null,
            'physician_supervision_of_diagnostic_procedures' => $row['physician_supervision_of_diagnostic_procedures'],
            'calculation_flag' => $row['calculation_flag'],
            'diagnostic_imaging_family_indicator' => $row['diagnostic_imaging_family_indicator'],
            'non_facility_pe_used_for_opps_payment_amount' => $row['non_facility_pe_used_for_opps_payment_amount'],
            'facility_pe_used_for_opps_payment_amount' => $row['facility_pe_used_for_opps_payment_amount'],
            'mp_used_for_opps_payment_amount' => $row['mp_used_for_opps_payment_amount'],
            'i_id' => $row['i_id']
        ]);
    }

    public function batchSize(): int
    {
        return 1000; // Adjust batch size as needed
    }

    public function chunkSize(): int
    {
        return 1000; // Adjust chunk size as needed
    }




}
