<?php

namespace App\Imports;

use App\Models\BulkCascadeUpload;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\BulkOmfs;

class OmfsCascadeBulk implements ToModel,WithHeadingRow, WithValidation
{
   
    protected $errors = [];
    private $currentdatetime;

    public function __construct() {
        $this->currentdatetime = date('Y-m-d H:i:s');
    }

    public function rules(): array
    {
        return [
            'patientregid' => 'required',
            'servicetype' => 'required',
            'dateofservice' => 'required|numeric',
            'placetype' => 'required',
            'providertype' => 'required',
            'localitytype' => 'required',
            'localitystate' => 'required',
            // 'locality_number' => 'required',
            // 'locality_name' => 'required',
            // 'localityzip' => 'required',
            'cptcode' => 'required',
            'unit' => 'required|integer|min:1',
            'charges' => 'required',
            // 'modifiers' => 'required',
        

        ];
    }

    public function model(array $row)
    {
        try {

            // Convert Excel date strings to DateTime objects
            $dos = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['dateofservice']);
        } catch (\Exception $e) {
            // If conversion fails, add an error message
            $this->errors[] = [
                'message' => "Invalid date format for Date of service",
                'row' => $row,
            ];
             return null; // Skip this row
        }

      

        return BulkCascadeUpload::create([
            'patientregid' => $row['patientregid'],
            'bulk_id' => $this->currentdatetime ,
            'service_name' => $row['servicetype'],
            'dos' => $dos,
            'service_type' => $row['placetype'],
            'provider_type' => $row['providertype'],
            'conversion_factor' => "Other Services",
            'locality_type' => $row['localitytype'],
            'locality_state' => $row['localitystate'],
            'locality_number' => $row['localitynumber'],
            'locality_name' => $row['localityname'],
            'localityzip' => $row['zipcode'],
            'cptcode' => $row['cptcode'],
            'units' => $row['unit'],
            'payment_total' => $row['charges'],
            'modifiers' => $row['modifier'],
        ]);

    }

    public function getbulkid()
    {
        return $this->currentdatetime;
    }

    public function batchSize(): int
    {
        return 1000; // Adjust batch size as needed
    }

    public function chunkSize(): int
    {
        return 1000; // Adjust chunk size as needed
    }

    public function onError(\Throwable $e)
    {
        // Handle errors
        $this->errors[] = $e->getMessage();
    }

    public function failures()
    {
        return $this->errors;
    }


}
