<?php

namespace App\Http\Controllers;

use App\Exports\BulreportExport;
use App\Exports\OmfsCascadereport;
use App\Imports\OmfsBulk;
use App\Imports\OmfsCascadeBulk;
use App\Jobs\ProcessBulkPdf;
use App\Models\BulkCascadeUpload;
use App\Models\BulkOmfs;
use App\Models\Bulkresponse;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PDF;
use App\Models\File;
use App\Models\gpci;
use App\Models\Locality;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Facades\Excel;
use PDOException;

//use Illuminate\Support\Collection;
//use Illuminate\Pagination\LengthAwarePaginator;

class HomeController extends Controller
{
    function home_load()
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }


        $states = gpci::select('state')
            ->distinct()
            ->get();
        // $user_email = Auth::user()->email;
        return view("services.physician.home", compact('states'));
    }

    public function modifierList()
    {
        $modifiers = DB::select(DB::raw("SELECT * FROM modifiers"));
        $list = view('services.physician.modifiers_list', ['list' => $modifiers])->render();
        return response()->json($list);
    }


    public function placeofservicelist(request $request)
    {
        $serviceplaces = gpci::select('locality_number', 'locality_name', 'state', 'dos', 'doe')
            ->where('state', '=', $request->state)
            ->whereRaw("STR_TO_DATE('$request->dos', '%m/%d/%Y') between dos and doe")
            ->distinct()
            ->get();

        return response()->json($serviceplaces);
    }

    public static function single_report_load_query($request,$api = false)
    {
        $login_user_email = "omfs@gmail.com";
        $p_Service_Name  = $request->service_name;

        $p_Data_of_Service = date('Y-m-d', strtotime($request->dos));
        $p_Service_Type = $request->servicetype;
        $p_Provider_Type = $request->providertype;
        $p_Conversion_Factor = $request->conversionfactor;
        $locality_type = $request->locality_type;
        $p_Locality_Name = '';
        $p_Locality_number = null;
        $p_Locality_zip = '';
        $p_Locality_state = $request->locality_state;
        $iscascading = $request->is_cascade ?? true;

        if ($locality_type == "County") {
            $p_Locality_Name = $request->locality_name;
            $p_Locality_number = $request->locality_number;
        } else {
            $p_Locality_zip = $request->localityzip;
        }




        // $p_Locality_state = $request->locality_state;
        if ($p_Locality_Name != '') {


            $lastDashPosition = strrpos($p_Locality_Name, '-');
            if ($lastDashPosition !== false) {
                // Extract the substring before the last occurrence of '-'
                $p_Locality_Namenonnum = substr($p_Locality_Name, 0, $lastDashPosition);
            }
        } else {
            $p_Locality_Namenonnum = null;
        }

        $data = [];
        $count = 0;
        if (count($request->singleReport) > 1 && $iscascading) {
            $bulk_id = now();
            $cascadeupload = null;
            foreach ($request->singleReport as $key => $value) {
                if (count($value) == 3) {
                    $value['modifiers'] = '';
                }
                if (is_array($value['modifiers'])) {
                    // $value['modifiers'] is an array, implode its elements with comma
                    $modifiersString = implode(',', $value['modifiers']);
                } else {
                    // $value['modifiers'] is not an array, keep it as is
                    $modifiersString = $value['modifiers'];
                }
                try {
                    DB::beginTransaction();


                    $cascadeupload =  BulkOmfs::create([
                        'bulk_id' => $bulk_id,
                        'service_name' => $p_Service_Name,
                        'dos' => $p_Data_of_Service,
                        'service_type' => $p_Service_Type,
                        'provider_type' => $p_Provider_Type,
                        'conversion_factor' => $p_Conversion_Factor,
                        'locality_type' => $locality_type,
                        'locality_state' => $p_Locality_state,
                        'locality_number' => $p_Locality_number,
                        'locality_name' => $p_Locality_Namenonnum,
                        'localityzip' => $p_Locality_zip,
                        'cptcode' => $value['cptcode'],
                        'units' => $value['units'],
                        'payment_total' =>  $value['payment_total'],
                        'modifiers' =>  $modifiersString,
                    ]);
                } catch (QueryException $e) {
                    return ['error' => $e->getMessage()];
                }
            }

            if ($cascadeupload) {
                try {
                    $results = DB::select("CALL proc_bulk_upload_calc(?,?,?)", [
                        $bulk_id,
                        1,
                        0
                    ]);
                    $additionalData = [
                        'r_service_name' => $p_Service_Name,
                        'r_dos' => $p_Data_of_Service,
                        'r_place_of_service_type' => $p_Service_Type,
                        'r_provider_type' => $p_Provider_Type,
                        'r_localityname' => $p_Locality_Name,
                        'zip' => $p_Locality_zip,
                        "locality_type" => $locality_type,
                        "r_localitystate" =>  $p_Locality_state,
                        "convofactor" =>  $p_Conversion_Factor
                    ];
                    $resultsCollection = collect($results);

                    $newdata = $resultsCollection->map(function ($item) use ($additionalData) {
                        return (object) array_merge((array) $item, $additionalData);
                    })->toArray();
                    $data = json_decode(json_encode($newdata), true);



                    DB::commit();
                } catch (QueryException $e) {
                    // Handle database query exceptions (including stored procedure errors)
                    // Log the error, return a response, or perform other error handling
                    DB::rollBack();

                    $errorMessage =   $e->getMessage();
                    $errorPrefix = '<<Unknown error>>: 1644 ';
                    $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                    $posSqlStart = strpos($errorMessage, '(SQL:');
                    $errorMessage = substr($errorMessage, 0, $posSqlStart);
                    return ['error' => $errorMessage];
                }
            }
        } else {
            foreach ($request->singleReport as $key => $value) {
                if (count($value) == 3) {
                    $value['modifiers'] = '';
                }


                if (is_array($value['modifiers'])) {
                    // $value['modifiers'] is an array, implode its elements with comma
                    $modifiersString = implode(',', $value['modifiers']);
                } else {
                    // $value['modifiers'] is not an array, keep it as is
                    $modifiersString = $value['modifiers'];
                }
                try {


                    $data[$count] = DB::select('CALL proc_omfs_calculations_new(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', [
                        $login_user_email,
                        $p_Service_Name,
                        $p_Data_of_Service,
                        $p_Service_Type,
                        $p_Provider_Type,
                        $p_Conversion_Factor,
                        $p_Locality_Namenonnum,
                        $p_Locality_state,
                        $value['cptcode'],
                        $modifiersString,
                        $value['units'],
                        $value['payment_total'],
                        $p_Locality_number,
                        $p_Locality_zip

                    ])[0];
                } catch (QueryException $e) {
                    // Handle database query exceptions (including stored procedure errors)
                    // Log the error, return a response, or perform other error handling
                    $errorMessage =   $e->getMessage();
                    $errorPrefix = '<<Unknown error>>: 1644 ';
                    $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                    $posSqlStart = strpos($errorMessage, '(SQL:');
                    $errorMessage = substr($errorMessage, 0, $posSqlStart);
                    return ['error' => $errorMessage];
                }

                $data[$count]->r_service_name = $p_Service_Name;
                $data[$count]->r_dos = $p_Data_of_Service;
                $data[$count]->r_place_of_service_type = $p_Service_Type;
                $data[$count]->r_provider_type = $p_Provider_Type;
                $data[$count]->r_localityname = $p_Locality_Name;
                $data[$count]->zip = $p_Locality_zip;
                $data[$count]->locality_type = $locality_type;
                $data[$count]->r_hcpcs =  $value['cptcode'];
                $data[$count]->r_modifier =  $modifiersString;
                $data[$count]->r_localitystate =  $p_Locality_state;
                $data[$count]->convofactor =  $p_Conversion_Factor;


                $data[$count] = (array)$data[$count];
                $count++;

                // }
            }
        }

        //dd($data);
        return $data;
    }

    function single_report_load(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $single_report = $this->single_report_load_query($request);


        if (isset($single_report['error'])) {

            return redirect()->back()->with("message", $single_report['error'])->withInput($request->all());
        }

        if (count($single_report) == 0) {
            return redirect()->back()->with("message", "Record is not valid as per date of service");
        } else {

            $modifiers = DB::select(DB::raw("SELECT * FROM modifiers"));

            $states = gpci::select('state')
                ->distinct()
                ->get();


            //dd($single_report[0]);
            return view('services.physician.single-report', ['single_reports' => $single_report, 'list' => $modifiers, 'states' => $states]);
            // for multiple modifiers  return view('single-report',['single_reports' => $single_report, 'selected_modifier' => $selected_modifier]);
        }
    }
    public function single_report_load_edit(Request $request)
    {

        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }

        $single_report = $this->single_report_load_query($request);

        if (isset($single_report['error'])) {
            return response()->json(["error" => $single_report['error']]);
        }

        if (count($single_report) == 0) {
            return response()->json(["error" => "Something Went Wrong!"]);
        }

        return response()->json("success");
    }


    public static function single_report_pdf(Request $request,$api = false)
    {
        // if (Auth::user()->approved === 0) {
        //     return redirect("user/pending");
        // }
        $instance = new self();
        $single_report = $instance->single_report_load_query($request);


        $pdf = FacadePdf::loadView('services.physician.single-report-pdf', ['single_reports' => $single_report]);

        return $pdf->stream('report.pdf');
    }

    function bulk_report_load(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $validator = Validator::make($request->all(), [
            'file' => 'required|mimes:xlsx'
        ]);
        if ($validator->fails()) {
            // return redirect()->back()->with('error',"The File not found");
            return redirect()->back()->with("message", "Only Xlsx File Can be Import!");
        }
        DB::beginTransaction();

        try {
            $import = null;
            $isbulkcascade = $request->is_cascading_bulk ?? 0;
            if ($isbulkcascade) {
                $import = new OmfsCascadeBulk();
            } else {
                $import = new OmfsBulk();
            }


            Excel::import($import, $request->file('file'));
            $bulk_id = $import->getbulkid();

            DB::commit();
            $bulk_report = null;
            try {

                if ($isbulkcascade) {
                    $bulk_report = DB::select("CALL prc_bulk_cascading('$bulk_id')");
                } else {
                    $bulk_report = DB::select("CALL proc_bulk_upload_calc('$bulk_id',0,'$isbulkcascade')");
                }
            } catch (QueryException $e) {

                // Deleting the module data of bulk upload
                $BulkUploadData = BulkOmfs::where('bulk_id', '=', $bulk_id);
                if (isset($BulkUploadData)) {
                    $BulkUploadData->delete();
                }

                $UploadCascading = BulkCascadeUpload::where('bulk_id', '=', $bulk_id);
                if (isset($UploadCascading)) {
                    $UploadCascading->delete();
                }

                $BulkResponseData = Bulkresponse::where('bulk_id', '=', $bulk_id);
                if (isset($BulkResponseData)) {
                    $BulkResponseData->delete();
                }
                //  end of the data deleting for the bulk

                // Handle database query exceptions (including stored procedure errors)
                // Log the error, return a response, or perform other error handling
                $errorMessage = $e->getMessage();
                $errorPrefix = '<<Unknown error>>: 1644 ';
                $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                $posSqlStart = strpos($errorMessage, '(SQL:');
                $errorMessage = substr($errorMessage, 0, $posSqlStart);
                return redirect()->back()->with("message", $errorMessage);
            }

            // Deleting the module data of bulk upload
            $BulkUploadData = BulkOmfs::where('bulk_id', '=', $bulk_id);
            if (isset($BulkUploadData)) {
                $BulkUploadData->delete();
            }

            $UploadCascading = BulkCascadeUpload::where('bulk_id', '=', $bulk_id);
            if (isset($UploadCascading)) {
                $UploadCascading->delete();
            }

            $BulkResponseData = Bulkresponse::where('bulk_id', '=', $bulk_id);
            if (isset($BulkResponseData)) {
                $BulkResponseData->delete();
            }
            //  end of the data deleting for the bulk

            if ($request->is_pdf_bulk) {
                if ($isbulkcascade) {

                    $bulk_report_collection = collect($bulk_report);
                    $uniqueCount = $bulk_report_collection->unique('patientregid')->count();

                    if ($uniqueCount > 200) {
                        return redirect()->back()->with("message", "You have exceeded the maximum PDF generation limit of 200.");
                    }
                } else if (count($bulk_report) > 200) {

                    return redirect()->back()->with("message", "You have exceeded the maximum PDF generation limit of 200.");
                }



                ProcessBulkPdf::dispatch($isbulkcascade, $bulk_report, $request->rc_email)->onQueue('pdf');
            }

            if ($isbulkcascade) {
                $fileName = 'bulk_cascade_report_' . time() . '.xlsx';
                return Excel::download(new OmfsCascadereport($bulk_report), $fileName);
            } else {
                $fileName = 'bulk_report_' . time() . '.xlsx';
                return Excel::download(new BulreportExport($bulk_report), $fileName);
            }
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            DB::rollBack();

            $failures = $e->failures(); // Get validation failures

            // Map failures to column names and error messages
            $errors = [];

            $customMessages = [
                'dos' => 'The DOS field must be In Date Format In Excel.',
            ];
            foreach ($failures as $failure) {
                $attribute = $failure->attribute(); // Get the attribute name
                $errors[] = $customMessages[$attribute] ?? $failure->errors()[0];
            }

            // Redirect back with errors
            return redirect()->back()->withErrors($errors);
        }
    }
    public function home_edit(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $request_value = $request->input();
        // dd($request_value);
        return view('services.physician.home-edit')->with(['request_value' => $request_value]);
    }
}
