<?php
namespace App\Http\Controllers\Core;

use Illuminate\Support\Facades\Cache;

trait ClassUtils
{
    private $_cache_lock = null;
    public function getClassSlug(?string $prefix = null): string
    {
        $str = \Illuminate\Support\Str::slug(str_replace(['/', '\\'], ' ', get_class()), '.');
        if ($prefix) {
            $str = $prefix . '.' . $str;
        }
        return $str;
    }
    public function checkIfAlreadyRunning()
    {
        $this->_cache_lock = Cache::lock($this->getClassSlug(), strtotime('+10 minutes', 0));
        return !$this->_cache_lock->get();
    }
    public function clearAsRunning()
    {
        return $this->_cache_lock->release();
    }
}
