<?php

namespace App\Exports;


use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
class OmfsCascadereport implements FromCollection,WithHeadings
{
 
    protected $data;

    public function __construct($bulk_report)
    {

        $data = [];
        foreach ($bulk_report as $result) {
            
            $ncci_edit = 'No NCCI edits for this procedure';
            $content = '';

            if (isset($result->meu) && $result->meu == 1) {
                $ncci_edit = "DOS MUE Rules Applied – Rationale: 'Nature of Service/Procedure' – Units of service allowed: " . $result->max_unit_allowed . " – Effective: " . $result->eff_dos;
                $content .= 'Medically Unlikely Edit (MUE) Rules Applied.';
            }

            if (isset($result->prohibited_code) && $result->prohibited_code == 1) {
                $content .= (empty($content) ? '' : ' ') . 'Prohibited Code.';
            }

            if (isset($result->mppr) && $result->mppr == 1) {
                $content .= (empty($content) ? '' : ' ') . 'Multiple Procedure Payment Reduction (MPPR) Rules Applied.';
            }

            $Basemaximumexpection = $content ?: 'None';
            $date = Carbon::parse($result->dos);


            $data[] = [
                'PatientRegId'=> $result->patientregid ?? null,
                'Date of Service' => $date->format('m/d/Y'),
                'Provider Type' => $result->provider_type,
                'Procedure Code' => $result->procedure_code,
                'Units' => $result->units,
                'Modifiers' => $result->modifier,
                'Payment Total' => '$'.number_format($result->payment_tot,2),
                'County' => $result->locality_name,
                'locality Number' => $result->locality_num,
                'Fee Schedule' => is_numeric($result->fee_schedule) ? '$' . number_format($result->fee_schedule, 2) : $result->fee_schedule,
                'Base Maximum Fee' => '$'.number_format($result->base_max_fee,2),
                'Balance Due' => '$'.number_format($result->balance,2),
                'Fee Schedule Description' => $result->fs_desc,
                'Efective Date of Service' => $result->eff_dos,
                'Description' => $result->desc,
                'Calculation Explaination' => $result->cal_exp,      
                'Procedure' => $result->proc,
                'Work RVU' => $result->work_rvu,
                'Facility RVU' => $result->facility_rvu,
                'Non Facility RVU' => $result->non_fac_rvu,
                'MP RVU' => $result->mp_rvu,
                'Work Gpci' => $result->work_gpci,
                'Facility PE' => $result->fac_pe_gpci,
                'Non Facility PE' => $result->non_fac_pe_gpci,
                'MP Gpci' => $result->mp_gpci,
                'Conversion Factor' => $result->cf,
                'Conversion Factor Value' => '$'.number_format($result->cf_val,2),
                'Base Maximum Fee Exceptions' => $Basemaximumexpection,
                'NCCI Edits' => $ncci_edit,
                'Status Code' => $result->status_code,
                'Global Days' => $result->glob_days,
                'Pre Op' => $result->pre_op,
                'Intra Op' => $result->intra_op,
                'Post Op' => $result->post_op,
                'Multiple Procedure' => $result->multi_proc,
                'Bilateral Surgery' => $result->bilat_surg,
                'Assistant at Surgery' => $result->asst_surg,
                'Co-surgery' => $result->co_surg,
                'Team Surgery' => $result->team_surg,
                'Endoscopy Base' => $result->endo_base,
                'Physician Supervision of Diagnostic Procedures' => $result->diagnostic_proc,
                'Diagnostic Imaging Family Indicator' => $result->diagnostic_family_ind,

            ];
        }

        $this->data = $data;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $datacollection = collect($this->data);
        return  $datacollection ;
    }

    public function headings(): array
    {
        return [
            'PatientRegId',
            'Date of Service',
            'Provider Type',
            'Procedure Code',
            'Units',
            'Modifiers',
            'Payment Total',
            'County',
            'locality Number',
            'Fee Schedule',
            'Base Maximum Fee',
            'Balance Due',
            'Fee Schedule Description',
            'Efective Date of Service',
            'Description',
            'Calculation Explaination',
            'Procedure',
            'Work RVU',
            'Facility RVU',
            'Non Facility RVU',
            'MP RVU',
            'Work Gpci',
            'Facility PE',
            'Non Facility PE',
            'MP Gpci',
            'Conversion Factor',
            'Conversion Factor Value',
            'Base Maximum Fee Exceptions',
            'NCCI Edits',
            'Status Code',
            'Global Days',
            'Pre Op',
            'Intra Op',
            'Post Op',
            'Multiple Procedure',
            'Bilateral Surgery',
            'Assistant at Surgery',
            'Co-surgery',
            'Team Surgery',
            'Endoscopy Base',
            'Physician Supervision of Diagnostic Procedures',
            'Diagnostic Imaging Family Indicator'
        ];
    }

}
