{{-- {{dd($single_reports[5]['selected_modifier'])}} --}}
{{-- {{dd($single_reports[0]['r_service_name'])}} --}}
{{-- {{dd($single_reports[0]['selected_modifier'])}} --}}

{{-- Modifiers Function --}}

<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/font-awesome.min.css') }}" />
    {{-- <link rel='stylesheet' href='{{asset("user/assets/css/bootstrap-select.min.css")}}' /> --}}
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap-datepicker3.min.css') }}" />
    <link rel='stylesheet' href="{{ asset('user/assets/css/bootstrap-table.min.css') }}">
    {{-- <link rel='stylesheet' href='assets/css/bootstrap-editable.css'> --}}
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />


    <style>
        .disabled {
            color: black;
            /* Text color for disabled look */
            background-color: #f5f5f5;
            /* Background color for disabled look */
            pointer-events: none;
            /* Disable pointer events to prevent interaction */
            font-weight: bold;
        }

        .was-validated .invalid-unit,
        .invalid-unit {
            border: 2px solid red !important;
            /* Change the border color to red for invalid units */
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(.375em + .1875rem) center !important;
            background-size: calc(.75em + .375rem) calc(.75em + .375rem) !important;

        }
    </style>
</head>


<body class="bg_gray- bg-new-theme ff_omfs">
    <div class="header-home">
        <div class="row mx-0">
            {{-- <div class="col-lg-4 pl-5 --ml-2 d-flex justify-content-around align-items-center py-3">
                <img src="{{ asset('user/assets/img/logo.svg') }}" alt="OMFS Calculator Logo"
                class="img-fluid" height="38" />
                <span class="separator">|</span>
                <h1 class="redhat-regular fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
            </div> --}}
            <div class="col-lg-6 pl-lg-5 --ml-2 py-3">
                <div class="d-flex justify-content-around align-items-center logo-div">
                    <img src="{{ asset('user/assets/img/logo.svg') }}" alt="OMFS Calculator Logo" class="img-fluid" height="38" />
                    <span class="separator mx-2 mx-md-0">|</span>
                    <h1 class="redhat-regular fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
                </div>
            </div>
            {{-- <div class="col-lg-3 d-flex justify-content-center align-items-center text-white">
                @if ($single_reports[0]['Effective Dates of Service'])
                    <span class="pr-2">Effective DOS: </span>
                    {{ $single_reports[0]['Effective Dates of Service'] }}
                @endif
            </div> --}}
            <div class="col-lg-6 d-flex justify-content-center justify-content-md-start justify-content-lg-end align-items-center text-white mb-3 mb-lg-0 pl-md-4 pl-lg-3">
                <div class="user-profile-icon">
                    <i class="fa fa-user" aria-hidden="true"></i>
                </div>
                <div class="fs_16 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> {{ \Auth::user()->email }}</div>
                <a href="{{ url('user/logout') }}" class="fw_5 btn btn-custom-2 text-white fs_16 ml-3">Logout</a>
            </div>
        </div>
    </div>
    <div class="row mx-0 calc_container">
        <div class="col-lg-3 px-0 bg-white mh-100 min-lg-vh-100">
            <div class="tab_head mt-3- mt-lg-5 pt-lg-3">
                <nav>
                    <?php $reportResult = strip_tags($single_reports[0]['r_service_name']); ?>

                    <div class="nav flex-lg-column nav-tabs nav-fill new-theme-tab" id="nav-tab" role="tablist">

                        <a class="nav-item nav-link text-left" href="{{ url('/') }}" style="width: 100%; max-width: 100%; border-bottom: solid 1px; margin-bottom: 10px;">
                            <span class="nav-tab-icon home"></span>Calculator
                        </a>

                        <a class="nav-item nav-link text-left {{ (trim($reportResult) == 'Physician Services') ? 'active' : '' }}"
                            id="physician-services-tab" data-toggle="tab" href="#physician-services" role="tab" aria-controls="physician-services" aria-selected="true">
                            <span class="nav-tab-icon"></span>Physician Services</a>

                        <a class="nav-item nav-link text-left {{( trim($reportResult)  == 'E-Service') ? 'active' : '' }}"
                            id="e-service-tab" data-toggle="tab" href="#e-service" role="tab" aria-controls="e-service" aria-selected="false">
                            <span class="nav-tab-icon"></span> E-Service</a>

                        <a class="nav-item nav-link text-left {{( trim($reportResult)  == 'RFA Serving') ? 'active' : '' }}"
                            id="rfa-serving-tab" data-toggle="tab" href="#rfa-serving" role="tab" aria-controls="rfa-serving" aria-selected="false">
                            <span class="nav-tab-icon"></span>RFA Serving</a>

                        <a class="nav-item nav-link text-left {{( trim($reportResult)  == 'PR2 Service') ? 'active' : '' }}"
                            id="pr2-service-tab" data-toggle="tab" href="#pr2-service" role="tab" aria-controls="pr2-service" aria-selected="false">
                            <span class="nav-tab-icon"></span>PR2 Service</a>

                        <a class="nav-item nav-link text-left {{( trim($reportResult)  == 'Claim Admin Directory') ? 'active' : '' }}"
                            id="claim-admin-dir-tab" data-toggle="tab" href="#claim-admin-dir" role="tab" aria-controls="claim-admin-dir" aria-selected="false">
                            <span class="nav-tab-icon"></span>Claim Admin Directory</a>

                    </div>
                </nav>
            </div>

        </div>
        <div class="col-lg-9 px-4 px-sm-5 calc_container">
            <div class="row my-3 rounded">
                <div class="col-lg-6 px-2">
                    <div class="d-flex">
                        <button type="button"
                            class="btn btn-custom-1 text-white mr-1 border-0 mb-1 rounded-100 w-auto"
                            data-toggle="modal" data-target="#physicianModal">
                            <i class="fa fa-pencil-square-o" aria-hidden="true"></i> Edit
                        </button>
                        {{-- Form for PDF SECTION --}}
                        <form action="{{ url('user/single-report-pdf') }}" id="pdfform" method="post"
                            target="_blank">
                            @csrf
                            <input type="hidden" value="{{ $single_reports[0]['r_service_name'] }}"
                                name="service_name">
                            <input type="hidden" value="{{ $single_reports[0]['r_dos'] }}" name="dos" />
                            <input type="hidden" value="{{ $single_reports[0]['r_place_of_service_type'] }}"
                                name="servicetype">
                            <input type="hidden" value="{{ $single_reports[0]['r_provider_type'] }}"
                                name="providertype" />
                            <input type="hidden" value="{{ $single_reports[0]['convofactor'] ?? null }}"
                                name="conversionfactor">
                            <input type="hidden" value="{{ $single_reports[0]['locality_type'] ?? null }}"
                                name="locality_type">

                            <input type="hidden" value="{{ $single_reports[0]['zip'] ?? null }}"
                                name="localityzip">
                            <input type="hidden" value="{{ $single_reports[0]['r_localitystate'] ?? null }}"
                                name="locality_state">

                            <input type="hidden" value="{{ $single_reports[0]['r_localityname'] ?? null }}"
                                name="locality_name" />
                            <input type="hidden" value="{{ $single_reports[0]['locality_num'] ?? null }}"
                                name="locality_number" />
                            @if (count($single_reports) > 0)
                                @foreach ($single_reports as $single_report_key => $single_report)
                                    <input type="hidden"
                                        value="{{ trim(explode(':', $single_report['Procedure Code'])[0]) ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][cptcode]">
                                    <input type="hidden" value="{{ $single_report['Modifier'] ?? null  }}"
                                        name="singleReport[{{ $single_report_key }}][modifiers]" />
                                    <input type="hidden" value="{{ $single_report['Units'] ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][units]">
                                    <input type="hidden" value="{{ $single_report['Payment Total'] ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][payment_total]" />
                                @endforeach
                            @endif
                            <button type="submit" id="pdfbtn"
                                class="btn btn-custom-2 fs_16 ml-1 border-0 mb-1 text-white rounded-100">
                                <i class="fa fa-file-pdf-o" aria-hidden="true"></i><span id="pdfspan">
                                    Print PDF</span>
                            </button>
                            <!-- <button class="btn btn-primary fs_13 py-1 px-4 mr-1 border-0 mb-1  rounded-100"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Download PDF</button> -->
                        </form>
                    </div>
                </div>
                <div class="col-lg-6 pl-lg-5 text-lg-right py-3">
                    @if ($single_reports[0]['Effective Dates of Service'])
                        <span class="pr-2 d-block d-sm-inline">Effective DOS: </span>
                        {{ $single_reports[0]['Effective Dates of Service'] }}
                    @endif
                </div>
            </div>

            <div class="bg-white-- ">
                <div class="row px-2 py-2 rounded">
                    <div class="col-12 bg-white">
                        <div class="row mt-3 mb-3 " id="section1">

                            <div class="col-6 col-sm-6 col-md-3 mb-2">
                                <div class="fs_13">
                                    <div><strong>DOS:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        {{ date('m/d/Y', strtotime($single_reports[0]['r_dos'])) }}</div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-6 col-md-3 mb-2 ">
                                <div class="fs_13">
                                    <div><strong>Place of Service Type:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        {{ $single_reports[0]['r_place_of_service_type'] }}</div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-6 col-md-3 mb-2 ">
                                <div class="fs_13">
                                    <div><strong>Provider Type:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">{{ $single_reports[0]['r_provider_type'] }}
                                    </div>
                                </div>
                            </div>

                            @if ($single_reports[0]['zip'])
                                <div class="col-6 col-sm-4 col-md-3 mb-2 ">
                                    <div class="fs_13">
                                        <div><strong>Place of Service Zip:</strong></div>
                                        <div
                                            class="field_border disabled px-4 pill-shap d-flex align-items-center justify-content-between mt-3">
                                            {{ $single_reports[0]['zip'] }}</div>
                                    </div>
                                </div>
                            @else
                                <div class="col-6 col-sm-4 col-md-3 mb-2 ">
                                    <div class="fs_13">
                                        <div><strong>Place of Service County:</strong></div>
                                        <div
                                            class="field_border disabled px-4 pill-shap d-flex align-items-center justify-content-between mt-3">
                                            {{ $single_reports[0]['r_localityname'] }}</div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="row mt-3 mb-3- rounded" id="section2">
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table
                                        class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                        <thead class="pill-shap table_header text-white">
                                            <tr>
                                                <th>Serial</th>
                                                <th class="px-2">Procedure Code</th>
                                                <th>Units</th>
                                                <th>Fee Schedule</th>
                                                <th>Payment Total</th>
                                                <th>Balance Due</th>
                                                <th>% Expected</th>
                                            </tr>
                                        </thead>
                                        <tbody class="pill-shap table_body with-total">

                                            @if (count($single_reports) > 0)
                                                @php
                                                    $i = 0;
                                                    $sn = 0;
                                                    $total_omfs = 0;
                                                    $total_payment_total = 0;
                                                    $total_balance_due = 0;
                                                    $total_percentexpected = 0;
                                                @endphp
                                                @foreach ($single_reports as $single_report_key => $single_report)
                                                    <tr>
                                                        <td class="text-link"><a href="#collapse{{ $loop->iteration }}"
                                                                data-toggle="collapse" aria-expanded="true"
                                                                aria-controls="collapse{{ $loop->iteration }}">#{{ ++$sn }}</a>
                                                        </td>
                                                        <td class="text-uppercase  px-2">
                                                            {{ $single_report['Procedure Code'] }}

                                                        </td>
                                                        <td>{{ $single_report['Units'] }} </td>
                                                        <td>
                                                            @if (is_numeric($single_report['Fee Schedule']))
                                                                ${{ number_format($single_report['Fee Schedule'], 2) }}
                                                            @else
                                                                {{ $single_report['Fee Schedule'] }}
                                                            @endif
                                                        </td>
                                                        <td>${{ $single_report['Payment Total'] }}</td>
                                                        <td>${{ floatval(round($single_report['Balance Due'], 2)) }}</td>

                                                        @if ($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule']))
                                                            <?php
                                                            $percentage = 100 - (($single_report['Fee Schedule'] - $single_report['Payment Total']) / $single_report['Fee Schedule']) * 100;
                                                            $formatted_percentage = floatval(round(str_replace('%', '', round($percentage, 2))));
                                                            ?>
                                                            <td>{{ $formatted_percentage }}%</td>
                                                        @else
                                                            <td>N/A</td>
                                                            <!-- Or handle the case where Fee Schedule is zero -->
                                                        @endif
                                                    </tr>
                                                    @php
                                                        $total_payment_total += $single_report['Payment Total'];
                                                        $roundOffBalanceDue = floatval(
                                                            round($single_report['Balance Due'], 2),
                                                        );
                                                        $total_balance_due += $roundOffBalanceDue;
                                                        if (
                                                            $single_report['Fee Schedule'] != 0 &&
                                                            is_numeric($single_report['Fee Schedule'])
                                                        ) {
                                                            $total_omfs += $single_report['Fee Schedule'];

                                                            $roundOffPercentExpected = round(
                                                                100 -
                                                                    (($single_report['Fee Schedule'] -
                                                                        $single_report['Payment Total']) /
                                                                        $single_report['Fee Schedule']) *
                                                                        100,
                                                            );
                                                        } else {
                                                            $roundOffPercentExpected = 0;
                                                        }
                                                        $total_percentexpected += $roundOffPercentExpected;
                                                    @endphp
                                                @endforeach
                                            @endif
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td><b>Total</b></td>
                                                <td><b>${{ number_format($total_omfs, 2) }}</b></td>
                                                <td><b>${{ number_format($total_payment_total, 2) }}</b></td>
                                                <td><b>${{ number_format($total_balance_due, 2) }}</b></td>
                                                <td><b>{{ $total_percentexpected }}%</b></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- <h3 class="redhat-medium fw_5 fs_20 text-dark mb-3 mt-4">Procedure Code - Fee Schedule Calculations</h3> --}}
            <div class="accordion" id="accordionExample">

                @foreach ($single_reports as $key => $value)
                    <div class="card bg-transparent border-0">
                        <div class="card-header- " >
                            <h4 class="mb-0 card-heading mt-3 mb-2">Procedure Code - Fee Schedule Calculations
                                <span id="heading{{ $loop->iteration }}" class="btn"
                                    data-toggle="collapse" data-target="#collapse{{ $loop->iteration }}"
                                    aria-expanded="true" aria-controls="collapse{{ $loop->iteration }}">
                                    #{{ $loop->iteration }} - {{ ucfirst($value['Procedure Code']) }}
                                </span>

                            </h4>
                        </div>

                        <div id="collapse{{ $loop->iteration }}"
                            class="collapse bg-white p-4 @if ($loop->iteration === 1) show @endif"
                            aria-labelledby="heading{{ $loop->iteration }}" data-parent="#accordionExample">
                            <div class="pdf-page-break">
                                <div class="row">
                                    <!-- col 1 -->
                                    <div class="col-md-6 half-width">
                                        <div class="table-responsive">
                                            <table style="text-wrap: balance !important;" class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2" colspan="2">Calculation Details</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before with-border">
                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Fee Schedule</b>
                                                        </td>
                                                        <td width="50%" class=" pt-3">
                                                            {{-- {{ $value['Fee Schedule Desc'] ?? null }} --}}
                                                            {!! $value['Fee Schedule Desc'] ?? null !!}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Description</b>
                                                        </td>
                                                        <td width="50%">
                                                            <p class="mb-0">
                                                                {{ $value['Description'] ?? null }}</p>
                                                        </td>
                                                    </tr>
                                                    @if (isset($value['Procedure']))
                                                        <tr>
                                                            <td width="50%" class="text-dark">
                                                                <b>Procedure</b>
                                                            </td>
                                                            <td width="50%">
                                                                <p class="mb-0">
                                                                    {{ $value['Procedure'] ?? null }}</p>
                                                            </td>
                                                        </tr>
                                                    @endif

                                                    @if (isset($value['Effective Dates of Service']))
                                                        <tr>
                                                            <td class="text-dark">
                                                                <b>Effective Dates of Service</b>
                                                            </td>
                                                            <td>{{ $value['Effective Dates of Service'] }}</td>
                                                        </tr>
                                                    @endif

                                                </tbody>
                                            </table>
                                        </div>

                                        <div class="table-responsive mt-3">
                                            <table
                                                class="table align-middle table-sm text-center fs_13 text-nowrap">
                                                @if (isset($value['Work RVU']))
                                                    <thead class="pill-shap table_header text-white">
                                                        <tr>
                                                            <th>Type</th>
                                                            <th>RVU</th>
                                                            <th>GPCI</th>
                                                            <th>Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="pill-shap table_body no_gap_before with-border redhat-regular font-apply-direct">
                                                        @php
                                                            $total1 = $value['Work RVU'] * $value['Work GPCI'];

                                                            $total2 = 0;

                                                            if (isset($single_reports[0]['r_place_of_service_type']) && $single_reports[0]['r_place_of_service_type'] == 'Facility')

                                                            {
                                                                $total2 =
                                                                    $value['Facility RVU'] *
                                                                    $value['Facility PE GPCI'];
                                                            } else {
                                                                $total2 =
                                                                    $value['Non Facility RVU'] *
                                                                    $value['Non Facility PE GPCI'];
                                                            }

                                                            $total3 = $value['MP RVU'] * $value['MP GPCI'];
                                                            $sumtotalcalc = $total1 + $total2 + $total3;
                                                        @endphp
                                                        <tr>
                                                            <td>Work</td>
                                                            <td class="border-top-0">{{ $value['Work RVU'] }}</td>
                                                            <td class="border-top-0">{{ $value['Work GPCI'] }}</td>
                                                            <td>{{ $total1 }}</td>
                                                        </tr>
                                                        <tr>
                                                            @if (isset($single_reports[0]['r_place_of_service_type']) && $single_reports[0]['r_place_of_service_type'] == 'Facility')

                                                                <td>Facility PE</td>
                                                                <td>{{ $value['Facility RVU'] }}</td>
                                                                <td>{{ $value['Facility PE GPCI'] ?? null }}</td>
                                                                <td>{{ $total2 }}</td>
                                                            @else
                                                                <td>Non-Facility PE</td>
                                                                <td>{{ $value['Non Facility RVU'] }}</td>
                                                                <td>{{ $value['Non Facility PE GPCI'] ?? null  }}</td>
                                                                <td>{{ $total2 }}</td>
                                                            @endif
                                                        </tr>
                                                        <tr>
                                                            <td>MP</td>
                                                            <td>{{ $value['MP RVU'] }}</td>
                                                            <td>{{ $value['MP GPCI'] }}</td>
                                                            <td>{{ $total3 }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="3">
                                                                <div class="right">Sum of Totals</div>
                                                            </td>
                                                            <td>{{ $sumtotalcalc }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="3">
                                                                <div class="right">Conversion Factor -
                                                                    {{ $value['convofactor'] }}</div>
                                                            </td>
                                                            <td>${{ $value['Conversion Factor Value'] }}</td>
                                                        </tr>
                                                        @if (isset($value['locality_num']))
                                                            <tr>
                                                                <td class="fs_16" colspan="4">
                                                                    <span style="text-wrap: balance;">Locality:{{ $value['locality_num'] }} - {{ $value['locality_name'] }}</span>
                                                                </td>
                                                            </tr>
                                                        @endif
                                                        <tr>
                                                            @php
                                                                if (
                                                                    preg_match(
                                                                        '/\((.*?)\)/',
                                                                        $value['locality_name'],
                                                                        $matches,
                                                                    )
                                                                ) {
                                                                    $countyName = $matches[1];
                                                                }
                                                            @endphp
                                                            <td colspan="4">Counties:
                                                                {{ $countyName ?? $value['locality_name'] }}
                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                @endif
                                                <tfoot>
                                                    @if (isset($value['Calculation Explanation']))
                                                        <tr>
                                                            <td class="border border-left-0" colspan="3">
                                                                <div class="fw_6">Calculation Explanation</div>
                                                            </td>
                                                            <td class="fw_6 border border-right-0">
                                                                {{ $value['Calculation Explanation'] ?? null }}
                                                            </td>
                                                        </tr>
                                                    @endif
                                                    <tr>
                                                        <td class="border border-left-0" colspan="3">
                                                            <div class="fw_6">Base Maximum Fee</div>
                                                        </td>
                                                        <td class="fw_6 border border-right-0">${{ $value['Base Maximum Fee'] ?? 0 }}</td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- col 2 -->
                                    <div class="col-md-6 half-width">
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2">Base Maximum Fee Exceptions</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before">
                                                    <tr>
                                                        <td class="pt-2 pb-0">
                                                            @php
                                                                $showNone = true; // Flag to determine if "None" should be displayed
                                                            @endphp


                                                            @if (isset($value['MEU']) && $value['MEU'] == 1)
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Medically Unlikely
                                                                    Edit (MUE) Rules Applied.</p>
                                                                @php $showNone = false; @endphp
                                                            @endif

                                                            @if (isset($value['Prohibited Code']) && $value['Prohibited Code'] == 1)
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Prohibited Code.
                                                                </p>
                                                                @php $showNone = false; @endphp
                                                            @endif

                                                            @if (isset($value['MPPR']) && $value['MPPR'] == 1)
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Multiple Procedure
                                                                    Payment Reduction (MPPR) Rules Applied.</p>
                                                                @php $showNone = false; @endphp
                                                            @endif
                                                            @if ($showNone)
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">None</p>
                                                            @endif


                                                        </td>

                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2">NCCI Edits</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before">
                                                    <tr>
                                                        @if (isset($value['MEU']) && $value['MEU'] == 1)
                                                            <td class="pt-2 pb-0"> DOS MUE Rules Applied – Rationale: 'Nature of
                                                                Service/Procedure' – Units of service allowed:
                                                                {{ $value['max_unit_allowed'] }} – Effective:
                                                                {{ $value['date_of_service'] }}</td>
                                                        @else
                                                            <td class="pt-2 pb-0">No NCCI edits for this procedure.</td>
                                                        @endif
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        @if (isset($value['Status Code']))
                                            <div class="table-responsive mt-2">
                                                <table
                                                    class="table align-middle table-sm table-bordered- -text-center fs_13 text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th class="pill-shap table_header-2" colspan="2">CMS RVU Information</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="pill-shap table_body no_gap_before with-border-bottom redhat-regular rvu-information">
                                                        <tr>
                                                            <td class="fw_6">Status Code</td>
                                                            <td>
                                                                @if (isset($value['Status Code']))
                                                                    {{ $value['Status Code'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">PC/TC Indicator</td>
                                                            <td>
                                                                @if (isset($value['pctc_indicator']))
                                                                    {{ $value['pctc_indicator'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Global Days</td>
                                                            <td>
                                                                @if (isset($value['glob_days']))
                                                                    {{ $value['glob_days'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Pre Op</td>
                                                            <td>
                                                                @if (isset($value['pre_op']))
                                                                    {{ number_format($value['pre_op'], 1, '.', ',') }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Intra Op</td>
                                                            <td>
                                                                @if (isset($value['intra_op']))
                                                                    {{ number_format($value['intra_op'], 1, '.', ',') }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Post Op</td>
                                                            <td>
                                                                @if (isset($value['post_op']))
                                                                    {{ number_format($value['post_op'], 1, '.', ',') }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Multiple Procedure</td>
                                                            <td>
                                                                @if (isset($value['mult_proc']))
                                                                    {{ $value['mult_proc'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Bilateral Surgery</td>
                                                            <td>
                                                                @if (isset($value['bilat_surg']))
                                                                    {{ $value['bilat_surg'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Assistant at Surgery</td>
                                                            <td>
                                                                @if (isset($value['asst_surg']))
                                                                    {{ $value['asst_surg'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Co-surgery</td>
                                                            <td>
                                                                @if (isset($value['co_surg']))
                                                                    {{ $value['co_surg'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Team Surgery</td>
                                                            <td>
                                                                @if (isset($value['team_surg']))
                                                                    {{ $value['team_surg'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Endoscopy Base</td>
                                                            <td>
                                                                @if (isset($value['endo_base']))
                                                                    {{ $value['endo_base'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Physician Supervision of
                                                                Diagnostic
                                                                Procedures</td>
                                                            <td>
                                                                @if (isset($value['diagnostic_proc']))
                                                                    {{ $value['diagnostic_proc'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Diagnostic Imaging Family
                                                                Indicator
                                                            </td>
                                                            <td>
                                                                @if (isset($value['diagnostic_family_ind']))
                                                                    {{ $value['diagnostic_family_ind'] }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>


        </div>
    </div>

    <!-- Modal -->
    <div class="modal" id="physicianModal" style=" background: rgb(25 130 154 / 55%);" role="dialog" aria-labelledby="physicianModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <form id="calc_form" action="{{ url('user/single-report') }}" method="post">
                    @csrf
                    <div class="modal-header pt-0">
                        <h5 class="modal-title" id="physicianModalLabel">Edit
                            {!! $single_reports[0]['r_service_name'] !!}
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row mt-2">
                            <div class="col-sm-12">
                                <div>
                                    <input type="hidden" class="" id="service_name" name="service_name"
                                        placeholder="Select Service"
                                        value="{{ $single_reports[0]['r_service_name'] }}" />
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <div class="form_label col-6 col-lg-6 col-xl-3 mb-5">
                                            <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy) </span><span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="datepicker date input-group datepicker-new-theme">
                                                <div class="input-group-append ml-0"> <span class="input-group-text pl-3"><i class="fa fa-calendar"></i></span> </div>
                                                <input type="text" placeholder="MM/DD/YYYY"
                                                    class="dos_input form-control" id="dos" name="dos"
                                                    pattern="\d{2}/\d{2}/\d{4}" min="01-01-2000"
                                                    value="{{ date('m/d/Y', strtotime($single_reports[0]['r_dos'])) }}"
                                                    required="" />
                                                {{-- <div class="input-group-append"> <span class="input-group-text"><i class="fa fa-calendar"></i></span> </div> --}}
                                                <div class="invalid-feedback datpicker-feedback">Select date of service</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-6 col-lg-6 col-xl-3 mb-5">
                                            <label>Place of Service Type</label>
                                            <div class="mt-3">
                                                <div
                                                    class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="facility"
                                                        name="servicetype" value="Facility" required
                                                        {{ $single_reports[0]['r_place_of_service_type'] == 'Facility' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="facility">Facility</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-facility" name="servicetype" value="Non-Facility"
                                                        required
                                                        {{ $single_reports[0]['r_place_of_service_type'] == 'Non-Facility' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="non-facility">Non-Facility</label>
                                                </div>
                                                <div class="invalid-feedback">Select service type</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-6 col-lg-7 col-xl-5 mb-5">
                                            <label>Provider Type</label>
                                            <div class="mt-3">
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="physician"
                                                        name="providertype" value="Physician" required
                                                        {{ $single_reports[0]['r_provider_type'] == 'Physician' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="physician">Physician</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-physician" name="providertype" value="Non-Physician"
                                                        required
                                                        {{ $single_reports[0]['r_provider_type'] == 'Non-Physician' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="non-physician">Non-Physician</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="clinical-soial-worker" name="providertype"
                                                        value="Clinical Soial Worker" required
                                                        {{ $single_reports[0]['r_provider_type'] == 'Clinical Soial Worker' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="clinical-soial-worker">Clinical Soial Worker</label>
                                                </div>
                                                <div class="invalid-feedback">Select provider type</div>
                                            </div>
                                        </div>


                                        <div id="convFactorDiv" class="form_label col-6 col-lg-5 col-xl-3 mb-3">
                                            <label>Select Conversion Factor <span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="mb-3 select2-simple_select_div">
                                                <select id="conversionfactor" class="simple_select mb-3 mt-2 select2-simple_select"
                                                    name="conversionfactor" aria-label="Conversion Factor"
                                                    aria-describedby="conversionfactoralidate" required>
                                                    <option value="Radiology"
                                                        {{ $single_reports[0]['convofactor'] == 'Radiology' ? 'selected' : '' }}>
                                                        Radiology</option>
                                                    <option value="Anesthesia"
                                                        {{ $single_reports[0]['convofactor'] == 'Anesthesia' ? 'selected' : '' }}>
                                                        Anesthesia</option>
                                                    <option value="Surgery"
                                                        {{ $single_reports[0]['convofactor'] == 'Surgery' ? 'selected' : '' }}>
                                                        Surgery</option>
                                                    <option value="Other Services"
                                                        {{ $single_reports[0]['convofactor'] == 'Other Services' ? 'selected' : '' }}>
                                                        Other Services</option>
                                                </select>
                                                <div id="conversionfactoralidate" class="invalid-feedback">Select
                                                    conversion factor</div>
                                            </div>
                                        </div>


                                        <div id="localityDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-4 col-xl-3 mb-3 localityDiv">
                                            <label>Find Place of Service Locality By</label>
                                            <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                <div class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input" type="radio"
                                                        name="locality_type" id="county" value="County"
                                                        {{ $single_reports[0]['locality_type'] == 'County' ? 'checked' : '' }}>
                                                    <label class="form-check-label fw_4 custom-control-label" for="county">County</label>
                                                </div>
                                                <div class="form-check custom-control custom-radio mr-5 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input" type="radio"
                                                        {{ $single_reports[0]['locality_type'] == 'Zip-Code' ? 'checked' : '' }}
                                                        name="locality_type" id="zipcode" value="Zip-Code">
                                                    <label class="form-check-label fw_4 custom-control-label"
                                                        for="zipcode">Zip-Code</label>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="form_label col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                                            <label class="" for="state">State</label>
                                            <div class="select2-simple_select_div select2-state">
                                            <select id="locality_state" name="locality_state" aria-label="State"
                                                class=" mb-3 form-control js-example-basic-single  locality_state select2-simple_select-with-search"
                                                required>
                                                @forelse($states as $state)
                                                    <option value="{{ $state->state }}">{{ $state->state }}
                                                    </option>
                                                @empty
                                                @endforelse

                                            </select>
                                            </div>
                                            <div id="servicestateValidate" class="invalid-feedback">
                                                Select State </div>
                                        </div>
                                        <div id="countyListDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-5 col-xl-4 mb-3 countyListDiv">
                                            <label for="calculation_locality_number">Place of Service
                                                County</label>
                                            <div class="mb-3">
                                                <div class="mb-3 select2-simple_select_div select2-place-of-service">
                                                    <select id="calculation_locality_number" name="locality_number"
                                                        aria-label="Place of Service County"
                                                        class=" mb-3 form-control js-example-basic-single  county select2-simple_select-with-search"
                                                        required>

                                                    </select>
                                                    <input type="hidden" class="localityname" name="locality_name"
                                                        id="localityname">


                                                    <div id="servicecountyValidate" class="invalid-feedback">
                                                        Select Place of service </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="zipListDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-5 col-xl-4 mb-3 zipListDiv">
                                            <label for="servicezipValidate">Place of Service
                                                Zip Code</label>
                                            <div class="mb-3">
                                                <div class="input-parent input-parent-county">
                                                    <input type="text" class="form-control text-uppercase localityzip form-input" name="localityzip" placeholder="Service Zip Code" required />
                                                </div>
                                                <div id="servicezipValidate" class="invalid-feedback">
                                                    Please Enter Zip Code </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12 modal-header">
                                <div class=" modal-title mb-4 mt-0">Bills</div>
                            </div>
                        </div>

                        <div class="row mobile-hidden">
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Modifiers <span class="text-red fs_12"></span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Units <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Payment Total <span class="text-red fs_12"></span></label>
                                </div>
                            </div>
                        </div>

                        <div class="field_wrapper">

                            @if (count($single_reports) > 0)
                                @foreach ($single_reports as $single_report_key => $single_report)
                                    <div class="row select-container">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span class="text-red fs_12">*</span></label>
                                                    <div class="input-parent input-parent-cpt">
                                                        <input type="text" class="form-control inc cptcode text-uppercase form-input"
                                                            name="singleReport[{{ $single_report_key }}][cptcode]"
                                                            placeholder="CPT code"
                                                            value="{{ $single_report['Procedure Code'] }}" maxLength="5"
                                                            required />
                                                    </div>
                                                <div class="invalid-feedback code-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3 select2-simple_select_div select2-modifiers">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}

                                                    <select
                                                        name="singleReport[{{ $single_report_key }}][modifiers][]"
                                                        multiple
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive select2-simple_select-with-search">

                                                        @if (count($list) > 0)
                                                            <?php
                                                            $mod = $single_report['Modifier'] ?? null;
                                                            // Convert $mod into an array of selected values
                                                            if (strpos($mod, ',') !== false) {
                                                                // If $mod contains a comma, explode into an array
                                                                $selectedValues = explode(',', $mod);
                                                            } else {
                                                                // If $mod is a single value, convert it to an array
                                                                $selectedValues = [$mod];
                                                            }
                                                            ?>
                                                            @foreach ($list as $value)
                                                                <?php
                                                                // Check if the current option value is in the $selectedValues array
                                                                $isSelected = in_array($value->value, $selectedValues);
                                                                ?>
                                                                <option value='{{ $value->value }}'
                                                                    {{ $isSelected ? 'selected' : '' }}>
                                                                    {{ $value->label }}
                                                                </option>
                                                            @endforeach
                                                        @endif

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span class="text-red fs_12">*</span></label>
                                                <div class="input-parent input-parent-unit">
                                                    <input type="text" class="form-control units form-input" name="singleReport[{{ $single_report_key }}][units]"
                                                    placeholder="Enter Unit number" min="1" value="{{ $single_report['Units'] }}" maxLength="3" required />
                                                </div>
                                                <div class="invalid-feedback unit-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <div class="input-parent input-parent-charges">
                                                    <input type="text" class="form-control charges form-input"
                                                        name="singleReport[{{ $single_report_key }}][payment_total]"
                                                        placeholder="0.00"
                                                        value="{{ $single_report['Payment Total'] }}"
                                                        maxLength="10" />
                                                    </div>
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                            @endif

                        </div>
{{-- <div class='row select-container'>
    <div class='col-6 col-sm-3 col-md-3'>
        <div class='form_label mb-3 input-parent input-parent-cpt'>
            <label class='d-block d-sm-none'>Procedure Code <span class='text-red fs_12'>*</span></label> <input type='text' class='form-control inc cptcode text-uppercase append_field form-input' name='singleReport["+index+"][cptcode]' placeholder='CPT code' value='' pattern='[a-zA-Z0-9]{1,5}'' maxLength='5'/> <div class='invalid-feedback'>Select procedure code</div>
        </div>
    </div>
    <div class='col-6 col-sm-3 col-md-3'>
        <div class='form_label mb-3 input-parent input-parent-cpt'> <label class='d-block d-sm-none'>Modifiers <span class='text-red fs_12'></span></label> <div class='mb-3 mod_selector select2-simple_select_div select2-modifiers'></div> </div>
    </div>
    <div class='col-6 col-sm-3 col-md-3'>
        <div class='form_label mb-3 input-parent input-parent-unit'> <label class='d-block d-sm-none'>Units <span class='text-red fs_12'>*</span></label> <input type='text' class='form-control units form-input' name='singleReport["+index+"][units]' placeholder='1' value='1' maxLength='3' required/> <div class='invalid-feedback'>Select unit</div> </div>
    </div>
    <div class='col-6 col-sm-3 col-md-3 input-parent input-parent-charges'>
        <div class='form_label mb-3'> <label class='d-block d-sm-none'>Charges <span class='text-red fs_12'></span></label> <div class='last_field'> <input type='text' class='form-control charges form-input' name='singleReport["+index+"][payment_total]' placeholder='0.00'  value='0' maxLength='5' /> <div class='removeField'><a href='javascript:void(0);' class='remove_button'><i class='fa fa-remove' aria-hidden='true'></i></a></div> </div> </div>
    </div>
</div> --}}
                        {{-- <div class="hidden-options" style="display: none;">
                            @if (count($list) > 0)
                                @foreach ($list as $value)
                                    <option value='{{ $value->value }}'
                                        {{ $value->value == $single_report['r_modifier'] ? 'selected' : '' }}>
                                        {{ $value->label }}</option>
                                @endforeach
                            @endif
                        </div> --}}


                        <div class="row mb-3">
                            <div class="col-12 col-lg-5">
                                <div class="text-right d-flex">

                                    <button type="submit"
                                        class="btn border-0 btn-custom-1 w-auto fs_15 text-white rounded-100"
                                        id="submitButton">Calculate</button>
                                </div>
                            </div>
                        </div>




                    </div>

                </form>
            </div>
        </div>
    </div>
    {{-- modal data --}}
<script>
    window.baseUrl = "{{ url('/') }}";
</script>

    {{-- <script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script> --}}
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>
    {{-- <script src='{{ asset('user/assets/js/bootstrap-select.min.js') }}'></script> --}}
    <script src="{{ asset('user/assets/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table.js') }}"></script>
    {{-- <script src="{{ asset('user/assets/js/bootstrap-table-editable.js') }}"></script> --}}
    <script src="{{ asset('user/assets/js/bootstrap-table-export.js') }}"></script>
    <script src="{{ asset('user/assets/js/tableExport.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-filter-control.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="{{ asset('user/assets/js/custom.js') }}"></script>
    <script src="{{ asset('user/assets/js/dynamic_cpt_row_edit.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>


    @if (\Session::has('message'))
        <script>
            // Display SweetAlert error message using the message from the session
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "{!! \Session::get('message') !!}"
            });
        </script>
    @endif

    <script>
        $(document).on('select2:open', () => {
            document.querySelector('.select2-search__field').focus();
        });

        $(document).ready(function() {

            $('.select2-simple_select').select2({
                minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });

            $('.select2-simple_select-with-search').select2({
                // minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });
            $('.select2-state .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "state",
            });
            $('.select2-place-of-service .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Service Zip Code",
            });
            $('.select2-modifiers .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Modifiers",
                allowClear: true,
            });

            // Assuming you have a variable called localityNumber pre-set in your view
            var preSelectedstate = '{{ $single_report['r_localitystate'] }}';
            var prezipcode = '{{ $single_report['zip'] }}';

            $('#locality_state').val(preSelectedstate).trigger('change');
            $('.localitytype').trigger('change');

            $('.localitytype').trigger('change');
            if (prezipcode) {
                $('.localityzip').val(prezipcode);

            }

        });





        $('#calc_form').submit(function(event) {
            event.preventDefault(); // Prevent default form submission
            isValid = true;
            $('.units').each(function() {
                let unitInput = $(this);
                let unitValue = parseInt(unitInput.val());
                if (unitValue < 1) {
                    isValid = false;
                    unitInput.val('')
                } else {
                    unitInput.removeClass('invalid-unit');
                }
            });

            if (isValid) {
                $("#submitButton").prop('disabled', true);
                $("#submitButton").html('Calculating...');
                var formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('edit-report') }}", // Form action URL
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Calculation Error',
                                text: response.error
                            });
                            $("#submitButton").prop('disabled', false);
                            $("#submitButton").html('Calculate');
                        } else {
                            $('#calc_form')[0].submit();
                        }



                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: "Something Went Wrong!"
                        });
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid Unit!',
                    text: 'Please enter a unit value that is at least 1.'
                });
            }
        });


        $('#pdfform').submit(function(event) {
            event.preventDefault(); // Prevent default form submission


            $("#pdfbtn").prop('disabled', true);
            $("#pdfspan").html(' Processing...');
            var formData = $(this).serialize();
            $.ajax({
                url: "{{ route('edit-report') }}", // Form action URL
                method: 'POST',
                data: formData,
                success: function(response) {
                    if (response.error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'PDF Error',
                            text: response.error
                        });
                        $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                    } else {
                         $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                        $('#pdfform')[0].submit();
                    }



                },
                error: function(xhr, status, error) {
                    $("#pdfbtn").prop('disabled', false);
                    $("#pdfspan").html(' Print PDF');
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: "Something Went Wrong!"
                    });
                }
            });


        });





        $(".dos_input").on("change", function() {
            var sb_dos_selected = $(this).val();
            if (moment(sb_dos_selected).isAfter(moment('02/28/2017', 'MM/DD/YYYY'))) {
                $(".convFactorDiv select option[value='Other Services']").attr('selected', 'selected');
            }
            var state = $(".locality_state").val();
            fetchServicePlaces(state, sb_dos_selected)
        });

        $('.county').on('change', function() {
            // Get the selected state value
            var selectedOption = $(this).find('option:selected');
            var selectedText = selectedOption.text();
            $(".localityname").val(selectedText);

        });

        $('.localitytype').change(function() {
            var checkedValue = $(this).val(); // Get the value of the changed checkbox

            if ($(this).is(':checked')) {
                console.log(checkedValue); // Output the checked value

                if (checkedValue === "County") {
                    $(".zipListDiv").hide();
                    $('.localityzip').prop('required', false);
                    $("#calculation_locality_number").prop('required', true);
                    $(".countyListDiv").show();

                } else {
                    $(".zipListDiv").show();
                    $('.localityzip').prop('required', true);
                    $("#calculation_locality_number").prop('required', false);
                    $(".countyListDiv").hide();
                }
            }
        });


        $('.locality_state').on('change', function() {
            // Get the selected state value
            var state = $(this).val();
            var dateofservice = $(".dos_input").val();
            // Call the fetchServicePlaces function with the selected state value
            fetchServicePlaces(state, dateofservice);
        });

        function fetchServicePlaces(state, doservice) {
            $.ajax({
                url: '{{ route('placeOfServiceList') }}',
                type: 'GET',
                data: {
                    state: state,
                    dos: doservice
                },
                success: function(response) {
                    // Clear previous options
                    $('.county').empty();

                    // Iterate over each response item and append an option
                    $.each(response, function(index, item) {
                        $('.county').append('<option value="' + item
                            .locality_number + '">' + item.locality_name + "-" + item
                            .locality_number +
                            ' </option>');
                        $('.county').trigger("change");
                    });

                    var preSelectedlocality = '{{ $single_report['locality_num'] ?? null }}';
                    if (preSelectedlocality) {
                        // Set the selected option in Select2
                        $('.county').val(preSelectedlocality).trigger('change');
                    }
                    $('.localitytype').trigger('change');

                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    </script>



</body>

</html>
