<?php
return [
	"DROP PROCEDURE if exists `omfs_bulk_process`;",
" CREATE PROCEDURE `omfs_bulk_process`(IN `filepath` VARCHAR(255))
BEGIN
  DECLARE v_MODIFIER VARCHAR(255) DEFAULT NULL;
  DECLARE v_HCPCS VARCHAR(255) DEFAULT NULL;
  DECLARE v_email VARCHAR(255) DEFAULT NULL;
  DECLARE v_service_name VARCHAR(255) DEFAULT NULL;
  DECLARE v_date_of_service DATE DEFAULT NULL;
  DECLARE v_place_of_service_type VARCHAR(255) DEFAULT NULL;
  DECLARE v_provider_type VARCHAR(255) DEFAULT NULL;
  DECLARE v_conversion_factor_name VARCHAR(255) DEFAULT NULL;
  DECLARE v_conv_factor DECIMAL(10,2) DEFAULT NULL;
  DECLARE v_localityname VARCHAR(255) DEFAULT NULL;
  DECLARE v_units INT DEFAULT NULL;
  DECLARE v_payment_total DECIMAL(10,2) DEFAULT NULL;
  DECLARE v_omfs DECIMAL(10,2) DEFAULT NULL;
  DECLARE vc INT DEFAULT NULL;
  DECLARE vstr VARCHAR(255) DEFAULT NULL;
  DECLARE v_rec VARCHAR(255) DEFAULT NULL;
	-- DECLARE newfilepath VARCHAR(255) DEFAULT 'C:\Users\Wasiq.Ali\Downloads\csv file omfs\csv file omfs\bulk_dum_data.csv';
	DECLARE sql_stmt VARCHAR(1000);

  -- Create a temporary table to store the data from the CSV file
  DROP TEMPORARY TABLE IF EXISTS temp_omfs_source;
  CREATE TEMPORARY TABLE temp_omfs_source (
    id INT NOT NULL AUTO_INCREMENT,
    email VARCHAR(255) DEFAULT NULL,
    service_name VARCHAR(255) DEFAULT NULL,
    date_of_service DATE DEFAULT NULL,
    place_of_service_type VARCHAR(255) DEFAULT NULL,
    provider_type VARCHAR(255) DEFAULT NULL,
    conversion_factor_name VARCHAR(255) DEFAULT NULL,
    localityname VARCHAR(255) DEFAULT NULL,
    hcpcs VARCHAR(255) DEFAULT NULL,
    modifier VARCHAR(255) DEFAULT NULL,
    units INT DEFAULT NULL,
    payment_total DECIMAL(10,2) DEFAULT NULL,
    omfs DECIMAL(10,2) DEFAULT NULL,
    PRIMARY KEY (id)
  );


-- Load the data from the CSV file into the temporary table
  SET @vstr = CONCAT('LOAD DATA INFILE ', QUOTE(COALESCE(filepath, '')), ' INTO TABLE temp_omfs_source
                    FIELDS TERMINATED BY '',''
                    ENCLOSED BY ''''
                    LINES TERMINATED BY ''\n''
                    IGNORE 1 ROWS');
  PREPARE stmt FROM @vstr;
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

-- Calculate the omfs value for each record and update the temp_omfs_source table
SELECT COUNT(*) INTO vc FROM temp_omfs_source;

WHILE vc > 0 DO
SELECT * INTO v_rec FROM temp_omfs_source LIMIT 1;
SET v_MODIFIER = v_rec.modifier;
SET v_HCPCS = v_rec.hcpcs;
SET v_email = v_rec.email;
SET v_service_name = v_rec.service_name;
SET v_date_of_service = v_rec.date_of_service;
SET v_place_of_service_type = v_rec.place_of_service_type;
SET v_provider_type = v_rec.provider_type;
SET v_conversion_factor_name = v_rec.conversion_factor_name;
SET v_conv_factor = v_rec.conv_factor;
SET v_localityname = v_rec.localityname;
SET v_units = v_rec.units;
SET v_payment_total = v_rec.payment_total;
SET v_omfs = v_units * v_payment_total;
UPDATE temp_omfs_source
SET omfs = v_omfs
WHERE email = v_email AND service_name = v_service_name AND date_of_service = v_date_of_service AND place_of_service_type = v_place_of_service_type AND provider_type = v_provider_type AND conversion_factor_name = v_conversion_factor_name AND conv_factor = v_conv_factor AND localityname = v_localityname AND hcpcs = v_HCPCS AND modifier = v_MODIFIER AND units = v_units AND payment_total = v_payment_total;
SELECT COUNT(*) INTO vc FROM temp_omfs_source;
END WHILE;

-- Select the data from the temp_omfs_source table and return it as a result set
SELECT email AS r_email, service_name AS r_service_name, date_of_service AS r_date_of_service, place_of_service_type AS r_place_of_service_type, provider_type AS r_provider_type, conversion_factor_name AS r_conversion_factor_name, localityname AS r_localityname, hcpcs AS r_hcpcs, modifier AS r_modifier, units AS r_units, payment_total AS r_payment_total, omfs AS r_omfs FROM temp_omfs_source;
--   conv_factor AS r_conv_factor,
END
"

];
