<!DOCTYPE html>
<html lang="en">

<head>
    <?php echo $__env->make('layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <title>User Information | Medical Lien Management</title>
    <link href="<?php echo e(asset('user/assets/style.css')); ?>" rel="stylesheet" />

</head>

<body>
    <main class="d-flex flex-column w-100 h-100">
         
        <div class="container-fluid h-100 pb-5 bg-new-theme position-relative overflow-hidden" style="background-color: #effcff; ">
            <div class="header mt-5 mb-5 pb-5 ps-5">
                <img src="<?php echo e(asset('user/assets/img/logo.svg')); ?>" alt="OMFS Calculator Logo"
                class="img-fluid" height="45" />
            </div>
            
            <div class="row">
                <div class="col-lg-4 text-center overflow-hidden d-none d-lg-flex justify-content-end position-relative">
                    <img src="<?php echo e(asset('user/assets/img/login_banner_left.svg')); ?>" alt="Banner"
                    class="img-fluid" style="position: absolute; bottom: 2vh; left: 51px; max-width: 45vw; min-width: 550px;" />
                </div>
                <div class="col-lg-4 px-0 app_box_container_login">
                    <div class="card app_box_container mb-0">
                        <div class="card-body">
                            <div class="m-sm-4">
                                <div class="row">
                                    <div class="col-xl-7 text-start">
                                        <h1 class="redhat-bold fs_30 text_dark_black">Welcome to OMFS Calculator</h1>
                                    </div>
                                    <div class="col-12 mb-1">
                                        <p class="redhat-regular fs_18 text_dark_black mb-4">Please login or sign up to continue</p>
                                    </div>
                                </div>

                                <form action="<?php echo e(url('user/login-form')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="mb-4 input-parent input-parent-email">
                                        
                                        <input class="form-control form-control-lg form-input" type="email" name="email"
                                            placeholder="your email" />
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="mb-3 input-parent input-parent-password">
                                        
                                        <input class="form-control form-control-lg form-input" type="password" name="password"
                                            placeholder="your password" />
                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-start my-5">
                                        <label class="form-check">
                                            <input class="form-check-input" type="checkbox" value="remember-me"
                                                name="remember-me" checked>
                                            <span class="form-check-label">
                                                Remember me next time
                                            </span>
                                        </label>
                                    </div>
                                    <div class="text-center mt-2">
                                        <button type="submit" class="btn btn-custom-1 fs_18 border-0 text-white rounded-100">Login</button>
                                    </div>
                                </form>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-none col-lg-4 text-end d-lg-flex justify-content-end align-items-end">
                    <img src="<?php echo e(asset('user/assets/img/login_banner_right.svg')); ?>" alt="Banner"
                    class="img-fluid" style="max-width: 420px; width:100%;" />
                </div>
            </div>
        </div>
        
        
    </main>

    <script src="js/app.js"></script>

</body>

</html>
<?php /**PATH D:\Appedology\omfs-calculator\resources\views/auth/signin.blade.php ENDPATH**/ ?>