<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\PharmacyController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/', [AuthController::class, 'login_load']);

Route::prefix('user')->group(function () {
    Route::get('login', [AuthController::class, 'login_load'])->name('login');
    Route::post('login-form', [AuthController::class, 'login_post']);
    Route::get('register', [AuthController::class, 'register_load']);
    Route::post('register-form', [AuthController::class, 'register_form']);

});

// Authication
Route::group(
    ['prefix' => 'user', 'middleware' => ['web', 'auth', 'check.session.expiry']],
    function () {
        Route::get("pending", [AuthController::class, "pending_load"]);
        Route::get('place-of-service-list', [HomeController::class, "placeofservicelist"])->name('placeOfServiceList');
        Route::get("modifier-list", [HomeController::class, "modifierList"]);

        // Physician Services
        Route::get("home", [HomeController::class, "home_load"])->name('physician.service');
        Route::post("single-report", [HomeController::class, "single_report_load"]);
        Route::post("single-report-edit", [HomeController::class, "single_report_load_edit"])->name('edit-report');
        Route::post("single-report-pdf", [HomeController::class, "single_report_pdf"]);
        Route::post("bulk-report", [HomeController::class, "bulk_report_load"]);
        Route::get("logout", [AuthController::class, "logout"]);

        // Pharmacy Services
        Route::group(['prefix' => '/pharmacy', 'as' => 'pharmacy.'], function () {

            Route::get('/', [PharmacyController::class, 'index'])->name('service');
            Route::post('single-report', [PharmacyController::class, 'single_report_load'])->name('single-report');
            Route::post('single-report-edit', [PharmacyController::class, 'single_report_load_edit'])->name('edit-report');
            Route::post('single-report-pdf', [PharmacyController::class, 'single_report_pdf'])->name('report-pdf');
            Route::post('bulk-report', [PharmacyController::class, 'bulk_report_load'])->name('bulkupload');
        });




    }
);
