<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
<title>OMFS Calculator | Medical Lien Management</title>
<link rel="stylesheet" href="{{asset("user/assets/css/bootstrap.min.css")}}"/>
<link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />  
<link rel="stylesheet" href="{{asset("user/assets/css/font-awesome.min.css")}}" />
<link rel='stylesheet' href="{{asset("user/assets/css/bootstrap-table.min.css")}}">
{{-- <link rel='stylesheet' href='assets/css/bootstrap-editable.css'> --}}
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg_gray ff_omfs">

<div class="overflow-x-0">


<div class="w-lg-85 px-3">
<div class="row mt-3 mb-3 d-lg-flex">

<div class="col-sm-12 col-md-3 text-center text-md-left fs_13 order-2 order-md-1 mb-3 mb-md-0">
<div class="fs_16 text_green">Medical Lien Management</div>
<div class="fs_12 mb-2"><b>Effective DOS: </b>
{{-- {{date('m/d/Y', strtotime($single_report->r_dos))}} - {{date('m/d/Y', strtotime($single_report->r_doe))}} --}}
</div>
<button type="button" class="fs_12 p-0 mr-1 mb-1 text_blue border-0 bg-transparent link_btn" data-toggle="modal" data-target="#previewCSVDataModal">View Uploaded File</button>
</div>

<div class="col-sm-12 col-md-6 text-center order-3 order-md-2">
{{-- <h1 class="text-center fs_40 text_dark_black ff_omfs fw_5">OMFS Bulk Report</h1> --}}
<div class="mb-2"><span><a class="fs_15 text_black fw_5 px-0" href="{{ url('/') }}">Calculator</a></span> <i class="fa fa-angle-double-right text_black" aria-hidden="true"></i> <span class="bg_green fs_18 service_title text-white fw_6">
{{-- {{$single_reports[0]->r_service_name}} --}}
OMFS Bulk Report
</span></div>
{{-- <div class="bg_green fs_18 service_title text-white fw_6 mb-3 py-2">
Physician Services
</div> --}}
{{-- <div class="title_underline bg_gradient ml-auto mr-auto mb-4 mb-lg-5"></div> --}}
 @if(Session::has('bulk_status'))
<div class="alert alert-success text-center fs_13" role="alert">
{{Session::get('bulk_status')}}
</div>
 @endif 
</div>

<div class="d-md-block d-flex align-items-center col-sm-12 col-md-3 text-center text-md-right order-1 order-md-3 justify-content-center mb-3 mb-md-0">
<div class="fs_12 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> 
{{\Auth::user()->email}}
</div>
<div class="fs_12"><a href="{{url('user/logout')}}" class="fw_5 btn bg_red text-white fs_12 py-1 px-3 mt-2">Logout</a> </div>
</div>

</div>
</div>


<div class="row">
<div class="col-sm-12">

<div class="calc_container bg-white">


<div class="row mb-3">
<div class="col-sm-12 col-md-8">
<div class="app_table">


<div id="toolbar">
		<select class="form-control">
				<option value="">Export Basic</option>
				<option value="all">Export All</option>
				<option value="selected">Export Selected</option>
		</select>
</div>

<table id="table" data-toggle="table" data-search="true"
			 data-filter-control="true" 
			 data-show-export="true"
       data-show-refresh="true"
       data-show-toggle="false"
       data-pagination="true"
       data-pagination-loop="false"
data-page-list="[10, 25, 50, 100, all]"
			 data-toolbar="#toolbar"
       class="table-responsive table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
	<thead class="bg_blue_light text-dark">
	
<tr>
@foreach($bulk_report[0] as $header)
<th data-sortable="true">{{ $header }}</th>
@endforeach
</tr>   
	</thead>

<tbody>
@foreach($bulk_report as $index => $row)
  @if($index != 0)
      <tr>
          @foreach($row as $column)
              <td>{{ $column }}</td>
          @endforeach
      </tr>
  @endif
@endforeach
</tbody>
</table>
  
</div>
<div class="table-responsive mt-2">
    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap bulk_summary">
        <thead class="bg_green text-white">
            <tr>
            <th></th>
                <th>No. of Rows</th>
                <th>Units</th>
                <th>Payment Amount</th>
                <th>Expected</th>
                <th>Balance Due</th>
                <th>% Expected</th>
            </tr>
            </thead>
            <tbody>
<tr>
<td><b>Total:</b></td>
<td>10</td>
<td>10</td>
<td>250</td>
<td>370.00</td>
<td>120</td>
<td>67%</td>  
{{-- formula for Percent Expected Value --
round((100-((v_OMFS - p_Payment_Total) / v_OMFS) * 100)) --}}
</tr>
            </tbody>
    </table>
</div>

</div>
<div class="col-sm-12 col-md-4">
<div class="row mt-3">
<div class="col-12">
<div  class="bg_blue fs_25 text-white fw_6 mb-3 text-center px-2 py-2 rounded d-flex align-items-center justify-content-between">
<div class="cpt_data"><span class="cptcode"><script>$cptcode</script></span></div>
<div classd="mod_data"><span class="modifier"><script>$modifier</script></span></div>
</div>
</div>
</div>

<div class="row">
<div class="col-12">
<table width="100%" border="1px" align="left"  class="table_col_border">
<tbody align="left" style="font-size: 12px;">
<tr>
<td class="head_col bg_gray">Date of Service:</td>
<td class="dateOfService"><script>$date_of_service</script></td>
</tr>
<tr>
<td class="head_col bg_gray">Place of Service Type:</td>
<td class="facilityType"><script>$facilityType</script></td>
</tr>
<tr>
<td class="head_col bg_gray">Provider Type:</td>
<td class="providerType"><script>$providerType</script></td>
</tr>
{{-- <tr>
<td class="head_col bg_gray">Serial No.</td><td>undefined</td>
</tr> --}}
<tr>
<td class="head_col bg_gray">Procedure Code</td>
<td class="cptcode"><script>$cptcode</script></td>
</tr>
<tr>
<td class="head_col bg_gray">Units</td>
<td class="units"><script>$units</script></td>
</tr>
<tr>
<td class="head_col bg_gray"><b>Expected</b></td>
<td class="omfs"><script>$omfs</script></td>
</tr>
<tr>
<td class="head_col bg_gray">Payment Amount</td>
<td class="paymentAmount"><script>$paymentAmount</script></td>
</tr>
<tr>
<td class="head_col bg_gray">Balance Due</td>
<td class="balanceDue"><script>$balanceDue</script></td>
</tr>
<tr>
<td class="head_col bg_gray">%Expected</td>
<td class="expected"><script>$expected</script></td>
</tr>
</tbody>
</table>
</div>
<div class="col-12 mt-2">
<div class="fs_13 btn_top_margin float-right d-sm-flex align-items-center justify-content-between">
<a href="{{ url('user/home') }}" class="btn btn-outline-secondary fs_13 py-1 px-4 mr-1 mb-1 rounded-100"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> Back</a>
<button class="btn btn-primary fs_13 py-1 px-4 mr-1 border-0 mb-1 rounded-100"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Download PDF</button>
{{-- <button class="btn btn-secondary fs_15 py-1 px-3 mr-1 border-0 mb-1"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Download XLX</button> --}}
</div>
</div>
</div>

</div>
</div>


<div class="row mt-3 mb-3">
<div class="col-sm-12">

</div>

</div>


{{-- <div class="row-details">
<div class="email"><script>email</script></div>
<div class="serviceName"><script>serviceName</script></div>
<div class="cptcode"><script>cptcode</script></div>
<div class="omfs"><script>omfs</script></div>
</div> --}}



<div class="row mt-3 mb-1">
<div class="col-sm-12 col-md-12 d-flex align-items-center justify-content-between ">
<h2 class="text-left fs_25 text_dark_black ff_omfs fw_4">Detail Explanation</h2>
<h3 class="text-left fs_20 text-white ff_omfs fw_4 bg_blue rounded px-3 py-2 fw_6">73721 <span>26</span></h2>
</div>

</div>

<div class="row mb-3">
<div class="col-sm-12 col-md-6">
<div class="report_details">
<h4 class="text-left fs_20 ff_omfs fw_4 bg_green_light text-dark py-2 px-3 rounded">Calculation Details</h4>
<div>
<table class="table align-middle table-sm fs_13">
<tbody>
<tr>
<td>
<b>Fee Schedule</b>
</td>
<td class="serviceName"><script>$serviceName</script></td>
</tr>
<tr>
<td>
<b>Description</b>
</td>
<td class="description"><script>$description</script></td>
</tr>
<tr>
<td>
<b>Status Code Explanation</b>
</td>
<td class="status"><script>$status</script></td>
</tr>
<tr>
<td>
<b>Effective Dates of Service</b>
</td>
<td class="effectiveDOS"><script>$effectiveDOS</script></td>
</tr>
</tbody>
</table>
</div>

<div  class="table-responsive">
<table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
<thead class="bg_green_light text_dark_black">
<tr>
<th class="text-left">Type</th>
<th>RVU</th>
<th>GPCI</th>
<th>Total</th>
</tr>
</thead>
<tbody>
<tr>
<td class="text-left">Work</td>
<td class="r_work_rvu"><script>$r_work_rvu</script></td>
{{-- <td class="r_statewide_work_gaf"><script>$r_statewide_work_gaf</script></td> --}}
<td class="r_wgpci"><script>$r_wgpci</script></td>
<td class="r_total_work"><script>$r_total_work</script></td>
</tr>
<tr>
<td class="text-left">Non-Facility PE</td>
<td>4.61</td>
<td>1.325</td>
<td>6.10825</td>
</tr>
<tr>
<td class="text-left">MP</td>
<td>0.02</td>
<td>0.421</td>
<td>0.00842</td>
</tr>
<tr>
<td colspan="3">
<div class="text-right">Sum of Totals</div>
</td>
<td>6.11667</td>
</tr>
<tr>
<td colspan="3">
<div class="text-right">Conversion Factor - Other Services</div>
</td>
<td>$45.8513</td>
</tr>
<tr>
<td colspan="4" class="text-left">
<div>Counties: San Francisco</div>
<div>Locality: 5 - SAN FRANCISCO-OAKLAND-HAYWARD (SAN FRANCISCO CNTY), CA</div>
</td>
</tr>
</tbody>
<tfoot class="bg_gray">
<tr>
<td colspan="3">
<div class="text-right"><b>Base Maximum Fee</b></div>
</td>
<td><b>$280.45</b></td>
</tr>
</tfoot>
</table>
</div>


</div>
</div>
<div class="col-sm-12 col-md-6">
<div class="report_details">
<h5 class="text-left fs_16 ff_omfs fw_4 bg_green_light text_dark_black py-2 px-3 rounded">Billing Ground Rules</h5>
<div class="mb-2"><p></p></div>

<h5 class="text-left fs_16 ff_omfs fw_4 bg_green_light text_dark_black py-2 px-3 rounded">NCCI Edits</h5>
<div class="mb-2"><p></p></div>

<h5 class="text-left fs_16 ff_omfs fw_4 bg_green_light text_dark_black py-2 px-3 rounded">HCPCS Information</h5>
<div>
<table class="table align-middle table-sm fs_12 table-bordered">
<tbody>
<tr>
<td class="span4">Status Code</td>
<td>A</td>
</tr>
<tr>
<td>PC/TC Indicator</td>
<td>1</td>
</tr>
<tr>
<td>Global Days</td>
<td>XXX</td>
</tr>
<tr>
<td>Pre Op</td>
<td>0.0</td>
</tr>
<tr>
<td>Intra Op</td>
<td>0.0</td>
</tr>
<tr>
<td>Post Op</td>
<td>0.0</td>
</tr>
<tr>
<td>Multiple Procedure</td>
<td>4</td>
</tr>
<tr>
<td>Bilateral Surgery</td>
<td>3</td>
</tr>
<tr>
<td>Assistant at Surgery</td>
<td>0</td>
</tr>
<tr>
<td>Co-surgery</td>
<td>0</td>
</tr>
<tr>
<td>Team Surgery</td>
<td>0</td>
</tr>
<tr>
<td>Endoscopy Base</td>
<td></td>
</tr>
<tr>
<td>Physician Supervision of Diagnostic Procedures</td>
<td>09</td>
</tr>
<tr>
<td>Diagnostic Imaging Family Indicator</td>
<td>09</td>
</tr>
</tbody>
</table>
</div>
</div>
</div>
</div>

</div>
</div>

</div> 
</div>  


<!-- Upload CSV File Preview Modal -->
<div class="modal" id="previewCSVDataModal" tabindex="-1" role="dialog" aria-labelledby="previewCSVDataModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content">
<div class="modal-header">
          <h5 class="modal-title" id="previewCSVDataModalLabel">Uploaded File Preview</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
</div>
        <div class="modal-body">
<div class="row mt-2">
<div class="col-sm-12 text-left mb-3">
<div class="app_table bulk_preview_table mt-2">
<table id="csvTable" data-toggle="table" data-search="true"
			 data-filter-control="false"
			 data-show-export="false"
       data-show-refresh="false"
       data-show-toggle="false"
       data-pagination="true"
data-pagination-loop="false"
data-page-list="[10, 25, 50, 100, all]"
			 data-toolbar="#toolbar"
       class="table-responsive table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
    <thead class="bg_blue_light text-dark">
        <tr>
            @foreach($csvData[0] as $header)
                <th data-sortable="true">{{ $header }}</th>
            @endforeach
        </tr>
    </thead>
    <tbody>
       @foreach($csvData as $index => $row)
            @if($index != 0)
                <tr>
                    @foreach($row as $column)
                        <td>{{ $column }}</td>
                    @endforeach
                </tr>
            @endif
        @endforeach
    </tbody>
</table>
<div> 

</div>
</div>
</div>
  </div>
    </div>
      </div>
    </div>
</div>



<script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script>
<script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
<script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('user/assets/js/bootstrap-table.js') }}"></script>
{{-- <script src="{{ asset('user/assets/js/bootstrap-table-editable.js') }}"></script> --}}
<script src="{{ asset('user/assets/js/bootstrap-table-export.js') }}"></script>
<script src="{{ asset('user/assets/js/tableExport.js') }}"></script>
<script src="{{ asset('user/assets/js/bootstrap-table-filter-control.js') }}"></script>
<script src="{{ asset('user/assets/js/custom.js') }}"></script>


</body>
</html>
