<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BulkPdfMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $zipFilePath;

    public function __construct($zipFilePath)
    {
        $this->zipFilePath = $zipFilePath;
    }

    /**
     * Build the message.
     *
     * @return $this
     */

     public function build()
     {
        //  return $this->view('emails.pdfbulkreport')
        //              ->subject('Your Bulk PDF Reports are Ready')
        //              ->with([
        //                  'url' => $this->url,
        //              ]);

                     return $this->view('emails.pdfbulkreport') // Create this view for the email body
                     ->subject('Your Bulk PDF Reports are Ready')
                     ->attach($this->zipFilePath, [
                         'as' => 'omfs_report_' . time() . '.zip',
                         'mime' => 'application/zip',
                     ]);
     }
}
