<?php

namespace App\Imports;

use App\Models\ConversionFactor;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ConvertionImport implements ToModel,WithHeadingRow, WithValidation
{

    protected $errors = [];

    public function rules(): array
    {
        return [
            'conversion_factor_name' => 'required',
            'conversion_factor_value' => 'required',
            'dos' => 'required|numeric',
            'doe' => 'required|numeric',

        ];
    }

    public function model(array $row)
    {

        try {

            // Convert Excel date strings to DateTime objects
            $dos = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['dos']);
            $doe = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['doe']);
        } catch (\Exception $e) {
            // If conversion fails, add an error message
            $this->errors[] = [
                'message' => "Invalid date format for DOS or DOE",
                'row' => $row,
            ];
            return null; // Skip this row
        }

        $existingConversion = ConversionFactor::where('conversion_factor_name', $row['conversion_factor_name'])
            ->where('dos', $dos)
            ->where('doe', $doe)
            ->first();

        if ($existingConversion) {
            // Handle duplicate Conversion
            // For example, update the existing Conversion with new data
            $existingConversion->update([
                'conversion_factor_value' => $row['conversion_factor_value'],
            ]);
            return null; // Skip this row
        }

        return ConversionFactor::create([
            'conversion_factor_name' => $row['conversion_factor_name'],
            'conversion_factor_value' => $row['conversion_factor_value'],
            'dos' => $dos,
            'doe' =>  $doe,

        ]);
    }

    public function batchSize(): int
    {
        return 1000; // Adjust batch size as needed
    }

    public function chunkSize(): int
    {
        return 1000; // Adjust chunk size as needed
    }

    public function onError(\Throwable $e)
    {
        // Handle errors
        $this->errors[] = $e->getMessage();
    }

    public function failures()
    {
        return $this->errors;
    }

}
