<?php

namespace App\Http\Controllers\Api;

use DB;
use Illuminate\Http\Request;
use Laravel\Passport\Client;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Validator;
class AuthApiController extends BaseController
{
    // Issue a token using client credentials
    public function issueToken(Request $request)
    {

        $response = Http::asForm()->post(url('/oauth/token'), [
            'grant_type' => 'client_credentials',
            'client_id' => $request->client_id,
            'client_secret' => $request->client_secret,
        ]);

        if ($response->failed()) {
            return response()->json(['error' => 'Invalid client credentials'], 401);
        }

        return $response->json();
    }

    // Refresh an access token
    public function refreshToken(Request $request)
    {
        $request->validate([
            'refresh_token' => 'required',
            'client_id' => 'required',
            'client_secret' => 'required',
        ]);

        $response = Http::asForm()->post(url('/oauth/token'), [
            'grant_type' => 'refresh_token',
            'refresh_token' => $request->refresh_token,
            'client_id' => $request->client_id,
            'client_secret' => $request->client_secret,
        ]);

        if ($response->failed()) {
            return response()->json(['error' => 'Invalid refresh token'], 401);
        }

        return $response->json();
    }

    // Revoke access token
    public function revokeToken(Request $request)
    {
        $token = $request->bearerToken();

        $tokenRepository = app('Laravel\Passport\TokenRepository');
        $tokenRepository->revokeAccessToken($token);

        return response()->json(['message' => 'Token revoked successfully']);
    }
}
