





<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/font-awesome.min.css')); ?>" />
    
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/bootstrap-datepicker3.min.css')); ?>" />
    <link rel='stylesheet' href="<?php echo e(asset('user/assets/css/bootstrap-table.min.css')); ?>">
    
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('user/assets/style.css')); ?>" rel="stylesheet" />


    <style>
        .disabled {
            color: black;
            /* Text color for disabled look */
            background-color: #f5f5f5;
            /* Background color for disabled look */
            pointer-events: none;
            /* Disable pointer events to prevent interaction */
            font-weight: bold;
        }

        .was-validated .invalid-unit,
        .invalid-unit {
            border: 2px solid red !important;
            /* Change the border color to red for invalid units */
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(.375em + .1875rem) center !important;
            background-size: calc(.75em + .375rem) calc(.75em + .375rem) !important;

        }
    </style>
</head>


<body class="bg_gray- bg-new-theme ff_omfs">
    <div class="header-home">
        <div class="row mx-0">
            
            <div class="col-lg-6 pl-lg-5 --ml-2 py-3">
                <div class="d-flex justify-content-around align-items-center logo-div">
                    <img src="<?php echo e(asset('user/assets/img/logo.svg')); ?>" alt="OMFS Calculator Logo" class="img-fluid" height="38" />
                    <span class="separator mx-2 mx-md-0">|</span>
                    <h1 class="ProximaNova fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
                </div>
            </div>
            
            <div class="col-lg-6 d-flex justify-content-center justify-content-md-start justify-content-lg-end align-items-center text-white mb-3 mb-lg-0 pl-md-4 pl-lg-3">
                <div class="user-profile-icon">
                    <i class="fa fa-user" aria-hidden="true"></i>
                </div>
                <div class="fs_16 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> <?php echo e(\Auth::user()->email); ?></div>
                <a href="<?php echo e(url('user/logout')); ?>" class="fw_5 btn btn-custom-2 text-white fs_16 ml-3">Logout</a>
            </div>
        </div>
    </div>
    <div class="row mx-0 calc_container">
        <div class="col-lg-3 px-0 bg-white mh-100 min-lg-vh-100">
            <div class="tab_head mt-3- mt-lg-5 pt-lg-3">
                <nav>
                    <?php $reportResult = strip_tags($single_reports[0]['r_service_name']); ?>

                    <div class="nav flex-lg-column nav-tabs nav-fill new-theme-tab" id="nav-tab" role="tablist">

                        <a class="nav-item nav-link text-left" href="<?php echo e(url('/')); ?>" style="width: 100%; max-width: 100%; border-bottom: solid 1px; margin-bottom: 10px;">
                            <span class="nav-tab-icon home"></span>Calculator
                        </a>

                        <a class="nav-item nav-link text-left <?php echo e((trim($reportResult) == 'Physician Services') ? 'active' : ''); ?>"
                            id="physician-services-tab" data-toggle="tab" href="#physician-services" role="tab" aria-controls="physician-services" aria-selected="true">
                            <span class="nav-tab-icon"></span>Physician Services</a>

                        <a class="nav-item nav-link text-left <?php echo e(( trim($reportResult)  == 'E-Service') ? 'active' : ''); ?>"
                            id="e-service-tab" data-toggle="tab" href="#e-service" role="tab" aria-controls="e-service" aria-selected="false">
                            <span class="nav-tab-icon"></span> E-Service</a>

                        <a class="nav-item nav-link text-left <?php echo e(( trim($reportResult)  == 'RFA Serving') ? 'active' : ''); ?>"
                            id="rfa-serving-tab" data-toggle="tab" href="#rfa-serving" role="tab" aria-controls="rfa-serving" aria-selected="false">
                            <span class="nav-tab-icon"></span>RFA Serving</a>

                        <a class="nav-item nav-link text-left <?php echo e(( trim($reportResult)  == 'PR2 Service') ? 'active' : ''); ?>"
                            id="pr2-service-tab" data-toggle="tab" href="#pr2-service" role="tab" aria-controls="pr2-service" aria-selected="false">
                            <span class="nav-tab-icon"></span>PR2 Service</a>

                        <a class="nav-item nav-link text-left <?php echo e(( trim($reportResult)  == 'Claim Admin Directory') ? 'active' : ''); ?>"
                            id="claim-admin-dir-tab" data-toggle="tab" href="#claim-admin-dir" role="tab" aria-controls="claim-admin-dir" aria-selected="false">
                            <span class="nav-tab-icon"></span>Claim Admin Directory</a>

                    </div>
                </nav>
            </div>

        </div>
        <div class="col-lg-9 px-4 px-sm-5 calc_container">
            <div class="row my-3 rounded">
                <div class="col-lg-6 px-2">
                    <div class="d-flex">
                        <button type="button"
                            class="btn btn-custom-1 text-white mr-1 border-0 mb-1 rounded-100 w-auto"
                            data-toggle="modal" data-target="#physicianModal">
                            <i class="fa fa-pencil-square-o" aria-hidden="true"></i> Edit
                        </button>
                        
                        <form action="<?php echo e(url('user/single-report-pdf')); ?>" id="pdfform" method="post"
                            target="_blank">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($single_reports[0]['r_service_name']); ?>"
                                name="service_name">
                            <input type="hidden" value="<?php echo e($single_reports[0]['r_dos']); ?>" name="dos" />
                            <input type="hidden" value="<?php echo e($single_reports[0]['r_place_of_service_type']); ?>"
                                name="servicetype">
                            <input type="hidden" value="<?php echo e($single_reports[0]['r_provider_type']); ?>"
                                name="providertype" />
                            <input type="hidden" value="<?php echo e($single_reports[0]['convofactor'] ?? null); ?>"
                                name="conversionfactor">
                            <input type="hidden" value="<?php echo e($single_reports[0]['locality_type'] ?? null); ?>"
                                name="locality_type">

                            <input type="hidden" value="<?php echo e($single_reports[0]['zip'] ?? null); ?>"
                                name="localityzip">
                            <input type="hidden" value="<?php echo e($single_reports[0]['r_localitystate'] ?? null); ?>"
                                name="locality_state">

                            <input type="hidden" value="<?php echo e($single_reports[0]['r_localityname'] ?? null); ?>"
                                name="locality_name" />
                            <input type="hidden" value="<?php echo e($single_reports[0]['locality_num'] ?? null); ?>"
                                name="locality_number" />
                            <?php if(count($single_reports) > 0): ?>
                                <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $single_report_key => $single_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <input type="hidden"
                                        value="<?php echo e(trim(explode(':', $single_report['Procedure Code'])[0]) ?? null); ?>"
                                        name="singleReport[<?php echo e($single_report_key); ?>][cptcode]">
                                    <input type="hidden" value="<?php echo e($single_report['Modifier'] ?? null); ?>"
                                        name="singleReport[<?php echo e($single_report_key); ?>][modifiers]" />
                                    <input type="hidden" value="<?php echo e($single_report['Units'] ?? null); ?>"
                                        name="singleReport[<?php echo e($single_report_key); ?>][units]">
                                    <input type="hidden" value="<?php echo e($single_report['Payment Total'] ?? null); ?>"
                                        name="singleReport[<?php echo e($single_report_key); ?>][payment_total]" />
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <button type="submit" id="pdfbtn"
                                class="btn btn-custom-2 fs_16 ml-1 border-0 mb-1 text-white rounded-100">
                                <i class="fa fa-file-pdf-o" aria-hidden="true"></i><span id="pdfspan">
                                    Print PDF</span>
                            </button>
                            <!-- <button class="btn btn-primary fs_13 py-1 px-4 mr-1 border-0 mb-1  rounded-100"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Download PDF</button> -->
                        </form>
                    </div>
                </div>
                <div class="col-lg-6 pl-lg-5 text-lg-right py-3">
                    <?php if($single_reports[0]['Effective Dates of Service']): ?>
                        <span class="pr-2 d-block d-sm-inline">Effective DOS: </span>
                        <?php echo e($single_reports[0]['Effective Dates of Service']); ?>

                    <?php endif; ?>
                </div>
            </div>

            <div class="bg-white-- ">
                <div class="row px-2 py-2 rounded">
                    <div class="col-12 bg-white">
                        <div class="row mt-3 mb-3 " id="section1">

                            <div class="col-6 col-sm-6 col-md-3 mb-2">
                                <div class="fs_13">
                                    <div><strong>DOS:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        <?php echo e(date('m/d/Y', strtotime($single_reports[0]['r_dos']))); ?></div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-6 col-md-3 mb-2 ">
                                <div class="fs_13">
                                    <div><strong>Place of Service Type:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        <?php echo e($single_reports[0]['r_place_of_service_type']); ?></div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-6 col-md-3 mb-2 ">
                                <div class="fs_13">
                                    <div><strong>Provider Type:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3"><?php echo e($single_reports[0]['r_provider_type']); ?>

                                    </div>
                                </div>
                            </div>

                            <?php if($single_reports[0]['zip']): ?>
                                <div class="col-6 col-sm-4 col-md-3 mb-2 ">
                                    <div class="fs_13">
                                        <div><strong>Place of Service Zip:</strong></div>
                                        <div
                                            class="field_border disabled px-4 pill-shap d-flex align-items-center justify-content-between mt-3">
                                            <?php echo e($single_reports[0]['zip']); ?></div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="col-6 col-sm-4 col-md-3 mb-2 ">
                                    <div class="fs_13">
                                        <div><strong>Place of Service County:</strong></div>
                                        <div
                                            class="field_border disabled px-4 pill-shap d-flex align-items-center justify-content-between mt-3">
                                            <?php echo e($single_reports[0]['r_localityname']); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="row mt-3 mb-3- rounded" id="section2">
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table
                                        class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                        <thead class="pill-shap table_header text-white">
                                            <tr>
                                                <th>Serial</th>
                                                <th class="px-2">Procedure Code</th>
                                                <th>Units</th>
                                                <th>Fee Schedule</th>
                                                <th>Payment Total</th>
                                                <th>Balance Due</th>
                                                <th>% Expected</th>
                                            </tr>
                                        </thead>
                                        <tbody class="pill-shap table_body with-total">

                                            <?php if(count($single_reports) > 0): ?>
                                                <?php
                                                    $i = 0;
                                                    $sn = 0;
                                                    $total_omfs = 0;
                                                    $total_payment_total = 0;
                                                    $total_balance_due = 0;
                                                    $total_percentexpected = 0;
                                                ?>
                                                <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $single_report_key => $single_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="text-link"><a href="#collapse<?php echo e($loop->iteration); ?>"
                                                                data-toggle="collapse" aria-expanded="true"
                                                                aria-controls="collapse<?php echo e($loop->iteration); ?>">#<?php echo e(++$sn); ?></a>
                                                        </td>
                                                        <td class="text-uppercase  px-2">
                                                            <?php echo e($single_report['Procedure Code']); ?>


                                                        </td>
                                                        <td><?php echo e($single_report['Units']); ?> </td>
                                                        <td>
                                                            <?php if(is_numeric($single_report['Fee Schedule'])): ?>
                                                                $<?php echo e(number_format($single_report['Fee Schedule'], 2)); ?>

                                                            <?php else: ?>
                                                                <?php echo e($single_report['Fee Schedule']); ?>

                                                            <?php endif; ?>
                                                        </td>
                                                        <td>$<?php echo e($single_report['Payment Total']); ?></td>
                                                        <td>$<?php echo e(floatval(round($single_report['Balance Due'], 2))); ?></td>

                                                        <?php if($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule'])): ?>
                                                            <?php
                                                            $percentage = 100 - (($single_report['Fee Schedule'] - $single_report['Payment Total']) / $single_report['Fee Schedule']) * 100;
                                                            $formatted_percentage = floatval(round(str_replace('%', '', round($percentage, 2))));
                                                            ?>
                                                            <td><?php echo e($formatted_percentage); ?>%</td>
                                                        <?php else: ?>
                                                            <td>N/A</td>
                                                            <!-- Or handle the case where Fee Schedule is zero -->
                                                        <?php endif; ?>
                                                    </tr>
                                                    <?php
                                                        $total_payment_total += $single_report['Payment Total'];
                                                        $roundOffBalanceDue = floatval(
                                                            round($single_report['Balance Due'], 2),
                                                        );
                                                        $total_balance_due += $roundOffBalanceDue;
                                                        if (
                                                            $single_report['Fee Schedule'] != 0 &&
                                                            is_numeric($single_report['Fee Schedule'])
                                                        ) {
                                                            $total_omfs += $single_report['Fee Schedule'];

                                                            $roundOffPercentExpected = round(
                                                                100 -
                                                                    (($single_report['Fee Schedule'] -
                                                                        $single_report['Payment Total']) /
                                                                        $single_report['Fee Schedule']) *
                                                                        100,
                                                            );
                                                        } else {
                                                            $roundOffPercentExpected = 0;
                                                        }
                                                        $total_percentexpected += $roundOffPercentExpected;
                                                    ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td><b>Total</b></td>
                                                <td><b>$<?php echo e(number_format($total_omfs, 2)); ?></b></td>
                                                <td><b>$<?php echo e(number_format($total_payment_total, 2)); ?></b></td>
                                                <td><b>$<?php echo e(number_format($total_balance_due, 2)); ?></b></td>
                                                <td><b><?php echo e($total_percentexpected); ?>%</b></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="accordion" id="accordionExample">

                <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card bg-transparent border-0">
                        <div class="card-header- " >
                            <h4 class="mb-0 card-heading mt-3 mb-2">Procedure Code - Fee Schedule Calculations
                                <span id="heading<?php echo e($loop->iteration); ?>" class="btn"
                                    data-toggle="collapse" data-target="#collapse<?php echo e($loop->iteration); ?>"
                                    aria-expanded="true" aria-controls="collapse<?php echo e($loop->iteration); ?>">
                                    #<?php echo e($loop->iteration); ?> - <?php echo e(ucfirst($value['Procedure Code'])); ?>

                                </span>

                            </h4>
                        </div>

                        <div id="collapse<?php echo e($loop->iteration); ?>"
                            class="collapse bg-white p-4 <?php if($loop->iteration === 1): ?> show <?php endif; ?>"
                            aria-labelledby="heading<?php echo e($loop->iteration); ?>" data-parent="#accordionExample">
                            <div class="pdf-page-break">
                                <div class="row">
                                    <!-- col 1 -->
                                    <div class="col-md-6 half-width">
                                        <div class="table-responsive">
                                            <table style="text-wrap: balance !important;" class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2" colspan="2">Calculation Details</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before with-border">
                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Fee Schedule</b>
                                                        </td>
                                                        <td width="50%" class=" pt-3">
                                                            
                                                            <?php echo $value['Fee Schedule Desc'] ?? null; ?>

                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Description</b>
                                                        </td>
                                                        <td width="50%">
                                                            <p class="mb-0">
                                                                <?php echo e($value['Description'] ?? null); ?></p>
                                                        </td>
                                                    </tr>
                                                    <?php if(isset($value['Procedure'])): ?>
                                                        <tr>
                                                            <td width="50%" class="text-dark">
                                                                <b>Procedure</b>
                                                            </td>
                                                            <td width="50%">
                                                                <p class="mb-0">
                                                                    <?php echo e($value['Procedure'] ?? null); ?></p>
                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>

                                                    <?php if(isset($value['Effective Dates of Service'])): ?>
                                                        <tr>
                                                            <td class="text-dark">
                                                                <b>Effective Dates of Service</b>
                                                            </td>
                                                            <td><?php echo e($value['Effective Dates of Service']); ?></td>
                                                        </tr>
                                                    <?php endif; ?>

                                                </tbody>
                                            </table>
                                        </div>

                                        <div class="table-responsive mt-3">
                                            <table
                                                class="table align-middle table-sm text-center fs_13 text-nowrap">
                                                <?php if(isset($value['Work RVU'])): ?>
                                                    <thead class="pill-shap table_header text-white">
                                                        <tr>
                                                            <th>Type</th>
                                                            <th>RVU</th>
                                                            <th>GPCI</th>
                                                            <th>Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="pill-shap table_body no_gap_before with-border ProximaNova font-apply-direct">
                                                        <?php
                                                            $total1 = $value['Work RVU'] * $value['Work GPCI'];

                                                            $total2 = 0;

                                                            if (isset($single_reports[0]['r_place_of_service_type']) && $single_reports[0]['r_place_of_service_type'] == 'Facility')

                                                            {
                                                                $total2 =
                                                                    $value['Facility RVU'] *
                                                                    $value['Facility PE GPCI'];
                                                            } else {
                                                                $total2 =
                                                                    $value['Non Facility RVU'] *
                                                                    $value['Non Facility PE GPCI'];
                                                            }

                                                            $total3 = $value['MP RVU'] * $value['MP GPCI'];
                                                            $sumtotalcalc = $total1 + $total2 + $total3;
                                                        ?>
                                                        <tr>
                                                            <td>Work</td>
                                                            <td class="border-top-0"><?php echo e($value['Work RVU']); ?></td>
                                                            <td class="border-top-0"><?php echo e($value['Work GPCI']); ?></td>
                                                            <td><?php echo e($total1); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <?php if(isset($single_reports[0]['r_place_of_service_type']) && $single_reports[0]['r_place_of_service_type'] == 'Facility'): ?>

                                                                <td>Facility PE</td>
                                                                <td><?php echo e($value['Facility RVU']); ?></td>
                                                                <td><?php echo e($value['Facility PE GPCI'] ?? null); ?></td>
                                                                <td><?php echo e($total2); ?></td>
                                                            <?php else: ?>
                                                                <td>Non-Facility PE</td>
                                                                <td><?php echo e($value['Non Facility RVU']); ?></td>
                                                                <td><?php echo e($value['Non Facility PE GPCI'] ?? null); ?></td>
                                                                <td><?php echo e($total2); ?></td>
                                                            <?php endif; ?>
                                                        </tr>
                                                        <tr>
                                                            <td>MP</td>
                                                            <td><?php echo e($value['MP RVU']); ?></td>
                                                            <td><?php echo e($value['MP GPCI']); ?></td>
                                                            <td><?php echo e($total3); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="3">
                                                                <div class="right">Sum of Totals</div>
                                                            </td>
                                                            <td><?php echo e($sumtotalcalc); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="3">
                                                                <div class="right">Conversion Factor -
                                                                    <?php echo e($value['convofactor']); ?></div>
                                                            </td>
                                                            <td>$<?php echo e($value['Conversion Factor Value']); ?></td>
                                                        </tr>
                                                        <?php if(isset($value['locality_num'])): ?>
                                                            <tr>
                                                                <td class="fs_16" colspan="4">
                                                                    <span style="text-wrap: balance;">Locality:<?php echo e($value['locality_num']); ?> - <?php echo e($value['locality_name']); ?></span>
                                                                </td>
                                                            </tr>
                                                        <?php endif; ?>
                                                        <tr>
                                                            <?php
                                                                if (
                                                                    preg_match(
                                                                        '/\((.*?)\)/',
                                                                        $value['locality_name'],
                                                                        $matches,
                                                                    )
                                                                ) {
                                                                    $countyName = $matches[1];
                                                                }
                                                            ?>
                                                            <td colspan="4">Counties:
                                                                <?php echo e($countyName ?? $value['locality_name']); ?>

                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                <?php endif; ?>
                                                <tfoot>
                                                    <?php if(isset($value['Calculation Explanation'])): ?>
                                                        <tr>
                                                            <td class="border border-left-0" colspan="3">
                                                                <div class="fw_6">Calculation Explanation</div>
                                                            </td>
                                                            <td class="fw_6 border border-right-0">
                                                                <?php echo e($value['Calculation Explanation'] ?? null); ?>

                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr>
                                                        <td class="border border-left-0" colspan="3">
                                                            <div class="fw_6">Base Maximum Fee</div>
                                                        </td>
                                                        <td class="fw_6 border border-right-0">$<?php echo e($value['Base Maximum Fee'] ?? 0); ?></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- col 2 -->
                                    <div class="col-md-6 half-width">
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2">Base Maximum Fee Exceptions</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before">
                                                    <tr>
                                                        <td class="pt-2 pb-0">
                                                            <?php
                                                                $showNone = true; // Flag to determine if "None" should be displayed
                                                            ?>


                                                            <?php if(isset($value['MEU']) && $value['MEU'] == 1): ?>
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Medically Unlikely
                                                                    Edit (MUE) Rules Applied.</p>
                                                                <?php $showNone = false; ?>
                                                            <?php endif; ?>

                                                            <?php if(isset($value['Prohibited Code']) && $value['Prohibited Code'] == 1): ?>
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Prohibited Code.
                                                                </p>
                                                                <?php $showNone = false; ?>
                                                            <?php endif; ?>

                                                            <?php if(isset($value['MPPR']) && $value['MPPR'] == 1): ?>
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">&#x2022; Multiple Procedure
                                                                    Payment Reduction (MPPR) Rules Applied.</p>
                                                                <?php $showNone = false; ?>
                                                            <?php endif; ?>
                                                            <?php if($showNone): ?>
                                                                <p style="white-space: break-spaces;"
                                                                    class="mb-0">None</p>
                                                            <?php endif; ?>


                                                        </td>

                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2">NCCI Edits</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before">
                                                    <tr>
                                                        <?php if(isset($value['MEU']) && $value['MEU'] == 1): ?>
                                                            <td class="pt-2 pb-0"> DOS MUE Rules Applied – Rationale: 'Nature of
                                                                Service/Procedure' – Units of service allowed:
                                                                <?php echo e($value['max_unit_allowed']); ?> – Effective:
                                                                <?php echo e($value['date_of_service']); ?></td>
                                                        <?php else: ?>
                                                            <td class="pt-2 pb-0">No NCCI edits for this procedure.</td>
                                                        <?php endif; ?>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php if(isset($value['Status Code'])): ?>
                                            <div class="table-responsive mt-2">
                                                <table
                                                    class="table align-middle table-sm table-bordered- -text-center fs_13 text-nowrap">
                                                    <thead>
                                                        <tr>
                                                            <th class="pill-shap table_header-2" colspan="2">CMS RVU Information</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="pill-shap table_body no_gap_before with-border-bottom ProximaNova rvu-information">
                                                        <tr>
                                                            <td class="fw_6">Status Code</td>
                                                            <td>
                                                                <?php if(isset($value['Status Code'])): ?>
                                                                    <?php echo e($value['Status Code']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">PC/TC Indicator</td>
                                                            <td>
                                                                <?php if(isset($value['pctc_indicator'])): ?>
                                                                    <?php echo e($value['pctc_indicator']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Global Days</td>
                                                            <td>
                                                                <?php if(isset($value['glob_days'])): ?>
                                                                    <?php echo e($value['glob_days']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Pre Op</td>
                                                            <td>
                                                                <?php if(isset($value['pre_op'])): ?>
                                                                    <?php echo e(number_format($value['pre_op'], 1, '.', ',')); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Intra Op</td>
                                                            <td>
                                                                <?php if(isset($value['intra_op'])): ?>
                                                                    <?php echo e(number_format($value['intra_op'], 1, '.', ',')); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Post Op</td>
                                                            <td>
                                                                <?php if(isset($value['post_op'])): ?>
                                                                    <?php echo e(number_format($value['post_op'], 1, '.', ',')); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Multiple Procedure</td>
                                                            <td>
                                                                <?php if(isset($value['mult_proc'])): ?>
                                                                    <?php echo e($value['mult_proc']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Bilateral Surgery</td>
                                                            <td>
                                                                <?php if(isset($value['bilat_surg'])): ?>
                                                                    <?php echo e($value['bilat_surg']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Assistant at Surgery</td>
                                                            <td>
                                                                <?php if(isset($value['asst_surg'])): ?>
                                                                    <?php echo e($value['asst_surg']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Co-surgery</td>
                                                            <td>
                                                                <?php if(isset($value['co_surg'])): ?>
                                                                    <?php echo e($value['co_surg']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Team Surgery</td>
                                                            <td>
                                                                <?php if(isset($value['team_surg'])): ?>
                                                                    <?php echo e($value['team_surg']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Endoscopy Base</td>
                                                            <td>
                                                                <?php if(isset($value['endo_base'])): ?>
                                                                    <?php echo e($value['endo_base']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Physician Supervision of
                                                                Diagnostic
                                                                Procedures</td>
                                                            <td>
                                                                <?php if(isset($value['diagnostic_proc'])): ?>
                                                                    <?php echo e($value['diagnostic_proc']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw_6">Diagnostic Imaging Family
                                                                Indicator
                                                            </td>
                                                            <td>
                                                                <?php if(isset($value['diagnostic_family_ind'])): ?>
                                                                    <?php echo e($value['diagnostic_family_ind']); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>


        </div>
    </div>

    <!-- Modal -->
    <div class="modal" id="physicianModal" style=" background: rgb(25 130 154 / 55%);" role="dialog" aria-labelledby="physicianModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <form id="calc_form" action="<?php echo e(url('user/single-report')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header pt-0">
                        <h5 class="modal-title" id="physicianModalLabel">Edit
                            <?php echo $single_reports[0]['r_service_name']; ?>

                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row mt-2">
                            <div class="col-sm-12">
                                <div>
                                    <input type="hidden" class="" id="service_name" name="service_name"
                                        placeholder="Select Service"
                                        value="<?php echo e($single_reports[0]['r_service_name']); ?>" />
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <div class="form_label col-6 col-lg-6 col-xl-3 mb-5">
                                            <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy) </span><span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="datepicker date input-group datepicker-new-theme">
                                                <div class="input-group-append ml-0"> <span class="input-group-text pl-3"><i class="fa fa-calendar"></i></span> </div>
                                                <input type="text" placeholder="MM/DD/YYYY"
                                                    class="dos_input form-control" id="dos" name="dos"
                                                    pattern="\d{2}/\d{2}/\d{4}" min="01-01-2000"
                                                    value="<?php echo e(date('m/d/Y', strtotime($single_reports[0]['r_dos']))); ?>"
                                                    required="" />
                                                
                                                <div class="invalid-feedback datpicker-feedback">Select date of service</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-6 col-lg-6 col-xl-3 mb-5">
                                            <label>Place of Service Type</label>
                                            <div class="mt-3">
                                                <div
                                                    class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="facility"
                                                        name="servicetype" value="Facility" required
                                                        <?php echo e($single_reports[0]['r_place_of_service_type'] == 'Facility' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="facility">Facility</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-facility" name="servicetype" value="Non-Facility"
                                                        required
                                                        <?php echo e($single_reports[0]['r_place_of_service_type'] == 'Non-Facility' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="non-facility">Non-Facility</label>
                                                </div>
                                                <div class="invalid-feedback">Select service type</div>
                                            </div>
                                        </div>

                                        <div class="form_label col-6 col-lg-7 col-xl-5 mb-5">
                                            <label>Provider Type</label>
                                            <div class="mt-3">
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="physician"
                                                        name="providertype" value="Physician" required
                                                        <?php echo e($single_reports[0]['r_provider_type'] == 'Physician' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="physician">Physician</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="non-physician" name="providertype" value="Non-Physician"
                                                        required
                                                        <?php echo e($single_reports[0]['r_provider_type'] == 'Non-Physician' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="non-physician">Non-Physician</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="clinical-soial-worker" name="providertype"
                                                        value="Clinical Soial Worker" required
                                                        <?php echo e($single_reports[0]['r_provider_type'] == 'Clinical Soial Worker' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="clinical-soial-worker">Clinical Soial Worker</label>
                                                </div>
                                                <div class="invalid-feedback">Select provider type</div>
                                            </div>
                                        </div>


                                        <div id="convFactorDiv" class="form_label col-6 col-lg-5 col-xl-3 mb-3">
                                            <label>Select Conversion Factor <span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="mb-3 select2-simple_select_div">
                                                <select id="conversionfactor" class="simple_select mb-3 mt-2 select2-simple_select"
                                                    name="conversionfactor" aria-label="Conversion Factor"
                                                    aria-describedby="conversionfactoralidate" required>
                                                    <option value="Radiology"
                                                        <?php echo e($single_reports[0]['convofactor'] == 'Radiology' ? 'selected' : ''); ?>>
                                                        Radiology</option>
                                                    <option value="Anesthesia"
                                                        <?php echo e($single_reports[0]['convofactor'] == 'Anesthesia' ? 'selected' : ''); ?>>
                                                        Anesthesia</option>
                                                    <option value="Surgery"
                                                        <?php echo e($single_reports[0]['convofactor'] == 'Surgery' ? 'selected' : ''); ?>>
                                                        Surgery</option>
                                                    <option value="Other Services"
                                                        <?php echo e($single_reports[0]['convofactor'] == 'Other Services' ? 'selected' : ''); ?>>
                                                        Other Services</option>
                                                </select>
                                                <div id="conversionfactoralidate" class="invalid-feedback">Select
                                                    conversion factor</div>
                                            </div>
                                        </div>


                                        <div id="localityDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-4 col-xl-3 mb-3 localityDiv">
                                            <label>Find Place of Service Locality By</label>
                                            <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                <div class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input" type="radio"
                                                        name="locality_type" id="county" value="County"
                                                        <?php echo e($single_reports[0]['locality_type'] == 'County' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label fw_4 custom-control-label" for="county">County</label>
                                                </div>
                                                <div class="form-check custom-control custom-radio mr-5 custom-control-inline">
                                                    <input class="form-check-input localitytype custom-control-input" type="radio"
                                                        <?php echo e($single_reports[0]['locality_type'] == 'Zip-Code' ? 'checked' : ''); ?>

                                                        name="locality_type" id="zipcode" value="Zip-Code">
                                                    <label class="form-check-label fw_4 custom-control-label"
                                                        for="zipcode">Zip-Code</label>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="form_label col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                                            <label class="" for="state">State</label>
                                            <div class="select2-simple_select_div select2-state">
                                            <select id="locality_state" name="locality_state" aria-label="State"
                                                class=" mb-3 form-control js-example-basic-single  locality_state select2-simple_select-with-search"
                                                required>
                                                <?php $__empty_1 = true; $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($state->state); ?>"><?php echo e($state->state); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php endif; ?>

                                            </select>
                                            </div>
                                            <div id="servicestateValidate" class="invalid-feedback">
                                                Select State </div>
                                        </div>
                                        <div id="countyListDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-5 col-xl-4 mb-3 countyListDiv">
                                            <label for="calculation_locality_number">Place of Service
                                                County</label>
                                            <div class="mb-3">
                                                <div class="mb-3 select2-simple_select_div select2-place-of-service">
                                                    <select id="calculation_locality_number" name="locality_number"
                                                        aria-label="Place of Service County"
                                                        class=" mb-3 form-control js-example-basic-single  county select2-simple_select-with-search"
                                                        required>

                                                    </select>
                                                    <input type="hidden" class="localityname" name="locality_name"
                                                        id="localityname">


                                                    <div id="servicecountyValidate" class="invalid-feedback">
                                                        Select Place of service </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="zipListDiv"
                                            class="form_label col-sm-6 col-md-4 col-lg-5 col-xl-4 mb-3 zipListDiv">
                                            <label for="servicezipValidate">Place of Service
                                                Zip Code</label>
                                            <div class="mb-3">
                                                <div class="input-parent input-parent-county">
                                                    <input type="text" class="form-control text-uppercase localityzip form-input" name="localityzip" placeholder="Service Zip Code" required />
                                                </div>
                                                <div id="servicezipValidate" class="invalid-feedback">
                                                    Please Enter Zip Code </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12 modal-header">
                                <div class=" modal-title mb-4 mt-0">Bills</div>
                            </div>
                        </div>

                        <div class="row mobile-hidden">
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Modifiers <span class="text-red fs_12"></span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Units <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3">
                                <div class="form_label">
                                    <label>Payment Total <span class="text-red fs_12"></span></label>
                                </div>
                            </div>
                        </div>

                        <div class="field_wrapper">

                            <?php if(count($single_reports) > 0): ?>
                                <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $single_report_key => $single_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row select-container">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span class="text-red fs_12">*</span></label>
                                                    <div class="input-parent input-parent-cpt">
                                                        <input type="text" class="form-control inc cptcode text-uppercase form-input"
                                                            name="singleReport[<?php echo e($single_report_key); ?>][cptcode]"
                                                            placeholder="CPT code"
                                                            value="<?php echo e($single_report['Procedure Code']); ?>" maxLength="5"
                                                            required />
                                                    </div>
                                                <div class="invalid-feedback code-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3 select2-simple_select_div select2-modifiers">
                                                    

                                                    <select
                                                        name="singleReport[<?php echo e($single_report_key); ?>][modifiers][]"
                                                        multiple
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive select2-simple_select-with-search">

                                                        <?php if(count($list) > 0): ?>
                                                            <?php
                                                            $mod = $single_report['Modifier'] ?? null;
                                                            // Convert $mod into an array of selected values
                                                            if (strpos($mod, ',') !== false) {
                                                                // If $mod contains a comma, explode into an array
                                                                $selectedValues = explode(',', $mod);
                                                            } else {
                                                                // If $mod is a single value, convert it to an array
                                                                $selectedValues = [$mod];
                                                            }
                                                            ?>
                                                            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php
                                                                // Check if the current option value is in the $selectedValues array
                                                                $isSelected = in_array($value->value, $selectedValues);
                                                                ?>
                                                                <option value='<?php echo e($value->value); ?>'
                                                                    <?php echo e($isSelected ? 'selected' : ''); ?>>
                                                                    <?php echo e($value->label); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span class="text-red fs_12">*</span></label>
                                                <div class="input-parent input-parent-unit">
                                                    <input type="text" class="form-control units form-input" name="singleReport[<?php echo e($single_report_key); ?>][units]"
                                                    placeholder="Enter Unit number" min="1" value="<?php echo e($single_report['Units']); ?>" maxLength="3" required />
                                                </div>
                                                <div class="invalid-feedback unit-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <div class="input-parent input-parent-charges">
                                                    <input type="text" class="form-control charges form-input"
                                                        name="singleReport[<?php echo e($single_report_key); ?>][payment_total]"
                                                        placeholder="0.00"
                                                        value="<?php echo e($single_report['Payment Total']); ?>"
                                                        maxLength="10" />
                                                    </div>
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        </div>

                        


                        <div class="row mb-3">
                            <div class="col-12 col-lg-5">
                                <div class="text-right d-flex">

                                    <button type="submit"
                                        class="btn border-0 btn-custom-1 w-auto fs_15 text-white rounded-100"
                                        id="submitButton">Calculate</button>
                                </div>
                            </div>
                        </div>




                    </div>

                </form>
            </div>
        </div>
    </div>
    
<script>
    window.baseUrl = "<?php echo e(url('/')); ?>";
</script>

    
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <script src="<?php echo e(asset('user/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('user/assets/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table.js')); ?>"></script>
    
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table-export.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/tableExport.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table-filter-control.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="<?php echo e(asset('user/assets/js/custom.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/dynamic_cpt_row_edit.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>


    <?php if(\Session::has('message')): ?>
        <script>
            // Display SweetAlert error message using the message from the session
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "<?php echo \Session::get('message'); ?>"
            });
        </script>
    <?php endif; ?>

    <script>
        $(document).on('select2:open', () => {
            document.querySelector('.select2-search__field').focus();
        });

        $(document).ready(function() {

            $('.select2-simple_select').select2({
                minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });

            $('.select2-simple_select-with-search').select2({
                // minimumResultsForSearch: -1,
                dropdownCssClass: 'select2-simple_select_dropdown'
            });
            $('.select2-state .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "state",
            });
            $('.select2-place-of-service .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Service Zip Code",
            });
            $('.select2-modifiers .select2-simple_select-with-search').select2({
                dropdownCssClass: 'select2-simple_select_dropdown',
                placeholder: "Modifiers",
                allowClear: true,
            });

            // Assuming you have a variable called localityNumber pre-set in your view
            var preSelectedstate = '<?php echo e($single_report['r_localitystate']); ?>';
            var prezipcode = '<?php echo e($single_report['zip']); ?>';

            $('#locality_state').val(preSelectedstate).trigger('change');
            $('.localitytype').trigger('change');

            $('.localitytype').trigger('change');
            if (prezipcode) {
                $('.localityzip').val(prezipcode);

            }

        });





        $('#calc_form').submit(function(event) {
            event.preventDefault(); // Prevent default form submission
            isValid = true;
            $('.units').each(function() {
                let unitInput = $(this);
                let unitValue = parseInt(unitInput.val());
                if (unitValue < 1) {
                    isValid = false;
                    unitInput.val('')
                } else {
                    unitInput.removeClass('invalid-unit');
                }
            });

            if (isValid) {
                $("#submitButton").prop('disabled', true);
                $("#submitButton").html('Calculating...');
                var formData = $(this).serialize();
                $.ajax({
                    url: "<?php echo e(route('edit-report')); ?>", // Form action URL
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Calculation Error',
                                text: response.error
                            });
                            $("#submitButton").prop('disabled', false);
                            $("#submitButton").html('Calculate');
                        } else {
                            $('#calc_form')[0].submit();
                        }



                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: "Something Went Wrong!"
                        });
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid Unit!',
                    text: 'Please enter a unit value that is at least 1.'
                });
            }
        });


        $('#pdfform').submit(function(event) {
            event.preventDefault(); // Prevent default form submission


            $("#pdfbtn").prop('disabled', true);
            $("#pdfspan").html(' Processing...');
            var formData = $(this).serialize();
            $.ajax({
                url: "<?php echo e(route('edit-report')); ?>", // Form action URL
                method: 'POST',
                data: formData,
                success: function(response) {
                    if (response.error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'PDF Error',
                            text: response.error
                        });
                        $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                    } else {
                         $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                        $('#pdfform')[0].submit();
                    }



                },
                error: function(xhr, status, error) {
                    $("#pdfbtn").prop('disabled', false);
                    $("#pdfspan").html(' Print PDF');
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: "Something Went Wrong!"
                    });
                }
            });


        });





        $(".dos_input").on("change", function() {
            var sb_dos_selected = $(this).val();
            if (moment(sb_dos_selected).isAfter(moment('02/28/2017', 'MM/DD/YYYY'))) {
                $(".convFactorDiv select option[value='Other Services']").attr('selected', 'selected');
            }
            var state = $(".locality_state").val();
            fetchServicePlaces(state, sb_dos_selected)
        });

        $('.county').on('change', function() {
            // Get the selected state value
            var selectedOption = $(this).find('option:selected');
            var selectedText = selectedOption.text();
            $(".localityname").val(selectedText);

        });

        $('.localitytype').change(function() {
            var checkedValue = $(this).val(); // Get the value of the changed checkbox

            if ($(this).is(':checked')) {
                console.log(checkedValue); // Output the checked value

                if (checkedValue === "County") {
                    $(".zipListDiv").hide();
                    $('.localityzip').prop('required', false);
                    $("#calculation_locality_number").prop('required', true);
                    $(".countyListDiv").show();

                } else {
                    $(".zipListDiv").show();
                    $('.localityzip').prop('required', true);
                    $("#calculation_locality_number").prop('required', false);
                    $(".countyListDiv").hide();
                }
            }
        });


        $('.locality_state').on('change', function() {
            // Get the selected state value
            var state = $(this).val();
            var dateofservice = $(".dos_input").val();
            // Call the fetchServicePlaces function with the selected state value
            fetchServicePlaces(state, dateofservice);
        });

        function fetchServicePlaces(state, doservice) {
            $.ajax({
                url: '<?php echo e(route('placeOfServiceList')); ?>',
                type: 'GET',
                data: {
                    state: state,
                    dos: doservice
                },
                success: function(response) {
                    // Clear previous options
                    $('.county').empty();

                    // Iterate over each response item and append an option
                    $.each(response, function(index, item) {
                        $('.county').append('<option value="' + item
                            .locality_number + '">' + item.locality_name + "-" + item
                            .locality_number +
                            ' </option>');
                        $('.county').trigger("change");
                    });

                    var preSelectedlocality = '<?php echo e($single_report['locality_num'] ?? null); ?>';
                    if (preSelectedlocality) {
                        // Set the selected option in Select2
                        $('.county').val(preSelectedlocality).trigger('change');
                    }
                    $('.localitytype').trigger('change');

                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    </script>



</body>

</html>
<?php /**PATH /var/www/hrm/omfs-calculator/resources/views/services/physician/single-report.blade.php ENDPATH**/ ?>