<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/bootstrap.min.css')); ?>" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/font-awesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/bootstrap-datepicker3.min.css')); ?>" />
    <link rel='stylesheet' href="<?php echo e(asset('user/assets/css/bootstrap-table.min.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('user/assets/style.css')); ?>" rel="stylesheet" />
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>

    <?php if($errors->any()): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                title: 'Validation Errors',
                html: `
                    <ul style="text-align: left; list-style-type: none; padding: 0;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>⚠️ <?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                `,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        });
    </script>
<?php endif; ?>

    <style>
        .was-validated .invalid-unit,
        .invalid-unit {
            border: 2px solid red !important;
            /* Change the border color to red for invalid units */
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(.375em + .1875rem) center !important;
            background-size: calc(.75em + .375rem) calc(.75em + .375rem) !important;

        }
    </style>

</head>

<body class="bg_gray- bg-new-theme ff_omfs">
    <div class="header-home">
        <div class="row mx-0">
            <div class="col-lg-6 pl-lg-5 --ml-2 py-3">
                <div class="d-flex justify-content-around align-items-center logo-div">
                    <img src="<?php echo e(asset('user/assets/img/logo.svg')); ?>" alt="OMFS Calculator Logo" class="img-fluid"
                        height="38" />
                    <span class="separator mx-2 mx-md-0">|</span>
                    <h1 class="ProximaNova fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
                </div>
            </div>
            <div
                class="col-lg-6 d-flex justify-content-center justify-content-md-start justify-content-lg-end align-items-center text-white mb-3 mb-lg-0 pl-md-4 pl-lg-3">
                <div class="user-profile-icon">
                    <i class="fa fa-user" aria-hidden="true"></i>
                </div>
                <div class="fs_16 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> <?php echo e(\Auth::user()->email); ?></div>
                <a href="<?php echo e(url('user/logout')); ?>" class="fw_5 btn btn-custom-2 text-white fs_16 ml-3">Logout</a>
            </div>
        </div>
    </div>

    <div class="row mx-0 calc_container">
        <div class="col-lg-3 px-0 bg-white mh-100 min-lg-vh-100 ">
            <div class="tab_head mt-3 mt-md-5 pt-3">
                <nav>
                    <div class="nav flex-lg-column nav-tabs nav-fill new-theme-tab" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link text-left" id="physician-services-tab" data-toggle="tab"
                            href="<?php echo e(route('physician.service')); ?>" role="tab" aria-controls="physician-services"
                            aria-selected="true"><span class="nav-tab-icon"></span>Physician Services</a>
                        <a class="nav-item nav-link text-left active" id="e-service-tab" data-toggle="tab" href="<?php echo e(route('pharmacy.service')); ?>"
                            role="tab" aria-controls="e-service" aria-selected="false"><span
                                class="pharmacy-tab-icon"></span>Pharmacy</a>
                        <a class="nav-item nav-link text-left" id="rfa-serving-tab" data-toggle="tab"
                            href="#rfa-serving" role="tab" aria-controls="rfa-serving" aria-selected="false"><span
                                class="nav-tab-icon"></span>RFA Serving</a>
                        <a class="nav-item nav-link text-left" id="pr2-service-tab" data-toggle="tab"
                            href="#pr2-service" role="tab" aria-controls="pr2-service" aria-selected="false"><span
                                class="nav-tab-icon"></span>PR2 Service</a>
                        <a class="nav-item nav-link text-left" id="claim-admin-dir-tab" data-toggle="tab"
                            href="#claim-admin-dir" role="tab" aria-controls="claim-admin-dir"
                            aria-selected="false"><span class="nav-tab-icon"></span>Claim Admin Directory</a>
                    </div>
                </nav>
            </div>
        </div>
        <div class="col-lg-9 px-md-5">

            <div class="tab_body tab-content new-theme-tab-content py-2 px-3 px-sm-0" id="nav-tabContent">
                <div class="tab-pane show active" id="physician-services" role="tabpanel"
                    aria-labelledby="physician-services-tab">
                    <div class="container-fluid">
                        <div class="row my-3 rounded">
                            <div class="col-md-6 px-0">
                                <div class="custom-control custom-switch">
                                    
                                </div>
                            </div>

                            <div class="col-md-6 px-0 text-right">
                                <div class="d-flex justify-content-end align-items-center #bulkCollapse">
                                    <div id="email_div">
                                        <div class="input-parent input-parent-email float-right hide-input-parent">
                                            <input type="text"
                                                class="form-control text-uppercase form-input rc_emails float-right"
                                                placeholder="Receiver email address" required
                                                style="width: 0; padding: 0;">
                                        </div>
                                        <div id="servicezipValidate" class="invalid-feedback">Please Enter valid Email
                                            Address</div>
                                    </div>
                                    <div class="custom-control custom-switch ml-3">
                                        <input type="checkbox" value="1"
                                            class="custom-control-input" id="is_pdf_bulk">
                                        <label class="custom-control-label" for="is_pdf_bulk">Pdf Result</label>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <div class="row bg-white position-relative">
                            <div class="position-absolute bulk-cascading-banner-left"
                                style=" min-width: 300px; height: 100%; width: 100%; max-width: 330px;"></div>
                            
                            <div class="col-lg-12 offset-xl-3 col-xl-6 text-center py-4" style="z-index: 1">
                                <h2 class="fw_7 fs_25 ProximaNova text-dark mb-3 mb-sm-0">Are you interested to get
                                    Multiple Bills?</h2>

                                <span class="fw_7 fs_13 text-dark ProximaNova d-block mb-1 mt-2 ml-2">Download xlsx
                                    Template:</span>
                                <div class="mb-3 mt-2 inline_btn_compact justify-content-center cascading-btn"
                                    style="justify-content: center !important;">

                                    <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-md-2 rounded-100 samplefile btn-custom-1 w-auto text-white"
                                        href="<?php echo e(asset('user/bulk-template/SamplePharmacy.xlsx')); ?>" download><i
                                            class="fa fa-download mr-2" aria-hidden="true"></i><span
                                            class="sampletxt">Sample
                                            xlsx</span></a>
                                    <a class="btn text-white fs_14 py-2 collapsed mt-2 ml-2 rounded-100 btn-custom-2"
                                        data-toggle="collapse" href="#bulkCollapse" role="button"
                                        aria-expanded="false" aria-controls="bulkCollapse">Upload Multiple Bills</a>
                                </div>
                            </div>
                            
                            <div class="bulk-cascading-banner-right position-absolute"
                                style="right: 0; min-width: 300px; height: 100%; width: 100%; max-width: 330px;"></div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-sm-12">

                                <div class="collapse" id="bulkCollapse">
                                    <div class="card card-body border-0"
                                        style="background-color: #fff; border-radius: 10px;">
                                        <form method="POST" action="<?php echo e(route('pharmacy.bulkupload')); ?>" id="upload-file"
                                            enctype="multipart/form-data" class="was-validated">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="is_cascading_bulk" value="0"
                                                class="custom-control-input" id="is_cascading_bulk_h">

                                                 <input type="hidden" name="is_pdf_bulk" value="0"
                                                class="custom-control-input" id="is_pdf_bulk_h">

                                                 <input type="hidden" name="rc_email" value=""
                                                class="custom-control-input" id="rc_email_h">

                                            <div class="row">
                                                <div class="col-sm-12 text-left text-sm-right mb-3">
                                                    <div class="row">
                                                        <div class="col-md-12 text-left">
                                                            <div class="fw_7 fs_13 text-dark mb-1">Upload Your file
                                                                <span class="fs_12 fw_4">(xlsx format only):</span>
                                                            </div>

                                                        </div>

                                                        <div class="col-md-12 d-flex flex-row align-items-center">
                                                            <div class="fileBrowse">
                                                                <input type="file" class="fs_12" name="file"
                                                                    id="file" required />
                                                                <img src="<?php echo e(asset('user/assets/images/upload-icon.png')); ?>"
                                                                    width="50px" height="50px" />
                                                                <label for="file"></label>
                                                                <div class="invalid-feedback">xlsx file is required.
                                                                </div>
                                                            </div>
                                                            <div class="ml-2"style="min-width: 180px;">
                                                                <button type="submit"
                                                                    class="btn border-0 rounded-100 btn-custom-1 w-auto- text-white fs_15 px-0 bulk-submit"
                                                                    id="bulk-submit">
                                                                    Calculate Multiple Bills
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    
                    <h3 class="ProximaNova fw_5 fs_20 text-dark mb-3 mt-4">Bill Information</h3>
                    <form id="calc_form" method="POST" action="<?php echo e(route('pharmacy.single-report')); ?>" novalidate="">
                        <?php echo csrf_field(); ?>
                        <div class="service_name">
                            <input type="hidden" class="" id="service_name" name="service_name"
                                placeholder="Select Service" value="Pharmacy Services" />
                        </div>
                        <div class="row mt-lg-2 ">
                            <div class="col-sm-12">
                                <div class="form-group bg-white py-4 px-4">
                                    <div class="row">
                                        <div class="form_label col-sm-6 col-xl-6 mb-4">
                                            <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy)</span><span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="datepicker date input-group datepicker-new-theme">
                                                <div class="input-group-append ml-0"> <span
                                                        class="input-group-text pl-3"><i
                                                            class="fa fa-calendar"></i></span> </div>
                                                <input type="text" placeholder="MM/DD/YYYY"
                                                    class="form-control dos_input" id="dos" name="dos"
                                                    pattern="\d{2}/\d{2}/\d{4}" value="<?php echo e(old('dos')); ?>"
                                                    min="01/01/2000"  required="" />
                                                <div class="invalid-feedback datpicker-feedback pr-5">Select date of
                                                    service</div>
                                            </div>
                                        </div>



                                        <div class="form_label col-12 col-xl-6  mb-4 float-end">
                                            <label>Product Type <span
                                                class="text-red fs_12">*</span></label>
                                            <div class="custom-input-form d-flex align-items-center">
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="compound"
                                                        name="product_type" value="compound" required disabled >
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="compound"><span>Compound</span></label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-xl-5 custom-control-inline">
                                                    <input type="radio" class="custom-control-input"
                                                        id="dispensed" name="product_type" value="dispensed"
                                                        required checked>
                                                    <label class="form-check-label custom-control-label fw_4 mb-0"
                                                        for="dispensed"><span>Dispensed</span></label>
                                                </div>

                                                <div class="invalid-feedback">Select Product type</div>
                                            </div>
                                        </div>




                                    </div>
                                </div>


                            </div>

                        </div>

                        <div class="row mt-2 margin_up_minus">
                            <div class="col-sm-12">
                                
                                <h3 class="ProximaNova fw_5 fs_20 text-dark mb-3 mt-5">Procedure Codes</h3>
                            </div>
                        </div>



                        <div class="bill-section bg-white py-4 px-4">
                            <div class="row mobile-hidden d-xl-flex d-none">
                                <div class="col-6 col-sm-4 col-md-4">
                                    <div class="form_label">
                                        <label>NDC Number<span class="text-red fs_12">*</span></label>
                                    </div>
                                </div>

                                <div class="col-6 col-sm-4 col-md-4">
                                    <div class="form_label">
                                        <label>Units <span class="text-red fs_12">*</span></label>
                                    </div>
                                </div>
                                <div class="col-6 col-sm-4 col-md-4">
                                    <div class="form_label">
                                        <label>Payment Total <span class="text-red fs_12"></span></label>
                                    </div>
                                </div>
                            </div>
                            <div class="field_wrapper_main">
                                <div class="row select-container_main">
                                    <div class="col-6- col-md-6 col-xl-4">
                                        <div class="form_label mb-3">
                                            <label class="d-block d-xl-none">NDC Number<span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="input-parent input-parent-cpt">
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase form-input"
                                                    name="singleReport[0][cptcode]" placeholder="NDC Number"
                                                    value=""  maxLength="13"
                                                    required />
                                            </div>
                                            <div class="invalid-feedback code-feedback">Fill NDC Number</div>

                                        </div>
                                    </div>

                                    <div class="col-6- col-md-6 col-xl-4 ">
                                        <div class="form_label mb-3">
                                            <label class="d-block d-xl-none">Units <span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="input-parent input-parent-unit">
                                                <input type="text" class="form-control units form-input"
                                                    name="singleReport[0][units]" placeholder="1" value="1"
                                                    maxLength="3" required />
                                            </div>
                                            <div class="invalid-feedback unit-feedback">Select unit</div>
                                        </div>
                                    </div>
                                    <div class="col-6- col-md-6 col-xl-4">
                                        <div class="form_label mb-3 ">
                                            <label class="d-block d-xl-none">Payment Total <span
                                                    class="text-red fs_12"></span></label>
                                            <div class="last_field">
                                                <div class="input-parent input-parent-charges">
                                                    <input type="text" class="form-control charges form-input"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                </div>
                                                <div class="removeField">
                                                    <a href='javascript:void(0);' class='remove_button'><i
                                                            class='fa fa-remove' aria-hidden='true'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-5">
                                    <div class="text-right d-flex">
                                        <button type="submit"
                                            class="btn border-0 btn-custom-1 w-auto fs_15 text-white rounded-100"
                                            id="submitButton">Calculate</button>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </form>

                    
                </div>

            </div>
        </div>
    </div>

    <script>
        window.baseUrl = "<?php echo e(url('/')); ?>";
    </script>

    
    <script src="<?php echo e(asset('user/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table-export.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/tableExport.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/bootstrap-table-filter-control.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="<?php echo e(asset('user/assets/js/dynamic_cpt_row_main_pharmacy.js')); ?>"></script>
    <script src="<?php echo e(asset('user/assets/js/custompharmacy.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <?php if(\Session::has('message')): ?>
        <script>
            // Display SweetAlert error message using the message from the session
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "<?php echo \Session::get('message'); ?>"
            });
        </script>
    <?php endif; ?>


    <script>
        $(document).ready(function() {


            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {

                var tabId = $(e.target).html(); // Get activated tab's ID
                $("#service_name").val(tabId);
                $('form')[0].reset();

                var href = $(e.target).attr('href');
            if (href && href.startsWith('http')) {
                window.location.href = href; // Redirect to the URL
            }
            });


        });



        $(function() {
            /*Date Comparison*/

            window.onpageshow = function(event) {
                if (event.persisted) {
                    window.location.reload();
                    document.getElementById("upload-file").reset();
                }
            };
        });


        $(document).ready(function() {
            // Handle form submission
            $('#upload-file').submit(function(event) {
                event.preventDefault();

                var rc_email = $(".rc_emails").val();
                if ($("#is_pdf_bulk").prop('checked')) {
                    if (rc_email && validateEmail(rc_email)) {
                         Swal.fire({
                            icon:"info",
                            text: "You will receive an email with PDF reporting details shortly after the Multiple DOS processing is complete."
                        });
                        setTimeout(function() {
                        $('#upload-file')[0].submit();

                        }, 2000);

                        $("#is_pdf_bulk_h").val(1)
                        $("#rc_email_h").val(rc_email)

                    } else {


                        Swal.fire({
                            icon: 'error',
                            title: 'Valid Receiver Email',
                            text: "Please enter a valid email address."
                        });
                    }
                } else {
                    $('#upload-file')[0].submit();

                }

            });

            function validateEmail(email) {
                var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return re.test(email);
            }

            $('#calc_form').submit(function(event) {
                event.preventDefault(); // Prevent default form submission
                isValid = true;
                $('.units').each(function() {
                    let unitInput = $(this);
                    let unitValue = parseInt(unitInput.val());
                    if (unitValue < 1) {
                        isValid = false;
                        unitInput.val('')
                    } else {
                        unitInput.removeClass('invalid-unit');
                    }
                });

                if (isValid) {
                    $("#submitButton").prop('disabled', true);
                    $("#submitButton").html('Calculating...');
                    var formData = $(this).serialize();
                    $.ajax({
                        url: "<?php echo e(route('pharmacy.edit-report')); ?>", // Form action URL
                        method: 'POST',
                        data: formData,
                        success: function(response) {
                            if (response.error) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Calculation Error',
                                    text: response.error
                                });

                                $("#submitButton").prop('disabled', false);
                                $("#submitButton").html('Calculate');
                            } else {
                                $('#calc_form')[0].submit();
                            }



                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: "Something Went Wrong!"
                            });

                            $("#submitButton").prop('disabled', false);
                            $("#submitButton").html('Calculate');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Invalid Unit!',
                        text: 'Please enter a unit value that is at least 1.'
                    });

                    $("#submitButton").prop('disabled', false);
                    $("#submitButton").html('Calculate');
                }
            });

        });




        $("#is_pdf_bulk").on('change', function() {
            console.log("test");

            $("#email_div input").css("transition", "0.4s");

            if ($(this).prop('checked')) {

                $("#email_div input").css("width", "100%");
                $("#email_div input").css("padding", "14px 60px")
                setTimeout(() => {
                    $("#email_div .input-parent-email").removeClass("hide-input-parent");
                }, 300);

            } else {
                $("#email_div input").css("width", "0%");
                $("#email_div input").css("padding", "0");

                $("#email_div .input-parent-email").addClass('hide-input-parent');
            }
        });


    </script>

</body>

</html>
<?php /**PATH /var/www/hrm/omfs-calculator/resources/views/services/pharmacy/home.blade.php ENDPATH**/ ?>