<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report Pharmacy</title>

    <style>
        @font-face {
            font-family: 'ProximaNova';
            src: url("<?php echo e(asset('user/assets/fonts/proxima-nova/ProximaNova-Regular.otf')); ?>");
        }
        .container-fluid {
            width: 100%;
            font-family: 'ProximaNova', sans-serif;
        }

        .col-3 {

            display: inline-block;
            width: 23.5%;
        }

        .col-5 {
            display: inline-block;
            vertical-align: top;
            width: 29.5%;
        }

        .col-6 {
            display: inline-block;
            vertical-align: top;
            width: 49.5%;
        }

        .col-7 {
            display: inline-block;
            vertical-align: top;
            width: 69.5%;
        }

        .field_border {
            border: 1px solid #dcdcdc;
            border-radius: 6px;
            padding: 10px 5px;
            font-size: 15px;
            color: #555;
        }

        .disabled {
            color: black;
            background-color: #f5f5f5;
            pointer-events: none;
            font-weight: bold;
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
            border: 1px solid #dee2e6;
            border-collapse: collapse;
        }

        .table th,
        .table td {
            padding: 10px;
            border-spacing: 0em;
            border: 1px solid #dee2e6;
        }

        .table tr:nth-child(even) {
            background: #f5f5f5;
        }

        /* margins */
        .mr-1 {
            margin-right: 0.5rem;
        }

        .mt-2 {
            margin-top: 0.5rem;
        }

        .mr-2 {}

        .mb-3 {
            margin-bottom: 2.5rem;
        }

        .ml-2 {
            margin-left: 2.5rem;
        }

        .my-2 {
            margin-top: 0.5rem;
            margin-bottom: 0.5rem;
        }

        .pl-2 {
            padding-left: 1rem;
        }

        /* margins end */

        /* paddings */
        .pr-1 {
            padding-right: 0.5rem;
        }

        .pt-2 {
            padding-top: 0.5rem;
        }

        .py-2 {
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
        }

        .px-2 {
            padding-right: 0.5rem;
            padding-left: 0.5rem;
        }

        /* paddings end */


        /* fonts */
        .fs_13 {
            font-size: 13px;
        }

        .fs_16 {
            font-size: 16px;
        }

        .fs_18 {
            font-size: 18px;
        }

        .fs_20 {
            font-size: 20px;
        }

        .fs_25 {
            font-size: 25px;
        }

        /* fonts end */


        /* color and BG colors */
        .bg_green,

        .calc_container .btn-primary {
            background-color: #08ad79;
            background-color: #CAF5FF !important;
        }

        .color_green {
            color: #08ad79;
        }

        .text-white {
            color: #fff !important;
            color: #000 !important;
        }

        .page-break {
            page-break-after: always;
        }

        /* color and BG colors  end*/

        .page-number:before {
            content: "Page " counter(page) " of " counter(pages);
        }
    </style>
</head>

<body>
    <div class="container-fluid">
        <!-- row 1  -->
        <div class="mb-3">
            <div class="col-7">
                <h1 class="fs_20">California Explanation of Fee Schedule (EOFS)</h1>
            </div>
            <div class="col-5">
                <small style="margin-bottom: 0;">Powered By</small>
                <h2 style="margin-top: 0; color: #178199;" class="fs_16 color_green-">Medical Lien Management</h2>

            </div>
            <h4>Pharmacy</h4>
            <hr>
        </div>


        <div class="row mt-3 mb-1">
            <!-- California Explanation of Fee Schedule (EOFS) -->
            <div class="col-3 mr-1">
                <div class="fs_13">
                    <div><strong>Date of Service:</strong></div>
                    <div class="field_border disabled mt-2 pl-2">
                        <?php echo e(date('m/d/Y', strtotime($single_reports[0]['date_of_service']))); ?>

                    </div>
                </div>
            </div>

            <div class="col-3 mr-1">
                <div class="fs_13">
                    <div><strong>Product Type:</strong></div>
                    <div class="field_border disabled mt-2 pl-2"><?php echo e($single_reports[0]['r_product_type'] ?? "dispensed"); ?>

                    </div>
                </div>
            </div>



        </div>

        <!-- row 2 -->
        <div class="row mt-3 mb-3- rounded" id="section2">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                        <thead class="pill-shap table_header text-white">
                            <tr>
                                <th></th>
                                <th class="px-2">NDC Number</th>
                                <th>Units</th>
                                <th>Fee Schedule</th>
                                <th>Payment Total</th>
                                <th>Balance Due</th>
                                <th>Fee Schedule %</th>
                            </tr>
                        </thead>
                        <tbody class="pill-shap table_body with-total">

                            <?php if(count($single_reports) > 0): ?>
                                <?php
                                    $i = 0;
                                    $sn = 0;
                                    $total_omfs = 0;
                                    $total_payment_total = 0;
                                    $total_balance_due = 0;
                                    $total_percentexpected = 0;
                                ?>
                                <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $single_report_key => $single_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class=""><?php echo e(++$sn); ?>  </td>

                                        <td class="text-uppercase  px-2">
                                            <?php echo e($single_report['NDC Number']); ?>


                                        </td>
                                        <td><?php echo e($single_report['Units']); ?> </td>
                                        <td>
                                            <?php if(is_numeric($single_report['Fee Schedule'])): ?>
                                                $<?php echo e(number_format($single_report['Fee Schedule'], 2)); ?>

                                            <?php else: ?>
                                                <?php echo e($single_report['Fee Schedule']); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>$<?php echo e($single_report['Payment Total']); ?></td>
                                        <td>$<?php echo e(floatval(round($single_report['Balance Due'], 2))); ?>

                                        </td>

                                        <?php if($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule'])): ?>
                                            <td><?php echo e($single_report['Fee Schedule %']); ?></td>
                                        <?php else: ?>
                                            <td>N/A</td>
                                            <!-- Or handle the case where Fee Schedule is zero -->
                                        <?php endif; ?>
                                    </tr>
                                    <tr>
                                        <td ></td>
                                        <td colspan="2">Dispensing Fee :</td>
                                        <td>

                                                   $<?php echo e($single_report['Dispensing Fee']); ?>

                                        </td>
                                        <td></td>
                                        <td></td>
                                        <td></td>

                                    </tr>
                                    <?php
                                        $total_payment_total += $single_report['Total Payment Total'];
                                        $roundOffBalanceDue = floatval(round($single_report['Total Balance Due'], 2));
                                        $total_balance_due += $roundOffBalanceDue;
                                        if (
                                            $single_report['Fee Schedule'] != 0 &&
                                            is_numeric($single_report['Fee Schedule'])
                                        ) {
                                            $total_omfs += $single_report['Total Fee Schedule'];

                                            $roundOffPercentExpected = str_replace(
                                                '%',
                                                '',
                                                $single_report['Total Fee Schedule %'],
                                            );
                                        } else {
                                            $roundOffPercentExpected = 0;
                                        }
                                        $total_percentexpected += $roundOffPercentExpected;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><b>Total</b></td>
                                <td><b>$<?php echo e(number_format($total_omfs, 2)); ?></b></td>
                                <td><b>$<?php echo e(number_format($total_payment_total, 2)); ?></b></td>
                                <td><b>$<?php echo e(number_format($total_balance_due, 2)); ?></b></td>
                                <td><b><?php echo e($total_percentexpected); ?>%</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>




        <!-- row 3 -->

        <!-- row 4  -->

        <div class="accordion" id="accordionExample">

            <?php $__currentLoopData = $single_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <h3>Procedure Code - Fee Schedule Calculations</h3>

                <div class="card">
                    <div class="card-header btn" id="heading<?php echo e($loop->iteration); ?>" data-toggle="collapse"
                        data-target="#collapse<?php echo e($loop->iteration); ?>" aria-expanded="true"
                        aria-controls="collapse<?php echo e($loop->iteration); ?>">
                        <h4 class="mb-0 "> #<?php echo e($loop->iteration); ?> -
                            <?php echo e(ucfirst($value['NDC Number'] ?? $single_report['r_hcpcs'])); ?>

                        </h4>
                    </div>

                    <div id="collapse<?php echo e($loop->iteration); ?>"
                        class="collapse <?php if($loop->iteration === 1): ?> show <?php endif; ?>"
                        aria-labelledby="heading<?php echo e($loop->iteration); ?>" data-parent="#accordionExample">
                        <div class="pdf-page-break">
                            <hr>

                            <div class="row">
                                <!-- col 1 -->
                                <div class="col-6 half-width">
                                    <div class="table-responsive">
                                        <table
                                            class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th class="bg_green text-white " colspan="2">
                                                        Base Maximum Fee Calculation</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td width="40%" class=" pt-3">
                                                        <b>Fee Schedule</b>
                                                    </td>
                                                    <td width="60%" class=" pt-3">
                                                        <?php echo e($value['fee schedule title'] ?? null); ?>

                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td width="40%">
                                                        <b>Description</b>
                                                    </td>
                                                    <td width="60%">
                                                        <p class="mb-0" style=" margin: 0; padding: 0;">
                                                            <?php echo e($value['Description'] ?? null); ?>

                                                        </p>
                                                    </td>
                                                </tr>

                                                <?php if(isset($value['Effective Dates of Service'])): ?>
                                                    <tr>
                                                        <td>
                                                            <b>Effective Dates of Service</b>
                                                        </td>
                                                        <td><?php echo e($value['Effective Dates of Service']); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                            </tbody>
                                        </table>
                                    </div>



                                </div>
                                <!-- col 2 -->

                            </div>
                        </div>
                    </div>
                </div>

                <?php if(!$loop->last): ?>
                    <div class="page-break"></div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="footer">
                <script type="text/php">
            if (isset($pdf)) {
                $pdf->page_script('
                    $font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
                    $size = 12;
                    $pageText = "Page " . $PAGE_NUM . " of " . $PAGE_COUNT;
                    $y = 15;
                    $x = 520;
                    $pdf->text($x, $pdf->get_height() - 30, $pageText, $font, $size);
                ');
            }
        </script>
            </div>
        </div>

    </div>
</body>



</html>
<?php /**PATH /var/www/hrm/omfs-calculator/resources/views/services/pharmacy/single-report-pdf.blade.php ENDPATH**/ ?>