<?php

use App\Http\Controllers\Api\AuthApiController;
use App\Http\Controllers\Api\OmfsApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::prefix('auth')->group(function () {
    Route::post('/token', [AuthApiController::class, 'issueToken']);
    Route::post('/refresh', [AuthApiController::class, 'refreshToken']);
    Route::post('/revoke', [AuthApiController::class, 'revokeToken']);
});

// Route::middleware('client')->group(function () {

//     Route::post('/get-omfs-report', [OmfsApiController::class, 'singleReportLoadQuery']);
//     Route::post('/get-pdf-report', [OmfsApiController::class, 'GetSingleReportPdf']);
// });


Route::middleware(['client'])->group(function () {
    Route::post('/get-omfs-report', [OmfsApiController::class, 'singleReportLoadQuery']);
    Route::post('/get-pdf-report', [OmfsApiController::class, 'GetSingleReportPdf']);
});
