<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>

    <style>
        @font-face {
            font-family: 'ProximaNova';
            src: url("{{ asset('user/assets/fonts/proxima-nova/ProximaNova-Regular.otf')}}");
        }

        .container-fluid {
            width: 100%;
            font-family: 'ProximaNova', sans-serif;
        }

        .col-3 {

            display: inline-block;
            width: 23.5%;
        }

        .col-5 {
            display: inline-block;
            vertical-align: top;
            width: 29.5%;
        }
        .col-6 {
            display: inline-block;
            vertical-align: top;
            width: 49.5%;
        }

        .col-7 {
            display: inline-block;
            vertical-align: top;
            width: 69.5%;
        }
        .field_border {
            border: 1px solid #dcdcdc;
            border-radius: 6px;
            padding: 10px 5px;
            font-size: 15px;
            color: #555;
        }

        .disabled {
            color: black;
            background-color: #f5f5f5;
            pointer-events: none;
            font-weight: bold;
        }

        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
            border: 1px solid #dee2e6;
            border-collapse: collapse;
        }

        .table th,
        .table td {
            padding: 10px;
            border-spacing: 0em;
            border: 1px solid #dee2e6;
        }

        .table tr:nth-child(even){
            background: #f5f5f5;
        }
        /* margins */
        .mr-1 {
            margin-right: 0.5rem;
        }

        .mt-2 {
            margin-top: 0.5rem;
        }
        .mr-2 { }
        .mb-3 {
            margin-bottom: 2.5rem;
        }
        .ml-2 {
            margin-left: 2.5rem;
        }
        .my-2 {
            margin-top: 0.5rem;
            margin-bottom: 0.5rem;
        }

        .pl-2 {
            padding-left: 1rem;
        }

        /* margins end */

        /* paddings */
        .pr-1 {
            padding-right: 0.5rem;
        }

        .pt-2 {
            padding-top: 0.5rem;
        }

        .py-2 {
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
        }

        .px-2 {
            padding-right: 0.5rem;
            padding-left: 0.5rem;
        }

        /* paddings end */


        /* fonts */
        .fs_13 {
            font-size: 13px;
        }
        .fs_16 {
            font-size: 16px;
        }
        .fs_18 {
            font-size: 18px;
        }
        .fs_20 {
            font-size: 20px;
        }
        .fs_25 {
            font-size: 25px;
        }

        /* fonts end */


        /* color and BG colors */
        .bg_green,

        .calc_container .btn-primary {
            background-color: #08ad79;
            background-color: #CAF5FF !important;
        }

        .color_green {
            color: #08ad79;
        }
        .text-white {
            color: #fff !important;
            color: #000 !important;
        }

        .page-break {
            page-break-after: always;
        }

        /* color and BG colors  end*/

        .page-number:before {
            content: "Page " counter(page) " of " counter(pages);
        }
    </style>
</head>

<body>
    <div class="container-fluid">
        <!-- row 1  -->
        <div class="mb-3">
            <div class="col-7">
                <h1 class="fs_20">California Explanation of Fee Schedule (EOFS)</h1>
            </div>
            <div class="col-5">
                <small style="margin-bottom: 0;">Powered By</small>
                <h2  style="margin-top: 0; color: #178199;" class="fs_16 color_green-">Medical Lien Management</h2>

            </div>
        </div>
        <div class="row mt-3 mb-1">
        <!-- California Explanation of Fee Schedule (EOFS) -->
            <div class="col-3 mr-1">
                <div class="fs_13">
                    <div><strong>DOS:</strong></div>
                    <div class="field_border disabled mt-2 pl-2">
                        {{ date('m/d/Y', strtotime($single_reports[0]['r_dos'])) }}
                    </div>
                </div>
            </div>
            <div class="col-3 mr-1">
                <div class="fs_13">
                    <div><strong>Place of Service Type:</strong></div>
                    <div class="field_border disabled mt-2 pl-2">
                        {{ $single_reports[0]['r_place_of_service_type'] }}
                    </div>
                </div>
            </div>
            <div class="col-3 mr-1">
                <div class="fs_13">
                    <div><strong>Provider Type:</strong></div>
                    <div class="field_border disabled mt-2 pl-2">{{ $single_reports[0]['r_provider_type'] }}
                    </div>
                </div>
            </div>

            @if ($single_reports[0]['zip'])
            <div class="col-3">
                <div class="fs_13">
                    <div><strong>Place of Service Zip:</strong></div>
                    <div class="field_border disabled mt-2 d-flex align-items-center justify-content-between pl-2">
                        {{ $single_reports[0]['zip'] }}
                    </div>
                </div>
            </div>
            @else
            <div class="col-3">
                <div class="fs_13">
                    <div><strong>Place of Service County:</strong></div>
                    <div class="field_border disabled mt-2 d-flex align-items-center justify-content-between">
                        {{ $single_reports[0]['locality_name'] }}
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- row 2 -->
        <div class="row mt-3 mb-3" id="section2">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                        <thead class="bg_green text-white">
                            <tr>
                                <th>Serial</th>
                                <th class="text-left px-2">Procedure Code</th>
                                <th>Units</th>
                                <th>Fee Schedule</th>
                                <th>Payment Total</th>
                                <th>Balance Due</th>
                                <th>% Expected</th>
                            </tr>
                        </thead>
                        <tbody class="">

                            @if (count($single_reports) > 0)
                            @php
                            $i = 0;
                            $sn = 0;
                            $total_omfs = 0;
                            $total_payment_total = 0;
                            $total_balance_due = 0;
                            $total_percentexpected = 0;
                            @endphp
                            @foreach ($single_reports as $single_report_key => $single_report)
                            <tr>
                                <td class="text-link">#{{ ++$sn }}</td>
                                <td class="text-uppercase text-left px-2">
                                    {{ $single_report['Procedure Code'] ?? $single_report['r_hcpcs']  }}
                                </td>
                                <td>{{ $single_report['Units'] }} </td>
                                <td>
                                    @if(is_numeric($single_report['Fee Schedule'])) ${{ number_format($single_report['Fee Schedule'], 2) }} @else {{ $single_report['Fee Schedule'] }} @endif
                                </td>
                                <td>${{ $single_report['Payment Total'] }}</td>
                                <td>${{ floatval(round($single_report['Balance Due'], 2)) }}</td>

                                @if ($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule']))
                                <?php
                                $percentage = 100 - (($single_report['Fee Schedule'] - $single_report['Payment Total']) / $single_report['Fee Schedule']) * 100;
                                $formatted_percentage = floatval(round(str_replace('%', '', round($percentage, 2))));
                                ?>
                                <td>{{ $formatted_percentage }}%</td>
                                @else
                                <td>N/A</td>
                                <!-- Or handle the case where Fee Schedule is zero -->
                                @endif
                            </tr>
                            @php
                            $total_payment_total += $single_report['Payment Total'];
                            $roundOffBalanceDue = floatval(
                            round($single_report['Balance Due'], 2),
                            );
                            $total_balance_due += $roundOffBalanceDue;
                            if ($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule'])) {
                            $total_omfs += $single_report['Fee Schedule'];

                            $roundOffPercentExpected = round(
                            100 -
                            (($single_report['Fee Schedule'] -
                            $single_report['Payment Total']) /
                            $single_report['Fee Schedule']) *
                            100,
                            );
                            } else {
                            $roundOffPercentExpected = 0;
                            }

                            $total_percentexpected += $roundOffPercentExpected;
                            @endphp
                            @endforeach
                            @endif
                            <tr>
                                <td></td>
                                <td></td>
                                <td><b>Total</b></td>
                                <td><b>${{ number_format($total_omfs, 2) }}</b></td>
                                <td><b>${{ number_format($total_payment_total, 2) }}</b></td>
                                <td><b>${{ number_format($total_balance_due, 2) }}</b></td>
                                <td><b>{{ $total_percentexpected }}%</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

        <div class="page-break"></div>


        <!-- row 3 -->

        <!-- row 4  -->

        <div class="accordion" id="accordionExample">

            @foreach ($single_reports as $key => $value)
            <h3>Procedure Code - Fee Schedule Calculations</h3>

            <div class="card">
                <div class="card-header btn" id="heading{{ $loop->iteration }}" data-toggle="collapse" data-target="#collapse{{ $loop->iteration }}" aria-expanded="true" aria-controls="collapse{{ $loop->iteration }}">
                    <h4 class="mb-0 "> #{{ $loop->iteration }} -
                        {{ ucfirst($value['Procedure Code'] ?? $single_report['r_hcpcs']) }}
                    </h4>
                </div>

                <div id="collapse{{ $loop->iteration }}" class="collapse @if ($loop->iteration === 1) show @endif" aria-labelledby="heading{{ $loop->iteration }}" data-parent="#accordionExample">
                    <div class="pdf-page-break">
                        <hr>

                        <div class="row">
                            <!-- col 1 -->
                            <div class="col-6 half-width">
                                <div class="table-responsive">
                                    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                        <thead>
                                            <tr>
                                                <th class="bg_green text-white " colspan="2">
                                                    Calculation Details</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td width="40%" class=" pt-3">
                                                    <b>Fee Schedule</b>
                                                </td>
                                                <td width="60%" class=" pt-3">
                                                    {{ $value['Fee Schedule Desc'] ?? null }}
                                                </td>
                                            </tr>

                                            <tr>
                                                <td width="40%">
                                                    <b>Description</b>
                                                </td>
                                                <td width="60%">
                                                    <p class="mb-0" style=" margin: 0; padding: 0;">
                                                        {{ $value['Description'] ?? null }}
                                                    </p>
                                                </td>
                                            </tr>
                                            @if (isset($value['Procedure']))
                                            <tr>
                                                <td width="40%">
                                                    <b>Procedure</b>
                                                </td>
                                                <td width="60%">
                                                    <p class="mb-0">
                                                        {{ $value['Procedure'] ?? null }}
                                                    </p>
                                                </td>
                                            </tr>
                                            @endif

                                            @if (isset($value['Effective Dates of Service']))
                                            <tr>
                                                <td>
                                                    <b>Effective Dates of Service</b>
                                                </td>
                                                <td>{{ $value['Effective Dates of Service'] }}</td>
                                            </tr>
                                            @endif

                                        </tbody>
                                    </table>
                                </div>

                              <div class="table-responsive">
    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
        @if (isset($value['Work RVU']))
            <thead>
                <tr class="bg_green text-white">
                    <th>Type</th>
                    <th>RVU</th>
                    <th>GPCI</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $total1 = $value['Work RVU'] * $value['Work GPCI'];

                    $total2 = 0;
                    if (
                        isset($single_reports[0]['r_place_of_service_type']) &&
                        $single_reports[0]['r_place_of_service_type'] == 'Facility'
                    ) {
                        $total2 = $value['Facility RVU'] * $value['Facility PE GPCI'];
                    } else {
                        $total2 = $value['Non Facility RVU'] * $value['Non Facility PE GPCI'];
                    }

                    $total3 = $value['MP RVU'] * $value['MP GPCI'];
                    $sumtotalcalc = $total1 + $total2 + $total3;
                @endphp

                <tr>
                    <td>Work</td>
                    <td>{{ $value['Work RVU'] }}</td>
                    <td>{{ $value['Work GPCI'] }}</td>
                    <td>{{ $total1 }}</td>
                </tr>

                <tr>
                    @if (isset($single_reports[0]['r_place_of_service_type']) && $single_reports[0]['r_place_of_service_type'] == 'Facility')
                        <td>Facility PE</td>
                        <td>{{ $value['Facility RVU'] }}</td>
                        <td>{{ $value['Facility PE GPCI'] }}</td>
                        <td>{{ $total2 }}</td>
                    @else
                        <td>Non-Facility PE</td>
                        <td>{{ $value['Non Facility RVU'] }}</td>
                        <td>{{ $value['Non Facility PE GPCI'] }}</td>
                        <td>{{ $total2 }}</td>
                    @endif
                </tr>

                <tr>
                    <td>MP</td>
                    <td>{{ $value['MP RVU'] }}</td>
                    <td>{{ $value['MP GPCI'] }}</td>
                    <td>{{ $total3 }}</td>
                </tr>

                <tr>
                    <td colspan="3">
                        <div class="right">Sum of Totals</div>
                    </td>
                    <td>{{ $sumtotalcalc }}</td>
                </tr>

                <tr>
                    <td colspan="3">
                        <div class="right">Conversion Factor - {{ $value['convofactor'] }}</div>
                    </td>
                    <td>${{ $value['Conversion Factor Value'] }}</td>
                </tr>

                @if (isset($value['locality_num']))
                    <tr>
                        <td colspan="4">
                            Locality: {{ $value['locality_num'] }} - {{ $value['locality_name'] }}
                        </td>
                    </tr>
                @endif

                <tr>
                    @php
                        $countyName = null;
                        if (preg_match('/\((.*?)\)/', $value['locality_name'], $matches)) {
                            $countyName = $matches[1];
                        }
                    @endphp
                    <td colspan="4">
                        Counties: {{ $countyName ?? $value['locality_name'] }}
                    </td>
                </tr>
            </tbody>
        @endif

        <tfoot>
            @if (isset($value['Calculation Explanation']))
                <tr>
                    <td colspan="3"><div class="fw_6">Calculation Explanation</div></td>
                    <td class="fw_6">{{ $value['Calculation Explanation'] ?? null }}</td>
                </tr>
            @endif

            <tr>
                <td colspan="3"><div class="fw_6">Base Maximum Fee</div></td>
                <td class="fw_6">${{ $value['Base Maximum Fee'] ?? 0 }}</td>
            </tr>
        </tfoot>
    </table>
</div>


                            </div>
                            <!-- col 2 -->
                            <div class="col-6 half-width">
                                <div class="table-responsive" style=" margin: 0; padding: 0;">
                                    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap" style=" margin-bottom: 15px; padding: 0;">
                                        <thead>
                                            <tr>
                                                <th class="bg_green text-white">Base Maximum Fee Exceptions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="pt-3">
                                                    @php
                                                    $showNone = true; // Flag to determine if "None" should be displayed
                                                    @endphp


                                                    @if (isset($value['MEU']) && $value['MEU'] == 1)
                                                    <p style="white-space: break-spaces; margin: 0; padding: 0;" class="mb-0">&#x2022; Medically Unlikely
                                                        Edit (MUE) Rules Applied.</p>
                                                    @php $showNone = false; @endphp
                                                    @endif

                                                    @if (isset($value['Prohibited Code']) && $value['Prohibited Code'] == 1)
                                                    <p style="white-space: break-spaces; margin: 0; padding: 0;" class="mb-0">&#x2022; Prohibited Code.
                                                    </p>
                                                    @php $showNone = false; @endphp
                                                    @endif

                                                    @if (isset($value['MPPR']) && $value['MPPR'] == 1)
                                                    <p style="white-space: break-spaces; margin: 0; padding: 0;" class="mb-0">&#x2022; Multiple Procedure
                                                        Payment Reduction (MPPR) Rules Applied.</p>
                                                    @php $showNone = false; @endphp
                                                    @endif
                                                    @if ($showNone)
                                                    <p style="white-space: break-spaces; margin: 0; padding: 0;" class="mb-0">None</p>
                                                    @endif


                                                </td>

                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="table-responsive" style=" margin: 0; padding: 0;">
                                    <table class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                        <thead>
                                            <tr>
                                                <th class="bg_green text-white">NCCI Edits</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                @if (isset($value['MEU']) && $value['MEU'] == 1)
                                                <td> DOS MUE Rules Applied – Rationale: 'Nature of
                                                    Service/Procedure' – Units of service allowed:
                                                    {{ $value['max_unit_allowed'] }} – Effective:
                                                    {{ $value['date_of_service'] ?? $value['Effective Dates of Service'] }}
                                                </td>
                                                @else
                                                <td>No NCCI edits for this procedure.</td>
                                                @endif
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                @if (isset($value['Status Code']))

                                <div class="table-responsive">
                                    <table class="table align-middle table-sm table-bordered- -text-center fs_13 text-nowrap">
                                        <thead>
                                            <tr>
                                                <th class="bg_green text-white" colspan="2">CMS RVU
                                                    Information</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="fw_6">Status Code</td>
                                                <td>
                                                    @if (isset($value['Status Code']))
                                                    {{ $value['Status Code'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">PC/TC Indicator</td>
                                                <td>
                                                    @if (isset($value['pctc_indicator']))
                                                    {{ $value['pctc_indicator'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Global Days</td>
                                                <td>
                                                    @if (isset($value['glob_days']))
                                                    {{ $value['glob_days'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Pre Op</td>
                                                <td>
                                                    @if (isset($value['pre_op']))
                                                    {{ number_format($value['pre_op'], 1, '.', ',') }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Intra Op</td>
                                                <td>
                                                    @if (isset($value['intra_op']))
                                                    {{ number_format($value['intra_op'], 1, '.', ',') }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Post Op</td>
                                                <td>
                                                    @if (isset($value['post_op']))
                                                    {{ number_format($value['post_op'], 1, '.', ',') }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Multiple Procedure</td>
                                                <td>
                                                    @if (isset($value['mult_proc']))
                                                    {{ $value['mult_proc'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Bilateral Surgery</td>
                                                <td>
                                                    @if (isset($value['bilat_surg']))
                                                    {{ $value['bilat_surg'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Assistant at Surgery</td>
                                                <td>
                                                    @if (isset($value['asst_surg']))
                                                    {{ $value['asst_surg'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Co-surgery</td>
                                                <td>
                                                    @if (isset($value['co_surg']))
                                                    {{ $value['co_surg'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Team Surgery</td>
                                                <td>
                                                    @if (isset($value['team_surg']))
                                                    {{ $value['team_surg'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Endoscopy Base</td>
                                                <td>
                                                    @if (isset($value['endo_base']))
                                                    {{ $value['endo_base'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Physician Supervision of Diagnostic
                                                    Procedures</td>
                                                <td>
                                                    @if (isset($value['diagnostic_proc']))
                                                    {{ $value['diagnostic_proc'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw_6">Diagnostic Imaging Family Indicator
                                                </td>
                                                <td>
                                                    @if (isset($value['diagnostic_family_ind']))
                                                    {{ $value['diagnostic_family_ind'] }}
                                                    @endif
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @if(!$loop->last)

            <div class="page-break"></div>
            @endif
            @endforeach
            <div class="footer">
        <script type="text/php">
            if (isset($pdf)) {
                $pdf->page_script('
                    $font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
                    $size = 12;
                    $pageText = "Page " . $PAGE_NUM . " of " . $PAGE_COUNT;
                    $y = 15;
                    $x = 520;
                    $pdf->text($x, $pdf->get_height() - 30, $pageText, $font, $size);
                ');
            }
        </script>
    </div>
        </div>

    </div>
</body>



</html>
