{{-- {{dd($single_reports[5]['selected_modifier'])}} --}}
{{-- {{dd($single_reports[0]['r_service_name'])}} --}}
{{-- {{dd($single_reports[0]['selected_modifier'])}} --}}

{{-- Modifiers Function --}}

<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/font-awesome.min.css') }}" />
    {{-- <link rel='stylesheet' href='{{asset("user/assets/css/bootstrap-select.min.css")}}' /> --}}
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap-datepicker3.min.css') }}" />
    <link rel='stylesheet' href="{{ asset('user/assets/css/bootstrap-table.min.css') }}">
    {{-- <link rel='stylesheet' href='assets/css/bootstrap-editable.css'> --}}
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />


    <style>
        .disabled {
            color: black;
            /* Text color for disabled look */
            background-color: #f5f5f5;
            /* Background color for disabled look */
            pointer-events: none;
            /* Disable pointer events to prevent interaction */
            font-weight: bold;
        }

        .was-validated .invalid-unit,
        .invalid-unit {
            border: 2px solid red !important;
            /* Change the border color to red for invalid units */
            background: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e") !important;
            background-repeat: no-repeat !important;
            background-position: right calc(.375em + .1875rem) center !important;
            background-size: calc(.75em + .375rem) calc(.75em + .375rem) !important;

        }
    </style>
</head>


<body class="bg_gray- bg-new-theme ff_omfs">
    <div class="header-home">
        <div class="row mx-0">

            <div class="col-lg-6 pl-lg-5 --ml-2 py-3">
                <div class="d-flex justify-content-around align-items-center logo-div">
                    <img src="{{ asset('user/assets/img/logo.svg') }}" alt="OMFS Calculator Logo" class="img-fluid"
                        height="38" />
                    <span class="separator mx-2 mx-md-0">|</span>
                    <h1 class="ProximaNova fs_18 text-white mb-0">Welcome to OMFS Calculator</h1>
                </div>
            </div>

            <div
                class="col-lg-6 d-flex justify-content-center justify-content-md-start justify-content-lg-end align-items-center text-white mb-3 mb-lg-0 pl-md-4 pl-lg-3">
                <div class="user-profile-icon">
                    <i class="fa fa-user" aria-hidden="true"></i>
                </div>
                <div class="fs_16 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> {{ \Auth::user()->email }}</div>
                <a href="{{ url('user/logout') }}" class="fw_5 btn btn-custom-2 text-white fs_16 ml-3">Logout</a>
            </div>
        </div>
    </div>
    <div class="row mx-0 calc_container">
        <div class="col-lg-3 px-0 bg-white mh-100 min-lg-vh-100">
            <div class="tab_head mt-3- mt-lg-5 pt-lg-3">
                <nav>
                    <?php $reportResult = strip_tags($single_reports[0]['r_service_name']); ?>

                    <div class="nav flex-lg-column nav-tabs nav-fill new-theme-tab" id="nav-tab" role="tablist">

                        <a class="nav-item nav-link text-left" href="{{ url('/') }}"
                            style="width: 100%; max-width: 100%; border-bottom: solid 1px; margin-bottom: 10px;">
                            <span class="nav-tab-icon home"></span>Calculator
                        </a>

                        <a class="nav-item nav-link text-left {{ trim($reportResult) == 'Physician Services' ? 'active' : '' }}"
                            id="physician-services-tab" data-toggle="tab" href="{{ route('physician.service') }}"
                            role="tab" aria-controls="physician-services" aria-selected="true">
                            <span class="nav-tab-icon"></span>Physician Services</a>

                        <a class="nav-item nav-link text-left active" id="e-service-tab" data-toggle="tab"
                            href="{{ route('pharmacy.service') }}" role="tab" aria-controls="e-service"
                            aria-selected="false">
                            <span class="nav-tab-icon"></span>Pharmacy</a>

                        <a class="nav-item nav-link text-left {{ trim($reportResult) == 'RFA Serving' ? 'active' : '' }}"
                            id="rfa-serving-tab" data-toggle="tab" href="#rfa-serving" role="tab"
                            aria-controls="rfa-serving" aria-selected="false">
                            <span class="nav-tab-icon"></span>RFA Serving</a>

                        <a class="nav-item nav-link text-left {{ trim($reportResult) == 'PR2 Service' ? 'active' : '' }}"
                            id="pr2-service-tab" data-toggle="tab" href="#pr2-service" role="tab"
                            aria-controls="pr2-service" aria-selected="false">
                            <span class="nav-tab-icon"></span>PR2 Service</a>

                        <a class="nav-item nav-link text-left {{ trim($reportResult) == 'Claim Admin Directory' ? 'active' : '' }}"
                            id="claim-admin-dir-tab" data-toggle="tab" href="#claim-admin-dir" role="tab"
                            aria-controls="claim-admin-dir" aria-selected="false">
                            <span class="nav-tab-icon"></span>Claim Admin Directory</a>

                    </div>
                </nav>
            </div>

        </div>
        <div class="col-lg-9 px-4 px-sm-5 calc_container">
            <div class="row my-3 rounded">
                <div class="col-lg-6 px-2">
                    <div class="d-flex">
                        <button type="button"
                            class="btn btn-custom-1 text-white mr-1 border-0 mb-1 rounded-100 w-auto"
                            data-toggle="modal" data-target="#physicianModal">
                            <i class="fa fa-pencil-square-o" aria-hidden="true"></i> Edit
                        </button>
                        {{-- Form for PDF SECTION --}}
                        <form action="{{ route('pharmacy.report-pdf') }}" id="pdfform" method="post"
                            target="_blank">
                            @csrf
                            <input type="hidden" value="{{ $single_reports[0]['r_service_name'] }}"
                                name="service_name">
                            <input type="hidden" value="{{ $single_reports[0]['r_dos'] }}" name="dos" />
                            <input type="hidden" value="{{ $single_reports[0]['r_product_type'] }}"
                                name="product_type" />

                            @if (count($single_reports) > 0)
                                @foreach ($single_reports as $single_report_key => $single_report)
                                    <input type="hidden"
                                        value="{{ trim(explode(':', $single_report['NDC Number'])[0]) ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][cptcode]">
                                    <input type="hidden" value="{{ $single_report['Units'] ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][units]">
                                    <input type="hidden" value="{{ $single_report['Payment Total'] ?? null }}"
                                        name="singleReport[{{ $single_report_key }}][payment_total]" />
                                @endforeach
                            @endif
                            <button type="submit" id="pdfbtn"
                                class="btn btn-custom-2 fs_16 ml-1 border-0 mb-1 text-white rounded-100">
                                <i class="fa fa-file-pdf-o" aria-hidden="true"></i><span id="pdfspan">
                                    Print PDF</span>
                            </button>
                            <!-- <button class="btn btn-primary fs_13 py-1 px-4 mr-1 border-0 mb-1  rounded-100"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Download PDF</button> -->
                        </form>
                    </div>
                </div>
                <div class="col-lg-6 pl-lg-5 text-lg-right py-3">
                    @if ($single_reports[0]['Effective Dates of Service'])
                        <span class="pr-2 d-block d-sm-inline">Effective DOS: </span>
                        {{ $single_reports[0]['Effective Dates of Service'] }}
                    @endif
                </div>
            </div>

            <div class="bg-white-- ">
                <div class="row px-2 py-2 rounded">
                    <div class="col-12 bg-white">
                        <div class="row mt-3 mb-3 " id="section1">

                            <div class="col-6 col-sm-6 col-md-3 mb-2">
                                <div class="fs_13">
                                    <div><strong>Date of Service:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        {{ date('m/d/Y', strtotime($single_reports[0]['r_dos'])) }}</div>
                                </div>
                            </div>

                            <div class="col-6 col-sm-6 col-md-3 mb-2 ">
                                <div class="fs_13">
                                    <div><strong>Product Type:</strong></div>
                                    <div class="field_border disabled px-4 pill-shap mt-3">
                                        {{ $single_reports[0]['r_product_type'] }}
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row mt-3 mb-3- rounded" id="section2">
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <table
                                        class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                        <thead class="pill-shap table_header text-white">
                                            <tr>
                                                <th>Serial</th>
                                                <th class="px-2">NDC Number</th>
                                                <th>Units</th>
                                                <th>Fee Schedule</th>
                                                <th>Payment Total</th>
                                                <th>Balance Due</th>
                                                <th>Fee Schedule %</th>
                                            </tr>
                                        </thead>
                                        <tbody class="pill-shap table_body with-total">

                                            @if (count($single_reports) > 0)
                                                @php
                                                    $i = 0;
                                                    $sn = 0;
                                                    $total_omfs = 0;
                                                    $total_payment_total = 0;
                                                    $total_balance_due = 0;
                                                    $total_percentexpected = 0;
                                                @endphp
                                                @foreach ($single_reports as $single_report_key => $single_report)
                                                    <tr>
                                                        <td class="text-link"><a
                                                                href="#collapse{{ $loop->iteration }}"
                                                                data-toggle="collapse" aria-expanded="true"
                                                                aria-controls="collapse{{ $loop->iteration }}">#{{ ++$sn }}</a>
                                                        </td>
                                                        <td class="text-uppercase  px-2">
                                                            {{ $single_report['NDC Number'] }}

                                                        </td>
                                                        <td>{{ $single_report['Units'] }} </td>
                                                        <td>
                                                            @if (is_numeric($single_report['Fee Schedule']))
                                                                ${{ number_format($single_report['Fee Schedule'], 2) }}
                                                            @else
                                                                {{ $single_report['Fee Schedule'] }}
                                                            @endif
                                                        </td>
                                                        <td>${{ $single_report['Payment Total'] }}</td>
                                                        <td>${{ floatval(round($single_report['Balance Due'], 2)) }}
                                                        </td>

                                                        @if ($single_report['Fee Schedule'] != 0 && is_numeric($single_report['Fee Schedule']))
                                                            <td>{{ $single_report['Fee Schedule %'] }}</td>
                                                        @else
                                                            <td>N/A</td>
                                                            <!-- Or handle the case where Fee Schedule is zero -->
                                                        @endif
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                                        <td colspan="2"></td>
                                                        <td>
                                                            <h6><span class="badge bg-secondary text-white">Dispensing
                                                                    Fee :
                                                                    ${{ $single_report['Dispensing Fee'] }}</span></h6>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>

                                                    </tr>
                                                    @php
                                                        $total_payment_total += $single_report['Total Payment Total'];
                                                        $roundOffBalanceDue = floatval(
                                                            round($single_report['Total Balance Due'], 2),
                                                        );
                                                        $total_balance_due += $roundOffBalanceDue;
                                                        if (
                                                            $single_report['Fee Schedule'] != 0 &&
                                                            is_numeric($single_report['Fee Schedule'])
                                                        ) {
                                                            $total_omfs += $single_report['Total Fee Schedule'];

                                                            $roundOffPercentExpected = str_replace(
                                                                '%',
                                                                '',
                                                                $single_report['Total Fee Schedule %'],
                                                            );
                                                        } else {
                                                            $roundOffPercentExpected = 0;
                                                        }
                                                        $total_percentexpected += $roundOffPercentExpected;
                                                    @endphp
                                                @endforeach
                                            @endif
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td><b>Total</b></td>
                                                <td><b>${{ number_format($total_omfs, 2) }}</b></td>
                                                <td><b>${{ number_format($total_payment_total, 2) }}</b></td>
                                                <td><b>${{ number_format($total_balance_due, 2) }}</b></td>
                                                <td><b>{{ $total_percentexpected }}%</b></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- <h3 class="ProximaNova fw_5 fs_20 text-dark mb-3 mt-4">NDC Number - Fee Schedule Calculations</h3> --}}
            <div class="accordion" id="accordionExample">

                @foreach ($single_reports as $key => $value)
                    <div class="card bg-transparent border-0">
                        <div class="card-header- ">
                            <h4 class="mb-0 card-heading mt-3 mb-2">Procedure Code - Fee Schedule Calculations
                                <span id="heading{{ $loop->iteration }}" class="btn" data-toggle="collapse"
                                    data-target="#collapse{{ $loop->iteration }}" aria-expanded="true"
                                    aria-controls="collapse{{ $loop->iteration }}">
                                    #{{ $loop->iteration }} - {{ ucfirst($value['NDC Number']) }}
                                </span>

                            </h4>
                        </div>

                        <div id="collapse{{ $loop->iteration }}"
                            class="collapse bg-white p-4 @if ($loop->iteration === 1) show @endif"
                            aria-labelledby="heading{{ $loop->iteration }}" data-parent="#accordionExample">
                            <div class="pdf-page-break">
                                <div class="row">
                                    <!-- col 1 -->
                                    <div class="col-md-6 half-width">
                                        <div class="table-responsive">
                                            <table style="text-wrap: balance !important;"
                                                class="table align-middle table-sm table-bordered text-center fs_13 text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="pill-shap table_header-2" colspan="2">
                                                            Base Maximum Fee Calculation</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="pill-shap table_body no_gap_before with-border">
                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Fee Schedule</b>
                                                        </td>
                                                        <td width="50%" class=" pt-3">
                                                            {{-- {{ $value['Fee Schedule Desc'] ?? null }} --}}
                                                            {!! $value['fee schedule title'] ?? null !!}
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td width="50%" class="text-dark">
                                                            <b>Description</b>
                                                        </td>
                                                        <td width="50%">
                                                            <p class="mb-0">
                                                                {{ $value['Description'] ?? null }}</p>
                                                        </td>
                                                    </tr>


                                                    @if (isset($value['Effective Dates of Service']))
                                                        <tr>
                                                            <td class="text-dark">
                                                                <b>Effective Dates of Service</b>
                                                            </td>
                                                            <td>{{ $value['Effective Dates of Service'] }}</td>
                                                        </tr>
                                                    @endif

                                                </tbody>
                                            </table>
                                        </div>


                                    </div>
                                    <!-- col 2 -->

                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>


        </div>
    </div>

    <!-- Modal -->
    <div class="modal" id="physicianModal" style=" background: rgb(25 130 154 / 55%);" role="dialog"
        aria-labelledby="physicianModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <form id="calc_form" action="{{ route('pharmacy.single-report') }}" method="post">
                    @csrf
                    <div class="modal-header pt-0">
                        <h5 class="modal-title" id="physicianModalLabel">Edit
                            {!! $single_reports[0]['r_service_name'] !!}
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row mt-2">
                            <div class="col-sm-12">
                                <div>
                                    <input type="hidden" class="" id="service_name" name="service_name"
                                        placeholder="Select Service"
                                        value="{{ $single_reports[0]['r_service_name'] }}" />
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <div class="form_label col-6 col-lg-6 col-xl-6 mb-5">
                                            <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy) </span><span
                                                    class="text-red fs_12">*</span></label>
                                            <div class="datepicker date input-group datepicker-new-theme">
                                                <div class="input-group-append ml-0"> <span
                                                        class="input-group-text pl-3"><i
                                                            class="fa fa-calendar"></i></span> </div>
                                                <input type="text" placeholder="MM/DD/YYYY"
                                                    class="dos_input form-control" id="dos" name="dos"
                                                    pattern="\d{2}/\d{2}/\d{4}" min="01-01-2000"
                                                    value="{{ date('m/d/Y', strtotime($single_reports[0]['r_dos'])) }}"
                                                    required="" />
                                                {{-- <div class="input-group-append"> <span class="input-group-text"><i class="fa fa-calendar"></i></span> </div> --}}
                                                <div class="invalid-feedback datpicker-feedback">Select date of service
                                                </div>
                                            </div>
                                        </div>



                                        <div class="form_label col-6 col-lg-6 col-xl-6 mb-5">
                                            <label>Product Type</label>
                                            <div class="mt-3">
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="compound"
                                                        name="product_type" value="compound" required disabled
                                                        {{ $single_reports[0]['r_product_type'] == 'compound' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="compound">Compound</label>
                                                </div>
                                                <div
                                                    class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                    <input type="radio" class="custom-control-input" id="dispensed"
                                                        name="product_type" value="dispensed" required
                                                        {{ $single_reports[0]['r_product_type'] == 'dispensed' ? 'checked' : '' }}>
                                                    <label class="form-check-label custom-control-label fw_4"
                                                        for="dispensed">Dispensed</label>
                                                </div>

                                                <div class="invalid-feedback">Select Product type</div>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12 modal-header">
                                <div class=" modal-title mb-4 mt-0">Procedure Codes</div>
                            </div>
                        </div>

                        <div class="row mobile-hidden">
                            <div class="col-6 col-sm-4 col-md-4">
                                <div class="form_label">
                                    <label>NDC Number <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>

                            <div class="col-6 col-sm-4 col-md-4">
                                <div class="form_label">
                                    <label>Units <span class="text-red fs_12">*</span></label>
                                </div>
                            </div>
                            <div class="col-6 col-sm-4 col-md-4">
                                <div class="form_label">
                                    <label>Payment Total <span class="text-red fs_12"></span></label>
                                </div>
                            </div>
                        </div>

                        <div class="field_wrapper">

                            @if (count($single_reports) > 0)
                                @foreach ($single_reports as $single_report_key => $single_report)
                                    <div class="row select-container">
                                        <div class="col-6 col-sm-4 col-md-4">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">NDC Number <span
                                                        class="text-red fs_12">*</span></label>
                                                <div class="input-parent input-parent-cpt">
                                                    <input type="text"
                                                        class="form-control inc cptcode text-uppercase form-input"
                                                        name="singleReport[{{ $single_report_key }}][cptcode]"
                                                        placeholder="NDC Number"
                                                        value="{{ $single_report['NDC Number'] }}" maxLength="13"
                                                        required />
                                                </div>
                                                <div class="invalid-feedback code-feedback">Fill NDC Number</div>
                                            </div>
                                        </div>

                                        <div class="col-6 col-sm-4 col-md-4">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <div class="input-parent input-parent-unit">
                                                    <input type="text" class="form-control units form-input"
                                                        name="singleReport[{{ $single_report_key }}][units]"
                                                        placeholder="Enter Unit number" min="1"
                                                        value="{{ $single_report['Units'] }}" maxLength="3"
                                                        required />
                                                </div>
                                                <div class="invalid-feedback unit-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-4 col-md-4">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <div class="input-parent input-parent-charges">
                                                        <input type="text" class="form-control charges form-input"
                                                            name="singleReport[{{ $single_report_key }}][payment_total]"
                                                            placeholder="0.00"
                                                            value="{{ $single_report['Payment Total'] }}"
                                                            maxLength="10" />
                                                    </div>
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                            @endif

                        </div>



                        <div class="row mb-3">
                            <div class="col-12 col-lg-5">
                                <div class="text-right d-flex">

                                    <button type="submit"
                                        class="btn border-0 btn-custom-1 w-auto fs_15 text-white rounded-100"
                                        id="submitButton">Calculate</button>
                                </div>
                            </div>
                        </div>




                    </div>

                </form>
            </div>
        </div>
    </div>
    {{-- modal data --}}
    <script>
        window.baseUrl = "{{ url('/') }}";
    </script>

    {{-- <script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script> --}}
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>
    {{-- <script src='{{ asset('user/assets/js/bootstrap-select.min.js') }}'></script> --}}
    <script src="{{ asset('user/assets/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table.js') }}"></script>
    {{-- <script src="{{ asset('user/assets/js/bootstrap-table-editable.js') }}"></script> --}}
    <script src="{{ asset('user/assets/js/bootstrap-table-export.js') }}"></script>
    <script src="{{ asset('user/assets/js/tableExport.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-filter-control.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="{{ asset('user/assets/js/dynamic_cpt_row_pharmacy_edit.js') }}"></script>
    <script src="{{ asset('user/assets/js/custompharmacy.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>


    @if (\Session::has('message'))
        <script>
            // Display SweetAlert error message using the message from the session
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "{!! \Session::get('message') !!}"
            });
        </script>
    @endif

    <script>
        $(document).ready(function() {


            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {

                var tabId = $(e.target).html(); // Get activated tab's ID
                $("#service_name").val(tabId);
                $('form')[0].reset();

                var href = $(e.target).attr('href');
                if (href && href.startsWith('http')) {
                    window.location.href = href; // Redirect to the URL
                }
            });


        });


        $('#calc_form').submit(function(event) {
            event.preventDefault(); // Prevent default form submission
            isValid = true;
            $('.units').each(function() {
                let unitInput = $(this);
                let unitValue = parseInt(unitInput.val());
                if (unitValue < 1) {
                    isValid = false;
                    unitInput.val('')
                } else {
                    unitInput.removeClass('invalid-unit');
                }
            });

            if (isValid) {
                $("#submitButton").prop('disabled', true);
                $("#submitButton").html('Calculating...');
                var formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('pharmacy.edit-report') }}", // Form action URL
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Calculation Error',
                                text: response.error
                            });
                            $("#submitButton").prop('disabled', false);
                            $("#submitButton").html('Calculate');
                        } else {
                            $('#calc_form')[0].submit();
                        }



                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: "Something Went Wrong!"
                        });
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid Unit!',
                    text: 'Please enter a unit value that is at least 1.'
                });
            }
        });


        $('#pdfform').submit(function(event) {
            event.preventDefault(); // Prevent default form submission


            $("#pdfbtn").prop('disabled', true);
            $("#pdfspan").html(' Processing...');
            var formData = $(this).serialize();
            $.ajax({
                url: "{{ route('pharmacy.edit-report') }}", // Form action URL
                method: 'POST',
                data: formData,
                success: function(response) {
                    if (response.error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'PDF Error',
                            text: response.error
                        });
                        $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                    } else {
                        $("#pdfbtn").prop('disabled', false);
                        $("#pdfspan").html(' Print PDF');
                        $('#pdfform')[0].submit();
                    }



                },
                error: function(xhr, status, error) {
                    $("#pdfbtn").prop('disabled', false);
                    $("#pdfspan").html(' Print PDF');
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: "Something Went Wrong!"
                    });
                }
            });


        });
    </script>



</body>

</html>
