<!DOCTYPE html>
<html lang="en">

<head>
    @include('layouts.head')
    <title>User Information | Medical Lien Management</title>
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />

</head>

<body>
    <main class="d-flex flex-column w-100 h-100">
         {{-- new ui starts here --}}
        <div class="container-fluid h-100 pb-5 bg-new-theme position-relative overflow-hidden" style="background-color: #effcff; ">
            <div class="header mt-5 mb-4 pb-5- ps-5">
                <img src="{{ asset('user/assets/img/logo_3.svg') }}" alt="OMFS Calculator Logo"
                class="img-fluid logo_size" height="150" />
            </div>
            {{-- body --}}
            <div class="row">
                <div class="col-lg-4 text-center overflow-hidden d-none d-lg-flex justify-content-end position-relative">
                    <img src="{{ asset('user/assets/img/login_banner_left.svg') }}" alt="Banner"
                    class="img-fluid" style="position: absolute; bottom: 2vh; left: 51px; max-width: 45vw; min-width: 550px;" />
                </div>
                <div class="col-lg-4 px-0 app_box_container_login">
                    <div class="card app_box_container mb-0">
                        <div class="card-body">
                            <div class="m-sm-4">
                                <div class="row">
                                    <div class="col-xl-7- col-12 text-start">
                                        <h1 class="ProximaNova fs_30 text_dark_black">Welcome to 
                                            <img src="{{ asset('user/assets/img/logo_2.svg') }}" alt="OMFS Calculator Logo" class="img-fluid mx-height-40" height="150" /> 
                                        Calculator</h1>
                                    </div>
                                    <div class="col-12 mb-1">
                                        <p class="ProximaNova fs_18 text_dark_black mb-4">Please login or sign up to continue</p>
                                    </div>
                                </div>

                                <form action="{{ url('user/login-form') }}" method="POST">
                                    @csrf
                                    <div class="mb-4 input-parent input-parent-email">
                                        {{-- <label class="form-label">Email</label> --}}
                                        <input class="form-control form-control-lg form-input" type="email" name="email"
                                            placeholder="your email" />
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 input-parent input-parent-password">
                                        {{-- <label class="form-label">Password</label> --}}
                                        <input class="form-control form-control-lg form-input" type="password" name="password"
                                            placeholder="your password" />
                                        @error('password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="d-flex align-items-center justify-content-start my-5">
                                        <label class="form-check">
                                            <input class="form-check-input" type="checkbox" value="remember-me"
                                                name="remember-me" checked>
                                            <span class="form-check-label">
                                                Remember me next time
                                            </span>
                                        </label>
                                    </div>
                                    <div class="text-center mt-2">
                                        <button type="submit" class="btn btn-custom-1 fs_18 border-0 text-white rounded-100">Login</button>
                                    </div>
                                </form>
                                {{-- <div class="text-center mb-3">
                                <div class="titleSidesLine mt-4 mb-2">OR</div>
                                <p class="text-center fs_15">Don't have an account?</p>
                                <a href="{{url("user/register")}}" class="btn btn-outline-primary fs_15 py-2 px-5 w-50  rounded-100">Register</a>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-none col-lg-4 text-end d-lg-flex justify-content-end align-items-end">
                    <img src="{{ asset('user/assets/img/login_banner_right.svg') }}" alt="Banner"
                    class="img-fluid" style="max-width: 420px; width:100%;" />
                </div>
            </div>
        </div>
        {{-- new ui ends here --}}
        {{-- <div class="container d-flex flex-column">
            <div class="row vh-100">
                <div class="col-sm-10 col-md-8 col-lg-6 mx-auto d-table h-100">
                    <div class="d-table-cell align-middle">
                        @if (session()->has('message'))
                            <div class="alert alert-danger">
                                {{ session()->get('message') }}
                            </div>
                        @endif
<div class="row mt-3">
<div class="col-sm-12">
<div class="text-center fs_16 text_dark_black ff_omfs fw_4">Welcome to</div>
<div class="text-center fs_30 text_dark_black ff_omfs fw_5">OMFS Calculator</div>
<div class="title_underline bg_gradient ms-auto me-auto mt-2"></div>
<div class="text-center fs_16 text_green ff_omfs mt-2 mb-4">Medical Lien Management</div>
</div>
</div>
                        <div class="card app_box_container">
                            <div class="card-body">
                                <div class="m-sm-4">
                                    <div class="text-center">
                                        <img src="{{ asset('user/assets/images/app-logo.png') }}" alt="OMFS Calculator"
                                            class="img-fluid" width="109" height="70" />
                                    </div>
                                    <form action="{{ url('user/login-form') }}" method="POST">
                                        @csrf
                                        <div class="mb-3">
                                            <label class="form-label">Email</label>
                                            <input class="form-control form-control-lg" type="email" name="email"
                                                placeholder="Enter your email" />
                                            @error('email')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Password</label>
                                            <input class="form-control form-control-lg" type="password" name="password"
                                                placeholder="Enter your password" />
                                            @error('password')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="d-flex align-items-center justify-content-center">
                                            <label class="form-check">
                                                <input class="form-check-input" type="checkbox" value="remember-me"
                                                    name="remember-me" checked>
                                                <span class="form-check-label">
                                                    Remember me next time
                                                </span>
                                            </label>
                                        </div>
                                        <div class="text-center mt-2">
                                            <button type="submit" class="btn bg_green fs_15 py-2 px-5 border-0 text-white w-50  rounded-100 themeBtn1">Login</button>
                                        </div>
                                    </form>
<div class="text-center mb-3">
<div class="titleSidesLine mt-4 mb-2">OR</div>
<p class="text-center fs_15">Don't have an account?</p>
<a href="{{url("user/register")}}" class="btn btn-outline-primary fs_15 py-2 px-5 w-50  rounded-100">Register</a>
</div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div> --}}
    </main>

    <script src="js/app.js"></script>

</body>

</html>
