<?php
return [
    "DROP FUNCTION if exists `omfs_calc_new`;",
    "CREATE  FUNCTION `omfs_calc_new`(p_email VARCHAR(255), p_service_name VARCHAR(255), p_date_of_service DATE, p_place_of_service_type VARCHAR(255), p_provider_type VARCHAR(255), p_conversion_factor_name VARCHAR(255), p_locality_name VARCHAR(255), p_hcpcs VARCHAR(255), p_modifier VARCHAR(255), p_units INT, p_payment_total DECIMAL(10,2)) RETURNS decimal(10,2)
DETERMINISTIC
BEGIN
--   DECLARE result INT;
-- 	DECLARE v_omfs DECIMAL(10,2);
DECLARE v_modifier VARCHAR(10) DEFAULT NULL;
DECLARE v_hcpcs VARCHAR(10) DEFAULT NULL;
DECLARE v_check INT DEFAULT 0;
DECLARE v_anes_cpt VARCHAR(10) DEFAULT NULL;
DECLARE v_conv_factor DECIMAL(10,4) DEFAULT 1;
DECLARE v_work_rvu DECIMAL(10,4) DEFAULT 1;
DECLARE v_mp_rvu DECIMAL(10,4) DEFAULT 1;
DECLARE v_facility_pe_rvu DECIMAL(10,4) DEFAULT 1;
DECLARE v_non_fac_pe_rvu DECIMAL(10,4) DEFAULT 1;
DECLARE v_statewide_work_gaf DECIMAL(10,4) DEFAULT 1;
DECLARE v_statewide_pe_gaf DECIMAL(10,4) DEFAULT 1;
DECLARE v_statewide_mp_gaf DECIMAL(10,4) DEFAULT 1;
DECLARE v_wgpci DECIMAL(10,4) DEFAULT 1;
DECLARE v_pegpci DECIMAL(10,4) DEFAULT 1;
DECLARE v_mpgpci DECIMAL(10,4) DEFAULT 1;
DECLARE v_dos DATE DEFAULT NULL;
DECLARE v_doe DATE DEFAULT NULL;
DECLARE v_omfs DECIMAL(10,2) DEFAULT 1;
DECLARE v_where_in_code VARCHAR(100) DEFAULT NULL;
DECLARE v_rec VARCHAR(100) DEFAULT NULL;
--
-- 	SET p_email VARCHAR(255);
SET p_service_name = IFNULL(p_service_name, NULL);
--  SET p_date_of_service DATE;
SET p_place_of_service_type = IFNULL(p_place_of_service_type, NULL);
SET p_provider_type = IFNULL(p_provider_type, 'Physician');
SET p_conversion_factor_name = IFNULL(p_conversion_factor_name, NULL);
SET p_locality_name = IFNULL(p_locality_name, NULL);
SET p_hcpcs = IFNULL(p_hcpcs, NULL);
SET p_modifier = IFNULL(p_modifier, NULL);
SET p_units = IFNULL(p_units, 1);
SET p_payment_total = IFNULL(p_payment_total, 1);

--  Alternate DEFAULT NULL PARAMETER Example
--  SET p_modifier = IFNULL(p_modifier, 34);

-- Check if the input email is valid by checking if it exists in the `users` table
SELECT COUNT(*) INTO @count FROM users WHERE email = p_email;
IF @count = 0 THEN
RETURN NULL;
END IF;

IF p_hcpcs IS NOT NULL THEN
SELECT expected_value INTO v_omfs FROM california_based_entries cbe WHERE DATE(p_date_of_service) BETWEEN cbe.dos AND cbe.doe AND cbe.cpt_code = p_hcpcs LIMIT 1;
END IF;

SELECT work_rvu, mp_rvu, facility_pe_rvu, non_fac_pe_rvu, anes_cpt INTO v_work_rvu, v_mp_rvu, v_facility_pe_rvu, v_non_fac_pe_rvu, v_anes_cpt FROM omfs_all oa
WHERE oa.hcpcs = p_hcpcs AND oa.mod = p_modifier AND DATE(p_date_of_service) BETWEEN oa.dos AND oa.doe LIMIT 1;

IF v_anes_cpt = 'Anesthesia' THEN
IF DATE(p_date_of_service) >= '2017-03-01' THEN
    SELECT conversion_factor_value INTO v_conv_factor
    FROM conversion_factors_2014_2022 cf
    WHERE cf.conversion_factor_name = v_anes_cpt AND DATE(p_date_of_service) BETWEEN cf.dos AND cf.doe
    LIMIT 1;
END IF;
END IF;

IF DATE(p_date_of_service) >= '2017-03-01' THEN
IF v_anes_cpt != 'Anesthesia' THEN
    SELECT conversion_factor_value INTO v_conv_factor
    FROM conversion_factors_2014_2022 cf
    WHERE cf.conversion_factor_name = 'Other Services' AND DATE(p_date_of_service) BETWEEN cf.dos AND cf.doe
    LIMIT 1;
END IF;
END IF;

IF v_work_rvu IS NULL THEN
SET v_work_rvu = 1;
END IF;

IF v_mp_rvu IS NULL THEN
SET v_mp_rvu = 1;
END IF;

IF v_facility_pe_rvu IS NULL THEN
SET v_facility_pe_rvu = 1;
END IF;

IF v_non_fac_pe_rvu IS NULL THEN
SET v_non_fac_pe_rvu = 1;
END IF;

IF p_locality_name IS NOT NULL THEN
SELECT wgpci, pegpci, mpgpci INTO v_wgpci, v_pegpci, v_mpgpci FROM localitylist_2019_2022 ll WHERE ll.localityname = p_locality_name AND DATE(p_date_of_service) BETWEEN ll.dos AND ll.doe LIMIT 1;
ELSE
SELECT wgpci, pegpci, mpgpci INTO v_wgpci, v_pegpci, v_mpgpci FROM localitylist_2019_2022 ll WHERE DATE(p_date_of_service) BETWEEN ll.dos AND ll.doe LIMIT 1;
END IF;

IF v_wgpci IS NULL THEN
SET v_wgpci = 1;
END IF;

IF v_pegpci IS NULL THEN
SET v_pegpci = 1;
END IF;

IF v_mpgpci IS NULL THEN
SET v_mpgpci = 1;
END IF;

SELECT work_rvu_gaf INTO v_statewide_work_gaf FROM gaf_data gd WHERE DATE(p_date_of_service) BETWEEN gd.dos AND gd.doe AND gd.work_rvu_gaf = 'WORK_RVU_GAF' LIMIT 1;

SELECT pe_rvu_gaf INTO v_statewide_pe_gaf FROM gaf_data gd WHERE DATE(p_date_of_service) BETWEEN gd.dos AND gd.doe AND gd.pe_rvu_gaf = 'PE_RVU_GAF' LIMIT 1;

SELECT mp_rvu_gaf INTO v_statewide_mp_gaf FROM gaf_data gd WHERE DATE(p_date_of_service) BETWEEN gd.dos AND gd.doe AND gd.mp_rvu_gaf = 'MP_RVU_GAF' LIMIT 1;

IF v_statewide_work_gaf IS NULL THEN
SET v_statewide_work_gaf = 1;
END IF;

IF v_statewide_pe_gaf IS NULL THEN
SET v_statewide_pe_gaf = 1;
END IF;

IF v_statewide_mp_gaf IS NULL THEN
SET v_statewide_mp_gaf = 1;
END IF;

-- if v_conv_factor is null then
-- if p_conversion_factor_name is not null and LENGTH(p_conversion_factor_name) > 0 then
SELECT cf.conversion_factor_value INTO v_conv_factor FROM conversion_factors_2014_2022 cf WHERE cf.conversion_factor_name = p_conversion_factor_name AND DATE(p_date_of_service) BETWEEN cf.dos AND 	cf.doe LIMIT 1;
    -- 	SELECT '----IN THE CONDITION v_conv_factor ====: ' || v_conv_factor;
-- end if;

IF v_conv_factor IS NULL THEN
SELECT cbe.expected_value INTO v_conv_factor
FROM california_based_entries cbe
WHERE DATE(p_date_of_service) BETWEEN cbe.dos AND cbe.doe AND cbe.cpt_code = p_hcpcs LIMIT 1;

--     SELECT 'IN THE CONDITION v_conv_factor: ' || v_conv_factor;
END IF;

IF v_conv_factor IS NULL THEN
SET v_conv_factor = 1;
END IF;

IF v_check >= 1 THEN
IF p_service_name = 'Physician Services' THEN
    -- For Facility
    IF p_place_of_service_type = 'Facility' THEN
        IF DATE(p_date_of_service) < '2019-01-01' THEN
            -- Formula No 1
            SET v_where_in_code = CONCAT('First Formula ', 'Formula No 1');
            SET v_omfs = ((v_work_rvu * v_statewide_work_gaf) + (v_facility_pe_rvu * v_statewide_pe_gaf) + (v_mp_rvu * v_statewide_mp_gaf)) * v_conv_factor;
        ELSEIF DATE(p_date_of_service) >= '2019-01-01' THEN
            -- Formula No 2
            SET v_where_in_code = CONCAT(' ', 'Formula No 2');
            SET v_omfs = ((v_work_rvu * v_wgpci) + (v_facility_pe_rvu * v_pegpci) + (v_mp_rvu * v_mpgpci)) * v_conv_factor;
        END IF;
    END IF;
END IF;
END IF;

IF p_place_of_service_type = 'Non-Facility' THEN
IF p_date_of_service < '2019-01-01' THEN
    -- Formula No 3
    SET v_where_in_code = CONCAT(' ', 'Formula No 3');

    SET v_omfs =  ((v_work_rvu * v_statewide_work_gaf) +
        (v_non_fac_pe_rvu * v_statewide_pe_gaf) +
        (v_mp_rvu * v_statewide_mp_gaf)) * v_conv_factor;
ELSEIF p_date_of_service > '2019-01-19' THEN
    -- Formula No 4
    SET v_where_in_code = CONCAT(' ', 'Formula No 4');

    SET v_omfs = ((v_work_rvu * v_wgpci) + (v_non_fac_pe_rvu * v_pegpci) +
                (v_mp_rvu * v_mpgpci)) * v_conv_factor;
END IF;
END IF;

-- Return the result
RETURN v_omfs;
END"

];
