<?php

namespace App\Http\Controllers;

use App\Exports\PharmacyBulkExport;
use App\Imports\PharmacyBulk;
use App\Jobs\PharmacyBulkPdf;
use App\Models\BulkPharmacyRequest;
use App\Models\BulkPharmacyResponse;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use PDOException;

class PharmacyController extends Controller
{

    function index()
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }

        return view("services.pharmacy.home");
    }



    public static function single_report_load_query($request, $api = false)
    {
        $p_Service_Name = $request->service_name;
        $p_Data_of_Service = date('Y-m-d', strtotime($request->dos));
        $p_product_type = $request->product_type;
        $iscascading = $request->is_cascade ?? true;



        $data = [];
        $count = 0;
        if (count($request->singleReport) > 1 && $iscascading) {
            $bulk_id = now();
            $cascadeupload = null;
            foreach ($request->singleReport as $key => $value) {

                try {
                    DB::beginTransaction();

                    $cleanCptCode = preg_replace('/-/', '', $value['cptcode']);

                    $cascadeupload = BulkPharmacyRequest::create([
                        'bulk_id' => $bulk_id,
                        'product_type' => "d",
                        'date_of_service' => $p_Data_of_Service,
                        'ndc_number' => $cleanCptCode,
                        'units' => $value['units'],
                        'payment_total' => $value['payment_total'],
                        "created_on" => now()
                    ]);
                } catch (QueryException $e) {
                    return ['error' => $e->getMessage()];
                }
            }

            if ($cascadeupload) {
                try {
                    $results = DB::select("CALL prc_pharmacy_calculations_bulk(?)", [
                        $bulk_id,

                    ]);
                    $additionalData = [
                        'r_service_name' => $p_Service_Name,
                        'r_dos' => $p_Data_of_Service,
                        'r_product_type' => $p_product_type,


                    ];
                    $resultsCollection = collect($results);

                    $newdata = $resultsCollection->map(function ($item) use ($additionalData) {
                        return (object) array_merge((array) $item, $additionalData);
                    })->toArray();
                    $data = json_decode(json_encode($newdata), true);



                    DB::commit();
                } catch (QueryException $e) {
                    // Handle database query exceptions (including stored procedure errors)
                    // Log the error, return a response, or perform other error handling
                    DB::rollBack();

                    $errorMessage = $e->getMessage();
                    $errorPrefix = '<<Unknown error>>: 1644 ';
                    $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                    $posSqlStart = strpos($errorMessage, '(SQL:');
                    $errorMessage = substr($errorMessage, 0, $posSqlStart);
                    return ['error' => $errorMessage];
                }
            }
        } else {
            foreach ($request->singleReport as $key => $value) {

                try {

                    $cleanCptCode = preg_replace('/-/', '', $value['cptcode']);

                    $data[$count] = DB::select('CALL prc_pharmacy_calculations(?,?,?,?,?,?)', [
                        $cleanCptCode,
                        $p_Data_of_Service,
                        $value['units'],
                        $value['payment_total'],
                        0,
                        ''

                    ])[0];
                } catch (QueryException $e) {
                    // Handle database query exceptions (including stored procedure errors)
                    // Log the error, return a response, or perform other error handling
                    $errorMessage = $e->getMessage();
                    $errorPrefix = '<<Unknown error>>: 1644 ';
                    $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                    $posSqlStart = strpos($errorMessage, '(SQL:');
                    $errorMessage = substr($errorMessage, 0, $posSqlStart);
                    return ['error' => $errorMessage];
                }

                $data[$count]->r_service_name = $p_Service_Name;
                $data[$count]->r_dos = $p_Data_of_Service;
                $data[$count]->r_product_type = $p_product_type;
                $data[$count]->r_hcpcs = $cleanCptCode;


                $data[$count] = (array) $data[$count];
                $count++;

                // }
            }
        }

        //dd($data);
        return $data;
    }

    function single_report_load(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $single_report = $this->single_report_load_query($request);


        if (isset($single_report['error'])) {

            return redirect()->back()->with("message", $single_report['error'])->withInput($request->all());
        }
        if (count($single_report) == 0) {
            return redirect()->back()->with("message", "Record is not valid as per date of service");
        }


        return view('services.pharmacy.single-report', ['single_reports' => $single_report]);

    }
    public function single_report_load_edit(Request $request)
    {

        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }

        $single_report = $this->single_report_load_query($request);

        if (isset($single_report['error'])) {
            return response()->json(["error" => $single_report['error']]);
        }

        if (count($single_report) == 0) {
            return response()->json(["error" => "Something Went Wrong!"]);
        }

        return response()->json("success");
    }


    public static function single_report_pdf(Request $request, $api = false)
    {

        $instance = new self();
        $single_report = $instance->single_report_load_query($request);


        $pdf = FacadePdf::loadView('services.pharmacy.single-report-pdf', ['single_reports' => $single_report]);

        return $pdf->stream('report.pdf');
    }

    function bulk_report_load(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $validator = Validator::make($request->all(), [
            'file' => 'required|mimes:xlsx'
        ]);
        if ($validator->fails()) {
            // return redirect()->back()->with('error',"The File not found");
            return redirect()->back()->with("message", "Only Xlsx File Can be Import!");
        }
        DB::beginTransaction();

        try {

            $import = new PharmacyBulk();

            Excel::import($import, $request->file('file'));
            $bulk_id = $import->getbulkid();

            DB::commit();
            $bulk_report = null;
            try {


                $bulk_report = DB::select("CALL prc_pharmacy_calculations_bulk('$bulk_id')");

            } catch (QueryException $e) {

                // Deleting the module data of bulk upload
                $BulkUploadData = BulkPharmacyRequest::where('bulk_id', '=', $bulk_id);
                if (isset($BulkUploadData)) {
                    $BulkUploadData->delete();
                }

                $BulkResponseData = BulkPharmacyResponse::where('bulk_id', '=', $bulk_id);
                if (isset($BulkResponseData)) {
                    $BulkResponseData->delete();
                }
                //  end of the data deleting for the bulk

                // Handle database query exceptions (including stored procedure errors)
                // Log the error, return a response, or perform other error handling
                $errorMessage = $e->getMessage();
                $errorPrefix = '<<Unknown error>>: 1644 ';
                $errorMessage = substr($errorMessage, strpos($errorMessage, $errorPrefix) + strlen($errorPrefix));
                $posSqlStart = strpos($errorMessage, '(SQL:');
                $errorMessage = substr($errorMessage, 0, $posSqlStart);
                return redirect()->back()->with("message", $errorMessage);
            }

            // Deleting the module data of bulk upload
            $BulkUploadData = BulkPharmacyRequest::where('bulk_id', '=', $bulk_id);
            if (isset($BulkUploadData)) {
                $BulkUploadData->delete();
            }


            $BulkResponseData = BulkPharmacyResponse::where('bulk_id', '=', $bulk_id);
            if (isset($BulkResponseData)) {
                $BulkResponseData->delete();
            }
            //  end of the data deleting for the bulk

            if ($request->is_pdf_bulk) {


                if (count($bulk_report) > 200) {

                    return redirect()->back()->with("message", "You have exceeded the maximum PDF generation limit of 200.");
                }

                PharmacyBulkPdf::dispatch( $bulk_report, $request->rc_email)->onQueue('pdf');
            }


            $fileName = 'bulk_report_' . time() . '.xlsx';
            return Excel::download(new PharmacyBulkExport($bulk_report), $fileName);

        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            DB::rollBack();

            $failures = $e->failures(); // Get validation failures

            // Map failures to column names and error messages
            $errors = [];

            $customMessages = [
                'dos' => 'The DOS field must be In Date Format In Excel.',
            ];
            foreach ($failures as $failure) {
                $attribute = $failure->attribute(); // Get the attribute name
                $errors[] = $customMessages[$attribute] ?? $failure->errors()[0];
            }

            // Redirect back with errors
            return redirect()->back()->withErrors($errors);
        }
    }
    public function home_edit(Request $request)
    {
        if (Auth::user()->approved === 0) {
            return redirect("user/pending");
        }
        $request_value = $request->input();
        // dd($request_value);
        return view('services.pharmacy.home-edit')->with(['request_value' => $request_value]);
    }

}
