<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller as Controller;


class BaseController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendResponse($message, $result)
    {
    	$response = [
            'success' => true,
            'message' => $message,
            'data'    => $result,

        ];


        return response()->json($response, 200);
    }


    /**
     * return error response.
     *
     * @return \Illuminate\Http\Response
     */
    // public function sendError($error, $errorMessages = [], $code = 200)
    public function sendError($error)
    {
    	$response = [
            'success' => false,
            'message' => $error,


        ];


        // if(!empty($errorMessages)){
        //     $response['data'] = $errorMessages;
        // }


        return response()->json($response, 200);
    }
}
