<?php

namespace App\Exports;

use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
class PharmacyBulkExport implements FromCollection,WithHeadings
{

    protected $data;

    public function __construct($bulk_report)
    {

        $data = [];
        foreach ($bulk_report as $result) {

            $date = Carbon::parse($result->date_of_service);


            $data[] = [
                'Date of Service' => $date->format('m/d/Y'),
                'NDC Number' => $result->{'NDC Number'},
                'Units' => $result->Units,
                'Dispensing Fee' => '$'.number_format($result->{'Dispensing Fee'},2),
                'Fee Schedule' => is_numeric($result->{'Fee Schedule'}) ? '$' . number_format($result->{'Fee Schedule'}, 2) : $result->{'Fee Schedule'},
                'Payment Total' => '$'.number_format($result->{'Payment Total'},2),
                'Balance Due' => '$'.number_format($result->{'Balance Due'},2),
                'Fee Schedule %' => $result->{'Fee Schedule %'},
                'Fee Schedule Title' => $result->{'fee schedule title'} ?? '',
                'Description' => $result->{'Description'} ?? '',
                'Effective Dates of Service' => $result->{'Effective Dates of Service'},
            ];
        }

        $this->data = $data;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $datacollection = collect($this->data);
        return  $datacollection ;
    }

    public function headings(): array
    {
        return [
            'Date of Service',
            'NDC Number',
            'Units',
            'Dispensing Fee',
            'Fee Schedule',
            'Payment Total',
            'Balance Due',
            'Fee Schedule %',
            'Fee Schedule Title',
            'Description',
            'Effective Dates of Service',
        ];
    }

}
