<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OMFS Calculator | Medical Lien Management</title>
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap.min.css') }}" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/font-awesome.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap-datepicker3.min.css') }}" />
    <link rel='stylesheet' href="{{ asset('user/assets/css/bootstrap-table.min.css') }}">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>

</head>

<body class="bg_gray ff_omfs" onload="getDate()">
    <div class="overflow-x-0">
        <div class="w-lg-85 px-3">
            <div class="row mt-3 mb-3 d-md-flex">
                <div class="col-sm-12 col-md-3 text-center text-md-left fs_13 order-2 order-md-1">
                    <div class="fs_16 text_green ff_omfs">Medical Lien Management</div>
                </div>
                <div class="col-sm-12 col-md-6 text-center order-3 order-md-2 mb-2">
                    <div class="text-center fs_40 text_dark_black ff_omfs fw_5 mb-1">OMFS Calculator</div>
                    <div class="title_underline bg_gradient ml-auto mr-auto mb-2"></div>
                </div>
                <div
                    class="d-md-block d-flex align-items-center col-sm-12 col-md-3 text-center text-md-right order-1 order-md-3 justify-content-center mb-3 mb-md-0">
                    <div class="fs_12 pr-3 pr-md-0"><b class="mr-2">Logged In: </b> {{ \Auth::user()->email }}</div>
                    <div class="fs_12"><a href="{{ url('user/logout') }}"
                            class="fw_5 btn bg_red text-white fs_12 py-1 px-3 mt-2">Logout</a> </div>

                    {{-- <div class="fs_18 text_green">Medical Lien Management</div>
<div class="fs_13"><a href="{{url('user/logout')}}" class="text-bold">Logout</a> </div> --}}

                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="calc_container bg-white">
                    @if (\Session::has('message'))
                        <div class="text-center text-danger">
                            <p>{!! \Session::get('message') !!}</p>
                        </div>
                    @endif

                    <div class="tab_head">
                        <nav>
                            <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                <a class="nav-item nav-link active" id="physician-services-tab" data-toggle="tab"
                                    href="#physician-services" role="tab" aria-controls="physician-services"
                                    aria-selected="true">Physician Services</a>
                                <a class="nav-item nav-link" id="e-service-tab" data-toggle="tab" href="#e-service"
                                    role="tab" aria-controls="e-service" aria-selected="false">E-Service</a>
                                <a class="nav-item nav-link" id="rfa-serving-tab" data-toggle="tab" href="#rfa-serving"
                                    role="tab" aria-controls="rfa-serving" aria-selected="false">RFA Serving</a>
                                <a class="nav-item nav-link" id="pr2-service-tab" data-toggle="tab" href="#pr2-service"
                                    role="tab" aria-controls="pr2-service" aria-selected="false">PR2 Service</a>
                                <a class="nav-item nav-link" id="claim-admin-dir-tab" data-toggle="tab"
                                    href="#claim-admin-dir" role="tab" aria-controls="claim-admin-dir"
                                    aria-selected="false">Claim Admin Directory</a>
                            </div>
                        </nav>
                    </div>
                    <div class="tab_body tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                        <div class="tab-pane show active" id="physician-services" role="tabpanel"
                            aria-labelledby="physician-services-tab">
                            {{-- Physician Content Start --}}
                            <form id="calc_form" method="POST" action="{{ url('user/single-report') }}" novalidate="">
                                @csrf
                                <div class="service_name">
                                    <input type="hidden" class="" id="service_name" name="service_name"
                                        placeholder="Select Service" value="Physician Services" />
                                </div>
                                <div class="row mt-lg-2">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="form_label col-sm-6 col-md-3 col-lg-3 mb-3">
                                                    <label for="dos">DOS <span class="fw_4">(mm/dd/yyyy)
                                                        </span><span class="text-red fs_12">*</span></label>
                                                    <div class="datepicker date input-group">
                                                        <input type="text" placeholder="MM/DD/YYYY"
                                                            class="form-control dos-input" id="dos" name="dos"
                                                            pattern="\d{2}/\d{2}/\d{4}" min="01/01/2000"
                                                            required="" />
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i
                                                                    class="fa fa-calendar"></i></span>
                                                        </div>
                                                        <div class="invalid-feedback pr-5">Select date of service</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label>Place of Service Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="facility" name="servicetype" value="Facility"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="facility">Facility</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="non-facility" name="servicetype"
                                                                value="Non-Facility" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="non-facility">Non-Facility</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select service type</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-5 col-lg-6 mb-3">
                                                    <label>Provider Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="physician" name="providertype" value="Physician"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="physician">Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="non-physician" name="providertype"
                                                                value="Non-Physician" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="non-physician">Non-Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="clinical-soial-worker" name="providertype"
                                                                value="Clinical Soial Worker" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="clinical-soial-worker">Clinical Soial
                                                                Worker</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select provider type</div>
                                                    </div>
                                                </div>


                                                <div id="convFactorDiv"
                                                    class="form_label col-sm-6 col-md-3  convFactorDiv col-lg-3 mb-3">
                                                    <label>Select Conversion Factor <span
                                                            class="text-red fs_12">*</span></label>
                                                    <div class="mb-3">
                                                        <select id="conversionfactor" class="simple_select mb-3 mt-2"
                                                            name="conversionfactor" aria-label="Conversion Factor"
                                                            aria-describedby="conversionfactoralidate" required>
                                                            <option value="Radiology Services">Radiology Services
                                                            </option>
                                                            <option value="Anesthesia">Anesthesia</option>
                                                            <option value="Surgery">Surgery</option>
                                                            <option value="Other Services">Other Services</option>
                                                        </select>
                                                        <div id="conversionfactoralidate" class="invalid-feedback">
                                                            Select conversion factor</div>
                                                    </div>
                                                </div>


                                                <div id="localityDiv"
                                                    class="form_label col-sm-6 col-md-4 localityDiv col-lg-3 mb-3">
                                                    <label>Find Place of Service Locality By</label>
                                                    <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="county" value="County"
                                                                checked>
                                                            <label class="form-check-label fw_4"
                                                                for="county">County</label>
                                                        </div>
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="zipcode" value="Zip-Code"
                                                                disabled>
                                                            <label class="form-check-label fw_4"
                                                                for="zipcode">Zip-Code</label>
                                                        </div>





                                                    </div>
                                                </div>
                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label class="" for="state">State</label>

                                                    <select id="locality_state" name="locality_state"
                                                        aria-label="State"
                                                        class="js-example-responsive locality_state mb-3 form-control js-example-basic-single js-states"
                                                        required>
                                                        @forelse($states as $state)
                                                            <option value="{{ $state->state }}">{{ $state->state }}
                                                            </option>
                                                        @empty
                                                        @endforelse

                                                    </select>
                                                    <div id="servicestateValidate" class="invalid-feedback">
                                                        Select State </div>
                                                </div>

                                                <div id="countyListDiv"
                                                    class="form_label col-sm-6 col-md-4 countyListDiv col-lg-3 mb-3">
                                                    <label for="calculation_locality_number">Place of Service
                                                        County</label>
                                                    <div class="mb-3">
                                                        <select id="calculation_locality_number" name="locality_name"
                                                            aria-label="Place of Service County"
                                                            class="js-example-responsive mb-3 form-control js-example-basic-single js-states calculation_locality_number"
                                                            required>

                                                        </select>
                                                        <div id="servicecountyValidate" class="invalid-feedback">
                                                            Select Place of service </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                                <div class="row mt-2 margin_up_minus">
                                    <div class="col-sm-12">
                                        <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">
                                            Bills</div>
                                    </div>
                                </div>


                                <div class="row mobile-hidden">
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Modifiers <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Units <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Payment Total <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                </div>


                                <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}
                                                    <select name="singleReport[0][modifiers]"
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="0" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="5" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="row mb-3">
                                    <div class="col-5">
                                        <div class="text-right d-flex">

                                            <button type="submit"
                                                class="btn bg_green themeBtn1 border-0 px-5 py-2 fs_15 text-white rounded-100"
                                                id="submitButton">Calculate</button>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <div class="cal_to_action bg_gray py-3 py-md-4 px-3 px-md-4 px-lg-5 rounded mt-3 mt-md-0">
                                <div class="row d-sm-flex align-items-center">
                                    <div class="col-sm-6 col-md-5 text-sm-left text-center">
                                        <p class="fw_7 fs_18 text-dark mb-3 mb-sm-0">Are you interested to get OMFS
                                            into Bulk?</p>
                                    </div>
                                    <div class="col-sm-6 col-md-7 text-sm-right text-center">
                                        <div class="text-center text-sm-right mb-3 mt-2 inline_btn_compact">
                                            <span class="fw_7 fs_13 text-dark mb-1 mt-2 ml-2">Download CSV Template:
                                            </span>
                                            <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-2 rounded-100"
                                                href="{{ asset('user/bulk-template/SampleBulkOMFS.csv') }}"
                                                download><i class="fa fa-download mr-2" aria-hidden="true"></i>Sample
                                                CSV</a>
                                            <a class="btn bg_blue text-white fs_14 py-2 px-5 collapsed mt-2 ml-2 rounded-100"
                                                data-toggle="collapse" href="#bulkCollapse" role="button"
                                                aria-expanded="false" aria-controls="bulkCollapse">Upload Bulk</a>


                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-2">
                                    <div class="col-sm-12">

                                        <div class="collapse" id="bulkCollapse">
                                            <div class="card card-body border-0"
                                                style="background-color: rgba(255,255,255,0.5);border-radius: 10px;">
                                                <form method="POST" action="{{ url('user/bulk-report') }}"
                                                    id="upload-file" enctype="multipart/form-data"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 text-left text-sm-right mb-3">
                                                            <div class="row">
                                                                <div class="col-sm-6 col-md-4 text-left">
                                                                    <div class="fw_7 fs_13 text-dark mb-1">Upload Your
                                                                        file <span class="fs_12 fw_4">(CSV format
                                                                            only):</span></div>
                                                                    <div class="fileBrowse">
                                                                        <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                            width="50px" height="50px" />
                                                                        <input type="file" class="fs_12"
                                                                            name="file" id="file" required />
                                                                        <label for="file"></label>
                                                                        <div class="invalid-feedback">CSV file is
                                                                            required.</div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-6 col-md-5">
                                                                    <div class="text-left mt-4">
                                                                        <button type="submit"
                                                                            class="btn btn-primary border-0 px-5 py-2 rounded-100 themeBtn1 fs_15"
                                                                            id="bulk-submit">Calculate Bulk</button>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            {{-- Physician Content End --}}
                        </div>
                        <div class="tab-pane fade" id="e-service" role="tabpanel" aria-labelledby="e-service-tab">
                            {{-- E-Service Content Start --}}
                            <form id="e-calc_form" method="POST" action="{{ url('user/single-report') }}"
                                novalidate="">
                                @csrf
                                <div class="service_name">
                                    <input type="hidden" class="" id="e-service_name" name="service_name"
                                        placeholder="Select Service" value="E-Service" />
                                </div>
                                <div class="row mt-lg-2">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="form_label col-sm-6 col-md-3 col-lg-3 mb-3">
                                                    <label for="e-dos">DOS <span class="fw_4">(mm/dd/yyyy)
                                                        </span><span class="text-red fs_12">*</span></label>
                                                    <div class="datepicker date input-group">
                                                        <input type="text" placeholder="MM/DD/YYYY"
                                                            class="form-control dos-input" id="e-dos" name="dos"
                                                            pattern="\d{2}/\d{2}/\d{4}" min="01/01/2000"
                                                             required="" />
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i
                                                                    class="fa fa-calendar"></i></span>
                                                        </div>
                                                        <div class="invalid-feedback pr-5">Select date of service</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label>Place of Service Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="e-facility" name="servicetype" value="Facility"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="e-facility">Facility</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="e-non-facility" name="servicetype"
                                                                value="Non-Facility" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="e-non-facility">Non-Facility</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select service type</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-5 col-lg-6 mb-3">
                                                    <label>Provider Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="e-physician" name="providertype" value="Physician"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="e-physician">Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="e-non-physician" name="providertype"
                                                                value="Non-Physician" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="e-non-physician">Non-Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="e-clinical-soial-worker" name="providertype"
                                                                value="Clinical Soial Worker" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="e-clinical-soial-worker">Clinical Soial
                                                                Worker</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select provider type</div>
                                                    </div>
                                                </div>


                                                <div id="e-convFactorDiv"
                                                    class="form_label col-sm-6 col-md-3 col-lg-3 mb-3 convFactorDiv">
                                                    <label>Select Conversion Factor <span
                                                            class="text-red fs_12">*</span></label>
                                                    <div class="mb-3">
                                                        <select id="e-conversionfactor" class="simple_select mb-3 mt-2"
                                                            name="conversionfactor" aria-label="Conversion Factor"
                                                            aria-describedby="conversionfactoralidate" required>
                                                            <option value="Radiology Services">Radiology Services
                                                            </option>
                                                            <option value="Anesthesia">Anesthesia</option>
                                                            <option value="Surgery">Surgery</option>
                                                            <option value="Other Services">Other Services</option>
                                                        </select>
                                                        <div id="e-conversionfactoralidate" class="invalid-feedback">
                                                            Select conversion factor</div>
                                                    </div>
                                                </div>


                                                <div id="e-localityDiv"
                                                    class="form_label col-sm-6 col-md-4 localityDiv col-lg-3 mb-3">
                                                    <label>Find Place of Service Locality By</label>
                                                    <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="e-county" value="County"
                                                                checked>
                                                            <label class="form-check-label fw_4"
                                                                for="e-county">County</label>
                                                        </div>
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="e-zipcode" value="Zip-Code"
                                                                disabled>
                                                            <label class="form-check-label fw_4"
                                                                for="e-zipcode">Zip-Code</label>
                                                        </div>





                                                    </div>
                                                </div>
                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label class="" for="state">State</label>

                                                    <select id="e-locality_state" name="locality_state"
                                                        aria-label="State"
                                                        class="js-example-responsive mb-3 locality_state form-control js-example-basic-single js-states"
                                                        required>
                                                        @forelse($states as $state)
                                                            <option value="{{ $state->state }}">{{ $state->state }}
                                                            </option>
                                                        @empty
                                                        @endforelse

                                                    </select>
                                                    <div id="e-servicestateValidate" class="invalid-feedback">
                                                        Select State </div>
                                                </div>

                                                <div id="e-countyListDiv"
                                                    class="form_label col-sm-6 col-md-4 countyListDiv col-lg-3 mb-3">
                                                    <label for="e-calculation_locality_number">Place of Service
                                                        County</label>
                                                    <div class="mb-3">
                                                        <select id="e-calculation_locality_number" name="locality_name"
                                                            aria-label="Place of Service County"
                                                            class="js-example-responsive mb-3 form-control js-example-basic-single js-states calculation_locality_number"
                                                            required>

                                                        </select>
                                                        <div id="e-servicecountyValidate" class="invalid-feedback">
                                                            Select Place of service </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                                <div class="row mt-2 margin_up_minus">
                                    <div class="col-sm-12">
                                        <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">
                                            Bills</div>
                                    </div>
                                </div>


                                <div class="row mobile-hidden">
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Modifiers <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Units <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Payment Total <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                </div>


                                <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}
                                                    <select name="singleReport[0][modifiers]"
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="0" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="row mb-3">
                                    <div class="col-5">
                                        <div class="text-right d-flex">

                                            <button type="submit"
                                                class="btn bg_green themeBtn1 border-0 px-5 py-2 fs_15 text-white rounded-100"
                                                id="e-submitButton">Calculate</button>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <div class="cal_to_action bg_gray py-3 py-md-4 px-3 px-md-4 px-lg-5 rounded mt-3 mt-md-0">
                                <div class="row d-sm-flex align-items-center">
                                    <div class="col-sm-6 col-md-5 text-sm-left text-center">
                                        <p class="fw_7 fs_18 text-dark mb-3 mb-sm-0">Are you interested to get OMFS
                                            into Bulk?</p>
                                    </div>
                                    <div class="col-sm-6 col-md-7 text-sm-right text-center">
                                        <div class="text-center text-sm-right mb-3 mt-2 inline_btn_compact">
                                            <span class="fw_7 fs_13 text-dark mb-1 mt-2 ml-2">Download CSV Template:
                                            </span>
                                            <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-2 rounded-100"
                                                href="{{ asset('user/bulk-template/SampleBulkOMFS.csv') }}"
                                                download><i class="fa fa-download mr-2" aria-hidden="true"></i>Sample
                                                CSV</a>
                                            <a class="btn bg_blue text-white fs_14 py-2 px-5 collapsed mt-2 ml-2 rounded-100"
                                                data-toggle="collapse" href="#bulkCollapse" role="button"
                                                aria-expanded="false" aria-controls="bulkCollapse">Upload Bulk</a>


                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-2">
                                    <div class="col-sm-12">

                                        <div class="collapse" id="bulkCollapse">
                                            <div class="card card-body border-0"
                                                style="background-color: rgba(255,255,255,0.5);border-radius: 10px;">
                                                <form method="POST" action="{{ url('user/bulk-report') }}"
                                                    id="upload-file" enctype="multipart/form-data"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 text-left text-sm-right mb-3">
                                                            <div class="row">
                                                                <div class="col-sm-6 col-md-4 text-left">
                                                                    <div class="fw_7 fs_13 text-dark mb-1">Upload Your
                                                                        file <span class="fs_12 fw_4">(CSV format
                                                                            only):</span></div>
                                                                    <div class="fileBrowse">
                                                                        <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                            width="50px" height="50px" />
                                                                        <input type="file" class="fs_12"
                                                                            name="file" id="file" required />
                                                                        <label for="file"></label>
                                                                        <div class="invalid-feedback">CSV file is
                                                                            required.</div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-6 col-md-5">
                                                                    <div class="text-left mt-4">
                                                                        <button type="submit"
                                                                            class="btn btn-primary border-0 px-5 py-2 rounded-100 themeBtn1 fs_15"
                                                                            id="bulk-submit">Calculate Bulk</button>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            {{-- E-Service Content End --}}
                        </div>
                        <div class="tab-pane fade" id="rfa-serving" role="tabpanel"
                            aria-labelledby="rfa-serving-tab">
                            {{-- RFA Serving --}}
                            <form id="rfa-calc_form" method="POST" action="{{ url('user/single-report') }}"
                                novalidate="">
                                @csrf
                                <div class="service_name">
                                    <input type="hidden" class="" id="rfa-service_name" name="service_name"
                                        placeholder="Select Service" value="RFA Serving" />
                                </div>
                                <div class="row mt-lg-2">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="form_label col-sm-6 col-md-3 col-lg-3 mb-3">
                                                    <label for="rfa-dos">DOS <span class="fw_4">(mm/dd/yyyy)
                                                        </span><span class="text-red fs_12">*</span></label>
                                                    <div class="datepicker date input-group">
                                                        <input type="text" placeholder="MM/DD/YYYY"
                                                            class="form-control dos-input" id="rfa-dos" name="dos"
                                                            pattern="\d{2}/\d{2}/\d{4}" min="01/01/2000"
                                                            required="" />
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i
                                                                    class="fa fa-calendar"></i></span>
                                                        </div>
                                                        <div class="invalid-feedback pr-5">Select date of service</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label>Place of Service Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="rfa-facility" name="servicetype" value="Facility"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="rfa-facility">Facility</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="rfa-non-facility" name="servicetype"
                                                                value="Non-Facility" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="rfa-non-facility">Non-Facility</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select service type</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-5 col-lg-6 mb-3">
                                                    <label>Provider Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="rfa-physician" name="providertype" value="Physician"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="rfa-physician">Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="rfa-non-physician" name="providertype"
                                                                value="Non-Physician" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="rfa-non-physician">Non-Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="rfa-clinical-soial-worker" name="providertype"
                                                                value="Clinical Soial Worker" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="rfa-clinical-soial-worker">Clinical Soial
                                                                Worker</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select provider type</div>
                                                    </div>
                                                </div>


                                                <div id="rfa-convFactorDiv"
                                                    class="form_label col-sm-6 col-md-3 col-lg-3 mb-3 convFactorDiv">
                                                    <label>Select Conversion Factor <span
                                                            class="text-red fs_12">*</span></label>
                                                    <div class="mb-3">
                                                        <select id="rfa-conversionfactor" class="simple_select mb-3 mt-2"
                                                            name="conversionfactor" aria-label="Conversion Factor"
                                                            aria-describedby="conversionfactoralidate" required>
                                                            <option value="Radiology Services">Radiology Services
                                                            </option>
                                                            <option value="Anesthesia">Anesthesia</option>
                                                            <option value="Surgery">Surgery</option>
                                                            <option value="Other Services">Other Services</option>
                                                        </select>
                                                        <div id="rfa-conversionfactoralidate" class="invalid-feedback">
                                                            Select conversion factor</div>
                                                    </div>
                                                </div>


                                                <div id="rfa-localityDiv"
                                                    class="form_label col-sm-6 col-md-4 localityDiv col-lg-3 mb-3">
                                                    <label>Find Place of Service Locality By</label>
                                                    <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="rfa-county" value="County"
                                                                checked>
                                                            <label class="form-check-label fw_4"
                                                                for="rfa-county">County</label>
                                                        </div>
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="rfa-zipcode" value="Zip-Code"
                                                                disabled>
                                                            <label class="form-check-label fw_4"
                                                                for="rfa-zipcode">Zip-Code</label>
                                                        </div>





                                                    </div>
                                                </div>
                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label class="" for="state">State</label>

                                                    <select id="rfa-locality_state" name="locality_state"
                                                        aria-label="State"
                                                        class="js-example-responsive mb-3 locality_state form-control js-example-basic-single js-states"
                                                        required>
                                                        @forelse($states as $state)
                                                            <option value="{{ $state->state }}">{{ $state->state }}
                                                            </option>
                                                        @empty
                                                        @endforelse

                                                    </select>
                                                    <div id="rfa-servicestateValidate" class="invalid-feedback">
                                                        Select State </div>
                                                </div>

                                                <div id="rfa-countyListDiv"
                                                    class="form_label col-sm-6 col-md-4 countyListDiv col-lg-3 mb-3">
                                                    <label for="rfa-calculation_locality_number">Place of Service
                                                        County</label>
                                                    <div class="mb-3">
                                                        <select id="rfa-calculation_locality_number" name="locality_name"
                                                            aria-label="Place of Service County"
                                                            class="js-example-responsive mb-3 form-control js-example-basic-single js-states calculation_locality_number"
                                                            required>

                                                        </select>
                                                        <div id="rfa-servicecountyValidate" class="invalid-feedback">
                                                            Select Place of service </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                                <div class="row mt-2 margin_up_minus">
                                    <div class="col-sm-12">
                                        <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">
                                            Bills</div>
                                    </div>
                                </div>


                                <div class="row mobile-hidden">
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Modifiers <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Units <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Payment Total <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                </div>


                                <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}
                                                    <select name="singleReport[0][modifiers]"
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="0" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="row mb-3">
                                    <div class="col-5">
                                        <div class="text-right d-flex">

                                            <button type="submit"
                                                class="btn bg_green themeBtn1 border-0 px-5 py-2 fs_15 text-white rounded-100"
                                                id="rfa-submitButton">Calculate</button>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <div class="cal_to_action bg_gray py-3 py-md-4 px-3 px-md-4 px-lg-5 rounded mt-3 mt-md-0">
                                <div class="row d-sm-flex align-items-center">
                                    <div class="col-sm-6 col-md-5 text-sm-left text-center">
                                        <p class="fw_7 fs_18 text-dark mb-3 mb-sm-0">Are you interested to get OMFS
                                            into Bulk?</p>
                                    </div>
                                    <div class="col-sm-6 col-md-7 text-sm-right text-center">
                                        <div class="text-center text-sm-right mb-3 mt-2 inline_btn_compact">
                                            <span class="fw_7 fs_13 text-dark mb-1 mt-2 ml-2">Download CSV Template:
                                            </span>
                                            <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-2 rounded-100"
                                                href="{{ asset('user/bulk-template/SampleBulkOMFS.csv') }}"
                                                download><i class="fa fa-download mr-2" aria-hidden="true"></i>Sample
                                                CSV</a>
                                            <a class="btn bg_blue text-white fs_14 py-2 px-5 collapsed mt-2 ml-2 rounded-100"
                                                data-toggle="collapse" href="#bulkCollapse" role="button"
                                                aria-expanded="false" aria-controls="bulkCollapse">Upload Bulk</a>


                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-2">
                                    <div class="col-sm-12">

                                        <div class="collapse" id="bulkCollapse">
                                            <div class="card card-body border-0"
                                                style="background-color: rgba(255,255,255,0.5);border-radius: 10px;">
                                                <form method="POST" action="{{ url('user/bulk-report') }}"
                                                    id="upload-file" enctype="multipart/form-data"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 text-left text-sm-right mb-3">
                                                            <div class="row">
                                                                <div class="col-sm-6 col-md-4 text-left">
                                                                    <div class="fw_7 fs_13 text-dark mb-1">Upload Your
                                                                        file <span class="fs_12 fw_4">(CSV format
                                                                            only):</span></div>
                                                                    <div class="fileBrowse">
                                                                        <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                            width="50px" height="50px" />
                                                                        <input type="file" class="fs_12"
                                                                            name="file" id="file" required />
                                                                        <label for="file"></label>
                                                                        <div class="invalid-feedback">CSV file is
                                                                            required.</div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-6 col-md-5">
                                                                    <div class="text-left mt-4">
                                                                        <button type="submit"
                                                                            class="btn btn-primary border-0 px-5 py-2 rounded-100 themeBtn1 fs_15"
                                                                            id="bulk-submit">Calculate Bulk</button>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            {{-- RFA Serving --}}
                        </div>
                        <div class="tab-pane fade" id="pr2-service" role="tabpanel"
                            aria-labelledby="pr2-service-tab">
                            {{-- PR2 Content Start --}}
                            <form id="pr2-calc_form" method="POST" action="{{ url('user/single-report') }}"
                                novalidate="">
                                @csrf
                                <div class="service_name">
                                    <input type="hidden" class="" id="pr2-service_name" name="service_name"
                                        placeholder="Select Service" value="PR2 Service" />
                                </div>
                                <div class="row mt-lg-2">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="form_label col-sm-6 col-md-3 col-lg-3 mb-3">
                                                    <label for="pr2-dos">DOS <span class="fw_4">(mm/dd/yyyy)
                                                        </span><span class="text-red fs_12">*</span></label>
                                                    <div class="datepicker date input-group">
                                                        <input type="text" placeholder="MM/DD/YYYY"
                                                            class="form-control dos-input" id="pr2-dos" name="dos"
                                                            pattern="\d{2}/\d{2}/\d{4}" min="01/01/2000"
                                                           required="" />
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i
                                                                    class="fa fa-calendar"></i></span>
                                                        </div>
                                                        <div class="invalid-feedback pr-5">Select date of service</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label>Place of Service Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="pr2-facility" name="servicetype" value="Facility"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="pr2-facility">Facility</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="pr2-non-facility" name="servicetype"
                                                                value="Non-Facility" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="pr2-non-facility">Non-Facility</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select service type</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-5 col-lg-6 mb-3">
                                                    <label>Provider Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="pr2-physician" name="providertype" value="Physician"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="pr2-physician">Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="pr2-non-physician" name="providertype"
                                                                value="Non-Physician" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="pr2-non-physician">Non-Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="pr2-clinical-soial-worker" name="providertype"
                                                                value="Clinical Soial Worker" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="pr2-clinical-soial-worker">Clinical Soial
                                                                Worker</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select provider type</div>
                                                    </div>
                                                </div>


                                                <div id="pr2-convFactorDiv"
                                                    class="form_label col-sm-6 col-md-3 col-lg-3 mb-3 convFactorDiv">
                                                    <label>Select Conversion Factor <span
                                                            class="text-red fs_12">*</span></label>
                                                    <div class="mb-3">
                                                        <select id="pr2-conversionfactor" class="simple_select mb-3 mt-2"
                                                            name="conversionfactor" aria-label="Conversion Factor"
                                                            aria-describedby="conversionfactoralidate" required>
                                                            <option value="Radiology Services">Radiology Services
                                                            </option>
                                                            <option value="Anesthesia">Anesthesia</option>
                                                            <option value="Surgery">Surgery</option>
                                                            <option value="Other Services">Other Services</option>
                                                        </select>
                                                        <div id="pr2-conversionfactoralidate" class="invalid-feedback">
                                                            Select conversion factor</div>
                                                    </div>
                                                </div>


                                                <div id="pr2-localityDiv"
                                                    class="form_label col-sm-6 col-md-4 localityDiv col-lg-3 mb-3">
                                                    <label>Find Place of Service Locality By</label>
                                                    <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="pr2-county" value="County"
                                                                checked>
                                                            <label class="form-check-label fw_4"
                                                                for="pr2-county">County</label>
                                                        </div>
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="pr2-zipcode" value="Zip-Code"
                                                                disabled>
                                                            <label class="form-check-label fw_4"
                                                                for="pr2-zipcode">Zip-Code</label>
                                                        </div>





                                                    </div>
                                                </div>
                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label class="" for="state">State</label>

                                                    <select id="pr2-locality_state" name="locality_state"
                                                        aria-label="State"
                                                        class="js-example-responsive mb-3 locality_state form-control js-example-basic-single js-states"
                                                        required>
                                                        @forelse($states as $state)
                                                            <option value="{{ $state->state }}">{{ $state->state }}
                                                            </option>
                                                        @empty
                                                        @endforelse

                                                    </select>
                                                    <div id="pr2-servicestateValidate" class="invalid-feedback">
                                                        Select State </div>
                                                </div>

                                                <div id="pr2-countyListDiv"
                                                    class="form_label col-sm-6 col-md-4 countyListDiv col-lg-3 mb-3">
                                                    <label for="pr2-calculation_locality_number">Place of Service
                                                        County</label>
                                                    <div class="mb-3">
                                                        <select id="pr2-calculation_locality_number" name="locality_name"
                                                            aria-label="Place of Service County"
                                                            class="js-example-responsive mb-3 form-control js-example-basic-single js-states calculation_locality_number"
                                                            required>

                                                        </select>
                                                        <div id="pr2-servicecountyValidate" class="invalid-feedback">
                                                            Select Place of service </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                                <div class="row mt-2 margin_up_minus">
                                    <div class="col-sm-12">
                                        <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">
                                            Bills</div>
                                    </div>
                                </div>


                                <div class="row mobile-hidden">
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Modifiers <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Units <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Payment Total <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                </div>


                                <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}
                                                    <select name="singleReport[0][modifiers]"
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="0" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="row mb-3">
                                    <div class="col-5">
                                        <div class="text-right d-flex">

                                            <button type="submit"
                                                class="btn bg_green themeBtn1 border-0 px-5 py-2 fs_15 text-white rounded-100"
                                                id="pr2-submitButton">Calculate</button>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <div class="cal_to_action bg_gray py-3 py-md-4 px-3 px-md-4 px-lg-5 rounded mt-3 mt-md-0">
                                <div class="row d-sm-flex align-items-center">
                                    <div class="col-sm-6 col-md-5 text-sm-left text-center">
                                        <p class="fw_7 fs_18 text-dark mb-3 mb-sm-0">Are you interested to get OMFS
                                            into Bulk?</p>
                                    </div>
                                    <div class="col-sm-6 col-md-7 text-sm-right text-center">
                                        <div class="text-center text-sm-right mb-3 mt-2 inline_btn_compact">
                                            <span class="fw_7 fs_13 text-dark mb-1 mt-2 ml-2">Download CSV Template:
                                            </span>
                                            <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-2 rounded-100"
                                                href="{{ asset('user/bulk-template/SampleBulkOMFS.csv') }}"
                                                download><i class="fa fa-download mr-2" aria-hidden="true"></i>Sample
                                                CSV</a>
                                            <a class="btn bg_blue text-white fs_14 py-2 px-5 collapsed mt-2 ml-2 rounded-100"
                                                data-toggle="collapse" href="#bulkCollapse" role="button"
                                                aria-expanded="false" aria-controls="bulkCollapse">Upload Bulk</a>


                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-2">
                                    <div class="col-sm-12">

                                        <div class="collapse" id="bulkCollapse">
                                            <div class="card card-body border-0"
                                                style="background-color: rgba(255,255,255,0.5);border-radius: 10px;">
                                                <form method="POST" action="{{ url('user/bulk-report') }}"
                                                    id="upload-file" enctype="multipart/form-data"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 text-left text-sm-right mb-3">
                                                            <div class="row">
                                                                <div class="col-sm-6 col-md-4 text-left">
                                                                    <div class="fw_7 fs_13 text-dark mb-1">Upload Your
                                                                        file <span class="fs_12 fw_4">(CSV format
                                                                            only):</span></div>
                                                                    <div class="fileBrowse">
                                                                        <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                            width="50px" height="50px" />
                                                                        <input type="file" class="fs_12"
                                                                            name="file" id="file" required />
                                                                        <label for="file"></label>
                                                                        <div class="invalid-feedback">CSV file is
                                                                            required.</div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-6 col-md-5">
                                                                    <div class="text-left mt-4">
                                                                        <button type="submit"
                                                                            class="btn btn-primary border-0 px-5 py-2 rounded-100 themeBtn1 fs_15"
                                                                            id="bulk-submit">Calculate Bulk</button>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            {{-- PR2 Content End --}}
                        </div>
                        <div class="tab-pane fade" id="claim-admin-dir" role="tabpanel"
                            aria-labelledby="claim-admin-dir-tab">
                            {{-- Claim-Admin Content Start --}}
                            <form id="claim-admin-calc_form" method="POST" action="{{ url('user/single-report') }}"
                                novalidate="">
                                @csrf
                                <div class="service_name">
                                    <input type="hidden" class="" id="claim-admin-service_name" name="service_name"
                                        placeholder="Select Service" value="Claim Admin" />
                                </div>
                                <div class="row mt-lg-2">


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="form_label col-sm-6 col-md-3 col-lg-3 mb-3">
                                                    <label for="claim-admin-dos">DOS <span class="fw_4">(mm/dd/yyyy)
                                                        </span><span class="text-red fs_12">*</span></label>
                                                    <div class="datepicker date input-group">
                                                        <input type="text" placeholder="MM/DD/YYYY"
                                                            class="form-control dos-input" id="claim-admin-dos" name="dos"
                                                            pattern="\d{2}/\d{2}/\d{4}" min="01/01/2000"
                                                             required="" />
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i
                                                                    class="fa fa-calendar"></i></span>
                                                        </div>
                                                        <div class="invalid-feedback pr-5">Select date of service</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label>Place of Service Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-4 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="claim-admin-facility" name="servicetype" value="Facility"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="claim-admin-facility">Facility</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="claim-admin-non-facility" name="servicetype"
                                                                value="Non-Facility" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="claim-admin-non-facility">Non-Facility</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select service type</div>
                                                    </div>
                                                </div>

                                                <div class="form_label col-sm-6 col-md-5 col-lg-6 mb-3">
                                                    <label>Provider Type</label>
                                                    <div class="mb-3">
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="claim-admin-physician" name="providertype" value="Physician"
                                                                required checked>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="claim-admin-physician">Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio mr-3 custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="claim-admin-non-physician" name="providertype"
                                                                value="Non-Physician" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="claim-admin-non-physician">Non-Physician</label>
                                                        </div>
                                                        <div
                                                            class="form-check custom-control custom-radio custom-control-inline">
                                                            <input type="radio" class="custom-control-input"
                                                                id="claim-admin-clinical-soial-worker" name="providertype"
                                                                value="Clinical Soial Worker" required>
                                                            <label class="form-check-label custom-control-label fw_4"
                                                                for="claim-admin-clinical-soial-worker">Clinical Soial
                                                                Worker</label>
                                                        </div>
                                                        <div class="invalid-feedback">Select provider type</div>
                                                    </div>
                                                </div>


                                                <div id="claim-admin-convFactorDiv"
                                                    class="form_label col-sm-6 col-md-3 col-lg-3 mb-3 convFactorDiv">
                                                    <label>Select Conversion Factor <span
                                                            class="text-red fs_12">*</span></label>
                                                    <div class="mb-3">
                                                        <select id="claim-admin-conversionfactor" class="simple_select mb-3 mt-2"
                                                            name="conversionfactor" aria-label="Conversion Factor"
                                                            aria-describedby="conversionfactoralidate" required>
                                                            <option value="Radiology Services">Radiology Services
                                                            </option>
                                                            <option value="Anesthesia">Anesthesia</option>
                                                            <option value="Surgery">Surgery</option>
                                                            <option value="Other Services">Other Services</option>
                                                        </select>
                                                        <div id="claim-admin-conversionfactoralidate" class="invalid-feedback">
                                                            Select conversion factor</div>
                                                    </div>
                                                </div>


                                                <div id="claim-admin-localityDiv"
                                                    class="form_label col-sm-6 col-md-4 localityDiv col-lg-3 mb-3">
                                                    <label>Find Place of Service Locality By</label>
                                                    <div class="mb-3 mt-md-3 d-flex align-items-center">
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="claim-admin-county" value="County"
                                                                checked>
                                                            <label class="form-check-label fw_4"
                                                                for="claim-admin-county">County</label>
                                                        </div>
                                                        <div class="form-check mr-4">
                                                            <input class="form-check-input" type="radio"
                                                                name="locality_type" id="claim-admin-zipcode" value="Zip-Code"
                                                                disabled>
                                                            <label class="form-check-label fw_4"
                                                                for="claim-admin-zipcode">Zip-Code</label>
                                                        </div>





                                                    </div>
                                                </div>
                                                <div class="form_label col-sm-6 col-md-4 col-lg-3 mb-3">
                                                    <label class="" for="state">State</label>

                                                    <select id="claim-admin-locality_state" name="locality_state"
                                                        aria-label="State"
                                                        class="js-example-responsive mb-3 locality_state form-control js-example-basic-single js-states"
                                                        required>
                                                        @forelse($states as $state)
                                                            <option value="{{ $state->state }}">{{ $state->state }}
                                                            </option>
                                                        @empty
                                                        @endforelse

                                                    </select>
                                                    <div id="claim-admin-servicestateValidate" class="invalid-feedback">
                                                        Select State </div>
                                                </div>

                                                <div id="claim-admin-countyListDiv"
                                                    class="form_label col-sm-6 col-md-4 countyListDiv col-lg-3 mb-3">
                                                    <label for="claim-admin-calculation_locality_number">Place of Service
                                                        County</label>
                                                    <div class="mb-3">
                                                        <select id="claim-admin-calculation_locality_number" name="locality_name"
                                                            aria-label="Place of Service County"
                                                            class="js-example-responsive mb-3 form-control js-example-basic-single js-states calculation_locality_number"
                                                            required>

                                                        </select>
                                                        <div id="claim-admin-servicecountyValidate" class="invalid-feedback">
                                                            Select Place of service </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                                <div class="row mt-2 margin_up_minus">
                                    <div class="col-sm-12">
                                        <div class="text-center fs_50 text_dark_black ff_omfs fw_6 text-uppercase">
                                            Bills</div>
                                    </div>
                                </div>


                                <div class="row mobile-hidden">
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Procedure Code <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Modifiers <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Units <span class="text-red fs_12">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-3 col-md-3">
                                        <div class="form_label">
                                            <label>Payment Total <span class="text-red fs_12"></span></label>
                                        </div>
                                    </div>
                                </div>


                                <div class="field_wrapper_main">
                                    <div class="row select-container_main">
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Procedure Code <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text"
                                                    class="form-control inc_main cptcode text-uppercase"
                                                    name="singleReport[0][cptcode]" placeholder="CPT code"
                                                    value="" pattern="[a-zA-Z0-9]{1,5}" maxLength="5"
                                                    required />
                                                <div class="invalid-feedback">Select procedure code</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Modifiers <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="mb-3">
                                                    {{-- Add class "multiple="multiple" for multiple selections --}}
                                                    <select name="singleReport[0][modifiers]"
                                                        class="mb-3 js-example-basic-multiple js-states form-control js-example-responsive modifier-select">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Units <span
                                                        class="text-red fs_12">*</span></label>
                                                <input type="text" class="form-control units"
                                                    name="singleReport[0][units]" placeholder="0" value="1"
                                                    maxLength="3" required />
                                                <div class="invalid-feedback">Select unit</div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-sm-3 col-md-3">
                                            <div class="form_label mb-3">
                                                <label class="d-block d-sm-none">Payment Total <span
                                                        class="text-red fs_12"></span></label>
                                                <div class="last_field">
                                                    <input type="text" class="form-control charges"
                                                        name="singleReport[0][payment_total]" placeholder="0.00"
                                                        value="0" maxLength="10" />
                                                    <div class="removeField">
                                                        <a href='javascript:void(0);' class='remove_button'><i
                                                                class='fa fa-remove' aria-hidden='true'></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="row mb-3">
                                    <div class="col-5">
                                        <div class="text-right d-flex">

                                            <button type="submit"
                                                class="btn bg_green themeBtn1 border-0 px-5 py-2 fs_15 text-white rounded-100"
                                                id="claim-admin-submitButton">Calculate</button>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <div class="cal_to_action bg_gray py-3 py-md-4 px-3 px-md-4 px-lg-5 rounded mt-3 mt-md-0">
                                <div class="row d-sm-flex align-items-center">
                                    <div class="col-sm-6 col-md-5 text-sm-left text-center">
                                        <p class="fw_7 fs_18 text-dark mb-3 mb-sm-0">Are you interested to get OMFS
                                            into Bulk?</p>
                                    </div>
                                    <div class="col-sm-6 col-md-7 text-sm-right text-center">
                                        <div class="text-center text-sm-right mb-3 mt-2 inline_btn_compact">
                                            <span class="fw_7 fs_13 text-dark mb-1 mt-2 ml-2">Download CSV Template:
                                            </span>
                                            <a class="btn btn-outline-secondary fs_14 py-2 px-4 mt-2 ml-2 rounded-100"
                                                href="{{ asset('user/bulk-template/SampleBulkOMFS.csv') }}"
                                                download><i class="fa fa-download mr-2" aria-hidden="true"></i>Sample
                                                CSV</a>
                                            <a class="btn bg_blue text-white fs_14 py-2 px-5 collapsed mt-2 ml-2 rounded-100"
                                                data-toggle="collapse" href="#bulkCollapse" role="button"
                                                aria-expanded="false" aria-controls="bulkCollapse">Upload Bulk</a>


                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-2">
                                    <div class="col-sm-12">

                                        <div class="collapse" id="bulkCollapse">
                                            <div class="card card-body border-0"
                                                style="background-color: rgba(255,255,255,0.5);border-radius: 10px;">
                                                <form method="POST" action="{{ url('user/bulk-report') }}"
                                                    id="upload-file" enctype="multipart/form-data"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 text-left text-sm-right mb-3">
                                                            <div class="row">
                                                                <div class="col-sm-6 col-md-4 text-left">
                                                                    <div class="fw_7 fs_13 text-dark mb-1">Upload Your
                                                                        file <span class="fs_12 fw_4">(CSV format
                                                                            only):</span></div>
                                                                    <div class="fileBrowse">
                                                                        <img src="{{ asset('user/assets/images/upload-icon.png') }}"
                                                                            width="50px" height="50px" />
                                                                        <input type="file" class="fs_12"
                                                                            name="file" id="file" required />
                                                                        <label for="file"></label>
                                                                        <div class="invalid-feedback">CSV file is
                                                                            required.</div>
                                                                    </div>
                                                                </div>

                                                                <div class="col-sm-6 col-md-5">
                                                                    <div class="text-left mt-4">
                                                                        <button type="submit"
                                                                            class="btn btn-primary border-0 px-5 py-2 rounded-100 themeBtn1 fs_15"
                                                                            id="bulk-submit">Calculate Bulk</button>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>

                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            {{-- Claim-Admin Content End --}}
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>



    {{-- <script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script> --}}
    <script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('user/assets/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-export.js') }}"></script>
    <script src="{{ asset('user/assets/js/tableExport.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap-table-filter-control.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
    <script src="{{ asset('user/assets/js/dynamic_cpt_row_main.js') }}"></script>
    <script src="{{ asset('user/assets/js/custom.js') }}"></script>

    <script>
        function getDate() {
            const selectedDos = document.getElementById("dos").value;
            if (selectedDos.length > 0) {
                if (!moment(selectedDos).isBetween('12/31/1999', '03/01/2017')) {
                    document.getElementById("conversionfactor").options[1].style.display = 'block';
                    document.getElementById("conversionfactor").options[3].style.display = 'block';
                    document.getElementById("conversionfactor").value = 'Other Services';
                }
            }
        }

        $(function() {
            /*Date Comparison*/
            $(".dos-input").on("change", function() {
                var sb_dos_selected = $(this).val();
                if (moment(sb_dos_selected).isAfter(moment('02/28/2017', 'MM/DD/YYYY'))) {
                    $(".convFactorDiv select option[value='Other Services']").attr('selected', 'selected');
                }
            });

            window.onpageshow = function(event) {
                if (event.persisted) {
                    window.location.reload();
                    document.getElementById("upload-file").reset();
                }
            };
        });


        //calculation_locality_number

        $('.locality_state').on('change', function() {
            // Get the selected state value
            var state = $(this).val();

            // Call the fetchServicePlaces function with the selected state value
            fetchServicePlaces(state);
        });


        function fetchServicePlaces(state) {
            $.ajax({
                url: '{{ route('placeOfServiceList') }}',
                type: 'GET',
                data: {
                    state: state
                },
                success: function(response) {
                    // Clear previous options
                    $('.calculation_locality_number').empty();

                    // Iterate over each response item and append an option
                    $.each(response, function(index, item) {
                        $('.calculation_locality_number').append('<option value="' + item
                            .localitynumber + '">' + item.localityname + "-" + item.localitynumber +
                            ' </option>');
                    });

                    // Initialize Select2
                    $('.calculation_locality_number').select2();
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    </script>

</body>

</html>
