<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>User Information | Medical Lien Management</title>
    <link rel="stylesheet" href="{{ asset('user/assets/css/bootstrap.min.css') }}" />
    <link href="{{ asset('user/assets/style.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('user/assets/css/font-awesome.min.css') }}"/>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
 <style>
.floating_fields input, .floating_fields textarea {
    background-color: #ffffff;
    padding: 8px 0px 8px 0px !important;
    width: 100%;
    border-radius: 0 !important;
    box-sizing: border-box;
    border: none !important;
    border-bottom: 1px solid #F3E5F5 !important;
    font-size: 14px !important;
    color: #000 !important;
    font-weight: 300;
}

.floating_fields input:focus, .floating_fields textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border-bottom: 1px solid #2d8ed2 !important;
    outline-width: 0;
    font-weight: 400;
}

.floating_fields .form-floating {
    position: relative;
    margin-bottom: 1.5rem;
}

.floating_fields .form-control-placeholder {
    position: absolute;
    top: 8px;
    padding: 7px 0 0 0;
    transition: all 300ms;
    opacity: 0.5;
}

.floating_fields .form-control:focus + .form-control-placeholder,
.floating_fields .form-control:valid + .form-control-placeholder {
    font-size: 80%;
    transform: translate3d(0, -90%, 0);
    opacity: 1;
}

</style>   
</head>

<body class="bg_gray ff_omfs">
    <div class="overflow-x-0">

<div class="row mt-3">
<div class="col-sm-12">
<div class="text-center fs_16 text_green ff_omfs">Medical Lien Management</div>
<div class="text-center fs_30 text_dark_black ff_omfs fw_5">User Registration Information</div>
<div class="title_underline bg_gradient ml-auto mr-auto mb-4 mb-lg-5 mt-2"></div>
</div>
</div>

        <div class="row">
            <div class="col-sm-12">

                <div class="calc_container bg-white w-lg-70">

                    <div class="row d-flex justify-content-center align-items-center">
                        <div class="col">
                            <div class="card card-registration my-4">
                                <div class="row g-0">
                                    <div class="col-lg-6 d-none d-lg-block">
                                        <img src="https://mdbcdn.b-cdn.net/img/Photos/new-templates/bootstrap-registration/img4.webp"
                                            alt="Sample photo" class="img-fluid"
                                            style="border-top-left-radius: .25rem; border-bottom-left-radius: .25rem;" />
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="card-body p-md-3 text-black">

                                            <form class="row floating_fields" method="POST" action={{ url('user/register-form') }}>
                                                @csrf

                                                
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>First Name</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="text" class="form-control" id="fName"
                                                            name="fname" placeholder="" value="{{ old('fname') }}" required>
                                                        <label for="fName" class="form-control-placeholder">Enter Your First Name</label>
                                                    </div>
                                                    @error('fname')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>


 
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Last Name</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="text" class="form-control" id="lName"
                                                            name="lname" placeholder="" value="{{ old('lname') }}" required>
                                                        <label for="lName" class="form-control-placeholder">Enter Your Last Name</label>
                                                    </div>
                                                    @error('lname')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>

                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Employee ID</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="text" class="form-control" id="employeeID"
                                                            name="employeeID" placeholder=""
                                                            value="{{ old('employeeID') }}" required>
                                                        <label for="employeeID" class="form-control-placeholder">Enter Your Employment ID</label>
                                                    </div>
                                                    @error('employeeID')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Email</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="email" class="form-control" id="userEmail"
                                                            name="email" placeholder="" value="{{ old('email') }}" required>
                                                        <label for="userEmail" class="form-control-placeholder">Your Email</label>
                                                    </div>
                                                    @error('email')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Password</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="password" class="form-control" id="password"
                                                            name="password" placeholder="" value="" required>
                                                        <label for="password" class="form-control-placeholder">Your Password</label>
                                                    </div>
                                                    @error('password')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Phone</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="text" class="form-control" id="phone"
                                                            name="phone" placeholder="" value="{{ old('phone') }}" required>
                                                        <label for="phone" class="form-control-placeholder">Enter Your Phone Number</label>
                                                    </div>
                                                    @error('phone')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Select Department</label>
                                                    <select class="simple_select mb-3 mt-2" name="department"
                                                        aria-label="Company Department">
                                                        <option value="" selected>None</option>
                                                        <option value="operations">Operations</option>
                                                        <option value="softwarehouse">Software House</option>
                                                        <option value="marketing">Marketing</option>
                                                    </select>
                                                    @error('department')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>
                                                <div class="form_label col-md-12 col-lg-6 col-sm-6">
                                                    <label>Job Title</label>
                                                    <div class="form-floating mb-3 mt-2">
                                                        <input type="text" class="form-control" id="jobTitle"
                                                            name="jobTitle" placeholder=""
                                                            value="{{ old('jobTitle') }}" required>
                                                        <label for="jobTitle" class="form-control-placeholder">Enter Your Job Title</label>
                                                    </div>
                                                    @error('jobTitle')
                                                        <span class="text-danger"> {{ $message }} </span>
                                                    @enderror
                                                </div>

                                                <div class="orm_button w-100 text-center mt-3">
                                                    <button type="reset" class="btn bg_gray fs_15 py-2 px-5 border-0  rounded-100">Reset</button>
                                                    <button type="submit" class="btn btn-primary fs_15 py-2 px-5 border-0  rounded-100 themeBtn1">Submit</button>
                                                </div>
                                            </form>
<div class="text-center">
<div class="titleSidesLine mt-3 mt-md-4 mt-lg-5 mb-lg-4">OR</div> 
<p class="text-center fs_15">Have already an account?</p>
<a href="{{url("user/login")}}" class="btn btn-outline-primary fs_15 py-2 px-5 w-50  rounded-100">Login</a>
</div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <script src="{{ asset('user/assets/js/jquery.slim.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('user/assets/js/bootstrap.min.js') }}"></script>

</body>

</html>
