<?php

namespace App\Helpers;

class GeneralHelper
{
    public static function mapBulkReportKeys($report)
    {
        return [
            'patient_id' => $report->patientregid,
            'Procedure Code' => $report->procedure_code . ($report->modifier ? ':' . $report->modifier : ''),
            'r_dos' => $report->dos,
            'Fee Schedule' => $report->fee_schedule,
            'Base Maximum Fee' => $report->base_max_fee,
            'Work RVU' => $report->work_rvu,
            'Facility RVU' => $report->facility_rvu,
            'Non Facility RVU' => $report->non_fac_rvu,
            'MP RVU' => $report->mp_rvu,
            'Work GPCI' => $report->work_gpci,
            'Facility PE GPCI' => $report->fac_pe_gpci,
            'Non Facility PE GPCI' => $report->non_fac_pe_gpci,
            'MP GPCI' => $report->mp_gpci,
            'r_place_of_service_type' => $report->service_type,
            "zip" => $report->zip,
            'convofactor' => $report->cf,
            'Conversion Factor Value' => $report->cf_val,
            'Fee Schedule Desc' => $report->fs_desc,
            'Description' => $report->desc,
            'Status Code' => $report->status_code,
            'Units' => $report->units,
            'Procedure' => $report->proc,
            'Effective Dates of Service' => $report->eff_dos,
            'r_provider_type' => $report->provider_type,
            'Payment Total' => $report->payment_tot,
            'Balance Due' => $report->balance,
            'MEU' => $report->meu,
            'max_unit_allowed' => $report->max_unit_allowed,
            'Prohibited Code' => $report->prohibited_code,
            'MPPR' => $report->mppr,
            'pctc_indicator' => $report->pctc_ind,
            'glob_days' => $report->glob_days,
            'pre_op' => $report->pre_op,
            'intra_op' => $report->intra_op,
            'post_op' => $report->post_op,
            'mult_proc' => $report->multi_proc,
            'bilat_surg' => $report->bilat_surg,
            'asst_surg' => $report->asst_surg,
            'co_surg' => $report->co_surg,
            'team_surg' => $report->team_surg,
            'endo_base' => $report->endo_base,
            'diagnostic_proc' => $report->diagnostic_proc,
            'diagnostic_family_ind' => $report->diagnostic_family_ind,
            'locality_name' => $report->locality_name,
            'locality_num' => $report->locality_num,
            'Calculation Explanation' => $report->cal_exp,
        ];
    }

    public static function mapCascadeReportKeys($report)
    {
        $groupedData = [];

        // Iterate over each report entry
        foreach ($report as $entry) {
            // Extract the patient_id from the current entry
            $patientId = $entry->patientregid;

            // Map the entry data to the desired structure
            $mappedEntry = self::mapBulkReportKeys($entry);

            // Group entries by patient_id
            if (!isset($groupedData[$patientId])) {
                $groupedData[$patientId] = [];
            }
            $groupedData[$patientId][] = $mappedEntry;
        }

        // Convert the grouped data array to the required format
        return array_values($groupedData);
    }
}
