<?php

namespace App\Console\Commands;

use App\Http\Controllers\Core\ClassUtils;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class Routines extends Command
{
    use ClassUtils;
    private const PATH = 'database/seeders/db/';
    private const DIRS = [
        'views',
        'routines',
    ];
    private const DEPENDENCIES = [
        'routines' => [
            'omfs_calc_new',
        ],
        'views' => [

        ],
    ];
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:routines {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seed DB views, procedures and functions';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (app()->environment('production')) {
            return 0;
        }
        if ($this->option('force')) {
            $this->info('Overwriting routines is enabled.');
        }
        if (!$this->option('force')) {

                $this->info('Skipping, nothing to migrate.');
                return 0;

        }
        foreach (self::DEPENDENCIES as $dep_dir => $_dependencies) {
            foreach ($_dependencies as $dep) {
                $queries = include base_path(self::PATH . $dep_dir . '/' . $dep . '.php');
                $this->info(sprintf('Writing %s/%s', $dep_dir, $dep));
                foreach ($queries as $query) {
                    DB::unprepared($query);
                }
            }
        }
        foreach (self::DIRS as $dir) {
            $files = scandir(base_path(self::PATH . $dir));
            foreach ($files as $file) {
                if (in_array($file, ['.', '..'])) {
                    continue;
                }
                if (in_array($file, self::DEPENDENCIES[$dir])) {
                    continue;
                }
                $queries = include base_path(self::PATH . $dir . '/' . $file);
                $this->info(sprintf('Writing %s/%s', $dir, $file));
                foreach ($queries as $query) {
                    DB::unprepared($query);
                }
            }
        }
        $this->info('All done');
        return 0;
    }
    public static function getLastModified()
    {
        $last_modified = 0;
        foreach (self::DIRS as $dir) {
            $files = scandir(base_path(self::PATH . $dir));
            foreach ($files as $file) {
                if (in_array($file, ['.', '..'])) {
                    continue;
                }
                $_lm = File::lastModified(self::PATH . $dir . '/' . $file);
                if ($_lm > $last_modified) {
                    $last_modified = $_lm;
                }
            }
        }
        return $last_modified;
    }
}
