CREATE TABLE `active_sessions` (
  `nonce` CHAR(128) NOT NULL,
  `user_id` BIGINT NOT NULL,
  `session_id` VARCHAR(100) NOT NULL,
  `is_mobile` BIT(1) NOT NULL DEFAULT 0,
  `ip_address` VARCHAR(20) NOT NULL,
  `browser` VARCHAR(50) NOT NULL,
  `platform` VARCHAR(50) NOT NULL,
  `last_active` DATETIME NOT NULL,
  PRIMARY KEY (`nonce`),
  INDEX `user` (`user_id` ASC),
  INDEX `session` (`session_id` ASC),
  INDEX `last_active` (`last_active` ASC))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;