ALTER TABLE `qz_form`
ADD COLUMN `record_purposes` BIT NOT NULL DEFAULT b'0' AFTER `autorelease-score`

CREATE OR REPLACE ALGORITHM=UNDEFINED SQL SECURITY INVOKER VIEW `google_quiz_detail` AS select `qz_form`.`id` AS `id`,`qz_form`.`form_id` AS `form_id`,`qz_form`.`label` AS `label`,`qz_form`.`title` AS `title`,`qz_form`.`description` AS `description`,`qz_form`.`link` AS `link`,`qz_form`.`due_date` AS `due_date`,`qz_form`.`passing_perc` AS `passing_perc`,`qz_form`.`added_at` AS `added_at`,`qz_form`.`modifiedTime` AS `modifiedTime`,`qz_form`.`record_purposes` AS `record_purposes`,if((`qz_form`.`autorelease-score` = 1),'yes','no') AS `autorelease-score`,(select sum(`qz_question`.`pointValue`) from `qz_question` where (`qz_question`.`form_id` = `qz_form`.`id`)) AS `totalScore` from `qz_form`;

ALTER TABLE `qz_rel_form_employee`
ADD COLUMN `form_employee_id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT FIRST,
ADD COLUMN `deletedAt` DATETIME NULL AFTER `submittedAt`,
ADD PRIMARY KEY (`form_employee_id`);
ADD INDEX `deletedAt` (`deletedAt` ASC);

ALTER TABLE `qz_employee_questions`
DROP COLUMN `employee_id`,
CHANGE COLUMN `form_id` `form_employee_id` BIGINT(20) UNSIGNED NOT NULL,
DROP INDEX `form_id`,
DROP INDEX `employee_id`,
ADD INDEX `form_employee_id` (`form_employee_id` ASC);

CREATE OR REPLACE ALGORITHM=UNDEFINED SQL SECURITY INVOKER VIEW `google_quiz_employee_details` AS select `qz_rel_form_employee`.`form_employee_id` AS `form_employee_id`,`qz_rel_form_employee`.`form_id` AS `form_id`,`qz_rel_form_employee`.`employee_id` AS `employee_id`,`qz_rel_form_employee`.`email` AS `email`,`qz_rel_form_employee`.`responseId` AS `responseId`,`qz_rel_form_employee`.`deletedAt` AS `deletedAt`,`google_quiz_detail`.`totalScore` AS `quizTotal`,`qz_rel_form_employee`.`totalScore` AS `totalScore`,`qz_rel_form_employee`.`submittedAt` AS `submittedAt`,`qz_rel_form_employee`.`resultSent` AS `resultSent`,`google_quiz_detail`.`title` AS `quiz_title`,`google_quiz_detail`.`autorelease-score` AS `autorelease-score`,`employee_details`.`hrm_id` AS `hrm_id`,`employee_details`.`full_name` AS `full_name`,`employee_details`.`pseudo` AS `pseudo`,`employee_details`.`business_email` AS `business_email`,`employee_details`.`direct_manager_email` AS `direct_manager_email`,`google_quiz_detail`.`passing_perc` AS `quiz_percentage`,((`qz_rel_form_employee`.`totalScore` / `google_quiz_detail`.`totalScore`) * 100) AS `obtained_percentage`,if(isnull(`qz_rel_form_employee`.`submittedAt`),'not-attempted',if((((`qz_rel_form_employee`.`totalScore` / `google_quiz_detail`.`totalScore`) * 100) >= `google_quiz_detail`.`passing_perc`),'passed','failed')) AS `status` from ((`qz_rel_form_employee` left join `employee_details` on((`qz_rel_form_employee`.`employee_id` = `employee_details`.`employee_id`))) left join `google_quiz_detail` on((`qz_rel_form_employee`.`form_id` = `google_quiz_detail`.`id`)));