ALTER TABLE `system_options` 
CHARACTER SET = utf8 , COLLATE = utf8_general_ci ,
CHANGE COLUMN `value` `value` LONGTEXT NOT NULL ;

DROP TABLE IF EXISTS `qz_email_queue`;
CREATE TABLE `qz_email_queue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `eto` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `status` enum('queued','failed','sent') NOT NULL DEFAULT 'queued',
  `retries` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `total_retries` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `error` text,
  `send_at` datetime NOT NULL,
  `added_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  KEY `status` (`status`),
  KEY `retries` (`retries`),
  KEY `send_at` (`send_at`),
  KEY `updated` (`updated_at`),
  KEY `added_at` (`added_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `qz_employee_answers`;
CREATE TABLE `qz_employee_answers` (
  `qid` bigint(20) unsigned NOT NULL,
  `answer` text NOT NULL,
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `qz_employee_questions`;
CREATE TABLE `qz_employee_questions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `question_id` varchar(155) NOT NULL,
  `isCorrect` bit(1) NOT NULL,
  `score` smallint(5) unsigned NOT NULL,
  `feedback` text,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `employee_id` (`employee_id`),
  KEY `isCorrect` (`isCorrect`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `qz_form`;
CREATE TABLE `qz_form` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `title` text NOT NULL,
  `description` longtext,
  `link` varchar(255) NOT NULL,
  `due_date` datetime NOT NULL,
  `passing_perc` tinyint(3) unsigned NOT NULL,
  `added_at` datetime NOT NULL,
  `autorelease-score` bit(1) NOT NULL DEFAULT b'1',
  `modifiedTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `due_date` (`due_date`),
  KEY `added_at` (`added_at`),
  KEY `modifiedTime` (`modifiedTime`),
  KEY `form_id` (`form_id`),
  KEY `autorelease-score` (`autorelease-score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `qz_question`;
CREATE TABLE `qz_question` (
  `form_id` bigint(20) unsigned NOT NULL,
  `question_id` varchar(155) NOT NULL,
  `title` text NOT NULL,
  `pointValue` smallint(5) unsigned NOT NULL,
  `added_at` datetime NOT NULL,
  KEY `form_id` (`form_id`),
  KEY `added_at` (`added_at`),
  KEY `question_id` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `qz_rel_form_employee`;
CREATE TABLE `qz_rel_form_employee` (
  `form_id` bigint(20) unsigned NOT NULL,
  `employee_id` bigint(20) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `responseId` varchar(255) DEFAULT NULL,
  `totalScore` smallint(5) unsigned NOT NULL DEFAULT '0',
  `resultSent` enum('held','queued','sent') NOT NULL DEFAULT 'held',
  `warningSent` bit(1) NOT NULL DEFAULT b'0',
  `submittedAt` datetime DEFAULT NULL,
  KEY `form_id` (`form_id`),
  KEY `employee_id` (`employee_id`),
  KEY `email` (`email`),
  KEY `responseId` (`responseId`),
  KEY `submittedAt` (`submittedAt`),
  KEY `resultSent` (`resultSent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE OR REPLACE ALGORITHM=UNDEFINED SQL SECURITY INVOKER VIEW `google_quiz_detail` AS select `qz_form`.`id` AS `id`,`qz_form`.`form_id` AS `form_id`,`qz_form`.`label` AS `label`,`qz_form`.`title` AS `title`,`qz_form`.`description` AS `description`,`qz_form`.`link` AS `link`,`qz_form`.`due_date` AS `due_date`,`qz_form`.`passing_perc` AS `passing_perc`,`qz_form`.`added_at` AS `added_at`,`qz_form`.`modifiedTime` AS `modifiedTime`,if((`qz_form`.`autorelease-score` = 1),'yes','no') AS `autorelease-score`,(select sum(`qz_question`.`pointValue`) from `qz_question` where (`qz_question`.`form_id` = `qz_form`.`id`)) AS `totalScore` from `qz_form`;
CREATE OR REPLACE ALGORITHM=UNDEFINED SQL SECURITY INVOKER VIEW `google_quiz_employee_details` AS select `qz_rel_form_employee`.`form_id` AS `form_id`,`qz_rel_form_employee`.`employee_id` AS `employee_id`,`qz_rel_form_employee`.`email` AS `email`,`qz_rel_form_employee`.`responseId` AS `responseId`,`google_quiz_detail`.`totalScore` AS `quizTotal`,`qz_rel_form_employee`.`totalScore` AS `totalScore`,`qz_rel_form_employee`.`submittedAt` AS `submittedAt`,`qz_rel_form_employee`.`resultSent` AS `resultSent`,`google_quiz_detail`.`title` AS `quiz_title`,`google_quiz_detail`.`autorelease-score` AS `autorelease-score`,`employee_details`.`hrm_id` AS `hrm_id`,`employee_details`.`full_name` AS `full_name`,`employee_details`.`pseudo` AS `pseudo`,`employee_details`.`business_email` AS `business_email`,`employee_details`.`direct_manager_email` AS `direct_manager_email`,`google_quiz_detail`.`passing_perc` AS `quiz_percentage`,((`qz_rel_form_employee`.`totalScore` / `google_quiz_detail`.`totalScore`) * 100) AS `obtained_percentage`,if(isnull(`qz_rel_form_employee`.`submittedAt`),'not-attempted',if((((`qz_rel_form_employee`.`totalScore` / `google_quiz_detail`.`totalScore`) * 100) >= `google_quiz_detail`.`passing_perc`),'passed','failed')) AS `status` from ((`qz_rel_form_employee` left join `employee_details` on((`qz_rel_form_employee`.`employee_id` = `employee_details`.`employee_id`))) left join `google_quiz_detail` on((`qz_rel_form_employee`.`form_id` = `google_quiz_detail`.`id`)));

BEGIN;
INSERT INTO `sec_menu_item` (`menu_id`, `menu_title`, `page_url`, `module`, `parent_menu`, `is_report`, `createby`, `createdate`, `active`) VALUES
(NULL, 'quiz_settings', 'quiz/settings', 'quiz', '0', '0', '2', '2022-06-22 00:00:00', '1'),
(NULL, 'create_quiz', 'quiz/create', 'quiz', '0', '0', '2', '2022-06-22 00:00:00', '1'),
(NULL, 'all_quiz', 'quiz/list', 'quiz', '0', '0', '2', '2022-06-22 00:00:00', '1'),
(NULL, 'open_quiz', 'quiz/list', 'quiz', '0', '0', '2', '2022-06-22 00:00:00', '1'),
(NULL, 'email_log', 'email/logs', 'quiz', '0', '0', '2', '2022-06-22 00:00:00', '1');
INSERT INTO `language` (`phrase`, `english`) VALUES
('quiz_settings', 'Settings'),
('create_quiz', 'Create Quiz'),
('compose_email', 'Compose Email'),
('email_account', 'Email Account'),
('preview_email', 'Preview Email'),
('email_preview', 'Email Preview'),
('schedule_email', 'Schedule Email'),
('all_quiz', 'All Quizzes'),
('due_date', 'Due Date'),
('passing_perc', 'Passing Percentage'),
('open_quiz', 'Open Quiz'),
('email_log', 'Email Logs');
COMMIT;