ALTER TABLE `attendance_history` 
CHARACTER SET = utf8 , COLLATE = utf8_general_ci ,
ADD COLUMN `state_type` ENUM('finger', 'face', 'password', 'card', 'hrm') NOT NULL DEFAULT 'hrm' AFTER `state`,
ADD INDEX `state_type` (`state_type` ASC);

ALTER TABLE `deviceinfo` 
ADD COLUMN `password` TEXT NOT NULL AFTER `port`;

CREATE OR REPLACE ALGORITHM=UNDEFINED SQL SECURITY INVOKER VIEW `attendance_view` AS select `attendance_history`.`group_no` AS `group_no`,`attendance_history`.`uid` AS `uid`,min(`attendance_history`.`day`) AS `day`,min(`attendance_history`.`punchin_time`) AS `punchin_time`,max(`attendance_history`.`punchout_time`) AS `punchout_time`,max(`attendance_history`.`duration`) AS `duration`,group_concat(distinct if((`attendance_history`.`punchin_time` is not null),`attendance_history`.`state_type`,NULL) separator ',') AS `state_type_in`,group_concat(distinct if((`attendance_history`.`punchout_time` is not null),`attendance_history`.`state_type`,NULL) separator ',') AS `state_type_out`,group_concat(`attendance_history`.`flag` separator ',') AS `flag`,group_concat(`attendance_history`.`remarks_in` separator ',') AS `remarks_in`,group_concat(`attendance_history`.`remarks_out` separator ',') AS `remarks_out` from `attendance_history` where (`attendance_history`.`active` = 1) group by `attendance_history`.`group_no`,`attendance_history`.`uid`;