<?php
/**
 * Remove below line before deploying HRM outside own organization
 */
define('INTERNAL_HRM', true);
if(file_exists('./.is-staging-server')) {
	define('STAGING_SERVER', true);
}
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2019, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (https://ellislab.com/)
 * @copyright	Copyright (c) 2014 - 2019, British Columbia Institute of Technology (https://bcit.ca/)
 * @license	https://opensource.org/licenses/MIT	MIT License
 * @link	https://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */

/*
 *---------------------------------------------------------------
 * APPLICATION ENVIRONMENT
 *---------------------------------------------------------------
 *
 * You can load different configurations depending on your
 * current environment. Setting the environment also influences
 * things like logging and error reporting.
 *
 * This can be set to anything, but default usage is:
 *
 *     development
 *     testing
 *     production
 *
 * NOTE: If you change these, also change the error_reporting() code below
 */
	//define('ENVIRONMENT', isset($_SERVER['CI_ENV']) ? $_SERVER['CI_ENV'] : 'production');

/*
 *---------------------------------------------------------------
 * ERROR REPORTING
 *---------------------------------------------------------------
 *
 * Different environments will require different levels of error reporting.
 * By default development will show errors but testing and live will hide them.
 */
define ('SERVER_NAME' ,  $_SERVER['SERVER_NAME'] );
switch ( SERVER_NAME )
{
	case 'localhost':
	case '127.0.0.1':
    	define('ENVIRONMENT', 'development');
   	break;

	case 'staging':
    	define('ENVIRONMENT', 'staging');
   	break;

   	case 'hrm.appedology.pk':
    	define('ENVIRONMENT', 'production');
   	break;

	case 'hrm.proglobaltechnologies.com':
    	define('ENVIRONMENT', 'production');
   	break;

	default:
    	define('ENVIRONMENT', 'development');
   	break;
}
switch (ENVIRONMENT)
{
	case 'development':
		error_reporting(-1);
		ini_set('display_errors', 1);
	break;

	case 'testing':
	case 'production':
		ini_set('display_errors', 0);
		if (version_compare(PHP_VERSION, '5.3', '>='))
		{
			error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
		}
		else
		{
			error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_USER_NOTICE);
		}
	break;

	default:
		header('HTTP/1.1 503 Service Unavailable.', TRUE, 503);
		echo 'The application environment is not set correctly.';
		exit(1); // EXIT_ERROR
}

/*
 *---------------------------------------------------------------
 * WRITEABLE DIRECTORY
 *---------------------------------------------------------------
 *
 * This variable must contain the name of your "write" directory.
 * Set the path if it is not in the same directory as this file.
 */
	$write_path = 'uploads';

/*
 *---------------------------------------------------------------
 * SYSTEM DIRECTORY NAME
 *---------------------------------------------------------------
 *
 * This variable must contain the name of your "system" directory.
 * Set the path if it is not in the same directory as this file.
 */
	$system_path = 'system';

/*
 *---------------------------------------------------------------
 * APPLICATION DIRECTORY NAME
 *---------------------------------------------------------------
 *
 * If you want this front controller to use a different "application"
 * directory than the default one you can set its name here. The directory
 * can also be renamed or relocated anywhere on your server. If you do,
 * use an absolute (full) server path.
 * For more info please see the user guide:
 *
 * https://codeigniter.com/user_guide/general/managing_apps.html
 *
 * NO TRAILING SLASH!
 */
	$application_folder = 'application';

/*
 *---------------------------------------------------------------
 * VIEW DIRECTORY NAME
 *---------------------------------------------------------------
 *
 * If you want to move the view directory out of the application
 * directory, set the path to it here. The directory can be renamed
 * and relocated anywhere on your server. If blank, it will default
 * to the standard location inside your application directory.
 * If you do move this, use an absolute (full) server path.
 *
 * NO TRAILING SLASH!
 */
	$view_folder = '';
	
	


/*
 * --------------------------------------------------------------------
 * DEFAULT CONTROLLER
 * --------------------------------------------------------------------
 *
 * Normally you will set your default controller in the routes.php file.
 * You can, however, force a custom routing by hard-coding a
 * specific controller class/function here. For most applications, you
 * WILL NOT set your routing here, but it's an option for those
 * special instances where you might want to override the standard
 * routing in a specific front controller that shares a common CI installation.
 *
 * IMPORTANT: If you set the routing here, NO OTHER controller will be
 * callable. In essence, this preference limits your application to ONE
 * specific controller. Leave the function name blank if you need
 * to call functions dynamically via the URI.
 *
 * Un-comment the $routing array below to use this feature
 */
	// The directory name, relative to the "controllers" directory.  Leave blank
	// if your controller is not in a sub-directory within the "controllers" one
	// $routing['directory'] = '';

	// The controller class file name.  Example:  mycontroller
	// $routing['controller'] = '';

	// The controller function you wish to be called.
	// $routing['function']	= '';


/*
 * -------------------------------------------------------------------
 *  CUSTOM CONFIG VALUES
 * -------------------------------------------------------------------
 *
 * The $assign_to_config array below will be passed dynamically to the
 * config class when initialized. This allows you to set custom config
 * items or override any default config values found in the config.php file.
 * This can be handy as it permits you to share one application between
 * multiple front controller files, with each file containing different
 * config values.
 *
 * Un-comment the $assign_to_config array below to use this feature
 */
	// $assign_to_config['name_of_config_item'] = 'value of config item';



// --------------------------------------------------------------------
// END OF USER CONFIGURABLE SETTINGS.  DO NOT EDIT BELOW THIS LINE
// --------------------------------------------------------------------

/*
 * ---------------------------------------------------------------
 *  Resolve the system path for increased reliability
 * ---------------------------------------------------------------
 */

	// Set the current directory correctly for CLI requests
	if (defined('STDIN'))
	{
		chdir(dirname(__FILE__));
	}

	if (($_temp = realpath($system_path)) !== FALSE)
	{
		$system_path = $_temp.DIRECTORY_SEPARATOR;
	}
	else
	{
		// Ensure there's a trailing slash
		$system_path = strtr(
			rtrim($system_path, '/\\'),
			'/\\',
			DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
		).DIRECTORY_SEPARATOR;
	}

	// Is the system path correct?
	if ( ! is_dir($system_path))
	{
		header('HTTP/1.1 503 Service Unavailable.', TRUE, 503);
		echo 'Your system folder path does not appear to be set correctly. Please open the following file and correct this: '.pathinfo(__FILE__, PATHINFO_BASENAME);
		exit(3); // EXIT_CONFIG
	}

/*
 * -------------------------------------------------------------------
 *  Now that we know the path, set the main path constants
 * -------------------------------------------------------------------
 */
	// The name of THIS file
	define('SELF', pathinfo(__FILE__, PATHINFO_BASENAME));

	// Path to the system directory
	define('BASEPATH', $system_path);

	// Path to the front controller (this file) directory
	define('FCPATH', dirname(__FILE__).DIRECTORY_SEPARATOR);

	// Name of the "system" directory
	define('SYSDIR', basename(BASEPATH));

	// The path to the "application" directory
	if (is_dir($application_folder))
	{
		if (($_temp = realpath($application_folder)) !== FALSE)
		{
			$application_folder = $_temp;
		}
		else
		{
			$application_folder = strtr(
				rtrim($application_folder, '/\\'),
				'/\\',
				DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
			);
		}
	}
	elseif (is_dir(BASEPATH.$application_folder.DIRECTORY_SEPARATOR))
	{
		$application_folder = BASEPATH.strtr(
			trim($application_folder, '/\\'),
			'/\\',
			DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
		);
	}
	else
	{
		header('HTTP/1.1 503 Service Unavailable.', TRUE, 503);
		echo 'Your application folder path does not appear to be set correctly. Please open the following file and correct this: '.SELF;
		exit(3); // EXIT_CONFIG
	}

	define('APPPATH', $application_folder.DIRECTORY_SEPARATOR);

	// The path to the "views" directory
	if ( ! isset($view_folder[0]) && is_dir(APPPATH.'views'.DIRECTORY_SEPARATOR))
	{
		$view_folder = APPPATH.'views';
	}
	elseif (is_dir($view_folder))
	{
		if (($_temp = realpath($view_folder)) !== FALSE)
		{
			$view_folder = $_temp;
		}
		else
		{
			$view_folder = strtr(
				rtrim($view_folder, '/\\'),
				'/\\',
				DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
			);
		}
	}
	elseif (is_dir(APPPATH.$view_folder.DIRECTORY_SEPARATOR))
	{
		$view_folder = APPPATH.strtr(
			trim($view_folder, '/\\'),
			'/\\',
			DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
		);
	}
	else
	{
		header('HTTP/1.1 503 Service Unavailable.', TRUE, 503);
		echo 'Your view folder path does not appear to be set correctly. Please open the following file and correct this: '.SELF;
		exit(3); // EXIT_CONFIG
	}

	define('VIEWPATH', $view_folder.DIRECTORY_SEPARATOR);

	define('WRITEPATH', FCPATH . rtrim($write_path, '/\\') . DIRECTORY_SEPARATOR);

/*
 * --------------------------------------------------------------------
 * LOAD THE BOOTSTRAP FILE
 * --------------------------------------------------------------------
 *
 * And away we go...
 */
 /*******
----------------------------
Check Database Connection
----------------------------
*********/
include('application/config/database.php');
$mysqli = new mysqli($db['default']['hostname'],$db['default']['username'],$db['default']['password'],$db['default']['database']);

// Check connection
if ($mysqli->connect_errno) {
	$timestamp = date('Y-m-d H:i:s');
	@file_put_contents(APPPATH . 'logs/php/log-' . date('Y-m-d') . '.log', "ERROR - {$timestamp} --> {$mysqli->connect_errno}: {$mysqli->connect_error}\n", FILE_APPEND);
	unset($timestamp);
	if(file_exists(FCPATH . 'flags/.installed')) {
		http_response_code(503);
		echo base64_decode('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');
	} else {
		$https = false;
		if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
			$protocol = 'https://';
		} else {
			$protocol = 'http://';
		}
		$dirname = rtrim(dirname($_SERVER['PHP_SELF']), '/\\').'/';
		if(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] != 'off') $https = true;
		$installerurl=$protocol.$_SERVER['HTTP_HOST'].$dirname;
		header('Location: '.$installerurl.'install');
	}
	exit;
}
$mysqli->close();
unset($mysqli);

require_once BASEPATH.'core/CodeIgniter.php';
